//
//     CLASE   frmVs       
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Converierte ficheros X3D a H3D y viceversa.
*/

//---------------------------------------------------------------------------

#ifndef frmVs_H
#define frmVs_H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <Grids.hpp>
#include <Graphics.hpp>
#include "frmEscena_.h"
//---------------------------------------------------------------------------
class TfrmVs : public TForm
{
__published:	// IDE-managed Components
        TPanel *PanelGrid;
        TStringGrid *Grid;
        TStringGrid *GridTitulos;
        TPanel *pnlElementos;
        TPanel *pnlComentarios;
        TPanel *pnlAcciones;
        TPanel *pnlIndicadores;
        TPanel *pnlBotones;
        TSpeedButton *sbAyuda;
        TSpeedButton *sbAceptar;
        TSpeedButton *sbCancelar;
        TPanel *pnlResultado;
        TPanel *pnlConversion;
        TPanel *pnlTitulo;
        TLabel *lbTitulo;
        TImage *imgOk;
        TImage *imgWarning;
        TImage *imgStop;
        TPanel *pnlH3D;
        TSpeedButton *sbH3D;
        TImage *imgFlecha;
        TPanel *pnlX3D;
        TSpeedButton *sbX3D;
        TPanel *pnlWarning;
        TSpeedButton *sbWarning;
        TPanel *pnlStop;
        TSpeedButton *sbStop;
        TPanel *pnlOk;
        TSpeedButton *sbOk;
        TGroupBox *gbNodos;
        TLabel *lbTotalNodos;
        TLabel *lbNumNodos;
        TLabel *lbBorradosNodos;
        TLabel *lbNodosBorrados;
        TLabel *lbCompatiblesNodos;
        TLabel *lbNodosComp;
        TGroupBox *gbCampos;
        TGroupBox *gbRutado;
        TGroupBox *gbPorcentaje;
        TGroupBox *gbResultados;
        TLabel *lbTotalCampos;
        TLabel *lbBorradosCampos;
        TLabel *lbCompatiblesCampos;
        TLabel *lbCamposComp;
        TLabel *lbCamposBorrados;
        TLabel *lbNumCampos;
        TLabel *lbTotalRutado;
        TLabel *lbBorradosRutado;
        TLabel *lbCompatiblesRutado;
        TLabel *lbRutadosComp;
        TLabel *lbRutadosBorrados;
        TLabel *lbNumRutados;
        TLabel *lbPorcentajeNodos;
        TLabel *lbPorcentajeCapos;
        TLabel *lbPorcentajeRutados;
        TLabel *lbRutadosPorc;
        TLabel *lbCamposPorc;
        TLabel *lbNodosPorc;
        TLabel *lbResultadosErrores;
        TLabel *lbResultadosAdvertencia;
        TLabel *lbResultadosCompatibles;
        TLabel *lbCompatibles;
        TLabel *lbAdvertencias;
        TLabel *lbErrores;
        void __fastcall sbCancelarClick(TObject *Sender);
        void __fastcall sbAceptarClick(TObject *Sender);
        void __fastcall FormPaint(TObject *Sender);
        void __fastcall GridDrawCell(TObject *Sender, int ACol, int ARow,
          TRect &Rect, TGridDrawState State);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall sbAyudaClick(TObject *Sender);
        void __fastcall FormCreate(TObject *Sender);
private:	// User declarations
        // Se usa para que la funcin Inicio comunique al evento onShow que
        // es la primera vez que se muestra la ventana para as iniciar la
        // conversin de la escena.
        bool Inicio;

        // Las funciones que convierten la escena pueden trabajar en dos modos
        // Crear el informe sin hacer la conversin (solo genera la informacin)
        // o puede hacer la conversin del fichero, con esta variable se informa
        // a estas funciones de este hecho. (no se pasa como parmetro a las
        // funciones porque son funciones recursivas).
        bool CreandoInforme;

        // Punteros a los gestores de nodos de la escena actual (1) y de la
        // escena a la que vamos a convertir el fichero (2).
        GestorNodos *GN1;
        GestorNodos *GN2;

        // Guarda los nodos DEFs compatibles de la escena para convertir los
        // vnculos de rutado. Se usarn los punteros que contienen para
        // apuntar a elementos NodoArbol.
        TStringList *NodosDEF;

        // Estas variables valdrn "X3D" o "H3D". Tipo1 ser el tipo de la
        // escena actual, y Tipo2 ser el tipo de la escena que se traducir.
        AnsiString Tipo1;
        AnsiString Tipo2;

        // Las siguientes variables se usan para rellenar los indicadores de
        // informacin sobre la conversin:
        int NumNodos,NumCampos,NumRutados;
        int NumNodosComp,NumCamposComp,NumRutadosComp;

        // Inicia la conversin del fichero. Esta funcin altera siempre el
        // contenido del arbol de frmEscena. Cuando el usuario salga con cancelar
        // se devolver false y habr que restaurar el contenido anterior de la
        // escena externamente. Si devuelve true habr que dibujar de nuevo el
        // arbol de frmEscena para que los cambios tengan efecto y adems habra
        // que cambiar el tipo de escena.
        void __fastcall IniciaConversion();

        // Es una funcin recursiva que recorre el arbol de frmEscena y
        // convierte todos los elementos incompatibles mostrando en Grid
        // informacin sobre cada elemento.
        // n es el elemento a procesar:
        void __fastcall ProcesadoRecursivo(NodoArbol *n);

        // Aade una nueva fila a grid con las cadenas cad1 a cad4 como columnas.
        // Solo hace algo si CreandoInforme es true.
        void __fastcall AnadirFila(AnsiString cad1,AnsiString cad2,
                                   AnsiString cad3,AnsiString cad4);

        // Borra los datos que contenga el campo. Si es un campo simple har que
        // valor sea "". Y si se un campo SFNode o MFNode borrar todos sus hijos:
        // Solo borra los hijos cuando CreandoInforme es false, aunque en cualquier
        // caso cuenta el nmero de elementos que se borraran, incrementando:
        // NodosBorrados, CamposBorrados, RutadosBorrados.
        void __fastcall EliminarDatosCampo(NodoArbol *campo);

        // Cuenta el nmero de elementos nodo, campos y rutado que haya dentro
        // de n. Los tres valores enteros deben inicializarse desde el exterior.
        // (Es una funcin recursiva).
        void __fastcall CuentaElementos(NodoArbol *n,int &nodos,int &campos, int &rutados);

public:		// User declarations

        // Inicia la conversin de ficheros. Devuelve true si el usuario ha
        // decidido convertir la escena. Esta funcin puede borrar elementos del
        // rbol de frmEscena para hacer las escenas compatibles.
        bool __fastcall Inicia();


        __fastcall TfrmVs(TComponent* Owner);
        __fastcall ~TfrmVs();
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmVs *frmVs;
//---------------------------------------------------------------------------
#endif
