//
//     CLASE   frmVs       
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Converierte ficheros X3D a H3D y viceversa.
*/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "frmVs_.h"
#include "Main_.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmVs *frmVs;
//---------------------------------------------------------------------------
__fastcall TfrmVs::TfrmVs(TComponent* Owner)
        : TForm(Owner)
{
   Inicio = false;
   NumNodos = 0;
   NumCampos = 0;
   NumRutados = 0;
   NumNodosComp = 0;
   NumCamposComp = 0;
   NumRutadosComp = 0;

   CreandoInforme=true;

   try{ NodosDEF = new TStringList();}
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }
   // Queremos que los elementos se guarden por orden de insercin:
   NodosDEF->Sorted = false;

   GN1=NULL;
   GN2=NULL;
}
//---------------------------------------------------------------------------
__fastcall TfrmVs::~TfrmVs(){
   delete NodosDEF;
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::sbCancelarClick(TObject *Sender)
{
   ModalResult = mrCancel;
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::sbAceptarClick(TObject *Sender)
{
   ModalResult = mrOk;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmVs::Inicia(){

   if(frmEscena->Raiz == NULL)
      return false;

   // Usamos como Caption: Main->Caption
   Caption = Main->Caption;

   // Indicamos a FormPaint que se ha iniciado la ventana.
   Inicio = true;

   // Al mostrar la ventana creamos el informe de la conversin:
   CreandoInforme=true;

   // Actualizamos los indicadores del tipo de conversin:
   // Y asignamos los punteros a los gestores de nodos GN1 y GN2.
   {
      int mayor = (pnlH3D->Left > pnlX3D->Left) ? pnlH3D->Left : pnlX3D->Left;
      int menor = (pnlH3D->Left < pnlX3D->Left) ? pnlH3D->Left : pnlX3D->Left;

      if(frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_X3D){
         pnlH3D->Left = mayor;
         pnlX3D->Left = menor;
         GN1=Main->GNX;
         GN2=Main->GNH;
         Tipo1="X3D";
         Tipo2="H3D";
      }else{
         pnlH3D->Left = menor;
         pnlX3D->Left = mayor;
         GN1=Main->GNH;
         GN2=Main->GNX;
         Tipo1="H3D";
         Tipo2="X3D";
      }
      if( (GN2 == NULL) || (GN1 == NULL) )
         return false;
   }
   pnlOk  ->Visible = false;
   pnlStop->Visible = false;
   pnlWarning->Visible = false;

   if(mrOk == ShowModal()){
     CreandoInforme=false;
      IniciaConversion();
      return true;
   }

   return false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::FormPaint(TObject *Sender){
   if(Inicio){
      Inicio = false;
      IniciaConversion();
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::IniciaConversion(){

   // Lo primero es usar como cursor para el ratn el reloj de espera porque
   // el procesado puede llevar cierto tiempo:
   Screen->Cursor=PUNT_RATON_ESPERA;

   // Inicializamos los indicadores:
   lbNumNodos->Caption = "";
   lbNumCampos->Caption = "";
   lbNumRutados->Caption = "";
   lbNodosComp->Caption = "";
   lbCamposComp->Caption = "";
   lbRutadosComp->Caption = "";
   lbNodosBorrados->Caption = "";
   lbCamposBorrados->Caption = "";
   lbRutadosBorrados->Caption = "";
   lbNodosPorc->Caption = "";
   lbCamposPorc->Caption = "";
   lbRutadosPorc->Caption = "";
   lbErrores->Caption = "";
   lbAdvertencias->Caption = "";
   lbCompatibles->Caption = "";

   NumNodos = 0;
   NumCampos = 0;
   NumRutados = 0;
   NumNodosComp = 0;
   NumCamposComp = 0;
   NumRutadosComp = 0;

   CuentaElementos(frmEscena->Raiz,NumNodos,NumCampos,NumRutados);

   // Actualizamos el contenido de los indicadores:
   lbNumNodos->Caption   = NumNodos;
   lbNumCampos->Caption  = NumCampos;
   lbNumRutados->Caption = NumRutados;

   // Inicializamos el grid:
   Grid->RowCount = 1;
   Grid->Cells[0][0] = "";
   Grid->Cells[1][0] = "";
   Grid->Cells[2][0] = "";
   Grid->Cells[3][0] = "";

   // Actualizamos la apariencia.
   Repaint();

   // Si la escena est vaca volvemos:
   if( (NumNodos == 0) && (NumCampos == 0) && (NumRutados == 0) ){
      Utilidad.MsgInfo("The scene doesn't contain nodes.");
      sbCancelarClick(NULL);
      return;
   }

   // Limpiamos la lista de nodos DEF.
   NodosDEF->Clear();

   // Iniciamos el procesado:
   ProcesadoRecursivo(frmEscena->Raiz);

   // Actualizamos los indicadores si estamos haciendo el informe:
   if(CreandoInforme){
      lbNodosComp->Caption = NumNodosComp;
      lbCamposComp->Caption = NumCamposComp;
      lbRutadosComp->Caption = NumRutadosComp;
      lbNodosBorrados->Caption = NumNodos-NumNodosComp;
      lbCamposBorrados->Caption = NumCampos - NumCamposComp;
      lbRutadosBorrados->Caption = NumRutados - NumRutadosComp;
      if(NumNodos > 0)
         lbNodosPorc->Caption = (AnsiString)((100 * NumNodosComp) / NumNodos) + "%" ;
      else
         lbNodosPorc->Caption = "-";
      if(NumCampos > 0)
         lbCamposPorc->Caption = (AnsiString)((100 * NumCamposComp) / NumCampos) + "%" ;
      else
         lbCamposPorc->Caption = "-";
      if(NumRutados > 0)
         lbRutadosPorc->Caption = (AnsiString)((100 * NumRutadosComp) / NumRutados) + "%" ;
      else
         lbRutadosPorc->Caption = "-";

      // Gestionamos los paneles: OK, Warnings, Errores
      int e=0;
      int w=0;
      int o=0;
      for(int c=0; c < Grid->RowCount; c++){
         if(Grid->Cells[3][c] == "Error")
            e++;
         else if(Grid->Cells[3][c] == "Warning")
            w++;
         else if(Grid->Cells[3][c] == "OK")
            o++;
         else{
            // Avisamos del error.
            Beep();
            Sleep(300);
         }
      }
      lbErrores->Caption = e;
      lbAdvertencias->Caption = w;
      lbCompatibles->Caption = o;

      pnlStop->Visible=false;
      pnlWarning->Visible=false;
      pnlOk->Visible=false;
      if(e != 0)
         pnlStop->Visible=true;
      else if(w != 0)
         pnlWarning->Visible=true;
      else
         pnlOk->Visible=true;
   }



   // Restauramos el puntero del ratn.
   Screen->Cursor=PUNT_RATON_NORMAL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::CuentaElementos(NodoArbol *n,int &nodos,int &campos, int &rutados){

   if(n == NULL)
      return;

   // Tenemos que considerar cada tipo de elemento:
   if(n->EsRaiz()){
      // Tenemos que procesar los hijos que tenga la raiz:
      for(int c=0; c <= n->hijos->MaxIndexUsado(); c++){
         if(n->hijos->Get(c) != NULL)
            CuentaElementos((NodoArbol *)n->hijos->Get(c),nodos,campos,rutados);
      }
   }else if(n->EsNodo()){
      nodos++;
      for(int c=0; c <= n->hijos->MaxIndexUsado(); c++)
         CuentaElementos((NodoArbol *)n->hijos->Get(c),nodos,campos,rutados);

   }else if(n->EsCampo()){
      campos++;
      if( !n->EsCampoEvento() && ( (n->AsCampo()->tipoCampo == SFNODE) ||
                                   (n->AsCampo()->tipoCampo == MFNODE) ) ){

         for(int c=0; c <= n->hijos->MaxIndexUsado(); c++)
            CuentaElementos((NodoArbol *)n->hijos->Get(c),nodos,campos,rutados);
      }
   }else if(n->EsRutado()){
      rutados++;
   }// else {} en otro caso (otro tipo de elementos no hacemos nada).
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::EliminarDatosCampo(NodoArbol *campo){

   if( (campo == NULL) || !campo->EsCampo() )
       return;

   if( campo->AsCampo()->tipoCampo == SIMPLE ){
      // Solo hay que poner a "" valor:
      if(!CreandoInforme)
         campo->AsCampo()->valor = "";

   }else{// Tenemos un campo SFNode o MFNode:
      for(int c=0; c <= campo->hijos->MaxIndexUsado(); c++){
         if(NULL != campo->hijos->Get(c)){

            // En cualquier caso contamos el nmero de elementos borrados:
            CuentaElementos((NodoArbol *)campo->hijos->Get(c),NumNodos,NumCampos,NumRutados);

            // Si no estamos creando el informe borraremos los hijos.
            if(!CreandoInforme)
               frmEscena->EliminarNodo((NodoArbol *)campo->hijos->Get(c));
         }
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::AnadirFila(AnsiString cad1,AnsiString cad2,AnsiString cad3,AnsiString cad4){

   if(!CreandoInforme)
      return;

   int fila;
   if( (Grid->RowCount == 1) && (Grid->Cells[0][0] == "") ){
      fila = 0;
   }else{
      Grid->RowCount++;
      fila = Grid->RowCount-1;
   }
   Grid->Cells[0][fila] = cad1;
   Grid->Cells[1][fila] = cad2;
   Grid->Cells[2][fila] = cad3;
   Grid->Cells[3][fila] = cad4;
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::ProcesadoRecursivo(NodoArbol *n){

   if(n == NULL)
      return;

   // Tenemos que considerar cada tipo de elementos:
   if(n->EsRaiz()){  // RAIZ 
      // En este caso no tenemos que aadir nada a Grid, solo procesar el resto
      // de elementos con llamadas recursivas:
      for(int c=0; c <= n->hijos->MaxIndexUsado(); c++){
         if(n->hijos->Get(c) != NULL)
            ProcesadoRecursivo((NodoArbol *)n->hijos->Get(c));
      }

   }else if(n->EsNodo()){ // NODO 
      // En este caso tenemos que ver si este nodo existe en el otro gestor
      // Si no existe tenemos que borrar este nodo (y todos sus hijos).
      // Si existe tendremos que procesar todos sus campos:
      if(NULL == GN2->DatosNodo(n->AsNodo()->nombre) ){
         // En este caso n no existe en el otro gestor-> Hay que borrar
         // este nodo.
         AnadirFila( (AnsiString)"Node:" + n->AsNodo()->nombre + " " + n->AsNodo()->nombreDado,
                     (AnsiString)"doesn't exist in " + Tipo2 + " scenes",
                     "Delete node","Error");

         if(!CreandoInforme){
            // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         }

      }else{
         AnadirFila( (AnsiString)"Node:" + n->AsNodo()->nombre + " " + n->AsNodo()->nombreDado,
                     (AnsiString)"Exists in " + Tipo2 + " scenes","","OK");

         NumNodosComp++;

         // Antes de procesar los campos del nodo vamos a aadir el nodo a la
         // lista de nodos DEF:
         {
            AnsiString nombreDado = n->AsNodo()->nombreDado.Trim();
            if(nombreDado != ""){
               // En este caso tenemos un nodo DEF.
               if(-1 == NodosDEF->IndexOf(nombreDado) ){
                  // El nodo tiene un identificador nico (nombreDado)
               }else{
                  // El nodo NO tiene un identificador nico (nombreDado)
                  // Avisamos con un Warning
                  AnadirFila( (AnsiString)"Node:" + n->AsNodo()->nombre + " " + nombreDado,
                              nombreDado + "->Duplicated identifier.","","Warning");
               }
               // Aadimos el nodo a la lista:
               NodosDEF->Append(nombreDado);
               NodosDEF->Objects[NodosDEF->Count-1] = (TObject *)n;
            }
         }

         // Procesamos los hijos del nodo actual:
         for(int c=0; c <= n->hijos->MaxIndexUsado(); c++){
            if(n->hijos->Get(c) != NULL)
               ProcesadoRecursivo((NodoArbol *)n->hijos->Get(c));
         }
      }

   }else if(n->EsCampo()){// CAMPO 

      // Hay que distinguir varios casos -> Si el nodo es un evento, si es
      // SIMPLE, SFNODE o MFNODE. Hay que tener en cuenta el nombre del tipo,
      // y el tipo de rutado.
      // (A)Que criterio seguiremos para decidir si un campo es vlido o no?
      // (B)Que haremos cuando un campo no sea vlido?
      // Para cada campo tenemos que tomar una de estas tres decisiones:
      // Error, OK y Warning.
      // (C) que haremos en cada caso? :
      // Caso campo OK: No hay que hacer nada.
      // Caso campo Error: Si es un evento -> nada,
      //                   Si es SFNode o MFNode -> borramos todos sus hijos
      //                   Si es un campo SIMPLE podremos sus datos a "" para que no se escriban.
      // Caso campo Warnning: No haremos nada:
      // Cmo decidimos en qu caso estamos?:
      //
      // 1) Si tenemos un campo vaco: Campo OK y volvemos. Siendo un campo
      //    vacio, un campo que no tenga datos -> Es decir un evento o un campo
      //    tipo SIMPLE que tenga como dato "" o su valor por defecto o bien,
      //    un campo SFNode o MFNode que no tenga ningn hijo.
      //
      // 2) Ver si en el nodo correspondiente de GN2 tenemos un campo
      // del mismo nombre (ya sabemos que el nodo existe en GN1 y en GN2). Si no
      // lo tenemos lo consideraremos <campo Error> y acabamos.
      //
      // 3) Comprobamos el tipo de rutado del campo:
      //                   Si es un evento -> ya se comprob en 1
      //                   Si es un campo Field o ExposedField sabemos que sus
      //                     datos no no son "" ni el valor por defecto pq ya se
      //                     comprob en 1 as que:
      //                       Si el campo2 es Field o ExposedField -> continuamos con las comprobaciones.
      //                       Si el campo2 es un evento -> CampoError -> ponemos su dato a "" y teminamos
      //
      // 4) Comparamos el tipo de Campo SIMPLE, SFNODE, o MFNODE. Si son iguales
      // continuamos las comprobaciones. Si no lo son:
      // CASO campo SIMPLE: -> Error y ponemos a "" el dato.
      // CASO SFNODE y MFNODE: -> Si tienen algn hijo -> Error -> Borramos los hijos.

      // 5) Comprobamos los nombres de los tipos:
      //                    Si son iguales -> no hacemos nada
      //                    Si son distintos -> Warnings

      // A continuacin implementamos todas estas reglas:

      //       
      //   PASO  1 
      //       
      // 1) Si tenemos un campo vaco: Campo OK y volvemos. Siendo un campo
      //    vacio, un campo que no tenga datos -> Es decir un evento o un campo
      //    tipo SIMPLE que tenga como dato "" o su valor por defecto o bien,
      //    un campo SFNode o MFNode que no tenga ningn hijo.

      if(n->AsCampo()->tipoCampo == SIMPLE){

         if(n->AsCampo()->valor.Trim() == ""){
            AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,"Is empty","","OK");
            NumCamposComp++;
            return;

         }else if(n->AsCampo()->valor == n->AsCampo()->datosCampo->valorPorDefecto){
            AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,"Contains the default value","","OK");
            NumCamposComp++;
            return;
         }

      }else { //( (n->AsCampo()->tipoCampo == SFNODE) || (n->AsCampo()->tipoCampo == MFNODE) ){
         // Vemos cuantos hijos tienen:
         if( n->hijos->NumElementosNoNulos() == 0 ){
            AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,"Is empty","","OK");
            NumCamposComp++;
            return;
         }
      }

      //       
      //   PASO  2 
      //       
      // 2) Ver si en el nodo correspondiente de GN2 tenemos un campo
      // del mismo nombre (ya sabemos que el nodo existe en GN1 y en GN2). Si no
      // lo tenemos lo consideraremos <campo Error> y acabamos.
      Campo *campo2=NULL;
      if( n->padre->EsNodo() ){
         Nodo *padre2 = GN2->DatosNodo(n->padre->AsNodo()->nombre);
         if( NULL != padre2){
            // Ahora tenemos que buscar entre los hijos del padre un campo que tenga
            // el mismo nombre que n->AsCampo()->nombre:
            bool encontrado = false;
            for(int c=0; c < padre2->numCampos; c++){
               if( (padre2->campos[c] != NULL) && (padre2->campos[c]->nombre == n->AsCampo()->nombre) ){
                  encontrado =true;
                  campo2 = padre2->campos[c];
                  break;
               }
            }
            if(!encontrado){
               AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,(AnsiString)"Doesn't exist as " + Tipo2 + " field","Delete its value","Error");
               EliminarDatosCampo(n);
               return;
            }// else {} En este caso no hay que hacer nada --> Seguimos con las comprobaciones.

         }else{
            // Nunca debera producirse este caso porque ya se ha comprobado el padre.
            AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,(AnsiString)"Doesn't exist as " + Tipo2 + " field","","Error" );
            EliminarDatosCampo(n);
            return;
         }
      }else{
         AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,"field without father","","Error" );
         EliminarDatosCampo(n);
         return;
      }

      //       
      //   PASO  3 
      //       
      // 3) Comprobamos el tipo de rutado del campo:
      //                   Si es un evento -> ya se comprob en 1
      //                   Si es un campo Field o ExposedField sabemos que sus
      //                     datos no no son "" ni el valor por defecto pq ya se
      //                     comprob en 1 as que:
      //                       Si el campo2 es Field o ExposedField -> continuamos con las comprobaciones.
      //                       Si el campo2 es un evento -> CampoError -> ponemos su dato a "" y teminamos

      if( (campo2->rutado != FIELD) && (campo2->rutado != EXPOSEDFIELD) ){
         // En este caso campo2 es un evento y entonces no ser compatible con
         // campo1, tenemos que borrar sus datos.
         AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,(AnsiString)"The associated " + Tipo2 + " field is an event","Delete its value","Error");
         EliminarDatosCampo(n);
         return;
      }

      //       
      //   PASO  4 
      //       
      // 4) Comparamos el tipo de Campo SIMPLE, SFNODE, o MFNODE. Si son iguales
      // continuamos las comprobaciones. Si no lo son:
      // CASO campo SIMPLE: -> Error y ponemos a "" el dato.
      // CASO SFNODE y MFNODE: -> Si tienen algn hijo -> Error -> Borramos los hijos.
      if( n->AsCampo()->datosCampo->tipo->numHijos != campo2->tipo->numHijos ){
         AnsiString c1,c2;
         switch (n->AsCampo()->datosCampo->tipo->numHijos){
           case 0: c1 = "Normal"; break;
           case 1: c1 = "SFNode"; break;
           case 2: c1 = "MFNode";
         }
         switch (campo2->tipo->numHijos){
           case 0: c2 = "Normal"; break;
           case 1: c2 = "SFNode"; break;
           case 2: c2 = "MFNode";
         }

         AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,
                     (AnsiString)"Is " + c1 + " and its associated " + Tipo2 + " field is " + c2,"Delete its value","Error");

         EliminarDatosCampo(n);
         return;
      }

      //       
      //   PASO  5 
      //       
      // 5) Comprobamos los nombres de los tipos:
      //                    Si son iguales -> no hacemos nada
      //                    Si son distintos -> Warnings
      if( n->AsCampo()->datosCampo->tipo->nombre != campo2->tipo->nombre ){
         AnsiString c1 = n->AsCampo()->datosCampo->tipo->nombre;
         AnsiString c2 = campo2->tipo->nombre;
         AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,(AnsiString)"Diferent types " + c1 + " Vs " + c2 ,"","Warning");
         // Tengo que considerar el campo como compatible porque de lo contrario
         // aparecera en la estadstica como campo borrado:
         NumCamposComp++;
         return;
      }

      // En este caso el campo es 100% compatible:
      AnadirFila( (AnsiString)"Field:" + n->AsCampo()->nombre,"Is compatible with its associated " + Tipo2 + " field","","OK");
      NumCamposComp++;

      // Tenemos que procesar todos sus hijos (si los tiene):
      for(int c=0; c <= n->hijos->MaxIndexUsado(); c++){
         if(n->hijos->Get(c) != NULL)
            ProcesadoRecursivo((NodoArbol *)n->hijos->Get(c));
      }

   }else if(n->EsRutado()){// RUTADO 

      /* En scripts python no se usan NUNCA prefijos ni sufijos con los nombres
      de los campos para crear vnculos de Rutado. En cambio en X3D Si se usan
      estos prefijos con los campos de tipo EXPOSEDFIELD. Tendremos que tener
      esto en cuenta para hacer la conversin.

         Los pasos a seguir son:

      PASO1: Comprobar que existen los dos DEF del vnculo.
             Si no existen -> Error y volvemos.
             Hay que hacerlo considarando solo los nodos que no se han borrado.
      PASO2: Comprobar que los dos nodos exiten en GN2. Si no -> Error y volvemos.
      PASO3: Obtener el nombre de los dos campos (si es necesario quitando los
             prefijos y sufijos).
      PASO4: Comprobar que exiten los mismos campos en los nodos
             del GN2-> Si no Error y volvemos.
      PASO5: Comprobar que los campos de igual nombre del GN2 son compatibles
             respecto al tipo de rutado:
               * Para el campo del evento de salida del vinculo de Rurado (GN1) tendremos
               que tener un campo en el GN2 de tipo ExposedField o EventOut.
               * Para el campo del evento de entrada del vinculo de Rurado (GN1) tendremos
               que tener un campo en el GN2 de tipo ExposedField o EventIn.
             Si no se cumple esto -> Error y volvemos.
      PASO6: Comprobar los tipos de los campos rutados. Si no coinciden warning pero
             no volvemos.
      PASO7: En este caso los campos son 100% compatibles solo habra que adaptar
             los nombres. Para los campos X3D de tipo ExposedField habr que:
                Aadir prefijos y sufijos si estamos en: H3D -> X3D
                Borrar prefijos y sufijos si estamos en: X3D -> H3D   */
      //--------------------------------------------------------------------------
      AnsiString rutado = n->AsRutado()->nodoOut + "." + n->AsRutado()->campoOut + " TO " +
                          n->AsRutado()->nodoIn  + "." + n->AsRutado()->campoIn;
      //       
      //   PASO  1 
      //       
      //   PASO1: Comprobar que existen los dos DEF del vnculo.
      //       Si no existen -> Error y volvemos.
      //       Hay que hacerlo considarando solo los nodos que no se han borrado.

      NodoArbol *nodoIn = NULL;
      NodoArbol *nodoOut = NULL;

      {
         // Intentamos recuperar los punteros a NodoArbol guardados en NodosDEF->Objects
         int index = NodosDEF->IndexOf(n->AsRutado()->nodoOut);
         if(-1 !=  index)
            nodoOut = (NodoArbol *)NodosDEF->Objects[index];

         index = NodosDEF->IndexOf(n->AsRutado()->nodoIn);
         if(-1 !=  index)
            nodoIn = (NodoArbol *)NodosDEF->Objects[index];
      }

      if( (nodoOut == NULL) || !nodoOut->EsNodo() ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Output node not found in the scene","Delete Element","Error");
         if(!CreandoInforme)
            // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }

      if( (nodoIn == NULL) || !nodoIn->EsNodo() ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Input node not found in the scene","Delete Element","Error");
         if(!CreandoInforme)
            // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }

      //       
      //   PASO  2 
      //       
      // PASO2: Comprobar que los dos nodos exiten en GN2. Si no -> Error y volvemos.
      // Lo primero es obtener los punteros NodoArbol del rutado:
      if( NULL == GN2->DatosNodo( nodoOut->AsNodo()->nombre ) ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Output Node(" +
                                 nodoOut->AsNodo()->nombre + ")doesn't exist in " + Tipo2 + " scenes","Delete Element","Error");
         if(!CreandoInforme)
            // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }

      if( NULL == GN2->DatosNodo( nodoIn->AsNodo()->nombre ) ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Input Node(" +
                                 nodoIn->AsNodo()->nombre + ")doesn' exist in " + Tipo2 + "scemes","Delete Element","Error");
         if(!CreandoInforme)
            // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }

      //       
      //   PASO  3 
      //       
      // PASO3: Obtener el nombre de los dos campos (si es necesario quitando los
      //       prefijos y sufijos). Y si no se encuentran los campos como hijos
      //       del nodo error.

      NodoArbol *campoOut = NULL;
      NodoArbol *campoIn  = NULL;

      for(int c=0; c <= nodoOut->hijos->MaxIndexUsado(); c++){
         NodoArbol *campo = (NodoArbol *)nodoOut->hijos->Get(c);
         if( (campo != NULL) && campo->EsCampo() ){
            // Si el campo es de tipo ExposedField y la escena Tipo1 es X3D
            // tenemos que aadirle el prefijo/sufijo antes de compararlo con
            // el nombre del nodo:
            AnsiString nombreCampo = campo->AsCampo()->nombre;
            // En X3D a los campos de tipo exposedfield se les puede aadir el
            // prefijo set_ y el sufijo _changed cuando se comportan como eventos
            // de entrada y salida respectivamente -> Lo tenemos en cuenta.
            if( (campo->AsCampo()->datosCampo->rutado == EXPOSEDFIELD) &&
                (Tipo1 == "X3D") ){
                // En este caso como estamos procesando el nodo out solo tenemos que
                // aadir el sufijo:
                if(n->AsRutado()->campoOut == (nombreCampo+CONF.SUFIJO_EXPOXEDFIELD_AS_EVENTOUT) ){
                   // En este caso lo hemos encontrado:
                   campoOut = campo;
                   break;
                }
            }
            // Ya podemos comparar el nombre del hijo de nodoOut de la interacin
            // actual con el nombre del campoOut del vnculo de rutado.
            if(n->AsRutado()->campoOut == nombreCampo){
               // En este caso lo hemos encontrado:
               campoOut = campo;
               break;
            }
         }
      }
      // Si no lo hemos encontrado volvemos.
      if( NULL == campoOut){
         AnadirFila( (AnsiString)"Route:" + rutado,"Field(" +
                                 n->AsRutado()->campoOut + ")isn't a child of " + n->AsRutado()->nodoOut ,"Delete Element","Error");
         if(!CreandoInforme)
            // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }

      // Ahora buscamos el campoIn:
      for(int c=0; c <= nodoIn->hijos->MaxIndexUsado(); c++){
         NodoArbol *campo = (NodoArbol *)nodoIn->hijos->Get(c);
         if( (campo != NULL) && campo->EsCampo() ){
            // Si el campo es de tipo ExposedField y la escena Tipo1 es X3D
            // tenemos que aadirle el prefijo/sufijo antes de compararlo con
            // el nombre del nodo:
            AnsiString nombreCampo = campo->AsCampo()->nombre;
            // En X3D a los campos de tipo exposedfield se les puede aadir el
            // prefijo set_ y el sufijo _changed cuando se comportan como eventos
            // de entrada y salida respectivamente -> Lo tenemos en cuenta.
            if( (campo->AsCampo()->datosCampo->rutado == EXPOSEDFIELD) &&
                (Tipo1 == "X3D") ){
               // En este caso como estamos procesando el nodo out solo tenemos que
               // aadir el sufijo:
               if(n->AsRutado()->campoIn == (CONF.PREFIJO_EXPOXEDFIELD_AS_EVENTIN + nombreCampo)){
                  // En este caso lo hemos encontrado:
                  campoIn = campo;
                  break;
               }
            }
            // Ya podemos comparar el nombre del hijo de nodoOut de la interacin
            // actual con el nombre del campoOut del vnculo de rutado.
            if(n->AsRutado()->campoIn == nombreCampo){
               // En este caso lo hemos encontrado:
               campoIn = campo;
               break;
            }
         }
      }
      // Si no lo hemos encontrado volvemos.
      if( NULL == campoIn){
         AnadirFila( (AnsiString)"Route:" + rutado,"Field(" +
                                 n->AsRutado()->campoIn + ")isn't child of " + n->AsRutado()->nodoIn ,"Delete Element","Error");
         if(!CreandoInforme)
            // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }

      // En este caso ya tenemos localizados en la escena todos los elementos
      // del vnculo de rutado: nodoIn,nodoOut,campoIn,campoOut. Tambin sabemos
      // que en GN2 tenemos los mismos nodos disponibles. Falta comprobar que
      // los campos sean correctos:
      //       
      //   PASO 4  
      //       
      // PASO4: Comprobar que exiten los mismos campos en los nodos
      //       del GN2-> Si no Error y volvemos:
      Campo *campoOut2=NULL;
      Campo *campoIn2 =NULL;
      {
         Nodo  *nodo2 = GN2->DatosNodo(nodoOut->AsNodo()->nombre);
         if(NULL != nodo2){
            // Ahora tenemos que buscar entre los hijos de nodo2 un campo que tenga
            // el mismo nombre que campoOut->AsCampo()->nombre:
            for(int c=0; c < nodo2->numCampos; c++){
               if( (nodo2->campos[c] != NULL) && (nodo2->campos[c]->nombre == campoOut->AsCampo()->nombre) ){
                  campoOut2 = nodo2->campos[c];
                  break;
               }
            }
            if(campoOut2 == NULL){
               AnadirFila( (AnsiString)"Route:" + rutado,"Output field(" +
                                       campoOut->AsCampo()->nombre + ")doesn't exist in " + Tipo2 + " scenes","Delete Element","Error");
               if(!CreandoInforme)
                  // En este caso que borrar el nodo:
                  frmEscena->EliminarNodo(n);
               return;
            }// else {} En este caso no hay que hacer nada --> Seguimos con las comprobaciones.

         }else{
            AnadirFila( (AnsiString)"Route:" + rutado,"Output Node(" +
                                    nodoOut->AsNodo()->nombre + ")doesn't exist in " + Tipo2 + " scenes","Delete Element","Error");
            if(!CreandoInforme)
               // En este caso que borrar el nodo:
               frmEscena->EliminarNodo(n);
            return;
         }
      }

      // Repetimos lo anterior para el nodoIn:
      {
         Nodo  *nodo2 = GN2->DatosNodo(nodoIn->AsNodo()->nombre);
         if(NULL != nodo2){
            // Ahora tenemos que buscar entre los hijos de nodo2 un campo que tenga
            // el mismo nombre que campoIn->AsCampo()->nombre:
            for(int c=0; c < nodo2->numCampos; c++){
               if( (nodo2->campos[c] != NULL) && (nodo2->campos[c]->nombre == campoIn->AsCampo()->nombre) ){
                  campoIn2 = nodo2->campos[c];
                  break;
               }
            }
            if(campoIn2 == NULL){
               AnadirFila( (AnsiString)"Route:" + rutado,"Input Field(" +
                                       campoIn->AsCampo()->nombre + ")doesn't exist in " + Tipo2 + " scenes","Delete Element","Error");
               if(!CreandoInforme)
                  // En este caso que borrar el nodo:
                  frmEscena->EliminarNodo(n);
               return;
            }// else {} En este caso no hay que hacer nada --> Seguimos con las comprobaciones.

         }else{
            AnadirFila( (AnsiString)"Route:" + rutado,"Input node(" +
                                    nodoIn->AsNodo()->nombre + ")doesn't exist in " + Tipo2 + " scenes","Delete Element","Error");
            if(!CreandoInforme)
               // En este caso hay que borrar el nodo:
               frmEscena->EliminarNodo(n);
            return;
         }
      }
      //       
      //   PASO 5  
      //       
      // PASO5:Comprobar que los campos de igual nombre del GN2 son compatibles
      //       respecto al tipo de rutado:
      //         * Para el campo del evento de salida del vinculo de Rurado (GN1) tendremos
      //         que tener un campo en el GN2 de tipo ExposedField o EventOut.
      //         * Para el campo del evento de entrada del vinculo de Rutado (GN1) tendremos
      //         que tener un campo en el GN2 de tipo ExposedField o EventIn.
      //       Si no se cumple esto -> Error y volvemos.

      // Sabemos que    campoOut2 y campoIn2 no son NULL.
      Campo *campoOut1 = campoOut->AsCampo()->datosCampo;
      Campo *campoIn1  = campoIn-> AsCampo()->datosCampo;

      if( (campoOut1 == NULL) || (campoIn1 == NULL) ){
         // Segn las reglas del gestor de nodos esto no debera ocurrir nunca.
         return;
      }

      // Comparamos los campos:
      // 5.a) campoOut1:
      if( campoOut1->rutado == FIELD ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Wrong Output field(" +
                                       campoOut1->nombre + ")FIELD","Delete Element","Error");
         if(!CreandoInforme) // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;

      }else if( campoOut1->rutado == EVENTIN ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Wrong Output Field(" +
                                       campoOut1->nombre + ")EventIn","Delete Element","Error");
         if(!CreandoInforme) // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }

      // 5.b) campoOut2:
      if( campoOut2->rutado == FIELD ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Wrong Output Field("+
                                       campoOut2->nombre + ")FIELD","Delete Element","Error");
         if(!CreandoInforme) // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;

      }else if( campoOut2->rutado == EVENTIN ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Wrong Output field("+
                                       campoOut2->nombre + ")EventIn","Delete Element","Error");
         if(!CreandoInforme) // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }

      // 5.c) campoIn1:
      if( campoIn1->rutado == FIELD ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Wrong Input Field(" +
                                       campoIn1->nombre + ")FIELD","Delete Element","Error");
         if(!CreandoInforme) // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;

      }else if( campoIn1->rutado == EVENTOUT ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Wrong input field(" +
                                       campoIn1->nombre + ")EventOut","Delete Element","Error");
         if(!CreandoInforme) // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }

      // 5.d) campoIn2:
      if( campoIn2->rutado == FIELD ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Wrong Input field("+
                                       campoIn2->nombre + ")FIELD","Delete Element","Error");
         if(!CreandoInforme) // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;

      }else if( campoIn2->rutado == EVENTOUT ){
         AnadirFila( (AnsiString)"Route:" + rutado,"Wrong input Field(" +
                                       campoIn2->nombre + ")EventOut","Delete Element","Error");
         if(!CreandoInforme) // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
         return;
      }
      //       
      //   PASO 6  
      //       
      // PASO6: Comprobar los tipos de los campos rutados. Si no coinciden warning pero
      //       no volvemos.
      bool warning = false;
      if( campoOut1->tipo->nombre != campoOut2->tipo->nombre ){
         warning = true;
         AnadirFila( (AnsiString)"Route:" + rutado,(AnsiString)"Output field:Types " + Tipo1 + "~" + Tipo2 +" different(" +
                                  campoOut1->tipo->nombre + "-" + campoOut2->tipo->nombre+")","Delete Element","Warning");
      }
      if( campoIn1->tipo->nombre != campoIn2->tipo->nombre ){
         warning = true;
         AnadirFila( (AnsiString)"Route:" + rutado,(AnsiString)"Input Field:Types " + Tipo1 + "~" + Tipo2 +" different(" +
                                  campoIn1->tipo->nombre + "-" + campoIn2->tipo->nombre+")","Delete Element","Warning");
      }

      //       
      //   PASO 7  
      //       
      // PASO7: En este caso los campos son 100% compatibles solo habra que adaptar
      //       los nombres. Para los campos X3D de tipo ExposedField habr que:
      //          Aadir prefijos y sufijos si estamos en: H3D -> X3D
      //          Borrar prefijos y sufijos si estamos en: X3D -> H3D   */
      if(!warning)
         AnadirFila( (AnsiString)"Route:" + rutado,"Compatible Element","","OK");

      // Aunque se produzca warning vamos a considerar el rutado compatible porque
      // si no se considerara como borrado.
      NumRutadosComp++;

      // Solo modificaremos el vnculo de rutado si es necesario:
      if(CreandoInforme)
         return;

      // Tenemos que distinguir los dos casos siguientes:
      // 7.a) H3D->X3D Los campos ExposedField en X3D habr que aadirles los
      //                prefijos y sufijos.
      // 7.b) X3D->H3D A campos ExposedField de X3D habr que quitarles los
      //                prefijos y sufijos.
      if(Tipo2 == "X3D"){  // Caso 7.a)
         if(campoOut2->rutado == EXPOSEDFIELD)
            n->AsRutado()->campoOut = campoOut2->nombre + CONF.SUFIJO_EXPOXEDFIELD_AS_EVENTOUT;
         if(campoIn2->rutado == EXPOSEDFIELD)
            n->AsRutado()->campoIn = CONF.PREFIJO_EXPOXEDFIELD_AS_EVENTIN + campoIn2->nombre;
      }else{ // Caso 7.b)
         // Podemos tomar directamente el valor del campo2:
            n->AsRutado()->campoOut = campoOut2->nombre;
            n->AsRutado()->campoIn  = campoIn2->nombre;
      }

   // Los comentarios no es necesario procesarlos.
   //}else if(n->EsComentario()){ // COMENTARIO 
   }else if(n->EsUSE()){  // USE 
      // Solo hay que comprobar que el nombr exista.
      if(-1 == NodosDEF->IndexOf(n->AsUSE()->nombreDado) ){
         AnadirFila( (AnsiString)"USE:" + n->AsUSE()->nombreDado,
                      "Doesn't exist in the scene","Delete Element","Error");
         if(!CreandoInforme) // En este caso que borrar el nodo:
            frmEscena->EliminarNodo(n);
      }else{
         AnadirFila( (AnsiString)"USE:" + n->AsUSE()->nombreDado,
                      "Compatible Element","","OK");
      }

   }else if(n->EsProto()){// PROTO 
      AnadirFila( "Proto:","Not compatible Element","Delete Element","Error");
      frmEscena->EliminarNodo(n);

   }else if(n->EsExternProto()){ // EXTENRPROTO 
      AnadirFila( "ExternProto:","Not compatible Element","Delete Element","Error");
      frmEscena->EliminarNodo(n);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::GridDrawCell(TObject *Sender, int ACol, int ARow,
      TRect &Rect, TGridDrawState State)
{
   if(ACol!=3)
     return;

   TRect posicion;
   int x,y;

   posicion=Grid->CellRect(3,ARow);
   // CellRect nos devuelve un rectngulo vaco si la celda no se
   // est mostrando en la pantalla.
   if(posicion.Width() || posicion.Height()){
      x=posicion.left;
      y=posicion.Top;

      if( Grid->Cells[ACol][ARow] == "OK" )
         Grid->Canvas->Draw(x,y,imgOk->Picture->Bitmap);
      else if( Grid->Cells[ACol][ARow] == "Error" )
         Grid->Canvas->Draw(x,y,imgStop->Picture->Bitmap);
      else if( Grid->Cells[ACol][ARow] == "Warning" )
         Grid->Canvas->Draw(x,y,imgWarning->Picture->Bitmap);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::sbAyudaClick(TObject *Sender)
{
   Main->Ayuda();
}
//---------------------------------------------------------------------------
void __fastcall TfrmVs::FormCreate(TObject *Sender)
{
   // Colocamos los paneles correctamente.
   pnlStop->Left = pnlWarning->Left;
   pnlOk->Left   = pnlWarning->Left;
   pnlStop->Top  = pnlWarning->Top;
   pnlOk->Top    = pnlWarning->Top;
}
//---------------------------------------------------------------------------


