//
//     CLASE   frmUtilidad    
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Esta es la clase implementa un formulario multipropsito que
       recoger y mostrar datos de inters.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "frmUtilidad_.h"
#include "frmEscena_.h"
//---------------------------------------------------------------------------

// Para cada una de las funciones de este formulario se usar un tamao de ventana
// determinado por las siguientes constantes.
#define WIDTH_COMENTARIO  639
#define HEIGHT_COMENTARIO 147
#define WIDTH_USE  427
#define HEIGHT_USE 140
#define WIDTH_MENSAJE  380
#define HEIGHT_MENSAJE 145
#define WIDTH_RUTADO  632
#define HEIGHT_RUTADO 230
#define WIDTH_BUSQUEDA 488
#define HEIGHT_BUSQUEDA 245
#define WIDTH_BUSQUEDA_TEXTO 491
#define HEIGHT_BUSQUEDA_TEXTO 184
#define WIDTH_ERRORES 733
#define HEIGHT_ERRORES 250
#define WIDTH_PROGRESO 449
#define HEIGHT_PROGRESO 170
#define WIDTH_MENSAJE_SIN_BOTONES 386
#define HEIGHT_MENSAJE_SIN_BOTONES 132
#define WIDTH_ELEGIR_H3D_X3D 495
#define HEIGHT_ELEGIR_H3D_X3D 251
#define WIDTH_IR_A_LINEA 409
#define HEIGHT_IR_A_LINEA 132

#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmUtilidad *frmUtilidad;
//---------------------------------------------------------------------------
__fastcall TfrmUtilidad::TfrmUtilidad(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::FormCreate(TObject *Sender)
{
   // Vamos a ocultar todos los tabs:
   tbIrALinea->TabVisible=false;
   tbComentario->TabVisible=false;
   tbPregunta->TabVisible=false;
   tbUSE->TabVisible=false;
   tbErrores->TabVisible=false;
   tbRutado->TabVisible=false;
   tbBusqueda->TabVisible=false;
   tbBusquedaTexto->TabVisible=false;
   tbProgreso->TabVisible=false;
   tbElegirH3D_X3D->TabVisible=false;

   pnlTickElegirH3D_X3D->Top = pnlStopElegirH3D_X3D->Top;

   pnlProgresoIcono->Width = 45;
   sbProgresoIcono2->Left = sbProgresoIcono1->Left;
   sbProgresoIcono3->Left = sbProgresoIcono1->Left;
   ProgresoPorcentajeAnterior=0;
   ProgresoIconoIndex=0;
   Tiempoanterior=-1;

   memoMensaje->Color=clBtnFace;
   MemoElegirH3D_X3D->Color=clBtnFace;
   Caption=NOMBRE_DEL_PROGRAMA;
   // Vamos a rellenar todos los elementos de la cbBusquArbolTipoElem.
   cbBusquArbolTipoElem->Clear();

   cbBusquArbolTipoElem->Items->Append("All");
   cbBusquArbolTipoElem->Items->Append("Nodes");
   cbBusquArbolTipoElem->Items->Append("DEF Nodes");
   cbBusquArbolTipoElem->Items->Append("USE Nodes");
   cbBusquArbolTipoElem->Items->Append("Fields (names)");
   cbBusquArbolTipoElem->Items->Append("Fields (contents)");
   cbBusquArbolTipoElem->Items->Append("ROUTE Links");
   cbBusquArbolTipoElem->Items->Append("Comments");
   cbBusquArbolTipoElem->ItemIndex=0;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmUtilidad::IniciaIrALinea(int &linea){

   Modo = "IrALinea";

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_IR_A_LINEA;
   Height=HEIGHT_IR_A_LINEA;
   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=9;
   // Inicializamos las variables.
   edIrALinea->Text = (linea == -1) ? (AnsiString)"" : IntToStr(linea);
   edIrALinea->SelectAll();
   // Pasamos el control a la edIrALinea.
   SetFocusedControl(edIrALinea);

   int p=ShowModal();
   if(p == mrOk){
       int l;
       try{ l = StrToInt(edIrALinea->Text); }
       catch(...){
          Utilidad.MsgInfo(" Format error, You must introduce an integer number.","Error");
          return IniciaIrALinea(linea);
       }
       if(l < 1){
          Utilidad.MsgInfo(" You must introduce a number greater than 1.","Advertencia");
          return IniciaIrALinea(linea);
       }
       linea = l;
       return true;
   }
   return false;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmUtilidad::IniciaComentario(AnsiString &texto){

   Modo = "Comentario";

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_COMENTARIO;
   Height=HEIGHT_COMENTARIO;
   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=0;
   // Inicializamos las variables.
   edComentario->Text=texto;
   // Pasamos el control a la comboBox.
   SetFocusedControl(edComentario);
   int p=ShowModal();
   if(p == mrOk){
       texto=edComentario->Text.TrimLeft();
//       if(texto[1] != '#')
//          texto=(AnsiString)"#" + texto;
       return true;
   }
   return false;
}
//---------------------------------------------------------------------------
TipoEscena __fastcall TfrmUtilidad::IniciaElegirH3D_X3D(AnsiString mensaje,AnsiString icono){

   Modo = "ElegirH3D_X3D";

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_ELEGIR_H3D_X3D;
   Height=HEIGHT_ELEGIR_H3D_X3D;

   pnlStopElegirH3D_X3D->Visible = (icono == "Stop");
   pnlTickElegirH3D_X3D->Visible = (icono == "Tick");

   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=8;
   // Inicializamos las variables.
   MemoElegirH3D_X3D->Text=mensaje;
   SetFocusedControl(btnElegirH3D);
   int p=ShowModal();
   if(p == mrOk)
      return ESCENA_H3D;
   else
      return ESCENA_X3D;
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::sbComentarioAceptarClick(TObject *Sender)
{
   ModalResult=mrOk;  // Con esta asignacin se cierra la ventana.
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::sbVolverClick(TObject *Sender)
{
   ModalResult=mrCancel; // Con esta asignacin se cierra la ventana.
}
//---------------------------------------------------------------------------
bool __fastcall TfrmUtilidad::IniciaUSE(AnsiString &nombreUSE,AnsiString &nombreTipoNodo){

   Modo = "USE";
   
   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_USE;
   Height=HEIGHT_USE;
   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=1;
   // Cargamos la ComboBox con los nombre de los ficheros de la escena actual.
   cbUSE->Clear();
   frmEscena->IniciaRecorrerArbol(NODO);
   NodoArbol *n=frmEscena->RecorrerArbol();
   while (n!= NULL){
       if( n->EsNodo() && (n->AsNodo()->nombreDado.Trim() != "" ) )
          cbUSE->Items->Append(n->AsNodo()->nombreDado.Trim());
       n=frmEscena->RecorrerArbol();
   }

   if(cbUSE->Items->Count == 0){
       Utilidad.MsgInfo(" To create USE sentences it is needed to specify a node identifier.");
       return false;
   }

   // Asignamos nombreUSE.
   cbUSE->Text = nombreUSE;
   // Pasamos el control a la comboBox.
   SetFocusedControl(cbUSE);
   // Mostramos la ventana y esperamos un valor de salida.
   if( (mrOk == ShowModal()) && (cbUSE->Text.Trim() != "")  )
   {
       nombreUSE = cbUSE->Text.Trim();
       //  Adems vamos a buscar el nombre que se ha elegido entre todos los nombres
       // dados a nodos en la escena y nos quedaremos con el nombre del nodo.
       frmEscena->IniciaRecorrerArbol(NODO);
       NodoArbol *n=frmEscena->RecorrerArbol();
       while (n!= NULL)
       {
           if( n->EsNodo() && (n->AsNodo()->nombreDado.Trim() == nombreUSE ) )
           {
              nombreTipoNodo = n->AsNodo()->nombre;   
              break;
           }
           n=frmEscena->RecorrerArbol();
       }
       return true;
   }
   return false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::CentrarVentana(){

   Left= ( Screen->Width - Width)  / 2;
   Top= ( Screen->Height - Height) / 2;
}
//---------------------------------------------------------------------------
TModalResult __fastcall TfrmUtilidad::Pregunta(AnsiString texto, AnsiString icono){

   Modo = "Pregunta";

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_MENSAJE;
   Height=HEIGHT_MENSAJE;
   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=2;
   // Asignamos las propiedades Visible de todos los controles.
   pnlMensajeAdvertencia->Visible=false;
   pnlMensajePregunta->Visible=false;
   pnlMensajeInfo->Visible=false;
   btnMensajeCancelar->Visible=true;
   btnMensajeSi->Visible=true;
   btnMensajeNo->Visible=true;
   this->ActiveControl = btnMensajeCancelar;

   // Hay que elegir qu icono se ver:
   if(icono == "Advertencia"){
       pnlMensajeAdvertencia->Visible=true;
       pnlMensajeAdvertencia->Top = 10;
   }else if(icono == "Pregunta"){
       pnlMensajePregunta->Visible=true;
       pnlMensajePregunta->Top = 10;
   }else{
       pnlMensajeInfo->Visible=true;
       pnlMensajeInfo->Top = 10;
   }
   // Asignamos el texto del mensaje.
   memoMensaje->Lines->Text=texto;
   // Mostramos la ventana.
   return ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::MsgSinBotones(AnsiString texto){

   Modo = "MensajeSinBotones";

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_MENSAJE_SIN_BOTONES;
   Height=HEIGHT_MENSAJE_SIN_BOTONES;

   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=2;
   // Asignamos las propiedades Visible de todos los controles.
   pnlMensajeAdvertencia->Visible=false;
   pnlMensajePregunta->Visible=false;
   pnlMensajeInfo->Visible=true;
   pnlMensajeInfo->Top = 17;
   btnMensajeCancelar->Visible=false;
   btnMensajeSi->Visible=false;
   btnMensajeNo->Visible=false;

   // Asignamos el texto del mensaje.
   memoMensaje->Lines->Text=texto;
   // Mostramos la ventana.
   Show();
   Repaint();
}
//-------------------------------------------------------------------------------
void __fastcall TfrmUtilidad::CerrarMsgSinBotones(){
   Close();
}
//-------------------------------------------------------------------------------
void __fastcall TfrmUtilidad::btnMensajeSiClick(TObject *Sender)
{
   ModalResult=mrYes;
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::btnMensajeNoClick(TObject *Sender)
{
   ModalResult=mrNo;
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::btnMensajeCancelarClick(TObject *Sender)
{
   ModalResult=mrCancel;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmUtilidad::IniciaRutado(AnsiString &nodoOut, AnsiString &campoOut,
                                           AnsiString &nodoIn,  AnsiString &campoIn ){

   Modo = "Rutado";

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_RUTADO;
   Height=HEIGHT_RUTADO;
   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=4;

   // Vamos a recorrer todos los nodos de la escena y a rellenar las comboBox.
   cbRutadoNodoIn->Clear();
   cbRutadoNodoOut->Clear();
   frmEscena->IniciaRecorrerArbol(NODO);
   NodoArbol *n=frmEscena->RecorrerArbol();
   while (n!= NULL){
       if( n->EsNodo() && (n->AsNodo()->nombreDado.Trim() != "" ) ){
          cbRutadoNodoOut->Items->Append(n->AsNodo()->nombreDado.Trim());
          cbRutadoNodoIn->Items->Append(n->AsNodo()->nombreDado.Trim());
       }
       n=frmEscena->RecorrerArbol();
   }
   if(cbRutadoNodoIn->Items->Count == 0){
       Utilidad.MsgInfo("To create ROUTE links it is needed to specify the node identifiers.","Advertencia");
       // return; No volvemos para dar libetad al usuario pero le avisamos:
   }

   int index;

   // Inicializamos los controles:
   cbRutadoNodoIn  ->Text = nodoIn;
   cbRutadoNodoOut ->Text = nodoOut;
   RutadoCargaCampoOut(nodoOut,campoOut);
   RutadoCargaCampoIn (nodoIn,campoIn);
   cbRutadoCampoIn ->Text = campoIn;
   cbRutadoCampoOut->Text = campoOut;

   // Pasamos el control a la comboBox del nodo de entrada.
   SetFocusedControl(cbRutadoNodoOut);
   // Mostramos la ventana y esperamos un valor de salida.
   if(mrOk == ShowModal()){
       nodoIn  = cbRutadoNodoIn->Text;
       nodoOut = cbRutadoNodoOut->Text;
       campoIn = cbRutadoCampoIn->Text;
       campoOut= cbRutadoCampoOut->Text;
       return true;
   }
   return false;
}
//------------------------------------------------------------------------------
void __fastcall TfrmUtilidad::cbRutadoNodoInChange(TObject *Sender)
{
   RutadoCargaCampoIn(cbRutadoNodoIn->Text,cbRutadoNodoIn->Text);
}
//---------------------------------------------------------------------------------------
void __fastcall TfrmUtilidad::cbRutadoNodoOutChange(TObject *Sender)
{
   RutadoCargaCampoOut(cbRutadoNodoOut->Text,cbRutadoCampoOut->Text);
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::cbRutadoCampoOutChange(TObject *Sender)
{
   int index = cbRutadoCampoOut->Items->IndexOf(cbRutadoCampoOut->Text);
   imgTipoOut->Visible = (index != -1);
   // Intentamos asignar el icono del tipo asociado al campo seleccionado.
   if(index != -1){
        TipoCampo *campo = ((NodoArbol *)cbRutadoCampoOut->Items->Objects[index])->AsCampo();
        imgTipoOut->Picture = campo->datosCampo->tipo->icono;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::cbRutadoCampoInChange(TObject *Sender)
{
   int index = cbRutadoCampoIn->Items->IndexOf(cbRutadoCampoIn->Text);
   imgTipoIn->Visible = (index != -1);
   // Intentamos asignar el icono del tipo asociado al campo seleccionado.
   if(index != -1){
        TipoCampo *campo = ((NodoArbol *)cbRutadoCampoIn->Items->Objects[index])->AsCampo();
        imgTipoIn->Picture = campo->datosCampo->tipo->icono;
   }
}
//------------------------------------------------------------------------------
void __fastcall TfrmUtilidad::RutadoCargaCampoIn(AnsiString nodoBuscado,AnsiString campoIn)
{
   // Cada vez que tengamos un nodo nuevo habr que actualizar la lista de los
   // hijos. Habr que hacer una lectura lineal para obtener los hijos.

   NodoArbol *nodo = frmEscena->BuscarNodoDEF(nodoBuscado);

   if(nodo == NULL){
      cbRutadoCampoIn->Items->Clear();
      return;
   }

   // Tenemos en nodo (que es != NULL) el puntero deseado.
   cbRutadoCampoIn->Items->Clear();

   // Vamos a obtener el nmero de campos que hay en el nodo. Es importante
   // no usar NodoArbolEditado->AsNodo()->datosNodo->numCampos porque hay nodos
   // especiales como Script (de VMRL) que tiene un nmero indeterminado de
   // campos (puede tener campos repetidos). Asi que calculamos el nmero de
   // campos as:
   int numCampos = 0;
   for(int c=0; c <= nodo->hijos->MaxIndexUsado(); c++){
      NodoArbol *campo = (NodoArbol *)nodo->hijos->Get(c);
      if( (campo != NULL) && campo->EsCampo() )
         numCampos++;
   }

   int c2=0;
   for(int c1=0; c1 < numCampos ; c1++){
      // Obtenemos un puntero al campo.
      NodoArbol *campo = nodo->GetHijo(c1,CAMPO);
      if(campo != NULL){
         // Obtenemos un puntero a los datos del campo.
         Campo *datosCampo = campo->AsCampo()->datosCampo;
         if( (datosCampo->rutado  == EVENTIN) || (datosCampo->rutado  == EXPOSEDFIELD) ){
            // Aadimos la cadena con el nombre del campo.
            if( (datosCampo->rutado  == EVENTIN) || (frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D) )
               cbRutadoCampoIn->Items->Append( (AnsiString) datosCampo->nombre );
            else // (datosCampo->rutado  == EXPOSEDFIELD)
               cbRutadoCampoIn->Items->Append( (AnsiString) Main->Prefijo_ExpField + datosCampo->nombre );
            // Guardaremos un puntero para cada campo -> Esto se usar ms tarde para
            // dibujar el icono y para crear el vnculo de rutado en caso necesario.
            cbRutadoCampoIn->Items->Objects[c2++] = (TObject *)campo;
         }
      }
   }

   if(numCampos > 0){
      // Intentamos asignar el icono del tipo asociado al campo seleccionado.
      int index = cbRutadoCampoIn->Items->IndexOf(campoIn);
      imgTipoIn->Visible = (index != -1);
      if(index != -1){
           TipoCampo *campo = ((NodoArbol *)cbRutadoCampoIn->Items->Objects[index])->AsCampo();
           imgTipoIn->Picture = campo->datosCampo->tipo->icono;
      }
   }

   // Cuando el campo sea "" cargaremos el primer campo de la lista:
   if( (cbRutadoCampoIn->Text.Trim() == "") && (cbRutadoCampoIn->Items->Count > 0) ){
      // Cambiamos el texto.
      cbRutadoCampoIn->Text = cbRutadoCampoIn->Items->Strings[0];
      // Cambiamos el icono.
      TipoCampo *campo = ((NodoArbol *)cbRutadoCampoIn->Items->Objects[0])->AsCampo();
      imgTipoIn->Picture = campo->datosCampo->tipo->icono;
      imgTipoIn->Visible = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::RutadoCargaCampoOut(AnsiString nodoBuscado,AnsiString campoOut)
{
   // Cada vez que tengamos un nodo nuevo habr que actualizar la lista de los
   // hijos. Habr que hacer una lectura lineal para obtener los hijos.
   NodoArbol *nodo = frmEscena->BuscarNodoDEF(nodoBuscado);

   if(nodo == NULL){
      cbRutadoCampoOut->Items->Clear();
      return;
   }

   // Tenemos en nodo (que es != NULL) el puntero deseado.
   cbRutadoCampoOut->Items->Clear();

   // Vamos a obtener el nmero de campos que hay en el nodo. Es importante
   // no usar NodoArbolEditado->AsNodo()->datosNodo->numCampos porque hay nodos
   // especiales como Script (de VMRL) que tiene un nmero indeterminado de
   // campos (puede tener campos repetidos). Asi que calculamos el nmero de
   // campos as:
   int numCampos = 0;
   for(int c=0; c <= nodo->hijos->MaxIndexUsado(); c++){
      NodoArbol *campo = (NodoArbol *)nodo->hijos->Get(c);
      if( (campo != NULL) && campo->EsCampo() )
         numCampos++;
   }

   int c2=0;
   for(int c1=0; c1 < numCampos ; c1++){
      // Obtenemos un puntero al campo.
      NodoArbol *campo = nodo->GetHijo(c1,CAMPO);

      if(campo != NULL){
         // Obtenemos un puntero a los datos del campo.
         Campo *datosCampo = campo->AsCampo()->datosCampo;
         if( (datosCampo->rutado  == EVENTOUT) || (datosCampo->rutado  == EXPOSEDFIELD) ){
            // Aadimos la cadena con el nombre del campo.
            if( (datosCampo->rutado  == EVENTOUT) || (frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D) )
               cbRutadoCampoOut->Items->Append( (AnsiString) datosCampo->nombre );
            else
               cbRutadoCampoOut->Items->Append( (AnsiString) datosCampo->nombre + Main->Sufijo_ExpField);
            // Guardaremos un puntero para cada campo -> Esto se usar ms tarde para
            // dibujar el icono y para crear el vnculo de rutado en caso necesario.
            cbRutadoCampoOut->Items->Objects[c2++] = (TObject *)campo;
         }
      }
   }

   if(numCampos > 0){
      // Intentamos asignar el icono del tipo asociado al campo seleccionado.
      int index = cbRutadoCampoOut->Items->IndexOf(campoOut);      
      imgTipoOut->Visible = (index != -1);
      if(index != -1){
           TipoCampo *campo = ((NodoArbol *)cbRutadoCampoOut->Items->Objects[index])->AsCampo();
           imgTipoOut->Picture = campo->datosCampo->tipo->icono;
      }
   }

   // Cuando el campo sea "" cargaremos el primer campo de la lista:
   if( (cbRutadoCampoOut->Text.Trim() == "") && (cbRutadoCampoOut->Items->Count > 0) ){
      // Cambiamos el texto.
      cbRutadoCampoOut->Text = cbRutadoCampoOut->Items->Strings[0];
      // Cambiamos el icono.
      TipoCampo *campo = ((NodoArbol *)cbRutadoCampoOut->Items->Objects[0])->AsCampo();
      imgTipoOut->Picture = campo->datosCampo->tipo->icono;
      imgTipoOut->Visible = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::sbRutadoAceptarClick(TObject *Sender)
{
   // Podramos impedir la creacin del vnculo de rutado cuando los tipos de
   // los campos rutados no coincidan, pero es mejor no hacerlo para que el usuario
   // pueda crear vinculos de rutados con campos que se definan dentro de un script.
   // Y conocer el tipo de los campos que se definan en un script no es fcil.
   // Con todo la nica condicin que impondremos para que se pueda crear el
   // vnculo de rutado es que las cuatro comboBox tengan texto.
   if(  (cbRutadoNodoIn->Text.Trim() != "") &&
        (cbRutadoNodoOut->Text.Trim() != "") &&
        (cbRutadoCampoIn->Text.Trim() != "") &&
        (cbRutadoCampoOut->Text.Trim() != "") )
      ModalResult=mrOk;  // Con esta asignacin se cierra la ventana.
   else
      Utilidad.MsgInfo("To create ROUTE links it is needed to specify the node identifiers.","Advertencia");
}
//---------------------------------------------------------------------------
bool __fastcall TfrmUtilidad::IniciaBusquedaArbol(AnsiString &texto, int &modo,bool &DistinguirMayusculas){

   Modo = "BsquedaArbol";

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_BUSQUEDA;
   Height=HEIGHT_BUSQUEDA;
   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=5;
   // Inicializamos las variables.
   cbBusquArbolTexto->Text=texto;
   // Ademas seleccionamos todo el texto.
   cbBusquArbolTexto->SelectAll();
   cbBusquedaDintinguir->Checked=DistinguirMayusculas;
   // Actualizamos cbBusquArbolTipoElem
   if(modo < cbBusquArbolTipoElem->Items->Count)
       cbBusquArbolTipoElem->ItemIndex= modo;
   // Pasamos el control a cbBusquArbolTexto.
   SetFocusedControl(cbBusquArbolTexto);
   int p=ShowModal();
   if(p == mrOk){
       texto=cbBusquArbolTexto->Text;
       DistinguirMayusculas=cbBusquedaDintinguir->Checked;
       if(cbBusquArbolTipoElem->ItemIndex != -1)
          modo=cbBusquArbolTipoElem->ItemIndex;
       return true;
   }
   return false;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmUtilidad::IniciaBusquedaTexto(AnsiString &texto,bool &DistinguirMayusculas){

   Modo = "BsquedaTexto";

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_BUSQUEDA_TEXTO;
   Height=HEIGHT_BUSQUEDA_TEXTO;
   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=6;
   // Inicializamos las variables.
   cbBusquedaTextoCadena->Text=texto;
   // Ademas seleccionamos todo el texto.
   cbBusquedaTextoCadena->SelectAll();

   cbBusquedaTexto->Checked=DistinguirMayusculas;
   // Pasamos el control a cbBusquArbolTexto.
   SetFocusedControl(cbBusquedaTextoCadena);
   int p=ShowModal();
   if(p == mrOk){
       texto=cbBusquedaTextoCadena->Text;
       DistinguirMayusculas=cbBusquedaTexto->Checked;
       return true;
   }
   return false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::IniciaProgreso(AnsiString msgTitulo ,int numPasos,
                                             AnsiString msgInicial,bool verPasos){

   Modo = "Progreso";

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_PROGRESO;
   Height=HEIGHT_PROGRESO;
   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=7;
   // Inicializamos los valores de los controles.
   lbProgresoTitulo->Caption= msgTitulo;
   pbProgreso->Max=numPasos;
   pbProgreso->Position=0;
   pnlProgresoPorcentaje->Caption="0%";
   lbProgresoMsgTmp->Caption = msgInicial;
   pnlProgresoPasos->Caption = IntToStr(pbProgreso->Position) + "/" + IntToStr(pbProgreso->Max);
   pnlProgresoPasosExt->Visible=verPasos;
   sbProgresoIcono1->Visible=true;
   sbProgresoIcono2->Visible=false;
   sbProgresoIcono3->Visible=false;
   ProgresoPorcentajeAnterior=0;
   ProgresoIconoIndex=0;
   Tiempoanterior=-1;
   if(!Visible)
      Show();
   Repaint();
}
//------------------------------------------------------------------------------
void __fastcall TfrmUtilidad::ActualizaProgreso(int paso,AnsiString msgActual){
   // Este es el poncentaje anterior (pbProgreso->Position * 100) / pbProgreso->Max
   // Y el nuevo es: (paso * 100) / pbProgreso->Max Usaremos esto para no
   // representar cambios menores de 1%
   int porcentajeActual = (paso * 100) / pbProgreso->Max;

   // Limitamos a 100 el valor mximo.
   if(porcentajeActual > 100)
      porcentajeActual = 100;

   if( porcentajeActual > ProgresoPorcentajeAnterior )
   {
        // Actualizamos el porcentaje solo si ha cambiado:
        pnlProgresoPorcentaje->Caption = IntToStr( porcentajeActual ) + "%";
        pnlProgresoPorcentaje->Repaint();
        ProgresoPorcentajeAnterior = porcentajeActual;

        // Ahora procesamos el giro de la rueda:
        Word tmp,Sec,MSec,tiempoActual;
        DecodeTime(Time(),tmp,tmp,Sec,MSec);
        tiempoActual = Sec*1000 + MSec;
        if(Tiempoanterior == -1)
           // Inicia progreso pone Tiempoanterior a -1 para considerar la primera
           // ejecucin de actualiza progreso.
           Tiempoanterior = tiempoActual;

        // 200 milisegundos es la velocidad ms adecuada para que gire la rueda.
        // La segunda condicin es para que no se detenga la rueda cuando cambian
        // los minutos.
        if( (tiempoActual-Tiempoanterior >= 200) || (tiempoActual < Tiempoanterior) ){
            sbProgresoIcono1->Visible = (ProgresoIconoIndex == 0);
            sbProgresoIcono2->Visible = (ProgresoIconoIndex == 1);
            sbProgresoIcono3->Visible = (ProgresoIconoIndex == 2);
            ProgresoIconoIndex = (ProgresoIconoIndex ==2) ? 0 : ProgresoIconoIndex + 1;
            pnlProgresoIcono->Repaint();
            Tiempoanterior = tiempoActual;
        }

        // Actualizamos la barra de progreso:
        pbProgreso->Position=paso;
        // pbProgreso->Repaint();  No es necesario hacerlo.
   }
   if(pnlProgresoPasosExt->Visible){
       pnlProgresoPasos->Caption = IntToStr(pbProgreso->Position) + "/" + IntToStr(pbProgreso->Max);
       pnlProgresoPasos->Repaint();
   }

   if( (msgActual != "") && (lbProgresoMsgTmp->Caption != msgActual) ){
       lbProgresoMsgTmp->Caption= msgActual;
       lbProgresoMsgTmp->Repaint();
   }
}
//------------------------------------------------------------------------------
void __fastcall TfrmUtilidad::FinalizaProgreso(){
   if(Visible)
     Close();
}
//---------------------------------------------------------------------------
int __fastcall TfrmUtilidad::IniciaErrores(TStrings *errores,AnsiString titulo)
{
   Modo = "Errores";

   if( errores->Count == 0 )
      return -1;

   // Asignamos las dimensiones de la ventana para este caso.
   Width=WIDTH_ERRORES;
   Height=HEIGHT_ERRORES;
   // Centramos la ventana en la pantalla.
   CentrarVentana();
   // Seleccionamos la pgina adecuada.
   Carpetas->ActivePageIndex=3;
   // Inicializamos las variables.
   lbErrores->Caption=titulo;

   // Vamos a rellenar la lista de errores:
   ListaErrores->Items->Clear();
   AnsiString cad;
   for(int c=0; c < errores->Count; c++)
   {
      cad = (*errores)[c];
      Utilidad.CortaPrimeraPalabra(cad);
      ListaErrores->Items->Add( cad );
   }

   this->Errores = errores;

   // Seleccionamos el primer elemento.   
   if(ListaErrores->Items->Count > 0)
   {
      ListaErrores->ItemIndex = 0;
      ListaErroresClick(NULL); // Para actualizar el edLocation
   }

   // Pasamos el control a la lista.
   SetFocusedControl(ListaErrores);

   int p=ShowModal();
   this->Errores = NULL;
   if(p == mrOk)
       return -1;
   if(ListaErrores->ItemIndex == -1 )
      return 0;
   else
      return ListaErrores->ItemIndex;
}
//------------------------------------------------------------------------------
void __fastcall TfrmUtilidad::edComentarioKeyPress(TObject *Sender,
      char &Key)
{
   if( (Key == VK_ESCAPE) || (Key == VK_RETURN) )
      Key=0; // As se evita que el TEdit produzca un sonido al pulsar Escape.
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::ListaErroresKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
   if(Key == VK_RETURN)
      sbVolverClick(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::btnElegirH3DClick(TObject *Sender)
{
   ModalResult=mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::btnMensajeSiKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
   char letra = Utilidad.CAP(Key);

   if (letra == 'S')
      ModalResult=mrYes;
   else if(letra == 'N')
      ModalResult=mrNo;
   else if(letra == 'C')
      ModalResult=mrCancel;
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::btnElegirX3D__Click(TObject *Sender)
{
   ModalResult=mrCancel;
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::edIrALineaKeyPress(TObject *Sender,
      char &Key)
{
   bool borrar = (Key == (char)8);
   bool punto =  (Key == '.');
   bool menos =  (Key == '-');
   bool numero = (Key <= '9') && (Key >= '0');
   if( !borrar && !numero && !punto && !menos )
      Key = '\0';
   else if( Key == VK_RETURN )
      Key=0; // As se evita que el TEdit produzca un sonido al pulsar Escape.
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::sbAceptarUSEClick(TObject *Sender)
{
   if(cbUSE->Text.Trim() == "")
       Utilidad.MsgInfo("You must specify an identifier or cancel the operation.");
   else
       ModalResult=mrOk;  // Con esta asignacin se cierra la ventana.
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::sbBusquedaBuscarClick(TObject *Sender)
{
   if( (cbBusquArbolTexto->Text.Trim() != "") &&
       (-1 == cbBusquArbolTexto->Items->IndexOf(cbBusquArbolTexto->Text))  )
      cbBusquArbolTexto->Items->Insert(0,cbBusquArbolTexto->Text);
   ModalResult=mrOk;  // Con esta asignacin se cierra la ventana.
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::sbBusquedaTextoAceptarClick(TObject *Sender)
{
   if (cbBusquedaTextoCadena->Text.Trim() == "")
      return;
   if( -1 == cbBusquedaTextoCadena->Items->IndexOf(cbBusquedaTextoCadena->Text)  )
      cbBusquedaTextoCadena->Items->Insert(0,cbBusquedaTextoCadena->Text);
   ModalResult=mrOk;  // Con esta asignacin se cierra la ventana.
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::cbBusquedaTextoCadenaKeyPress(
      TObject *Sender, char &Key)
{
   if( Key == VK_RETURN){
      // Con esto evitamos el Beep() que suena al pulsar intro.
      Key = '\0';
      sbBusquedaTextoAceptarClick(NULL);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::cbBusquArbolTextoKeyPress(TObject *Sender,
      char &Key)
{
   if(Key == VK_RETURN){
      // Con esto evitamos el Beep() que suena al pulsar intro.
      Key = '\0';
      sbBusquedaBuscarClick(NULL);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::FormShortCut(TWMKey &Msg, bool &Handled)
{
   Handled=false;

   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
   // Cerraremos la ventana cuando se pulse ESC si el modo lo permite:
   // El bit 30 de Msg.KeyData es 1 si la tecla est pulsada antes de que se produzca
   // el evento.
   if(0x40000000 & Msg.KeyData)
      return;
   if(Msg.CharCode == VK_ESCAPE){
      if( (Modo == "Comentario")    || (Modo == "USE")           || (Modo == "Rutado") ||
          (Modo == "BsquedaArbol") || (Modo == "BsquedaTexto") || (Modo == "IrALinea") ){
         sbVolverClick(NULL);
         Handled=true;
      }
   }

  // Tambin gestionaremos la pulsacin de intro cuando el modo sea el adeacuado:
   if(Msg.CharCode == VK_RETURN){
      Handled=true;
      if( (Modo == "Comentario") || (Modo == "IrALinea") )
         sbComentarioAceptarClick(NULL);
      else if(Modo == "USE")
         sbAceptarUSEClick(NULL);
      else if(Modo == "Errores")
         sbVolverClick(NULL);
      else if(Modo == "Rutado")
         sbRutadoAceptarClick(NULL);
      else if(Modo == "BsquedaArbol")
         sbBusquedaBuscarClick(NULL);
      else if (Modo == "BsquedaTexto")
         sbBusquedaTextoAceptarClick(NULL);
      else
         Handled=false;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::ListaErroresClick(TObject *Sender)
{
   edLocation->Text = "";

   if(Errores != NULL && ListaErrores->ItemIndex >= 0 && ListaErrores->ItemIndex < Errores->Count)
   {
      AnsiString cad = (*Errores)[ListaErrores->ItemIndex];
      edLocation->Text = Utilidad.CortaPrimeraPalabra(cad);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmUtilidad::edLocationDblClick(TObject *Sender)
{
   sbVolverClick(NULL);        
}

