//
//     CLASE   frmTipos   
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Lista los tipos H3D y X3D.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include "frmTipos_.h"
#include "Utilidad_.h"
#include "Configuracion_.h"
#include "frmEscena_.h"


// Constantes para ajustar la imagen a las casillas del grid.
#define IMAGEN_OFFSET_X 10


//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmTipos *frmTipos;
//---------------------------------------------------------------------------
__fastcall TfrmTipos::TfrmTipos(TComponent* Owner)
     : TForm(Owner)
{
     GT=NULL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmTipos::sbVolverClick(TObject *Sender)
{
     Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmTipos::Inicia(GestorTipos *gt){

     if(gt == NULL)
        return;
     GT=gt;

     CargarDatos();
     ShowModal();
}
//------------------------------------------------------------------------------
void __fastcall TfrmTipos::FormCreate(TObject *Sender)
{
     // Vamos a asignar el ttulo del Grid de Ttulos.
     GridTitulos->Cells[0][0]="Icon";
     GridTitulos->Cells[1][0]="Type";
     GridTitulos->Cells[2][0]="Examples";
}
//---------------------------------------------------------------------------
void __fastcall TfrmTipos::GridDrawCell(TObject *Sender, int ACol,
      int ARow, TRect &Rect, TGridDrawState State)
{
     // Para no dibujar varias veces por fila solo pintamos cuando la
     // columna es la adecuada.
     if(ACol!=0)
          return;

     AnsiString nombretipo;
     Tipo *tipo;

     nombretipo=Grid->Cells[1][ARow];

     // Ya tenemos el nombre del tipo base, ahora lo buscamos en el gestor de
     // nodos.
     tipo=GT->DatosTipo(nombretipo);
     if(tipo == NULL)
          return;
     Grid->Canvas->Draw(Rect.left+IMAGEN_OFFSET_X,Rect.top,tipo->icono->Bitmap);

}
//---------------------------------------------------------------------------
void __fastcall TfrmTipos::CargarDatos()
{
     Tipo *tipo;
     int nTipos;

     nTipos=GT->GetNumTipos();
     if(nTipos==0)
          return;

     Grid->RowCount= nTipos;

     for(int i=0; i < nTipos; i++){
          tipo=GT->DatosTipo(i);
          if(tipo != NULL){
               Grid->Cells[0][i]= "";
               Grid->Cells[1][i]= tipo->nombre;
               Grid->Cells[2][i]= tipo->ejemplo;
          }
     }
     Grid->Repaint();

     lbTitulo->Caption= (GT->tipoEscena==ESCENA_X3D)  ? "X3D Types" : "H3D Types";
}
//---------------------------------------------------------------------------
void __fastcall TfrmTipos::sbH3DClick(TObject *Sender)
{
   GT=Main->GTH;
   CargarDatos();
}
//---------------------------------------------------------------------------
void __fastcall TfrmTipos::sbX3DClick(TObject *Sender)
{
   GT=Main->GTX;
   CargarDatos();
}
//---------------------------------------------------------------------------
void __fastcall TfrmTipos::FormKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(VK_ESCAPE == Key)
     Close();
}
//---------------------------------------------------------------------------

void __fastcall TfrmTipos::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmTipos::sbAyudaClick(TObject *Sender)
{
   Main->Ayuda();
}
//---------------------------------------------------------------------------

