//
//     CLASE   frmSobre   
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Implementa la ventana de crditos del programa.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "frmSobre_.h"
#include "Utilidad_.h"
#include "Main_.h"
#include "mapi.hpp"

// Coordenadas de lbMail1 y lbMail2
#define MAIL1_LEFT 303
#define MAIL1_TOP 295

#define MAIL2_LEFT 296
#define MAIL2_TOP 320

#define MAIL3_LEFT 281
#define MAIL3_TOP 308

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TfrmSobre *frmSobre;
//---------------------------------------------------------------------------
__fastcall TfrmSobre::TfrmSobre(TComponent* Owner)
        : TForm(Owner)
{
   TodosCargados=false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::Inicia(){

   if(!TodosCargados){
      Utilidad.MsgInfo("The configuration files don't exist.","Error");
      return;
   }

   // Preparamos los controles para mostrar el cuadro.
   Cuadro->Visible = true;
   ImgCuadro->Visible = false;
   lbMail1->Visible = false;
   lbMail2->Visible = false;
   lbMail3->Visible = false;   

   try{
      LogoPrograma->Active = true;
      Cuadro->Active = true;
   }catch(...){
      Utilidad.MsgInfo("Format error in the configuration files.","Error");
      return;
   }

   // Ocultamos los logos VRML y H3D.
   LogoVRML->Visible = false;
   LogoH3D->Visible = false;

   // Mostramos la ventana:
   ShowModal();

   // Desactivamos las animaciones para que las hebras que contienen no consuman recursos:
   LogoPrograma->Active = false;
   Cuadro->Active = false;
   LogoVRML->Active = false;
   LogoH3D->Active = false;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmSobre::CargaVideo(TAnimate *video,AnsiString fichero){

   // Intentamos cargar el Logo:
   AnsiString file;

   file = (AnsiString) Main->CARPETA_PROGRAMA + "\\" +
          (AnsiString) CONF.CARPETA_CONFIGURACION +
          (AnsiString) "\\" +
          (AnsiString) fichero;

   if( FileExists(file) ){
      try{
         video->FileName = file;
      }catch(...){
         return false;
      }
   }else
      return false;
   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::CuadroStop(TObject *Sender)
{
   // La animacin de los logos VRML y H3D comienza cuando acaba la animacin
   // del cuadro:
   try{
      LogoVRML->Visible = true;
      LogoVRML->Active = true;
      LogoH3D->Active = true;
      LogoH3D->Visible = true;
      Beep();

   }catch(...){
      Utilidad.MsgInfo("Format error in the configuration files.","Error");
      ModalResult=mrOk;
   }

   // Tenemos un problema con los componentes TAnimate y es que no responden a
   // los eventos del ratn. As que vamos a ocultar Cuadro y a mostrar ImgCuadro.
   Cuadro->Visible = false;
   Cuadro->Repaint();
   ImgCuadro->Visible = true;
   ImgCuadro->Repaint();
   lbMail1->Visible = true;
   lbMail2->Visible = true;
   lbMail3->Visible = true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::FormCreate(TObject *Sender)
{
   // Inicialmente cargamos todos los ficheros:
   TodosCargados =  CargaVideo(LogoPrograma,VIDEO_LOGO_PROGRAMA) &&
                    CargaVideo(Cuadro,VIDEO_CUADRO) &&
                    CargaVideo(LogoVRML,VIDEO_VRML) &&
                    CargaVideo(LogoH3D,VIDEO_H3D);

   // Colocamos ImgCuadro.
   ImgCuadro->Left = Cuadro->Left;
   ImgCuadro->Top = Cuadro->Top;

   lbMail1->Left = MAIL1_LEFT;
   lbMail1->Top  = MAIL1_TOP;

   lbMail2->Left = MAIL2_LEFT;
   lbMail2->Top  = MAIL2_TOP;

   lbMail3->Left = MAIL3_LEFT;
   lbMail3->Top  = MAIL3_TOP;
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::FormShortCut(TWMKey &Msg, bool &Handled)
{
  // Cerraremos la ventana cuando se pulse ESC:
  // El bit 30 de Msg.KeyData es 1 si la tecla est pulsada antes de que se produzca
  // el evento.
  if(0x40000000 & Msg.KeyData)
     return;
  if( Msg.CharCode == VK_ESCAPE)
     ModalResult=mrOk;
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::lbMail1MouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
   Activa(lbMail1);
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::imgFondoMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
   Activa(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::lbMail2MouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
   Activa(lbMail2);
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::ImgCuadroClick(TObject *Sender)
{
   Screen->Cursor = crDefault;
   ModalResult = mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::Activa(TLabel *lb){

   lbMail1->Font->Color = clYellow;
   lbMail1->Font->Style = TFontStyles();
   lbMail2->Font->Color = clYellow;
   lbMail2->Font->Style = TFontStyles();
   lbMail3->Font->Color = clYellow;
   lbMail3->Font->Style = TFontStyles();

   if(lb == NULL){
      Screen->Cursor = crDefault;
   }else{
      Screen->Cursor = crHandPoint;
      lb->Font->Color = clLime;
      lb->Font->Style = TFontStyles()<< fsUnderline;
   }
}
//------------------------------------------------------------------------------
void __fastcall TfrmSobre::MailTo(AnsiString direccion){

     /*  Este cdigo no de buenos resultados. A veces se queda colcago y no es
   posible cerrar el programa de correo, lo haremos de otro modo:

   TMapiMessage MapiMessage;
   TMapiRecipDesc destino;

   destino.ulReserved = 0;
   destino.ulRecipClass = 1;
   destino.lpszName = direccion.c_str();
   destino.lpszAddress = NULL;
   destino.ulEIDSize = 0;
   destino.lpEntryID = NULL;

   MapiMessage.ulReserved = 0;
   MapiMessage.lpszSubject = "";
   MapiMessage.lpszNoteText = "";
   MapiMessage.lpszMessageType = NULL;
   MapiMessage.lpszDateReceived = NULL;
   MapiMessage.lpszConversationID = NULL;
   MapiMessage.flFlags = 0;
   MapiMessage.lpOriginator = NULL;
   MapiMessage.nRecipCount = 1;
   MapiMessage.lpRecips = &destino;
   MapiMessage.nFileCount = 0;
   MapiMessage.lpFiles = NULL;

   MapiSendMail(0, 0, MapiMessage,MAPI_DIALOG | MAPI_LOGON_UI | MAPI_NEW_SESSION, 0);

    */
   direccion = (AnsiString)"mailto:" + direccion;
   ShellExecute(this->Handle,"open",direccion.c_str(),NULL,NULL, SW_SHOWMAXIMIZED);
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::lbMail1Click(TObject *Sender)
{
   MailTo(lbMail1->Caption);
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::lbMail2Click(TObject *Sender)
{
   MailTo(lbMail2->Caption);
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::imgDisRealClick(TObject *Sender)
{
   ShellExecute(this->Handle,"open", URL_DISREAL,NULL,NULL, SW_SHOWMAXIMIZED);
}
//---------------------------------------------------------------------------

void __fastcall TfrmSobre::imgDisRealMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
   Screen->Cursor = crHandPoint;
}
//---------------------------------------------------------------------------

void __fastcall TfrmSobre::lbMail3MouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
   Activa(lbMail3);        
}
//---------------------------------------------------------------------------
void __fastcall TfrmSobre::lbMail3Click(TObject *Sender)
{
   MailTo(lbMail3->Caption);        
}
//---------------------------------------------------------------------------

