//
//     CLASE   frmRutado   
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Lista los vnculos de rutado de la escena actual.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "frmRutado_.h"
#include "frmEscena_.h"
#include "Utilidad_.h"
#include "frmUtilidad_.h"
#include "frmTipos_.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmRutado *frmRutado;
//---------------------------------------------------------------------------
__fastcall TfrmRutado::TfrmRutado(TComponent* Owner)
        : TForm(Owner)
{
  GT=NULL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmRutado::sbVolverClick(TObject *Sender)
{
   Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmRutado::Inicia(GestorTipos *GT_){

    GT=GT_;

    grid->RowCount=1;  // Iremos aadiendo filas a medida que hangan falta.
    // Vamos a recorrer todos los nodos de tipo Rutado del TreeView y a aadirlos
    // a la lista:
    frmEscena->IniciaRecorrerArbol(RUTADO);
    int c=0;
    NodoArbol *vinculo = frmEscena->RecorrerArbol();
    while( (vinculo != NULL) && (vinculo->dato != NULL) ){
        if( (c+1) > grid->RowCount )
            grid->RowCount=c+1;

        TipoRutado *v = vinculo->AsRutado();
        // Aadimos el vnculo:
        grid->Cells[2][c]= v->nodoOut + "." + v->campoOut;
        grid->Cells[3][c]= v->nodoIn + "." + v->campoIn;

        NodoArbol *padre = vinculo->padre;
        if(padre != NULL){
            if(padre->EsRaiz())
               grid->Cells[1][c]= "Root";
            else
               grid->Cells[1][c]= padre->AsNodo()->nombre + ":" + padre->AsNodo()->nombreDado;
        }

        // Hay que usar un icono para cada vinculo de rutado -> Es muy complejo
        // hacerlo. Vamos a usar los punteros a TObject de grid para que apunten
        // a cada vinculo de rutado de la lista y cuando acabemos la lectura
        // lineal de la escena actual. tendremos que hacer otra lectura lineal
        // para encontrar los campos asociados a cada vinculo y de ah obtener
        // el nodo.
        grid->Objects[0][c]= (TObject *) v;

        c++;
        vinculo = frmEscena->RecorrerArbol();
    }

    if(c == 0){  // En este caso no se han encontrado vnculos de rutado.
        Utilidad.MsgInfo("There isn't information about ROUTEs links.");
        return;
    }

    // Ahora tengo que hacer que los punteros grid->Objects[0][*] apunten
    // a los iconos de cada uno de los campos. El modo de hacerlo es para cada
    // uno de los puntero grid->Objects[0][c] hacer una lectura lineal en la
    // que busquemos el nombreDado de uno de los dos nodos X3D del vnculo y
    // a continuacin buscar entre los hijos el campo que participa en el vinculo
    // y cuando lo tengamos se asignar a grid->Objects[0][c].
    for(int cont=0; cont < grid->RowCount ; cont++){

        frmEscena->IniciaRecorrerArbol(NODO);
        NodoArbol *nodo= frmEscena->RecorrerArbol();
        bool encontradoEnIn=false;
        bool encontrado=false;
        while( (nodo != NULL) && (!encontrado) ){
            if(nodo->AsNodo()->nombreDado == ((TipoRutado *)grid->Objects[0][cont])->nodoIn){
               encontrado=true;
               encontradoEnIn=true;
            }else if(nodo->AsNodo()->nombreDado == ((TipoRutado *)grid->Objects[0][cont])->nodoOut){
               encontrado=true;
               encontradoEnIn=false;
            }else
               nodo= frmEscena->RecorrerArbol();
        }
        // Vemos si hemos encontrado o no el nodo.
        if(nodo!=NULL){
           // En este caso hemos encontrado el nodo -> Tenemos que buscar
           // entre sus hijos el nombre nombreCampo:
           AnsiString nombreCampo;
           if(encontradoEnIn)
              nombreCampo = ((TipoRutado *)grid->Objects[0][cont])->campoIn;
           else
              nombreCampo = ((TipoRutado *)grid->Objects[0][cont])->campoOut;
           AnsiString nombreCampoSin=nombreCampo;
           QuitarPreYSufijos(nombreCampoSin);
           int c1=0;
           NodoArbol *campo = nodo->GetHijo(c1++,CAMPO);
           bool campoEncontrado=false;
           while( campo != NULL ){
              // Comparamos el nombre del campo con nombreCampo
              if( campo->AsCampo()->datosCampo->rutado == EXPOSEDFIELD){
                  if(nombreCampoSin == campo->AsCampo()->nombre){
                     // En este caso hemos encontrado el campo -> Solo tenemos que
                     // asignar grid->Objects[0][c] al tipo del campo.
                     grid->Objects[0][cont] = (TObject *) campo->AsCampo()->datosCampo;
                     // Salimos del bucle.
                     campo=NULL;
                    campoEncontrado=true;
                  }
              }else{
                  if(nombreCampo == campo->AsCampo()->nombre){
                    // En este caso hemos encontrado el campo -> Solo tenemos que
                    // asignar grid->Objects[0][c] al tipo del campo.
                    grid->Objects[0][cont] = (TObject *) campo->AsCampo()->datosCampo;
                    // Salimos del bucle.
                    campo=NULL;
                    campoEncontrado=true;
                  }
              }
              
              if(!campoEncontrado){
                 // Seguimos buscando.
                 campo = nodo->GetHijo(c1++,CAMPO);
              }
           }
           if(!campoEncontrado)
              grid->Objects[0][cont]=NULL;

        }else{
           // En este caso no hemos encontrado el nodo asignamos a NULL el puntero
           // para que no se represente ningn icono.
           grid->Objects[0][cont]=NULL;
        }
    }

    // Finalmente seleccionamos la primera celda y mostramos la ventana.
    grid->Row=0;
    grid->Col=0;
    ShowModal();
}
//------------------------------------------------------------------------------
void __fastcall TfrmRutado::gridDrawCell(TObject *Sender, int ACol,
      int ARow, TRect &Rect, TGridDrawState State)
{
   if(ACol == 0){
      // En este caso hay que dibujar el icono asociado al tipo.
      Campo *campo;
      campo=(Campo *)grid->Objects[0][ARow];
      if( (campo != NULL) && (campo->tipo != NULL) )
             grid->Canvas->Draw(Rect.Left,Rect.Top,campo->tipo->icono->Bitmap);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmRutado::gridMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   int ACol,ARow;
   grid->MouseToCell(X,Y,ACol,ARow);
   if(ACol == 0)
        frmTipos->Inicia(GT);
}
//---------------------------------------------------------------------------
void __fastcall TfrmRutado::FormKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(VK_ESCAPE == Key)
     Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmRutado::QuitarPreYSufijos(AnsiString &campo){

    AnsiString cad;
   // Buscamos el prefijo:
   cad=Main->Prefijo_ExpField;
   if( (1 == campo.Pos(cad)) && (campo.Length() > cad.Length()) ){
      campo = campo.SubString(cad.Length()+1,campo.Length()-cad.Length());
   }
   // Buscamos el sufijo:
   cad=Main->Sufijo_ExpField;
   int pos = campo.Pos(cad);
   if( (0 != pos) && (campo.Length() > cad.Length()) ){
      campo = campo.SubString(1,campo.Length()-cad.Length());
   }
}
//---------------------------------------------------------------------------

void __fastcall TfrmRutado::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------

void __fastcall TfrmRutado::sbAyudaClick(TObject *Sender)
{
   Main->Ayuda();        
}
//---------------------------------------------------------------------------

