//
//     CLASE   frmRelieve  
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta clase implementa una utilidad para crear relieves 3D.
*/
//---------------------------------------------------------------------------
#ifndef frmRelieve_H
#define frmRelieve_H

//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Dialogs.hpp>
#include "Utilidad_.h"

//---------------------------------------------------------------------------
////////////////////////////////////////////////// CLASE Punto3D ///////////////
// Esta clase guarda la informacin de un punto 3D.
class Punto3D{
public:
   float x,y,z;

   // DEvuelve una cadena con los tres valores reales separados por un espacio
   // por ejemplo: "1,2 2,0 3,0"
   AnsiString ToString();

   // Constructores
   Punto3D();
   Punto3D(float x,float y, float z);
};

////////////////////////////////////////////////// CLASE DatosPerfil ///////////
class DatosPerfil{
public:
   // Estas variables corresponden a la expresin:
   // A/(B + c1*x^e1+c2*x^e2+c3*x^e3)
   // Adems escalaVI es la escala que se aplica a la variable independiente (VI).
   // Con escalaVI cambiamos el ancho de la montaa.
   double A,B,c1,c2,c3,e1,e2,e3,escalaVI;
   AnsiString Nombre;
   // Convierte todos los datos de la clase a una cadena.
   AnsiString SaveToString();
   
   // Carga los todos los datos de la clase de una cadena.
   // El formato de cad debe ser:
   // "Nombre del Perfil" <A> <B> <c1> <c2> <c3> <e1> <e2> <e3>
   // Los elementos que aparecen entre < > sern nmeros reales.
   void LoadFromString(AnsiString cad);

   // Copia los datos de p a this.
   void Asigna(DatosPerfil *p);

   // Constructores.
   DatosPerfil();
   DatosPerfil(DatosPerfil *p);

   DatosPerfil(AnsiString cad);
};
//---------------------------------------------------------------------------

class TfrmRelieve : public TForm
{
__published:	// IDE-managed Components
        TPanel *pnlGen;
        TOpenDialog *dlgOpen;
        TSaveDialog *dlgSave;
        TGroupBox *gbListaPuntos;
        TListBox *Lista;
        TGroupBox *gb1Modos;
        TRadioButton *rbModoRelieve;
        TRadioButton *rbModoPerfiles;
        TGroupBox *gb2Modos;
        TRadioButton *rbSumarPerfiles;
        TRadioButton *rbModoUsarMaximo;
        TGroupBox *gbAcciones;
        TButton *btnBorrar;
        TButton *btnIniciar;
        TGroupBox *gbFicheros;
        TButton *btnCargarRelieve;
        TButton *btnSalvarRelieve;
        TGroupBox *gbPerfiles;
        TButton *btnEliminarPerfil;
        TListBox *ListaPerfiles;
        TButton *btnAnadirPerfil;
        TGroupBox *gbResolucion;
        TLabel *lbResolucion;
        TEdit *edResolucion;
        TPanel *pnlRes;
        TButton *btnPrueba;
        TGroupBox *gbPerfilActual;
        TLabel *lbA;
        TLabel *lbc3;
        TLabel *lbc2;
        TLabel *lbc1;
        TLabel *lbB;
        TLabel *lbe1;
        TLabel *lbe2;
        TLabel *lbe3;
        TLabel *lbEscala;
        TLabel *lbNombrePerfil;
        TEdit *edA;
        TEdit *edB;
        TEdit *edc1;
        TEdit *ede1;
        TEdit *edc2;
        TEdit *ede2;
        TEdit *edc3;
        TEdit *ede3;
        TEdit *edEscalaVI;
        TEdit *edNombrePerfil;
        TGroupBox *gbExpresion;
        TLabel *lbExpr;
        TPanel *pnlPB;
        TImage *Canvas;
        TMemo *CodigoBasico;
        TPanel *pnl1;
        TPanel *Panel1;
        TPanel *Panel2;
        TPanel *Panel3;
        TGroupBox *GroupBox1;
        TButton *btnAceptar;
        TButton *btnCancelar;
        TButton *btnAyuda;
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall btnIniciarClick(TObject *Sender);
        void __fastcall ListaClick(TObject *Sender);
        void __fastcall edAKeyPress(TObject *Sender, char &Key);
        void __fastcall edAKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall btnCargarRelieveClick(TObject *Sender);
        void __fastcall btnSalvarRelieveClick(TObject *Sender);
        void __fastcall CanvasMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall btnBorrarClick(TObject *Sender);
        void __fastcall ListaKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall btnPruebaClick(TObject *Sender);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall FormDestroy(TObject *Sender);
        void __fastcall rbModoRelieveClick(TObject *Sender);
        void __fastcall rbModoPerfilesClick(TObject *Sender);
        void __fastcall btnAceptarClick(TObject *Sender);
        void __fastcall btnEliminarPerfilClick(TObject *Sender);
        void __fastcall btnAnadirPerfilClick(TObject *Sender);
        void __fastcall ListaPerfilesKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall ListaPerfilesClick(TObject *Sender);
        void __fastcall edNombrePerfilKeyPress(TObject *Sender, char &Key);
        void __fastcall btnCancelarClick(TObject *Sender);
        void __fastcall btnAyudaClick(TObject *Sender);
private:	// User declarations
        // Apunta a una estructura con los datos del perfil por defecto.
        DatosPerfil *PerfilPorDefecto;
        // Apunta a una estructura con los datos del perfil actual.        
        DatosPerfil *PerfilActual;
        // Variable que se usa para crear el cdigo X3D de la escena.
        TStringList *Codigo;
        // Dibuja el fondo de Canvas con el color c.
        void __fastcall Fondo(TColor c);

        // Dibula las lneas que forman la cuadrcula en Canvas:
        // paso es la distancia en pixels entre cada lnea y c es el color de stas.
        void __fastcall Cuadricula(int paso,TColor c);

        // Toma los puntos de Lista y los representa en Canvas.
        void __fastcall DibujarPuntos();

        // Actualiza los controles contenidos en gbPerfilActual con los datos de p.
        void __fastcall RellenaDatosPerfil(DatosPerfil *p);

        // Estas funciones cargan/salvan los datos contenidos en Lista perfiles
        // al fichero de configuracin FICH_PERFILES, incluyendo los parmetros
        // de cada perfil.
        void __fastcall CargarPerfiles();
        void __fastcall SalvarPerfiles();

        // Salva el texto de los indicadores contenidos en gbPerfilActual
        // distinguiendo dos casos. Si se est diseando un perfil o si no hay
        // ningn elemento seleccionado en Lista, se salvan PerfilActual.
        // Si hay algn elemento seleccionado en Lista se salva al perfil
        // asociado a ese elemento.
        void __fastcall SalvaIndicadores();

        // Genera el relieve actual en cdigo X3D y lo guarda en Codigo.
        // Devuelve false si no se genera el error pq algn parmetro tenga
        // algn valor incorrecto.
        bool __fastcall GenerarRelieve();
        // Devuelve el valor de la altura para los puntos x,z
        float __fastcall Evalua(float x,float z); 
        // Devuelve el valor de la altura para los puntos x,z
        float __fastcall EvaluaExprNum(int i,float x,float z);

        // Representa sobre Canvas un grfica que muestra el perfil contenido de
        // PerfilActual.
        void __fastcall RepresentaGrafica();
                       
public:		// User declarations

       // Muestra la ventana. Si el usuario decide incluir el relive en la
       // escena, la funcin devolver true y rellenar relive con los datos
       // que hay que incluir en la escena. En otro caso devolver false y no
       // modificar el contenido de relieve.
       bool __fastcall Inicia(TStringList *relieve);

        __fastcall TfrmRelieve(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmRelieve *frmRelieve;
//---------------------------------------------------------------------------
#endif


