//
//     CLASE   frmRelieve  
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta clase implementa una utilidad para crear relieves 3D.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "configuracion_.h"
#include "Main_.h"
#include "frmRelieve_.h"
#include "frmUtilidad_.h"
#include <math.hpp>
#include <math.h>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

#define A_POR_DEFECTO "50"
#define B_POR_DEFECTO "0.0001"
// Nombre del fichero que se usa para probar la escena.
#define FICH_PRUEBA "PruebaPerfil.wrl"
// Nombre del fichero de configuracin donde se guardan los datos de los perfiles.
#define FICH_PERFILES "Perfiles.cfg"
// Color de fondo de la cuadrcula:
#define COLOR_FONDO (TColor)0x00DF967A
// Color de las lneas de la cuadrcula:
#define COLOR_LINEAS clBlue
// Paso de los cuadrados de la cuadrcula (en pxels).
#define PASO_CUADRICULA 15
// Radio de los puntos asociados a cada montaa.
#define ITEM_RADIO 5
// Color del borde de cada punto (montaa).
#define ITEM_COLOR_BORDE     (TColor) 0x00D8E900
// Color del interior del crculo asociado a cada montaa.
#define ITEM_COLOR_INTERIOR  clYellow
// Es el color de la grfica que se usa para mostrar los perfiles.
#define COLOR_GRAFICA  clYellow
// Para alinear por columnas las coordenadas x,z de los puntos es necesario
// usar un nmero de caracteres de referencia (donde empieza cada columna).
#define LONG_COLUMNA1 4
#define LONG_COLUMNA2 8
// Para seleccionar cada punto (montaa) se usan tres crculos, las siguientes
// constantes definen sus radios y su color.
#define RADIO_SEL1 8
#define RADIO_SEL2 12
#define RADIO_SEL3 16
#define COLOR_SEL clLime

// A continuacin se definen los valores por defecto (VD) de las variables de la
// clase DatosPerfil.
#define VD_A   50
#define VD_B   1
#define VD_c1  1
#define VD_c2  0
#define VD_c3  0
#define VD_e1  3
#define VD_e2  1
#define VD_e3  1
#define VD_NOMBRE "Normal"
#define VD_ESCALA_VI 0.03


// Esta funcion calcula a elevado a b capturando las posible excepciones.
Extended pow2(Extended a, Extended b){
   Extended  x;
   try{ x=Power(a,b); }
   catch(...){x=0;}
   return x;
}

TfrmRelieve *frmRelieve;
//---------------------------------------------------------------------------
AnsiString Punto3D::ToString(){
   // No se por qu pero a veces el valor de DecimalSeparator cambia de modo que
   // no es suficiente con asignarlo en Create FormCreate
   if(DecimalSeparator!='.')
      DecimalSeparator='.';
   // No se producen excepciones en el paso: float -> String
   return (FloatToStr(x) + " " + FloatToStr(y) + " " + FloatToStr(z) );
}
//---------------------------------------------------------------------------
Punto3D::Punto3D(){
    x=0; y=0; z=0;
}
//---------------------------------------------------------------------------
Punto3D::Punto3D(float x,float y, float z){
   this->x=x; this->y=y; this->z=z;
}
//---------------------------------------------------------------------------
void DatosPerfil::LoadFromString(AnsiString cad){
   cad=cad.Trim();
   if(cad[1] != '"')
      return;
   // Lo primero es obtener el nombre que aparece entre ""
   int c=2;
   int lon=cad.Length();

   while( (c <= lon) && (cad[c] != '"') )
      c++;

   Nombre = cad.SubString(2,c-2);
   if(c <= lon) c++;  // Absorvemos las comillas.

   // Obtenemos el resto de valores reales. Los leemos con PasaStrAFloat que
   // captura posibles excepciones y avisa con un mensaje de error.
   cad = cad.SubString(c,lon-c+1);
   A  = Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,1));
   B  = Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,2));
   c1 = Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,3));
   c2 = Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,4));
   c3 = Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,5));
   e1 = Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,6));
   e2 = Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,7));
   e3 = Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,8));
   escalaVI = Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,9));
}
//---------------------------------------------------------------------------
AnsiString DatosPerfil::SaveToString(){
   // No se por qu pero a veces el valor de DecimalSeparator cambia de modo que
   // no es suficiente con asignarlo en Create FormCreate
   if(DecimalSeparator!='.')
      DecimalSeparator='.';
   return (AnsiString)"\"" + Nombre + "\" " +
           FloatToStr(A)  + " " + FloatToStr(B)  + " " +
           FloatToStr(c1) + " " + FloatToStr(c2) + " " + FloatToStr(c3) + " " +
           FloatToStr(e1) + " " + FloatToStr(e2) + " " + FloatToStr(e3) + " " +
           FloatToStr(escalaVI);
           // NOTA: FloatToStr no produce excepciones.
}
//---------------------------------------------------------------------------
void DatosPerfil::Asigna(DatosPerfil *p){
   if(p == NULL)
      return;

   c1=p->c1;  c2=p->c2;  c3=p->c3;
   e1=p->e1;  e2=p->e2;  e3=p->e3;
   A=p->A;    B=p->B;   
   escalaVI=p->escalaVI;
   Nombre = p->Nombre;
}
//---------------------------------------------------------------------------
DatosPerfil::DatosPerfil(){
   A=0; B=0;
   c1=0; c2=0; c3=0;
   e1=0; e2=0; e3=0;
   escalaVI=1;
   Nombre = "";
}
//---------------------------------------------------------------------------
DatosPerfil::DatosPerfil(DatosPerfil *p){
   Asigna(p);
}
//---------------------------------------------------------------------------
DatosPerfil::DatosPerfil(AnsiString cad){
   this->LoadFromString(cad);
}
//---------------------------------------------------------------------------
__fastcall TfrmRelieve::TfrmRelieve(TComponent* Owner)
        : TForm(Owner)
{
   Codigo= new TStringList();
   PerfilPorDefecto = new DatosPerfil();
   PerfilPorDefecto->A  = VD_A;
   PerfilPorDefecto->B  = VD_B;
   PerfilPorDefecto->c1 = VD_c1;
   PerfilPorDefecto->c2 = VD_c2;
   PerfilPorDefecto->c3 = VD_c3;
   PerfilPorDefecto->e1 = VD_e1;
   PerfilPorDefecto->e2 = VD_e2;
   PerfilPorDefecto->e3 = VD_e3;
   PerfilPorDefecto->Nombre = VD_NOMBRE;
   PerfilPorDefecto->escalaVI = VD_ESCALA_VI;
   PerfilActual     = new DatosPerfil(PerfilPorDefecto);
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::FormDestroy(TObject *Sender)
{
   // Antes de eliminar Codigo salvamos los perfiles.
   SalvarPerfiles();

   delete Codigo;
   delete PerfilActual;
   delete PerfilPorDefecto;
   DatosPerfil *p;
   for(int c=0; c < Lista->Items->Count; c++){
      p = (DatosPerfil *)(Lista->Items->Objects[c]);
      Lista->Items->Objects[c]=NULL;
      if( p != NULL ){
         delete p;
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::FormCreate(TObject *Sender)
{
   dlgSave->InitialDir = ExtractFileDir(Application->ExeName);
   dlgOpen->InitialDir = ExtractFileDir(Application->ExeName);
   // Inicializamos la apariencia de Canvas:
   Fondo( (TColor) COLOR_FONDO);
   Cuadricula(PASO_CUADRICULA,COLOR_LINEAS);
   // La variable global DecimalSeparator indica el carcter que se usan en las
   // funciones BCB para la conversin de formato de nmero reales. Por defecto
   // es una coma, y hay que cambiarla a punto por compatibilidad con X3D
   DecimalSeparator='.';
   // Las dimensiones de Cambas en pixels sern tb las dimensiones de la escena
   // X3D en metros, as conseguimos mantener la proporcin.
   pnlRes->Caption = IntToStr(Canvas->Width) + "x" + IntToStr(Canvas->Height);

   RellenaDatosPerfil(PerfilActual);

   // Rellenamos la lista con los perfiles del fichero de configuracin.
   CargarPerfiles();
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::Fondo(TColor c){
   Canvas->Canvas->Brush->Color = c;
   Canvas->Canvas->FillRect( TRect(0,0,Canvas->Width,Canvas->Height) );
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::Cuadricula(int paso,TColor c){
    int x,y;
    // Lneas horizontales:
    y=paso;
    Canvas->Canvas->Pen->Color = c;
    while( y < Canvas->Height ){
        Canvas->Canvas->PenPos = TPoint(0,y);
        Canvas->Canvas->LineTo(Canvas->Width,y);
        y+=paso;
    }
    x=paso;
    while( x < Canvas->Width ){
        Canvas->Canvas->PenPos = TPoint(x,0);
        Canvas->Canvas->LineTo(x,Canvas->Height);
        x+=paso;
    }
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnIniciarClick(TObject *Sender)
{
    PerfilActual->Asigna(PerfilPorDefecto);
    RellenaDatosPerfil(PerfilActual);
    for(int c=0; c < Lista->Items->Count; c++){
       if( Lista->Items->Objects[c] != NULL )
          delete (DatosPerfil *)Lista->Items->Objects[c];
    }
    Lista->Clear();
    if(rbModoRelieve->Checked)
      DibujarPuntos();
    else
      RepresentaGrafica();
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::DibujarPuntos(){
   Fondo( (TColor) COLOR_FONDO);
   Cuadricula(PASO_CUADRICULA,COLOR_LINEAS);
   AnsiString cad;
   int X,Y;

   Canvas->Canvas->Pen->Color   =  ITEM_COLOR_BORDE;
   Canvas->Canvas->Brush->Color =  ITEM_COLOR_INTERIOR;

   for(int c=0; c < Lista->Items->Count; c++){
      cad = Lista->Items->Strings[c];
      X = StrToInt(Utilidad.GetPalabra(cad,1));
      Y = StrToInt(Utilidad.GetPalabra(cad,2));
      Canvas->Canvas->Ellipse(X-ITEM_RADIO,Y-ITEM_RADIO,X+ITEM_RADIO,Y+ITEM_RADIO);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::edAKeyPress(TObject *Sender, char &Key)
{
   bool borrar = (Key == (char)8);
   bool punto =  (Key == '.');
   bool menos =  (Key == '-');
   bool numero = (Key <= '9') && (Key >= '0');
   if( !borrar && !numero && !punto && !menos )
      Key = '\0';
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::CanvasMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   if(!rbModoRelieve->Checked)
      return;
   // Tenemos que buscar el Punto X,Y entre la lista de puntos ya registrado:
   // Si lo encontramos lo seleccionamos y no hacemos nada ms. Si no lo
   // encontramos tenemos que aadir un punto nuevo en la posicin X,Y
   int posx,posy,dx,dy;
   AnsiString cad;
   bool encontrado=false;
   for(int c=0; c < Lista->Items->Count; c++){
      cad = Lista->Items->Strings[c];
      posx=StrToInt(Utilidad.GetPalabra(cad,1));
      posy=StrToInt(Utilidad.GetPalabra(cad,2));
      dx= posx-X;
      dy= posy-Y;
      // Hacemos el valor absoluto para comparar distancias.
      if(dx<0) dx*=-1;
      if(dy<0) dy*=-1;
      if( (dx<= ITEM_RADIO) && (dy<= ITEM_RADIO) ){
          encontrado=true;
          Lista->ItemIndex=c;
          ListaClick(NULL);
          c = Lista->Items->Count;  // (para salir del bucle).
      }
   }

   if(!encontrado){
       // El punto no se ha encontrado hay que registrarlo.
       cad = IntToStr(X);
       // Hacemos que los datos se muestren alineados en columnas.
       while(cad.Length() < LONG_COLUMNA1)  cad = cad + " ";
       cad = cad + IntToStr(Y);
       while(cad.Length() < LONG_COLUMNA2)  cad = cad + " ";
       cad = cad + PerfilActual->Nombre;

       Lista->Items->Append(cad);

       // Dibujamos el punto en Canvas:
       Canvas->Canvas->Pen->Color   =  ITEM_COLOR_BORDE;
       Canvas->Canvas->Brush->Color =  ITEM_COLOR_INTERIOR;
       Canvas->Canvas->Ellipse(X-ITEM_RADIO,Y-ITEM_RADIO,X+ITEM_RADIO,Y+ITEM_RADIO);

       // Aadimos los datos del perfil actual:
       Lista->Items->Objects[Lista->Items->Count-1] = (TObject *) (new DatosPerfil(PerfilActual));

       // Finalmente hacemos que el elemento aadido aparezca marcado:
       Lista->ItemIndex=Lista->Items->Count-1;
       ListaClick(NULL);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnBorrarClick(TObject *Sender)
{
   if( -1 == Lista->ItemIndex )
      return;
   DatosPerfil *p = (DatosPerfil *) Lista->Items->Objects[Lista->ItemIndex];
   if(p != NULL)
     delete p;
   Lista->Items->Delete(Lista->ItemIndex);
   Fondo((TColor)COLOR_FONDO);
   Cuadricula(PASO_CUADRICULA,COLOR_LINEAS);
   DibujarPuntos();
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::ListaKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(VK_DELETE == Key)
      btnBorrarClick(NULL);
}
//------------------------------------------------------------------------------
bool __fastcall TfrmRelieve::GenerarRelieve(){

   float Paso;
   if(edResolucion->Text.Trim() == ""){
      int max = (Canvas->Width > Canvas->Height) ? Canvas->Width : Canvas->Height;
      ShowMessage("You must specify a number between 0 and " + IntToStr(max) + " (both values not includes)");
      return false;
   }
   if(!Utilidad.PasaStrAFloat(edResolucion->Text.Trim(),Paso))
      return false;

   if( fabs(Paso) < 3)
   {
      ShowMessage("The step must be >= 3");
      return false;
   }
   int N = (int)(Canvas->Width / Paso);
   int M = (int)(Canvas->Height / Paso);

   // El principio del fichero X3D est en CdigoBasico.
   Codigo->Assign(CodigoBasico->Lines);

   // Aqui se crea el campo coordIndex:
   {
      int p;
      for(int n=0; n < N-1; n++){
         for(int m=0; m < M-1; m++){
            p = m*N + n;
             Codigo->Append( IntToStr( p )   + " " + IntToStr(p+1)  + " " +
                             IntToStr(p+N+1) + " " + IntToStr(p+N)  + " -1");
         }
      }
   }
   Codigo->Append("                '>");
   Codigo->Append("           <Coordinate");
   Codigo->Append("           point = '");

   {
      // Con dos bucles for obtenemos todos los puntos x,z del plano sobre el que
      // se eleva el relieve.

      frmUtilidad->IniciaProgreso("Creating Relief...",M,"",false);

      Punto3D p;
      float nf,mf;
      for(int m=0; m < M; m++){
         frmUtilidad->ActualizaProgreso(m,"");
         mf=(float)m;
         for(int n=0; n < N; n++){
             nf=(float)n;
             p.x = Paso * nf;
             p.z = Paso * mf;
             // Llamamos a la funcin que nos dar la altura segn los datos actuales:
             p.y = Evalua(p.x,p.z);

             // Un caso especial es el ltimo punto que se aada, no debe tener la coma final.
             if( (m == (M-1)) && (n == (N-1)) )
                Codigo->Append(p.ToString());
             else
                Codigo->Append(p.ToString() + ",");
         }
      }
      frmUtilidad->FinalizaProgreso();
      this->Repaint();
   }
   // Aadimos ms lneas al fichero X3D.
   Codigo->Append("                     '/>");
   Codigo->Append("         </IndexedFaceSet>");
   Codigo->Append("      </Shape>");
   Codigo->Append("   </Transform>");
   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnPruebaClick(TObject *Sender)
{
    // Generamos el relieve en cdigo:
    if(!GenerarRelieve())
       return;
    // Ya tenemos en Cdigo el relieve -> Lo salvamos en el fichero de prueba
    // que crearemos en la carpeta del programa:

    AnsiString file = Main->CARPETA_PROGRAMA + "\\" + FICH_PRUEBA;
    AnsiString carpeta = Main->CARPETA_PROGRAMA;

    Codigo->SaveToFile(file);
    // Abrimos el fichero con el programa que abre los ficheros X3D por defecto.
    //ShellExecute( this->Handle, "open", file.c_str(),"", carpeta.c_str(), SW_SHOWMAXIMIZED);
    AnsiString pathExplorer = (AnsiString)"\"" + CONF.PATH_EXPLORER + "\"";
    file = (AnsiString)"\"" + file + "\"";
    carpeta = (AnsiString)"\"" + carpeta + "\"";
    ShellExecute( this->Handle, "", pathExplorer.c_str(), file.c_str(), carpeta.c_str(), SW_SHOWMAXIMIZED);
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if(Msg.CharCode == VK_F1)
      Main->Ayuda();
   // Capturamos las pulsaciones de teclado para ejecutar la escena con F9.
   // Hay que solucionar un problema: Tenemos que distinguir cuando se pulsa la
   // tecla F9 y cuando se suelta -> Usamos un booleano.
   static bool EsperandoKeyUp = true;
   if(Msg.CharCode == VK_F9){
      if(EsperandoKeyUp){
         EsperandoKeyUp = (Msg.KeyData & 0x40000000);
      }else{
         btnPruebaClick(NULL);
         EsperandoKeyUp=true;
      }
   }
}
//---------------------------------------------------------------------------
float __fastcall TfrmRelieve::Evalua(float x,float z){
   float v=0;
   float d;
   for(int c=0; c < Lista->Items->Count; c++){
      d = EvaluaExprNum(c,x,z);
      if(!rbModoUsarMaximo->Checked)
         v =  v + d;
      else
         v =  (v > d) ?  + v : d;
   }
   return v;
}
//---------------------------------------------------------------------------
float __fastcall TfrmRelieve::EvaluaExprNum(int i,float x,float z){
   AnsiString cad = Lista->Items->Strings[i];
   float posx,posz;
   if(!Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,1),posx))   return 0.0;
   if(!Utilidad.PasaStrAFloat(Utilidad.GetPalabra(cad,2),posz))   return 0.0;

   // Obtenemos los datos asociados a la expresin i:
   DatosPerfil *p = (DatosPerfil *) Lista->Items->Objects[i];

   // Con try no se pueden capturar algunos mensajes de error que da pow as que
   // intentamos evitarlos asi:
   if(p->e1 <= 0.0001) p->e1=1;
   if(p->e2 <= 0.0001) p->e2=1;
   if(p->e3 <= 0.0001) p->e3=1;


   // Este cambio de variable nos desplaza al punto donde queremos crear la montaa.
   x = x-posx;
   z = z-posz;
   // Obtenemos vi (variable independiente) de modo que tengamos simeria de revolucin
   // respecto a posx, posy
   double vi = sqrt(x*x + z*z);
   vi=vi*p->escalaVI;
   // El ltimo paso es evaluar la funcin.
   // A/(B + c1*x^e1+c2*x^e2+c3*x^e3)
   double v;
   try{ v = p->A / ( p->B + p->c1*pow2(vi,p->e1) + p->c2*pow2(vi,p->e2) + p->c3*pow2(vi,p->e3) ); }
   catch(...){v=0;}

   return v;
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::ListaClick(TObject *Sender)
{
   if( Lista->ItemIndex == -1 )
      return;
   AnsiString cad = Lista->Items->Strings[Lista->ItemIndex];
   int X = StrToInt(Utilidad.GetPalabra(cad,1));
   int Y = StrToInt(Utilidad.GetPalabra(cad,2));

   DatosPerfil *p = (DatosPerfil *)Lista->Items->Objects[Lista->ItemIndex];
   PerfilActual->Asigna(p);
   RellenaDatosPerfil(p);

   if(rbModoRelieve->Checked){
      // Dibujamos todos los puntos para borrar el punto seleccionado anteriormente.
      DibujarPuntos();
      // Seleccionamos el punto actual.
      Canvas->Canvas->Pen->Color = COLOR_SEL;
      int R;
      R=RADIO_SEL1; Canvas->Canvas->Arc(X-R,Y-R,X+R,Y+R,X-R,Y,X-R,Y);
      R=RADIO_SEL2; Canvas->Canvas->Arc(X-R,Y-R,X+R,Y+R,X-R,Y,X-R,Y);
      R=RADIO_SEL3; Canvas->Canvas->Arc(X-R,Y-R,X+R,Y+R,X-R,Y,X-R,Y);
   }else{
      RepresentaGrafica();
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::edAKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   // Cuando se pulsa intro sobre alguno de los TEdit hay que actualizar los datos.
   if(VK_RETURN == Key)
      SalvaIndicadores();
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnSalvarRelieveClick(TObject *Sender)
{
   // Obtenemos la ruta que indique el usuario.
   if( (!rbModoRelieve->Checked) || !dlgSave->Execute())
      return;
   // Usamos cdigo para salvar el fichero. En cada lnea guardaremos la
   // informacin asociada a cada montaa. Las dos primeras palabras sern
   // las coordenadas que contiene Lista. El resto de la cadena ser la
   // informacin que se obtiene de SaveToString de DatosPerfil.
   Codigo->Clear();
   DatosPerfil *p;
   AnsiString cad,pal1,pal2;
   for(int c=0; c < Lista->Items->Count; c++){
      p =(DatosPerfil *)Lista->Items->Objects[c];
      cad = Lista->Items->Strings[c];
      pal1 = Utilidad.GetPalabra(cad,1);
      pal2 = Utilidad.GetPalabra(cad,2);      
      Codigo->Append(pal1 + " " + pal2 + " "  + p->SaveToString());
   }
   // Escribimos el fichero.
   Codigo->SaveToFile(dlgSave->FileName);
}

//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnCargarRelieveClick(TObject *Sender)
{
   // Obtenemos la ruta del fichero que el usuario desea abrir.
   if( (!rbModoRelieve->Checked) || !dlgOpen->Execute())
      return;
   if(!FileExists(dlgOpen->FileName) )
      return;
   // Cargamos los datos en codigo.
   Codigo->LoadFromFile(dlgOpen->FileName);
   // Vamos a rellenar lista con los datos de Codigo, creando objetos DatosPefil
   // que sern apuntados por Lista->Items->Objects.
   Lista->Items->Clear();
   AnsiString cad,dato;
   DatosPerfil *p;
   for(int c=0; c < Codigo->Count; c++){
      // Con cada iteracin aadimos una nueva lnea a Lista y creamos un objeto
      // DatosPerfil.
      dato = Codigo->Strings[c];
      cad = Utilidad.CortaPrimeraPalabra(dato) + " ";
      // Usamos while para alinear los datos en columnas.
      while(cad.Length() < LONG_COLUMNA1)  cad = cad + " ";
      cad = cad + Utilidad.CortaPrimeraPalabra(dato) + " ";
      while(cad.Length() < LONG_COLUMNA2)  cad = cad + " ";
      p=new DatosPerfil(dato);
      if(p != NULL)
         cad = cad + p->Nombre;

      Lista->Items->Append(cad);
      Lista->Items->Objects[c] = (TObject *)p;
   }
   if(Lista->Items->Count > 0)
      Lista->ItemIndex=0;

   DibujarPuntos();
   ListaClick(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::RepresentaGrafica(){

   if( PerfilActual == NULL)
      return;

   // Actualizamos los indicadores con los datos de PefilActual:
   DatosPerfil *p = PerfilActual;
   RellenaDatosPerfil(p);

   // Con try no se pueden capturar algunos mensajes de error que da pow as que
   // intentamos evitarlos asi:
   if(p->e1 <= 0.0001) p->e1=1;
   if(p->e2 <= 0.0001) p->e2=1;
   if(p->e3 <= 0.0001) p->e3=1;

   // Limpiamos el fondo:
   Fondo( (TColor) COLOR_FONDO);
   Cuadricula(PASO_CUADRICULA,COLOR_LINEAS);
   Canvas->Canvas->Pen->Color = COLOR_GRAFICA;

   double vi,fdvi,deno;

   bool inicio=true;
   int y;
   // Evitamos las posibles excepciones con try
   try{
      // Recorremos el eje horizontal con un bucle for:
      for(int c=0; c < Canvas->Width; c++){
         vi= p->escalaVI * (double)c;
         // Evaluamos la funcion en c.
         deno = ( p->B + p->c1*pow2(vi,p->e1) + p->c2*pow2(vi,p->e2) + p->c3*pow2(vi,p->e3) );
         if( fabs(deno) > 0.00001 )
            fdvi = p->A / deno;
         else
            fdvi = 1;

         y = (int) ((double)Canvas->Height/2 - fdvi);
         if( (y <= Canvas->Height) && (y >= 0) ){
             if(inicio){
                Canvas->Canvas->PenPos= TPoint(c,y);
                inicio=false;
             }else{
               Canvas->Canvas->LineTo(c,y);
             }
         }
      }
   }catch(...){  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::rbModoRelieveClick(TObject *Sender)
{
     DibujarPuntos();
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::rbModoPerfilesClick(TObject *Sender)
{
     RepresentaGrafica();
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnAceptarClick(TObject *Sender)
{
   ModalResult = mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnEliminarPerfilClick(TObject *Sender)
{
   // Tenemos que eliminar el perfil seleccionado en lbListaPerfiles
   if(-1 == ListaPerfiles->ItemIndex)
      return;
   DatosPerfil *p = (DatosPerfil *)ListaPerfiles->Items->Objects[ListaPerfiles->ItemIndex];
   if(p != NULL)
      delete p;
   ListaPerfiles->Items->Delete(ListaPerfiles->ItemIndex);
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::RellenaDatosPerfil(DatosPerfil *p){
   if(p == NULL)
      return;
   // No se por qu pero a veces el valor de DecimalSeparator cambia de modo que
   // no es suficiente con asignarlo en Create FormCreate
   if(DecimalSeparator!='.')
      DecimalSeparator='.';
   // Actualizamos los indicadores (no se producen excepciones en FloatToStr()
   edA->Text  = FloatToStr(p->A);
   edB->Text  = FloatToStr(p->B);
   edc1->Text = FloatToStr(p->c1);
   edc2->Text = FloatToStr(p->c2);
   edc3->Text = FloatToStr(p->c3);
   ede1->Text = FloatToStr(p->e1);
   ede2->Text = FloatToStr(p->e2);
   ede3->Text = FloatToStr(p->e3);
   edEscalaVI->Text = FloatToStrF(p->escalaVI,ffFixed,5,5);
   edNombrePerfil->Text = p->Nombre;
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnAnadirPerfilClick(TObject *Sender)
{
   if(PerfilActual == NULL)
      return;
   if(!rbModoPerfiles->Checked ){
      Utilidad.MsgInfo("To save a contour you need to be in <Contour Design Mode>.");
      return;
   }
   if(PerfilActual->Nombre.Trim() == ""){
      Utilidad.MsgInfo("You must specify the current contour.");
      return;
   }
   SalvaIndicadores();
   DatosPerfil *p = new DatosPerfil(PerfilActual);
   ListaPerfiles->Items->Append(p->Nombre);
   int index = ListaPerfiles->Items->IndexOf(p->Nombre);
   ListaPerfiles->Items->Objects[index] = (TObject *)p;
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::ListaPerfilesKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(VK_DELETE == Key)
      btnEliminarPerfilClick(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::ListaPerfilesClick(TObject *Sender)
{
   if(-1 == ListaPerfiles->ItemIndex)
      return;
   DatosPerfil *p = (DatosPerfil *) ListaPerfiles->Items->Objects[ListaPerfiles->ItemIndex];
   if( p != NULL){
      PerfilActual->Asigna(p);
      RellenaDatosPerfil(PerfilActual);
   }
   if(rbModoPerfiles->Checked)
      RepresentaGrafica();
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::CargarPerfiles(){

   AnsiString file = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION +
                                              "\\" + FICH_PERFILES;

    DatosPerfil *p;
    if(FileExists(file)){
       Codigo->LoadFromFile(file);
       for(int c=0; c < Codigo->Count; c++){
          p = new DatosPerfil(Codigo->Strings[c]);
          if(p != NULL){
             ListaPerfiles->Items->Append(p->Nombre);
             int index = ListaPerfiles->Items->IndexOf(p->Nombre);
             ListaPerfiles->Items->Objects[index] = (TObject *)p;
          }
       }
    }
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::SalvarPerfiles(){

   AnsiString file = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION +
                                              "\\" + FICH_PERFILES;
   DatosPerfil *p;
   Codigo->Clear();
   for(int c=0; c < ListaPerfiles->Items->Count; c++){
      p = (DatosPerfil *)ListaPerfiles->Items->Objects[c];
      if(p != NULL)
         Codigo->Append(p->SaveToString());
   }
   Codigo->SaveToFile(file);
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::edNombrePerfilKeyPress(TObject *Sender, char &Key)
{
   if(Key == (char) 13){
      Key = '\0';
      WORD k = VK_RETURN;
      edAKeyDown(NULL,k,TShiftState());
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::SalvaIndicadores(){

   DatosPerfil *p;
   // Asignamos p a la direccin del objeto DatosPerfil que tendremos que
   // actualizar segn el caso:
   if( (rbModoPerfiles->Checked) || (Lista->ItemIndex == -1) || (Lista->Items->Objects[Lista->ItemIndex] == NULL) )
      p=PerfilActual;
   else{
      p = (DatosPerfil *)Lista->Items->Objects[Lista->ItemIndex];
      // En este caso ha podido cambiar el nombre del perfil:
      AnsiString cad = Lista->Items->Strings[Lista->ItemIndex];
      AnsiString pal1 = Utilidad.GetPalabra(cad,1);
      AnsiString pal2 = Utilidad.GetPalabra(cad,2);

      cad=pal1;
      while(cad.Length() < LONG_COLUMNA1)  cad = cad + " ";
      cad = cad + pal2;
      while(cad.Length() < LONG_COLUMNA2)  cad = cad + " ";
      cad = cad + edNombrePerfil->Text;

      Lista->Items->Strings[Lista->ItemIndex]=cad;
   }

   // Actualizamos el objeto Datos perfil apuntado por p.
   p->A  = Utilidad.PasaStrAFloat(edA->Text);
   p->B  = Utilidad.PasaStrAFloat(edB->Text);
   p->c1 = Utilidad.PasaStrAFloat(edc1->Text);
   p->c2 = Utilidad.PasaStrAFloat(edc2->Text);
   p->c3 = Utilidad.PasaStrAFloat(edc3->Text);
   p->e1 = Utilidad.PasaStrAFloat(ede1->Text);
   p->e2 = Utilidad.PasaStrAFloat(ede2->Text);
   p->e3 = Utilidad.PasaStrAFloat(ede3->Text);
   p->escalaVI = Utilidad.PasaStrAFloat(edEscalaVI->Text);
   p->Nombre = edNombrePerfil->Text;

   // Si estamos en el caso ModPerfil, la grfica ha podido cambiar -> As
   // que la actualizamos.
   if(rbModoPerfiles->Checked)
      RepresentaGrafica();
}
//---------------------------------------------------------------------------
bool __fastcall TfrmRelieve::Inicia(TStringList *relieve){

   Caption = (AnsiString)"3D Relief Generator - " + NOMBRE_DEL_PROGRAMA;

   int devuelto=ShowModal();

   // Antes de volver intentamos borrar el fichero de prueba:
   /*  Prefiero no salvar el fichero porque al estar en la carpeta del programa
     no tienen sentido crearlo y borrarlo continuamente, es mejor no borrarlo. 
   AnsiString file = Main->CARPETA_PROGRAMA + "\\" + FICH_PRUEBA;
   if(FileExists(file)){
       try{DeleteFile(file); }
       catch(...){} // No es necesario dar un mensaje de error
   }
   */
   
   if(mrOk == devuelto){

       // Generamos el relieve en cdigo:
       if(!GenerarRelieve())
          return false;

       // Ya tenemos en Codigo el relieve -> Lo lo asignamos a Codigo.
       Screen->Cursor=PUNT_RATON_ESPERA;
       relieve->Text = Codigo->Text;
       Screen->Cursor=PUNT_RATON_NORMAL;

       return true;
   }
   return false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnCancelarClick(TObject *Sender)
{
   ModalResult = mrCancel;
}
//---------------------------------------------------------------------------
void __fastcall TfrmRelieve::btnAyudaClick(TObject *Sender)
{
   Main->Ayuda();        
}
//---------------------------------------------------------------------------




