//
//     CLASE   frmIndiceNodos  
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Lista todos los nodos y permite seleccionar uno de ellos.
*/

//---------------------------------------------------------------------------

#ifndef IndiceNodos_H
#define IndiceNodos_H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ImgList.hpp>
#include <Buttons.hpp>
#include "GestorNodos_.h"
#include "Main_.h"

//---------------------------------------------------------------------------
class TfrmIndiceNodos : public TForm
{
__published:	// IDE-managed Components
     TImageList *ListaImagenes;
     TSpeedButton *sbVolver;
     TSpeedButton *sbDetalles;
     TSpeedButton *sbSiguiente;
     TSpeedButton *sbAnterior;
     TSpeedButton *sbAnadir;
        TSpeedButton *sbH3D;
        TSpeedButton *sbX3D;
        TSpeedButton *sbAyuda;
     TListView *ListaNodos;
     TListBox *ListaCat;
     TLabel *lbCategorias;
     TLabel *lbNodos;
        TListBox *lbRecientes;
     TLabel *Label1;
        TSpeedButton *sbTransform;
     void __fastcall sbVolverClick(TObject *Sender);
     void __fastcall sbSiguienteClick(TObject *Sender);
     void __fastcall sbAnteriorClick(TObject *Sender);
     void __fastcall sbDetallesClick(TObject *Sender);
     void __fastcall ListaNodosDblClick(TObject *Sender);
     void __fastcall sbAnadirClick(TObject *Sender);
     void __fastcall sbH3DClick(TObject *Sender);
     void __fastcall sbX3DClick(TObject *Sender);
     void __fastcall ListaNodosKeyDown(TObject *Sender, WORD &Key,TShiftState Shift);
     void __fastcall ListaCatClick(TObject *Sender);
     void __fastcall ListaCatKeyUp(TObject *Sender, WORD &Key,TShiftState Shift);
     void __fastcall ListaNodosEnter(TObject *Sender);
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall FormDestroy(TObject *Sender);
        void __fastcall FormShow(TObject *Sender);
        void __fastcall ListaNodosAdvancedCustomDraw(
          TCustomListView *Sender, const TRect &ARect,
          TCustomDrawStage Stage, bool &DefaultDraw);
        void __fastcall sbAyudaClick(TObject *Sender);
        void __fastcall sbTransformClick(TObject *Sender);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
private:	// User declarations

     // Esta ventana se puede usar de dos modos:
     //  - Para mostrar informacin sobre los nodos.
     //  - Para elegir un nodo.
     // Para distinguir estos dos casos se usa la variable ElegirNodo.
     bool ElegirNodo;

     // Es el nombre del nodo que se ha elegido.
     AnsiString NodoElegido;

     // Un nodo se puede seleccionar de dos modos, para incluirlo en un nodo
     // transform o no, con esta variable sabremos cmo se ha decidido aadir.
     bool EnTransform;

     // Es un puntero a un objeto de la clase GestorNodos. Se asigna en la
     // funcin Inicia.
     GestorNodos *GN;

     // Recibe el nombre de un nodo y devuelve verdadero si ese nodo tiene
     // 0 campos X3D y false en otro caso.
     bool __fastcall NodoAbstracto(AnsiString nodo);

     // Rellena los tabs usando la informacin de GN.
     void __fastcall CargarDatos();

     // Rellena la lista de iconos con los nodos del tipo asociado a indexListaCat
     void __fastcall RellenaLista(int indexListaCat);

     // Procesa el nodo que este seleccionado actualmente. En primer lugar se
     // determina cual es ese nodo viendo si el foco est en lbRecientes o en
     // ListaNodos. Y a continuacin vemos si Elegir nodo es true o false y segn
     // su valor devolvemos el nodo seleccionado o iniciamos frmDetallesNodo.
     void __fastcall ProcesarNodoActual();


     // Caso genrico para las funciones inicia que muestran esta pantalla:
     // gn -> Puntero al gestor de nodos.
     // elegirNodo -> Para saber el modo de funcionamiento: Ver  Seleccionar nodos.
     // enTransform -> Da informacin de salida sobre si se ha seleccionado un nodo
     //                con el botn transform o con el botn anadir.
     //                Si se pasa a false no se mostrar el botn Transform
     // nombreCampo -> indica el nombre del campo SFNode o MFNode al que se le
     //                va a aadir el nodo que se elija (esto se usa para
     //                seleccionar un nodo inicial).
     // devuelve una cadena con el nombre del nodo seleccionado, si no se
     // - Selecciona ningn nodo se devuelve NULL.
     AnsiString __fastcall Inicia(GestorNodos *gn, bool elegirNodo,
                                  bool &enTransform,AnsiString nombreCampo="");

public:
     // Constructpor y destructor:
     __fastcall TfrmIndiceNodos(TComponent* Owner);

     // La siguientes funciones muestran la ventana. Esta ventana se puede usar
     // de dos modos:
     //  - Para mostrar informacin sobre los nodos.
     //  - Para elegir un nodo.
     // Cada una de las funciones se asocia a uno de estos modos:
     // En ambos casos se necesita un puntero al gestor de nodos:
     // IniciaElegirNodo devolver una cadena con el nombre del nodo. Si no se
     // selecciona ningn nodo devolver "".
     // enTransform se usa como variable de salida para indicar si se ha
     // seleccionado el nodo con el botn aadir (enTransform ser false) o
     // con el botn transform. Si se pasa a false no se mostrar el botn Transform.
     // NombreCampo indica el nombre del campo SFNode o MFNode al que se le va a
     // aadir el nodo que se elija (esto se usa para seleccionar un nodo inicial).
     AnsiString __fastcall IniciaElegirNodo(GestorNodos *gn,bool &enTransform, AnsiString NombreCampo="");
     void __fastcall IniciaVerNodos(GestorNodos *gn);

};
//---------------------------------------------------------------------------
extern PACKAGE TfrmIndiceNodos *frmIndiceNodos;
//---------------------------------------------------------------------------
#endif
