//
//     CLASE   frmIndiceNodos  
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Lista todos los nodos y permite seleccionar uno de ellos.
*/


//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "frmIndiceNodos_.h"
#include "Utilidad_.h"
#include "frmDetallesNodo_.h"
#include "frmUtilidad_.h"
#include "Configuracion_.h"
#include "frmEscena_.h"

// Es el ttulo que llevar el tab que contiene todos los nodos (valor mn 1).
#define TITULO_TAB_PARA_TODOS_LOS_NODOS "All Nodes"

// Es el nmero de ficheros recientes que habr en la lista.
#define NUM_FICHEROS_RECIENTES 8

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmIndiceNodos *frmIndiceNodos;

//---------------------------------------------------------------------------
__fastcall TfrmIndiceNodos::TfrmIndiceNodos(TComponent* Owner)
     : TForm(Owner)
{
    GN=NULL;
    EnTransform=false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::RellenaLista(int indexListaCat){
     TListColumn *Columna;
     TListItem *nuevoitem;
     Nodo *nodo;
     int lastindex;

     if( (0 == ListaCat->Items->Count) || (indexListaCat < 0) || (indexListaCat >= ListaCat->Items->Count) )
          return; // No hay cadenas en el Tab -> salimos.

     ListaNodos->Items->Clear();

     lastindex=ListaCat->Items->Count-1;
     if(indexListaCat == lastindex){
          // Aadimos todos los nodos.
          for(int i=0; i < GN->GetNumNodos(); i++){
                nodo=GN->DatosNodo(i);
                nuevoitem=ListaNodos->Items->Add();
                nuevoitem->ImageIndex=i;
                nuevoitem->Caption=(AnsiString)nodo->nombre;
          }
     }else{
          for(int i=0; i < GN->GetNumNodos(); i++){
               nodo=GN->DatosNodo(i);
               if(  ((AnsiString)(nodo->tipo)) == ListaCat->Items->Strings[indexListaCat] ){
                    nuevoitem=ListaNodos->Items->Add();
                    nuevoitem->ImageIndex=i;
                    nuevoitem->Caption=(AnsiString)nodo->nombre;
               }
          }
     }
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::sbVolverClick(TObject *Sender)
{
   NodoElegido="";
   Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::sbSiguienteClick(TObject *Sender)
{
     if(ListaCat->ItemIndex+1 < ListaCat->Items->Count ){
         ListaCat->ItemIndex++;
         RellenaLista(ListaCat->ItemIndex);
     }
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::sbAnteriorClick(TObject *Sender)
{
     if(ListaCat->ItemIndex > 0){
         ListaCat->ItemIndex--;
         RellenaLista(ListaCat->ItemIndex);
     }
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::sbDetallesClick(TObject *Sender)
{
     // Mostramos la ventana de detalles del nodo actualmente seleccionado.
     // Si el nodo no existe no se mostrar la ventana.
     if( NULL != ListaNodos->ItemFocused){
         if(GN->tipoEscena == ESCENA_X3D)
              frmDetallesNodo->Inicia(Main->GNX,Main->GTX,ListaNodos->ItemFocused->Caption);
         else
              frmDetallesNodo->Inicia(Main->GNH,Main->GTH,ListaNodos->ItemFocused->Caption);
     }
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::ListaNodosDblClick(TObject *Sender)
{
   ProcesarNodoActual();
}
//------------------------------------------------------------------------------
AnsiString __fastcall TfrmIndiceNodos::IniciaElegirNodo(GestorNodos *gn,bool &enTransform,
                                                        AnsiString NombreCampo){
   return Inicia(gn,true,enTransform,NombreCampo);
}
//------------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::IniciaVerNodos(GestorNodos *gn){

   bool enTransform=false;
   Inicia(gn,false,enTransform);
}

//------------------------------------------------------------------------------
AnsiString __fastcall TfrmIndiceNodos::Inicia(GestorNodos *gn, bool elegirNodo,bool &enTransform,AnsiString nombreCampo)
{
     if(gn==NULL)
        return "";
     Screen->Cursor=PUNT_RATON_ESPERA;        
     GN=gn;
     ElegirNodo=elegirNodo;
     NodoElegido="";
     sbAnadir->Visible=ElegirNodo;
     sbTransform->Visible=enTransform;
     if(GN->tipoEscena == ESCENA_X3D)
         Caption="X3D Nodes";
     else
         Caption="H3D Nodes";

     // Ahora cargamos todos los datos de los nodos usando GN.
     CargarDatos();

     // Seleccionamos la ltima categora.
     if(ListaCat->Items->Count > 0){
        ListaCat->ItemIndex=ListaCat->Items->Count-1;
        RellenaLista(ListaCat->ItemIndex);
     }

     // Seleccionamos el primer nodo de la lista. Y posteriormente veremos
     // si es ms adecuado seleccionar otro nodo.
     if( ListaNodos->Items->Count > 0){
         this->ActiveControl = ListaNodos;
         ListaNodos->Selected = ListaNodos->Items->Item[0];
         ListaNodos->ItemFocused=ListaNodos->Items->Item[0];
     }

     // Si nombreCampo != "" Intentamos seleccionar ese nombre en la ListaNodos:
     nombreCampo=nombreCampo.Trim();
     nombreCampo=nombreCampo.UpperCase();

     if(nombreCampo != ""){

        // Ahora vemos cuando el nombre del campo le debemos asociar una
        // categora en lugar de un nodo.
        int index;
        if(nombreCampo == "SURFACE"){
           // Lo primero es buscar Surface entre las categorias.
           index=ListaCat->Items->IndexOf("Surfaces");
           if( -1 != index){
              ListaCat->ItemIndex=index;
              RellenaLista(index);
              // Seleccionamos el primer nodo de la categora cargada.
              if( ListaNodos->Items->Count > 0){
                  ListaNodos->Selected = ListaNodos->Items->Item[0];
                  ListaNodos->ItemFocused=ListaNodos->Items->Item[0];
              }
           }
        }else if(nombreCampo == "GEOMETRY"){
           // Lo primero es buscar Surface entre las categorias.
           index=ListaCat->Items->IndexOf("Geometries");
           if( -1 != index){
              ListaCat->ItemIndex=index;
              RellenaLista(index);
              // Seleccionamos el primer nodo de la categora cargada.
              if( ListaNodos->Items->Count > 0){
                  ListaNodos->Selected = ListaNodos->Items->Item[0];
                  ListaNodos->ItemFocused=ListaNodos->Items->Item[0];
              }
           }
        }else{
             // Algunos casos especiales de nombres de campos que no se parecen al
             // nombre del nodo que se le debe asociar por defecto.
             if(nombreCampo == "TEXTURE")  nombreCampo = "IMAGETEXTURE";
             if(nombreCampo == "TEXCOORD") nombreCampo = "TEXTURECOORDINATE";
             if(nombreCampo == "COORD")    nombreCampo = "COORDINATE";
             if(nombreCampo == "IFS")      nombreCampo = "INDEXEDFACESET";
             if(nombreCampo == "ITS")      nombreCampo = "INDEXEDTRIANGLESET";
             if(nombreCampo == "HINTS")    nombreCampo = "CACHEHINTS";

             // Vamos a buscar nombreCampo en la lista de todos los nodos y si
             // encontramos un nodo llamado nombreCampo lo selecionamos. Si no
             // lo encontramos, seleccionaremos el primer nodo cuya 1 letra
             // coincida con la 1 letra de nombreCampo.
             bool encontrado=false;
             AnsiString nodoActual;
             int indexNodoPrimeraLetra=-1;

             for(int c=0; c < ListaNodos->Items->Count; c++){
                nodoActual = ListaNodos->Items->Item[c]->Caption.UpperCase();
                if( nodoActual == nombreCampo){
                   ListaNodos->Selected = ListaNodos->Items->Item[c];
                   ListaNodos->ItemFocused=ListaNodos->Items->Item[c];
                   encontrado=true;
                   // Salimos del bucle.
                   c = ListaNodos->Items->Count;
                }
                // Por si no encontramos el nodo buscamos un nodo que comience con
                // la misma letra que nombreCampo.
                if( (indexNodoPrimeraLetra == -1) && (nodoActual!= "") &&
                    (nodoActual[1] == nombreCampo[1]) )
                    indexNodoPrimeraLetra=c;
             }
             // Si no hemos encontrado ningn nodo entonces intentamos seleccionar
             // un nodo que empiece por la misma letra.
             if(!encontrado){
                if( -1 != indexNodoPrimeraLetra){
                   ListaNodos->Selected = ListaNodos->Items->Item[indexNodoPrimeraLetra];
                   ListaNodos->ItemFocused=ListaNodos->Items->Item[indexNodoPrimeraLetra];
                } // else: En otro caso ya se seleccion el primer nodo.
             }
        }
     }

     // Acabamos de seleccionar un nodo, ahora vamos a hacer que se vea aunque
     // sea necesario hacer un scroll.
     if( ListaNodos->Selected != NULL)
        ListaNodos->Selected->MakeVisible(false);

     EnTransform=false;

     Screen->Cursor=PUNT_RATON_NORMAL;
     
     ShowModal();

     enTransform=EnTransform;
     
     if(ElegirNodo){
        if(NodoAbstracto(NodoElegido))
           return "";
        else
           return NodoElegido;
     }else
        return "";
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::sbAnadirClick(TObject *Sender)
{
    EnTransform=false;
    ProcesarNodoActual();
}
//---------------------------------------------------------------------------
bool __fastcall TfrmIndiceNodos::NodoAbstracto(AnsiString nodo)
{
   Nodo *pn;
   pn=GN->DatosNodo(nodo);
   if(pn==NULL)
        return false;
   return (0 == pn->numCampos);
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::CargarDatos()
{
     // En primer lugar rellenamos la lista de imgenes.
     Graphics::TBitmap *imagen;
     Nodo *nodo;

     try{ imagen=new Graphics::TBitmap; }
     catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

     ListaImagenes->Clear();
     ListaImagenes->Masked=false;
     for(int i=0; i < GN->GetNumNodos(); i++){
          nodo=GN->DatosNodo(i);
          if(GN->tipoEscena == ESCENA_X3D)
             Utilidad.GetImagen(imagen,nodo->icono,CONF.ICONO_GENERAL_NODO_X3D);
          else
             Utilidad.GetImagen(imagen,nodo->icono,CONF.ICONO_GENERAL_NODO_H3D);

          ListaImagenes->Add(imagen,NULL);
     }
     delete imagen;

     // Vinculamos la lista de imgenes al objeto lista:
     ListaNodos->SmallImages=ListaImagenes;

     // Recorremos todos los tipos de nodos y para cada tipo buscamos los
     // nodos de ese tipo y los aadimos a cada columna.
     // (Las categoras hay que rellenarlas cada vez que se llame a la funcin porque
     // podemos recibir el gestor de nodos X3D o el gestor de nodos H3D).
     ListaCat->Clear();
     for(int c=0; c< GN->TiposNodo->Count ; c++){
          ListaCat->Items->Append(GN->TiposNodo->Strings[c]);
     }
     // Adems aadimos una categora ms para guardar todos los nodos.
     ListaCat->Items->Append(TITULO_TAB_PARA_TODOS_LOS_NODOS);

     // Ahora vamos a intentar que la primera categora de la lista sea "Geometras" y
     // el penltimo "Otros".
     if( -1 != ListaCat->Items->IndexOf("Geometries") ){
        // Geometras est en la lista -> Lo aadimos al principio:
        ListaCat->Items->Delete(ListaCat->Items->IndexOf("Geometries") );
        ListaCat->Items->Insert(0,"Geometries");
     }

     if( (-1 != ListaCat->Items->IndexOf("Others")) &&
         (-1 != ListaCat->Items->Count >= 1)  ){
           ListaCat->Items->Delete( ListaCat->Items->IndexOf("Others") );
           ListaCat->Items->Insert(ListaCat->Items->Count-1,"Others");
     }

     // Ahora Rellenamos la lista con los objetos del primer tipo.
     RellenaLista(0);
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::sbH3DClick(TObject *Sender)
{
   if(GN == Main->GNH)
        return;

   GN=Main->GNH;
   // Si cambiamos de gestor no podremos elegir un nodo.
   ElegirNodo=false;
   sbAnadir->Visible= false;
   sbTransform->Visible= false;
   Caption="H3D Nodes";
   CargarDatos();
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::sbX3DClick(TObject *Sender)
{
   if(GN == Main->GNX)
        return;

   GN=Main->GNX;
   // Si cambiamos de gestor no podremos elegir un nodo.
   ElegirNodo=false;
   sbAnadir->Visible= false;
   sbTransform->Visible= false;   
   Caption="X3D Nodes";
   CargarDatos();
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::ListaNodosKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(Key == VK_RETURN)
      ProcesarNodoActual();

    if(VK_ESCAPE == Key)
       Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::ListaCatClick(TObject *Sender)
{
   /* Algo curioso que no explica la documentacin es que cada vez que se cambia
   la linea actual de ListaCat se produce un evento ListaCatClick as que con
   este mismo cdigo controlamos tb los cambios que el teclado hace en la lnea
   seleccionada.  */
   if(ListaCat->ItemIndex != -1)
     RellenaLista(ListaCat->ItemIndex);
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::ListaCatKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(VK_ESCAPE == Key)
     Close();
   /* No es necesario controlar las teclas que podran cambiar la lnea
   seleccionada porque curiosamente cada vez que se cambia la lnea actual
   desde el teclado se produce un evento onClick y se llama a la funcin ListaCatClick
   if( (ListaCat->ItemIndex != -1) && ( (Key == VK_UP) || (Key == VK_DOWN) ) )
     RellenaLista(ListaCat->ItemIndex);
   */
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::ListaNodosEnter(TObject *Sender)
{
   if(ListaNodos->Selected == NULL){
      ListaNodos->Selected = ListaNodos->Items->Item[0];
      ListaNodos->ItemFocused=ListaNodos->Items->Item[0];
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::FormCreate(TObject *Sender)
{
   AnsiString Fichero;
   Fichero= Main->CARPETA_PROGRAMA + "\\" + (AnsiString) CONF.CARPETA_CONFIGURACION +
            (AnsiString) "\\" + (AnsiString) FICHERO_NODOS_RECIENTES;
   lbRecientes->Items->Clear();
   if(FileExists(Fichero))
      Utilidad.LoadFromFile(lbRecientes->Items,Fichero);
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::FormDestroy(TObject *Sender)
{
   AnsiString Fichero;
   Fichero= Main->CARPETA_PROGRAMA + "\\" + (AnsiString) CONF.CARPETA_CONFIGURACION +
            (AnsiString) "\\" + (AnsiString) FICHERO_NODOS_RECIENTES;
   Utilidad.SaveToFile(lbRecientes->Items,Fichero);
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::ProcesarNodoActual(){

   // Lo primero es determinar cual es el nodo que se ha seleccionado. Lo hacemos
   // viendo que componente tiene el foco.
   AnsiString seleccionado;
   if( lbRecientes->Focused() ){
      if(lbRecientes->ItemIndex == -1)
         return;
      else
         seleccionado=lbRecientes->Items->Strings[lbRecientes->ItemIndex];

   }else if( ListaNodos->Focused() ){
       if(ListaNodos->ItemFocused == NULL)
          return;
       else
          seleccionado=ListaNodos->ItemFocused->Caption;
   }else
      return;

   seleccionado=seleccionado.Trim();
   if(seleccionado == "")
      return;

   bool esH3D= (NULL != Main->GNH->DatosNodo(seleccionado));
   bool esX3D   = (NULL != Main->GNX->DatosNodo(seleccionado));
   if( !esH3D && !esX3D ){
      Utilidad.MsgInfo("The " + seleccionado + " node is not registered.","Error");
      return;
   }
   if( (GN->tipoEscena == ESCENA_H3D )  &&  !esH3D ){
      Utilidad.MsgInfo("The " + seleccionado + " node is not registered as H3D node.","Advertencia");
      return;
   }

   if( (GN->tipoEscena == ESCENA_X3D )  &&  !esX3D ){
      Utilidad.MsgInfo("The " + seleccionado + " node is not registered as X3D node.","Advertencia");
      return;
   }

   // Ya tenemos el nombre del nodo seleccionado. Ahora hay que ver si debemos
   // devolverlo a la escena o iniciar frmDetallesNodo.
   if(ElegirNodo){
       NodoElegido=seleccionado;
       if(NodoAbstracto(NodoElegido))
           Utilidad.MsgInfo("The selected node hasn't any fields.","Advertencia");
       else{
           // Hay que actualizar la lista de nodos seleccionados.
           // Distinguimos si el nodo seleccionado est o no en la lista de nodos recientes.
           if( -1 == lbRecientes->Items->IndexOf(NodoElegido) ){
              // En este caso borramos al final.
              while(NUM_FICHEROS_RECIENTES <= lbRecientes->Items->Count)
                 lbRecientes->Items->Delete(lbRecientes->Items->Count-1);
           }else
              lbRecientes->Items->Delete(lbRecientes->Items->IndexOf(NodoElegido));
           lbRecientes->Items->Insert(0,NodoElegido);
           Close();
       }
   }else{
       // Mostramos la ventana de detalles del nodo actualmente seleccionado.
       // Si el nodo no existe no se mostrar la ventana.
       if(GN->tipoEscena == ESCENA_X3D)
            frmDetallesNodo->Inicia(Main->GNX,Main->GTX,seleccionado);
       else
            frmDetallesNodo->Inicia(Main->GNH,Main->GTH,seleccionado);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::FormShow(TObject *Sender)
{
     if(ListaNodos->CanFocus())
        frmIndiceNodos->FocusControl(ListaNodos);
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::ListaNodosAdvancedCustomDraw(
      TCustomListView *Sender, const TRect &ARect, TCustomDrawStage Stage,
      bool &DefaultDraw)
{
   static bool Inicio=true;
   // Hay un problema que se soluciona de este modo. El problema es que la primera
   // vez (y solo la primera vez) que se dibujan los iconos de ListaNodos aparecen
   // estos iconos en columnas con un ancho mayor que en el resto de las ocasiones.
   // He buscado varias horas en las propiedades y mtodos de esta clase pero no
   // he encontrado ninguna solucin. As que no me queda ms remedio que hacer
   // que la primera vez que se represente la lista se haga dos veces y as todo
   // funciona correctamente.
   if(Inicio){
      Inicio=false;
      // Al rellenar la lista se piede el nodo actualmente seleccionado as
      // que vemos cual es y luego lo reponemos.
      AnsiString nombre;
      if( ListaNodos->ItemFocused != NULL )
         nombre = ListaNodos->ItemFocused->Caption.UpperCase();
         // Ahora rellenamos la lista.
      RellenaLista(ListaCat->ItemIndex);
      // Ahora intentamos seleccionar el nodo que tiene como Caption <nombre>:
      for(int c=0; c < ListaNodos->Items->Count; c++){
         if(nombre == ListaNodos->Items->Item[c]->Caption.UpperCase() ){
             ListaNodos->ItemFocused = ListaNodos->Items->Item[c];
             ListaNodos->Selected    = ListaNodos->Items->Item[c];
             c=ListaNodos->Items->Count;  // dejamos de iterar.
         }
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::sbAyudaClick(TObject *Sender)
{
   Main->Ayuda();
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::sbTransformClick(TObject *Sender)
{
   EnTransform=true;
   ProcesarNodoActual();
}
//---------------------------------------------------------------------------
void __fastcall TfrmIndiceNodos::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------

