//
//     CLASE   frmGaleria   
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Presenta una lista de Objetos X3D/Sonidos/Textura para
                seleccionar uno de ellos.
*/

//---------------------------------------------------------------------------

#ifndef frmGaleria_H
#define frmGaleria_H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <Grids.hpp>
#include <Graphics.hpp>
#include <jpeg.hpp>
//---------------------------------------------------------------------------
class TfrmGaleria : public TForm
{
__published:	// IDE-managed Components
        TSpeedButton *sbCancelar;
        TSpeedButton *sbAbrir;
        TGroupBox *gbCategorias;
        TLabel *lbCategorias;
        TGroupBox *gbTitulo;
        TLabel *lbTitulo;
        TGroupBox *gbGaleria;
        TPanel *pnlGaleria;
        TSpeedButton *sbAceptar;
        TSpeedButton *sbExplorar;
        TGroupBox *gbListaCategorias;
        TPanel *pnlCategorias;
        TListBox *Categorias;
        TScrollBox *ScrollBox;
        TShape *Marco;
        TTimer *Timer;
        TImage *MarcoInterior;
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall sbCancelarClick(TObject *Sender);
        void __fastcall sbExplorarClick(TObject *Sender);
        void __fastcall CategoriasClick(TObject *Sender);
        void __fastcall sbAceptarClick(TObject *Sender);
        void __fastcall sbAbrirClick(TObject *Sender);
        void __fastcall TimerTimer(TObject *Sender);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall FormPaint(TObject *Sender);
        void __fastcall MarcoInteriorDblClick(TObject *Sender);
private:	// User declarations

        // Para saber qu tipo de fichero estamos usando definimos Modo:
        // 1 -> Objetos, 2-> Sonidos, 3 -> Texturas
        int Modo;

        // Identifica al elemento seleccionado (primer valor 0). 
        int Seleccionado;

        // Toma uno de estos valores: "Objetos", "Sonidos", "Texturas", ""
        // para indicar cual es el tipo de galera actual. 
        AnsiString GaleriaActual;

        // Solo tenemos un componente, Categoras, que puede tener el foco.
        // Pero sera necesario que tb lo tuviese ScrollBox, as que lo emularemos,

        // A cada fichero de la galera se le asocia una imgen. Imagenes es un
        // array de punteros a TImagen que va cambiando de tamao cada vez
        // que se cambia la lista de ficheros.
        TImage **Imagenes;

        // A cada fichero de la galera se le asocia TLabel. Labels es un
        // array de punteros a TLabel que va cambiando de tamao cada vez
        // que se cambia la lista de ficheros.
        TLabel **Labels;

        // Se usa para controlar el tiempo mnimo entre llamadas a
        // CompruebaCambiosEnHD()
        bool TimeOut;

        // Contiene una imagen que se usa al seleccionar un elemento de ScrollBox,
        // de modo que (al usar Canvas->CopyMode) podemos conseguir hacer esta
        // imagen semitransparente y superponerla al elemento seleccionado.
        Graphics::TBitmap *FondoSel;

        // Contiene el nombre de todos los ficheros contenidos en Carpeta:
        // Con la ruta completa.
        TStringList *Ficheros;

        // Para algunas operaciones es necesario usar localmente esta variable:
        TStringList *CadenasTmp;

        // Contiene la ruta completa de la carpeta actual que contiene los
        // ficheros que se muestran en ScrollBox.
        AnsiString Carpeta;

        // Esta funcin rellena lista con los nombres de las carpetas que estn
        // dentro de carpeta.
        void __fastcall RellenaCategorias(AnsiString carpeta,TStringList *lista);

        // Selecciona el fichero asociado al entero s (0 para el primer fichero
        // de la lista). Adems asigna Seleccionado:
        // Si Ficheros->Count es 0 se oculta el Marco.
        void __fastcall Selecciona(int s);

        // Procesa los eventos OnClick de Imagenes y Labels:
        void __fastcall ProcesaClickEnScrollBox(TObject *Sender);

        // Aade a lista la ruta completa de todos los ficheros contenidos
        // en carpeta que tengan la extensin asociada al modo actual:
        void __fastcall AnadirFicheros(AnsiString carpeta,TStringList *lista);

        // Comara las dos listas de cadenas que recibe y devuelve false si hay
        // alguna diferencia en las cadenas. Si el orden de los elementos es
        // distinto y las cadenas contienen los mismos elementos se devuelve true.
        bool __fastcall SonIguales(TStringList *cads1,TStrings *cads2);

        // Lee la estructura de ficheros de la galera actual y si hay algn
        // cambio con respecto a los datos de los ficheros que se estn
        // mostrando se actualizar el contenido de los controles.
        void __fastcall CompruebaCambiosEnHD();

        // Ajusta el rectangulo definido por Left,Top,Width,Height al interior
        // del rectangulo definido por LimLeft,LimTop,LimWidth,LimHeight
        // manteniendo la proporcionalidad y centrando el ajuste.
        // Si el segundo rectangulo es ms grande lo ajusta y si es ms pequeo
        // lo centra.
        void __fastcall Ajusta(int LimLeft,int LimTop,int LimWidth,int LimHeight,
                              int &Left  ,int &Top  ,int &Width  ,int &Height);

        // Libera la memoria de los arrays Imagenes y Labels.
        void __fastcall LiberaMemoria();

        // Busca los ficheros que hay en carpeta y actualiza los controles.
        // Si todos es true se cargan todos los ficheros que haya en carpeta
        // y tb en las subcarpetas de carpetas.
        void __fastcall CargaCarpeta(AnsiString carpeta,bool todos);

        // Responde a la pulsacin de una tecla actuando sobre SrollBox. Teclas,
        // permitidas, Cursores, Inicio, Fin, Avanzar Pgina, Re.Pgina, Intro.
        void __fastcall ScrollBoxProcesaTeclado(WORD Key);

        // Rellena ScrollBox con los elementos asociados a la categora seleccionada:
        void __fastcall CargaCategoria();

public:		// User declarations

        // Estas tres funciones cargan los contenidos de las galeras de Sonidos,
        // texturas y objetos respectivamente. Si el usuario elige alguno de los
        // elementos de las galeras se devuelve la ruta del fichero asociado
        // a ese objeto, si se sale sin elegir ningn objeto se devuelve "".
        AnsiString __fastcall IniciaSonidos();
        AnsiString __fastcall IniciaTexturas();
        AnsiString __fastcall IniciaObjetos();

        // Devuelve una de estas tres cadenas para informar sobre cual es la
        // galera actualmente abierta. Si no se est mostrando ninguna galera
        // devolver "".
        // Posibles valores: "Objetos", "Sonidos", "Texturas", ""
        AnsiString __fastcall GetGaleriaActual();

        // Constructor y destructor de la clase:
        __fastcall TfrmGaleria(TComponent* Owner);
        __fastcall ~TfrmGaleria();
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmGaleria *frmGaleria;
//---------------------------------------------------------------------------
#endif
