//
//     CLASE   frmGaleria   
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Presenta una lista de Objetos X3D/Sonidos/Textura para
                seleccionar uno de ellos.
*/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <Filectrl.hpp>
#include "frmGaleria_.h"
#include "Main_.h"
#include "Utilidad_.h"


// Dentro de la carpeta que contiene el fichero .EXE del programa se buscar
// la siguiente carpeta que contendr las galeras.
#define CARPETA_GALERIAS "Galleries"
// Dentro de la carpeta CARPETA_GALERIAS se buscarn la siguientes carpetas que
// contendrn los sonidos, las texturas y los objetos X3D respectivamente:
#define CARPETA_SONIDOS "Sounds"
#define CARPETA_TEXTURAS "Textures"
#define CARPETA_OBJETOS "Objects"

// Constantes que definen cmo se distribuyen los controles en el interior de ScrollBox:
#define ICONO_WIDTH 110
#define ICONO_HEIGHT 110
#define PASO_X 135
#define PASO_Y 145
#define BORDE 15
#define TOP_LABEL 4
#define TLABEL_HEIGHT 15
#define NUM_COLS 4

// Nmeros asociados al modo de funcionamiento:
#define MODO_OBJETOS 1
#define MODO_SONIDOS 2
#define MODO_TEXTURAS 3

// En cada tipo de la galera hay una imagen por defecto que se asocia a los ficheros.
#define IMAGEN_SONIDOS "Sonidos.bmp"
#define IMAGEN_OBJETOS "Objetos.bmp"
#define IMAGEN_TEXTURAS "Texturas.bmp"
#define IMAGEN_FONDO_SELECCIONADO "Fondosel.bmp"

// A cada modo de funcionamiento se le asocia un tipo de fichero, una extensin:
#define MASCARA_OBJETOS  "*.x3d"
#define MASCARA_SONIDOS  "*.wav"
#define MASCARA_TEXTURAS "*.png"

// Nmero mnimo de segundos que transcurrirn entre dos comprobaciones de
// cambios de datos en el disco duro (HD).
#define TIME_OUT_CHEQUEO 3

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmGaleria *frmGaleria;
//---------------------------------------------------------------------------
__fastcall TfrmGaleria::TfrmGaleria(TComponent* Owner)
        : TForm(Owner)
{
   Imagenes=NULL;
   Labels=NULL;
   // Reservamos memoria para Ficheros:
   try{ Ficheros = new TStringList(); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   try{ CadenasTmp = new TStringList(); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   try{ FondoSel = new Graphics::TBitmap; }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }
   // Cargamos la imagen del fondo seleccionado:
   Utilidad.GetImagen(FondoSel,IMAGEN_FONDO_SELECCIONADO,"");

   Ficheros->Sorted = true;

   Modo=0;
   Seleccionado=0;
   TimeOut=true;

}
//---------------------------------------------------------------------------
__fastcall TfrmGaleria::~TfrmGaleria()
{
   LiberaMemoria();
   if(Ficheros != NULL)
      delete Ficheros;

   if(CadenasTmp != NULL)
      delete CadenasTmp;

   if(FondoSel != NULL)
      delete FondoSel;

}
//---------------------------------------------------------------------------
AnsiString __fastcall TfrmGaleria::IniciaSonidos(){

   Carpeta = Main->CARPETA_PROGRAMA + "\\" + CARPETA_GALERIAS + "\\" + CARPETA_SONIDOS;
   if(!DirectoryExists(Carpeta)){
      Utilidad.MsgInfo("The following folder doesn't exist: " + Carpeta,"Advertencia");
      return "";
   }
   Modo=MODO_SONIDOS;

   // Es necesario colocar ScrollBox al principio para que se dibujen bien los
   // controles.
   ScrollBox->VertScrollBar->Position=0;

   // La carga de las categoras puede durar varios segundos:
   Screen->Cursor=PUNT_RATON_ESPERA;

   // Rellenamos la lista de categoras:
   RellenaCategorias(Carpeta,CadenasTmp);
   Categorias->Items->Assign(CadenasTmp);

   // Vamos a seleccionar la categora todos y a inicializar la lista de iconos:
   if(Categorias->Items->Count > 0)
      Categorias->ItemIndex = Categorias->Items->Count - 1;
   // Con Seleccionado -1 indicamos un caso especial -> Se va a mostrar la ventana.
   Seleccionado=-1;
   CargaCategoria();

   lbTitulo->Caption = "Sounds Gallery";

   // Devolvemos al cursor su aspecto original:
   Screen->Cursor=PUNT_RATON_NORMAL;

   GaleriaActual = "Sonidos";
   
   Timer->Enabled=true;
   int devuelto = ShowModal();
   Timer->Enabled=false;

   GaleriaActual = "";

   // Liberamos todos los recursos reservados:
   LiberaMemoria();

   if( (devuelto != mrCancel) && (Ficheros->Count > 0) &&
       (Seleccionado >= 0)    && (Seleccionado < Ficheros->Count) )
      return Ficheros->Strings[Seleccionado];
   else
      return "";
}
//---------------------------------------------------------------------------
AnsiString __fastcall TfrmGaleria::IniciaTexturas(){

   Carpeta= Main->CARPETA_PROGRAMA + "\\" + CARPETA_GALERIAS + "\\" + CARPETA_TEXTURAS;
   if(!DirectoryExists(Carpeta)){
      Utilidad.MsgInfo("The following folder doesn't exist: " + Carpeta,"Advertencia");
      return "";
   }
   Modo=MODO_TEXTURAS;

   // Es necesario colocar ScrollBox al principio para que se dibujen bien los
   // controles.
   ScrollBox->VertScrollBar->Position=0;

   // La carga de las categoras puede durar varios segundos:
   Screen->Cursor=PUNT_RATON_ESPERA;

   // Rellenamos la lista de categoras:
   RellenaCategorias(Carpeta,CadenasTmp);
   Categorias->Items->Assign(CadenasTmp);

   // Vamos a seleccionar la categora todos y a inicializar la lista de iconos:
   if(Categorias->Items->Count > 0)
      Categorias->ItemIndex = Categorias->Items->Count - 1;
   // Con Seleccionado -1 indicamos un caso especial -> Se va a mostrar la ventana.
   Seleccionado=-1;
   CargaCategoria();

   lbTitulo->Caption = "Texture Gallery";

   // Devolvemos al cursor su aspecto original:
   Screen->Cursor=PUNT_RATON_NORMAL;

   GaleriaActual = "Texturas";
   Timer->Enabled=true;
   int devuelto = ShowModal();
   Timer->Enabled=false;

   GaleriaActual = "";

   // Liberamos todos los recursos reservados:
   LiberaMemoria();

   if( (devuelto != mrCancel) && (Ficheros->Count > 0) &&
       (Seleccionado >= 0)    && (Seleccionado < Ficheros->Count) )
      return Ficheros->Strings[Seleccionado];
   else
      return "";
}
//---------------------------------------------------------------------------
AnsiString __fastcall TfrmGaleria::IniciaObjetos(){

   Carpeta= Main->CARPETA_PROGRAMA + "\\" + CARPETA_GALERIAS + "\\" + CARPETA_OBJETOS;
   if(!DirectoryExists(Carpeta)){
      Utilidad.MsgInfo("The following folder doesn't exist: " + Carpeta,"Advertencia");
      return "";
   }
   Modo=MODO_OBJETOS;

   // Es necesario colocar ScrollBox al principio para que se dibujen bien los
   // controles.
   ScrollBox->VertScrollBar->Position=0;

   // La carga de las categoras puede durar varios segundos:
   Screen->Cursor=PUNT_RATON_ESPERA;

   // Rellenamos la lista de categoras:
   RellenaCategorias(Carpeta,CadenasTmp);
   Categorias->Items->Assign(CadenasTmp);

   // Vamos a seleccionar la categora todos y a inicializar la lista de iconos:
   if(Categorias->Items->Count > 0)
      Categorias->ItemIndex = Categorias->Items->Count - 1;
   // Con Seleccionado -1 indicamos un caso especial -> Se va a mostrar la ventana.
   Seleccionado=-1;
   CargaCategoria();

   lbTitulo->Caption = "Objects Gallery";

   // Devolvemos al cursor su aspecto original:
   Screen->Cursor=PUNT_RATON_NORMAL;

   GaleriaActual = "Objetos";

   Timer->Enabled=true;
   int devuelto = ShowModal();
   Timer->Enabled=false;

   GaleriaActual = "";   

   // Liberamos todos los recursos reservados:
   LiberaMemoria();

   if( (devuelto != mrCancel) && (Ficheros->Count > 0) &&
       (Seleccionado >= 0)    && (Seleccionado < Ficheros->Count) )
      return Ficheros->Strings[Seleccionado];
   else
      return "";
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::FormCreate(TObject *Sender)
{
   Caption = Main->Caption;
   Marco->Width  = ICONO_WIDTH  + 2*Marco->Pen->Width + 2;
   Marco->Height = ICONO_HEIGHT + TOP_LABEL + TLABEL_HEIGHT + 2*Marco->Pen->Width + 2;

   MarcoInterior->Width  = Marco->Width;
   MarcoInterior->Height = Marco->Height;

   // Este es el ltimo evento FormCreate de todo el proyecto, as avisamos
   // a Main:
   Main->CreacionFormsAcabada();
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::sbCancelarClick(TObject *Sender)
{
   ModalResult= mrCancel;
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::sbExplorarClick(TObject *Sender)
{
   if(-1 == Categorias->ItemIndex){
      Utilidad.MsgInfo("You must select a category.");
      return;
   }

   AnsiString carp;
   if(Categorias->ItemIndex == (Categorias->Items->Count - 1) )
      // Este es un caso especial: Todos:
      carp = Carpeta;
   else
      carp = Carpeta + "\\" + Categorias->Items->Strings[Categorias->ItemIndex];

   if(DirectoryExists(carp))
      ShellExecute(this->Handle,"explore", carp.c_str(),NULL,NULL, SW_SHOWMAXIMIZED);
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::RellenaCategorias(AnsiString carpeta,TStringList *lista){

   if(!DirectoryExists(carpeta))
      return;

   lista->Clear();
   lista->Sorted = true;

   // Vamos a obtener todas las carpetas que hay dentro de carpeta y a aadirlas
   // en categoras de forma ordenada:

   // Tenemos que aadir \*.* a la carpeta teniendo en cuenta el caso especial
   // de "C:\"
   AnsiString mascara;
   if( (carpeta.Length() > 1) && (carpeta[carpeta.Length()] != '\\') )
      mascara = carpeta + "\\*.*";
   else
      mascara = carpeta + "*.*";

   TSearchRec F;
   if( 0 == FindFirst(mascara, faDirectory, F) ){
      if( (F.Name[1] != '.') && DirectoryExists(carpeta + "\\" + F.Name) )
         lista->Append(F.Name);

      while(0 == FindNext(F)){
         if( (F.Name[1] != '.') && DirectoryExists(carpeta + "\\" + F.Name) )
            lista->Append(F.Name);
      }

      // Ahora desactivamos el orden para incluir una ltima categora "All":
      lista->Sorted = false;
      lista->Append("All");
   }
   FindClose(F);
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::LiberaMemoria(){

   if( (Imagenes == NULL) || (Labels == NULL) )
      return;

   // Hay que liberar desvincular los controles creados dinmicamente:
   // Tb aprovechamos para liberar memoria:

   int fin = Ficheros->Count;

   for(int c=0; c < fin; c++){
      if( Imagenes[c] != NULL){
         ScrollBox->RemoveControl(Imagenes[c]);
         delete Imagenes[c];
      }
      if( Labels[c] != NULL ){
         ScrollBox->RemoveControl(Labels[c]);
         delete Labels[c];
      }
   }
   delete Imagenes;
   delete Labels;
   Imagenes = NULL;
   Labels = NULL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::CategoriasClick(TObject *Sender)
{
   if( (Categorias->Items->Count <= 0) || (Categorias->ItemIndex == -1) )
      return;

   CargaCategoria();
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::CargaCarpeta(AnsiString carpeta,bool todos){

   if(!DirectoryExists(carpeta))
      return;

   // Tenemos que ocutar el marco para evitar que se vea mientras se carga
   // una escena con muchas carpetas.
   Marco->Visible= false;
   MarcoInterior->Visible = false;
   Marco->Repaint();
   MarcoInterior->Repaint();

   // Lo primero es rellenar Ficheros con los nombres que encontremos en Carpeta.
   LiberaMemoria();
   Ficheros->Clear();

   if(todos){
      //Tenemos que aadir todos los ficheros que haya en Carpeta y tb los que
      // haya dentro de las carpetas categora:
      AnadirFicheros(Carpeta,Ficheros);

      // Y ahora aadimos los ficheros que haya dentro de cada categora:
      // La ltima categora es un caso especial: "All" que no corresponde
      // a una carpeta, as:
      for(int c=0; c < (Categorias->Items->Count-1); c++)
         AnadirFicheros(Carpeta + "\\" + Categorias->Items->Strings[c],Ficheros);

   }else{
      AnadirFicheros(carpeta,Ficheros);
   }

   // Ya tenemos en Ficheros los nombres de todos los ficheros, hay que crear
   // todos los objetos TImage y TLabel:
   if(Ficheros->Count == 0){
      // La funcin Seleccionado lo pondr a true cuando se seleccione un fichero
      // vlido.
      Marco->Visible=false;
      MarcoInterior->Visible=false;
      return;
   }

   // Creamos los arrays de punteros:
   try{ Imagenes = new (TImage *[Ficheros->Count]); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   try{ Labels = new (TLabel *[Ficheros->Count]); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   // ScroolBox->Height cambia en funcin del nmero de elementos de Ficheros:
   // int numFilas = (Ficheros->Count / NUM_COLS);         (sin efecto).
   //if( (Ficheros->Count % NUM_COLS) != 0)                (sin efecto).
   //   numFilas++;                                        (sin efecto).
   // ScrollBox->Height = BORDE * 2 + numFilas * PASO_Y;   (sin efecto).

   // Con un bucle vamos creando todos los componentes, los insertamos en
   // ScrollBox y asignamos sus propiedades:
   int fila,col;

   for(int c=0; c < Ficheros->Count;c++){
      // Creamos una nueva imagen:
      try{ Imagenes[c] = new TImage(frmGaleria); }
      catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

      // Creamos una nueva etiqueta:
      try{ Labels[c] = new TLabel(frmGaleria); }
      catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

      // Los aadimos a ScrollBox:
      ScrollBox->InsertControl(Imagenes[c]);
      ScrollBox->InsertControl(Labels[c]);

      // Asignamos el evento OnClick para poder seleccionar los elementos.
      Imagenes[c]->OnClick = ProcesaClickEnScrollBox;
      Labels[c]->OnClick = ProcesaClickEnScrollBox;

      // Asignamos sus propiedades:
      fila = c / NUM_COLS;
      col  = c % NUM_COLS;
      Imagenes[c]->Width  = ICONO_WIDTH;
      Imagenes[c]->Height = ICONO_HEIGHT;
      Imagenes[c]->Stretch = true;
      Imagenes[c]->Top  = BORDE + fila * PASO_Y;
      Imagenes[c]->Left = BORDE + col * PASO_X;
      

      Labels[c]->Caption = ExtractFileName(Ficheros->Strings[c]);
      Labels[c]->Left = Imagenes[c]->Left;
      Labels[c]->Top = Imagenes[c]->Top + ICONO_HEIGHT + TOP_LABEL;
      Labels[c]->AutoSize = false;
      Labels[c]->Width = ICONO_WIDTH;
      Labels[c]->Alignment = taCenter;
      Labels[c]->Height = TLABEL_HEIGHT;

      // Ahora vamos a ver si el nombre cabe en el espacio reservado, si no
      // cabe le aadimos "..." y lo truncamos.
      {
         AnsiString cad = Labels[c]->Caption;
         int s = Labels[c]->Canvas->TextWidth(cad);
         if(s > Labels[c]->Width){
            do{
               if(cad.Length() > 0)
                  cad = cad.Delete(cad.Length(),1);
               s = Labels[c]->Canvas->TextWidth(cad + "...");

            }while( (s > Labels[c]->Width) && (cad.Length() > 0) );
            Labels[c]->Caption = cad + "...";
         }
      }

      AnsiString file;
      // Tenemos que distinguir varios casos para asociar una imagen al fichero.
      if(Modo == MODO_OBJETOS){
         // En este caso: Si hay un fichero con el mismo nombre que el fichero
         // wrl y con extensin .jpg lo cargamos en otro caso cargamos la imagen
         // por defecto asociada a los objetos:

         // Lo primero es obtener el nombre del fichero:
         file = Ficheros->Strings[c].UpperCase();
         AnsiString extension = ExtractFileExt(file).UpperCase();
         if(extension.Length() > 0)
            file = file.Delete(file.Pos(extension),extension.Length());

         // Ya tenemos el nombre del fichero: Le aadimos la extensin JPG
         // y comprobamos si el fichero existe. Al cargar el fichero usamos
         // try para evitar posibles errores.
         if(FileExists(file + ".jpg")){
            try{
               Imagenes[c]->Picture->LoadFromFile(file + ".jpg");
            }catch(...){
               Utilidad.GetImagen (Imagenes[c]->Picture,IMAGEN_OBJETOS,"");
            }
         }else{
            Utilidad.GetImagen (Imagenes[c]->Picture,IMAGEN_OBJETOS,"");
         }
      }else if(Modo == MODO_SONIDOS){
         // En este caso siempre asociamos la misma imagen:
         Utilidad.GetImagen (Imagenes[c]->Picture,IMAGEN_SONIDOS,"");

      }else if(Modo == MODO_TEXTURAS){
         // En este caso: Si hay un fichero con el mismo nombre que el fichero
         // png y con extensin .jpg lo cargamos en otro caso cargamos la imagen
         // por defecto asociada a las texturas:

         // Lo primero es obtener el nombre del fichero:
         file = Ficheros->Strings[c].UpperCase();
         AnsiString extension = ExtractFileExt(file).UpperCase();
         if(extension.Length() > 0)
            file = file.Delete(file.Pos(extension),extension.Length());

         // Ya tenemos el nombre del fichero: Le aadimos la extensin JPG
         // y comprobamos si el fichero existe. Al cargar el fichero usamos
         // try para evitar posibles errores.
         if(FileExists(file + ".jpg")){
            try{
               Imagenes[c]->Picture->LoadFromFile(file + ".jpg");
            }catch(...){
               Utilidad.GetImagen (Imagenes[c]->Picture,IMAGEN_TEXTURAS,"");
            }
         }else{
            Utilidad.GetImagen (Imagenes[c]->Picture,IMAGEN_TEXTURAS,"");
         }
      }

      // Adems hay que ajustar la imagen al tamao del control:
      TImage *im = Imagenes[c];
      int left,top,width,height;

      left=0;
      top=0;
      width=im->Picture->Width;
      height=im->Picture->Height;
      Ajusta(0,0,ICONO_WIDTH,ICONO_HEIGHT,left,top,width,height);
      im->Left+=left;
      im->Top+=top;
      im->Width=width;
      im->Height=height;
   }

   // Finalmente seleccionamos uno de los ficheros: Un caso especial es
   // Seleccionado -1 que indica que se va a mostrar la ventana y entonces no
   // debemos seleccionar ningn elemento:
   if( (Seleccionado >= Ficheros->Count) && (Ficheros->Count > 0) )
      Selecciona(Ficheros->Count - 1);
   else if( (Seleccionado < Ficheros->Count) && (Seleccionado >= 0) )
      Selecciona(Seleccionado);
   else if( -1 == Seleccionado )
      Selecciona(Seleccionado);
   else
      Selecciona(Seleccionado);

   // Para que se vean los marcos tenemos que llamar a:
   Marco->BringToFront();
   MarcoInterior->BringToFront();
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::Ajusta(int LimLeft,int LimTop,int LimWidth,int LimHeight,
                                   int &Left  ,int &Top  ,int &Width  ,int &Height){

   if( (Height==0) || (Width == 0) )
      return;
   float rWidth,rHeight,rLimWidth,rLimHeight;

   rWidth  =  (float) Width;
   rHeight =  (float) Height;
   rLimWidth =(float) LimWidth;
   rLimHeight=(float) LimHeight;
   //----------------------------------- CASO 1: IMAGEN MS PEQUEA ------------
   if( (Width <= LimWidth) && (Height <= LimHeight) ){
       // Solo hay que centrar la imagen.
       Left=LimLeft + (LimWidth -Width )/2;
       Top =LimTop  + (LimHeight-Height)/2;
   }
   //----------------------------------- CASO 2: LA IMAGEN ES MS GRANDE -------
   else if( (Width > LimWidth) && (Height > LimHeight) ){
       // Comprobamos si hay que usar el ajuste vertical.
       if(rLimWidth >= rWidth*rLimHeight/rHeight){
          // Usamos el Ajuste Vertical
          Height=LimHeight;
          Width= (int)(rWidth*(rLimHeight/rHeight));
          Top=LimTop;
          Left=(LimWidth-Width)/2;
       }else{
          // Usamos el Ajuste Horizontal
          Width=LimWidth;
          Height= (int)rHeight*(rLimWidth/rWidth);
          Left=LimLeft;
          Top=(LimHeight-Height)/2;
       }
   }
   //--------------------- CASO 3: LA IMAGEN ES MS ALTA QUE LA PANTALLA -------
   else if( (Width <= LimWidth) && (Height > LimHeight) ){
       // Usamos el Ajuste Vertical
       Height=LimHeight;
       Width= (int)rWidth*(rLimHeight/rHeight);
       Top=LimTop;
       Left=(LimWidth-Width)/2;
   }
   //--------------------- CASO 4: LA IMAGEN ES MS ANCHA QUE LA PANTALLA -------
   else // if( (Width > LimWidth) && (Height <= LimHeight) )
   {
       // Usamos el Ajuste Horizontal
       Width=LimWidth;
       Height= (int)rHeight*(rLimWidth/rWidth);
       Left=LimLeft;
       Top=(LimHeight-Height)/2;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::AnadirFicheros(AnsiString carpeta,TStringList *lista){

   AnsiString mascara = "*.*";
   switch(Modo){
      case MODO_OBJETOS:  mascara = MASCARA_OBJETOS;  break;
      case MODO_SONIDOS:  mascara = MASCARA_SONIDOS;  break;
      case MODO_TEXTURAS: mascara = MASCARA_TEXTURAS; break;
   }

   // Tenemos que aadir mascara a la carpeta teniendo en cuenta el caso especial
   // de "C:\"
   AnsiString path;
   if( (carpeta.Length() > 1) && (carpeta[carpeta.Length()] != '\\') )
       path = carpeta + "\\" + mascara;
   else
       path  = carpeta + mascara;

   TSearchRec F;
   if( 0 == FindFirst(path, faArchive, F) ){
      lista->Append(carpeta + "\\" + F.Name);
      while(0 == FindNext(F)){
         lista->Append(carpeta + "\\" + F.Name);
      }
   }
   FindClose(F);
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::Selecciona(int s){
     
   // Si no hay ficheros en la categora actual se ocultan los marcos:
   Marco->Visible= (Ficheros->Count != 0) && (Seleccionado >= 0);
   MarcoInterior->Visible = Marco->Visible;

   // Solo seleccionaremos valores vlidos:
   if( (Ficheros->Count == 0) || (s < 0) || (s >= Ficheros->Count) )
      return;

   // Actualizamos Seleccionado:
   Seleccionado = s;

   // Tenemos que determinar las coordenadas donde colocar los marcos teniendo
   // en cuenta la posicin actual de la barra vertical:
   int fila = s / NUM_COLS;
   int col  = s % NUM_COLS;
   Marco->Top  = BORDE + fila * PASO_Y - Marco->Pen->Width - 1 - ScrollBox->VertScrollBar->Position;
   Marco->Left = BORDE + col  * PASO_X - Marco->Pen->Width - 1;

   MarcoInterior->Top = Marco->Top;

   // Tenemos que ocultar el Marco Interior para tomar la imagen de this->Canvas;
   MarcoInterior->Left = -MarcoInterior->Width - 1;

   // Hacemos que el control seleccionado se muestre -> Si no se ve se har
   // un scroll:
   ScrollBox->ScrollInView(Marco);

   // Tenemos que actualizar el aspecto de ScrollBoxPor si se ha hecho un scroll:
   // Es importante no hacer un Repaint que representa el control siempre y
   // aparecera un parpado con Update solo se representa cuando ha cambiado.
   ScrollBox->Update();

   // Vamos a obtener el aspecto que debe tener el marco interior. Ser una
   // combinacin del icono seleccionado y una imagen de fondo. El efecto resultante
   // ser similar a ver el icono a travs de un objeto semitransparente:
   int width  = Marco->Width;
   int height = Marco->Height;
   int left = gbGaleria->Left + pnlGaleria->Left + ScrollBox->Left;
   int top  = gbGaleria->Top + pnlGaleria->Top + ScrollBox->Top;
   left = left + Marco->Left;
   top  = top  + Marco->Top;
   TRect source(left,top,left+width,top+height);

   // Copiamos FondoSel en MarcoInterior:
   MarcoInterior->Canvas->CopyMode = cmSrcCopy;
   MarcoInterior->Canvas->Draw(0,0,FondoSel);

   // Ahora combinamos la imagen del elemento actual y el fondo:
   MarcoInterior->Canvas->CopyMode = cmSrcAnd;
   MarcoInterior->Canvas->CopyRect(TRect(0,0,width,height),this->Canvas,source);
   MarcoInterior->Left = Marco->Left;

   // La captura de los eventos de ratn impide que se haga el Repaint de Marco,
   // y de MarcoInterior, as que hay que hacerlo explcitamente:
   MarcoInterior->Repaint();
   Marco->Repaint();
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::sbAceptarClick(TObject *Sender)
{
   ModalResult= mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::sbAbrirClick(TObject *Sender)
{
   if(-1 == Categorias->ItemIndex){
      Utilidad.MsgInfo("You must select a category.");
      return;
   }

   if( (Seleccionado >= 0) && (Seleccionado < Ficheros->Count) ){
      if(FileExists(Ficheros->Strings[Seleccionado]))
         ShellExecute(this->Handle,"open", Ficheros->Strings[Seleccionado].c_str(),NULL,NULL, SW_SHOWMAXIMIZED);
      else
         Utilidad.MsgInfo("The following file doesn't exist: " + Ficheros->Strings[Seleccionado],"Advertencia");
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::CargaCategoria(){

   if( (Categorias->Items->Count <= 0) || (Categorias->ItemIndex == -1) )
      return;

   // Tenemos que distinguir un caso especial: "All":
   if(Categorias->ItemIndex == (Categorias->Items->Count-1)){
      // En este caso se ha seleccionado el ltimo elemento de Categorias: "All".
      CargaCarpeta(Carpeta,true);
   }else{
      CargaCarpeta(Carpeta + "\\" + Categorias->Items->Strings[Categorias->ItemIndex],false);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::TimerTimer(TObject *Sender)
{
    static int ms=0;

    // Vamos a gestionar la variable TimeOut, para el control de los chequeos
    // al HD:
    if(!TimeOut){
       // Obtenemos el nmero mnimo de ms que activan el TimeOut.
       ms += Timer->Interval;
       if( ms >= (1000 * TIME_OUT_CHEQUEO) ){
          TimeOut = true;
          ms=0;
       }
    }

   // Un caso especial es Seleccionado = -1, indica que se acaba de llamar a la
   // funcin IniciaSonidos/Texturas/Objetos y que no se ha podido seleccionar
   // un elemento porque es necesario que la ventana se muestre para poder copiar
   // parte de this->Canvas. As que ahora es cuando seleccionamos el primer
   // elemento:
   if( (Seleccionado == -1) && (Ficheros->Count > 0) ){
      // Ojo, no se puede usar Seleccionado(0), pq cuando Seleccionado es -1
      // el control no es visible.
      Seleccionado=0;
      Selecciona(Seleccionado);
      // Adems desactivamos el control activo para que el "foco virtual" est
      // en ScrollBox. Esto no se puede hacer en las funciones Inicia porque el
      // foco an no ha sido asignado:
      if(ActiveControl != NULL)
         this->DefocusControl(ActiveControl,false);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }

   // Tenemos que solucionar el siguiente problema: El control ScrollBox no
   // puede recibir el foco (no responde a eventos del teclado) y necesitamos
   // cambiar el icono seleccionado con el teclado. La solucin es:
   // El control categoras responder a los eventos de teclado mientras tenga
   // el foco. Cuando se pulse el tabulador o cuando se haga un click sobre
   // ScrollBox haremos que ActiveControl sea NULL llamando a DefocusControl,
   // Y as, FormShortCut capturar los eventos de teclado cuando ActiveControl
   // sea NULL y los enviar a ScrollBoxProcesaTeclado.

   // Con todo, cuando se pulse el tabulador en conmutaremos entre estos dos casos:
   // ActiveControl == NULL y ActiveControl == Categorias. Con esto conseguiremos
   // emular que ScrollBox tenga foco. As en el evento OnFormKeyDown atenderemos
   // los eventos de teclado asociados a ScrollBox.
   if(Msg.CharCode == '\t'){
      if(ActiveControl == NULL)
         FocusControl(Categorias);
      else
         this->DefocusControl(ActiveControl,false);
         // (ActiveControl debe ser Categoras)
      Handled=true;
   }else if(Msg.CharCode == VK_ESCAPE){
      Handled = true;
      sbCancelarClick(NULL);
   }else if(ActiveControl == NULL){
      ScrollBoxProcesaTeclado(Msg.CharCode);
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::ScrollBoxProcesaTeclado(WORD Key){

   int elementosPorPag = NUM_COLS * ( ScrollBox->Height / PASO_Y );

   if(Key == VK_ESCAPE){//------------------------------------ Escape-----------
      sbCancelarClick(NULL);
   }else if(Key == VK_HOME){//-------------------------------- Inicio ----------
      Selecciona(0);
   }else if(Key == VK_END){//--------------------------------- Fin -------------
      Selecciona(Ficheros->Count-1);
   }else if(Key == VK_PRIOR){//------------------------------- Re.Pag ----------
      if( (Seleccionado-elementosPorPag) < 0)
         Selecciona(0);
      else
         Selecciona(Seleccionado-elementosPorPag);
   }else if(Key == VK_NEXT){//-------------------------------- Av.Pag ----------
      if( (Seleccionado+elementosPorPag) >= Ficheros->Count)
         Selecciona(Ficheros->Count-1);
      else
         Selecciona(Seleccionado+elementosPorPag);
   }else if(Key == VK_LEFT){//-------------------------------- Izquierda -------
      Selecciona(Seleccionado-1);
   }else if(Key == VK_RIGHT){//------------------------------- Derecha ---------
      Selecciona(Seleccionado+1);
   }else if(Key == VK_UP){   //------------------------------- Arriba ----------
      Selecciona(Seleccionado-NUM_COLS);
   }else if(Key == VK_DOWN){ //------------------------------- Abajo -----------
      Selecciona(Seleccionado+NUM_COLS);
   }else if(Key == VK_RETURN){//------------------------------ Intro -----------
      sbAceptarClick(NULL);
   }
}
//---------------------------------------------------------------------------
bool __fastcall TfrmGaleria::SonIguales(TStringList *cads1,TStrings *cads2){
   if( (cads1== NULL) || (cads2== NULL) )
      return false;
   if( cads1->Count != cads2->Count )
      return false;

   for(int c=0; c < cads1->Count; c++){
      if(-1 == cads1->IndexOf(cads2->Strings[c]) )
         return false;
   }
   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::FormPaint(TObject *Sender)
{
   // Los datos que muestran los controles pueden cambiar en el HD, por ello
   // es necesario chequearlos para ver si han cambiado. Usaremos FormPaint.
   // Hay que solucionar un problema y es que en ocasiones, dos ejecuciones
   // consecutivas de este evento pueden ocurrir muy rpido, por ejemplo si
   // se arrastra un ventana por encima de frmGalera o cuando se redibujan
   // los SpeedButton. Y como la comprobacin del cambio en los datos de
   // HD pueden llevar cierto tiempo, es necesario cuidar que entre dos
   // llamadas a CompruebaCambiosEnHD(); pasen al menos TIME_OUT_CHEQUEO segs.
   if( TimeOut ){
      TimeOut = false;
      CompruebaCambiosEnHD();
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::CompruebaCambiosEnHD(){

   if(Categorias->ItemIndex == -1)
      return;

   // Hay que desactivar el Timer para evitar que se den varios mensajes de
   // que los datos han cambiado. 
   Timer->Enabled=false;

   // Cada 6 * Timer->Interval comprobamos si se han producido cambios en
   // las categoras (carpetas) y en los elementos de ScrollBox (ficheros).
   // Haremos dos cosas:
   // 1) Comprobar si la lista de categorias ha cambiado
   // 2) Comprobar si la lista de ficheros ha cambiado.

   // Pero antes hay que comprobar que Carpeta sigue existiendo:
   if(!DirectoryExists(Carpeta)){
      Utilidad.MsgInfo("The following folder doesn't exist: " + Carpeta,"Error");
      sbCancelarClick(NULL);
   }

   RellenaCategorias(Carpeta,CadenasTmp);
   // Ahora hay que comparar CadenasTmp con Categorias->Items para ver si
   // ha cambiado.
   if( !SonIguales(CadenasTmp,Categorias->Items) ){
      Utilidad.MsgInfo("The category list has changed. This list is going to be updated.");

      // Vamos a actualizar el contenido de Categorias intentando mantener
      // seleccionado el mismo elemento de la lista:
      if(Categorias->ItemIndex != -1){

         AnsiString cad = Categorias->Items->Strings[Categorias->ItemIndex];
         Categorias->Items->Assign(CadenasTmp);

         if( -1 != Categorias->Items->IndexOf(cad) )
            Categorias->ItemIndex = Categorias->Items->IndexOf(cad);
      }

      // Adems tenemos que actualiza el contenido de ScrollBox por si ha cambiado.
      CargaCategoria();
   }else{
      // En este caso no ha cambiado la lista de categorias, vemos si ha
      // cambiado el contenido de ScrollBox.

      // Lo primero que tenemos que hacer es cargar en CadTmp lo mismo que
      // debe haber en Ficheros y luego lo comparamos.
      CadenasTmp->Clear();
      if(Categorias->ItemIndex == (Categorias->Items->Count-1)){
         //Tenemos que aadir todos los ficheros que haya en Carpeta y tb los que
         // haya dentro de las carpetas categora:
         AnadirFicheros(Carpeta,CadenasTmp);

         // Y ahora aadimos los ficheros que haya dentro de cada categora:
         // La ltima categora es un caso especial: "Todos" que no corresponde
         // a una carpeta, as:
         for(int c=0; c < (Categorias->Items->Count-1); c++)
             AnadirFicheros(Carpeta + "\\" + Categorias->Items->Strings[c],CadenasTmp);

      }else if(Categorias->ItemIndex != -1){
         AnadirFicheros(Carpeta + "\\" + Categorias->Items->Strings[Categorias->ItemIndex],CadenasTmp);
      }

      // Ahora solo falta comparar las listas de cadenas:
      if( !SonIguales(CadenasTmp,Ficheros) ){
         Utilidad.MsgInfo("The gallery's elements have changed. They are going to be updated.");
         CargaCategoria();
      }
   }
   Timer->Enabled=true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::ProcesaClickEnScrollBox(TObject *Sender){

   TControl *control = (TControl *)Sender;

   // Vamos a buscar el control en los arrays:
   for(int c=0; c < Ficheros->Count ; c++){
      if( (Imagenes[c] == (TImage *)control) ||
          (Labels[c]   == (TLabel *)control) ){
          Selecciona(c);
          break;
      }
   }

   // Adems hay que quitar el foco de Categorias:
   if(ActiveControl != NULL)
      this->DefocusControl(ActiveControl,false);
}
//---------------------------------------------------------------------------
void __fastcall TfrmGaleria::MarcoInteriorDblClick(TObject *Sender)
{
   sbAceptarClick(NULL);
}
//---------------------------------------------------------------------------
AnsiString __fastcall TfrmGaleria::GetGaleriaActual(){
   return GaleriaActual;
}

