//
//     CLASE   frmEscena   
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Esta es la clase implementa un arbol que contendr todos los
       datos de las escena.
*/

//---------------------------------------------------------------------------

#ifndef frmEscena_H
#define frmEscena_H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ImgList.hpp>
#include "ArrayDinamico_.h"
#include "Utilidad_.h"
#include "Main_.h"
#include <Buttons.hpp>
#include <ExtCtrls.hpp>

// Cada uno de los nodos del arbol NodoArbol tendr asociado alguno de estos
// tipos. Cada tipo corresponde a un elemento definido en la especificacin X3D
// de modo que cada nodo NodoArbol se escribe de un modo distinto en el fichero.
// Y adems la posicin que ocupe ese nodo en el arbol determinar la
// posicin del fichero donde se escriba.
enum TipoNodoArbol { TNA_INDEFINIDO = 0, RAIZ = 1, NODO = 2,CAMPO = 3, RUTADO = 4,
                     PROTO = 5, EXTERNPROTO= 6,COMENTARIO = 7, USE = 8};

// En la definicion de unas clases se hace uso de otras por esto es necesario
// declarar los nombres de las clases antes que sus cuerpos.
class TipoRaiz;
class TipoNodo;
class TipoCampo;
class TipoRutado;
class TipoComentario;
class TipoUSE;
class TipoProto;
class TipoExternProto;
//----------------------------------------------------------------------------
// Esta clase implementa un nodo del arbol que formar la escena.
class NodoArbol{
public:
    TTreeNode *nodoAsociado;  // Es el nodo del rbol TreView que est asociado
                              // al nodo del rbol que implementa esta clase. Por
                              // comodidad para aprovechar las funcines de acceso
                              // a los nodos que se implementan en TTreeView siempre
                              // ocurrir que los dos rboles sern iguales de
                              // modo que tendrn el mismo nmero de nodos y la
                              // misma estructura. As nodoAsociado ser != NULL siempre.

    NodoArbol *padre;         // Es un puntero al nodo padre.
    ArrayDinamico *hijos;      // Contiene punteros void a todos los nodos hijos.
                              // (los punteros void habr que convertirlos a NodoArbol *)

    TipoNodoArbol tipo;       // Cada nodo NodoArbol encaja en un tipo concreto.
    void *    dato;           // Para cada tipo de nodo NodoArbol hay asociada una
                              // clase. dato es un puntero a un objeto de esa clase
                              // (es necesaria hacer la conversin de explicita).


    // Esta funcin devuelve el hijo de tipo tipo que ocupa la posicin n (n>=0).
    // si tipo == TNA_INDEFINIDO entonces los hijos considerados pueden ser de
    // cualquier tipo.
    // Ejemplo: GetHijo(5,CAMPO);  Devolver el sexto hijo de tipo campo que haya
    // en el array hijos (en cualquier posicin).
    // Si no se encuentra el hijo pedido se devuelve NULL.
    NodoArbol * __fastcall GetHijo(int n,TipoNodoArbol tipo_=TNA_INDEFINIDO);

    // Las siguientes funciones permiten comprobar fcilmente qu tipo de elemento
    // del arbol tenemos. El cdigo resulta ms intuitivo y ms compacto que al
    // usar comparaciones con this->tipo.
    inline bool _fastcall EsTNA_INDEFINIDO() { return (tipo == TNA_INDEFINIDO); }
    inline bool _fastcall EsRaiz          () { return (tipo == RAIZ          ); }
    inline bool _fastcall EsNodo          () { return (tipo == NODO          ); }
    inline bool _fastcall EsCampo         () { return (tipo == CAMPO         ); }
    inline bool _fastcall EsRutado        () { return (tipo == RUTADO        ); }
    inline bool _fastcall EsProto         () { return (tipo == PROTO         ); }
    inline bool _fastcall EsExternProto   () { return (tipo == EXTERNPROTO   ); }
    inline bool _fastcall EsComentario    () { return (tipo == COMENTARIO    ); }
    inline bool _fastcall EsUSE           () { return (tipo == USE           ); }

    // Las siguientes funciones implementan la conversion de tipo que se aplica
    // a dato. Si el tipo pedido no es el correcto devuelven NULL:
    TipoRaiz   * _fastcall AsRaiz  () { return (tipo != RAIZ  ) ? NULL : (TipoRaiz   *)dato; }
    TipoNodo   * _fastcall AsNodo  () { return (tipo != NODO  ) ? NULL : (TipoNodo   *)dato; }
    TipoCampo  * _fastcall AsCampo () { return (tipo != CAMPO ) ? NULL : (TipoCampo  *)dato; }
    TipoRutado * _fastcall AsRutado() { return (tipo != RUTADO) ? NULL : (TipoRutado *)dato; }
    TipoUSE    * _fastcall AsUSE   () { return (tipo != USE   ) ? NULL : (TipoUSE    *)dato; }
    TipoProto  * _fastcall AsProto () { return (tipo != PROTO)  ? NULL : (TipoProto  *)dato; }
    TipoExternProto * _fastcall AsExternProto() { return (tipo != EXTERNPROTO) ? NULL : (TipoExternProto *)dato; }
    TipoComentario  * _fastcall AsComentario () { return (tipo != COMENTARIO ) ? NULL : (TipoComentario  *)dato; }

    // Devuelve true si this es un campo de tipo eventin o eventout.
    bool _fastcall EsCampoEvento();

    // Devuelve true si this es un campo de tipo SFNode y no es un evento.
    bool _fastcall EsCampoSFNodeNoEvento();
    // Devuelve true si this es un campo de tipo MFNode y no es un evento.
    bool _fastcall EsCampoMFNodeNoEvento();


    NodoArbol(TipoNodoArbol tipo_tmp);       // Constructor.
    ~NodoArbol();                        // Destructor.
};
//---------------------------------------------------------------------------
// Clase asociada al TipoNodoArbol RAIZ:
class TipoRaiz {
public:
    AnsiString fichero;   // Contiene el nombre del fichero.

    TipoEscena tipoEscena;  // Especifica el tipo de escena H3D/X3D.

    AnsiString cabecera;  //cabecera leida del fichero o cabecera default.

    AnsiString tipoCodificacion;  // Codificacin "XML" o "VRML"

    __fastcall TipoRaiz(){   // Constructor.
       fichero="";
       tipoEscena=ESCENA_X3D;
       tipoCodificacion = "XML";
    }
};
//---------------------------------------------------------------------------
// En una escena podemos tener nodos normales. Nodos que no se definen ni en la
// especificacin ni con sentencias PROTO y EXTERNPROTO. Y nodos definidos en
// sentencias PROTO o EXTERNPROTO. Los dos tipos segundos se consideran como
// nodos genricos. Con este tipo de datos distinguiremos los tres casos.
enum TipoNodoVRML { NODO_NORMAL = 0, NODO_INDEFINIDO = 1, NODO_DEFINIDO_EN_PROTOS = 2};

// Clase asociada al TipoNodoArbol NODO:
class TipoNodo {
public:
    AnsiString nombre;     // Nombre del nodo X3D/H3D.
    AnsiString nombreDado; // Nombre dado por el usuario al nodo.
    Nodo *datosNodo;       // Puntero al registro del gestor de nodos con la
                           // informacin del nodo (depende el tipo de escena)

    TipoNodoVRML tipoNodoVRML; // Contiene informacin sobre el tipo de nodo

    __fastcall TipoNodo(){            // Constructor.
        tipoNodoVRML = NODO_NORMAL;
        nombre="";
        nombreDado="";
        datosNodo=NULL;
    }
};
//---------------------------------------------------------------------------
// Hay que clasificar los campos en varios tipos para saber cuando se pueden
// aadir nodos, un solo nodo o nada.
enum TIPO_CAMPO { SIMPLE = 0, SFNODE = 1, MFNODE = 2};
// Clase asociada al TipoNodoArbol CAMPO:
class TipoCampo{
public:
    AnsiString nombre;     // Nombre del campo.
    Campo *datosCampo;     // Contiene todos los datos del gestor de nodos asociado
                           // al campo. Se puede acceder a la informacin del
                           // tipo de campo del gestor de tipos usando datosCampo.

    AnsiString  valor;     // Contiene los datos del campo.

    TIPO_CAMPO  tipoCampo; // Contiene informacin sobre si el campo puede
                           // o no terner hijos.

    __fastcall TipoCampo(){           // Constructor.
        nombre="";
        datosCampo=NULL;
        tipoCampo=SIMPLE;     // asigno un valor cualquiera.
        valor = "";
    }
};
//---------------------------------------------------------------------------
// Clase asociada al TipoNodoArbol RUTADO:
class TipoRutado{
public:
    AnsiString nodoOut;    // Nombre del Nodo asociado al evento de salida.
    AnsiString campoOut;   // Nombre del campo -> evento de salida.
    AnsiString nodoIn;     // Nombre del Nodo asociado al evento de entrada.
    AnsiString campoIn;    // Nombre del campo -> evento de entrada.
    bool routeAndTouch;    // En escenas H3D es posible tener rutados de
                           // tipo ROUTEANDTOUCH, con este booleano distinguimos.
                           // este caso.

    __fastcall TipoRutado(){   // Constructor.
         nodoOut="";
         campoOut="";
         nodoIn="";
         campoIn="";
         routeAndTouch=false;
    }
};
//---------------------------------------------------------------------------
// Clase asociada al TipoNodoArbol COMENTARIO:
class TipoComentario{
public:
    AnsiString texto;   // Contenido del comentario incluido el caracter #
    __fastcall TipoComentario(){   // Constructor.
        texto="";
    }
};
//---------------------------------------------------------------------------
// Clase asociada al TipoNodoArbol USE:
class TipoUSE{
public:
    AnsiString nombreDado;      // Conteniene el nombre dado al nodo.
    AnsiString nombreTipoNodo; // En X3D se debe usar tambin el nombre del nodo en las sentencias USE.
    __fastcall TipoUSE(){     // Constructor.
        nombreDado="";
    }
};
//---------------------------------------------------------------------------
// Clase asociada al TipoNodoArbol PROTO:
class TipoProto{
public:
   AnsiString nombre;    // Nombre dado al elemento Proto.
   AnsiString interfaz;  // Contiene las definiciones del interfaz que
                         // aparecen entre [] (no se incluyen los [])
   AnsiString cuerpo;    // Contiene todo el texto entre {} sin incluir las {} 
};
//---------------------------------------------------------------------------
// Clase asociada al TipoNodoArbol EXTERNPROTO:
class TipoExternProto{
public:
   AnsiString nombre;    // Nombre dado al elemento ExternProto.
   AnsiString interfaz;  // Contiene las definiciones del interfaz que
                         // aparecen entre [] (no se incluyen los [])
   AnsiString url;       // Contiene el valor del campo MFString que hay tras
                         // las declaracin del interfaz.
};
//---------------------------------------------------------------------------
class TfrmEscena : public TForm
{
__published:	// IDE-managed Components
        TImageList *ListaIconos;
        TPageControl *Carpetas;
        TTabSheet *TabEscena;
        TTabSheet *TabCodigo;
        TTreeView *TreeView;
        TRichEdit *Codigo;
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall TreeViewDblClick(TObject *Sender);
        void __fastcall TreeViewClick(TObject *Sender);
        void __fastcall CodigoKeyDown(TObject *Sender, WORD &Key,TShiftState Shift);
    void __fastcall CarpetasChange(TObject *Sender);
    void __fastcall CodigoKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
    void __fastcall TreeViewStartDrag(TObject *Sender,
          TDragObject *&DragObject);
    void __fastcall TreeViewEndDrag(TObject *Sender, TObject *Target,
          int X, int Y);
    void __fastcall TreeViewDragOver(TObject *Sender, TObject *Source,
          int X, int Y, TDragState State, bool &Accept);
    void __fastcall FormCanResize(TObject *Sender, int &NewWidth,
          int &NewHeight, bool &Resize);
        void __fastcall TreeViewKeyPress(TObject *Sender, char &Key);
        void __fastcall FormActivate(TObject *Sender);
        void __fastcall CodigoKeyPress(TObject *Sender, char &Key);
        void __fastcall CodigoMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall TreeViewKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall TreeViewKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall CodigoMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall CodigoMouseWheel(TObject *Sender,
          TShiftState Shift, int WheelDelta, TPoint &MousePos,
          bool &Handled);
private:	// User declarations
        //----------------------------------------------- VARIABLES PRIVADAS ---
        // Estas variables se usan para recorrer el rbol.
        int RecorrerArbolLastIndex;
        TipoNodoArbol RecorrerArbolTipoNodoArbol;
        bool RecorrerArbolRecorrerTodos;

        // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
        // del texto, lo evitamos con  FormateoAnulado en OnMouseDown y OnMouseUp y
        // tambin al pulsar y soltar Shift:
        bool FormateoAnulado;

       // Las propiedades y mtodos de Codigo no son sufientes para hacer algunas
       // cosas por ello hay que recurrir a las API de windows interceptando los
       // mensajes que se envan al control. Por ejemplo para saber cuando se hace
        // un scroll. As usamos esta variable que guarda la direccin de la funcin
        // que procesaba originalmente el mensaje.
        TWndMethod FuncionOriginal;

        // Para preguntar si se desea salvar el fichero cuando se han hecho
        // cambios se usa la variable:
        bool EscenaHaCambiado;

        // Al empezar a arrastrar un nodo hay que mantener una referencia a el.
        NodoArbol *NodoArrastrado;

        // Guardar los errores que se producen al cargar un fichero.
        TStringList *ErroresDeLectura;

        //----------------------------------------------- FUNCIONES PRIVADAS ---
        // Esta funcin devuelve una cadena con un nmero <num> usando <digits>
        // dgitos de modo que se introducen 0's a la izquierda del nmero hasta
        // obtener <digits> nmeros.
        AnsiString __fastcall Formatea(int num,int digits);

        // Segun el tipo de elemento los indices de la lista de imgenes:
        // elemento->nodoAsociado->ImageIndex
        // elemento->nodoAsociado->SelectedIndex
        void __fastcall AsignarIcono(NodoArbol *elemento);

        // Devuelve verdadero si la cadena cad contiene la cadena que se est
        // buscando (BusquedaCadena) teniendo en cuenta si se deben distinguir
        // o no maysculas (BusquedaDistinguir).
        bool __fastcall ContieneCadenaBuscada(AnsiString *cad);

        // Devuelve true si c es un nmero.
        bool __fastcall Numero(char c);

        // Devuelve la posicin del cursor que se debe pasar a frmEditor->Inicia
        // para colocar el error sobre el error que se indica en error donde,
        // error puede ser por ejemplo: "fila:7 col:33--> Error ..."
        // Se devuelve TPoint(col,fila)
        TPoint __fastcall GetPosCursor(TStrings *lineas, AnsiString error);
        // Es la versin de la funcin para el caso de X3D. 
        TPoint __fastcall GetPosCursorXML(TStrings *lineas, AnsiString error);

        // Las propiedades y mtodos de Codigo no son sufientes para hacer
        // algunas cosas por ello hay que recurrir a las API de windows interceptando los
        // mensajes que se envan al control. Por ejemplo para saber cuando se hace
        // un scroll. As usamos esta funcin para interceptar estos mensajes y
        // hacer el procesamiento adecuado.
        void __fastcall CapturaMensaje(Messages::TMessage &Message);


public:		// User declarations
        //----------------------------------------------- VARIABLES PUBLICAS ---

        // Contienen los Gestores de tipos y de nodos asociados a la escena.
        // Es cmodo que sean pblicos para no tener en cuenta el tipo de escena.
        GestorNodos * GN;
        GestorTipos * GT;

        // Contiene todos los datos de la escena actual.
        NodoArbol *Raiz;

        // Es una cadena que contiene el nmero de elementos de cada tipo que
        // hay actualmente en la escena, por ejemplo:
        // "Nodos: 54 Campos: 186 Rutados: 15 USE: 5 DEF: 25 Comentarios: 61"
        AnsiString Estadistica;

        // Contiene el valor de la ltima cadena que se ha buscado en la escena.
        AnsiString BusquedaCadena;
        // Contiene el valor de la ltima tipo de elemento que se ha buscado en la escena.
        //   Valor          Elementos Buscados:
        //  -------        ---------------------
        //    0               Todos
        //    1               Nodos
        //    2               Nodos DEF
        //    3               Nodos USE
        //    4               Campos (nombres)
        //    5               Campos (contenido)
        //    6               Vinculos de Rutado
        //    7               Comentarios
        int BusquedaTipoElemento;
        // Indica si en la bsqueda hay que distinguir maysculas de minsculas o no.
        bool BusquedaDistinguir;

        // Contiene el nmero aproximado de lneas que tiene la escena.
        int NumLineas;
        // Contiene la lnea actual de la escena (si es -1 es que no se ha definido)
        int LineaActual;


        //----------------------------------------------- FUNCIONES PUBLICAS ---

        // Inicia la bsqueda de elementos en la escena. texto es el texto que
        // queremos buscar y modo indica sobre qu tipo de elementos se har la
        // bsqueda:
        //   modo          Elementos Buscados:
        //  -------        ---------------------
        //    0               Todos
        //    1               Nodos
        //    2               Nodos DEF
        //    3               Nodos USE
        //    4               Campos (nombres)
        //    5               Campos (contenido)
        //    6               Vinculos de Rutado
        //    7               Comentarios
        // distinguir indica si hay que distinguir maysculas de minsculas o no.
        void __fastcall IniciaBusqueda(AnsiString texto,int modo,bool distinguir);
        // Esta funcin busca el siguiente elemento de la escena que responda a
        // los datos especificados en IniciaBusqueda. Si se llega al final de la
        // escena antes de encontrar el elemento se avisa con un mensaje.
        // Si se encuentra el elemento buscado se seleccionar en la escena.
        void __fastcall Busca();

        // Si se modifica el contenido de la escena, por ejemplo al editarla,
        // se puede llamar a esta funcin para que se actualice el arbol de
        // datos en memoria y los indicadores con los datos de ms. Se puede
        // especificar un nombre de fichero nuevo y si la escena inicialmente
        // est modificada o no.
        // El contenido de datos se asigna a Codigo
        void __fastcall ActualizaDesdeAnsiString(AnsiString &datos,AnsiString nombrefichero,bool escenaModificada);

        // Llama a ActualizaArbol o ActualizaCdigoVRML, segn cual sea el Tab
        // seleccionado.
        void __fastcall Actualiza();

        // Hay varios tipos de nodos NodoArbol. Esta funcin devuelve el nombre
        // que aparecer en el rbol TreeView teniendo en cuenta de qu tipo de
        // campo se trata.
        AnsiString __fastcall GetNombreTreeView(NodoArbol *elemento);

        // Coloca la ventana en el centro ajustando los bordes a otras ventanas.
        void __fastcall Posiciona();

        // Prepara la clase para una nueva escena. Si hay una escena cargada
        // se eliminan. Esta sobre cargada para poder recibir un fichero o
        // una estructura de datos ya cargada en raiz. Si raiz es NULL la escena
        // se cargar desde el fichero, otra posibilidad es que raiz contenga
        // la estructura de datos ya cargada en memoria. En este caso, lo que hace
        // esta funcin es crear el arbol TreeView y actualizar los controles
        // y dems variables de la clase.
        // Cuando raiz != NULL el parmetro fichero es ignorado (el fichero
        // asociado a la escena ya debe estar en la estructura de datos apuntada
        // por raiz).
        void __fastcall IniciaEscena(GestorNodos *GN_, GestorTipos *GT_);
        void __fastcall IniciaEscena(AnsiString fichero,TipoEscena tipoEscena,NodoArbol *raiz=NULL);

        // Permite abrir un fichero X3D y/o H3D. Tipo indica que tipo de
        // fichero debe abrirse:
        //  Tipo = 0 -> Se abre un fichero de tipo H3D o X3D.
        //  Tipo = 1 -> Se abre un fichero de tipo X3D.
        //  Tipo = 2 -> Se abre un fichero de tipo H3D.
        // Si fichero es "" (por defecto) se muestra un cuadro de dilogo para
        // elegir el fichero, en otro caso se intenta abrir el fichero <fichero>.
        void __fastcall AbrirEscena(int tipo,AnsiString fichero="");

        // Esta funcin representa en el TreeView la estructura de datos usada.
        // La funcin es recursiva y necesita que se le pase como parmetro el
        // nodo de la estructura de datos que se quiere representar (nodo1)
        // (habitualmente Raiz) y tambin se le debe pasar el nodo del arbol
        // TreeView donde se quieren aadir los datos (nodo2).
        // Si nodo2 vale NULL se borrar el arbol TreeView y se crear
        // uno nuevo.
        // No es necesario que los campos nodoAsociado sean NULL. En cualquier
        // caso se sobreescribirn.
        void __fastcall DibujarArbol(NodoArbol *nodo1,TTreeNode* nodo2);

        // Elimina el nodo que recibe y todos sus hijos.
        // Es una funcin recursiva (exterior debe ser verdadera para distinguir
        // la primera llamada).
        void __fastcall EliminarNodo(NodoArbol *nodo,bool exterior=true);

        // Borra elemento del arbol de datos. Se tiene en cuenta la interaccin
        // con otros elementos como vinculos de rutado etc.
        void __fastcall BorrarNodo(NodoArbol *elemento);

        // Aade el nodo de nombre nombreNodo del gestor de nodos al nodo NodoPadre.
        // Si padre es NULL (por defecto) se aadir al nodo actualmente seleccionado.
        // Si no se pueden aadir nodos al nodo indicado se aadirn en la raiz.
        // Devuelve el nodo aadido, si no se ha podido aadir devuelve NULL.
        NodoArbol * __fastcall AnadirNodo(AnsiString nombreNodo,NodoArbol *NodoPadre=NULL);

        // Igual que AnadirNodo, la diferencia es que aade un nodo transform a
        // nodoPadre y dentro del campo children de este nodo transform aade
        // un nodo de nombre nombreNodo y devuelve un puntero a este nodo.
        // Si se produce algn error devuelve NULL. 
        NodoArbol *__fastcall AnadirNodoEnTransform(AnsiString nombreNodo,NodoArbol *nodoPadre=NULL);


        // Funciona como AnadirNodo, la nica diferencia es que asigna el campo,
        // de nombre nombreCampo con valor. Si el nombre del campo no existe o no
        // existe el nodo se advierte con un mensaje.
        NodoArbol * __fastcall AnadirNodoAsignandoUnCampo(AnsiString nombreNodo,
                                       AnsiString nombreCampo,AnsiString valor);

        // Aade un nuevo vnculo de rutado como hijo del nodo padre.
        // padre debe ser un nodo o la Raiz.
        void __fastcall AnadirVinculoRutado(NodoArbol *padre,NodoArbol *out,NodoArbol *in);
        void __fastcall AnadirVinculoRutado(NodoArbol *padre,AnsiString nodoOut,AnsiString campoOut,
                                                             AnsiString nodoIn,AnsiString campoIn);

        // Aade un comentario como hermano anterior de elemento.
        // elemento puede ser cualquier nodo. Si es la raiz o un campo MFNode se
        // aadir como primer primer hijo.
        // Devuelve un puntero al elemento aadido:
        NodoArbol * __fastcall AnadirComentario(NodoArbol *elemento,AnsiString texto);

        // Aade un nodo de tipo USE como hijo del campo elemento, si elemento es
        // un campo MFNode o un campo SFNode (sin el hijo asignado). Si no se
        // cumple ninguna de estas condiciones se aadir un nodo use como ltimo
        // hijo de la raiz. Elemento es el campo SFNode o MFNode (u otro).
        // Si elemento es NULL se aadir a la raiz.
        void __fastcall AnadirUSE(NodoArbol *elemento,AnsiString nombreDado,AnsiString nombreTipoNodo);

        // Reserva memoria para un nodo, e inicializa los campos del nuevo nodo,
        // pero no se asigna el campo TTreeNode (NodoAsociado es NULL).
        NodoArbol * __fastcall CrearNodo(TipoNodoArbol tipo);

        // Las siguientes funciones aaden un nodo NodoArbol al arbol:
        // AnadirPrimerHijo aade elemento como primer hijo de padre.
        // AnadirUltimoHijo aade elemento como ltimo hijo de padre.
        // AnadirHermanoAnterior aade elemento en la posicin anterior a la que ocupa hermano.
        // AnadirHemarnoSiguiente aade elemento en la posicin siguiente a la que ocupa hermano.
        // En todos los casos la variable nuevo->padre se asignar en la funcin.
        void __fastcall AnadirPrimerHijo(NodoArbol *nuevo,NodoArbol *padre);
        void __fastcall AnadirUltimoHijo(NodoArbol *nuevo,NodoArbol *padre);
        void __fastcall AnadirHermanoAnterior(NodoArbol *nuevo,NodoArbol *hermano);
        void __fastcall AnadirHermanoSiguiente(NodoArbol *nuevo,NodoArbol *hermano);

        // Recibe un puntero de tipo NodoArbol con elemento->nodoAsociado NULL. Y
        // crear el nodo asociado en el treeView. La funcin es recursiva para
        // crear tambin todos los hijos.
        void __fastcall CrearNodoAsociado(NodoArbol *elemento);

        // Si se modifica la escena desde el exterior hay que usar esta funcin
        // para indicar que la escena ha cambiado.
        // Si el cambio afecta a estadistica se debe pasar true en caso contrario
        // false (no se hace siempre la estadistica porque si la escena tiene
        // muchos elementos, esta funcin puede ser un poco lenta.)
        void __fastcall EscenaModificada(bool hacerEstadistica);
        // Funcin sobrecargada que devuelve true si no se ha guardado el ltimo
        // cambio.
        bool __fastcall EscenaModificada();

        // Cuando se da un nombre por defecto a un nodo es necesario comprobar
        // que ese nombre no existe en la escena. Para ello se usa esta funcin.
        // Devuelve verdadero si ya existe un nodo con ese nombre asignado y falso
        // en caso contrario.
        bool __fastcall ExisteNombreNodo(AnsiString nombre);

        // Estas dos funciones recorren el arbol actual devolviendo punteros a los
        // nodos del arbol. Se devolvern punteros a los nodos de tipo tipoNodoArbol.
        // por ejemplo si tipoNodoArbol = NODO; se devolvern todos los nodos del
        // arbol que sean nodos X3D/H3D. Cuando ya se hayan recorrido todos
        // los nodos del tipo indicado se devolver NULL.
        // Si en lugar de devolver tipos de nodos concretos se quieren recibir
        // todos los nodos (de todos los tipos) se pasar todos a true.
        void __fastcall IniciaRecorrerArbol(TipoNodoArbol tipoNodoArbol,bool todos=false);
        NodoArbol * __fastcall RecorrerArbol();

        // Ejecuta la escena actual. Se crear temporalmente un fichero que
        // se borrar al cerrar la escena actual.
        // El parmetro modo indica cmo se debe ejecutar la escena:
        // modo=0 -> Segn el tipo de escena se usar el ejecutable asociado
        //             a H3D o a X3D.
        // modo=1 -> Se ejecutar la escena con el fichero .exe asociado a los archivos X3D.
        // modo=2 -> Se ejecutar la escena con el fichero .exe asociado a los archivos H3D.
        void __fastcall Ejecutar(int modo=0);

        // Recibe el nombre de un fichero que ejecuta en Ms InternetExplorer o
        // en Rechin Load segn cual sea el valor de los parmetros modo y escena:
        // modo=0 -> Segn el tipo de escena se usar el ejecutable asociado
        //             a H3D o a X3D.
        // modo=1 -> Se ejecutar la escena con el fichero .exe asociado a los archivos X3D.
        // modo=2 -> Se ejecutar la escena con el fichero .exe asociado a los archivos H3D.
        void __fastcall EjecutarFichero(AnsiString fichero, int modo, TipoEscena tipoEscena);

        // Esta funcin cambia el nombre del fichero asociado a la escena.
        // DEBE ser un nombre de fichero con la ruta completa.
        void __fastcall CambiarNombreEscena(AnsiString fichero);

        // Salva la escena actual a disco (el nombre del fichero est en el nodo raiz).
        // Devuelve verdadero si se salva el fichero a disco y falso si se
        // cancela la operacin.
        bool __fastcall SalvarEscena();

        // Salva la escena actual a disco abriendo un cuadro de dilogo para que
        // el usuario introduzca un nombre.
        // Devuelve verdadero si se salva el fichero a disco y falso si se
        // cancela la operacin.
        bool __fastcall SalvarEscenaComo();

        // Esta funcin borra el fichero de prueba que se genera cuando se
        // ejecuta la escena. Recibe el nombre del fichero que se est
        // editando (con la ruta completa incluida la extensin).
        void __fastcall BorrarFicheroPrueba(AnsiString fichero);

        // Al llamar a esta funcin se comprueba si la escena ha sido modificada.
        // Si no se ha modificado devuelve true (seguir=true). Si la escena se
        // ha modificado se preguntar al usuario si desea guardar los cambios.
        // Si el usuario reponde afirmativamente se salva el fichero y se devuelve
        // true. Si responde pulsando "No" no se salvar el fichero y se devolver
        // true. En el caso en el que pulse el botn cancelar se devuelve false.
        bool __fastcall PreguntarSalvar();

        // Corta al portapapeles elemento. La informacin se escribe segn la
        // especificacin VRML 97 con la codificacin UTF8 (Unicode).
        void __fastcall Cortar(NodoArbol *elemento);


        // Estas funciones expanden o comprimen recursivamente el nodo
        // seleccionado -> Si no hay seleccionado ningn nodo no se hace nada.
        void __fastcall ExpandirNodoActual();
        void __fastcall ComprimirNodoActual();

        // Copia al portapapeles elemento. La informacin se escribe segn la
        // especificacin VRML 97 con la codificacin UTF8 (Unicode).
        void __fastcall Copiar(NodoArbol *elemento);

        // Pega el contenido del portapapeles teniendo en cuenta el tipo de
        // elemento del arbol seleccionado. La informacin se lee segn la
        // especificacin VRML 97 con la codificacin UTF8 (Unicode).
        void __fastcall Pegar();

        // Pega texto como hijo del nodo padre. Si padre no puede tener hijos,
        // se pegar en la raiz. Si padre es NULL tb se pegar en la raiz:
        // Si hay errores en texto se devuelve false.
        bool __fastcall Pegar(TStringList *texto,NodoArbol *padre);

        // Aade elemento a la estructura del treeView. Se asume que ni elemento
        // ni sus descendientes tienen asignado su nodo asociado (todos deben
        // ser NULL). Pega elemento como hijo de seleccionado.
        // Si se consigue pegar elemento, se desvincular del padre poniendo el
        // vnculo del padre a NULL y el vinculo elemento->padre
        // apuntar a su nuevo padre.
        void __fastcall PegarElemento(NodoArbol *seleccionado,NodoArbol *elemento,bool actualizar=true);

        // Esta funcin busca un nodo al que se le haya dado el nombre nombreDado
        // (usando DEF). Si se encuentra el nodo de vuelve un puntero a l, en
        // caso contrario se devuelve NULL.
        // IMPORTANTE: Esta funcin usa internamente las funciones de recorrido
        // del arbol por lo que no podr llamarse a BuscarNodoDEF si se entn
        // usando las funciones que recorren el arbol.
        NodoArbol *__fastcall BuscarNodoDEF(AnsiString nombreDado);

        // Esta funcin actualiza la apariencia del arbol TreeViewla. Se
        // actualizarn todos los nombres de los nodos, pero no la estructura.
        // Es decir si han cambiado los nodos no se volver a representar la
        // estructura en pantalla. Es necesario hacerlo as porque cuando se
        // representa la estructura en pantalla se pierde la informacin de qu
        // nodos estn desplegados y cuales no. Si ha cambiado la estructura se
        // puede ejecutar la funcin DibujarArbol.
        void __fastcall ActualizaArbol();

        // Devuelve verdadero si la escena actual usa algn nodo de las
        // herramientas User Interface ToolKit de H3D.
        bool __fastcall UsaUI_ToolKit();

        // Actualiza el contenido de Editor con los datos de la escena.
        void __fastcall ActualizaCodigo();

        // Actualiza el contenido de la variable pblica estadistica.
        void __fastcall ActualizaEstadistica();

        // Esta funcin aade un nodo import como primer hijo de la raiz que
        // importa la libreras User Interface Toolkit
        // Solo se puede usar en escenas H3D pq en X3D no hay nodos Import
        // Antes de aadir el nodo import se comprueba que no est ya en la escena.
        void __fastcall ImportarUserInterfaceToolkit();

        // Activa la ventana Escena y pasa el foco al control adecuado segn el
        // Tab actualmente seleccionado.
        void __fastcall GetFoco();

        // Se editan los datos asociados al elemento actualmente seleccionado
        // en el TreeView: Campo, Nodos, Rutados, Comentarios, USE, etc.
        void __fastcall EditaDatos();

        // Asignar los campos rotation, scale y translation de los nodos transform
        // es una tarea tediosa. Esta funcin permite hacerlo de modo grfico mostrando
        // controles que permiten colocar objetos en la posicin deseada.
        // Esta funcin usa el nodo actualmente seleccionado que debe ser un
        // nodo transform (no es necesario que tenga un nombre dado). Y a
        // continuacin ejecuta la escena permitiendo al usuario colocar los
        // objetos contenidos en ese nodo transform. Si el usuario acepta los
        // cambios, se asignarn automticamente los campos del nodo transform elegido.
        // Solo se ha implementado para H3D.
        void __fastcall IniciaAsignarTransform();

        // Anlogo a IniciaAsignarTransform, pero en este caso hay que
        // seleccionar un campo de tipo SFRGB.
        void __fastcall IniciaAsignarRGB();

        // Anlogo a IniciaAsignarTransform, pero en este caso hay que
        // seleccionar un campo de tipo SFVec3f.
        void __fastcall IniciaAsignarSFVec3f();

        // Las siguientes funciones aaden ficheros VRML, texturas y sonidos.
        // Reciben el nombre de un fichero VRML, png y wav respectivamente.
        // Y aaden a la escena dentro de uno de estos nodos:
        //   Inline para Objetos VRML, ImageTexture para texturas,
        // Y en el caso de Sonidos hay que distinguir X3D de H3D porque no
        // se usa el mismo nodo: En VRML se crear un nodo AudioClip y en
        // H3D un nodo SoundBuffer.
        //   Hay una excepcin a lo anterior: Si el campo seleccionado en el
        // arbol tiene como nombre "url" y no es un evento -> se asignar file
        // a este campo.
        void __fastcall AnadirObjetoVRML(AnsiString file);
        void __fastcall AnadirTextura(AnsiString file);
        void __fastcall AnadirSonido(AnsiString file);

        __fastcall TfrmEscena(TComponent* Owner);
        __fastcall ~TfrmEscena();
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmEscena *frmEscena;
//---------------------------------------------------------------------------
#endif
