//
//     CLASE   frmEscena   
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Esta es la clase implementa un arbol que contendr todos los
       datos de las escena.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <vcl\Clipbrd.hpp>

#include "frmEscena_.h"
#include "Main_.h"
#include "frmEditorNodos_.h"
#include "frmEditor_.h"
#include "frmUtilidad_.h"
#include "frmIndiceNodos_.h"
#include "frmTools_.h"
#include "frmConsola_.h"
#include "Utilidad_.h"
#include "Configuracion_.h"
#include "GestorVRML_.h"
#include "RichEditVRML_.h"
#include "frmConsola_.h"

// En la lista de iconos se carga varios iconos especiales al principio de la
// lista. Y los iconos asociados a los tipos se cargan a partir de la posicin
// indicada por la constate INDEX_PRIMER_ICONO:
#define INDEX_ICONO_NODO 1
#define INDEX_ICONO_NODO_GENERICO 2
#define INDEX_ICONO_X3D 3
#define INDEX_ICONO_H3D 4
#define INDEX_ICONO_RUTADO 5
#define INDEX_ICONO_COMENTARIO 6
#define INDEX_ICONO_USE 7
#define INDEX_ICONO_TIPO_INDEFINIDO 8
#define INDEX_ICONO_PROTO 9
#define INDEX_PRIMER_ICONO 10

// Son el ancho mnimo y la altura mnima que tendr la ventana.
#define MIN_WIDTH 218
#define MIN_HEIGHT 203

// Es el nmero de dgitos que se usa en los nombres que se asignan por defecto
// a los nodos que se crean. Tambin hay que usar un lmite que ser 10 elevado
// a NUM_DIGITOS_EN_NOMBRES_POR_DEFECTO.
#define NUM_DIGITOS_EN_NOMBRES_POR_DEFECTO 2
#define MAX_NUM_NOMBRES_POR_DEFECTO 100

// Contiene el icono de tamao 20x20 que se asocia a las sentencias PROTO y
// EXTERNPROTO en el rbol.
#define FICH_PROTO_20x20 "proto.bmp"

// Contienen los ficheros que deben estar dentro de la carpeta de configuracin
// con las dos partes que se pegan en la escena para porder asignar Transform,SFRGB y SFVec3f
#define FICH_ASIGNA_TRANSFORM_1 "AsignaTransformVRML1.cfg"
#define FICH_ASIGNA_TRANSFORM_2 "AsignaTransformVRML2.cfg"
#define FICH_ASIGNA_RGB_1 "AsignaRGB_VRML1.cfg"
#define FICH_ASIGNA_RGB_2 "AsignaRGB_VRML2.cfg"
#define FICH_ASIGNA_SFVec3f_1 "AsignaVec3f_VRML1.cfg"
#define FICH_ASIGNA_SFVec3f_2 "AsignaVec3f_VRML2.cfg"

// Nombre del fichero contenido en la carpeta de configuracin que contiene el
// script que se usa para asignar Transform,SFRGB y SFVec3f:
#define FICH_ASIGNA_TRANSFORM_SCRIPT "AsignaTransformScript.py"
#define FICH_ASIGNA_RGB_SCRIPT "AsignaRGB_Script.py"
#define FICH_ASIGNA_Vec3f_SCRIPT "AsignaVec3f_Script.py"

// Para colocar los objetos es necesario crear un comentario con esta marca
// en la escena para luego modificar la escena aadiendo los controles que
// permiten colocar los objetos:
#define MARCA_PARA_COLOCAR_OBJTS "<-<-<-<-<-<-<-<- Marca para insertar Texto al colocar objetos ->->->->->->->->"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmEscena *frmEscena;

NodoArbol::NodoArbol(TipoNodoArbol tipo_tmp){              // Constructor.
   nodoAsociado=NULL;
   padre=NULL;
   tipo=tipo_tmp;     // Hay que dar un tipo por defecto (que puede ser cualquiera).
   dato=NULL;

   try{ hijos = new ArrayDinamico(); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   // Aprovechamos el constructor para reservar memoria para dato.
   try{
      switch (tipo){
         case RAIZ       :  dato = (void *) new TipoRaiz();       break;
         case NODO       :  dato = (void *) new TipoNodo();       break;
         case CAMPO      :  dato = (void *) new TipoCampo();      break;
         case RUTADO     :  dato = (void *) new TipoRutado();     break;
         case COMENTARIO :  dato = (void *) new TipoComentario(); break;
         case USE        :  dato = (void *) new TipoUSE();        break;
         case PROTO      :  dato = (void *) new TipoProto();      break;
         case EXTERNPROTO:  dato = (void *) new TipoExternProto();break;
      }
   }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }
}
//---------------------------------------------------------------------------
NodoArbol::~NodoArbol(){             // Destructor.
   // Aqui hay que borrar todo lo que haya en dato, y hay que hacerlo teniendo
   // en cuenta el valor de tipo:
   if(dato == NULL)
      return;
   switch (tipo){
      case RAIZ       : { TipoRaiz        *p;  p=(TipoRaiz        *)dato;  delete p; } break;
      case NODO       : { TipoNodo        *p;  p=(TipoNodo        *)dato;  delete p; } break;
      case CAMPO      : { TipoCampo       *p;  p=(TipoCampo       *)dato;  delete p; } break;
      case RUTADO     : { TipoRutado      *p;  p=(TipoRutado      *)dato;  delete p; } break;
      case COMENTARIO : { TipoComentario  *p;  p=(TipoComentario  *)dato;  delete p; } break;
      case USE        : { TipoUSE         *p;  p=(TipoUSE         *)dato;  delete p; } break;
      case PROTO      : { TipoProto       *p;  p=(TipoProto       *)dato;  delete p; } break;
      case EXTERNPROTO: { TipoExternProto *p;  p=(TipoExternProto *)dato;  delete p; } break;
   }

   if(hijos != NULL)
      delete hijos;

}
//---------------------------------------------------------------------------
bool _fastcall NodoArbol::EsCampoEvento(){
   return this->EsCampo() && ( (this->AsCampo()->datosCampo->rutado == EVENTIN) ||
                               (this->AsCampo()->datosCampo->rutado == EVENTOUT) );
}
//---------------------------------------------------------------------------
bool _fastcall NodoArbol::EsCampoSFNodeNoEvento() {
   return this->EsCampo() && (this->AsCampo()->tipoCampo == SFNODE) &&
                             (this->AsCampo()->datosCampo->rutado != EVENTIN) &&
                             (this->AsCampo()->datosCampo->rutado != EVENTOUT);
}
//---------------------------------------------------------------------------
bool _fastcall NodoArbol::EsCampoMFNodeNoEvento() {
   return this->EsCampo() && (this->AsCampo()->tipoCampo == MFNODE) &&
                             (this->AsCampo()->datosCampo->rutado != EVENTIN) &&
                             (this->AsCampo()->datosCampo->rutado != EVENTOUT);
}
//---------------------------------------------------------------------------
NodoArbol * __fastcall NodoArbol::GetHijo(int n,TipoNodoArbol tipoNodoArbol){

  if( (n< 0) && (n >= hijos->MaxIndexUsado()) )
     return NULL;
  // Vamos a recorrer hijos y a devolver el elemento de tipo tipoNodoArbol
  // que ocupa la posicin n ( n>=0 ). Si tipoNodoArbol == TNA_INDEFINIDO entonces
  // los hijos considerados pueden ser de cualquier tipo.
  NodoArbol *p;
  int elementos=0;
  for(int c=0; c <= hijos->MaxIndexUsado() ; c++){
     p=(NodoArbol *)hijos->Get(c);
     if( (p!= NULL) &&  ( (tipoNodoArbol == TNA_INDEFINIDO) || (p->tipo == tipoNodoArbol) ) ){
        if(elementos == n)
           return p;  // Ya hemos encontrado el elemento n.
        elementos++;
     }
  }
  return NULL;
}
//---------------------------------------------------------------------------
__fastcall TfrmEscena::TfrmEscena(TComponent* Owner)
        : TForm(Owner)
{
   GN=NULL;
   GT=NULL;
   Raiz=NULL;
   FormateoAnulado=false;
   RecorrerArbolLastIndex=0;
   RecorrerArbolRecorrerTodos=false;
   EscenaHaCambiado=false;
   Estadistica="";
   BusquedaCadena="";
   NodoArrastrado=NULL;
   BusquedaTipoElemento=0;
   BusquedaDistinguir=true;

   try{ ErroresDeLectura=new TStringList(); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }
}
//------------------------------------------------------------------------------
__fastcall TfrmEscena::~TfrmEscena()
{
   // Si hemos creado un fichero de prueba para la escena actual hay que eliminarlo.
   if( (Raiz != NULL) && Raiz->EsRaiz() )
      BorrarFicheroPrueba(Raiz->AsRaiz()->fichero);
   // Liberamos la memoria ocupada.
   EliminarNodo(Raiz);
   if(ErroresDeLectura != NULL)
     delete ErroresDeLectura;
}
//---------------------------------------------------------------------------
NodoArbol * __fastcall TfrmEscena::CrearNodo(TipoNodoArbol tipo){

   NodoArbol *nodo;
   try{ nodo= new NodoArbol(tipo);  // El constructor inicializa los valores de las variables.
   }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   return nodo;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::DibujarArbol(NodoArbol *nodo1,TTreeNode *nodo2){
    if(nodo1==NULL)
       return;

    // Cuando el nodo2 es NULL hay que borrar el arbol TreeView.
    if(nodo2==NULL)
       TreeView->Items->Clear();

    // Para implementar esta funcin lo nico que hay que hacer es recorrer el
    // rbol y a la vez ir creando otro rbol en paralelo.

    // En este punto hay que representar el nodo actual y todos los hijos.
    // Primero representamos el nodo y despus todos sus Hijos.
    TTreeNode *nuevoNodoTreeView;

    nuevoNodoTreeView = TreeView->Items->AddChild(nodo2,GetNombreTreeView(nodo1));

    // Ahora vinculamos los dos nodos.
    nodo1->nodoAsociado = nuevoNodoTreeView;
    nuevoNodoTreeView->Data = (void *) nodo1;

    // Asociamos el icono dependiendo de nodo1->tipo
    AsignarIcono(nodo1);

    // Ahora aadimos todos los hijos.
    int maxIndexUsado;
    maxIndexUsado = nodo1->hijos->MaxIndexUsado();
    for(int i=0; i <= maxIndexUsado; i++)
       DibujarArbol((NodoArbol *) nodo1->hijos->Get(i) , nuevoNodoTreeView);
}
//---------------------------------------------------------------------------
AnsiString __fastcall TfrmEscena::Formatea(int num,int digits){
   AnsiString s="";
   double y,x=1;
   int tmp;
   y=(double) num;
   for(int c=1;c < digits;c++)
      x*=10;
   for(int c=0;c < digits;c++){
      tmp= (int)(y / x);
      s+= (AnsiString)(char)(tmp + 48);
      y=y-x*((double) tmp);
      x=x/10;
   }
   return s;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TfrmEscena::GetNombreTreeView(NodoArbol *elemento){
     if( (elemento == NULL) || (elemento->dato == NULL) ) 
         return "";

    switch (elemento->tipo)
    {
      case RAIZ   :
             if(  elemento->AsRaiz()-> tipoEscena  == ESCENA_X3D   )
                 return (AnsiString)"X3D:" + ExtractFileName(elemento->AsRaiz()->fichero);
             else if(  elemento->AsRaiz()-> tipoEscena  == ESCENA_H3D   )
                 return (AnsiString)"H3D:" + ExtractFileName(elemento->AsRaiz()->fichero);
      case NODO   :
           if (!CONF.VER_NOMBRE_NODO_EN_EL_ARBOL)
               return elemento->AsNodo()->nombre;
           else{
               if( elemento->AsNodo()->nombreDado.Trim() == "")
                   return elemento->AsNodo()->nombre;
               else
                   return elemento->AsNodo()->nombre + ": " + elemento->AsNodo()->nombreDado;
           }
      case CAMPO  :
           return elemento->AsCampo()->nombre;
      case RUTADO : {
            TipoRutado *vinculo;
            vinculo = elemento->AsRutado();
            AnsiString texto;
            texto = vinculo->nodoOut + "." + vinculo->campoOut;
            texto += " ---> ";
            texto += vinculo->nodoIn + "." + vinculo->campoIn;;
            return texto;
      }
      case COMENTARIO  :
           {
              //  Si el comentario tiene varias lneas aparecera en el rbol los
              // caracteres 13 y 10  -> los eliminamos del comentario. 
              AnsiString cad = elemento->AsComentario()->texto;
              for(int c=1; c <= cad.Length();c++)
              {
                 if( (cad[c] == '\r') || (cad[c] == '\n') )
                    cad[c] = ' ';
              }
              return cad;
           }
      case USE :
           return "USE: " + elemento->AsUSE()->nombreDado;
      case PROTO:
           return "PROTO: " + elemento->AsProto()->nombre;
      case EXTERNPROTO:
           return "EXTERNPROTO: " + elemento->AsExternProto()->nombre;
    }
    return "";
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::Posiciona(){
    if( (frmTools == NULL) || (frmEditorNodos == NULL) )
       return;
    int Top,Left,Height,Width;
    Top= CONF.MARGEN_POSICIONADO_DE_VENTANAS;
    Left=CONF.MARGEN_POSICIONADO_DE_VENTANAS + frmEditorNodos->Width;
    if(CONF.VER_HERRAMIENTAS_COMO == "VENTANA")
       Width= frmTools->Left - frmEditorNodos->Left - frmEditorNodos->Width;
    else
       Width= Main->ClientWidth - frmEditorNodos->Left - frmEditorNodos->Width - CONF.MARGEN_POSICIONADO_DE_VENTANAS-4;
    if(CONF.VER_HERRAMIENTAS_COMO == "BARRA")
       Height= Main->ClientHeight - 2*CONF.MARGEN_POSICIONADO_DE_VENTANAS - Main->BarraEstado->Height - Main->pnlTools->Height - Main->ToolBar->Height - 4;
    else
       Height= Main->ClientHeight - 2*CONF.MARGEN_POSICIONADO_DE_VENTANAS - Main->BarraEstado->Height - Main->ToolBar->Height - 4;
    SetBounds(Left,Top,Width,Height);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::IniciaEscena(GestorNodos *GN_, GestorTipos *GT_){

   GN=GN_;
   GT=GT_;

   // Ahora borramos los datos del arbol anterior.
   EliminarNodo(Raiz);
   Raiz=NULL;

   // Eliminamos tambin todos los datos representados.
   TreeView->Items->Clear();
   Codigo->Clear();

   // Ahora Rellenamos la lista de imgenes con los iconos de los tipos.
   // El primer icono que aadimos es una imagen en blanco y el segundo es
   // el icono que se asocia a los nodos. y a continuacin se cargan todos
   // los iconos de los tipos.
   TPicture *imagen;

   try{ imagen=new TPicture; }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   ListaIconos->Clear();
   if(!(Utilidad.GetImagen(imagen,"",CONF.ICONO_BLANCO_20x20)))
       Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + CONF.ICONO_BLANCO_20x20);
   ListaIconos->Add(imagen->Bitmap,NULL);

   if(!(Utilidad.GetImagen(imagen,"",CONF.ICONO_NODO_ARBOL)))
       Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + CONF.ICONO_NODO_ARBOL);
   ListaIconos->Add(imagen->Bitmap,NULL);

   if(!(Utilidad.GetImagen(imagen,"",CONF.ICONO_NODO_GENERICO_ARBOL)))
       Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + CONF.ICONO_NODO_ARBOL);
   ListaIconos->Add(imagen->Bitmap,NULL);

   if(!(Utilidad.GetImagen(imagen,"",CONF.ICONO_X3D_20x20)))
       Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + CONF.ICONO_X3D_20x20);
   ListaIconos->Add(imagen->Bitmap,NULL);

   if(!(Utilidad.GetImagen(imagen,"",CONF.ICONO_H3D_20x20)))
      Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + CONF.ICONO_H3D_20x20);
   ListaIconos->Add(imagen->Bitmap,NULL);

   if(!(Utilidad.GetImagen(imagen,"",CONF.ICONO_RUTADO_20x20)))
      Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + CONF.ICONO_RUTADO_20x20);
   ListaIconos->Add(imagen->Bitmap,NULL);

   if(!(Utilidad.GetImagen(imagen,"",CONF.ICONO_COMENTARIO_20x20)))
      Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + CONF.ICONO_COMENTARIO_20x20);
   ListaIconos->Add(imagen->Bitmap,NULL);

   if(!(Utilidad.GetImagen(imagen,"",CONF.ICONO_USE_20x20)))
      Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + CONF.ICONO_USE_20x20);
   ListaIconos->Add(imagen->Bitmap,NULL);

   if(!(Utilidad.GetImagen(imagen,"",CONF.ICONO_GENERAL_TIPO)))
      Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + CONF.ICONO_GENERAL_TIPO);
   ListaIconos->Add(imagen->Bitmap,NULL);

   if(!(Utilidad.GetImagen(imagen,"",FICH_PROTO_20x20)))
      Utilidad.FatalError((AnsiString)"The following file doesn't exist: " + FICH_PROTO_20x20);
   ListaIconos->Add(imagen->Bitmap,NULL);

   delete imagen;

   // Ahora cargamos el resto de iconos.
   Tipo *tipo;
   for(int i=0; i < GT->GetNumTipos(); i++){
      tipo=GT->DatosTipo(i);
      ListaIconos->Add(tipo->icono->Bitmap,NULL);
   }

   // Ahora aadimos el nodo raiz.
   Raiz=CrearNodo(RAIZ);   // Esto reserva la memoria para un nodo.

   // Ahora vamos a asignar todos los campos del primer nodo.
   Raiz->AsRaiz()->fichero = FICHERO_POR_DEFECTO + (AnsiString)EXTENSION_X3D;
   Raiz->AsRaiz()->tipoEscena = (TipoEscena) GN->tipoEscena;

   // Consideramos que la escena si ha cambiado.
   EscenaHaCambiado=true;

   DibujarArbol(Raiz,NULL);
   ActualizaCodigo();

   if( (Raiz != NULL) && (frmEditorNodos != NULL) ){
      TreeView->Selected = Raiz->nodoAsociado;
      frmEditorNodos->Carga(Raiz);
   }
}
//------------------------------------------------------------------------------
void __fastcall TfrmEscena::IniciaEscena(AnsiString fichero,TipoEscena tipoEscena,NodoArbol *raiz){

   if( !Utilidad.Existe(fichero) )
       return;

   // Solo se usan los prefijos y sufijos en los rutados de los campos exposedfield
   // de escenas X3D y no en H3D. An as este parametro puede configurarse
   // As prevemos posibles modificaciones del sw de H3D para comportarse como X3D.
   if(tipoEscena == ESCENA_H3D){
      if(CONF.USAR_PREF_Y_SUF_EN_RUTADOS_H3D){
         Main->Prefijo_ExpField = CONF.PREFIJO_EXPOXEDFIELD_AS_EVENTIN;
         Main->Sufijo_ExpField  = CONF.SUFIJO_EXPOXEDFIELD_AS_EVENTOUT;
      }else{
         Main->Prefijo_ExpField = "";
         Main->Sufijo_ExpField  = "";
      }
   }else{
      Main->Prefijo_ExpField = CONF.PREFIJO_EXPOXEDFIELD_AS_EVENTIN;
      Main->Sufijo_ExpField  = CONF.SUFIJO_EXPOXEDFIELD_AS_EVENTOUT;
   }

   if(tipoEscena == ESCENA_X3D)
       IniciaEscena(Main->GNX,Main->GTX);
   else if(tipoEscena == ESCENA_H3D)
       IniciaEscena(Main->GNH,Main->GTH);

   // Es posible que cargar el fichero de disco lleve unos instantes.
   Utilidad.LoadFromFile(Main->LineasAux,fichero);

   if(Utilidad.EsFicheroBinario(Main->LineasAux))
      Utilidad.MsgInfo("It isn't possible to load compressed files.","Advertencia");

   // Si hay errores y el usuario los edita necesitaremos estas variables:
   bool textoModificado=false;
   TPoint posCursor=TPoint(0,0);
   bool fin; //  = true; comentado para evitar el warning "is assigned a value thar is never used
   bool cargarEscena=false;
   bool primeraIteracion=true;
   // En este bucle se presentarn al usuario los errores detectados durante la
   // carga de la escena y se le dar la oportunidad de editar el fichero y cada
   // vez que acabe la edicin se volver a intentar cargar la escena mostrando
   // los errores encontrados.

   // En este punto tenemos dos posibilidades, que raiz sea NULL -> entonces
   // hay que leer los datos aqui o bien que raiz ya contenga la estructura de
   // datos cargada en memoria:
   if(raiz != NULL){
      // En este caso suponemos que la escena no tiene errores y que ya est
      // cargada en memoria.
      fin=true;
   }else{
      int numNodosGenericos;
      raiz=GVRML.CargaEscena(Main->LineasAux , ErroresDeLectura, fichero,tipoEscena, true, numNodosGenericos);
      // Si el fichero es muy extenso es necesario refrescar las ventanas:
      Main->Repaint();
      fin= (ErroresDeLectura->Count == 0);
   }

   while(!fin){

      // Desde CargaEscena ya se inicializa la escena actual segn el tipo de gestor
      // de nodos H3D/X3D.
      if(cargarEscena){
         // si se ha cargado una escena anteriormente hay que eliminar los datos.
         if(raiz != NULL)
            EliminarNodo(raiz);
         int numNodosGen;
         raiz=GVRML.CargaEscena(Main->LineasAux , ErroresDeLectura, fichero,tipoEscena,true,numNodosGen);
         // Si el fichero es muy extenso es necesario refrescar las ventanas:
         Main->Repaint();
      }

      if( (!primeraIteracion) && (ErroresDeLectura->Count == 0) ){
         Utilidad.MsgInfo("The scene has been loaded successfully.");
         break;
      }

      int errorNum = frmUtilidad->IniciaErrores(ErroresDeLectura,"Detected Problems while loading the Scene:");

      Main->Repaint();

      if( -1 != errorNum ){
           // El usuario ha decidido editar los cambios.
           // Obtenemos la posicin donde est el error.
           posCursor = GetPosCursorXML(Main->LineasAux, ErroresDeLectura->Strings[errorNum]);

           if( frmEditor->Inicia(Main->LineasAux,fichero,textoModificado,tipoEscena,posCursor) ){
               // El usuario pulsa mantener los cambios, as que intentamos de nuevo leer la escena.
               // (se supone que se ha intentado arreglar el error).
               // Asignamos los datos:
               fin = false;
               cargarEscena=true;  // -> Volvemos a leer la escena.

           }else{
               // El usuario no desea mantener los cambios -> Volvemos a Mostrar los Errores.
               fin = false;
               cargarEscena=false;  // -> No cargamos la escena.
           }
       }else{
          // El usuario ha pulsado aceptar -> Seguimos.
          Utilidad.MsgInfo("The file contains errors. It hasn't been possible to load the entire scene.","Advertencia");
          fin =true;
       }
       primeraIteracion =false;
   }


   if(raiz != NULL){
      Raiz=raiz;

      // Dibujar el rbol puede llevar algn tiempo, usamos el reloj de arena.
      Screen->Cursor=PUNT_RATON_ESPERA;
      DibujarArbol(Raiz,NULL);
      Screen->Cursor=PUNT_RATON_NORMAL;

      Raiz->nodoAsociado->Expand(false);

      // Seleccionamos el nodo Raiz -> Con esto se desplaza toda escena al principio.
      TreeView->Selected=Raiz->nodoAsociado;
      frmEditorNodos->Carga(Raiz);

      // Vamos a intentar que el elemento seleccionado sea el primer nodo que
      // apareza en la Raiz -> As mejora el aspecto del editor de nodos:
      for(int c=0; c <= Raiz->hijos->MaxIndexUsado(); c++){
           NodoArbol *p = (NodoArbol *) Raiz->hijos->Get(c);
           if( (NULL != p) && (p->nodoAsociado != NULL) && p->EsNodo() ){
              TreeView->Selected = p->nodoAsociado;
              frmEditorNodos->Carga(p);
              c=Raiz->hijos->MaxIndexUsado(); // Salimos del bucle.
           }
      }
   }else{
      // Si el fichero que intentamos cargar no tiene ningn nodo VRML, hay que
      // evitar que la escena tenga Raiz a NULL porque en ese caso podra fallar
      // el cdigo -> As llamamos a IniciaEscena con los gestores actuales para
      // tener una escena nueva, solo con el elemento Raiz.
      IniciaEscena(GN,GT);
   }

   ActualizaCodigo();

   // Consideramos que la escena no ha cambiado, es decir no se preguntar si se
   // desea salvar el fichero.
   // El usuario ha podido modificar el contenido del fichero si se han encontrado
   // errores.
   EscenaHaCambiado=textoModificado;
   Actualiza();
}
//--------------------------------------------------------------------------------
void __fastcall TfrmEscena::ActualizaDesdeAnsiString(AnsiString &datos,AnsiString nombrefichero,bool escenaModificada){

   if(Raiz == NULL)
      return;

   // Guardamos el tipo de escena actual.
   TipoEscena tipoEscena= Raiz->AsRaiz()->tipoEscena;

   // Ahora borramos los datos del arbol anterior.
   EliminarNodo(Raiz);
   Raiz=NULL;

   // Desde CargaEscena ya se inicializa la escena actual segn el tipo de gestor
   // de nodos H3D/X3D. -> No hay que hacerlo aqui.

   // Si hay errores y el usuario los edita necesitaremos estas variables:
   bool textoModificado=false;
   TPoint posCursor(0,0);
   bool fin; //  = true; comentado para evitar el warning "is assigned a value thar is never used
   NodoArbol *raiz;
   bool cargarEscena=true;
   bool primeraIteracion=true;

   Screen->Cursor=PUNT_RATON_ESPERA;

   // En este bucle se presentarn al usuario los errores detectados durante la
   // carga de la escena y se le dar la oportunidad de editar el fichero y cada
   // vez que acabe la edicin se volver a intentar cargar la escena mostrando
   // los errores encontrados.
   do{
      // Desde CargaEscena ya se inicializa la escena actual segn el tipo de gestor
      // de nodos H3D/X3D.
      if(cargarEscena){
         int numNodoGen;
         raiz=GVRML.CargaEscena(Main->LineasAux, ErroresDeLectura, nombrefichero,tipoEscena,true,numNodoGen);
      }

      if( (!primeraIteracion) && (ErroresDeLectura->Count == 0) )
         Utilidad.MsgInfo("The scene has been loaded successfully.");

      int errorNum = frmUtilidad->IniciaErrores(ErroresDeLectura,"Detected Problems while loading the Scene:");
      Main->Repaint();

      if( -1 != errorNum ){
           posCursor = GetPosCursorXML(Main->LineasAux, ErroresDeLectura->Strings[errorNum]);
           // El usuario ha decidido editar los cambios.

           if( frmEditor->Inicia(Main->LineasAux,nombrefichero,textoModificado,tipoEscena,posCursor) ){
               // El usuario pulsa mantener los cambios, as que intentamos de nuevo leer la escena.
               // (se supone que se ha intentado arreglar el error).
               // Asignamos los datos:

               fin = false;
               cargarEscena=true;  // -> Volvemos a leer la escena.
           }else{
               // El usuario no desea mantener los cambios -> Volvemos a Mostrar los Errores.
               fin = false;
               cargarEscena=false;  // -> Volvemos a leer la escena.
           }
       }else{
          // El usuario ha pulsado aceptar -> Seguimos.
          fin =true;
       }
       primeraIteracion =false;

   }while (!fin);

   if(raiz != NULL){
      Raiz=raiz;
      DibujarArbol(Raiz,NULL);
      Raiz->nodoAsociado->Expand(false);


      // Seleccionamos el nodo Raiz -> Con esto se desplaza toda escena al principio.
      TreeView->Selected=Raiz->nodoAsociado;
      frmEditorNodos->Carga(Raiz);

      // Vamos a intentar que el elemento seleccionado sea el primer nodo que
      // apareza en la Raiz -> As mejora el aspecto del editor de nodos:
      for(int c=0; c <= Raiz->hijos->MaxIndexUsado(); c++){
           NodoArbol *p = (NodoArbol *) Raiz->hijos->Get(c);
           if( (NULL != p) && (p->nodoAsociado != NULL) && p->EsNodo() ){
              TreeView->Selected = p->nodoAsociado;
              frmEditorNodos->Carga(p);
              c=Raiz->hijos->MaxIndexUsado(); // Salimos del bucle.
           }
      }
   }else{
      // Si el fichero que intentamos cargar no tiene ningn nodo VRML, hay que
      // evitar que la escena tenga Raiz a NULL porque en ese caso podra fallar
      // el cdigo -> As llamamos a IniciaEscena con los gestores actuales para
      // tener una escena nueva, solo con el elemento Raiz.
      IniciaEscena(GN,GT);
   }

   // Consideramos que la escena no ha cambiado, es decir no se preguntar si se
   // desea salvar el fichero.
   EscenaHaCambiado=escenaModificada;
   ActualizaCodigo();
   ActualizaArbol();
   ActualizaEstadistica();
   Main->ActualizaBarraEstado();
}
//------------------------------------------------------------------------------
void __fastcall TfrmEscena::FormCreate(TObject *Sender)
{
   // Vamos a crear el nodo raiz con el tipo de escena por defecto.
   if(CONF.TIPO_ESCENA_POR_DEFECTO == ESCENA_X3D)
      IniciaEscena(Main->GNX,Main->GTX);
   else if (CONF.TIPO_ESCENA_POR_DEFECTO == ESCENA_H3D)
      IniciaEscena(Main->GNH,Main->GTH);

    Width=MIN_WIDTH;
    Height=MIN_HEIGHT;
    // Con esto evitamos que se vea como cambia de tamao la ventana frmEscena
    // cuando se ejecuta inicialmente Posiciona.
    Left=Screen->Width;
    Carpetas->ActivePageIndex=0;

    // Al formatear el texto de Codigo es imprescindible que ReadOnly sea
    // false. No entiendo porqu pero es el nico modo que he encontrado de
    // que no aparezcan trozos de texto con un formato extrao al hacer un scroll.
    // Y adems no funciona si se asigna la propiedad en tiempo de ejecucin justo
    // antes de formatear la pantalla.
    Codigo->ReadOnly = false;

    // Las propiedades y mtodos de Codigo no son sufientes para hacer algunas
    // cosas por ello hay que recurrir a las API de windows interceptando los
    // mensajes que se envan al control. Por ejemplo para saber cuando se hace
    // un scroll. As se interceptan estos mensajes.
    FuncionOriginal=Codigo->WindowProc;
    Codigo->WindowProc=CapturaMensaje;

    // Actualizamos el aspecto de Codigo.
    ReVRML.Inicia(frmEscena,frmEscena->Codigo,2);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::EliminarNodo(NodoArbol *nodo,bool exterior){

   if(nodo==NULL)
      return;

   // Si la llamada es desde el exterior habr que borrar el nodo asociado.
   // Esto es porque la clase TTreeNodes ya elimina internamente de forma
   // recursiva todos los nodos.
   if( (exterior) && (nodo->nodoAsociado != NULL) )
       TreeView->Items->Delete(nodo->nodoAsociado);

   // Si borramos algn elemento que se est usando en el editor de nodos habr
   // punteros no a null si no ha zonas prohibidas de memoria -> Errores -> Los evitamos:
   if( (exterior) && (frmEditorNodos != NULL) )
       frmEditorNodos->Carga(NULL);

   // Vamos a borrar todos los hijos del arbol -> Hay que hacer llamadas
   // recursivas.
   int maxIndexHijos;
   maxIndexHijos=nodo->hijos->MaxIndexUsado();

   for(int i=0; i <= maxIndexHijos; i++)
       EliminarNodo( (NodoArbol *) (nodo->hijos->Get(i)) , false);

   // Ahora hay que eliminar la referencia del nodo padre al nodo nodo hijo.
   // Hay que buscar en el array de hijos una casilla que contenga un puntero
   // que valga igual que nodo:

   if(nodo->padre != NULL){
       int i=0;
       while( (i <= nodo->padre->hijos->MaxIndexUsado()) && (nodo != (NodoArbol *)nodo->padre->hijos->Get(i)))
          i++;
       if (i <= nodo->padre->hijos->MaxIndexUsado())
           // En este caso se ha salido del while por que ha dejado de cumplirse
           // la segunda condicin y esto quiere decir que se ha encontrado el nodo.
           nodo->padre->hijos->Set(NULL,i);
       else
           Utilidad.FatalError("Error Nodo hijo Hurfano.");
   }

   // Una vez que hemos borrado todos los hijos y que hemos puesto a NULL
   // la referencia del nodo padre, podemos borrar el nodo.
   delete nodo;
}

//---------------------------------------------------------------------------
NodoArbol * __fastcall TfrmEscena::AnadirNodo(AnsiString nombreNodo,NodoArbol *NodoPadre){

   if( (nombreNodo == "") || (Raiz==NULL) )
      return NULL;

   NodoArbol *padre,*nuevo,*hijo;
   TTreeNode *padreTreeNode,*nuevoTreeNode,*hijoTreeNode;

   if(NodoPadre != NULL)
       padre = NodoPadre;
   else if(TreeView->Selected != NULL)
      padre = (NodoArbol *) TreeView->Selected->Data;
   else
      padre = Raiz;

   padreTreeNode=padre->nodoAsociado;

   // Cuando no se pueda insertar un elemento en padre lo pegaremos en el
   // nodo padreComun. Este nodo ser el primer nodo de tipo MFNode que nos
   // encontremos al ascender por el arbol desde padre:
   // Tras el siguiente bucle, padreComun ser la Raiz o bien un campo de tipo
   // MFNode.
   NodoArbol *padreComun = padre;
   while( (padreComun != NULL) && !padreComun->EsRaiz() && !padreComun->EsCampoMFNodeNoEvento() )
      padreComun = padreComun->padre;

   if(padreComun == NULL)
      padreComun = Raiz;

   // Si el campo seleccionado es SFNODE o MFNODE y adems es un evento no podr
   // tener hijos -> avisamos de esto.
   if ( padre->EsCampo() &&
         (  (padre->AsCampo()->datosCampo->rutado == EVENTIN)  ||
            (padre->AsCampo()->datosCampo->rutado == EVENTOUT)  )  ){

      AnsiString cad = (padreComun->nodoAsociado == NULL) ? (AnsiString)"the root" : padreComun->nodoAsociado->Text;
      Utilidad.MsgInfo("The selected field is an event and it can't have children. The node will be added in " + cad + ".");
   }


   // Hay que comprobar que se puedan aadir nodos al nodo seleccionado.
   // Solo se pueden aadir nodos a la raiz o a un campo de tipo MFNode.
   // o SFNODE que no sea EventIn ni EventOut.
   // As que cuando no podamos aadir el nodo en padre lo haremos en padreComun:
   if (     (!padre->EsCampo()) ||
            (padre->AsCampo()->datosCampo->rutado == EVENTIN)  ||
            (padre->AsCampo()->datosCampo->rutado == EVENTOUT) ||
            (   (padre->AsCampo()->tipoCampo != MFNODE)  &&
                (padre->AsCampo()->tipoCampo != SFNODE)  )        ){
          // En este caso el nodo no es un nodo MFNode as que lo aadimos en padreComun
          padre = padreComun;
          padreTreeNode=padre->nodoAsociado;
   }

   // Lo primero es obtener los datos del gestor de nodos.
   Nodo *datosNodo;
   datosNodo = GN->DatosNodo(nombreNodo);
   if(datosNodo == NULL){
      Utilidad.MsgInfo("The node " + nombreNodo + " is not registered. You can use the settings window to register types and nodes.","Error");
      return NULL;
   }

   // Ya tenemos los datos del nodo. Ahora creamos un nuevo nodo del arbol y
   // asignamos sus campos.

   nuevo = CrearNodo(NODO);

   nuevo->padre=padre;
   //  nuevo->nodoAsociado  Se asignar luego (al crear el TTreeNode).
   // hijos no se asigna pq el constructor de hijos ya lo inicializa.

   // Por comodidad usamos un puntero a los datos del nuevo nodo.
   TipoNodo *nuevoNodo = (TipoNodo *)nuevo->dato;
   nuevoNodo->nombre=nombreNodo;
   // nuevoNodo->nombreDado   Se asigna despus.
   nuevoNodo->datosNodo=datosNodo;

   if(CONF.NOMBRAR_NODOS_AUTOMATICAMENTE){
         // Vamos a dar un valor por defecto al nombre del nodo. Esto es necesario para
         // poder utilizar el rutado de nodos que el usuario no haya nombrado explicitamente.
         // El criterio que seguiremos es que el nombre del nodo sea igual al nombre del
         // nodo X3D/H3D seguido de 4 dgitos por ejemplo Group0001.
         int cont=1;
         do{
             nuevoNodo->nombreDado = nuevoNodo->nombre + Formatea(cont++,NUM_DIGITOS_EN_NOMBRES_POR_DEFECTO);
         }while(ExisteNombreNodo(nuevoNodo->nombreDado) && (cont < MAX_NUM_NOMBRES_POR_DEFECTO));

         // Si se han agotado todos los nombres por defecto asignamos el primer nombre
         // libre que encontremos al ir aumentando el contador:
          if(ExisteNombreNodo(nuevoNodo->nombreDado) && (cont == MAX_NUM_NOMBRES_POR_DEFECTO)){
             do{
                 nuevoNodo->nombreDado= nuevoNodo->nombre + IntToStr(cont++);
             }while(ExisteNombreNodo(nuevoNodo->nombreDado));
          }
   }else
      nuevoNodo->nombreDado="";


   // Ahora creamos el nodo del TreeView asociado al nodo que acabamos de crear.
   nuevoTreeNode = TreeView->Items->AddChild(padreTreeNode,GetNombreTreeView(nuevo));

   // Asociamos sus iconos.
   nuevoTreeNode->ImageIndex    = INDEX_ICONO_NODO;
   nuevoTreeNode->SelectedIndex = INDEX_ICONO_NODO;

   // Vinculamos los nodos.
   nuevoTreeNode->Data=(void *) nuevo;
   nuevo->nodoAsociado=nuevoTreeNode;

   // Solo falta aadir los hijos al nodo nuevo. Estos hijos son los campos del
   // nodo X3D/H3D.
   for(int i=0; i < datosNodo->numCampos ; i++){
        // En cada iteracin creamos un hijo.
        hijo = CrearNodo(CAMPO);
        // Por comodidad usamos:
        TipoCampo *nuevoCampo = hijo->AsCampo();

        nuevoCampo->nombre     = datosNodo->campos[i]->nombre;
        nuevoCampo->datosCampo = datosNodo->campos[i];
        nuevoCampo->valor      = datosNodo->campos[i]->valorPorDefecto;

        if(datosNodo->campos[i]->tipo->numHijos == 1)
           nuevoCampo->tipoCampo = SFNODE;
        else if(datosNodo->campos[i]->tipo->numHijos == 2)
           nuevoCampo->tipoCampo = MFNODE;
        else
           nuevoCampo->tipoCampo = SIMPLE;

        AnadirUltimoHijo(hijo,nuevo);
        CrearNodoAsociado(hijo);
   }

  // Aadimos el hijo creado al padre. Hay que tener en cuenta algo:
  // si el nodo padre es un campo SFNODE solo podr tener un hijo, as
  // lo aadiremos en la posicin 0.
  if( padre->EsCampo() && (padre->AsCampo()->tipoCampo == SFNODE) ){
     // En este caso sustituimos el hijo que hay por nuevo nodo.
     if(padre->GetHijo(0,NODO) != NULL)
          EliminarNodo( padre->GetHijo(0,NODO) );
     // Tambin puede ser una sentencia USE:
     if(padre->GetHijo(0,USE) != NULL)
          EliminarNodo( padre->GetHijo(0,USE) );
     padre->hijos->Set((void *) nuevo,0);
  }else{
      // Mejor usar MaxIndexUsado que PrimerIndexLibre pq si no cambiara
      // el orden de los hijos en el tree view.
      padre->hijos->Set((void *) nuevo,padre->hijos->MaxIndexUsado()+1);
  }

  // Expandimos el nodo padre recursivamente para que aparezca el nodo creado.
  padreTreeNode->Expand(false);
  nuevoTreeNode->Expand(true);

  EscenaModificada(true);

  if(UsaUI_ToolKit())
     ImportarUserInterfaceToolkit();

  return nuevo;
}
//------------------------------------------------------------------------------
NodoArbol *__fastcall TfrmEscena::AnadirNodoEnTransform(AnsiString nombreNodo,NodoArbol *nodoPadre){

   if(Raiz == NULL)
      return NULL;

   // Lo primero es Crear el nodo transform.
   NodoArbol *t = AnadirNodo("Transform",nodoPadre);
   if(t == NULL){
      Utilidad.MsgInfo("The Transform node is not registered.","Advertencia");
      return NULL;
   }

   // Ahora intentamos aadir el nodo <nodo> dentro del campo children
   // del nodo transform -> Buscamos el campo children:
   NodoArbol *hijo;
   for(int c=0; c <= t->hijos->MaxIndexUsado(); c++){
      hijo = (NodoArbol *) t->hijos->Get(c);
      if(hijo != NULL){
          bool esCampoMFNodeNoEvento = hijo->EsCampoMFNodeNoEvento();

         if( esCampoMFNodeNoEvento && (hijo->AsCampo()->nombre == "children") ) {
            // Finalmente aadimos el hijo.
            return AnadirNodo(nombreNodo,hijo);
         }
      }
   }

   Utilidad.MsgInfo("The children field of the Transform node is not registered.","Advertencia");
   return NULL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirVinculoRutado(NodoArbol *padre,NodoArbol *out,NodoArbol *in){

   if( (padre == NULL) || (out == NULL) || (in == NULL) || (!in->EsCampo())
       || (!out->EsCampo()) || (in->padre == NULL) || (out->padre == NULL) )
      return;
   if( !padre->EsRaiz() && (!padre->EsNodo()) )
      return;

   // Hay que aadir un nuevo vinculo de rutado a la escena.
   TipoRutado *vinculo;

   // Ahora hay que crear el nodo NodoArbol que contendr el vnculo de rutado.
   NodoArbol *NuevoNodo=NULL;   
   try{ NuevoNodo= new NodoArbol(RUTADO); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   vinculo=NuevoNodo->AsRutado();

   // Ya est el vnculo creado en memoria -> rellenamos sus datos.
   vinculo->nodoOut  = out->padre->AsNodo()->nombreDado;
   vinculo->campoOut = out->AsCampo()->nombre;
   if( (Raiz->AsRaiz()->tipoEscena == ESCENA_X3D) && ( out->AsCampo()->datosCampo->rutado == EXPOSEDFIELD ) )
      vinculo->campoOut= vinculo->campoOut + Main->Sufijo_ExpField;
   vinculo->nodoIn   = in->padre->AsNodo()->nombreDado;
   vinculo->campoIn  = in->AsCampo()->nombre;
   if( ( in->AsCampo()->datosCampo->rutado == EXPOSEDFIELD ) && (frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_X3D) )
      vinculo->campoIn= (AnsiString) Main->Prefijo_ExpField + vinculo->campoIn;

   // Ya est creado el nodo asignamos sus campos.
   AnadirUltimoHijo(NuevoNodo,padre);
   CrearNodoAsociado(NuevoNodo);

   EscenaModificada(true);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirVinculoRutado(NodoArbol *padre,
       AnsiString nodoOut,AnsiString campoOut,AnsiString nodoIn,AnsiString campoIn){
   if( (padre == NULL) || (nodoOut == "") || (campoOut == "") ||
                          (nodoIn  == "") || (campoIn == "") )
      return;
   if( !padre->EsRaiz() && (!padre->EsNodo()) )
      return;

   // Hay que aadir un nuevo vinculo de rutado a la escena.
   TipoRutado *vinculo;

   // Ahora hay que crear el nodo NodoArbol que contendr el vnculo de rutado.
   NodoArbol *NuevoNodo=NULL;
   try{ NuevoNodo = new NodoArbol(RUTADO); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   vinculo=NuevoNodo->AsRutado();

   // Ya est el vnculo creado en memoria -> rellenamos sus datos.
   vinculo->nodoOut  = nodoOut;
   vinculo->campoOut = campoOut;
   vinculo->nodoIn   = nodoIn;
   vinculo->campoIn  = campoIn;

   // Ya est creado el nodo asignamos sus campos.
   AnadirUltimoHijo(NuevoNodo,padre);
   CrearNodoAsociado(NuevoNodo);

   EscenaModificada(true);
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEscena::ExisteNombreNodo(AnsiString nombre){
   // Usamos la funcin que recorre el rbol.
   NodoArbol *punt;
   IniciaRecorrerArbol(NODO);
   punt=RecorrerArbol();
   while(punt != NULL){
       // Solo hay que comparar los nombres de los nodos del TreeView que sean
       // nodos X3D/H3D con el nombre que se recibe como parmetro.
       // (En los campos X3D/H3D punt->nombre estar vaca, as que
       // no hace falta distinguir ese caso.
       if( punt->AsNodo()->nombreDado == nombre)
          return true;
       punt=RecorrerArbol();
   }
   return false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::IniciaRecorrerArbol(TipoNodoArbol tipoNodoArbol,bool todos){
   // Inicializamos las variables que informarn sobre el tipo de nodo devuelto,
   // el ltimo nodo devuelto y si se quiere recorrer todos los nodos.
   RecorrerArbolLastIndex=0;
   RecorrerArbolTipoNodoArbol=tipoNodoArbol;
   RecorrerArbolRecorrerTodos=todos;
}
//---------------------------------------------------------------------------
NodoArbol * __fastcall TfrmEscena::RecorrerArbol(){
  // Hacer una funcin que recorra el rbol y que no sea recursiva es complejo.
  // La opcin ms sencilla es usar las propiedades del objeto TreeView, as es
  // case inmediato.
  if(TreeView->Items->Count == RecorrerArbolLastIndex)
     return NULL;
  else{
      if(RecorrerArbolRecorrerTodos){
          return (NodoArbol *) (TreeView->Items->Item[RecorrerArbolLastIndex++])->Data;
      }else{
          while(  RecorrerArbolLastIndex < TreeView->Items->Count){
              NodoArbol *p;
              p = (NodoArbol *) (TreeView->Items->Item[RecorrerArbolLastIndex++])->Data;
              if(p == NULL)
                 return NULL;
              else if(RecorrerArbolTipoNodoArbol == p->tipo)
                 return p;
          }
          return NULL;
      }
  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::Ejecutar(int modo){

   if( (Raiz == NULL) || !Raiz->EsRaiz() )
      return;

   // Fichero que se ejecuta.
   AnsiString fichero = Raiz->AsRaiz()->fichero.Trim();

   if(fichero == "")
      fichero = (AnsiString)FICHERO_POR_DEFECTO + (AnsiString)EXTENSION_X3D;

   if(fichero[1] == '?'){
      // En este caso an no se ha dado ningn nombre a la escena.
      // Vamos a hacer que se cree el fichero de prueba en la carpeta del programa

      fichero = ExtractFileName(fichero);
      fichero = Main->CARPETA_PROGRAMA + "\\" + fichero;
   }

   if(!EscenaHaCambiado){
      // Cuando la escena no ha cambiado no es necesario usar un fichero de prueba.
      // as que no tenemos que hacer nada.
   }else if( EscenaHaCambiado || !FileExists(fichero) ){
      // Solo escribiremos el fichero de prueba cuando la escena haya cambiado o
      // cuando no exista.
      // Para ejecutar el programa se usar un fichero que tendr el mismo nombre
      // que la escena original aadiendole CONF.SUF_FICHERO_PRUEBA

      // Obtengo el nombre sin la extensin.
      fichero.Delete(fichero.AnsiPos(EXTENSION_X3D), ((AnsiString)EXTENSION_X3D).Length() );

       // Aadimos el sufijo y la extensin:
      fichero = fichero + CONF.SUF_FICHERO_PRUEBA + EXTENSION_X3D;

      if(Carpetas->ActivePageIndex != 1)
         ActualizaCodigo();
      // Escribimos la escena a disco.
      Utilidad.SaveToFile(Codigo->Lines,fichero);
   }

   // Ya est escrito el fichero--> llamamos a Explorer o H3DLoader segn modo:
   EjecutarFichero(fichero,modo, Raiz->AsRaiz()->tipoEscena );
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::EjecutarFichero(AnsiString fichero, int modo, TipoEscena tipoEscena){

   if(!Utilidad.Existe(fichero))
      return;

   AnsiString carpeta=ExtractFileDir(fichero);
   // Ejecutamos el fichero segn el parmetro modo.
   if( (modo == 1) || ( (modo==0) && (tipoEscena == ESCENA_X3D) ) ){
       // Antes de ejecutar el fichero hay que comprobar si existe.
       if( FileExists(CONF.PATH_EXPLORER) )
       {
          AnsiString pathExplorer = (AnsiString)"\"" + CONF.PATH_EXPLORER + "\"";
          fichero = (AnsiString)"\"" + fichero + "\"";
          carpeta = (AnsiString)"\"" + carpeta + "\"";

          ShellExecute( this->Handle, "", pathExplorer.c_str(), fichero.c_str() , carpeta.c_str(), SW_SHOWMAXIMIZED);
       }
       else
          Utilidad.MsgInfo("The following file doesn't exist: " + CONF.PATH_EXPLORER + " You can use the settings window to specify the right path.","Advertencia");
   }else if( (modo == 2) || ( (modo==0) && (tipoEscena == ESCENA_H3D) ) ){
       // Antes de ejecutar el fichero hay que comprobar si existe.
       if( !FileExists(CONF.PATH_H3D_LOAD) ){
           Utilidad.MsgInfo("The following file doesn't exist: " + CONF.PATH_H3D_LOAD + " You can use the settings window to specify the right path.","Advertencia");
       }else{
          // Hay que distinguir dos casos: Si el visor H3D se quiere o no
          // ejecutar con la Consola H3D (programas de MsDos):
          if(CONF.USAR_CONSOLA_H3D_AL_EJECUTAR_H3D){
             int linea = frmConsola->Inicia(fichero,true);
             if(linea != -1){
                if(frmEditor->Editando)
                   frmEditor->SeleccionarLinea(linea,true);
                else{
                  // En este caso hay que editar la escena actual y editar la lnea linea.
                  Main->EditaEscenaActual(linea);
                }
             }
          }else{
             AnsiString pathLoader = (AnsiString)"\"" + CONF.PATH_H3D_LOAD + "\"";
             fichero = (AnsiString)"\"" + fichero + "\"";
             carpeta = (AnsiString)"\"" + carpeta + "\"";
             ShellExecute( this->Handle, "", pathLoader.c_str(), fichero.c_str(), carpeta.c_str(), SW_SHOWMAXIMIZED);
          }
       }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::ActualizaArbol(){
   if(Raiz==NULL)
      return;

   // Tenemos que recorrer todos los nombres de la escena asignando el
   // texto que aparece en cada nodo del TreeView.

   IniciaRecorrerArbol(NODO,true);
   AnsiString tmp;
   NodoArbol *punt=RecorrerArbol();
   while(punt != NULL){
      if(punt != NULL){
         tmp=GetNombreTreeView(punt);
         if( punt->nodoAsociado->Text != tmp)
              punt->nodoAsociado->Text= tmp;
      }
      punt=RecorrerArbol();
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirPrimerHijo(NodoArbol *nuevo,NodoArbol *padre){
    if( (nuevo == NULL) ||(padre == NULL) )
       return;
    // Tenemos que hacer un hueco al principio del array:
    void *tmp,*anter=nuevo;
    for(int c=0;c <= padre->hijos->MaxIndexUsado(); c++){
        tmp=padre->hijos->Get(c);
        padre->hijos->Set(anter,c);
        anter=tmp;
    }
    // Ahora aadimos el primer hijo y vinculamos los nodos.
    padre->hijos->Set((void *)anter,padre->hijos->MaxIndexUsado()+1);
    nuevo->padre=padre;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirUltimoHijo(NodoArbol *nuevo,NodoArbol *padre){
    if( (nuevo == NULL) ||(padre == NULL) )
       return;
    padre->hijos->Set((void *)nuevo,padre->hijos->MaxIndexUsado()+1);
    nuevo->padre=padre;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirHermanoAnterior(NodoArbol *nuevo,NodoArbol *hermano){
    if( (nuevo == NULL)          || (hermano == NULL) ||
        (hermano->padre == NULL) || (nuevo->padre!=NULL) )
       return;

    NodoArbol *padre=hermano->padre;
    // Tenemos que hacer un hueco a partir de la posicin que ocupe hermano.
    // As que en primer lugar buscamos la posicin de hermano.
    int c=0;
    while( (c <= padre->hijos->MaxIndexUsado()) && (hermano != padre->hijos->Get(c)) )
       c++;

    // As c es el ndice asociado a hermano. Ahora desde c hasta el final
    // hacemos un hueco en el que aadimos nuevo.
    void *tmp,*anter=nuevo;
    for(;c <= padre->hijos->MaxIndexUsado(); c++){
        tmp=padre->hijos->Get(c);
        padre->hijos->Set(anter,c);
        anter=tmp;
    }
    // Hay que escribir el ltimo elemento.
    padre->hijos->Set(anter,c);
    nuevo->padre=hermano->padre;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirHermanoSiguiente(NodoArbol *nuevo,NodoArbol *hermano){
    if( (nuevo == NULL)          || (hermano == NULL) ||
        (hermano->padre == NULL) || (nuevo->padre!=NULL) )
       return;

    NodoArbol *padre=hermano->padre;
    // Tenemos que hacer un hueco a partir de la posicin que ocupe hermano.
    // As que en primer lugar buscamos la posicin de hermano.
    int c=0;
    int encontrados=0;
    while( (c <= padre->hijos->MaxIndexUsado()) && (hermano != padre->hijos->Get(c)) ){
       if( padre->hijos->Get(c) != NULL )
         encontrados++;
          c++;
    }

    if(encontrados == padre->hijos->NumElementosNoNulos()){
       // En este caso solo hay que aadir al final porque hermano es el ltimo elemento.
       padre->hijos->Set((void *)nuevo,padre->hijos->MaxIndexUsado()+1);
       nuevo->padre=padre;
       return;
    }

    // Incrementamos c para colocarnos detrs de hermano.
    c++;

    // As c es el ndice asociado a hermano. Ahora desde c hasta el final
    // hacemos un hueco en el que aadimos nuevo.
    void *tmp,*anter=nuevo;
    for(;c <= padre->hijos->MaxIndexUsado(); c++){
        tmp=padre->hijos->Get(c);
        padre->hijos->Set(anter,c);
        anter=tmp;
    }
    // Hay que escribir el ltimo elemento.
    padre->hijos->Set(anter,c);
    nuevo->padre=hermano->padre;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::CrearNodoAsociado(NodoArbol *elemento){
    if( (elemento==NULL) || (elemento->nodoAsociado!=NULL) )
       return;

    // Ahora aadimos al control TTreeView el nuevo elemento.
    // En el caso en que elemento->padre sea NULL tendremos la raiz y en otro
    // caso aadiremos elemento como hijo de su padre:
    if(elemento->EsRaiz()){
        // En este caso tenemos que crear el nodo raiz.
        TreeView->Items->Clear();
        elemento->nodoAsociado=TreeView->Items->Add(NULL,GetNombreTreeView(elemento));
        if(elemento->nodoAsociado != NULL){
           elemento->nodoAsociado->Data=(void *)elemento;
           AsignarIcono(elemento);
        }
    }else if (elemento->padre != NULL){
        // En este caso tenemos que aadir a TreeView un nodo que no es la raiz.
        // Lo aadimos siguiendo la misma estructura que hay en el arbol Raiz:
        // Lo primero es buscar elemento entre los hijos de su padre:
        int c=0;
        NodoArbol *padre = elemento->padre;
        while( (c <= padre->hijos->MaxIndexUsado()) && (elemento != padre->hijos->Get(c)) ){
           c++;
        }
        // Ahora buscamos el hermano siguiente.
        NodoArbol *hermanoSiguiente=NULL;
        c++; // Estamos en elemento -> incrementando pasamos al siguiente.
        while( (c <= padre->hijos->MaxIndexUsado()) && (hermanoSiguiente == NULL) ){
           if(padre->hijos->Get(c) != NULL)
              hermanoSiguiente=(NodoArbol *)padre->hijos->Get(c);
           c++;
        }
        // Y ahora: si existe un hermano siguiente, aadimos elemento antes de
        // ese hermano y si no existe ningn hermano siguiente lo aadimos como
        // primer hijo.
        if(hermanoSiguiente == NULL)
            // No existe ningn hermano anterior -> lo aadimos como ultimo hijo.
            elemento->nodoAsociado=TreeView->Items->AddChild(elemento->padre->nodoAsociado,GetNombreTreeView(elemento));
        else
            // Existe un hermano siguiente -> lo aadimos detrs.
            elemento->nodoAsociado=TreeView->Items->Insert(hermanoSiguiente->nodoAsociado,GetNombreTreeView(elemento));

        if(elemento->nodoAsociado != NULL){
           elemento->nodoAsociado->Data = (void *) elemento;
           AsignarIcono(elemento);
        }
    }
    // Tabin aadimos los hijos de elemento.
    for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++)
        CrearNodoAsociado((NodoArbol *)elemento->hijos->Get(c));
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AsignarIcono(NodoArbol *elemento){
    if(elemento == NULL)
       return;
    // Asignamos el icono del nodo. Hay que distinguir varios casos.
    if ( elemento->EsRaiz() ){
        if(elemento->AsRaiz()->tipoEscena == ESCENA_X3D)
            elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_X3D;
        else
            elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_H3D;

    }else if(elemento->EsNodo() ){
        // Distinguimos el caso de nodo genrico:
        if( (NULL != elemento->dato) &&
            (elemento->AsNodo()->tipoNodoVRML == NODO_INDEFINIDO) )
           elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_NODO_GENERICO;
        else
           elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_NODO;

    }else if(elemento->EsRutado()){

        elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_RUTADO;

    }else if(elemento->EsCampo()){

       if (elemento->AsCampo()->tipoCampo == SIMPLE){
            AnsiString nombreTipo;
            nombreTipo = elemento->AsCampo()->datosCampo->tipo->nombre;

            int numTipo = GT->NumeroDeTipo(nombreTipo) ;

            if( -1 != numTipo )
               elemento->nodoAsociado->ImageIndex    = numTipo + INDEX_PRIMER_ICONO;
            else
               // En este caso tenemos un tipo desconocido asgnamos su icono:
               elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_TIPO_INDEFINIDO;

       }else
            elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_NODO;

    }else if(elemento->EsComentario())
        elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_COMENTARIO;
    else if(elemento->EsUSE())
        elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_USE;
    else if(elemento->EsProto())
        elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_PROTO;
    else if(elemento->EsExternProto())
        elemento->nodoAsociado->ImageIndex    = INDEX_ICONO_PROTO;
    else
       return;
    elemento->nodoAsociado->SelectedIndex = elemento->nodoAsociado->ImageIndex;

}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::CambiarNombreEscena(AnsiString fichero){

   if( (Raiz == NULL) || (!Raiz->EsRaiz()) ||(Raiz->dato == NULL) )
      return;
   Raiz->AsRaiz()->fichero = fichero;
   Raiz->nodoAsociado->Text=GetNombreTreeView(Raiz);
   EscenaModificada(false);
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEscena::SalvarEscena(){
   if(Raiz == NULL)
     return false;

   // Si es posible se borra el fichero de pruebas:
   if( (Raiz != NULL) && Raiz->EsRaiz() )
      BorrarFicheroPrueba(Raiz->AsRaiz()->fichero);

   if( ( ExtractFileName( Raiz->AsRaiz()->fichero.Trim()) ) == "")
       return SalvarEscenaComo();

   AnsiString ruta = Raiz->AsRaiz()->fichero;
   // Si no se ha dado an nombre a la escena le damos uno.
   if( (ruta != "") && (ruta[1] == '?') ){
      // En este caso no podemos salvar el fichero porque el usuario an no ha
      // especificado la carpeta en la que debe guardarse as que llamamos a
      // SalvarEscenaComo():
      return SalvarEscenaComo();
   }

   Main->LineasAux->Clear();
   // Lo primero es actualizar el contenido del cdigo:
   bool sinProblemas = GVRML.EscribeFichero(Raiz,Main->LineasAux,TreeView->Items->Count);

   // La asignacin puede durar unos instantes y hay que restaurar las ventanas
   // que no se han dibujado al desaparecer la barra de progreso.
   if(frmEditorNodos != NULL)
      frmEditorNodos->Repaint();
   frmEscena->Repaint();

   // Antes de asignar vamos a salvar la posicin del cursor.
   int posCur = Codigo->SelStart;
   int longSel = Codigo->SelLength;

   // Asignamos los contenidos -> Puede tardar unos instantes.
   Screen->Cursor=PUNT_RATON_ESPERA;
   Codigo->Text = Main->LineasAux->Text;

   // Tb hay que dar formato al cdigo en caso de que sea necesario.
   ReVRML.FormateaPantalla(this,Codigo);
   Screen->Cursor=PUNT_RATON_NORMAL;

   InvalidateRect(Codigo->Handle, 0, true);   // Equivale a Repaint();

   // Reponemos la posicin del cursor.
   Codigo->SelStart=posCur;
   Codigo->SelLength=longSel;

   // Actualizamos la variable:
   EscenaHaCambiado=false;
   Caption= (AnsiString) "Scene " + ExtractFileName(ruta);

   // Actualizamos, en el men principal el contenido de los 4 ltimos ficheros abiertos.
   AnsiString letraMenu = ( Raiz->AsRaiz()->tipoEscena==ESCENA_X3D ? "V" : "R");
   Main->Actualiza_LAST_FILES(letraMenu + ruta);

   // Y ahora se salva la escena a disco.
   Utilidad.SaveToFile(Codigo->Lines,ruta);

   Actualiza();

   return sinProblemas;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEscena::SalvarEscenaComo(){

   if(Raiz == NULL)
      return false;

   BorrarFicheroPrueba( Raiz->AsRaiz()->fichero );

   AnsiString ruta = Raiz->AsRaiz()->fichero;

   // Vamos a cargar un nuevo fichero VRML.
   Main->dlgSalvar->DefaultExt=EXTENSION_X3D;
   Main->dlgSalvar->FileName= ExtractFileName(ruta);
   Main->dlgSalvar->InitialDir=CONF.LAST_CARPETA_USADA;
   if(!Main->dlgSalvar->Execute())
      return false;

   CONF.LAST_CARPETA_USADA= GetCurrentDir();
   CONF.LosDatosHanCambiado();

   AnsiString fichero=Main->dlgSalvar->FileName;
   if(FileExists(fichero)){
       if(mrYes != frmUtilidad->Pregunta("The file " + ExtractFileName(fichero) + " already exists. Do you want to replace it?"))
          return false;
   }

   // Antes de cambiar el nombre de la escena vamos a intentar borrar el fichero
   // de prueba que se usa en las ejecuciones.
   if( (Raiz != NULL) && Raiz->EsRaiz() )
      BorrarFicheroPrueba(Raiz->AsRaiz()->fichero);
   CambiarNombreEscena(fichero);
   // Actualizamos, en el men principal el contenido de los 4 ltimos ficheros abiertos.
   AnsiString letraMenu = ( Raiz->AsRaiz()->tipoEscena==ESCENA_X3D ? "V" : "R");
   Main->Actualiza_LAST_FILES( letraMenu + fichero);
   SalvarEscena();
   ActualizaArbol();
   // Actualizamos frmEscena por si se est viendo el nombre de la raiz que ha cambiado.
   if(TreeView->Selected != NULL)
      frmEditorNodos->Carga((NodoArbol *)TreeView->Selected->Data);

   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::ActualizaCodigo(){
   // Vamos a usar Main->LineasAux como buffer temporal para mejorar la velocidad de carga.
   // Main->LineasAux->Clear(); La ejecucin ser ms rpida (en ciertas ocasiones) si
   // no se borra el contenido de Main->LineasAux porque EscribeFichero solo escribe
   // en Main->LineasAux cuando es necesario.
   Main->LineasAux->Clear();
   GVRML.EscribeFichero(Raiz,Main->LineasAux,TreeView->Items->Count);

   // La asignacin puede durar unos instantes y hay que restaurar las ventanas
   // que no se han dibujado al desaparecer la barra de progreso.
   Main->Repaint();  // (Con esto tb se hace el Repaint de las ventanas hijas).

   // Antes de asignar vamos a salvar la posicin del cursor.
   int posCur = Codigo->SelStart;
   int longSel = Codigo->SelLength;

   // Cargamos Codigo y formateamos el texto con:
   ReVRML.Inicia(this,Codigo,2,&(Main->LineasAux->Text));

   InvalidateRect(Codigo->Handle, 0, true);   // Equivale a Repaint();

   // Reponemos la posicin del cursor.
   Codigo->SelStart=posCur;
   Codigo->SelLength=longSel;

   // Actualizamos el contenido de Estadistica.
   ActualizaEstadistica();
   Main->ActualizaBarraEstado();
   // Actualizamos el ttulo de la escena teniendo en cuenta si la escena se ha
   // salvado o no.
   Caption= (AnsiString) "Scene " + (EscenaHaCambiado ? "* " : " ") + ExtractFileName(Raiz->AsRaiz()->fichero) ;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::Cortar(NodoArbol *elemento)
{
  if(elemento == NULL)
     return;
   // Copiamos elemento al portapapeles.
   Copiar(elemento);
   // Y borramos el elemento que hemos copiado al portapapeles.
   BorrarNodo(elemento);

   // En borrar elemento ya se habr llamado a EscenaModificada se fuese necesario.
   Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::Copiar(NodoArbol *elemento){
  // Para copiar el elemento actual hay que crear temporalmente una variable
  // TStrings y pegar en ella el contenido del elemento actualmente seleccionado

  // Comprobamos que elemento seleccionado no es un campo y si lo es intentamos
  // seleccionar el nodo padre.
  if(elemento == NULL)
     return;
  if( elemento->EsCampo() && ( (elemento->EsCampoEvento()) ||
                               (elemento->AsCampo()->tipoCampo == SIMPLE) ) )
    // En este caso intentamos seleccionar al padre.
    elemento=elemento->padre;

  // Otro caso especial es que tengamos un comentario.
  if(elemento->EsComentario()){
      // Solo tenemos que copiar su contenido al portapapeles.
      if( elemento->dato != NULL )
      {
          AnsiString comentario = (AnsiString)"<!--" + elemento->AsComentario()->texto + "-->";
          Clipboard()->SetTextBuf( comentario.c_str() );
      }
      return;
  }

  // Reservamos memoria para el tipo TStringList donde escribiremos el contenido
  // del elemento seleccionado.
  TStringList *lineas=NULL;
  try{ lineas = new TStringList(); }
  catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

  // Ahora tenemos que escribir en lineas el cdigo VRML asociado a elemento:
  // Elemento puede ser:
  //  La Raiz, USE, NODO, un campo SFNode (no evento), un campo MFNode (no evento)
  // (No puede ser un comentario pq ya los hemos considerado)
  if(elemento->EsRaiz())
     GVRML.EscribeFichero(elemento,lineas,TreeView->Items->Count);
  else if( elemento->EsCampoMFNodeNoEvento() || elemento->EsCampoSFNodeNoEvento() ){
     // En este caso tenemos que escribir en lineas todos los elementos que
     // contenga elemento como hijos. (Notar que un campo SFNode puede tener
     // mas de un hijo -> comentarios).
     int escritos = 0;
     for(int c=0; c <= elemento->hijos->MaxIndexUsado(); c++){
        NodoArbol *hijo = (NodoArbol *) elemento->hijos->Get(c);
        if(hijo != NULL){
           Main->LineasAux->Clear();
           GVRML.EscribirElementoVRML(hijo,Main->LineasAux,Raiz->AsRaiz());     //MODIFICADO
           lineas->Append(Main->LineasAux->Text);
           escritos++;
        }
     }

     if(escritos == 0){
        // En este caso no hay ningn hijo dentro de elemento. Vamos a hacer
        // una llamada recursiva para copiar padre->elemento que es lo que
        // habramos copiado si el campo seleccionado hubiese sido un campo simple.
        delete lineas;
        Copiar(elemento->padre);
        return;
     }
  }else{
     // Este caso se aplica a Nodos y a USE:
     GVRML.EscribirElementoVRML(elemento,lineas,Raiz->AsRaiz());
  }

  // Ahora copiamos el portapapeles el contenido de lineas.
  Clipboard()->SetTextBuf(lineas->Text.c_str());

  // Liberamos la memoria.
  delete lineas;
}

//---------------------------------------------------------------------------
void __fastcall TfrmEscena::BorrarNodo(NodoArbol *elemento){
   // Vamos a borrar nodo.
   if( (Raiz == NULL) || (elemento == NULL) )
      return;

   // Hay que distinguir varios casos:
   NodoArbol *padre=elemento->padre;
   NodoArbol *anter=NULL;


   // Es incmodo que cada vez que se borre un elemento se seleccione la raiz y
   // todo el arbol de la escena se desplace hacia arriba. Para evitarlo intentaremos
   // seleccionar el hermano anterior del nodo que vamos a borrar. Si el nodo
   // que vamos a borrar es el primer hermano seleccionaremos el padre.
   //  Y en otro caso seleccionaremos el nodo raiz.
   if(padre != NULL){
      // Buscamos el hermano anterior.
      int c=0;
      while( (c <= padre->hijos->MaxIndexUsado()) && (elemento != (NodoArbol *)padre->hijos->Get(c) ) ){
        anter=(NodoArbol *)padre->hijos->Get(c);
        c++;
      }
      if(anter == NULL)
          // En este caso seleccionamos el padre.
          TreeView->Selected=padre->nodoAsociado;
      else
          // Seleccionamos el nodo anterior.
          TreeView->Selected=anter->nodoAsociado;
      Actualiza();
      frmEditorNodos->Carga((NodoArbol *)TreeView->Selected->Data);
   }

   if(elemento->EsRaiz()){
      // En este caso borramos todos los nodos hijos de la raiz.
      for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++){
          if(elemento->hijos->Get(c) != NULL){
             EliminarNodo((NodoArbol *) elemento->hijos->Get(c) );
          }
      }
      elemento->hijos->CrearNuevoArray();
      TreeView->Selected=Raiz->nodoAsociado;
      ActualizaArbol();
      frmEditorNodos->Carga((NodoArbol *)TreeView->Selected->Data);

   }else if(elemento->EsNodo()){
         // Habra que borrar vnculos de rutado que contengan campos de ese nombre
         // pero esta filosofa complicar mucho el cdigo, es ms aconsejable
         // dejar que la funcin que chequea los errores avise de este problema.
         // Y as se borra el nodo.
         EliminarNodo(elemento);

   }else if(elemento->EsCampo()){
       // En este caso se borrarn todos los hijos del nodo actual si el nodo
       // es SFNode o MFNode y si es un campo simple se avisar que no se pueden
       // borrar nodos simples:
       if( elemento->AsCampo()->tipoCampo == SIMPLE ){
          Utilidad.MsgInfo("It is not possible to delete the fields of a node.");
          return;
       }else if( (elemento->AsCampo()->tipoCampo == SFNODE) ||
                 (elemento->AsCampo()->tipoCampo == MFNODE) ){

          if(elemento->hijos->NumElementosNoNulos() == 0)
              return;
          else{
             // En este caso borramos todos los nodos hijos de la raiz.
             for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++){
                if(elemento->hijos->Get(c) != NULL)
                    EliminarNodo((NodoArbol *) elemento->hijos->Get(c) );
            }
          }
       }
   }else if( elemento->EsRutado() || elemento->EsComentario() ||
             elemento->EsUSE() ){
      // Borramos el nodo sin ms
      EliminarNodo(elemento);
   }

   EscenaModificada(true);
   Actualiza();
   if(TreeView->Selected != NULL)
      frmEditorNodos->Carga(  (NodoArbol *)TreeView->Selected->Data  );
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEscena::Pegar(TStringList *texto,NodoArbol *padre){

    if(Raiz==NULL)
       return true;

    int numNodosGen;
    NodoArbol *nuevo = GVRML.CargaEscena(texto,ErroresDeLectura,"",Raiz->AsRaiz()->tipoEscena,true,numNodosGen,false);

    if( (nuevo == NULL) || (ErroresDeLectura->Count != 0) ){
        // Hay que borrar de memoria los datos que no hemos usado:
        if(nuevo != NULL)
           EliminarNodo(nuevo);
        return false;
    }

    // Hemos recibido un nodo raiz. Sus nodos hijos son el contenido del porta-
    // papeles -> Vamos a pegar los hijos en la escena actual.
    for(int c=0; c <= nuevo->hijos->MaxIndexUsado() ;c++){
        NodoArbol *hijo= (NodoArbol *)nuevo->hijos->Get(c);
        if(hijo != NULL){
             PegarElemento(padre,hijo);
             // Pongo a NULL los hijos porque ms tarde eliminaremos nuevo pero
             // los hijos de nuevo no deben eliminarse de memoria.
             // nuevo->hijos->Set(NULL,c); No hace falta hacer esto porque ya
             // se hace dentro de pegar elemento.
        }
    }
    // Solo nos falta borrar de memoria los datos que no hemos usado:
    if(nuevo != NULL)
       EliminarNodo(nuevo);

    // La funcin PegarElemento selecciona el nodo del arbol que se ha pegado.
    // As vamos a editarlo en el editor de nodos.
    frmEditorNodos->Carga((NodoArbol *)TreeView->Selected->Data);

    if(UsaUI_ToolKit())
        ImportarUserInterfaceToolkit();

    EscenaModificada(true);
    Actualiza();
    return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::Pegar(){

   if(Raiz==NULL)
      return;

    // Volveremos si en el portapapeles est vaco o hay algo que no sea texto.

    if(TreeView->Selected == NULL)
       return;
    if(!Clipboard()->HasFormat(CF_TEXT)){
       Utilidad.MsgInfo("The clipboard doesn't contain text.");
       return;
    }

    // Ahora hay que pegar el contenido del portapapeles en lineas.
    Main->LineasAux->Text = Clipboard()->AsText;

    if(!Pegar(Main->LineasAux,(NodoArbol *)TreeView->Selected->Data))
       Utilidad.MsgInfo("The text contained in the clipboard is not X3D/H3D code.","Advertencia");
}
//------------------------------------------------------------------------------
void __fastcall TfrmEscena::TreeViewDblClick(TObject *Sender){
   EditaDatos();
   if(TreeView->Selected != NULL){
      NodoArbol *n = (NodoArbol *) TreeView->Selected->Data;
      if(n->EsCampo())
         frmEditorNodos->btnEnlaceVerdeClick(NULL);
   }
}
//---------------------------------------------------------------------------
NodoArbol * __fastcall TfrmEscena::AnadirComentario(NodoArbol *elemento,AnsiString texto){

    if(elemento == NULL)
       return NULL;

    bool esCampoMFNodeNoEvento = elemento->EsCampoMFNodeNoEvento();

    // Creamos un nuevo nodo con los datos leidos.
    NodoArbol *comentario= CrearNodo(COMENTARIO);
    comentario->AsComentario()->texto=texto;
    // Si el campo seleccionado es la raiz aadimos comentario como primer hijo.
    if( elemento->EsRaiz()  || esCampoMFNodeNoEvento )
        AnadirPrimerHijo(comentario,elemento);
    else
        // Si se selecciona otro campo se aade comentario como hermano anterior.
        AnadirHermanoAnterior(comentario,elemento);
    CrearNodoAsociado(comentario);
    // Han cambiado los hijos del nodo actualmente seleccionado-> Actualizamos
    // el editor de nodos.
    EscenaModificada(true);
    Actualiza();
    return comentario;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::ExpandirNodoActual(){
   if(TreeView->Selected != NULL)
      TreeView->Selected->Expand(true);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::ComprimirNodoActual(){
   if(TreeView->Selected != NULL)
      TreeView->Selected->Collapse(true);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirUSE(NodoArbol *elemento,AnsiString nombreDado,AnsiString nombreTipoNodo){
    if(Raiz== NULL)
       return;
    if(elemento == NULL)
       elemento=Raiz;

    // Creamos un nuevo nodo con los datos leidos.
    NodoArbol *use= CrearNodo(USE);
    use->AsUSE()->nombreDado=nombreDado;
    use->AsUSE()->nombreTipoNodo = nombreTipoNodo;

    // Aadiremos use como hijo del campo seleccionado si tenemos un campo MFNode
    // o un campo SFNode sin ningn elemento.
    bool puedoAnadir=false;
    if (elemento->EsCampo()){
       if( elemento->AsCampo()->tipoCampo == MFNODE )
          puedoAnadir=true;
       else if( elemento->AsCampo()->tipoCampo == SFNODE ){
          puedoAnadir= (0 == elemento->hijos->NumElementosNoNulos());
       }
    }

    if(puedoAnadir)
        AnadirUltimoHijo(use,elemento);
    else
        // En otro caso aadimos use en la raiz.
        AnadirUltimoHijo(use,Raiz);

    CrearNodoAsociado(use);
    EscenaModificada(true);
    Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::TreeViewClick(TObject *Sender)
{
   if(TreeView->Selected != NULL)
      frmEditorNodos->Carga((NodoArbol *)TreeView->Selected->Data);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::ActualizaEstadistica(){
   // Incializamos los valores de los contadores.
   int nodos=0,campos=0,comentarios=0,rutados=0,uses=0,defs=0;

   // Vamos a recorrer toda la escena contando los elementos de cada tipo:
   IniciaRecorrerArbol(TNA_INDEFINIDO,true);
   NodoArbol *p= RecorrerArbol();
   while(p != NULL){
      switch (p->tipo){
          case NODO:
                nodos++;
                if( p->AsNodo()->nombreDado != "" )
                   defs++;
          break;
          case CAMPO:      campos++;      break;
          case USE:        uses++;        break;
          case RUTADO:     rutados++;     break;
          case COMENTARIO: comentarios++; break;
      }
      p= RecorrerArbol();
   }
   // Actualizamos el contenido de la barra de estado.
   Estadistica=  (AnsiString)" Nodes: "       + IntToStr(nodos) +
                 (AnsiString)"    Fields: "      + IntToStr(campos) +
                 (AnsiString)"    ROUTE: "     + IntToStr(rutados) +
                 (AnsiString)"    USE: "         + IntToStr(uses) +
                 (AnsiString)"    DEF: "         + IntToStr(defs) +
                 (AnsiString)"    Comments: " + IntToStr(comentarios);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::CodigoKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   Main->ActualizaBarraEstado();

   // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
   // del texto, lo evitamos con  FormateoAnulado al pulsar y al soltar Shift.
   if(Key == VK_SHIFT)
      FormateoAnulado=true;

   // Por el problema que se comenta en el evento FormCreate sobre
   // Codigo->ReadOnly tenemos que evitar aqui que se pueda modificar el
   // texto. As solo vamos a permitir la pulsaciones de los cursores y de
   // Av.Pag, Re.Pag, Inicio y Fin.
   if( (Key != VK_PRIOR) && (Key != VK_NEXT) && (Key != VK_END)   && (Key != VK_HOME) &&
       (Key != VK_LEFT)  && (Key != VK_UP)   && (Key != VK_RIGHT) && (Key != VK_DOWN) )
       Key ='\0'; // Anulamos la pulsacion.
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::EscenaModificada(bool hacerEstadistica){

   if(Raiz==NULL)
      return;

   // Actualizamos el ttulo de la escena teniendo en cuenta si la escena se ha
   // salvado o no.
   if(!EscenaHaCambiado ){
      EscenaHaCambiado=true;
      Caption= (AnsiString) "Scene " + (EscenaHaCambiado ? "* " : " ") + ExtractFileName(Raiz->AsRaiz()->fichero) ;
   }

   if(hacerEstadistica){
       ActualizaEstadistica();
       Main->ActualizaBarraEstado();
   }
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEscena::EscenaModificada(){
   return EscenaHaCambiado;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEscena::PreguntarSalvar(){
   if(!EscenaHaCambiado)
      return true;

   // Un caso frecuente es una escena vaca. Entonces debemos devolver false.
   if(TreeView->Items->Count == 1)
      return true;  // Solo existe el nodo raiz.

   if( Raiz != NULL)
      BorrarFicheroPrueba(Raiz->AsRaiz()->fichero );

   TModalResult mr = frmUtilidad->Pregunta("The current scene has been modified.           \n\n Do you want to save the changes?         ");
   if(mr == mrYes){
       return SalvarEscena();
   }else if(mr == mrCancel){
       // Devolvemos false para no continuar con el proceso.
       return false;
   }
   // Devolvemos true para que continue el proceso.
   return true;
}
//---------------------------------------------------------------------------
NodoArbol *__fastcall TfrmEscena::BuscarNodoDEF(AnsiString nombreDado){

  if(nombreDado == "")
     return NULL;

  IniciaRecorrerArbol(NODO);
  NodoArbol *nodo = RecorrerArbol();
  while( nodo != NULL ){
      if( nombreDado == nodo->AsNodo()->nombreDado )
          return nodo;
      nodo = RecorrerArbol();
  }
  return NULL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::PegarElemento(NodoArbol *seleccionado,NodoArbol *elemento,bool actualizar){

    if(  (elemento == NULL) || elemento->EsRaiz() || (elemento->padre == NULL) )
       return;

    bool esCampoMFNodeNoEvento = seleccionado->EsCampoMFNodeNoEvento();

    // Cuando no se pueda pegar elemento en seleccionado lo pegaremos en el
    // nodo padreComun. Este nodo ser el primer nodo de tipo MFNode que nos
    // encontremos al ascender por el arbol desde elemento:
    // Tras el siguiente bucle, padreComun ser la Raiz o bien un campo de tipo
    // MFNode.
    NodoArbol *padreComun = seleccionado->padre;
    while( (padreComun != NULL) && !padreComun->EsRaiz() && !padreComun->EsCampoMFNodeNoEvento() )
       padreComun = padreComun->padre;

    if(padreComun == NULL)
       padreComun = Raiz;

    // Antes de seguir desvinculamos padre e hijo. Buscamos el hijo:
    NodoArbol *padre = elemento->padre;
    int indexHijo=-1;
    for(int c=0; c <= padre->hijos->MaxIndexUsado();c++){
       if( elemento == padre->hijos->Get(c) ){
           padre->hijos->Set(NULL,c);
           indexHijo=c;
           // Salimos del bucle.
           c=padre->hijos->MaxIndexUsado();
       }
    }
    elemento->padre=NULL;

    // Distinguimos entre los tipos de elementos que podemos tener:
    if(elemento->EsComentario()){
       // En este caso podemos pegar siempre. Y pegaremos el comentario como:
       // Primer hijo del nodo seleccionado si este primer hijo es la raiz o
       // un nodo o un campo MFNode. En otro caso pegaremos el comentario como hermano anterior
       // del elemento seleccionado.
       if( seleccionado->EsRaiz() || seleccionado->EsNodo() || esCampoMFNodeNoEvento )
           // AnadirPrimerHijo(seleccionado,elemento);
           AnadirPrimerHijo(elemento,seleccionado);
       else
           AnadirHermanoAnterior(elemento,seleccionado);

       CrearNodoAsociado(elemento);

       EscenaModificada(false);
       if(actualizar)
          Actualiza();

       // Finalmente seleccionamos en el arbol elemento:
       TreeView -> Selected = elemento->nodoAsociado;

       return;

    }else if(elemento->EsRutado()){
        // Pegaremos el elemento rutado como ltimo hijo del elemento seleccionado
        // si el elemento seleccionado es es: La raiz o un nodo o un campo MFNode
        // que no sea un evento.
        if( (!seleccionado->EsNodo()) && !esCampoMFNodeNoEvento)
           seleccionado= Raiz;
        AnadirUltimoHijo(elemento,seleccionado);
        CrearNodoAsociado(elemento);
        EscenaModificada(false);
        if(actualizar)
           Actualiza();

        // Finalmente seleccionamos en el arbol elemento:
        TreeView -> Selected = elemento->nodoAsociado;

        return;
    }else if( elemento->EsNodo() || elemento->EsUSE() ){
        // Si seleccionado es un campo MFNode pegaremos elementos como un hijo ms
        // Si es un SFNode pegaremos elemento como hijo si est libre. Si no se
        // avisar con un mensaje y no se pegar. En el resto de los casos se
        // pegar elemento en la raiz como ltimo hijo.
        // Pero es mejor volver sin dar mensajes de aviso porque si se pegan muchos
        // elementos del mismo tipo saldran muchos mensajes.
        if(seleccionado->EsCampo()){

           if(seleccionado->AsCampo()->tipoCampo == SIMPLE){
              seleccionado=padreComun;
           }else{
              // Comprobamos que el campo no sea un evento:
              if( (seleccionado->AsCampo()->datosCampo->rutado == EVENTOUT) ||
                  (seleccionado->AsCampo()->datosCampo->rutado == EVENTIN) ){
                  // Mejor no dar mensajes de aviso porque si se pegan muchos
                  // elementos del mismo tipo saldran muchos mensajes.
                  seleccionado=padreComun;
              }else if(seleccionado->AsCampo()->tipoCampo == MFNODE){
                  // En este caso no hay que hacer nada pegaremos elemento como hijo de seleccionado:
              }else if(  (seleccionado->AsCampo()->tipoCampo == SFNODE) &&
                         (  (NULL != seleccionado->GetHijo(0,NODO)) ||
                            (NULL != seleccionado->GetHijo(0,USE)) )   ){
                 // En este el nodo SF ya tiene el hijo asignado -> Pegamos en padreComun.
                 seleccionado=padreComun;
              }
           }
        }else{
           // En el resto de los casos pegamos elemento como hijo de padreComun.
           seleccionado=padreComun;
        }

        // En este caso podemos aadir el nodo o use.
        DibujarArbol(elemento,seleccionado->nodoAsociado);

        // DibujarArbol crea todos los nodosAsociados pero no vincula elemento
        // con seleccionado. Lo hacemos.
        elemento->padre=seleccionado;
        seleccionado->hijos->Set((void *)elemento,seleccionado->hijos->MaxIndexUsado()+1);

        if(actualizar)
           Actualiza();

        // Finalmente seleccionamos en el arbol elemento:
        TreeView -> Selected = elemento->nodoAsociado;
        
        return;
    }

    // En el resto de los casos no haremos nada (RAIZ, CAMPO, etc.)
    // Pero habr que volver a vincular al padre y al hijo porque no se ha aadido
    // a la estructura y quedara descolgado.
    if(indexHijo != -1)
       padre->hijos->Set(elemento,indexHijo);
    elemento->padre=padre;
}
//------------------------------------------------------------------------------
void __fastcall TfrmEscena::AbrirEscena(int tipo,AnsiString fichero)
{
   // Lo primero es preguntar al usuario si quiere salvar los cambios (si los hay).
   if(!PreguntarSalvar())
     return;

   if(fichero != ""){
      if(!FileExists(fichero))
         return;
   }else{
      // Vamos a cargar un nuevo fichero.
      Main->dlgAbrir->DefaultExt=EXTENSION_X3D;
      Main->dlgAbrir->FilterIndex = 1;
      Main->dlgAbrir->FileName= (AnsiString)"*" + EXTENSION_X3D;
      Main->dlgAbrir->InitialDir=CONF.LAST_CARPETA_USADA;
      if(!Main->dlgAbrir->Execute())
         return;

      CONF.LAST_CARPETA_USADA= GetCurrentDir();
      CONF.LosDatosHanCambiado();
      fichero=Main->dlgAbrir->FileName;
      Main->Repaint();
   }
   // En cualquier caso fichero contiene el nombre del fichero a abrir.

   // Antes de cargar la escena vamos a borrar el fichero de prueba (si existe).
   if( (Raiz != NULL) && Raiz->EsRaiz() )
      BorrarFicheroPrueba(Raiz->AsRaiz()->fichero);

   if( !Utilidad.Existe(fichero) )
      return;

   // Cargamos la nueva escena.
   if(tipo==1)
      IniciaEscena(fichero,ESCENA_X3D);
   else if(tipo==2)
      IniciaEscena(fichero,ESCENA_H3D);
   else if(tipo == 0){

      // En este caso hay que intentar cargar el fichero de los dos modos
      // posibles, como escena X3D o H3D. Y decidirnos por el que no
      // contenga errores. Si en los dos casos hay errores o si no los hay
      // en ninguno de los dos casos hay que preguntar al usuario cmo quiere
      // abrir la escena.

      Utilidad.LoadFromFile(Main->LineasAux,fichero);

      ErroresDeLectura->Clear();
      int numNodosGenericos;
      NodoArbol *raizVRML = GVRML.CargaEscena(Main->LineasAux,ErroresDeLectura,fichero,ESCENA_X3D,false,numNodosGenericos,true);
      bool conErroresVRML = (ErroresDeLectura->Count > 0) || (numNodosGenericos > 0);

      ErroresDeLectura->Clear();
      Utilidad.LoadFromFile(Main->LineasAux,fichero);
            
      NodoArbol *raizH3D = GVRML.CargaEscena(Main->LineasAux,ErroresDeLectura,fichero,ESCENA_H3D,false,numNodosGenericos,true);
      bool conErroresH3D = (ErroresDeLectura->Count > 0) || (numNodosGenericos > 0);

      if(conErroresVRML && !conErroresH3D){
         EliminarNodo(raizVRML);
         IniciaEscena(fichero,ESCENA_H3D,raizH3D);
      }else if(!conErroresVRML && conErroresH3D){
         EliminarNodo(raizH3D);
         IniciaEscena(fichero,ESCENA_X3D,raizVRML);
      }else{
         // En este caso la escena contiene errores tanto si es una escena VRML
         // como si es H3D, o bien no contiene errores en ninguno de los dos
         // casos. As que hay que preguntar como se desea abrir la escena:
         AnsiString Mensaje;
         if( !conErroresVRML && !conErroresH3D){
             Mensaje= " The file: " + ExtractFileName(fichero) + " is valid as a X3D and as a H3D scene. Open the file as:";

             if(ESCENA_X3D == frmUtilidad->IniciaElegirH3D_X3D(Mensaje,"Tick")){
                 EliminarNodo(raizH3D);
                 IniciaEscena(fichero,ESCENA_X3D,raizVRML);
             }else{ // Se ha elejido una escena H3D.
                 EliminarNodo(raizVRML);
                 IniciaEscena(fichero,ESCENA_H3D,raizH3D);
             }

         }else{ // ( conErroresVRML && conErroresH3D)
             // Las dos escenas contienen errores -> Hay que deshechar el rbol
             // cargado en memoria.
             EliminarNodo(raizH3D);
             EliminarNodo(raizVRML);
             Mensaje= " The file: " + ExtractFileName(fichero) + " contains errors as a X3D and as a H3D scene. Open the file as:";
             if(ESCENA_X3D == frmUtilidad->IniciaElegirH3D_X3D(Mensaje,"Stop"))
                 IniciaEscena(fichero,ESCENA_X3D);
             else // Se ha elejido una escena H3D.
                 IniciaEscena(fichero,ESCENA_H3D);
         }
      }
   }
   if(Raiz==NULL)
      return;

   // Actualizamos, en el men principal el contenido de los 4 ltimos ficheros abiertos.
   if( (Raiz->AsRaiz()->fichero != "") && (Raiz->AsRaiz()->fichero[1] != '?') ){
      AnsiString letraMenu = ( Raiz->AsRaiz()->tipoEscena==ESCENA_X3D ? "V" : "R");
      Main->Actualiza_LAST_FILES( letraMenu + Raiz->AsRaiz()->fichero);
   }
}
//------------------------------------------------------------------------------
void __fastcall TfrmEscena::TreeViewKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if( (Key == VK_DELETE ) && (TreeView->Selected != NULL) )
       BorrarNodo((NodoArbol *)TreeView->Selected->Data);

   // Si se pulsa control mientras se expande/colapsa un nodo con la barra
   // espaciadora se har recursivamente.
   bool ControlPulsado = Shift.Contains(ssCtrl);

   if( (VK_SPACE == Key) && (TreeView->Selected != NULL) ){
      if(TreeView->Selected->Expanded)
         TreeView->Selected->Collapse(ControlPulsado);
      else
         TreeView->Selected->Expand(ControlPulsado);
   }
   if(VK_RETURN == Key)
      EditaDatos();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::TreeViewKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   // Sincronizamos frmEditorNodos y frmEscena.
   if(TreeView->Selected != NULL)
      frmEditorNodos->Carga((NodoArbol *)TreeView->Selected->Data);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::IniciaBusqueda(AnsiString texto,int modo,bool distinguir){
  BusquedaCadena=texto;
  BusquedaTipoElemento=modo;
  BusquedaDistinguir=distinguir;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::Busca(){

   if(Raiz==NULL)
      return;

   // Cuando quiero buscar la cadena "" en todos los nodos no hago nada porque
   // se ira avanzando de un nodo al siguiente.
   if( (BusquedaTipoElemento == 0) && (BusquedaCadena == "") )
      return;
   if(TreeView->Selected == NULL)
      TreeView->Selected=Raiz->nodoAsociado;

   IniciaRecorrerArbol(TNA_INDEFINIDO,true);
   // Hay que intentar avanzar la lectura lineal de la escena hasta el elemento
   // actualmente seleccionado.
   NodoArbol *p;
   do{
      p=RecorrerArbol();
   }while( (p != NULL) && ( p->nodoAsociado != TreeView->Selected) );

   if(p != NULL){
      // En este caso hemos encontrado el elemento seleccionado as que seguimos
      // buscando a partir de aqui -> no hay que hacer nada.
   }else{
      // En este caso no se ha encontrado el elemento de la ltima bsqueda,lo
      // nico que hay que hacer es comenzar una nueva bsqueda.
      IniciaRecorrerArbol(TNA_INDEFINIDO,true);
   }
   // else -> En este caso no habra que hacer nada porque ya se empieza a buscar
   // desde el principio de la escena.

   // Buscamos el elemento que encaje con los datos que buscamos.
   bool encontrado =false;
   p=RecorrerArbol();
   while( !encontrado && (p!= NULL) ){
      // Hay que distinguir entre los diferentes casos:

      // Cuando la cadena buscada es "" lo que nos interesa es encontrar elementos
      // de cierto tipo sin que importe su contenido as que considereamos que
      // hemos encontrado el nodo buscado.
      if(BusquedaCadena == ""){
         if(BusquedaTipoElemento == 0)  // Todos los nodos
             encontrado=true;
         else if( (BusquedaTipoElemento == 1) && p->EsNodo() )   // Nodos
             encontrado=true;
         else if(  (BusquedaTipoElemento == 2) && p->EsNodo()    // Nodos DEF
                && ( p->AsNodo()->nombreDado != "")  )
             encontrado=true;
         else if( (BusquedaTipoElemento == 3) && p->EsUSE() )   // Nodos USE
             encontrado=true;
         else if( (BusquedaTipoElemento == 4) && p->EsCampo() ) // Campos (nombre)
            encontrado=true;
         else if( (BusquedaTipoElemento == 5) && p->EsCampo()   // Campos (contenido)
                && ( p->AsCampo()->valor != "")  )
            encontrado=true;
         else if( (BusquedaTipoElemento == 6) && p->EsRutado() ) // Rutado
            encontrado=true;
         else if( (BusquedaTipoElemento == 7) && p->EsComentario() ) // Comentario
            encontrado=true;

      }else if(p->EsNodo()){
           //                     BusquedaTipoElemento 1     
           if( (BusquedaTipoElemento == 1) || (BusquedaTipoElemento == 0) ){
               // En este caso p es un nodo -> buscamos el nombre X3D/H3D del nodo.
               encontrado= ContieneCadenaBuscada( & (p->AsNodo()->nombre) );
           }
           //                     BusquedaTipoElemento 2     
           if( (!encontrado) && ( (BusquedaTipoElemento == 2) || (BusquedaTipoElemento == 0) ) ){
               // En este caso p es un nodo -> buscamos el nombre dado al nodo.
               encontrado= ContieneCadenaBuscada( & (p->AsNodo()->nombreDado) );
           }
      }else if(p->EsUSE()){
           //                     BusquedaTipoElemento 3 o 0      
           if( (BusquedaTipoElemento == 3) || (BusquedaTipoElemento == 0) ){
              // En este caso p es una sentencia USE -> buscamos la cadena.
              encontrado= ContieneCadenaBuscada( & (p->AsUSE()->nombreDado) );
           }
      }else if(p->EsCampo()){
           //                     BusquedaTipoElemento 4     
           if( (BusquedaTipoElemento == 4) || (BusquedaTipoElemento == 0) ){
               // En este caso p es una campo -> buscamos la cadena en el nombre del campo.
               encontrado= ContieneCadenaBuscada( &(p->AsCampo()->nombre) );
           }
           //                     BusquedaTipoElemento 5     
           if( (!encontrado) && ( (BusquedaTipoElemento == 5) || (BusquedaTipoElemento == 0) ) ){
               // En este caso p es una campo -> buscamos la cadena en el contenido.
               encontrado= ContieneCadenaBuscada( &(p->AsCampo()->valor) );
           }
      }else if(p->EsRutado()){
           //                     BusquedaTipoElemento 6 o 0      
           if( (BusquedaTipoElemento == 6) || (BusquedaTipoElemento == 0) ){
               // En este caso p es vnculo de rutado-> buscamos cadena en el
               // nombre que aparece en el TreeView.
               encontrado= ContieneCadenaBuscada( &(p->nodoAsociado->Text) );
           }
      }else if(p->EsComentario()){
           //                     BusquedaTipoElemento 7 o 0     
           if( (BusquedaTipoElemento == 7) || (BusquedaTipoElemento == 0) ){
               encontrado= ContieneCadenaBuscada( & (p->AsComentario()->texto) );
           }
      }

      // Cuando se ha encontrado el elemento deseado no avanzamos el puntero
      // porque ms tarde se usar p.
      if(!encontrado)
         p=RecorrerArbol();
   }

   if(p == NULL){
      // En este caso no se ha encontrado la cadena -> Avisamos con un mensaje.
      Utilidad.MsgInfo("The search has ended.");
   }else{
      // Hemos encontrado un nodo -> Lo seleccionamos.
      TreeView->Selected=p->nodoAsociado;
      // Tb debe cargarse en el Editor de nodos.
      frmEditorNodos->Carga(p);
   }
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEscena::ContieneCadenaBuscada(AnsiString *cad){
   if(BusquedaDistinguir)
      return ( 0 != cad->Pos(BusquedaCadena) ) ;
   else
      return ( 0 != cad->UpperCase().Pos(BusquedaCadena.UpperCase() ) ) ;
}
//------------------------------------------------------------------------------
void __fastcall TfrmEscena::Actualiza(){

   if( (Carpetas->ActivePageIndex == 1) && (EscenaHaCambiado) )
      ActualizaCodigo();
   else if (Carpetas->ActivePageIndex == 0)
      ActualizaArbol();

   // Actualizamos el contenido de Estadistica.
   ActualizaEstadistica();

   // Actualizamos el ttulo de la escena teniendo en cuenta si la escena se ha
   // salvado o no.
   Caption= (AnsiString) "Scene " + (EscenaHaCambiado ? "* " : " ") + ExtractFileName(Raiz->AsRaiz()->fichero) ;
   Main->ActualizaBarraEstado();
}
//----------------------------------------------------------------------------
void __fastcall TfrmEscena::CarpetasChange(TObject *Sender)
{
   Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::CodigoKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   Main->ActualizaBarraEstado();

   // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
   // del texto, lo evitamos con  FormateoAnulado al pulsar y al soltar Shift.
   if(Key == VK_SHIFT){
      FormateoAnulado=false;
      ReVRML.FormateaPantalla(this,Codigo);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::TreeViewStartDrag(TObject *Sender,
      TDragObject *&DragObject)
{
   // Seleccionamos el nodo arrastrado.
   if(TreeView->Selected)
      NodoArrastrado= (NodoArbol *)TreeView->Selected->Data;
   else
      NodoArrastrado= NULL;

}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::TreeViewEndDrag(TObject *Sender,
      TObject *Target, int X, int Y)
{
   // Obtenemos el nodo sobre el que se ha soltado el botn.
   TTreeNode *destino= TreeView->GetNodeAt(X,Y);

   if( (destino == NULL) || (destino->Data == NULL) || (NodoArrastrado == NULL) )
      return;
   NodoArbol *NodoDestino = (NodoArbol *)destino->Data;
   // Solo haremos algo si los nodos arrastrados son hermanos.
   // Tambin volvemos si los nodos son iguales:
   if( (NodoDestino->padre != NodoArrastrado->padre) ||
       (NodoDestino == NodoArrastrado) || (NodoArrastrado->padre == NULL) )
      return;

   // Ahora hay que borrar el nodoArrastrado de TreeView e insertarlo en otra
   // parte del arbol. Antes salvaremos los indices de los iconos:
   int index1,index2;

   index1=NodoArrastrado->nodoAsociado->ImageIndex;
   index2=NodoArrastrado->nodoAsociado->SelectedIndex;

   // Hacemos un hueco.
   TTreeNode *Nuevo = TreeView->Items->Insert(destino,GetNombreTreeView(NodoArrastrado));

   // Ahora borramos el nodo.
   TreeView->Items->Delete(NodoArrastrado->nodoAsociado);

   // Reponemos los indices de los iconos.
   Nuevo->ImageIndex    = index1;
   Nuevo->SelectedIndex = index2;

   if(Nuevo== NULL)
      Utilidad.FatalErrorFaltaMemoria();

   // Ya tenemos el nodo creado, ahora solo hay que aadir todos sus hijos si es
   // que los tiene. No hace falta vincular padre e hijo porque ese vnculo no ha
   // cambiado. Si es necesario actualizar el vnculo a nodoAsociado:
   NodoArrastrado->nodoAsociado = Nuevo;
   Nuevo->Data = (void *) NodoArrastrado;
   // Solo falta aadir todos los hijos asociando los campos nodoAsociado.
   NodoArbol *hijo;
   for(int c=0; c <= NodoArrastrado->hijos->MaxIndexUsado(); c++){
       hijo= (NodoArbol *)NodoArrastrado->hijos->Get(c);
       if(hijo != NULL)
          DibujarArbol(hijo,Nuevo);
   }

   // Finalmente hay que hacer tambin el cambio de orden en los hijos en el
   // arbol de datos Raiz: Lo hacemos:
   for(int c=0; c <= NodoArrastrado->padre->hijos->MaxIndexUsado(); c++){
       hijo= (NodoArbol *)NodoArrastrado->padre->hijos->Get(c);
       if(hijo == NodoArrastrado){
          (NodoArbol *)NodoArrastrado->padre->hijos->Set(NULL,c);
          c=NodoArrastrado->padre->hijos->MaxIndexUsado();
       }
   }
   NodoArrastrado->padre=NULL;
   // Hemos borrado el nodo, ahora falta insertarlo a continuacin de NodoDestino.
   AnadirHermanoAnterior(NodoArrastrado,NodoDestino);

   EscenaHaCambiado=true;
   Actualiza();
   TreeView->Selected=NodoArrastrado->nodoAsociado;
   if(TreeView->Selected != NULL)
      frmEditorNodos->Carga((NodoArbol *)TreeView->Selected->Data);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::TreeViewDragOver(TObject *Sender,
      TObject *Source, int X, int Y, TDragState State, bool &Accept)
{
   TTreeNode *actual= TreeView->GetNodeAt(X,Y);

   if( (actual == NULL) || (actual->Data == NULL) || (NodoArrastrado == NULL) ){
      Accept=false;
      return;
   }
   // Solo se podrn intercambiar nodos hermanos:
   Accept= ( ((NodoArbol *)actual->Data)->padre == NodoArrastrado->padre);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::FormCanResize(TObject *Sender, int &NewWidth,
      int &NewHeight, bool &Resize)
{
   Resize = true;
   NewHeight = (NewHeight >= MIN_HEIGHT) ? NewHeight : MIN_HEIGHT;
   NewWidth  = (NewWidth  >= MIN_WIDTH)  ? NewWidth  : MIN_WIDTH;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEscena::Numero(char c){
   return ( (c <= '9') && (c >= '0') );
}
//---------------------------------------------------------------------------
TPoint __fastcall TfrmEscena::GetPosCursor(TStrings *lineas, AnsiString error){

   int fila=1,col=1;
   // Hay que asignar fila y col procesando error. Un posible valor de error es:
   // "fila:7 col:33--> Error ..."
   char *cad = error.c_str();
   int c=0;
   while( (cad[c] != '\0') && !Numero(cad[c]) )
      c++;
   if(cad[c] == '\0')  // Final de cadena inesperado.
      return TPoint(1,1);
   // Estamos al principio del primer nmero -> fila, lo leemos:
   while( (cad[c] != '\0') && Numero(cad[c]) ){
      fila = fila * 10 + (int)( cad[c] - '0' ) ;
      c++;
   }
   if(cad[c] == '\0')  // Final de cadena inesperado.
      return TPoint(1,1);
   // Ya hemos leido fila -> Leemos col, antes hay que colocarse al principio del
   // siguiente nmero:
   while( (cad[c] != '\0') && !Numero(cad[c]) )
      c++;
   if(cad[c] == '\0')  // Final de cadena inesperado.
      return TPoint(0,0);
   // Estamos al principio de col, lo leemos:
   while( (cad[c] != '\0') && Numero(cad[c]) )
   {
      col = col * 10 + (int)( cad[c] - '0' ) ;
      c++;
   }
   // Ya tenemos fila y col -> Las devolvemos.
   return TPoint(col,fila);
}
//---------------------------------------------------------------------------
TPoint __fastcall TfrmEscena::GetPosCursorXML(TStrings *lineas, AnsiString error)
{
   if(lineas == NULL)
      TPoint(1,1);

   // Nos vamos a quedar con la parte de error que nos interesa:
   error = Utilidad.CortaPrimeraPalabra(error);
   if(error == "")
      return TPoint(1,1);

   AnsiString cad = lineas->Text;
   int index = cad.Pos("<Scene");
   int fin   = cad.Length();
   if(fin == 0)
      return TPoint(1,1);

   if(index == 0) // Si no se ha encontrado "<Scence>" nos colocamos en la primera posicin.
      index = 1;
   else // Si se ha encontrado scene tenemos que avanzar hasta colocarnos tras la primera > , es decir en el interior del nodo Scene:
   {
      while(index <= fin && cad[index] != '>')
         index++;
      index++; // -> para colocarnos en el siguiente caracter a '>'
   }

   // En este punto estamos en el interior de Scene -> Comenzamos a movernos hasta
   // encontrar la posicin que buscamos:
   // En este punto estamos justo despus del nodo raiz (tanto si ste existe
   // como si no) y lo que se va a leer a continuacin ser el primer hijo del
   // nodo raiz.
   char anterior;
   bool inicioNodo;
   bool finNodo;

   // El objetivo del siguiente bucle es ir recorriendo todo el rbol XML registrando
   // en todo momento en qu nivel estamos, en qu n de hijo y dentro de qu nodo estamos.
   AnsiString nombreNodo;
   AnsiString nombreDado;
   AnsiString pathActual;
   int lastCoincidencias = -1;
   int indexCandidato = 1;

   while(index <= fin)
   {
      inicioNodo = false;
      finNodo    = false;
      nombreNodo = "";
      nombreDado = "";
      anterior = ' ';
      do
      {
         // Este es el criterio que usaremos:
         //     />    Fin de nodo, fin de route y fin de use
         //     </    Fin de nodo -> Falta avanzar hasta el siguiente >
         //     <!    Inicio de comentario
         //     ->    Fin de comentario
         // else
         //      <    Inicio de nodo, de Route o de USE
         // Los comentarios los vamos a intentar leer aqui:
         if( anterior == '<' && cad[index] == '!')
         {
            // Avanzamos hasta el final del comentario.
            while(index <= fin && anterior != '-' && cad[index] != '>')
            {
               anterior = cad[index++];
            }
         }
         else if( anterior == '/' && cad[index] == '>')  finNodo = true;
         else if( anterior == '<' && cad[index] == '/'){ finNodo = true; while(index <= fin && cad[index] != '>'){ index++; } index++; }
         else if( anterior == '<' ){ index--; inicioNodo = true; } // Se decrementa index para quedarnos al principio del nodo t se usa anterior en la condicion para evitar que </ se tome como inicio de un nuevo nodo..

         // Avanzamos un caracter y guardamos el anterior.
         anterior = cad[index++];
      }
      while(index <= fin && !inicioNodo && !finNodo);

      // Si estamos ante un nuevo nodo -> Intentaremos obtener el nombre del nodo:
      if(inicioNodo)
      {
         int posInioNodo = index-1;

         // Vamos a obtener el nombre del nodo:
         while(index <= fin &&  Utilidad.Separador(cad[index]) )index++;
         while(index <= fin && !Utilidad.Separador(cad[index]) ){ nombreNodo += cad[index++]; }

         // Ahora vamos a intentar obtener si es posible el nombre que se le ha asignado al nodo -> El nombre dado por el usuario:
         // Avanzaremos hasta llegar al final o hasta encontrar DEF o hasta que encontremos >
         int savedIndex = index;
         bool acabarBusqueda = false;
         while(index <= fin && !acabarBusqueda)
         {
            while(index <= fin  &&  cad[index]!='D'  &&  cad[index] != '>' ) index++;

            if(index > fin || cad[index] == '>')
            {
               acabarBusqueda = true;
            }
            else if(cad[index]=='D')
            {
               // Vemos si hemos encontrado DEF:
               if(index+2 <= fin && cad[index+1] == 'E' && cad[index+2] == 'F')
               {
                  // Se ha encontrado DEF -> vamos a leer el nombre dado:
                  acabarBusqueda = true;
                  while(index <= fin && cad[index] != '\'' && cad[index] != '\"' )index++;

                  // Para absorver la comilla (simple o doble):
                  index++;
                  // Estamos al principio del nombre -> Lo leemos:
                  while(index <= fin && cad[index] != '\'' && cad[index] != '\"' )
                  {
                     nombreDado = nombreDado + (AnsiString)cad[index++];
                  }
               }
               else // No se ha encontrado DEF -> incrementamos index para pasar a la siguiente letra y no quedarnos estancados:
                  index++;
            }
         }

         // Tras las bsquedas reponemos el ndice original:
         index = savedIndex;

         if(nombreDado != "")
            pathActual = pathActual + "\\" + nombreNodo + ":" + nombreDado;
         else
            pathActual = pathActual + "\\" + nombreNodo;

         // Al empezar la lectura del nodo comprobamos si hemos llegado a nodo que queramos.
         if(error == pathActual)
         {
            indexCandidato    = posInioNodo;
            index = fin;
            break;
         }
         else
         {
            //  Si no conseguimos encontrar la ubicacin indicada por error -> Nos intetaremos
            // quedar lo ms cerca posible:
            int coincidencias = Utilidad.GetNumCaracteresComunes(error,pathActual);
            if(coincidencias > lastCoincidencias)
            {
               indexCandidato    = posInioNodo;
               lastCoincidencias = coincidencias;
            }
         }
      }
      else  // Tenemos que quitar el ltimo elemento de pathActual:
      {
         for(int c=pathActual.Length() ; c >= 1; c--)
         {
            if(pathActual[c] == '\\')
            {
               pathActual[c] = ' ';
               break;
            }
            pathActual[c] = ' ';
         }
         pathActual = pathActual.Trim();
      }
   }

   // Ahora tenemos que ver que fila y qu columna del fichero tiene asociado indexCandidato:
   int fil = 1;
   int col = 1;
   for(int c=1; c <= fin;c++)
   {
      // Las reglas para contabilizar las filas y las columnas son las siguientes.
      //  13 + 10 -> Un salto de lnea
      //  13      -> Un salto de lnea
      //  10      -> Un salto de lnea
      //  10 + 13 -> Dos saltos de lnea
      //  Es decir si el caracter actual es 13 hacemos una salto de lneas y si es
      // 10 solo haremos el salto de lnea cuando el caracter anterior no sea el 13.
      if     (cad[c] == '\r'){  fil++; col = 1; }
      else if(cad[c] == '\n' && (c > 1) && cad[c-1] != '\r'){  fil++; col = 1; }

      if(c == indexCandidato)
      {
         if(col > 1) col--;
            return TPoint(col,fil);
      }         
      col++;
   }

   return TPoint(1,1);
}
//------------------------------------------------------------------------------
bool __fastcall TfrmEscena::UsaUI_ToolKit(){

   IniciaRecorrerArbol(NODO);
   NodoArbol *p=RecorrerArbol();
   AnsiString tipo;
   while(p != NULL){
      tipo=p->AsNodo()->datosNodo->tipo;
      if(tipo == "UI Toolkit")
         return true;
      p=RecorrerArbol();
   }
   return false;
}
//------------------------------------------------------------------------------
void __fastcall TfrmEscena::ImportarUserInterfaceToolkit(){
   // Solo hacemos algo si la escena es H3D:
   if( (Raiz == NULL) || ( Raiz->AsRaiz()->tipoEscena != ESCENA_H3D) )
      return;

   // Lo primero es comprobar que no exista ya un import en la escena actual:
   bool encontrado=false;
   IniciaRecorrerArbol(NODO);
   NodoArbol *p=RecorrerArbol();
   while( (p != NULL) && (!encontrado) ){
      if (p->AsNodo()->nombre == "Import" ){
         // Ahora hay que comprobar si el campo url contiene la direccin
         // asociada a las User Interface Toolkit.
         int c=0;
         NodoArbol *campo = p->GetHijo(c++,CAMPO);
         while( (campo != NULL) && (!encontrado) ){
            if(  (campo->AsCampo()->nombre == "url") &&
                 (campo->AsCampo()->valor == CONF.URL_USER_INTERFACE_TOOLKIT) ){
                 encontrado=true;
            }
            campo = p->GetHijo(c++,CAMPO);
         }
      }
      p=RecorrerArbol();
   }

   if(encontrado)
      return;

   NodoArbol *nuevo,*hijo;
   TTreeNode *nuevoTreeNode,*hijoTreeNode;

   // Lo primero es obtener los datos del gestor de nodos.
   Nodo *datosNodo;
   datosNodo = GN->DatosNodo("Import");
   if(datosNodo == NULL){
      Utilidad.MsgInfo("Error: The Import node is not registered.","Advertencia");
      return;
   }

   // Ya tenemos los datos del nodo. Ahora creamos un nuevo nodo del arbol y
   // asignamos sus campos.
   nuevo = CrearNodo(NODO);

   nuevo->padre=Raiz;
   //  nuevo->nodoAsociado  Se asignar luego (al crear el TTreeNode).
   // hijos no se asigna pq el constructor de hijos ya lo inicializa.

   // Por comodidad usamos un puntero a los datos del nuevo nodo.
   TipoNodo *nuevoNodo = nuevo->AsNodo();
   nuevoNodo->nombre=datosNodo->nombre;
   nuevoNodo->datosNodo=datosNodo;
   nuevoNodo->nombreDado="";

   // Ahora creamos el nodo del TreeView asociado al nodo que acabamos de crear.
   nuevoTreeNode = TreeView->Items->AddChildFirst(Raiz->nodoAsociado,GetNombreTreeView(nuevo));

   // Asociamos sus iconos.
   nuevoTreeNode->ImageIndex    = INDEX_ICONO_NODO;
   nuevoTreeNode->SelectedIndex = INDEX_ICONO_NODO;

   // Vinculamos los nodos.
   nuevoTreeNode->Data=(void *) nuevo;
   nuevo->nodoAsociado=nuevoTreeNode;

   // Solo falta aadir los hijos al nodo nuevo. Estos hijos son los campos del
   // nodo X3D/H3D.
   for(int i=0; i < datosNodo->numCampos ; i++){
        // En cada iteracin creamos un hijo.
        hijo = CrearNodo(CAMPO);
        // Por comodidad usamos:
        TipoCampo *nuevoCampo = hijo->AsCampo();

        nuevoCampo->nombre     = datosNodo->campos[i]->nombre;
        nuevoCampo->datosCampo = datosNodo->campos[i];
        if(nuevoCampo->nombre == "url")
           nuevoCampo->valor   = CONF.URL_USER_INTERFACE_TOOLKIT;
        else
           nuevoCampo->valor   = datosNodo->campos[i]->valorPorDefecto;

        if(datosNodo->campos[i]->tipo->numHijos == 1)
           nuevoCampo->tipoCampo = SFNODE;
        else if(datosNodo->campos[i]->tipo->numHijos == 2)
           nuevoCampo->tipoCampo = MFNODE;
        else
           nuevoCampo->tipoCampo = SIMPLE;

        AnadirUltimoHijo(hijo,nuevo);
        CrearNodoAsociado(hijo);
   }

   AnadirPrimerHijo(nuevo,Raiz);

   AnadirComentario(Raiz,"#User Interface ToolKit");

   EscenaModificada(true);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::TreeViewKeyPress(TObject *Sender, char &Key)
{
   if( (VK_SPACE == Key) || (VK_RETURN == Key) || ((int)Key == 10) )
      Key=0;  // As evitamos el sonido de windows.
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::GetFoco(){

   TWinControl *control=NULL;
   // Vamos a determinar que control debe obtener el foco en funcin del
   // tab seleccionado.
   // Notar que no es necesario hacer comprobaciones sobre si el control
   // est oculto o activo porque antes de pasar el foco usamos la funcion CanFocus.
   if(Carpetas->ActivePageIndex == 0)
      control=TreeView;
   else if(Carpetas->ActivePageIndex == 1)
      control=Codigo;
   // Ahora intentamos pasar el foco a control.
   if( (control != NULL) && control->CanFocus() ){
      Main->LiberarFoco();
      frmEscena->SetFocus();
      frmEscena->FocusControl(control);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::EditaDatos(){

   if(TreeView->Selected == NULL)
      return;

   NodoArbol *elemento= (NodoArbol *)TreeView->Selected->Data;

   if(elemento->EsUSE()){
      if(frmUtilidad->IniciaUSE( elemento->AsUSE()->nombreDado,elemento->AsUSE()->nombreTipoNodo ))
          EscenaModificada(true);
      // Actualizamos el nombre del TreeView.
      elemento->nodoAsociado->Text=GetNombreTreeView(elemento);
   }else if( elemento->EsComentario() && (elemento->dato != NULL) ){
      if(frmUtilidad->IniciaComentario( elemento->AsComentario()->texto) ){
          EscenaModificada(false);
          Main->ActualizaBarraEstado();
      }
      // Actualizamos el nombre del TreeView.
      elemento->nodoAsociado->Text=GetNombreTreeView(elemento);
   }else if(elemento->EsRutado()) {
      TipoRutado *v = elemento->AsRutado();
      if( frmUtilidad->IniciaRutado(v->nodoOut, v->campoOut, v->nodoIn, v->campoIn) ){
         // Si se devuelve true se ha salido pulsando aceptar y es posible que
         // haya cambiado el contedido -> No es seguro pero poniendonos en el caso peor
         // marcamos la escena como modificada.
         EscenaModificada(false);
         Actualiza();
      }
   }else if( (elemento->EsCampo()) || elemento->EsNodo() || elemento->EsRaiz() ){
      frmEditorNodos->GetFoco();
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::FormActivate(TObject *Sender)
{
   if( (Carpetas->ActivePageIndex == 0) && TreeView->CanFocus() )
     frmEscena->FocusControl(TreeView);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::BorrarFicheroPrueba(AnsiString fichero){
   // Para ejecutar el programa se usa un fichero que tendr el mismo nombre
   // que la escena original aadiendole CONF.SUF_FICHERO_PRUEBA
   fichero=fichero.Trim();

   if(fichero == "")
      return;

   if(fichero[1] == '?'){
      // En este caso an no se ha dado ningn nombre a la escena. El nombre que
      // se habr usado para ejecutar ser:
      fichero = ExtractFileName(fichero);
      fichero = Main->CARPETA_PROGRAMA + "\\" + fichero;
   }

   // Obtengo el nombre sin la extensin.
   fichero.Delete(fichero.AnsiPos(EXTENSION_X3D), ((AnsiString)EXTENSION_X3D).Length() );

    // Aadimos el sufijo y la extensin:
   fichero = fichero + CONF.SUF_FICHERO_PRUEBA;

   // Ya tenemos en fichero el nombre del fichero de prueba -> Lo intentamos borrar.
   if(FileExists(fichero + EXTENSION_X3D))
       try{DeleteFile(fichero + EXTENSION_X3D); }
       catch(...){/*No es necesario dar un mensaje de error*/}

   // Ya tenemos en fichero el nombre del fichero de prueba -> Lo intentamos borrar.
   if(FileExists(fichero + EXTENSION_wrlb))
       try{DeleteFile(fichero + EXTENSION_wrlb); }
       catch(...){/*No es necesario dar un mensaje de error*/}

}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::CodigoKeyPress(TObject *Sender, char &Key)
{
   Utilidad.MsgInfo("Use F10 to edit the code.");
   Key='\0';
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::CodigoMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   Main->ActualizaBarraEstado();
   // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
   // del texto, lo evitamos con  FormateoAnulado en OnMouseDown y OnMouseUp:
   FormateoAnulado=true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::CapturaMensaje(Messages::TMessage &Message){

   // Para evitar formatear el cdigo ms veces de las necesarias se usa
   // esta variable que indica si se est formateando el cdigo VRML.
   static bool FormateandoCodigo=false;

   //   if( (Message.Msg == WM_VSCROLL) || (Message.Msg == WM_MOUSEWHEEL) )
   //      FormateaPantalla(this,Texto);
   // Hay otra opcin mejor que usar WM_VSCROLL y WM_MOUSEWHEEL pq nos resuelve
   // tb el problema de las teclas, incluso el de pegar texto y es capturar este
   // otro mensaje que se envia cada vez que hay que dibujar el control.
   bool representar = (Message.Msg == WM_PAINT) && !FormateandoCodigo && !FormateoAnulado;

   if( representar ){
      FormateandoCodigo=true;
      ReVRML.FormateaPantalla(this,Codigo);
      FormateandoCodigo=false;
   }
   FuncionOriginal(Message);
}
//---------------------------------------------------------------------------
NodoArbol * __fastcall TfrmEscena::AnadirNodoAsignandoUnCampo(AnsiString nombreNodo,
                                             AnsiString nombreCampo,AnsiString valor){

   NodoArbol *nodo = AnadirNodo(nombreNodo);
   NodoArbol *hijo;
   if(nodo != NULL){
      // Intentamos asignar su campo url:
      NodoArbol *hijo;
      for(int c=0; c < nodo->hijos->NumElementosNoNulos(); c++){
         hijo = nodo->GetHijo(c);

         if( (hijo != NULL) && hijo->EsCampo() ){

            TipoCampo *campo = hijo->AsCampo();
            // Ahora comprobamos que el nombre sea el correcto.
            if( campo->nombre == nombreCampo ){
               // Hemos encontrado el campo, solo falta comprobar dos cosas:
               // 1) que es un campo simple.
               // 2) que no es un evento.
               if (campo->tipoCampo == SIMPLE){
                  // Solo falta comprobar que no es un evento antes de asignar el valor:
                  if( (campo->datosCampo->rutado != EVENTOUT) &&
                      (campo->datosCampo->rutado != EVENTIN) ){

                      campo->valor = valor;
                      return nodo;
                  }else{
                     Utilidad.MsgInfo("The value " + valor + " can't be assigned to the field "+nombreCampo+" of the node " + nombreNodo +" because it is an event.");
                     return NULL;
                  }
               }else{
                  Utilidad.MsgInfo("The value " + valor + " can't be assigned to the field "+nombreCampo+" of the node " + nombreNodo +".");
                  return NULL;
               }
            }
         }
      }
      Utilidad.MsgInfo("The field "+nombreCampo+" of the node " + nombreNodo +" is not registered. You can use the settings window to register types and nodes.","Advertencia");
   }else{
      // No es necesario avisar con un mensaje porque ya lo hace la funcin AnadirNodo.
      // Utilidad.MsgInfo("No se ha encontrado el nodo <" + nombreNodo +">. Puede usar el men de configuracin para definir nodos y tipos.","Advertencia");
   }
   return NULL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirTextura(AnsiString file){

   if(Raiz==NULL)
      return;

   // Vamos a distinguir el caso en el que el elemento seleccionado en el arbol
   // sea un campo que no sea evento y adems tenga como nombre "url". En este
   // caso le asignaremos file directamente, teniendo en cuenta que en H3D
   // hay que duplicar las barras de la ruta de acceso.
   NodoArbol *elemento = NULL;

   if( (Raiz != NULL) && (Raiz->AsRaiz()->tipoEscena == ESCENA_H3D ) )
      Utilidad.DuplicaBarras(file);

   if(TreeView->Selected != NULL)
      elemento = (NodoArbol *) TreeView->Selected->Data;

   if( (elemento != NULL) && elemento->EsCampo() && !elemento->EsCampoEvento() &&
                             (elemento->AsCampo()->nombre == "url") ){
      elemento->AsCampo()->valor = "\"" + file + "\"";
   }else{
      // No es necesario distinguir los casos X3D y H3D porque el nodo
      // ImageTexture existe en ambos casos y tiene los mismos campos.
      AnadirNodoAsignandoUnCampo("ImageTexture","url","\"" + file + "\"");
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirObjetoVRML(AnsiString file){

   if(Raiz==NULL)
      return;

   // Vamos a distinguir el caso en el que el elemento seleccionado en el arbol
   // sea un campo que no sea evento y adems tenga como nombre "url". En este
   // caso le asignaremos file directamente, teniendo en cuenta que en H3D
   // hay que duplicar las barras de la ruta de acceso.
   NodoArbol *elemento = NULL;

   if( (Raiz != NULL) && (Raiz->AsRaiz()->tipoEscena == ESCENA_H3D ) )
      Utilidad.DuplicaBarras(file);

   if(TreeView->Selected != NULL)
      elemento = (NodoArbol *) TreeView->Selected->Data;

   if( (elemento != NULL) && elemento->EsCampo() && !elemento->EsCampoEvento() &&
                             (elemento->AsCampo()->nombre == "url") ){
      elemento->AsCampo()->valor = "\"" + file + "\"";
   }else{
      // Vamos a aadir un nodo Inline. No es necesario distinguir el tipo de
      // escena porque el nodo Inline existe en X3D y en H3D, y en ambos
      // casos uno de los campos es url. Los tipos no son iguales pero si
      // compatibles ya que en ambos casos podemos pasar una cadena de caracteres.
      AnadirNodoAsignandoUnCampo("Inline","url","\"" + file + "\"");
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::AnadirSonido(AnsiString file){

   if(Raiz==NULL)
      return;

   // Vamos a distinguir el caso en el que el elemento seleccionado en el arbol
   // sea un campo que no sea evento y adems tenga como nombre "url". En este
   // caso le asignaremos file directamente, teniendo en cuenta que en H3D
   // hay que duplicar las barras de la ruta de acceso.
   NodoArbol *elemento = NULL;

   if( (Raiz != NULL) && (Raiz->AsRaiz()->tipoEscena == ESCENA_H3D ) )
      Utilidad.DuplicaBarras(file);

   if(TreeView->Selected != NULL)
      elemento = (NodoArbol *) TreeView->Selected->Data;

   if( (elemento != NULL) && elemento->EsCampo() && !elemento->EsCampoEvento() &&
                             (elemento->AsCampo()->nombre == "url") ){
      elemento->AsCampo()->valor = "\"" + file + "\"";
   }else{
      // En este caso si que tenemos que distinguir el tipo de escena:
      if(Raiz->AsRaiz()->tipoEscena  == ESCENA_X3D)
         AnadirNodoAsignandoUnCampo("AudioClip","url","\"" + file + "\"");
      else if(Raiz->AsRaiz()->tipoEscena  == ESCENA_H3D)
         AnadirNodoAsignandoUnCampo("SoundBuffer","url","\"" + file + "\"");
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::IniciaAsignarTransform(){
   if(Raiz == NULL)
      return;

   // En primer lugar hay que comprobar que la escena sea H3D.
//   if( Raiz->AsRaiz()->tipoEscena != ESCENA_H3D )
   {
      Utilidad.MsgInfo("The visual utilities are not available in this version.","Advertencia");
      return;
   }
/*
   // Adems debemos tener un nodo seleccionado y que sea un nodo Transform:
   if( (TreeView->Selected == NULL) || (TreeView->Selected->Data == NULL) ){
      Utilidad.MsgInfo("You must select a Transform node.");
      return;
   }
   NodoArbol *transform = ((NodoArbol *)TreeView->Selected->Data);
   if( (!transform->EsNodo()) || (transform->dato == NULL) ||
       (transform->AsNodo()->nombre.Trim() != "Transform")  )
   {
      Utilidad.MsgInfo("You must select a Transform node.");
      return;
   }

   // Ahora tenemos que asegurarnos de que no se le ha dado el mismo nombre a
   // otro nodo. Recorremos la escena buscando nodos llamados transform->AsNodo()->nombreDado
   if(transform->AsNodo()->nombreDado != ""){
      AnsiString nombreDado = transform->AsNodo()->nombreDado;
      int numNombres = 0;
      NodoArbol *punt;
      IniciaRecorrerArbol(NODO);
      punt=RecorrerArbol();
      while(punt != NULL){
          // Solo hay que comprobar el nombre de los nodos.
          if(  (punt != NULL) && (punt->AsNodo()->nombreDado == nombreDado) )
             numNombres++;
          punt=RecorrerArbol();
      }
      if(numNombres > 1){
         Utilidad.MsgInfo("The identifier  " + nombreDado + " is duplicated.","Advertencia");
         return;
      }
   }

   // Ya tenemos el nodo transform que usaremos:
   TipoNodo *transf = transform->AsNodo();

   // Vamos a asignar temporalmente un nombre al nodo transform:
   AnsiString transfNombreDadoOriginal = transf->nombreDado.Trim();
   AnsiString transfNombreDado;

   if( transfNombreDadoOriginal.Trim() != ""){
      transfNombreDado = transfNombreDadoOriginal;
   }else{
      transfNombreDado = "MotorObjetos";
      int cont=1;
      while(ExisteNombreNodo(transfNombreDado))
         transfNombreDado = "MotorObjetos" + Formatea(cont++,4);
   }

   // Adems necesitaremos en el script que la escena tenga un nodo Display:
   //  Lo buscamos-> Usamos la funcin que recorre el rbol.
   NodoArbol *nodoDisplay = NULL;
   TipoNodo *display=NULL;
   {
      NodoArbol *punt;
      int numDisplays=0;
      IniciaRecorrerArbol(NODO);
      punt=RecorrerArbol();
      while(punt != NULL){
          // Solo hay que comprobar el nombre de los nodos y que no haya ms de
          // un nodo Display.
          if(  ((TipoNodo *)punt->dato != NULL) &&
              (punt->AsNodo()->nombre == "Display") ){
             display=punt->AsNodo();
             nodoDisplay = punt;
             numDisplays++;
          }
          punt=RecorrerArbol();
      }
      if(numDisplays > 1){
         Utilidad.MsgInfo("There are several Display nodes in the Scene. The scene must have only one.","Advertencia");
         return;
      }
      if(display==NULL){
         Utilidad.MsgInfo("The scene must have a Display node.","Advertencia");
         return;
      }
   }

   // Ahora tenemos que asegurarnos de que no se le ha dado el mismo nombre a
   // otro nodo. Recorremos la escena buscando nodos llamados nodoDisplay->AsNodo()->nombreDado
   if(nodoDisplay->AsNodo()->nombreDado != ""){
      AnsiString nombreDado = nodoDisplay->AsNodo()->nombreDado;
      int numNombres = 0;
      NodoArbol *punt;
      IniciaRecorrerArbol(NODO);
      punt=RecorrerArbol();
      while(punt != NULL){
          // Solo hay que comprobar el nombre de los nodos.
          if(  (punt != NULL) && (punt->AsNodo()->nombreDado == nombreDado) )
             numNombres++;
          punt=RecorrerArbol();
      }
      if(numNombres > 1){
         Utilidad.MsgInfo("The identifier  " + nombreDado + " is duplicated.","Advertencia");
         return;
      }
   }

   // La escena tiene un nodo Display: Tambin hay que asignarle un nombre:
   AnsiString displayNombreDadoOriginal = display->nombreDado.Trim();
   AnsiString displayNombreDado;
   if( displayNombreDadoOriginal.Trim() != ""){
      displayNombreDado = displayNombreDadoOriginal;
   }else{
      displayNombreDado = "NodoDisplay";
      int cont=1;
      while(ExisteNombreNodo(displayNombreDado))
         displayNombreDado = "NodoDisplay" + Formatea(cont++,4);
   }

   // Una vez realizadas todas las comprobaciones vamos a ejecutar la escena.
   // tenemos que cambiar los nombres de los nodos Transform y Display.
   transf ->nombreDado = transfNombreDado;
   display->nombreDado = displayNombreDado;

   // Vamos a buscar nodos Appearance que tengan asignado su campo surface.
   // Si los encontramos avisaremos con un mensaje de error.
   Main->LineasAux->Clear();
   GVRML.EscribirElementoVRML(transform,Main->LineasAux,Raiz->AsRaiz());


   // Ahora tenemos que buscar en LineasAux si aparece la palabra "surface":
   for(int c=0;c < Main->LineasAux->Count; c++){
      if(0 != Main->LineasAux->Strings[c].Pos("surface")){
         // surface podra aparecer en un comentario y entonces no habra que,
         // dar el mensaje pero como es un caso poco frecuente y slo vamos a
         // dar un mensaje informativo no nos preocupa ese caso as:
         Utilidad.MsgInfo("It is not recommended to use surface in the objects that you are going to move, scale or turn because this objects can interfere with the haptic.","Advertencia");
         break;
      }
   }

   // El siguiente paso es crear en LineasAux el fichero que vamos a ejecutar.
   // Tendremos que aadir cdigo dentro del campo children del nodo Display y
   // tb al final del fichero. La forma ms cmoda de hacerlo es crear un comentario
   // dentro de Display.children para saber donde tenemos que incluir el texto:

   // Lo primero es buscar el campo children de display:
   NodoArbol *displayChildren = NULL;
   for(int c=0; c <= nodoDisplay->hijos->MaxIndexUsado(); c++){
       if(NULL != nodoDisplay->hijos->Get(c)){
           NodoArbol *hijo = (NodoArbol *)nodoDisplay->hijos->Get(c);
           if( hijo->EsCampo() && (hijo->AsCampo()->nombre == "children") ){
             displayChildren = hijo;
             break;
           }
       }
   }

   if(NULL == displayChildren){
      transf ->nombreDado = transfNombreDadoOriginal;
      display->nombreDado = displayNombreDadoOriginal;
      Utilidad.MsgInfo("The children field of the Display node is not registered.","Advertencia");
      return;
   }

   // Aadimos la marca en display Children:
   NodoArbol *marca; // =NULL; comentado para evitar el warning "is assigned a value thar is never used
   {

       bool esCampoMFNodeNoEvento = displayChildren->EsCampoMFNodeNoEvento(); 

       // Creamos un nuevo nodo con los datos leidos.
       NodoArbol *comentario= CrearNodo(COMENTARIO);
       comentario->AsComentario()->texto=MARCA_PARA_COLOCAR_OBJTS;
       if( esCampoMFNodeNoEvento )
           AnadirUltimoHijo(comentario,displayChildren);

       CrearNodoAsociado(comentario);
       marca = comentario;
   }
   if(marca == NULL){
      transf ->nombreDado = transfNombreDadoOriginal;
      display->nombreDado = displayNombreDadoOriginal;
      Utilidad.MsgInfo("An error has occurred while building the scene.","Advertencia");
      return;
   }
   
   // Salvamos la escena a LineasAux.
   Main->LineasAux->Clear();
   GVRML.EscribeFichero(Raiz,Main->LineasAux,TreeView->Items->Count);

   // Reponemos los nombres originales de los nodos transform y display.
   transf ->nombreDado = transfNombreDadoOriginal;
   display->nombreDado = displayNombreDadoOriginal;

   // Borramos el comentario anterior:
   EliminarNodo(marca);

   // ------------------ INICIO DE LA FORMACIN DEL FICHERO A EJECUTAR ---------
   // Necesitaremos importar las libreras para usar las User Interface ToolKit
   // as que si la escena actual no la incluye, las incluiremos nosotros:
   if(!UsaUI_ToolKit())
      Main->LineasAux->Insert(0,"Import { url " + CONF.URL_USER_INTERFACE_TOOLKIT + " } ");

   // El siguiente paso es avanzar indexEscena hasta la marca que hemos incluido antes:
   int indexEscena=0;
   while( (indexEscena < Main->LineasAux->Count) &&
          (0 == Main->LineasAux->Strings[indexEscena].Pos(MARCA_PARA_COLOCAR_OBJTS)) ){
      indexEscena++;
   }

   // Comprobamos que no hemos llegado al final de las lineas de la escena.
   if(indexEscena == Main->LineasAux->Count){
      Utilidad.MsgInfo("An error has occurred while building the scene.","Advertencia");
      return;
   }

   // Borramos el comentario (la marca).
   Main->LineasAux->Delete(indexEscena);

   // Ahora tenemos que aadir en la posicin actual el contenido del
   // fichero FICH_ASIGNA_TRANSFORM_1. Vamos a necesitar otro tipo
   // TStringList, vamos a usar ErroresDeLectura para no reservar memoria
   // para un tipo nuevo y le vamos a llamar lineas:
   TStringList *lineas = ErroresDeLectura;

   // Vamos a cargar el fichero en lineas.
   AnsiString carpeta = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\";
   AnsiString file = carpeta + FICH_ASIGNA_TRANSFORM_1;

   lineas->Clear();
   if(! Utilidad.LoadFromFile(lineas,file,false))
      return;

   // Ahora tenemos que insertarlo en la posicin actual de LineasAux:
   for(int c = lineas->Count-1; c >= 0 ; c--)
      Main->LineasAux->Insert(indexEscena,lineas->Strings[c]);

   // El siguiente paso es aadir el fichero FICH_ASIGNA_TRANSFORM_2 al
   // final de lneasAux:
   file = carpeta + FICH_ASIGNA_TRANSFORM_2;

   lineas->Clear();
   if(! Utilidad.LoadFromFile(lineas,file,false))
      return;

   // Ahora tenemos que insertarlo al final de LineasAux:
   for(int c = 0;c < lineas->Count;c++)
      Main->LineasAux->Append(lineas->Strings[c]);

   // ------------------- FINAL DE LA FORMACIN DEL FICHERO A EJECUTAR ---------

   // Ya tenemos en LineasAux la escena a ejecutar, hay que hacer algunos
   // cambios en el cdigo VRML:
   AnsiString rutaPython = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\" + FICH_ASIGNA_TRANSFORM_SCRIPT;
   // Tenemos que cambiar cada \ por \\ para que python localice el fichero
   // correctamente.
   Utilidad.DuplicaBarras(rutaPython);

   Utilidad.Sustituir(Main->LineasAux,"DIS_X1X2X3X4",displayNombreDado);
   Utilidad.Sustituir(Main->LineasAux,"MotorObjeto_X1X2X3X4",transfNombreDado);
   Utilidad.Sustituir(Main->LineasAux,"urlPS_X1X2X3X4.py",rutaPython);

   // Solo falta salvar lineasAux a un fichero situado en la misma carpeta que
   // la escena actual y ejecutarlo:

   file = Raiz->AsRaiz()->fichero.Trim();

   if(file == "")
      file = (AnsiString)FICHERO_POR_DEFECTO + (AnsiString)EXTENSION_X3D;

   if(file[1] == '?'){
      // En este caso an no se ha dado ningn nombre a la escena.
      // Vamos a hacer que se cree el file de prueba en la carpeta del programa

      file = ExtractFileName(file);
      file = Main->CARPETA_PROGRAMA + "\\" + file;
   }

   file.Delete(file.AnsiPos(EXTENSION_X3D), ((AnsiString)EXTENSION_X3D).Length() );

   // Aadimos el sufijo y la extensin:
   file = file + CONF.SUF_FICHERO_PRUEBA + EXTENSION_X3D;

   if(!Utilidad.SaveToFile(Main->LineasAux,file))
      // Ya se da un mensaje de error en SaveToFile.
      return;

   EjecutarFichero(file,0, ESCENA_H3D );

   // Solo falta Borrar el fichero de prueba y comprobar frmConsola para ver
   // si se han asignado los valores de transform:

   // Borramos los ficheros:
   AnsiString extension = ExtractFileExt(file);
   if( false && (extension.Length() != 0) ){
      file = file.Delete(file.Pos(extension),extension.Length());

      if(FileExists(file + EXTENSION_wrlb))
          try{DeleteFile(file + EXTENSION_wrlb); }
          catch(...){} // No es necesario dar un mensaje de error


      if(FileExists(file + EXTENSION_X3D))
          try{DeleteFile(file + EXTENSION_X3D); }
          catch(...){} //No es necesario dar un mensaje de error
     }

   // Hemos borrado los ficheros, consultamos frmConsola:
   TStrings *consola = frmConsola->Memo->Lines;
   if( consola->Count >= 6){
      // Un ejemplo de la salida que da el script es:
      //   -----------------------------------
      //      Valores del nodo Transform:
      //   -----------------------------------
      //   translation: 0 0 0
      //   rotation:    0 1 0 3.14
      //   scale:       1 1 1        

      if(consola->Strings[consola->Count-5].Trim() == "Valores del nodo Transform:"){
         // En este caso se ha pulsado aceptar en el script -> Leemos los valores
         // del nodo transform.
         AnsiString campo,translation,scale,rotation;

         // Leemos el campo translation:
         translation = consola->Strings[consola->Count-3];
         campo = Utilidad.CortaPrimeraPalabra(translation);
         translation = translation.Trim();
         if(campo.Trim() != "translation:")
            Utilidad.MsgInfo("The translation field value can't be read.","Advertencia");

         // Leemos el campo rotation:
         rotation = consola->Strings[consola->Count-2];
         campo = Utilidad.CortaPrimeraPalabra(rotation);
         rotation = rotation.Trim();
         if(campo.Trim() != "rotation:")
            Utilidad.MsgInfo("The rotation field value can't be read.","Advertencia");

         // Leemos el campo scale:
         scale = consola->Strings[consola->Count-1];
         campo = Utilidad.CortaPrimeraPalabra(scale);
         scale = scale.Trim();
         if(campo.Trim() != "scale:")
            Utilidad.MsgInfo("The scale field value can't be read.","Advertencia");

         // Ahora vamos a asignar los campos del nodo transform:
         NodoArbol *hijo;
         for(int c=0; c <= transform->hijos->MaxIndexUsado(); c++){
            hijo = (NodoArbol *)transform->hijos->Get(c);
            if(hijo->EsCampo()){
                if ( hijo->AsCampo()->nombre == "translation" ){
                   hijo->AsCampo()->valor = translation;

                }else if ( hijo->AsCampo()->nombre == "rotation" ){
                   hijo->AsCampo()->valor = rotation;

                }else if ( hijo->AsCampo()->nombre == "scale" ){
                   hijo->AsCampo()->valor = scale;
                }
            }
         }
         EscenaModificada(false);
         Actualiza();
      }
   } */
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::FormShortCut(TWMKey &Msg, bool &Handled)
{
  // Vamos a gestionar las pulsaciones del Tab de un modo especial. Queremos
  // que con cada pulsacin del tabulador se cambie el tab actual de Carpetas.

  // El bit 30 de Msg.KeyData es 1 si la tecla est pulsada antes de que se produzca
  // el evento.
  if(0x40000000 & Msg.KeyData)
     return;

  if(Msg.CharCode == VK_TAB){
     Carpetas->ActivePageIndex =  (Carpetas->ActivePageIndex == 0) ? 1:0;
     Handled =true;
     CarpetasChange(NULL);
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmEscena::CodigoMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
   // del texto, lo evitamos con  FormateoAnulado en OnMouseDown y OnMouseUp:
   FormateoAnulado=false;
   ReVRML.FormateaPantalla(this,Codigo);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::CodigoMouseWheel(TObject *Sender,
      TShiftState Shift, int WheelDelta, TPoint &MousePos, bool &Handled)
{
   // La seleccin parpada cuando se desplaza el texto -> Lo evitamos
   Codigo->SelLength=0;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEscena::IniciaAsignarRGB(){

   if(Raiz == NULL)
      return;

   // En primer lugar hay que comprobar que la escena sea H3D.
   //if( Raiz->AsRaiz()->tipoEscena != ESCENA_H3D )
   {
      Utilidad.MsgInfo("The visual utilities are not available in this version.","Advertencia");
      return;
   }
   /*

   // Adems debemos tener un elemento seleccionado y que sea un campo de tipo SFRGB.
   if( (TreeView->Selected == NULL) || (TreeView->Selected->Data == NULL) ){
      Utilidad.MsgInfo("You must select a SFRGB field.");
      return;
   }
   NodoArbol *rgb = ((NodoArbol *)TreeView->Selected->Data);
   if( (!rgb->EsCampo()) || (rgb->dato == NULL) ||
       (rgb->AsCampo()->datosCampo->tipo->nombre.Trim() != "SFRGB")  )
   {
      Utilidad.MsgInfo("You must select a SFRGB field.");
      return;
   }

   // Adems el campo no puede ser ni un evento ni field (debe ser porque
   // internamente se usan rutados cuando se asignan valores a elementos de la
   // escena desde Scripts).
   if( rgb->AsCampo()->datosCampo->rutado != EXPOSEDFIELD){
      Utilidad.MsgInfo("You must select a ExposedField field.");
      return;
   }

   NodoArbol *padre = rgb->padre;

   if( (padre == NULL) || !padre->EsNodo() )
      return;

   // Ahora tenemos que asegurarnos de que el nodo padre tiene un nombre no repetido.
   // Recorremos la escena buscando nodos llamados transform->AsNodo()->nombreDado
   if(padre->AsNodo()->nombreDado != ""){
      AnsiString nombreDado = padre->AsNodo()->nombreDado;
      int numNombres = 0;
      NodoArbol *punt;
      IniciaRecorrerArbol(NODO);
      punt=RecorrerArbol();
      while(punt != NULL){
          // Solo hay que comprobar el nombre de los nodos.
          if(  (punt != NULL) && (punt->AsNodo()->nombreDado == nombreDado) )
             numNombres++;
          punt=RecorrerArbol();
      }
      if(numNombres > 1){
         Utilidad.MsgInfo("The identifier  " + nombreDado + " is duplicated.","Advertencia");
         return;
      }
   }

   // Ya tenemos el campo y su nodo padre, los usamos:
   TipoNodo *tnPadre = padre->AsNodo();

   // Vamos a asignar temporalmente un nombre al nodo:
   AnsiString nombreDadoOriginal = tnPadre->nombreDado.Trim();
   AnsiString nombreDado;

   if( nombreDadoOriginal.Trim() != ""){
      nombreDado = nombreDadoOriginal;
   }else{
      nombreDado = "NODO_PADRE_RGB";
      int cont=1;
      while(ExisteNombreNodo(nombreDado))
         nombreDado = "NODO_PADRE_RGB" + Formatea(cont++,4);
   }

   // Adems necesitaremos en el script que la escena tenga un nodo Display:
   //  Lo buscamos-> Usamos la funcin que recorre el rbol.
   NodoArbol *nodoDisplay = NULL;
   TipoNodo *display=NULL;
   {
      NodoArbol *punt;
      int numDisplays=0;
      IniciaRecorrerArbol(NODO);
      punt=RecorrerArbol();
      while(punt != NULL){
          // Solo hay que comprobar el nombre de los nodos y que no haya ms de
          // un nodo Display.
          if(  ((TipoNodo *)punt->dato != NULL) &&
              (punt->AsNodo()->nombre == "Display") ){
             display=punt->AsNodo();
             nodoDisplay = punt;
             numDisplays++;
          }
          punt=RecorrerArbol();
      }
      if(numDisplays > 1){
         Utilidad.MsgInfo("There are several Display nodes in the Scene. The scene must have only one.","Advertencia");
         return;
      }
      if(display==NULL){
         Utilidad.MsgInfo("The scene must have a Display node.","Advertencia");
         return;
      }
   }

   // Ahora tenemos que asegurarnos de que no se le ha dado el mismo nombre a
   // otro nodo. Recorremos la escena buscando nodos llamados nodoDisplay->AsNodo()->nombreDado.
   if(nodoDisplay->AsNodo()->nombreDado != ""){
      AnsiString nombreDado = nodoDisplay->AsNodo()->nombreDado;
      int numNombres = 0;
      NodoArbol *punt;
      IniciaRecorrerArbol(NODO);
      punt=RecorrerArbol();
      while(punt != NULL){
          // Solo hay que comprobar el nombre de los nodos.
          if(  (punt != NULL) && (punt->AsNodo()->nombreDado == nombreDado) )
             numNombres++;
          punt=RecorrerArbol();
      }
      if(numNombres > 1){
         Utilidad.MsgInfo("The identifier  " + nombreDado + " is duplicated.","Advertencia");
         return;
      }
   }

   // La escena tiene un nodo Display: Tambin hay que asignarle un nombre:
   AnsiString displayNombreDadoOriginal = display->nombreDado.Trim();
   AnsiString displayNombreDado;
   if( displayNombreDadoOriginal.Trim() != ""){
      displayNombreDado = displayNombreDadoOriginal;
   }else{
      displayNombreDado = "NodoDisplay";
      int cont=1;
      while(ExisteNombreNodo(displayNombreDado))
         displayNombreDado = "NodoDisplay" + Formatea(cont++,4);
   }

   // Una vez realizadas todas las comprobaciones vamos a ejecutar la escena.
   // tenemos que cambiar los nombres de los nodos padre y Display.
   tnPadre->nombreDado = nombreDado;
   display->nombreDado = displayNombreDado;

   // El siguiente paso es crear en LineasAux el fichero que vamos a ejecutar.
   // Tendremos que aadir cdigo dentro del campo children del nodo Display y
   // tb al final del fichero. La forma ms cmoda de hacerlo es crear un comentario
   // dentro de Display.children para saber donde tenemos que incluir el texto:

   // Lo primero es buscar el campo children de display:
   NodoArbol *displayChildren = NULL;
   for(int c=0; c <= nodoDisplay->hijos->MaxIndexUsado(); c++){
       if(NULL != nodoDisplay->hijos->Get(c)){
           NodoArbol *hijo = (NodoArbol *)nodoDisplay->hijos->Get(c);
           if( hijo->EsCampo() && (hijo->AsCampo()->nombre == "children") ){
             displayChildren = hijo;
             break;
           }
       }
   }

   if(NULL == displayChildren){
      tnPadre ->nombreDado = nombreDadoOriginal;
      display->nombreDado = displayNombreDadoOriginal;
      Utilidad.MsgInfo("The children field of the Display node is not registered.","Advertencia");
      return;
   }

   // Aadimos la marca en display Children:
   NodoArbol *marca; // =NULL; comentado para evitar el warning "is assigned a value thar is never used
   {

       bool esCampoMFNodeNoEvento = displayChildren->EsCampoMFNodeNoEvento();

       // Creamos un nuevo nodo con los datos leidos.
       NodoArbol *comentario= CrearNodo(COMENTARIO);
       comentario->AsComentario()->texto=MARCA_PARA_COLOCAR_OBJTS;
       if( esCampoMFNodeNoEvento )
           AnadirUltimoHijo(comentario,displayChildren);

       CrearNodoAsociado(comentario);
       marca = comentario;
   }
   if(marca == NULL){
      tnPadre->nombreDado = nombreDadoOriginal;
      display->nombreDado = displayNombreDadoOriginal;
      Utilidad.MsgInfo("An error has occurred while building the scene.","Advertencia");
      return;
   }
   
   // Salvamos la escena a LineasAux.
   Main->LineasAux->Clear();
   GVRML.EscribeFichero(Raiz,Main->LineasAux,TreeView->Items->Count);

   // Reponemos los nombres originales de los nodos transform y display.
   tnPadre->nombreDado = nombreDadoOriginal;
   display->nombreDado = displayNombreDadoOriginal;

   // Borramos el comentario anterior:
   EliminarNodo(marca);

   // ------------------ INICIO DE LA FORMACIN DEL FICHERO A EJECUTAR ---------
   // Necesitaremos importar las libreras para usar las User Interface ToolKit
   // as que si la escena actual no la incluye, las incluiremos nosotros:
   if(!UsaUI_ToolKit())
      Main->LineasAux->Insert(0,"Import { url " + CONF.URL_USER_INTERFACE_TOOLKIT + " } ");

   // El siguiente paso es avanzar indexEscena hasta la marca que hemos incluido antes:
   int indexEscena=0;
   while( (indexEscena < Main->LineasAux->Count) &&
          (0 == Main->LineasAux->Strings[indexEscena].Pos(MARCA_PARA_COLOCAR_OBJTS)) ){
      indexEscena++;
   }

   // Comprobamos que no hemos llegado al final de las lineas de la escena.
   if(indexEscena == Main->LineasAux->Count){
      Utilidad.MsgInfo("An error has occurred while building the scene.","Advertencia");
      return;
   }

   // Borramos el comentario (la marca).
   Main->LineasAux->Delete(indexEscena);

   // Ahora tenemos que aadir en la posicin actual el contenido del
   // fichero FICH_ASIGNA_RGB_1. Vamos a necesitar otro tipo
   // TStringList, vamos a usar ErroresDeLectura para no reservar memoria
   // para un tipo nuevo y le vamos a llamar lineas:
   TStringList *lineas = ErroresDeLectura;

   // Vamos a cargar el fichero en lineas.
   AnsiString carpeta = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\";
   AnsiString file = carpeta + FICH_ASIGNA_RGB_1;

   lineas->Clear();
   if(! Utilidad.LoadFromFile(lineas,file,false))
      return;

   // Ahora tenemos que insertarlo en la posicin actual de LineasAux:
   for(int c = lineas->Count-1; c >= 0 ; c--)
      Main->LineasAux->Insert(indexEscena,lineas->Strings[c]);

   // El siguiente paso es aadir el fichero FICH_ASIGNA_RGB_2 al
   // final de lneasAux:
   file = carpeta + FICH_ASIGNA_RGB_2;

   lineas->Clear();
   if(! Utilidad.LoadFromFile(lineas,file,false))
      return;

   // Ahora tenemos que insertarlo al final de LineasAux:
   for(int c = 0;c < lineas->Count;c++)
      Main->LineasAux->Append(lineas->Strings[c]);

   // ------------------- FINAL DE LA FORMACIN DEL FICHERO A EJECUTAR ---------

   // Ya tenemos en LineasAux la escena a ejecutar, hay que hacer algunos
   // cambios en el cdigo VRML:
   AnsiString rutaPythonPrueba = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\" + "prueba_" + FICH_ASIGNA_RGB_SCRIPT;
   AnsiString rutaPythonOriginal = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\" + FICH_ASIGNA_RGB_SCRIPT;
   // Tenemos que cambiar cada \ por \\ para que python localice el fichero
   // correctamente.
   AnsiString tmp = rutaPythonPrueba;
   Utilidad.DuplicaBarras(tmp);

   Utilidad.Sustituir(Main->LineasAux,"DIS_X1X2X3X4",displayNombreDado);
   Utilidad.Sustituir(Main->LineasAux,"NODOPADRE_X1X2X3X4",nombreDado);
   Utilidad.Sustituir(Main->LineasAux,"urlPS_X1X2X3X4.py",tmp);

   // Ahora hay que salvar lineasAux a un fichero situado en la misma carpeta que
   // la escena actual y ejecutarlo:

   file = Raiz->AsRaiz()->fichero.Trim();

   if(file == "")
      file = (AnsiString)FICHERO_POR_DEFECTO + (AnsiString)EXTENSION_X3D;

   if(file[1] == '?'){
      // En este caso an no se ha dado ningn nombre a la escena.
      // Vamos a hacer que se cree el file de prueba en la carpeta del programa

      file = ExtractFileName(file);
      file = Main->CARPETA_PROGRAMA + "\\" + file;
   }

   file.Delete(file.AnsiPos(EXTENSION_X3D), ((AnsiString)EXTENSION_X3D).Length() );

   // Aadimos el sufijo y la extensin:
   file = file + CONF.SUF_FICHERO_PRUEBA + EXTENSION_X3D;

   if(!Utilidad.SaveToFile(Main->LineasAux,file))
      // Ya se da un mensaje de error en SaveToFile.
      return;

   // Un ltimo paso es cambiar en el script para especificar el nombre del campo:

   // Vamos a usar Main->LineasAux para modificar el script:
   if(!FileExists(rutaPythonOriginal)){
      Utilidad.MsgInfo("The following file doesn't exist:"+rutaPythonOriginal);
      return;
   }

   Main->LineasAux->LoadFromFile(rutaPythonOriginal);
   // Ahora sustituimos el nombre del campo en el script:
   Utilidad.Sustituir(Main->LineasAux,"CAMPO_X1X2X3X4",rgb->AsCampo()->nombre);

   // Salvamos el script al fichero de pruebas:
   if(!Utilidad.SaveToFile(Main->LineasAux,rutaPythonPrueba))
      // Ya se da un mensaje de error en SaveToFile.
      return;

   EjecutarFichero(file,0, ESCENA_H3D );

   // Solo falta Borrar el fichero de prueba y comprobar frmConsola para ver
   // si se han asignado los valores del campo:

   // Borramos los ficheros:
   AnsiString extension = ExtractFileExt(file);
   if( false && (extension.Length() != 0) ){
      file = file.Delete(file.Pos(extension),extension.Length());

      if(FileExists(file + EXTENSION_wrlb))
          try{DeleteFile(file + EXTENSION_wrlb); }
          catch(...){}//No es necesario dar un mensaje de error


      if(FileExists(file + EXTENSION_X3D))
          try{DeleteFile(file + EXTENSION_X3D); }
          catch(...){}//No es necesario dar un mensaje de error
   }

   // Hemos borrado los ficheros, consultamos frmConsola:
   TStrings *consola = frmConsola->Memo->Lines;
   // Un ejemplo de la salida que da el script es:
   // El valor del campo elegido es: 1.0 0.4041 0.3496

   if( (consola->Count > 1) &&
       (0 != consola->Strings[consola->Count-1].Pos("El valor del campo elegido es:"))){
       // En este caso se ha pulsado aceptar en el script -> Leemos los valores
       // del nodo transform.
       int index = consola->Strings[consola->Count-1].Pos("El valor del campo elegido es:");
       tmp = "El valor del campo elegido es:";
       int longit = tmp.Length();
       AnsiString cad = consola->Strings[consola->Count-1].Delete(index,longit);
       rgb->AsCampo()->valor = cad.Trim();
       EscenaModificada(false);
       Actualiza();
   } */
}

//---------------------------------------------------------------------------
void __fastcall TfrmEscena::IniciaAsignarSFVec3f(){

   if(Raiz == NULL)
      return;

   // En primer lugar hay que comprobar que la escena sea H3D.
   //if( Raiz->AsRaiz()->tipoEscena != ESCENA_H3D )
   {
      Utilidad.MsgInfo("The visual utilities are not available in this version.","Advertencia");
      return;
   }
/*
   // Adems debemos tener un elemento seleccionado y que sea un campo de tipo SFVec3f.
   if( (TreeView->Selected == NULL) || (TreeView->Selected->Data == NULL) ){
      Utilidad.MsgInfo("You must select a SFVec3f field.");
      return;
   }
   NodoArbol *vec3f = ((NodoArbol *)TreeView->Selected->Data);
   if( (!vec3f->EsCampo()) || (vec3f->dato == NULL) ||
       (vec3f->AsCampo()->datosCampo->tipo->nombre.Trim() != "SFVec3f")  )
   {
      Utilidad.MsgInfo("You must select a SFVec3f field.");
      return;
   }

   // Adems el campo no puede ser ni un evento ni field (debe ser porque
   // internamente se usan rutados cuando se asignan valores a elementos de la
   // escena desde Scripts).
   if( vec3f->AsCampo()->datosCampo->rutado != EXPOSEDFIELD){
      Utilidad.MsgInfo("You must select a ExposedField field.");
      return;
   }

   NodoArbol *padre = vec3f->padre;

   if( (padre == NULL) || !padre->EsNodo() )
      return;

   // Ahora tenemos que asegurarnos de que el nodo padre tiene un nombre no repetido.
   // Recorremos la escena buscando nodos llamados transform->AsNodo()->nombreDado
   if(padre->AsNodo()->nombreDado != ""){
      AnsiString nombreDado = padre->AsNodo()->nombreDado;
      int numNombres = 0;
      NodoArbol *punt;
      IniciaRecorrerArbol(NODO);
      punt=RecorrerArbol();
      while(punt != NULL){
          // Solo hay que comprobar el nombre de los nodos.
          if(  (punt != NULL) && (punt->AsNodo()->nombreDado == nombreDado) )
             numNombres++;
          punt=RecorrerArbol();
      }
      if(numNombres > 1){
         Utilidad.MsgInfo("The identifier  " + nombreDado + " is duplicated.","Advertencia");
         return;
      }
   }

   // Ya tenemos el campo y su nodo padre, los usamos:
   TipoNodo *tnPadre = padre->AsNodo();

   // Vamos a asignar temporalmente un nombre al nodo:
   AnsiString nombreDadoOriginal = tnPadre->nombreDado.Trim();
   AnsiString nombreDado;

   if( nombreDadoOriginal.Trim() != ""){
      nombreDado = nombreDadoOriginal;
   }else{
      nombreDado = "NODO_PADRE_VEC3F";
      int cont=1;
      while(ExisteNombreNodo(nombreDado))
         nombreDado = "NODO_PADRE_VEC3F" + Formatea(cont++,4);
   }

   // Adems necesitaremos en el script que la escena tenga un nodo Display:
   //  Lo buscamos-> Usamos la funcin que recorre el rbol.
   NodoArbol *nodoDisplay = NULL;
   TipoNodo *display=NULL;
   {
      NodoArbol *punt;
      int numDisplays=0;
      IniciaRecorrerArbol(NODO);
      punt=RecorrerArbol();
      while(punt != NULL){
          // Solo hay que comprobar el nombre de los nodos y que no haya ms de
          // un nodo Display.
          if(  ((TipoNodo *)punt->dato != NULL) &&
              (punt->AsNodo()->nombre == "Display") ){
             display=punt->AsNodo();
             nodoDisplay = punt;
             numDisplays++;
          }
          punt=RecorrerArbol();
      }
      if(numDisplays > 1){
         Utilidad.MsgInfo("There are several Display nodes in the Scene. The scene must have only one.","Advertencia");
         return;
      }
      if(display==NULL){
         Utilidad.MsgInfo("The scene must have a Display node.","Advertencia");
         return;
      }
   }

   // Ahora tenemos que asegurarnos de que no se le ha dado el mismo nombre a
   // otro nodo. Recorremos la escena buscando nodos llamados nodoDisplay->AsNodo()->nombreDado.
   if(nodoDisplay->AsNodo()->nombreDado != ""){
      AnsiString nombreDado = nodoDisplay->AsNodo()->nombreDado;
      int numNombres = 0;
      NodoArbol *punt;
      IniciaRecorrerArbol(NODO);
      punt=RecorrerArbol();
      while(punt != NULL){
          // Solo hay que comprobar el nombre de los nodos.
          if(  (punt != NULL) && (punt->AsNodo()->nombreDado == nombreDado) )
             numNombres++;
          punt=RecorrerArbol();
      }
      if(numNombres > 1){
         Utilidad.MsgInfo("The identifier  " + nombreDado + " is duplicated.","Advertencia");
         return;
      }
   }

   // La escena tiene un nodo Display: Tambin hay que asignarle un nombre:
   AnsiString displayNombreDadoOriginal = display->nombreDado.Trim();
   AnsiString displayNombreDado;
   if( displayNombreDadoOriginal.Trim() != ""){
      displayNombreDado = displayNombreDadoOriginal;
   }else{
      displayNombreDado = "NodoDisplay";
      int cont=1;
      while(ExisteNombreNodo(displayNombreDado))
         displayNombreDado = "NodoDisplay" + Formatea(cont++,4);
   }

   // Una vez realizadas todas las comprobaciones vamos a ejecutar la escena.
   // tenemos que cambiar los nombres de los nodos padre y Display.
   tnPadre->nombreDado = nombreDado;
   display->nombreDado = displayNombreDado;

   // El siguiente paso es crear en LineasAux el fichero que vamos a ejecutar.
   // Tendremos que aadir cdigo dentro del campo children del nodo Display y
   // tb al final del fichero. La forma ms cmoda de hacerlo es crear un comentario
   // dentro de Display.children para saber donde tenemos que incluir el texto:

   // Lo primero es buscar el campo children de display:
   NodoArbol *displayChildren = NULL;
   for(int c=0; c <= nodoDisplay->hijos->MaxIndexUsado(); c++){
       if(NULL != nodoDisplay->hijos->Get(c)){
           NodoArbol *hijo = (NodoArbol *)nodoDisplay->hijos->Get(c);
           if( hijo->EsCampo() && (hijo->AsCampo()->nombre == "children") ){
             displayChildren = hijo;
             break;
           }
       }
   }

   if(NULL == displayChildren){
      tnPadre ->nombreDado = nombreDadoOriginal;
      display->nombreDado = displayNombreDadoOriginal;
      Utilidad.MsgInfo("The children field of the Display node is not registered.","Advertencia");
      return;
   }

   // Aadimos la marca en display Children:
   NodoArbol *marca; // =NULL; comentado para evitar el warning "is assigned a value thar is never used
   {

       bool esCampoMFNodeNoEvento = displayChildren->EsCampoMFNodeNoEvento();

       // Creamos un nuevo nodo con los datos leidos.
       NodoArbol *comentario= CrearNodo(COMENTARIO);
       comentario->AsComentario()->texto=MARCA_PARA_COLOCAR_OBJTS;
       if( esCampoMFNodeNoEvento )
           AnadirUltimoHijo(comentario,displayChildren);

       CrearNodoAsociado(comentario);
       marca = comentario;
   }
   if(marca == NULL){
      tnPadre->nombreDado = nombreDadoOriginal;
      display->nombreDado = displayNombreDadoOriginal;
      Utilidad.MsgInfo("An error has occurred while building the scene.","Advertencia");
      return;
   }

   // Salvamos la escena a LineasAux.
   Main->LineasAux->Clear();
   GVRML.EscribeFichero(Raiz,Main->LineasAux,TreeView->Items->Count);

   // Reponemos los nombres originales de los nodos transform y display.
   tnPadre->nombreDado = nombreDadoOriginal;
   display->nombreDado = displayNombreDadoOriginal;

   // Borramos el comentario anterior:
   EliminarNodo(marca);

   // ------------------ INICIO DE LA FORMACIN DEL FICHERO A EJECUTAR ---------
   // Necesitaremos importar las libreras para usar las User Interface ToolKit
   // as que si la escena actual no la incluye, las incluiremos nosotros:
   if(!UsaUI_ToolKit())
      Main->LineasAux->Insert(0,"Import { url " + CONF.URL_USER_INTERFACE_TOOLKIT + " } ");

   // El siguiente paso es avanzar indexEscena hasta la marca que hemos incluido antes:
   int indexEscena=0;
   while( (indexEscena < Main->LineasAux->Count) &&
          (0 == Main->LineasAux->Strings[indexEscena].Pos(MARCA_PARA_COLOCAR_OBJTS)) ){
      indexEscena++;
   }

   // Comprobamos que no hemos llegado al final de las lineas de la escena.
   if(indexEscena == Main->LineasAux->Count){
      Utilidad.MsgInfo("An error has occurred while building the scene.","Advertencia");
      return;
   }

   // Borramos el comentario (la marca).
   Main->LineasAux->Delete(indexEscena);

   // Ahora tenemos que aadir en la posicin actual el contenido del
   // fichero FICH_ASIGNA_RGB_1. Vamos a necesitar otro tipo
   // TStringList, vamos a usar ErroresDeLectura para no reservar memoria
   // para un tipo nuevo y le vamos a llamar lineas:
   TStringList *lineas = ErroresDeLectura;

   // Vamos a cargar el fichero en lineas.
   AnsiString carpeta = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\";
   AnsiString file = carpeta + FICH_ASIGNA_SFVec3f_1;

   lineas->Clear();
   if(! Utilidad.LoadFromFile(lineas,file,false))
      return;

   // Ahora tenemos que insertarlo en la posicin actual de LineasAux:
   for(int c = lineas->Count-1; c >= 0 ; c--)
      Main->LineasAux->Insert(indexEscena,lineas->Strings[c]);

   // El siguiente paso es aadir el fichero FICH_ASIGNA_Vec3f_2 al
   // final de lneasAux:
   file = carpeta + FICH_ASIGNA_SFVec3f_2;

   lineas->Clear();
   if(! Utilidad.LoadFromFile(lineas,file,false))
      return;

   // Ahora tenemos que insertarlo al final de LineasAux:
   for(int c = 0;c < lineas->Count;c++)
      Main->LineasAux->Append(lineas->Strings[c]);

   // ------------------- FINAL DE LA FORMACIN DEL FICHERO A EJECUTAR ---------

   // Ya tenemos en LineasAux la escena a ejecutar, hay que hacer algunos
   // cambios en el cdigo VRML:
   AnsiString rutaPythonPrueba = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\" + "prueba_" + FICH_ASIGNA_Vec3f_SCRIPT;
   AnsiString rutaPythonOriginal = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\" + FICH_ASIGNA_Vec3f_SCRIPT;
   // Tenemos que cambiar cada \ por \\ para que python localice el fichero
   // correctamente.
   AnsiString tmp = rutaPythonPrueba;
   Utilidad.DuplicaBarras(tmp);

   Utilidad.Sustituir(Main->LineasAux,"DIS_X1X2X3X4",displayNombreDado);
   Utilidad.Sustituir(Main->LineasAux,"NODOPADRE_X1X2X3X4",nombreDado);
   Utilidad.Sustituir(Main->LineasAux,"urlPS_X1X2X3X4.py",tmp);

   // Ahora hay que salvar lineasAux a un fichero situado en la misma carpeta que
   // la escena actual y ejecutarlo:

   file = Raiz->AsRaiz()->fichero.Trim();

   if(file == "")
      file = (AnsiString)FICHERO_POR_DEFECTO + (AnsiString)EXTENSION_X3D;

   if(file[1] == '?'){
      // En este caso an no se ha dado ningn nombre a la escena.
      // Vamos a hacer que se cree el file de prueba en la carpeta del programa

      file = ExtractFileName(file);
      file = Main->CARPETA_PROGRAMA + "\\" + file;
   }

   file.Delete(file.AnsiPos(EXTENSION_X3D), ((AnsiString)EXTENSION_X3D).Length() );

   // Aadimos el sufijo y la extensin:
   file = file + CONF.SUF_FICHERO_PRUEBA + EXTENSION_X3D;

   if(!Utilidad.SaveToFile(Main->LineasAux,file))
      // Ya se da un mensaje de error en SaveToFile.
      return;

   // Un ltimo paso es cambiar en el script para especificar el nombre del campo:

   // Vamos a usar Main->LineasAux para modificar el script:
   if(!FileExists(rutaPythonOriginal)){
      Utilidad.MsgInfo("The following file doesn't exist:"+rutaPythonOriginal);
      return;
   }

   Main->LineasAux->LoadFromFile(rutaPythonOriginal);
   // Ahora sustituimos el nombre del campo en el script:
   Utilidad.Sustituir(Main->LineasAux,"CAMPO_X1X2X3X4",vec3f->AsCampo()->nombre);

   // Salvamos el script al fichero de pruebas:
   if(!Utilidad.SaveToFile(Main->LineasAux,rutaPythonPrueba))
      // Ya se da un mensaje de error en SaveToFile.
      return;

   EjecutarFichero(file,0, ESCENA_H3D );

   // Solo falta Borrar el fichero de prueba y comprobar frmConsola para ver
   // si se han asignado los valores del campo:

   // Borramos los ficheros:
   AnsiString extension = ExtractFileExt(file);
   if( false && (extension.Length() != 0) ){
      file = file.Delete(file.Pos(extension),extension.Length());

      if(FileExists(file + EXTENSION_wrlb))
          try{DeleteFile(file + EXTENSION_wrlb); }
          catch(...){}//No es necesario dar un mensaje de error


      if(FileExists(file + EXTENSION_X3D))
          try{DeleteFile(file + EXTENSION_X3D); }
          catch(...){}//No es necesario dar un mensaje de error
   }

   // Hemos borrado los ficheros, consultamos frmConsola:
   TStrings *consola = frmConsola->Memo->Lines;
   // Un ejemplo de la salida que da el script es:
   // El valor del campo elegido es: 1.0 0.4041 0.3496

   if( (consola->Count > 1) &&
       (0 != consola->Strings[consola->Count-1].Pos("El valor del campo elegido es:"))){
       // En este caso se ha pulsado aceptar en el script -> Leemos los valores
       // del nodo transform.
       int index = consola->Strings[consola->Count-1].Pos("El valor del campo elegido es:");
       tmp = "El valor del campo elegido es:";
       int longit = tmp.Length();
       AnsiString cad = consola->Strings[consola->Count-1].Delete(index,longit);
       vec3f->AsCampo()->valor = cad.Trim();
       EscenaModificada(false);
       Actualiza();
   }  */
}



