//
//    EDITOR DE TEXTO     
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Editor de texto con las opciones bsicas y algunas utilidades
                para ficheros VRML (como ejecucin y verificacin de cdigo). */
//---------------------------------------------------------------------------

#ifndef frmEditor_H
#define frmEditor_H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <ToolWin.hpp>
#include <Dialogs.hpp>
#include "Main_.h"
#include <Graphics.hpp>

/* Esta clase contiene los datos asociados a cada fichero para poder editar varios
ficheros a la vez con un mismo componente TRichEdit incluido en un TTabControl. */
class DatosFichero{
   public:
      // Indica si los datos que se han recibido desde el rbol han sido
      // modificados en frmEscena (independientemente de que estos datos estn
      // salvados en disco o no).
      bool datosModificados;

      // Falso si los datos editados estn guardados en disco.
      bool ficheroModificado;

      // Contiene el nmero de la primera linea visible.
      int primeraLinea;

      // Posicin en la que empieza la seleccion.
      int selStart;

      // Longitud de la seleccin.
      int selLength;

      // Contiene la posicin de las Marcas que se colocan en el Texto.
      int marca1;
      int marca2;
      int marca3;
      int marca4;

      // Solo uno de los ficheros editados ser el fichero principal (el de frmEscena).
      bool esFicheroPrincipal;

      // Contiene la ruta completa del fichero de texto que se est editando.
      AnsiString fichero;

      // Guarda temporalmente el texto cuando se edita otro fichero.
      AnsiString datos;

      // Constructores:
      DatosFichero(AnsiString f,bool fm,bool dm);
      DatosFichero();
};


//---------------------------------------------------------------------------
class TfrmEditor : public TForm
{
__published:	// IDE-managed Components
    TMainMenu *Menu;
        TMenuItem *mnArchivo;
    TMenuItem *mnNuevo;
    TMenuItem *mnAbrir;
    TMenuItem *mnGuardar;
    TMenuItem *mnGuardarComo;
    TMenuItem *mnArchivoBarra;
    TMenuItem *mnVolver;
    TMenuItem *mnEdicion;
    TMenuItem *mnCortar;
    TMenuItem *mnCopiar;
    TMenuItem *mnPegar;
    TMenuItem *mnEdicionBarra2;
    TMenuItem *mnBuscar;
    TMenuItem *mnBuscarSiguiente;
    TMenuItem *mnEjecucion;
    TMenuItem *mnEjecutarEscena;
    TMenuItem *mnAyuda;
    TToolBar *ToolBar;
    TSpeedButton *sbGuardar;
    TSpeedButton *sbAbrir;
    TSpeedButton *sbNuevo;
    TSpeedButton *sbGuardarComo;
    TSpeedButton *sbCortar;
    TSpeedButton *sbPegar;
    TSpeedButton *sbBuscar;
    TSpeedButton *sbCopiar;
    TSpeedButton *sbBuscarSiguiente;
    TMenuItem *mnMantenerCambios;
    TMenuItem *mnNoMantenerCambios;
    TSpeedButton *sbCancelar;
    TSpeedButton *sbVolverOK;
        TPanel *pnlInfo;
    TPanel *pnlTipoEscena;
    TPanel *pnlNombreFichero;
    TPanel *pnlFilaCol;
    TPanel *pnlLineas;
    TPanel *pnlModificado;
        TSpeedButton *sbEjecutar;
        TSpeedButton *SpeedButton2;
        TPanel *pnlInsert;
        TLabel *lbNombreFichero;
        TSpeedButton *sbAyuda;
        TSpeedButton *sbConsola;
        TMenuItem *mnEjecucionConsola;
        TSpeedButton *sbConfiguracion;
        TTabControl *TabControl;
        TPanel *pnlMarcas;
        TPanel *pnlTexto;
        TRichEdit *Texto;
        TMenuItem *mnCerrar;
        TSpeedButton *sbSetMarca1;
        TSpeedButton *sbMarca1;
        TSpeedButton *sbSetMarca2;
        TSpeedButton *sbMarca2;
        TSpeedButton *sbSetMarca3;
        TSpeedButton *sbMarca3;
        TSpeedButton *sbSetMarca4;
        TSpeedButton *sbMarca4;
        TMenuItem *mnMarcas;
        TMenuItem *mnIraMarca1;
        TMenuItem *mnIraMarca2;
        TMenuItem *mnIraMarca3;
        TMenuItem *mnIraMarca4;
        TMenuItem *mnMarcasSeparador;
        TMenuItem *mnSetMarca1;
        TMenuItem *mnSetMarca2;
        TMenuItem *mnSetMarca3;
        TMenuItem *mnSetMarca4;
        TMenuItem *mnGuardarTodo;
        TPanel *pnlInsercion;
        TListBox *lbVRML;
        TListBox *lbAT;
        TTimer *TimerAC;
        TMenuItem *mnDeshacer;
        TMenuItem *mnEdicionBarra0;
        TMenuItem *mnUtilidades;
        TMenuItem *mnConfigurar;
        TMenuItem *mnIrALinea;
        TMenuItem *mnAT;
        TMenuItem *mnAC;
        TMenuItem *mnAyudaManual;
        TMenuItem *mnAyudaAcerca;
    void __fastcall FormCanResize(TObject *Sender, int &NewWidth,
          int &NewHeight, bool &Resize);
    void __fastcall mnNuevoClick(TObject *Sender);
    void __fastcall mnGuardarClick(TObject *Sender);
    void __fastcall mnAbrirClick(TObject *Sender);
    void __fastcall mnGuardarComoClick(TObject *Sender);
    void __fastcall mnNoMantenerCambiosClick(TObject *Sender);
    void __fastcall mnMantenerCambiosClick(TObject *Sender);
    void __fastcall mnCortarClick(TObject *Sender);
    void __fastcall mnCopiarClick(TObject *Sender);
    void __fastcall mnPegarClick(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall mnBuscarClick(TObject *Sender);
    void __fastcall mnBuscarSiguienteClick(TObject *Sender);
    void __fastcall mnEjecutarEscenaClick(TObject *Sender);
    void __fastcall TextoClick(TObject *Sender);
    void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
    void __fastcall FormPaint(TObject *Sender);
        void __fastcall TextoKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall TextoMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall TextoKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall FormResize(TObject *Sender);
        void __fastcall TextoKeyPress(TObject *Sender, char &Key);
        void __fastcall mnIrALineaClick(TObject *Sender);
        void __fastcall mnEjecucionConsolaClick(TObject *Sender);
        void __fastcall TabControlChange(TObject *Sender);
        void __fastcall mnCerrarClick(TObject *Sender);
        void __fastcall FormShow(TObject *Sender);
        void __fastcall sbSetMarca1Click(TObject *Sender);
        void __fastcall sbSetMarca2Click(TObject *Sender);
        void __fastcall sbSetMarca3Click(TObject *Sender);
        void __fastcall sbSetMarca4Click(TObject *Sender);
        void __fastcall sbMarca1Click(TObject *Sender);
        void __fastcall sbMarca2Click(TObject *Sender);
        void __fastcall sbMarca3Click(TObject *Sender);
        void __fastcall sbMarca4Click(TObject *Sender);
        void __fastcall mnIraMarca1Click(TObject *Sender);
        void __fastcall mnIraMarca2Click(TObject *Sender);
        void __fastcall mnIraMarca3Click(TObject *Sender);
        void __fastcall mnIraMarca4Click(TObject *Sender);
        void __fastcall mnSetMarca1Click(TObject *Sender);
        void __fastcall mnSetMarca2Click(TObject *Sender);
        void __fastcall mnSetMarca3Click(TObject *Sender);
        void __fastcall mnSetMarca4Click(TObject *Sender);
        void __fastcall mnGuardarTodoClick(TObject *Sender);
        void __fastcall TextoMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
        void __fastcall TextoMouseWheel(TObject *Sender, TShiftState Shift,
          int WheelDelta, TPoint &MousePos, bool &Handled);
        void __fastcall FormDestroy(TObject *Sender);
        void __fastcall TimerACTimer(TObject *Sender);
        void __fastcall mnArchivoClick(TObject *Sender);
        void __fastcall mnDeshacerDrawItem(TObject *Sender,
          TCanvas *ACanvas, TRect &ARect, bool Selected);
        void __fastcall mnDeshacerClick(TObject *Sender);
        void __fastcall mnACClick(TObject *Sender);
        void __fastcall mnATClick(TObject *Sender);
        void __fastcall lbATKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall lbVRMLDblClick(TObject *Sender);
        void __fastcall lbVRMLKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall lbATDblClick(TObject *Sender);
        void __fastcall lbATExit(TObject *Sender);
        void __fastcall mnConfigurarClick(TObject *Sender);
        void __fastcall mnAyudaAcercaClick(TObject *Sender);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall mnAyudaManualClick(TObject *Sender);
private:	// User declarations
    //--------------------------------------------------- VARIABLES PRIVADAS ---
    // Las propiedades y mtodos de Texto no son sufientes para hacer algunas
    // cosas por ello hay que recurrir a las API de windows interceptando los
    // mensajes que se envan al control. Por ejemplo para saber cuando se hace
    // un scroll. As usamos esta variable que guarda la direccin de la funcin
    // que procesaba originalmente el mensaje.
    TWndMethod FuncionOriginal;

    // Es un array que contiene punteros a objetos de la clase DatosFichero
    // y se utilizan para editar varios ficheros a la vez:
    DatosFichero **DF;

    // Es el nmero de ficheros que se estn editando.
    int NumFicheros;
    // Contiene el ndice del array DF asociado al fichero que se est editando.
    int IndexDF;

    // Al cerrar la ventana es necesario distinguir el caso en el que el usuario
    // ha elegido si desea mantener o no los cambios, del caso en el que el usuario
    // cierra la ventana. En el segundo caso se preguntar si se desean conservar
    // los cambios.
    bool NoPreguntar;

    // Con esta variable OnKeyDown comunica a OnKeyUp cuando debe anular la
    // prxima pulsacin que le llegue.
    bool AnularPulsacion;

    // Se usa para pasar informacin de OnKeyDown a OnKeyUp para gestionar
    // el formateo de pantalla durante la seleccin del texto.
    int PrimeraLinea;

    // Cuando se modifica el texto hay que actualizar las marcas. Esto requiere
    // una comunicacin entre eventos que se hace con estas variables:
    int  TamInicial_Marcas;
    int  PosInicial_Marcas;
    bool ProcesoIniciado_Marcas;

    // Es la longitud de la cadena que el usuario ha teclado para activar el
    // autotexto.
    int LongCadAC;

    // Cuando un fichero tiene ms de FORMATO_MAX_NUM_LINS lineas no se puede
    // usar la opcin de autocompletar. La primera vez que ocurre esto se avisa
    // al usuario, esta variable ser tru si ya se ha avisado.
    bool SeHaAvisadoNoAC;

    // Esta variable se usa para que la funcin Inicia comunique al evento onPaint
    // que la primera vez que se ejecute cargue la lnea CargarLinea. Si vale -1
    // quiere decir que no se debe hacer nada.
    int CargarLinea;

    // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
    // del texto, lo evitamos con  FormateoAnulado en OnMouseDown y OnMouseUp y
    // tambin al pulsar y soltar Shift:
    bool FormateoAnulado;

    // Contiene el tipo de escena (X3D/H3D) -> Se usa para ejecutar el fichero.
    TipoEscena TipoEscenaActual;

    // Contiene la ltima cadena que se ha buscado.
    AnsiString TextoBuscado;

    // Contiene la ltima eleccin que se hizo al buscar una cadena sobre si
    // se deba o no distinguir maysculas y minsculas.
    bool DistinguirMayusculas;

    // Debido a que se usa ShowModal para mostrar la ventana hay que usar el
    // evento OnPaint para que desde Inicio se pueda desplazar el cursor a la
    // posicin adecuada (desplazando el Texto correctamente). Estas dos variables
    // controlan este procesado.
    bool DesdeInicio;
    TPoint PosicionCursor;

    //--------------------------------------------------- FUNCIONES PRIVADAS ---
    // Salva el fichero asociado a index. Si an no se le ha dado nombre
    // se llama a SalvarFicheroComo(). Devuelve falso si no se ha podido guardar
    // el fichero. Si los datos no han sido modificados no se salvar el fichero.
    // Si se pasa index a -1, lo anterior se aplicar a todos los ficheros.
    // Devuelve false si el usuario cancela la operacin.
    bool __fastcall SalvarFichero(int index=-1);

    // Prepara las variables y controles para la insercin de autotexto VRML
    // teniendo en cuenta el tipo de escena (TipoEscenaActual).
    void __fastcall CargaAutoCompletar();

    // Muestra un cuadro de dilogo para que el ususario de un nombre al fichero
    // asociado a index.
    // Devuelve falso si el usuario no elige un nombre.
    bool __fastcall SalvarFicheroComo(int index);

    // Actualiza el aspecto de la ventana rellenando Caption y la Barra de estado.
    void __fastcall Actualiza();

    // Devuelve true si la extensin de file coincide con EXTENSION_X3D de Main.h:
    bool __fastcall EsVRML(AnsiString file);

    // Las propiedades y mtodos de Texto no son sufientes para hacer algunas
    // cosas por ello hay que recurrir a las API de windows interceptando los
    // mensajes que se envan al control. Por ejemplo para saber cuando se hace
    // un scroll. As usamos esta funcin para interceptar estos mensajes y
    // hacer el procesamiento adecuado.
    void __fastcall CapturaMensaje(Messages::TMessage &Message);

    // Al llamar a esta funcin indicamos que el contenido del texto ha sido
    // modificado. Se actualizan los indicadores.
    void __fastcall HaCambiado();

    // Devuelve el ndice de DF asociado al fichero principal (el de frmEscena).
    // Si no se encuentra el fichero principal devuelve -1.
    int __fastcall GetIndexFicheroPrincipal();

    // Las posiciones de las marcas hay que actualizarlas cuando se modifica el
    // texto. Para ello hay que llamar a estas dos funciones:
    // ActualizaMarcasPaso1 se llamar antes de la mdificacin y
    // ActualizaMarcasPaso2 despus.
    void __fastcall ActualizaMarcasPaso1();
    void __fastcall ActualizaMarcasPaso2();

    // Salva el contenido de Texto en DF.
    // Tambin cambia el puntero del ratn a un reloj de arena mientras se
    // asignan los datos.
    void __fastcall SalvaDF();

    // Carga en Texto los datos asociados a DF[index] y actualiza IndexDF.
    // Tambin cambia el puntero del ratn a un reloj de arena mientras se
    // asignan los datos.
    // Tambin gestiona los tabs de TabControl.
    // Si se pasa cargarTexto a false no se asignar el contenido de Texto->Text
    // y solo se gestionar TabControl.
    void __fastcall CargaDF(int index,bool cargarTexto);

    // Libera la memoria que ocupa DF[index] creando un nuevo array DF con una
    // posicin menos. Si se pasa index a -1 se liberar toda la memoria ocupada
    // por DF y todos los objetos a los que apunte (DF ser NULL).
    void __fastcall BorraDF(int index=-1);

    // Crea un objeto en memoria de tipo DatosFichero y aade un elemento al
    // final de DF que apuntar a este nuevo objeto DatosFichero que se incializa
    // con los parmetros pasados.
    // Si DF es NULL se crear el array con una posicin.
    // Tambin se aade un Tab a TabControl.
    // IndexDF no cambiar.
    // Devuelve el ndice de DF asociado al elemento que se acaba de crear.
    int __fastcall CreaDF(AnsiString fichero,bool ficheroModificado,bool datosModificados);


    // Borra todos los elementos de lb incluyendo los punteros a TObject de
    // lb->Items que se consideran punteros a AnsiString.
    void __fastcall LiberaMemAutoCompletar(TListBox *lb);

    // Ajusta las dos cadenas pasadas al ancho de los controles TListBox usandos
    // para autocompletar de este modo: "cadmsg"
    AnsiString __fastcall PreparaElemLista(AnsiString cad,AnsiString msg);

    // Aade un elementos a la lista lb. La cadena que se aade en lb->StriNgs,
    // ser <nombreIzq>....<nombreDer>. Si esta cadena ya est en la lista no
    // se aadir.
    // Adems esta funcion reserva memoria para dato, de modo que lb->Objects
    // contendr punteros a AnsiString que se crean y asignan (a dato) en esta funcin.
    void __fastcall AnadeListBox(TListBox *lb,AnsiString nombreIzq,AnsiString nombreDer,AnsiString dato);


public:		// User declarations
    //--------------------------------------------------- VARIABLES PUBLICAS ---
    // Verdadero si la ventana del editor est abierta, es decir si se ha
    // llamado a la funcin Ininicia y an no ha acabado su ejecucin.
    bool Editando;

    //--------------------------------------------------- FUNCIONES PUBLICAS ---
    // Al llamar a esta funcin se comprueba si el fichero ha sido modificado en
    // caso negativo se devuelve true (continuar) en caso positivo se pregunta
    // al usuario si desea salvar los cambios. Tanto si guarda los
    // cambios como si no desea hacerlo se devuelve true (continuar) y si pulsa
    // cancelar se devolver false.
    // Lo anterior se aplica al fichero asociado a index.
    // Si index es -1 (por defecto) se aplicar a todos los ficheros abiertos.
    // Y se devolver false solo si el usuario pulsa cancelar en alguna de las
    // pregutas.
    bool __fastcall PreguntarSalvar(int index = -1);


    // Esta funcin muestra el editor con ShowModal. El contenido de datos
    // copiar al texto editado. Fichero indica la ruta del fichero actual
    // modificado es true si no se ha salvado la ltima modificacin. Y tipo
    // escena se usar para ejecutar la escena (con H3DLoader o Explorer).
    // Si el usuario decide volver conservando los cambios se devuelve true y
    // se asigna datos.
    // Tambin se pasa la posicin del cursor TPoint(col,fila). Pero si en lugar
    // de la posicin del cursor se pasa un nmero de lnea en cargarLinea
    // distinto de -1, se Seleccionarn todas la lneas cargarLinea de todos los
    // ficheros abiertos.
    bool __fastcall Inicia(TStrings *datos,AnsiString &fichero,
                           bool &modificado,TipoEscena tipoescena,
                           TPoint &posCursor,int cargarLinea=-1);

    // Ajusta el nombre del fichero (ruta completa) al control lb de modo que
    // si la ruta no cabe completamente la recorta de este modo:
    // C:\...\Nombre del Fichero.txt
    void __fastcall AjustarNombreFichero(AnsiString cad,TLabel *lb);

    // Inserta cad en la posicin actual. Si cad contiene varias lineas las
    // inserta teniendo en cuenta la justificacin.
    // longCad indica el nmero de caracteres que se borrarn antes de insertar
    // la lnea, como ejemplo InsertatTexto equivaldra a pulsar la tecla borrar
    // lonCad veces (en la misma lnea) antes de insertar cad.
    void __fastcall InsertaTexto(AnsiString cad,int longCad);

    // Asigna las propiedades Top y Left de PnlInsercion segn la posicin actual
    // del cursor:
    void __fastcall ColocaPnlInsercion();

    // Selecciona el texto asociado a line del fichero actual. Si todo es true
    // se har con todos los ficheros abirtos.
    // La primera linea es line 1.
    void __fastcall SeleccionarLinea(int line,bool todos);

    // Devuelve true si alguno de los ficheros editados no se ha salvado a disco.
    bool __fastcall HayFicherosSinSalvar();

    // Devuelve true si c es '_' o una letra (mayuscula o minuscula). 
    bool __fastcall EsLetra(char c);

    // Constructor y Destructor:
    __fastcall TfrmEditor(TComponent* Owner);
    __fastcall ~TfrmEditor();
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmEditor *frmEditor;
//---------------------------------------------------------------------------
#endif

