//
//    EDITOR DE TEXTO     
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Editor de texto con las opciones bsicas y algunas utilidades
                para ficheros X3D (como ejecucin y verificacin de cdigo). */
//---------------------------------------------------------------------------


#include <vcl.h>
#pragma hdrstop

#include <vcl\Clipbrd.hpp>

#include "frmEditor_.h"
#include "frmUtilidad_.h"
#include "frmEscena_.h"
#include "frmConfiguracion_.h"
#include "Utilidad_.h"
#include "GestorVRML_.h"
#include "RichEditVRML_.h"
#include "frmSobre_.h"

// Especifican las dimensiones mnimas de la ventana.
#define MIN_WIDTH 555
#define MIN_HEIGHT 332

// Es el nmero de elementos que contiene una pgina de las listas de autocompletar
#define TAM_PAG_LISTA_AC 7

// Es el nmero mximo de caracteres que se pueden usar en los controles
// TListBox para mostrar los mensajes de autocompletar.
#define NUM_CARACTERES_AUTOCOMPLETAR 38

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmEditor *frmEditor;

//---------------------------------------------------------------------------
DatosFichero::DatosFichero(AnsiString f,bool fm,bool dm){
   ficheroModificado=fm;
   datosModificados=dm;
   fichero=f;
   selStart=0;
   selLength=0;
   primeraLinea=0;
   esFicheroPrincipal=false;
   marca1=0;
   marca2=0;
   marca3=0;
   marca4=0;
}
//---------------------------------------------------------------------------
DatosFichero::DatosFichero()
{
   ficheroModificado = true;
   datosModificados  = false;
   fichero="";
   selStart=0;
   selLength=0;
   primeraLinea=0;
   esFicheroPrincipal=false;
   marca1=0;
   marca2=0;
   marca3=0;
   marca4=0;
}
//---------------------------------------------------------------------------
__fastcall TfrmEditor::TfrmEditor(TComponent* Owner)
    : TForm(Owner)
{
   NoPreguntar=false;
   TextoBuscado = "";
   DistinguirMayusculas=true;
   DesdeInicio=false;
   PosicionCursor=TPoint(0,0);
   AnularPulsacion=false;
   PrimeraLinea=0;
   SeHaAvisadoNoAC=false;

   TamInicial_Marcas=0;
   PosInicial_Marcas=0;
   ProcesoIniciado_Marcas=false;
   LongCadAC=0;
   CargarLinea=0;

   IndexDF=0;
   NumFicheros=0;
   DF=NULL;
   FormateoAnulado=false;
}
//---------------------------------------------------------------------------
__fastcall TfrmEditor::~TfrmEditor(){
   if(DF != NULL)
      BorraDF();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::FormDestroy(TObject *Sender)
{
   // Liberamos memoria:
   LiberaMemAutoCompletar(lbVRML);
   frmConfiguracion->DescargaAT(lbAT);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::FormCreate(TObject *Sender)
{
   // Asignamos algunos ShorCuts que no se pueden elegir en el object Inspector.
   mnMantenerCambios->ShortCut   = ShortCut(Word(13), TShiftState() << ssCtrl);

   mnIraMarca1->ShortCut   = ShortCut(Word('1'), TShiftState() << ssAlt);
   mnIraMarca2->ShortCut   = ShortCut(Word('2'), TShiftState() << ssAlt);
   mnIraMarca3->ShortCut   = ShortCut(Word('3'), TShiftState() << ssAlt);
   mnIraMarca4->ShortCut   = ShortCut(Word('4'), TShiftState() << ssAlt);

   mnSetMarca1->ShortCut   = ShortCut(Word('1'), TShiftState() << ssCtrl);
   mnSetMarca2->ShortCut   = ShortCut(Word('2'), TShiftState() << ssCtrl);
   mnSetMarca3->ShortCut   = ShortCut(Word('3'), TShiftState() << ssCtrl);
   mnSetMarca4->ShortCut   = ShortCut(Word('4'), TShiftState() << ssCtrl);

   mnIrALinea ->ShortCut   = ShortCut(Word('G'), TShiftState() << ssAlt);

   // Las propiedades y mtodos de Texto no son sufientes para hacer algunas
   // cosas por ello hay que recurrir a las API de windows interceptando los
   // mensajes que se envan al control. Por ejemplo para saber cuando se hace
   // un scroll. As se interceptan estos mensajes.
   FuncionOriginal=Texto->WindowProc;
   Texto->WindowProc=CapturaMensaje;

   mnAyudaAcerca->Caption = (AnsiString)"&About " + (AnsiString)NOMBRE_DEL_PROGRAMA;

   // Inicializamos el tick de mnAC:
   mnAC->Checked = CONF.USAR_AUTO_COMPLETAR;

   // La siguiente lnea permite que se pueda editar el texto cuando se cargan
   // datos desde un Stream a Texto. Sin ella, al cargar un bloque de ms de
   // 64K el texto no se prodra ampliar. Esta lnea se ha obtenido de unas
   // FAQs sobre componentes TRichEdit, al parecer se trata de un fallo
   // de Borland. Ya que esto no pasa con otros componentes similares como
   // TMemo y tp ocurre si en lugar de cargar los datos desde un Stream los
   // cargamos desde un fichero.
   SendMessage(Texto->Handle, EM_EXLIMITTEXT, 0, 0x7fffffff);

   // Preparamos la apariencia de algunos controles:
   TabControl->Tabs->Clear();
   pnlInsercion->BorderWidth=1;

   lbVRML->Top  = 1;
   lbVRML->Left = 1;
   lbVRML->Height = pnlInsercion->ClientHeight-2;
   lbVRML->Width  = pnlInsercion->ClientWidth-2;

   lbAT->Top  = 1;
   lbAT->Left = 1;
   lbAT->Height = pnlInsercion->ClientHeight-2;
   lbAT->Width  = pnlInsercion->ClientWidth-2; 
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEditor::EsVRML(AnsiString file){

   AnsiString a = ExtractFileExt(file);
   AnsiString b = EXTENSION_X3D;

   return (a.UpperCase() == b.UpperCase());
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEditor::Inicia(TStrings *datos,AnsiString &fichero,
                                   bool &modificado,TipoEscena tipoescena,
                                   TPoint &posCursor,int cargarLinea)
{
    // Creamos un nuevo tab y lo cargamos:
    int index = CreaDF(fichero,modificado,false);
    CargaDF(index,false);
    IndexDF=index;
    DF[IndexDF]->esFicheroPrincipal = true;

    TipoEscenaActual=tipoescena;
    NoPreguntar=false;

    // Preparamos la insercin de AutoCompletar:
    CargaAutoCompletar();

    pnlInsercion->Visible = false;
    
    // Cargamos los datos y actualizamos la apariencia del texto: Color de
    // fondo, tipo de letra, tamao de la fuente etc.
    // tipo 3 indica que se dar siempre el formato sencillo (pe.para scripts)
    int tipo = EsVRML(fichero) ? 1 : 3;
    ReVRML.Inicia(this,Texto,tipo,&(datos->Text));

    Caption = Main->Caption;

    // Debido a que se usa ShowModal para mostrar la ventana hay que usar el
    // evento OnPaint para que desde Inicio se pueda desplazarar el cursor a la
    // posicin adecuada (desplazando el Texto correctamente). As:
    DesdeInicio=true;
    PosicionCursor=posCursor;
    CargarLinea=cargarLinea;

    Actualiza();

    Editando = true;

    int p=ShowModal();

    Editando = false;    

    SalvaDF();

    // Ocultamos el panel de AC:
    pnlInsercion->Visible = false;

    int indexP = GetIndexFicheroPrincipal();

    if( (indexP == -1) || (NumFicheros == 0) || (DF[indexP] == NULL) )
       return false;

    // Vamos a intentar borrar todos los fichero de prueba que se hayan usado:
    for(int c=0; c < NumFicheros; c++){
       if( (DF[c] != NULL) && EsVRML(DF[c]->fichero) )
          frmEscena->BorrarFicheroPrueba(DF[c]->fichero);
    }

    if(p == mrOk){
        // En este caso se ha elegido volver manteniendo los cambios.
        // En ficheros grandes, hay que esperar un poco al cargar los datos
        // para evitar que las ventanas no se muestren correctamente usamos Repaint();
        Main->Repaint();

        Screen->Cursor=PUNT_RATON_ESPERA;
        datos->Text = DF[indexP]->datos;
        Screen->Cursor=PUNT_RATON_NORMAL;

        modificado=DF[indexP]->ficheroModificado;
        fichero=DF[indexP]->fichero;
        // Conservaremos la posicin del cursor si el fichero actual es el principal.
        if(IndexDF == indexP){
           Texto->SelLength=0;
           posCursor=Texto->CaretPos;
        }
    }
    // No necesitaremos TimerAC -> Lo desactivamos:
    TimerAC->Enabled=false;

    // Liberamos la memoria que ocupa el fichero principal y el autocompletar:
    if(indexP != -1)
       BorraDF(indexP);
    LiberaMemAutoCompletar(lbVRML);
    frmConfiguracion->DescargaAT(lbAT);

    return (p == mrOk);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnNuevoClick(TObject *Sender)
{
   if( (DF==NULL) || (NumFicheros==0) || (IndexDF<0) || (IndexDF>=NumFicheros) || (DF[IndexDF]==NULL) )
      return;

   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;      

   // Vamos a intentar borrar el fichero de prueba que se usa en las ejecuciones.
   frmEscena->BorrarFicheroPrueba(DF[IndexDF]->fichero);

   // Salvamos los datos actuales de Texto y creamos un nuevo elemento en DF:
   SalvaDF();
   Texto->Lines->Clear();

   // El fichero se ha cargado correctamente -> Creamos un nuevo elemento en DF:
   AnsiString nombre = (AnsiString)FICHERO_POR_DEFECTO + ".x3d";
   CargaDF( CreaDF(nombre,false,true),true);

   Actualiza();
}

//---------------------------------------------------------------------------
bool __fastcall TfrmEditor::HayFicherosSinSalvar(){

   if( (DF==NULL) || (NumFicheros==0) )
      return false;  // Para que continue el proceso.

   for(int c=0; c < NumFicheros; c++){
      if(DF[c]->ficheroModificado)
         return true;
   }
   return false;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEditor::PreguntarSalvar(int index){

   if( (DF==NULL) || (NumFicheros==0) || (index<-1) || (index>=NumFicheros) || (DF[index]==NULL) )
      return true;  // Para que continue el proceso.

   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if(-1 == index){
      // Tenemos que procesar todos los ficheros abiertos:
      for(int c=0; c < NumFicheros; c++){
         // Hacemos llamadas recursivas. Devolvemos false si el usuario pulsa
         // cancelar al preguntarle si desea salvar alguno de los ficheros.
         if(!PreguntarSalvar(c))
            return false;
      }
      return true;
   }else{
      if(!DF[index]->ficheroModificado)
         return true;
      TModalResult mr = frmUtilidad->Pregunta("Save changes to " + ExtractFileName(DF[index]->fichero) + "?");
      if(mr == mrYes){
          return SalvarFichero(index);
      }else if(mr == mrCancel){
          // Devolvemos false para no continuar con el proceso.
          return false;
      }
      // Devolvemos true para que continue el proceso.
      return true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnAbrirClick(TObject *Sender)
{
   if( (DF==NULL) || (NumFicheros==0) || (IndexDF<0) || (IndexDF>=NumFicheros) || (DF[IndexDF]==NULL) )
      return;

   // Vamos a cargar un nuevo fichero VRML.
   Main->dlgAbrir->DefaultExt=EXTENSION_X3D;
   Main->dlgAbrir->FilterIndex = 1;   
   Main->dlgAbrir->FileName= (AnsiString)"*" + EXTENSION_X3D;
   Main->dlgAbrir->InitialDir=CONF.LAST_CARPETA_USADA;
   if( (!Main->dlgAbrir->Execute()) || !Utilidad.Existe(Main->dlgAbrir->FileName,true) )
      return;

   // Si el fichero que abrimos es grande hay que hacer el repaint del control
   // cuando desaparece el cuadro de dilogo.
   this->Repaint();

   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   CONF.LAST_CARPETA_USADA= GetCurrentDir();
   CONF.LosDatosHanCambiado();

   // Antes de cargar la escena vamos a borrar el fichero de prueba (si existe).
   frmEscena->BorrarFicheroPrueba(DF[IndexDF]->fichero);

   // Cargamos la nueva escena: Tenemos que salvar el contenido de Texto:
   SalvaDF();

   // Primero cargamos el fichero y luego lo formateamos -> evitamos que se
   // Dibuje texto.
   ReVRML.BloqueaRepaint(Texto);

   if(!Utilidad.LoadFromFile(Texto->Lines,Main->dlgAbrir->FileName)){
      // Recuperamos el texto anterior.
      Texto->Text = DF[IndexDF]->datos;
      return;
   }

   // El fichero se ha cargado correctamente -> Creamos un nuevo elemento en DF:
   int index = CreaDF(Main->dlgAbrir->FileName,false,false);

   CargaDF(index,false);
   int tipo = EsVRML(DF[index]->fichero) ? 1 : 3;
   ReVRML.Inicia(this,Texto,tipo);

   ReVRML.PermiteRepaint(Texto);

   Actualiza();
}
//------------------------------------------------------------------------------
void __fastcall TfrmEditor::mnGuardarClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;      

   SalvarFichero(IndexDF);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnGuardarComoClick(TObject *Sender)
{
   SalvaDF();

   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;      

   SalvarFicheroComo(IndexDF);

   // Por si ha cambiado la extensin:
   CargaDF(TabControl->TabIndex,true);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnNoMantenerCambiosClick(TObject *Sender){
   NoPreguntar=true;
   Close();  // Esto cierra la ventana con mrCancel
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnMantenerCambiosClick(TObject *Sender){
   NoPreguntar=true;
   ModalResult=mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnCortarClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if(Texto->SelLength <= 0)
      return;
   // Hay que actualizar las marcas.
   ActualizaMarcasPaso1();
   Texto->CutToClipboard();
   ActualizaMarcasPaso2();
   HaCambiado();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnCopiarClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   Texto->CopyToClipboard();
   Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnPegarClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   int lineasIni = ReVRML.LinesCount(Texto);

   if(!Clipboard()->HasFormat(CF_TEXT))
      return;
   // Ahora hay que pegar el contenido del portapapeles en la lnea actual:
   // No lo pegamos directamente con Texto->PasteFromClipboard() porque podra
   // ser texto con formato.

   // Otra cuestin es la actualizacin de las marcas:
   ActualizaMarcasPaso1();

   // Y otra cuestin ms es que siempre que pegemos el texto se debe dar
   // formato. El formato se dar automticamante gracias a que windows produce
   // un mensaje WM_PAINT cuando el texto cambia pero es necesario que el
   // formateo no est anulado FormateoAnulado as que lo reestablecemos:
   FormateoAnulado=false;

   Clipboard()->SetTextBuf(Clipboard()->AsText.c_str());
   Texto->PasteFromClipboard();

   ActualizaMarcasPaso2();

   // Que ocurrira si sobrepasamos el Max Num de lneas editadas? Tendramos
   // Parte del texto con formato y parte sin formato -> Controlamos esto:
   if( (FORMATO_MAX_NUM_LINS > lineasIni) && (DF != NULL) && (DF[IndexDF] != NULL) &&
       (FORMATO_MAX_NUM_LINS < ReVRML.LinesCount(Texto)) ){

        int tipo = EsVRML(DF[IndexDF]->fichero) ? 1 : 3;
        ReVRML.Inicia(this,Texto,tipo);
   }
   
   /* Lo siguiente sera otro modo de hacerlo. Es un poco ms lento, pero
   la diferencia en tiempo no merece la pena adems hay que controlar la
   posicin del cursor y la seleccin.

   if(!Clipboard()->HasFormat(CF_TEXT))
      return;
   // Ahora hay que pegar el contenido del portapapeles en la lnea actual:
   // No lo pegamos directamente con Texto->PasteFromClipboard() porque
   // podra ser texto con formato.

   // Guardamos la seleccin actual.
   int selPos = Texto->SelStart;
   int selLen = Texto->SelLength;
   Texto->SelLength = 0;

   // Con este mensaje reemplazamos la seleccin actual (ninguna) con el contenido
   // del portapapeles.
   SendMessage(Texto->Handle, EM_REPLACESEL, 0,(LPARAM)Clipboard()->AsText.c_str());

   // Reponemos la seleccin anterior.
   Texto->SelStart=selPos;
   Texto->SelLength=selLen + Clipboard()->AsText.Length();

   */

   if(Clipboard()->AsText != "")
      HaCambiado();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnBuscarClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;      

   if( frmUtilidad->IniciaBusquedaTexto(TextoBuscado,DistinguirMayusculas) ){
      mnBuscarSiguienteClick(NULL); // Buscamos la cadena TextoBuscado:
      Actualiza();
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnBuscarSiguienteClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;      

   if(TextoBuscado == "")
       return;

   // Obtenemos la primera lnea visible antes de la bsqueda.
   int primeraLinVis = ReVRML.GetPrimeraLineaVisible(Texto);

   int tmp=Texto->SelLength;
   // Con esto garantizamos que Texto->SelStart es la posicin del cursor.
   Texto->SelLength=0;
   // Con esto avanzamos el cursor para buscar la siguiente ocurrencia.
   //   (sin encontrar la misma dos veces)
   Texto->SelStart+=tmp;

   int pos;
   // Asignamos longit al tamao del texto editado (equivale a Texto->Text.Length()).
   int longit = SendMessage(Texto->Handle, WM_GETTEXTLENGTH, 0, 0);
   if(DistinguirMayusculas)
      pos = Texto->FindText(TextoBuscado,Texto->SelStart, longit, TSearchTypes()<< stMatchCase);
   else
      pos = Texto->FindText(TextoBuscado,Texto->SelStart, longit, TSearchTypes());

   if(pos != -1){

      Texto->SelStart=pos;
      // Con la siguiente lnea hacemos un scroll al cursor si es necesario.
      SendMessage(Texto->Handle,EM_SCROLLCARET, 0, 0);

      // Ahora volvemos obtener la primera lnea visible, si ha cambiado
      // al hacer el scroll anterior es posible que aparezca el problema siguiente:
      // A veces al encontrar una palabra y hacer el scroll anterior, solo
      // se ve parte del texto seleccionado y hay que subir la lnea, lo
      // haremos siempre que no sea la primer lnea visible. Vamos a evitarlo
      // haciendo el scroll de 4 lneas en este caso EM_SCROLL
      int primeraLinVis2 = ReVRML.GetPrimeraLineaVisible(Texto);
      if( primeraLinVis2 != primeraLinVis)
          Texto->Perform(EM_LINESCROLL,0,1);

      Texto->SelLength=TextoBuscado.Length();

   }else{
      Utilidad.MsgInfo("The searched string was not found");
   }

   ReVRML.PermiteRepaint(Texto);
   Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnEjecutarEscenaClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;      

   if( (DF==NULL) || (NumFicheros==0) || (IndexDF<0) || (IndexDF>=NumFicheros) || (DF[IndexDF]==NULL) )
      return;

   // Debido a que podemos tener varios ficheros abiertos (tb scripts) no es
   // sencillo decicir qu fichero se debe ejecutar. La opcin que parece
   // ms adecuada es ejecutar el fichero VRML actual y si el fichero actual no
   // es VRML (p.e. un scrip) ejecutaremos el fichero principal (de frmEscena)
   AnsiString f;
   int index;

   if(EsVRML(DF[IndexDF]->fichero) )
      index = IndexDF;
   else{
      index = GetIndexFicheroPrincipal();
      if(index == -1)
         // No se ha encontrado el fichero principal -> El usuario lo ha cerrado.
         return;
   }

   f = DF[index]->fichero;

   bool usarFichTmp = false;
   if( (f != "") && (f[1] == '?') ){
      // En este caso an no se ha dado ningn nombre a la escena.
      // Vamos a hacer que se cree el fichero de prueba en la carpeta del programa
      f = Main->CARPETA_PROGRAMA + "\\" + ExtractFileName( f );
      usarFichTmp = true;
   }

   // Solo escribiremos el fichero de prueba cuando la escena haya cambiado o
   // cuando no exista.
   if(usarFichTmp || DF[index]->ficheroModificado){
      // Para ejecutar el programa se usar un fichero que tendr el mismo nombre
      // que la escena original aadiendole CONF.SUF_FICHERO_PRUEBA

      // Obtengo el nombre sin la extensin.
      f.Delete(f.AnsiPos(EXTENSION_X3D), ((AnsiString)EXTENSION_X3D).Length() );

      // Aadimos el sufijo y la extensin:
      f = f + CONF.SUF_FICHERO_PRUEBA + EXTENSION_X3D;

      Screen->Cursor=PUNT_RATON_ESPERA;

      // Escribimos la escena a disco.
      if(index == IndexDF)
         Utilidad.SaveToFile(Texto->Lines,f);
      else{
         Main->LineasAux->Text = DF[index]->datos;
         Utilidad.SaveToFile(Main->LineasAux,f);
      }

      Screen->Cursor=PUNT_RATON_NORMAL;
   }

   // Solo falta ejecutar la escena:
   frmEscena->EjecutarFichero(f,0,TipoEscenaActual);
}
//------------------------------------------------------------------------------
void __fastcall TfrmEditor::TextoClick(TObject *Sender)
{
   Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::Actualiza(){

   if( (DF==NULL) || (NumFicheros==0) || (IndexDF<0) || (IndexDF>=NumFicheros) || (DF[IndexDF]==NULL) )
      return;

    if( (DF[IndexDF]->fichero != "") && (DF[IndexDF]->fichero[1] == '?') )
       lbNombreFichero->Caption = "(New)";
    else
       AjustarNombreFichero(DF[IndexDF]->fichero,lbNombreFichero);

    pnlTipoEscena->Caption    = (TipoEscenaActual == ESCENA_X3D) ? "X3D Scene" : "H3D Scene";

    pnlModificado->Caption    = DF[IndexDF]->ficheroModificado ?  "Modified" : "";
    pnlLineas->Caption = (AnsiString) "Lines: " + IntToStr(ReVRML.LinesCount(Texto));

    pnlFilaCol->Caption = (AnsiString) "Row: " + IntToStr(Texto->CaretPos.y+1) + " Col: " + IntToStr(Texto->CaretPos.x+1);

}
//------------------------------------------------------------------------------
void __fastcall TfrmEditor::FormClose(TObject *Sender,
      TCloseAction &Action)
{
   if( (DF==NULL) || (NumFicheros==0) || (IndexDF<0) || (IndexDF>=NumFicheros) || (DF[IndexDF]==NULL) )
      return;

   if( !NoPreguntar ){
      // Tenemos que ver si el fichero principal ha cambiado o no:
      int indexP = GetIndexFicheroPrincipal();

      if(indexP == -1)
         // No se ha encontrado el fichero principal -> Cerraremos la ventana.
         return;

      if(DF[indexP]->datosModificados){
         TModalResult mr = frmUtilidad->Pregunta("The file has changed. Do you wish to keep       \n\n the changes and return?   ");
         if(mr == mrYes){
             mnMantenerCambiosClick(NULL);
             return;
         }else if(mr == mrCancel)
             Action=caNone;
         // else en otro caso se ha pulsado NO -> Cerramos la ventana sin conservar cambios.
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::FormPaint(TObject *Sender)
{
   if(DesdeInicio){
     DesdeInicio=false;
     Texto->SelLength=0;
     // Distinguimos dos casos, la funcin frmEscena->Inicia se puede llamar pasando
     // la posicin del cursor o la lnea que se quiere editar as:
     if(CargarLinea == -1)
        ReVRML.SetCursorPos(Texto,PosicionCursor.y,PosicionCursor.x);
     else
        SeleccionarLinea(CargarLinea,true);
     Actualiza();
   }
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEditor::SalvarFichero(int index)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;      

   if( (DF==NULL) || (NumFicheros==0) || (index<-1) || (index>=NumFicheros) || (DF[index]==NULL) )
      return false;

   if(index != -1){
      // Si el fichero no ha sido modificado -> Volvemos:
      if( !DF[index]->datosModificados && !DF[index]->ficheroModificado )
         return true; 

      // Salvamos el fichero asociado a index:
      if( ((ExtractFileName( DF[index]->fichero.Trim()) ) == "") ||
          ( (DF[index]->fichero != "") && (DF[index]->fichero[1] == '?') ) ){
          return SalvarFicheroComo(index);
      }

      Screen->Cursor=PUNT_RATON_ESPERA;

      if(index == IndexDF)
         SalvaDF();
      Main->LineasAux->Text = DF[index]->datos;
      Utilidad.SaveToFile(Main->LineasAux,DF[index]->fichero);

      Screen->Cursor=PUNT_RATON_NORMAL;

      DF[index]->ficheroModificado=false;
      Actualiza();

      return true;
   }else{
      // En este caso vamos a salvar todos los ficheros:
      bool ok=true;
      for(int c=0; c < NumFicheros; c++){
         if(!SalvarFichero(c))
            ok = false;
      }
      return ok;
   }
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEditor::SalvarFicheroComo(int index){

   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if( (DF==NULL) || (NumFicheros==0) || (index<0) || (index>=NumFicheros) || (DF[index]==NULL) )
      return false;

   // Vamos a cargar un nuevo fichero VRML.
   Main->dlgSalvar->DefaultExt=EXTENSION_X3D;
   Main->dlgSalvar->FileName= ExtractFileName(DF[index]->fichero);
   Main->dlgSalvar->InitialDir=CONF.LAST_CARPETA_USADA;
   if(!Main->dlgSalvar->Execute())
      return false;

   // Si el fichero que guardamos es grande hay que hacer el repaint del control
   // cuando desaparece el cuadro de dilogo.
   this->Repaint();

   CONF.LAST_CARPETA_USADA= GetCurrentDir();
   CONF.LosDatosHanCambiado();

   AnsiString fichero=Main->dlgSalvar->FileName;
   if(FileExists(fichero)){
       if(mrYes != frmUtilidad->Pregunta("The file " + ExtractFileName(fichero) + " already exists. Overwrite?"))
          return false;
   }

   // Vamos a intentar borrar el fichero de prueba que se usa en las ejecuciones.
   frmEscena->BorrarFicheroPrueba(DF[index]->fichero);

   // Actualizamos las variables.
   DF[index]->fichero=Main->dlgSalvar->FileName;
   DF[index]->ficheroModificado=false;
   DF[index]->datosModificados=true;

   // Hay que actualizar el tab:
   if( TabControl->Tabs->Count > index)
      TabControl->Tabs->Strings[index] = ExtractFileName(DF[index]->fichero);

   Screen->Cursor=PUNT_RATON_ESPERA;

   // Escribimos la escena a disco.
   if(index == IndexDF)
      Utilidad.SaveToFile(Texto->Lines,DF[index]->fichero);
   else{
      Main->LineasAux->Text = DF[index]->datos;
      Utilidad.SaveToFile(Main->LineasAux,DF[index]->fichero);
   }

   Screen->Cursor=PUNT_RATON_NORMAL;

   Actualiza();
   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::TextoKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   // El timer solo debe activarse al soltar una tecla y siempre que se escriba
   // algo debe permanecer inactivo.
   TimerAC->Enabled = false;

   // Las posiciones de las marcas hay que actualizarlas cuando se modifica el
   // texto, usaremos ActualizaMarcasPaso1. Hay problemas con los cambios de
   // tabs as que los evitamos:
   ActualizaMarcasPaso1();

   // Dividiremos en dos casos el procesado que se hace en este evento segn
   // pnlInsercion sea o no visible:
   if(pnlInsercion->Visible){
      bool procesada = true;
      bool masDe0 = (lbVRML->Items->Count > 0);
      // Vamos a procesar las teclas: Arriba, abajo, inicio, fin, av.Pag. y re.pag.
      if(Key == VK_UP){           // --------- Arriba --------
         if( masDe0 && (lbVRML->ItemIndex > 0) )
            lbVRML->ItemIndex = lbVRML->ItemIndex-1;

      }else if(Key == VK_DOWN){   // --------- Abajo ---------
         if( masDe0 && (lbVRML->ItemIndex+1 < lbVRML->Items->Count) )
            lbVRML->ItemIndex = lbVRML->ItemIndex+1;

      }else if(Key == VK_PRIOR){  // --------- Re.Pag. -------
         if( masDe0 && (lbVRML->ItemIndex - TAM_PAG_LISTA_AC  >= 0 ) )
            lbVRML->ItemIndex = lbVRML->ItemIndex - TAM_PAG_LISTA_AC;
         else if( masDe0 && (lbVRML->ItemIndex != 0) )
            lbVRML->ItemIndex = 0;

      }else if(Key == VK_NEXT){   // --------- Av.Pag. -------
         if( masDe0 && (lbVRML->ItemIndex + TAM_PAG_LISTA_AC  < lbVRML->Items->Count) )
            lbVRML->ItemIndex = lbVRML->ItemIndex + TAM_PAG_LISTA_AC;
         else if( masDe0 && (lbVRML->ItemIndex != (lbVRML->Items->Count-1)) )
            lbVRML->ItemIndex = (lbVRML->Items->Count-1);

      }else if(Key == VK_HOME){   // --------- Inicio --------
         if(masDe0)
            lbVRML->ItemIndex = 0;

      }else if(Key == VK_END){    // --------- Fin -----------
         if(masDe0)
            lbVRML->ItemIndex = lbVRML->Items->Count-1;

      }else if(Key == VK_RETURN){  // --------- Intro ---------
         // En este caso hay que insertar el texto que contiene el elemento
         // de lbVRML seleccionado.
         lbVRMLDblClick(NULL);
         AnularPulsacion=true; // para no incluir un RC en OnKeyPress
      }else if((Key == VK_BACK) ){
         // Permitiremos que se borre un caracter.
         procesada = false;
      }else if( ((Key >= 'A') && (Key <= 'Z'))  ){ // --------- Letras ---------
         // No tenemos que hacer nada, esta opcin se gestiona en OnKeyUp

      }else if(VK_ESCAPE == Key){
         pnlInsercion->Visible=false;
         if(Texto->CanFocus())
            this->FocusControl(Texto);
      }else{
         // En este caso se ha pulsado una tecla que no permite seguir con la
         // insercin de autocompletar, as:
         pnlInsercion->Visible = false;
         procesada = false;
      }
      // Vemos si considera que ya se ha procesado la pulsacin.
      if(procesada){
         Key ='\0';
         return;
      }
   }

   if(VK_ESCAPE == Key){ //------------------------------------- ESCAPE ---------
      Close();

   }else if( (Key == 'L') && (Shift.Contains(ssCtrl)) ){//------ CNTRL + L ------
      // Repetimos la ultima bsqueda.
      mnBuscarSiguienteClick(NULL);

   }else if(Key == VK_SHIFT){ //------------------------------------- SHIFT ----
      // Cuando se pulsa SHIFT comienza la seleccin y tenemos que guardar la
      // primera linea visible para saber en OnKeyUp si hay que formatear la pantalla.
      PrimeraLinea = ReVRML.GetPrimeraLineaVisible(Texto);

      // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
      // del texto, lo evitamos con  FormateoAnulado al pulsar y al soltar Shift.
      FormateoAnulado=true;
                              //----------------------------- CAMBIO DE TAB ----
   }else if( (VK_TAB == Key) && Shift.Contains(ssCtrl) ){
      // Gestionamos los cambios de tabs:
      SalvaDF();
      if(Shift.Contains(ssShift))
         CargaDF( (IndexDF==0) ? NumFicheros-1 : IndexDF-1, true );
      else
         CargaDF( (IndexDF+1) % NumFicheros, true );
      // Para no introducir un tab en el texto.
      Key = '\0';
   }

   // Ahora vamos a gestionar las marcas. Implementaremos las opciones de teclado
   // de builder porque las del men ya se gestionan desde el men.
   static bool sePulsoCntrlK= false;
   static bool sePulsoCntrlQ= false;

   AnularPulsacion = true;

   if     ( sePulsoCntrlK && (Key == '1') )
      sbSetMarca1Click(NULL);
   else if( sePulsoCntrlK && (Key == '2') )
      sbSetMarca2Click(NULL);
   else if( sePulsoCntrlK && (Key == '3') )
      sbSetMarca3Click(NULL);
   else if( sePulsoCntrlK && (Key == '4') )
      sbSetMarca4Click(NULL);
   else if( sePulsoCntrlQ && (Key == '1') )
      sbMarca1Click(NULL);
   else if( sePulsoCntrlQ && (Key == '2') )
      sbMarca2Click(NULL);
   else if( sePulsoCntrlQ && (Key == '3') )
      sbMarca3Click(NULL);
   else if( sePulsoCntrlQ && (Key == '4') )
      sbMarca4Click(NULL);
   else
      AnularPulsacion = false;

   // Actualizamos los valores para la siguiente llamada:
   sePulsoCntrlK = (Shift.Contains(ssCtrl) && (Key =='K'));  // No influye 'k'
   sePulsoCntrlQ = (Shift.Contains(ssCtrl) && (Key =='Q'));  // No influye 'q'

   Actualiza();
   // Vamos a evitar algunos de los sonidos que se producen si se intenta
   // colocar el cursor en una posicin no vlida.
   if(  ( (Key == VK_UP)    && (Texto->CaretPos.y == 0)                   )   ||
        ( (Key == VK_DOWN)  && (Texto->CaretPos.y == ReVRML.LinesCount(Texto)) )   ||
        ( (Key == VK_LEFT)  && (Texto->CaretPos.x == 0) && (Texto->CaretPos.y == 0) ) )
         // ( (Key == VK_RIGHT) && (Texto->CaretPos.y == ReVRML.LinesCount(Texto)) ) )
         // Comento esta ltima lnea porque en ficheros grandes puede enlentecer un poco.
      Key=0;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::TextoMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   Actualiza();
   // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
   // del texto, lo evitamos con  FormateoAnulado en OnMouseDown y OnMouseUp:
   FormateoAnulado=true;

   // Ocultamos el panel de AC.
   pnlInsercion->Visible=false;

   // Cuando se selecciona un trozo de texto sin haber hecho scroll no es
   // necesario formatear la pantalla, as evitaremos un parpado, con esta
   // asignacin controlaremos este proceso en el evento OnMouseUp
   PrimeraLinea = ReVRML.GetPrimeraLineaVisible(Texto);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::TextoKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if( (pnlInsercion->Visible) && ( ( (Key >= 'A') && (Key <= 'Z') ) || (Key == VK_BACK) ) ){
      // En este caso tenemos que hacer que se intente seleccionar la nueva
      // palabra, llamamos al Timer:
      TimerACTimer(NULL);
   }

   // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
   // del texto, lo evitamos con  FormateoAnulado al pulsar y al soltar Shift.
   if(Key == VK_SHIFT){
      FormateoAnulado=false;
      // Si ha cambiado la primera lnea visible desde que se empez a
      // seleccionar el texto tendremos que formatear la pantalla:
      // int primL = ReVRML.GetPrimeraLineaVisible(Texto);
      // if( (primL != PrimeraLinea) && (DF != NULL) && (DF[IndexDF] != NULL) && (EsVRML(DF[IndexDF]->fichero)) )
      if((DF != NULL) && (DF[IndexDF] != NULL) && (EsVRML(DF[IndexDF]->fichero)) )
         ReVRML.FormateaPantalla(this,Texto);
   }

   // Hay algunos casos que no nos interesar procesar porque ya se procesan con
   // los ShortCuts del men:
   if( ((VK_INSERT == Key) &&  Shift.Contains(ssShift))  ||   // Insertar
       ((   'X'    == Key) &&  Shift.Contains(ssCtrl))   ||   // Cortar
       ((   'x'    == Key) &&  Shift.Contains(ssCtrl))   ||   // Cortar
       (VK_SHIFT == Key) || (VK_CONTROL == Key) || (VK_MENU == Key) )
      return;

   if(VK_DELETE == Key)
      HaCambiado();

   Actualiza();

   // Las posiciones de las marcas hay que actualizarlas cuando se modifica el
   // texto, usaremos ActualizaMarcasPaso.
   ActualizaMarcasPaso2();

   // El nico modo de saber en qu modo estamos Insercin/Sobrescritura es
   // controlar las pulsacin de Insert:
   if( (VK_INSERT == Key) &&  !Shift.Contains(ssCtrl)  &&
                              !Shift.Contains(ssShift) &&
                              !Shift.Contains(ssAlt)  )
      pnlInsert->Caption = (pnlInsert->Caption == "OVE") ? "INS" : "OVE";

}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::AjustarNombreFichero(AnsiString cad,TLabel *lb){

   if(lb == NULL)
      return;
   if(lb->Canvas->TextWidth(cad) < lb->Width ){
      lb->Caption=cad;
      return;
   }else{ // Tendremos que deshechar parte del texto-> Lo indicamos con 
      if(cad.Length() >= 4)
         cad.Insert("",4);
   }

   // 7 es 3+3+1  (de C:\    y uno ms para borrar la sig posic.)
   while( (lb->Canvas->TextWidth(cad) >= lb->Width ) && (cad.Length() > 7) ){
      // Tenemos que intentar quitar caracteres del principio de la cadena.
      cad=cad.Delete(7,1);   // pq sabemos que length es 4 o ms.
   }
   lb->Caption=cad;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::FormResize(TObject *Sender)
{
   Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::FormCanResize(TObject *Sender, int &NewWidth,
      int &NewHeight, bool &Resize)
{
   Resize = true;
   NewHeight = (NewHeight >= MIN_HEIGHT) ? NewHeight : MIN_HEIGHT;
   NewWidth  = (NewWidth  >= MIN_WIDTH)  ? NewWidth  : MIN_WIDTH;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::HaCambiado(){

   if( (DF==NULL) || (NumFicheros==0) || (IndexDF<0) || (IndexDF>=NumFicheros) || (DF[IndexDF]==NULL) )
      return;

   DF[IndexDF]->ficheroModificado=true;
   DF[IndexDF]->datosModificados=true;
   Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::TextoKeyPress(TObject *Sender, char &Key)
{
   // Es posible que haya que anular la pulsacin por el procesado hecho en
   // OnKeyDown, as:
   if(AnularPulsacion)
      Key = '\0';
   else
      HaCambiado();

   // Cuando se est escribiendo un nombre debemos activar el temporizador que
   // mostrar la lista de autocompletar, y cuando la lista se est mostrando, no
   // hace falta activar el temporizador.
   if( CONF.USAR_AUTO_COMPLETAR && !pnlInsercion->Visible && GVRML.CaracterIDValido(Key) &&
       (DF!=NULL) && (NumFicheros!=0) && (DF[IndexDF]!=NULL) && EsVRML(DF[IndexDF]->fichero) ){

      if(CONF.RETARDO_AUTO_COMPLETAR > 0)
         TimerAC->Interval = CONF.RETARDO_AUTO_COMPLETAR;
      TimerAC->Enabled=false;  // Para resetear la cuenta.
      TimerAC->Enabled=true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::CapturaMensaje(Messages::TMessage &Message){

   // Para evitar formatear el cdigo ms veces de las necesarias se usa
   // esta variable que indica si se est formateando el cdigo VRML.
   static bool RepresentandoPantalla=false;

   //   if( (Message.Msg == WM_VSCROLL) || (Message.Msg == WM_MOUSEWHEEL) )
   //      ReVRML.FormateaPantalla(this,Texto);
   // Hay otra opcin mejor que usar WM_VSCROLL y WM_MOUSEWHEEL pq nos resuelve
   // tb el problema de las teclas, incluso el de pegar texto y es capturar este
   // otro mensaje que se envia cada vez que hay que dibujar el control.
   bool representar = (Message.Msg == WM_PAINT) &&
                      !RepresentandoPantalla;
   if( representar && (DF != NULL) && EsVRML(DF[IndexDF]->fichero) && !FormateoAnulado ){
      RepresentandoPantalla=true;
      ReVRML.FormateaPantalla(this,Texto);
      RepresentandoPantalla=false;
   }
   FuncionOriginal(Message);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnConfigurarClick(TObject *Sender)
{
   if( (DF==NULL) || (NumFicheros==0) || (IndexDF<0) || (IndexDF>=NumFicheros) || (DF[IndexDF]==NULL) )
      return;

   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if(frmConfiguracion->Inicia(0)){
      // Formateamos el texto en pantalla.
      // tipo 3 indica que se dar siempre el formato sencillo (pe.para scripts)
      int tipo = EsVRML(DF[IndexDF]->fichero) ? 1 : 3;

      // Actualizamos la apariencia de los controles RichEdit.
      ReVRML.Inicia(this,Texto,tipo);
      ReVRML.Inicia(frmEscena,frmEscena->Codigo,2);

      CargaAutoCompletar();

      // Tambin tenemos que cargar el autotexto en lbAT:
      AnsiString ext = ExtractFileExt(DF[IndexDF]->fichero);

      if( 1 == ext.Pos(".") )
         // Borramos el punto:
         ext = ext.Delete(1,1);

      // Liberamos la memoria ocupada.
      frmConfiguracion->DescargaAT(lbAT);
      // Cargamos la lista:
      frmConfiguracion->CargaAT(lbAT,ext.UpperCase());
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnIrALineaClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;      

   int  total   = ReVRML.LinesCount(Texto);
   int  linea   = Texto->CaretPos.y + 1;
   bool seguir;
   do{
      if(frmUtilidad->IniciaIrALinea(linea)){
         if(total < linea){
            Utilidad.MsgInfo(" The number line must be <= " + IntToStr(total));
            seguir=true;
         }else{
            // Marcamos la linea:
            SeleccionarLinea(linea,false);

            seguir=false;
         }
      }else
         seguir=false;
   }while(seguir);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnEjecucionConsolaClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   Main->mnVerConsolaH3DClick(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::BorraDF(int index){

   if( (DF==NULL) || (NumFicheros==0) || (index<-1) || (index>=NumFicheros) || (DF[index]==NULL) )
      return;

   if(-1 != index){
      if(DF[index] != NULL){
         delete DF[index];
         DF[index] = NULL;
      }
      // Tenemos que crear un nuevo array con una casilla menos:
      if(NumFicheros == 1){
         NumFicheros=0;
         IndexDF=0;
         delete DF;
         DF = NULL;
         if(0 < TabControl->Tabs->Count)
            TabControl->Tabs->Delete(0);
         return;
      }else{
         // Vamos a crear el nuevo array y a copiar los punteros vlidos:
         DatosFichero **DF_tmp = DF;
         try{
            // Reservamos memoria para el nuevo array:
            DF = new (DatosFichero*[NumFicheros-1]);
         }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

         // Copiamos los punteros vlidos del array:
         int i=0;
         for(int c=0; c < NumFicheros; c++){
            if(DF_tmp[c] != NULL)
               DF[i++] = DF_tmp[c];
         }
         NumFicheros--;
         if(i != NumFicheros){
            // En este caso haba ms de un puntero a NULL en DF_tmp -> tenemos
            // que poner a NULL los elementos del final de DF:
            while(i < NumFicheros)
               DF[i++] = NULL;
         }
         // Tenemos que borrar el tab asociado al fichero liberado:
         if(index < TabControl->Tabs->Count)
            TabControl->Tabs->Delete(index);

         if(IndexDF >= NumFicheros)
            IndexDF = NumFicheros-1;
      }
   }else{
      for(int c=0; c < NumFicheros;c++){
         if(DF[c] != NULL)
            delete DF[c];
      }
      NumFicheros=0;
      IndexDF = 0;
      delete DF;
      DF = NULL;
      // Tambin eliminamos los tabs de TabControl:
      TabControl->Tabs->Clear();
   }
}
//---------------------------------------------------------------------------
int __fastcall TfrmEditor::CreaDF(AnsiString fichero,bool ficheroModificado,bool datosModificados){

   // Tenemos que distinguir el caso inicial en el que DF == NULL:
   if(DF == NULL){
      try{
         // Reservamos memoria para un array de un elemento:
         DF = new (DatosFichero*[1]);
         // Reservamos memoria para el nico elemento del array:
         DF[0] = new DatosFichero(fichero,ficheroModificado,datosModificados);

      }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

      NumFicheros = 1;
      IndexDF = 0;
   }else{
      // En este caso ya existe un array de DatosFichero -> Lo ampliamos:
      DatosFichero **df_tmp = DF;
      try{
         // Reservamos memoria para el nuevo array:
         DF = new (DatosFichero*[NumFicheros+1]);
         // Reservamos memoria para el ultimo elemento del array:
         DF[NumFicheros] = new DatosFichero(fichero,ficheroModificado,datosModificados);

      }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

      // Solo falta copiar los punteros del array anterior:
      for(int c=0; c < NumFicheros; c++)
         DF[c] = df_tmp[c];

      NumFicheros+=1;
      // IndexDF no debe cambiar porque habra que salvar el texto editado.
   }

   // Finalmente solo hay que crear un nuevo tab en TabControl:
   TabControl->Tabs->Append( ExtractFileName(DF[NumFicheros-1]->fichero) );

   return NumFicheros-1;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::SalvaDF(){

   if( (DF==NULL) || (NumFicheros==0) || (IndexDF<0) || (IndexDF>=NumFicheros) || (DF[IndexDF]==NULL) )
      return;
    Screen->Cursor=PUNT_RATON_ESPERA;
    DF[IndexDF]->datos = Texto->Text;
    Screen->Cursor=PUNT_RATON_NORMAL;
    // Salvamos el aspecto del control -> Posicin del cursor,seleccin y primera lnea:    
    DF[IndexDF]->selStart=Texto->SelStart;
    DF[IndexDF]->selLength=Texto->SelLength;
    DF[IndexDF]->primeraLinea = ReVRML.GetPrimeraLineaVisible(Texto);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::CargaDF(int index,bool cargarTexto){

   if( (DF == NULL) || (DF[IndexDF] == NULL) || (index < 0) || (index >= NumFicheros) ||
       (TabControl->Tabs->Count != NumFicheros) )
      return;

   // Por si se ha iniciado el proceso de actualizar las marcas, lo acabamos
   // antes de modificar el texto.
   ActualizaMarcasPaso2();

   ReVRML.BloqueaRepaint(Texto);

   IndexDF = index;
   if(TabControl->TabIndex != IndexDF)
      TabControl->TabIndex = IndexDF;
   if(cargarTexto){
      // tipo 3 indica que se dar siempre el formato sencillo (pe.para scripts)
      int tipo = EsVRML(DF[IndexDF]->fichero) ? 1 : 3;
      ReVRML.Inicia(this,Texto,tipo,&(DF[IndexDF]->datos));
   }
   // Reponemos el aspecto del control -> Posicin del cursor,seleccin y primera lnea:
   Texto->SelStart  = DF[IndexDF]->selStart;
   Texto->SelLength = DF[IndexDF]->selLength;
   ReVRML.SetPrimeraLineaVisible(Texto,DF[IndexDF]->primeraLinea);
   ReVRML.PermiteRepaint(Texto);
   Actualiza();

   // Tambin tenemos que cargar el autotexto en lbAT:
   AnsiString ext = ExtractFileExt(DF[IndexDF]->fichero);

   if( 1 == ext.Pos(".") )
      // Borramos el punto:
      ext = ext.Delete(1,1);

   // Liberamos la memoria ocupada.
   frmConfiguracion->DescargaAT(lbAT);
   // Cargamos la lista:
   frmConfiguracion->CargaAT(lbAT,ext.UpperCase());
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::TabControlChange(TObject *Sender)
{
   // Salvamos el contenido de Texto.
   SalvaDF();
   // Cargamos el contenido del nuevo tab.
   CargaDF(TabControl->TabIndex,true);

   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;
   TimerAC->Enabled = false;
}
//---------------------------------------------------------------------------
int __fastcall TfrmEditor::GetIndexFicheroPrincipal(){

   // Buscamos FicheroPrincipal entre los ficheros abiertos:
   for(int c=0; c < NumFicheros; c++){
      if( (DF[c] != NULL) && (DF[c]->esFicheroPrincipal) ){
         return c;
      }
   }
   // No se ha encontrado el fichero principal -> El usuario lo ha cerrado.
   return -1;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnCerrarClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if(!PreguntarSalvar(IndexDF))
      // Devolviendo false, se indica que no debe continuar el proceso:
      return;

   BorraDF(IndexDF);
   if(NumFicheros == 0){
      mnNoMantenerCambiosClick(NULL);
   }else
      CargaDF(IndexDF,true);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::FormShow(TObject *Sender)
{
   // El foco lo puede tener TabControl -> Lo pasamos a Texto:
   if(Texto->CanFocus() && !Texto->Focused() )
    this->FocusControl(Texto);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::sbSetMarca1Click(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if( (DF == NULL) || (DF[IndexDF] == NULL) )
      return;
   // Obtenemos la posicin actual del cursor.
   DF[IndexDF]->marca1 = Texto->SelLength + Texto->SelStart;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::sbSetMarca2Click(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if( (DF == NULL) || (DF[IndexDF] == NULL) )
      return;
   // Obtenemos la posicin actual del cursor.
   DF[IndexDF]->marca2 = Texto->SelLength + Texto->SelStart;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::sbSetMarca3Click(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if( (DF == NULL) || (DF[IndexDF] == NULL) )
      return;
   // Obtenemos la posicin actual del cursor.
   DF[IndexDF]->marca3 = Texto->SelLength + Texto->SelStart;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::sbSetMarca4Click(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if( (DF == NULL) || (DF[IndexDF] == NULL) )
      return;
   // Obtenemos la posicin actual del cursor.
   DF[IndexDF]->marca4 = Texto->SelLength + Texto->SelStart;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::sbMarca1Click(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if( (DF == NULL) || (DF[IndexDF] == NULL) )
      return;
   // Vamos a Colocar el cursor en la posicin guardada en la marca.
   Texto->SelLength = 0;
   Texto->SelStart = DF[IndexDF]->marca1;

   // Es posible que sea necesario hacer un scroll para que el cursor aparezca
   // en la pantalla -> Lo hacemos:
   SendMessage(Texto->Handle,EM_SCROLLCARET, 0, 0);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::sbMarca2Click(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if( (DF == NULL) || (DF[IndexDF] == NULL) )
      return;
   // Vamos a Colocar el cursor en la posicin guardada en la marca.
   Texto->SelLength = 0;
   Texto->SelStart = DF[IndexDF]->marca2;

   // Es posible que sea necesario hacer un scroll para que el cursor aparezca
   // en la pantalla -> Lo hacemos:
   SendMessage(Texto->Handle,EM_SCROLLCARET, 0, 0);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::sbMarca3Click(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if( (DF == NULL) || (DF[IndexDF] == NULL) )
      return;
   // Vamos a Colocar el cursor en la posicin guardada en la marca.
   Texto->SelLength = 0;
   Texto->SelStart = DF[IndexDF]->marca3;

   // Es posible que sea necesario hacer un scroll para que el cursor aparezca
   // en la pantalla -> Lo hacemos:
   SendMessage(Texto->Handle,EM_SCROLLCARET, 0, 0);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::sbMarca4Click(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;

   if( (DF == NULL) || (DF[IndexDF] == NULL) )
      return;
   // Vamos a Colocar el cursor en la posicin guardada en la marca.
   Texto->SelLength = 0;
   Texto->SelStart = DF[IndexDF]->marca4;

   // Es posible que sea necesario hacer un scroll para que el cursor aparezca
   // en la pantalla -> Lo hacemos:
   SendMessage(Texto->Handle,EM_SCROLLCARET, 0, 0);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnIraMarca1Click(TObject *Sender)
{
   sbMarca1Click(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnIraMarca2Click(TObject *Sender)
{
   sbMarca2Click(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnIraMarca3Click(TObject *Sender)
{
   sbMarca3Click(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnIraMarca4Click(TObject *Sender)
{
   sbMarca4Click(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnSetMarca1Click(TObject *Sender)
{
   sbSetMarca1Click(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnSetMarca2Click(TObject *Sender)
{
   sbSetMarca2Click(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnSetMarca3Click(TObject *Sender)
{
   sbSetMarca3Click(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnSetMarca4Click(TObject *Sender)
{
   sbSetMarca4Click(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnGuardarTodoClick(TObject *Sender)
{
   SalvarFichero(-1);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::TextoMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   // Cuando se formatea la pantalla se interrumpe el proceso de seleccin
   // del texto, lo evitamos con  FormateoAnulado en OnMouseDown y OnMouseUp:
   FormateoAnulado=false;

   // Cuando se selecciona un trozo de texto sin haber hecho scroll no es
   // necesario formatear la pantalla, as evitaremos un parpado, usamos la
   // informacin de PrimeraLinea asiganada en en el evento OnMouseDown.
   int primL = ReVRML.GetPrimeraLineaVisible(Texto);
   if( (primL != PrimeraLinea) && (DF != NULL) && (DF[IndexDF] != NULL) && (EsVRML(DF[IndexDF]->fichero)) )
      ReVRML.FormateaPantalla(this,Texto);

}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::TextoMouseWheel(TObject *Sender,
      TShiftState Shift, int WheelDelta, TPoint &MousePos, bool &Handled)
{
   // La seleccin parpada cuando se desplaza el texto -> Lo evitamos
   Texto->SelLength=0;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::ActualizaMarcasPaso1(){

   if(ProcesoIniciado_Marcas)
      return;

   // Antes de la modificacin del cdigo solo necesitaremos estos datos para
   // saber cmo habr que modificar las marcas en el paso 2:
   // TamInicial_Marcas= Texto->Text.Length(); Este modo es ms lento en ficheros grandes.
   TamInicial_Marcas=SendMessage(Texto->Handle, WM_GETTEXTLENGTH, 0, 0);
   PosInicial_Marcas=Texto->SelStart;
   // Una vez ejecutado el paso1 debe ejecutarse el 2, lo conseguirmos con:
   ProcesoIniciado_Marcas = true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::ActualizaMarcasPaso2(){
   if(!ProcesoIniciado_Marcas)
      return;

   // Esta funcin se ejecuta tras la modificacin y su misin es actualizar las
   // marcas. Solo tenemos que considerar el incremento en la longitud del texto.
   // Este incremento ser positivo si se aade texto y negativo en caso
   // contrario, y solo afectar a las marcas cuando la modificacin se produzca
   // antes de la posicin que contiene la marca:

   // int tamFinal = Texto->Text.Length(); Este modo es ms lento en ficheros grandes.
   int tamFinal = SendMessage(Texto->Handle, WM_GETTEXTLENGTH, 0, 0);

   int incremento =  tamFinal - TamInicial_Marcas;
   if( (DF !=  NULL) && (IndexDF >= 0) && (IndexDF < NumFicheros) && (DF[IndexDF] != NULL) ){

      if( PosInicial_Marcas <= DF[IndexDF]->marca1 )  DF[IndexDF]->marca1+= incremento;
      if( PosInicial_Marcas <= DF[IndexDF]->marca2 )  DF[IndexDF]->marca2+= incremento;
      if( PosInicial_Marcas <= DF[IndexDF]->marca3 )  DF[IndexDF]->marca3+= incremento;
      if( PosInicial_Marcas <= DF[IndexDF]->marca4 )  DF[IndexDF]->marca4+= incremento;

      // Comprobamos los valores nuevos:
      if( DF[IndexDF]->marca1 < 0 )  DF[IndexDF]->marca1 = 0;
      if( DF[IndexDF]->marca2 < 0 )  DF[IndexDF]->marca2 = 0;
      if( DF[IndexDF]->marca3 < 0 )  DF[IndexDF]->marca3 = 0;
      if( DF[IndexDF]->marca4 < 0 )  DF[IndexDF]->marca4 = 0;

      if( DF[IndexDF]->marca1 >= tamFinal )  DF[IndexDF]->marca1 = (tamFinal > 0) ? (tamFinal-1) : 0;
      if( DF[IndexDF]->marca2 >= tamFinal )  DF[IndexDF]->marca2 = (tamFinal > 0) ? (tamFinal-1) : 0;
      if( DF[IndexDF]->marca3 >= tamFinal )  DF[IndexDF]->marca3 = (tamFinal > 0) ? (tamFinal-1) : 0;
      if( DF[IndexDF]->marca4 >= tamFinal )  DF[IndexDF]->marca4 = (tamFinal > 0) ? (tamFinal-1) : 0;
   }

   // Con esto indicamos que ya se puede volver a ejecutar el paso 1:
   ProcesoIniciado_Marcas = false;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TfrmEditor::PreparaElemLista(AnsiString cad,AnsiString msg){

   // Evitamos este caso especial en el que no funcionara bien la funcin.
   // No debe producirse nunca porque msg ser siempre mucho ms corto que
   // NUM_CARACTERES_AUTOCOMPLETAR.
   if( (msg.Length()+1) > NUM_CARACTERES_AUTOCOMPLETAR )
      return "";

   AnsiString cadena;
   // Creamos una cadena con la longitud que usaremos (NUM_CARACTERES_AUTOCOMPLETAR).
   // Sus primeros caracteres sern los de cad y los siguientes :
   for(int c=1; c <= NUM_CARACTERES_AUTOCOMPLETAR ; c++){
      if(c <= cad.Length())
         cadena += cad[c];
      else
         cadena += "";
   }
   int index = NUM_CARACTERES_AUTOCOMPLETAR;
   // Ahora copiamos msg al final de cadena:
   for(int c=msg.Length(); c >= 1  ; c--)
      cadena[index--] = msg[c];

   // Nos aseguramos de que al menos un punto separe cad de msg (si es necesario
   // se sobreescribir parte de cad).
   cadena[index] = '';

   return cadena;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::LiberaMemAutoCompletar(TListBox *lb){

   if(lb == NULL)
      return;
   // Liberamos la memoria ocupada por los lb->Itens->Objects que no sean NULL:
   for(int c=0; c < lb->Items->Count; c++){
      AnsiString *cad = (AnsiString *)lb->Items->Objects[c];
      if(cad != NULL){
         delete cad;
         lb->Items->Objects[c]= NULL;
      }
   }
   // Finalmente borramos todas las cadena:
   lb->Clear();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::CargaAutoCompletar(){

   // Lo primero es liberar toda la memoria reservada que contienen los punteros
   // a TObjec:
   LiberaMemAutoCompletar(lbVRML);

   // Cargamos el gestor de nodos adecuado.
   GestorNodos *GN;
   if(TipoEscenaActual == ESCENA_X3D)
      GN = Main->GNX;
   else
      GN = Main->GNH;

   if(GN == NULL)
      return;

   // Para cada nodo vamos a aadir: Su nombre, todos sus campos aunque sean
   // eventos y el nodo completo con solo los campos que no sean eventos.
   int numNodos = GN->GetNumNodos();

   // Para evitar problemas con la asignacin de los punteros, creamos la lista
   // de nombres y luego asignamos los punteros:
   for(int c1=0; c1 < numNodos; c1++){
       Nodo *n = GN->DatosNodo(c1);
       if(n != NULL){
          // -------------- Aadimos el NOMBRE DEL NODO -----------------------:
          AnadeListBox(lbVRML,n->nombre,"Node(Nam)",n->nombre);
          // -------------- Aadimos TODOS LOS CAMPOS -------------------------:
          for(int c2=0; c2 < n->numCampos; c2++){
             Campo *c = n->campos[c2];
             if(c != NULL)
                AnadeListBox(lbVRML,c->nombre,"Field    ",c->nombre);
          }
          // -------------- Aadimos NODOS COMPLETOS --------------------------:
          AnsiString dato = "";

          // A continuacin aadimos los campos que no sean eventos:
          for(int c2=0; c2 < n->numCampos; c2++){

             Campo *c = n->campos[c2];

             if( (c != NULL) && (c->rutado != EVENTOUT) && (c->rutado != EVENTIN) ){
                // Aadimos el nombre del campo anidado con CONF.FICH_NUM_CARACTERES_JUSTIF espacios
                dato += AnsiString::StringOfChar(' ',CONF.FICH_NUM_CARACTERES_JUSTIF) ;
                dato += c->nombre + " = '" + c->valorPorDefecto + "'\r\n";
             }
          }
          // Solo falta aadir la llave de cierre:
          dato += "/>\r\n";

          AnadeListBox(lbVRML,n->nombre,"Node(DEF)",(AnsiString) "<" + n->nombre +  " DEF='Identifier'\r\n" + dato);
          AnadeListBox(lbVRML,n->nombre,"Node(Cmp)",(AnsiString) "<" + n->nombre + "\r\n" + dato);
       }
   }

   // Aadimos la primera lnea de un fichero VRML:
   AnadeListBox(lbVRML,PRIMERA_LINEA_VRML,"1st Line ",(AnsiString)PRIMERA_LINEA_VRML + " ");
   // Aadimos un rutado:
   AnadeListBox(lbVRML,"*ROUTE <-> TO","* ROUTE Link ","ROUTE NodeIdent.Field TO NodeIdent.Field");
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEditor::EsLetra(char c){

   if( (c >= 'a') && (c <= 'z') )
      return true;
   if( (c >= 'A') && (c <= 'Z') )
      return true;
   return (c == '_');
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::TimerACTimer(TObject *Sender)
{
   // En cualquier caso el temporizador no deber volver a activarse hasta que
   // el usuario lo provoque.
   TimerAC->Enabled = false;

   // Inicialmente la asignamos a 0 por si salimos de la funcin por algn
   // motivo, y cuando encontremos la cadena, asgnaremos su valor:
   LongCadAC = 0;

   // Solo se permite autocompletar en ficheros VRML:
   if( (DF==NULL) || (NumFicheros==0) || (IndexDF<0) || (IndexDF>=NumFicheros) ||
       (DF[IndexDF]==NULL) || !EsVRML(DF[IndexDF]->fichero) || (Texto->SelLength != 0) ){
      pnlInsercion->Visible = false;       
      return;
   }
   // En ficheros de muchas lneas estas operaciones pueden llevar cierto tiempo
   // por eso las desactivamos si el fichero es de demasiadas lneas y en otro
   // caso usamos el puntero del ratn.
   if(FORMATO_MAX_NUM_LINS < ReVRML.LinesCount(Texto)){
      if(!SeHaAvisadoNoAC){
         Utilidad.MsgInfo((AnsiString)"When the file has got more than " + FORMATO_MAX_NUM_LINS + " lines it is not possible to use the autocomple feature.") ;
         SeHaAvisadoNoAC=true;
      }
      pnlInsercion->Visible = false;
      return;
   }
   Screen->Cursor=PUNT_RATON_ESPERA;

   // Lo primero es ver qu caracteres se estn tecleando, obtenemos los
   // caracteres que hay antes del actual hasta un mximo de 10.
   int index = Texto->SelStart+1;  // +1 para convertir a index de AnsiString.

   // En este caso estaremos al principio del texto y no tenemos que hacer nada
   if(index <= 1){
      Screen->Cursor=PUNT_RATON_NORMAL;
      pnlInsercion->Visible = false;
      return;
   }

   // Si tras el ultimo caracter escrito hay una letra o un numero no
   // mostraremos el panel:
   if( index <= Texto->Text.Length() ){
      char c = Texto->Text[index];
      if( EsLetra(c) || ((c <= '9') && (c >= '0') ) ){
         Screen->Cursor=PUNT_RATON_NORMAL;
         pnlInsercion->Visible = false;
         return;
      }
   }

   int cont = 0;
   AnsiString cad;

   // Intentamos decrementar index para colocarnos sobre el ltimo caracter introducido:
   if(index >= 2)
      index--;

   while( (index >= 1) && (cont <= 10) && EsLetra(Texto->Text[index]) ){
       // Vamos construyendo una cadena con los caracteres que leemos:
       cad = ((AnsiString) Texto->Text[index]) + cad;
       index--;
       cont++;
   }
   if(cont == 10){
      Screen->Cursor=PUNT_RATON_NORMAL;
      pnlInsercion->Visible = false;
      return;  // El nombre excede la longitud que buscamos.
   }

   // El siguiente paso es buscar la cadena que tenemos entre las cadenas que
   // hay en lbVRML y si encontramos una cadena que coincide la seleccionamos.
   // No distinguiremos mayusculas y minusculas.
   cad = cad.UpperCase();
   int fin = lbVRML->Items->Count;
   bool encontrada = false;
   for(int c=0; c < fin; c++){
      if( 1 == lbVRML->Items->Strings[c].UpperCase().Pos(cad) ){
         // Hemos encontrado la cadena:
         lbVRML->ItemIndex = c;
         encontrada = true;
         break;
      }
   }

   if(!encontrada){
      pnlInsercion->Visible=false;
      Screen->Cursor=PUNT_RATON_NORMAL;
      pnlInsercion->Visible = false;
      return;
   }
   LongCadAC = cad.Length();

   // Hemos encontrado y seleccionado la cadena, pero el elemento seleccioando
   // no siempre aparece como el primer elemento de la lista, vamos a usar las
   // API para hacer que sea el primer elemento.
   SendMessage(lbVRML->Handle, LB_SETTOPINDEX, lbVRML->ItemIndex, 0);

   ColocaPnlInsercion();

   lbVRML->Visible=true;
   lbAT->Visible=false;
   pnlInsercion->Visible = true;
   Screen->Cursor=PUNT_RATON_NORMAL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnArchivoClick(TObject *Sender)
{
   // Ocultamos el panel de AC:
   pnlInsercion->Visible = false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnDeshacerDrawItem(TObject *Sender,
      TCanvas *ACanvas, TRect &ARect, bool Selected)
{
   mnDeshacer->Enabled = Texto->CanUndo;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnDeshacerClick(TObject *Sender)
{
   if(Texto->CanUndo)
      Texto->Undo();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::SeleccionarLinea(int line,bool todos){

   if( (NumFicheros == 0) || (line <= 0) )
      return;

   if(todos){
      if(NumFicheros == 1){
         SeleccionarLinea(line,false);
      }else{
         // En este caso cargaremos todos los ficheros abiertos y seleccionaremos
         // la lnea en cada uno de ellos, usaremos Repaint para que el usuario
         // vea el proceso.
         SalvaDF();
         int tmp = IndexDF;
         for(int c=0; c < NumFicheros; c++){
            CargaDF(c,true);
            SeleccionarLinea(line,false);
            SalvaDF();
            // this->Repaint(); Realmente no hace falta porque se hacen en CargaDF.
         }
         if(tmp != IndexDF)
            CargaDF(tmp,true);
      }
   }else{
      // Obtenemos los indices asociados a la lnea que queremos seleccionar y
      // a la siguiente.
      int index1 = ReVRML.GetIndexLinea(Texto,line-1);
      int index2 = ReVRML.GetIndexLinea(Texto,line);

      if(index1 == -1)
         // En este caso se intenta ir a una lnea mayor al n de lneas de Texto.
         return;

      // Ahora seleccionaremos el texto que hay desde index1 hasta index2.
      if(index2 == -1)
         // Se ha llegado al final del texto.
         index2 = Texto->Text.Length()+1;
      ReVRML.SetCursorPos(Texto,line,1);
      Texto->SelStart = index1-1;
      if((index2-index1-1) >= 1)
         Texto->SelLength = index2-index1-1;
      else
         Texto->SelLength = index2-index1;
   }
   Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::InsertaTexto(AnsiString cad,int longCad){

   if(cad == "")
     return;

   int fila = Texto->CaretPos.y;
   int col  = Texto->CaretPos.x+1;   // Index de AnsiString

   if(longCad != 0)
      Texto->Lines->Strings[fila] = Texto->Lines->Strings[fila].Delete(col-longCad,longCad);

   AnsiString inicio;
   if( col > longCad )
      inicio = AnsiString::StringOfChar(' ',col-longCad-1);

   int numCadenas = Utilidad.GetNumCadenas(cad);

   for(int c=0; c < numCadenas; c++){
      AnsiString linea = Utilidad.GetLinea(cad,c);
      if(c == 0){
         if(linea == "")
            linea = "\r\n";
         Texto->Lines->Strings[fila] = Texto->Lines->Strings[fila].Insert(linea,col-longCad);
      }else{
         if(linea == "")
            linea = " ";
         Texto->Lines->Insert(++fila,inicio+linea);
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::AnadeListBox(TListBox *lb,AnsiString nombreIzq,AnsiString nombreDer,AnsiString dato){

   if(lb == NULL)
      return;

   AnsiString cad = PreparaElemLista(nombreIzq,nombreDer);
   AnsiString *s = NULL;

   if(-1 == lb->Items->IndexOf(cad)){

      // Aadimos la cadena.
      lb->Items->Append(cad);

      int index = lb->Items->IndexOf(cad);

      if(-1 != index){
         // Reservamos memoria para el AnsiString:
         try{ s = new AnsiString;}
         catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

         (*s) = dato;
         lbVRML->Items->Objects[index] = (TObject *) s;
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnACClick(TObject *Sender)
{
   CONF.USAR_AUTO_COMPLETAR = !CONF.USAR_AUTO_COMPLETAR;
   mnAC->Checked = CONF.USAR_AUTO_COMPLETAR;
   CONF.LosDatosHanCambiado();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnATClick(TObject *Sender)
{
   if(lbAT->Items->Count == 0){
      if( (DF != NULL) && (DF[IndexDF] != NULL) ){
         AnsiString ext = ExtractFileExt(DF[IndexDF]->fichero);
         Utilidad.MsgInfo((AnsiString)" You can use the settings window to create autotext elements for " + ext + " files.");
      }
      return;
   }
   
   ColocaPnlInsercion();
   lbVRML->Visible=false;
   lbAT->Visible=true;
   pnlInsercion->Visible = true;
   if(lbAT->CanFocus())
      this->FocusControl(lbAT);

   // Intentamos seleccionar el primer elemento de la lista:
   if(lbAT->Items->Count > 0)
      lbAT->ItemIndex = 0;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::lbATKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(Key == VK_ESCAPE){
      pnlInsercion->Visible = false;
      if(Texto->CanFocus())
         this->FocusControl(Texto);
   }else if(Key == VK_RETURN){
      lbATDblClick(NULL);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::lbVRMLDblClick(TObject *Sender)
{
   if( (lbVRML->ItemIndex != -1) && (lbVRML->Items->Objects[lbVRML->ItemIndex] != NULL) ){
      InsertaTexto( *((AnsiString *)lbVRML->Items->Objects[lbVRML->ItemIndex]),LongCadAC );
      pnlInsercion->Visible=false;
   }
   if(Texto->CanFocus())
      FocusControl(Texto);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::lbVRMLKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(VK_RETURN == Key)
      lbVRMLDblClick(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::lbATDblClick(TObject *Sender)
{
   if( (lbAT->Items->Count > 0) && (lbAT->ItemIndex != -1) &&
       (lbAT->Items->Objects[lbAT->ItemIndex] != NULL) ){

      AnsiString *s = (AnsiString *) lbAT->Items->Objects[lbAT->ItemIndex];
      InsertaTexto(*s,0);
   }
   pnlInsercion->Visible = false;
   if(Texto->CanFocus())
      FocusControl(Texto);        
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::lbATExit(TObject *Sender)
{
   if(this->ActiveControl == lbAT)
      pnlInsercion->Visible = false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::ColocaPnlInsercion(){
   // Vamos a colocar el panel en la posicin adecuada, cuidando los bordes de Texto:
   // Lo primero que necesitamos es la posicin en pixels del cursor-> Usamos las API:
   POINT pos;
   if(!GetCaretPos(&pos) ){
      Screen->Cursor=PUNT_RATON_NORMAL;
      pnlInsercion->Visible = false;
      return;
   }

   // Tambin necesitaremos el tamao de una lnea:
   int lineHeight = ReVRML.GetLineHeight(this,Texto,CONF.Formato_TAM_FUENTE_EDITOR);

   // Asignamos pnlInsercion->Top cuidando los bordes:
   // (aadimos 2 para separarnos un poco del borde de la linea).
   int nuevoTop = pos.y + lineHeight + 2;
   if( (nuevoTop + pnlInsercion->Height) < Texto->Height)
      pnlInsercion->Top  = nuevoTop;
   else
      pnlInsercion->Top  = pos.y - 2 - pnlInsercion->Height;

   // Asignamos pnlInsercion->Left cuidando los bordes:
   if( (pos.x + pnlInsercion->Width) < Texto->Width)
      pnlInsercion->Left  = pos.x;
   else
      pnlInsercion->Left  = pos.x - pnlInsercion->Width;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnAyudaAcercaClick(TObject *Sender)
{
   frmSobre->Inicia();
}
//---------------------------------------------------------------------------

void __fastcall TfrmEditor::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditor::mnAyudaManualClick(TObject *Sender)
{
   Main->Ayuda();
}
//---------------------------------------------------------------------------

