//
//    EDITOR DE NODOS     
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Visualiza los datos de cada nodo X3D/H3D y permite editarlos.
*/
//---------------------------------------------------------------------------

#ifndef frmEditorNodos_H
#define frmEditorNodos_H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <Grids.hpp>
#include <ImgList.hpp>
#include <ExtCtrls.hpp>
#include "GestorNodos_.h"
#include <Buttons.hpp>
#include <Graphics.hpp>
#include "Main_.h"
#include "frmEscena_.h"
#include <CheckLst.hpp>
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
class TfrmEditorNodos : public TForm
{
__published:	// IDE-managed Components
        TPageControl *Carpetas;
        TTabSheet *TabSheet1;
        TTabSheet *pnlEventos;
        TPanel *pnlCampos;
        TStringGrid *gridCampos;
        TPanel *pnlEnlaces;
        TSpeedButton *btnEnlaceVerde;
        TImageList *imgsTipos;
        TPanel *pnlDatosCampo;
        TEdit *edDatosCampo;
        TStatusBar *BarraDeEstado;
        TPanel *BarraCampos;
        TPanel *pnlEventosSup;
        TLabel *lbEvento;
        TImage *imgField;
        TListBox *ListBox1;
        TListBox *ListBox2;
        TPanel *pnlImagenTipo;
        TImage *imgTipo;
        TPanel *pnlTitEventOut;
        TImage *imgExposedField_;
        TImage *imgEventOut;
        TPanel *pnlTitEventIn;
        TImage *imgExposedField;
        TImage *imgEventIn;
        TPanel *pnlEventosInf;
        TPanel *pnlEventOut;
        TSpeedButton *sbEventOut;
        TPanel *pnlNombreCampo;
        TPanel *pnlEventIn;
        TSpeedButton *sbEventIn;
        TListBox *listEventOut;
        TPanel *pnlEventosSalida;
        TPanel *pnlEventosEntrada;
        TListBox *listEventIn;
        TPanel *pnlEventosCentro;
        TStringGrid *gridEventos;
        TPanel *pnlHint;
        TPanel *Panel4;
        TPanel *pnlImgNodo;
        TImage *imgNodo;
        TLabel *lbNombreNodo;
        TLabel *lbNombre;
        TEdit *edNombreNodo;
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall gridCamposDrawCell(TObject *Sender,
          int ACol, int ARow, TRect &Rect, TGridDrawState State);
        void __fastcall imgNodoDblClick(TObject *Sender);
        void __fastcall gridCamposSelectCell(TObject *Sender,
          int ACol, int ARow, bool &CanSelect);
        void __fastcall FormShow(TObject *Sender);
        void __fastcall edDatosCampoKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall btnEnlaceVerdeClick(TObject *Sender);
        void __fastcall CarpetasChange(TObject *Sender);
        void __fastcall imgTipoClick(TObject *Sender);
        void __fastcall gridEventosSelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
        void __fastcall gridEventosMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
        void __fastcall pnlEventosMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
        void __fastcall pnlHintMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall sbEventOutClick(TObject *Sender);
        void __fastcall sbEventInClick(TObject *Sender);
        void __fastcall gridCamposMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall edNombreNodoExit(TObject *Sender);
        void __fastcall edDatosCampoExit(TObject *Sender);
        void __fastcall edDatosCampoKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall edDatosCampoKeyPress(TObject *Sender, char &Key);
        void __fastcall edNombreNodoKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall FormDeactivate(TObject *Sender);
    void __fastcall edNombreNodoKeyPress(TObject *Sender, char &Key);
        void __fastcall CarpetasDrawTab(TCustomTabControl *Control,
          int TabIndex, const TRect &Rect, bool Active);
        void __fastcall FormCanResize(TObject *Sender, int &NewWidth,
          int &NewHeight, bool &Resize);
        void __fastcall pnlCamposResize(TObject *Sender);
        void __fastcall edDatosCampoDblClick(TObject *Sender);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall gridCamposMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
private:	// User declarations
        // Es el nodo que se est editando actualmente.
        NodoArbol *NodoArbolEditado;

        // Cuando se est editando un nodo, habr siempre un campo selecionado
        // este campo es apuntado por:
        NodoArbol *CampoEditado;

        // Es necesario saber cuando ha cambiado el campo para actualizar o no
        // la escena.
        bool CampoHaCambiado;

        // Esta funcin dibuja el botn de enlace correspondiente al campo
        // asociado a la fila row.
        void __fastcall DibujaBotonEnlace_y_TEdit(int row);

        // Usando la informacin de campo devuelve el contenido que
        // aparecer en gridCampos y en edDatosCampo.
        AnsiString __fastcall GetDatosCampo(NodoArbol *campo);

        // Indica si se pueden editar o no los datos de edDatosCampo (a veces
        // aparece un texto fijo que no debe cambiar el usuario por ejemplo en
        // los eventos). Usa CampoEditado.
        bool __fastcall DatosCampoEditables();

        // Asigna el contenido de la barra de estado segn el valor de NodoArbolEditado.
        void __fastcall RellenarBarraEstado();

        // Carga toda la informacin del nodo: Nombre del nodo, campos,datos
        // de los campos etc.
        void __fastcall CargaNodo(NodoArbol *nodoArbol);

        // Carga un NodoArbol de tipo Rutado.
        void __fastcall CargaRutado(NodoArbol *elemento);

        // Muestra un cuadro de dilogo para elegir una imagen y asigna ruta.
        void __fastcall GetRutaImagen(AnsiString &ruta);

        // Muestra un cuadro de dilogo para elegir una fichero y asigna ruta.
        void __fastcall GetRutaFile(AnsiString &ruta);


public:		// Constructor
        __fastcall TfrmEditorNodos(TComponent* Owner);
        __fastcall ~TfrmEditorNodos();
        // Se encarga de colocar la ventana a la izquierda de la pantalla. El
        // ajuste se hace teniendo en cuenta el resto de ventanas.
        void __fastcall Posiciona();

        // Recibe un campo que se edita. Si el nodo actual es != del nodo padre
        // de campo se cargara el nodo padre de campo. Si campo es un evento
        // se mostrar el tab de eventos y si es un campo tipo FIELD o EXPOSEDFIELD
        // se mostrar el listado de campos.
        void __fastcall EditaCampo(NodoArbol *campo);

        // Recibe un puntero al nodo del arbol asociado al evento (campo) que
        // se est editando y carga todos los eventos de la escena actualizando
        // la informacin de todos los controles.
        void __fastcall CargaEventos(NodoArbol *campoEventoEditado);


        // Esta funcin recibe un puntero a un elemento de la escena que puede
        // ser: un nodo X3D/H3D, el nodo RAIZ o un campo. Esta funcin carga
        // los datos necesarios en los controles segn qu tab est seleccionado.
        // Tambin se puede pasar NULL -> Se desactica el editor de nodos.
        void __fastcall Carga(NodoArbol *elemento);

        // Esta funcin actualiza la lista de eventos de toda la escena que se
        // muestra en el tab Eventos. Solo se actualiza la lista si se est
        // mostrando el tab. El tipo de los eventos (tipo de dato X3D/H3D)
        // que aparecern en la lista ser igual al ltimo usado (variable
        // privada (CampoEditado).
        void __fastcall ActualizarListaEventos();

        // Estas funciones permiten usar el portapapeles para cortar, copiar
        // y pegar texto. Para esta interaccin se usa el control activo que
        // debe ser edDatosCampo o edNombreNodo.
        void __fastcall Cortar();
        void __fastcall Copiar();
        void __fastcall Pegar();


        // Activa la ventana EditorNodos y pasa el foco al control asociado
        // al tipo de elemento que se est editando actualmente.
        // Cuando el elemento seleccionado en frmEscena->TreeView es un nodo
        // se editar el nombre de ese nodo.
        void __fastcall GetFoco();

};
//---------------------------------------------------------------------------
extern PACKAGE TfrmEditorNodos *frmEditorNodos;
//---------------------------------------------------------------------------
#endif
