//
//    EDITOR DE NODOS     
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Visualiza los datos de cada nodo X3D/H3D y permite editarlos.
*/
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "frmEditorNodos_.h"
#include "frmTipos_.h"
#include "frmDetallesNodo_.h"
#include "Utilidad_.h"
#include "frmTools_.h"
#include "frmIndiceNodos_.h"
#include "frmUtilidad_.h"
#include "Main_.h"
#include "Configuracion_.h"
#include "GestorVRML_.h"
#include "frmEdicionCampos_.h"
#include <vcl\Clipbrd.hpp>

// Es el color de los datos que se introducen en los campos.
#define COLOR_DATOS_CAMPOS clBlue

// Es el color de los nombres de los campos.
#define COLOR_NOMBRES_CAMPO clBlack

// Es la cadena que se muestra en edDatosNodo cuando el campo tiene datos que
// ocupan varias lneas.
#define CADENA_CONTROL_MAS_INTRO "(CTRL+Enter)"

// Ancho y alto de la ventana.
#define MIN_HEIGHT 375
#define WIDTH_VENTANA 302
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmEditorNodos *frmEditorNodos;

//---------------------------------------------------------------------------
__fastcall TfrmEditorNodos::TfrmEditorNodos(TComponent* Owner)
        : TForm(Owner)
{
    NodoArbolEditado=NULL;
    CampoEditado=NULL;
}
//---------------------------------------------------------------------------
__fastcall TfrmEditorNodos::~TfrmEditorNodos()
{
   // El destructor de frmEscena llamar a esta funcin cuando se salga del
   // programa y para evitar un "null pointer" hay que hacer esto:
   frmEditorNodos=NULL;
}

//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::DibujaBotonEnlace_y_TEdit(int row){

    if( (NodoArbolEditado == NULL) || (row > NodoArbolEditado->hijos->MaxIndexUsado())
        || (row < 0) || (!NodoArbolEditado->EsNodo()) || (row >= gridCampos->RowCount) )
       return;

    // Hay que actualizar correctamente los datos de edDatosCampo:
    // Actualizamos el puntero al campo selecionado.
    CampoEditado= NodoArbolEditado->GetHijo(row,CAMPO);

    // Y en segundo lugar asignamos los datos.
    edDatosCampo->Text = GetDatosCampo(CampoEditado);
    edDatosCampo->SelStart=0;
    edDatosCampo->SelLength=edDatosCampo->Text.Length();

    // frmEscena->TreeView y el editor de nodos estn vinculados. As se
    // implementa esa vinculacin en un sentido.
    if( (CampoEditado != NULL) && (CampoEditado->nodoAsociado != NULL) &&
        (CampoEditado->nodoAsociado->IsVisible) &&
        (frmEscena->TreeView->Selected != CampoEditado->nodoAsociado) &&
        (frmEscena->TreeView->Selected != NULL) &&
        (((NodoArbol *)frmEscena->TreeView->Selected->Data)->EsCampo())  ){
        frmEscena->TreeView->Selected=CampoEditado->nodoAsociado;
    }

    TRect r=gridCampos->CellRect(3,row);

    if( ((int)r.Top+1 + pnlEnlaces->Height) > pnlCampos->ClientHeight)
       return;

    pnlDatosCampo->Top=(int)r.Top+1;
    pnlDatosCampo->Left= BarraCampos->Width + BarraCampos->Left + gridCampos->ColWidths[2];

    pnlEnlaces->Top=(int)r.Top+1;
    pnlEnlaces->Left= pnlDatosCampo->Left + pnlDatosCampo->Width;

}

//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::Posiciona(){
    int Top= CONF.MARGEN_POSICIONADO_DE_VENTANAS;
    int Left=CONF.MARGEN_POSICIONADO_DE_VENTANAS;
    int Height;
    if(CONF.VER_HERRAMIENTAS_COMO == "BARRA")
       Height= Main->ClientHeight - 2*CONF.MARGEN_POSICIONADO_DE_VENTANAS - Main->BarraEstado->Height - Main->pnlTools->Height - Main->ToolBar->Height - 4;
    else
       Height= Main->ClientHeight - 2*CONF.MARGEN_POSICIONADO_DE_VENTANAS - Main->BarraEstado->Height - Main->ToolBar->Height - 4;
    SetBounds(Left,Top,Width,Height);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::CargaNodo(NodoArbol *nodoArbol){

    if( (nodoArbol == NULL) ||(!nodoArbol->EsNodo()) )
       return;

    // Asignamos las variables NodoArbolEditado y CampoSeleccionado.
    NodoArbolEditado=nodoArbol;

    // Hacemos que el campo seleccionado sea el primero:
    if(NodoArbolEditado->hijos->MaxIndexUsado() >= 0)
       CampoEditado= NodoArbolEditado->GetHijo(0,CAMPO);
    else
       CampoEditado=NULL;

    edNombreNodo->Text    = NodoArbolEditado->AsNodo()->nombreDado;
    edNombreNodo->Enabled = true;
    lbNombreNodo->Caption = NodoArbolEditado->AsNodo()->nombre;

    // Tambin hay que actualizar la imagen asociada al nodo.
    if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_X3D){
       if( NodoArbolEditado->EsNodo() )
          Utilidad.GetImagen (imgNodo->Picture,NodoArbolEditado->AsNodo()->datosNodo->icono,CONF.ICONO_GENERAL_NODO_X3D);
       else
          Utilidad.GetImagen (imgNodo->Picture,"",CONF.ICONO_GENERAL_NODO_H3D);

    }else if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D){
       if( NodoArbolEditado->EsNodo() )
          Utilidad.GetImagen (imgNodo->Picture,NodoArbolEditado->AsNodo()->datosNodo->icono,CONF.ICONO_GENERAL_NODO_H3D);
       else
          Utilidad.GetImagen (imgNodo->Picture,"",CONF.ICONO_GENERAL_NODO_H3D);
    }

    // Tenemos toda la informacin del nodo X3D / H3D. Vamos a rellenar los campos.
    // Lo primero es ajustar el nmero de filas.

    // Necestitaremos un puntero para leer la informacin de cada campo.
    Campo *campo;

    // Vamos a obtener el nmero de campos que hay en el nodo. Es importante
    // no usar NodoArbolEditado->AsNodo()->datosNodo->numCampos porque hay nodos
    // especiales como Script (de VMRL) que tiene un nmero indeterminado de
    // campos (puede tener campos repetidos). Asi que calculamos el nmero de
    // campos as:
    int NumeroCampos = 0;
    for(int c=0; c <= NodoArbolEditado->hijos->MaxIndexUsado(); c++){
       NodoArbol *campo = (NodoArbol *)NodoArbolEditado->hijos->Get(c);
       if( (campo != NULL) && campo->EsCampo() )
          NumeroCampos++;
    }

    // Ya tenemos el nmero de campos vlidos -> podemos asignar el n de filas.
    gridCampos->RowCount= NumeroCampos;

    Tipo *tipo;
    NodoArbol *hijo;

    // A continuacin rellenamos los nombres de los campos, y los datos que ha
    // introducido anteriormente el usuario. Las imgenes del tipo de rutado y
    // de los tipos de campos se dibujarn solo cuando sea necesario usando el
    // evento gridCamposDrawCell

    for(int c=0; c < NumeroCampos; c++){
        // Obtenemos el hijo actual.
        hijo=NodoArbolEditado->GetHijo(c,CAMPO);

        if(hijo == NULL)
           Utilidad.FatalError("Se esperaba encontrar un hijo (frmEditorNodos).");

        campo =  hijo->AsCampo()->datosCampo;
        if(campo != NULL){
           gridCampos->Cells[1][c]=campo->nombre;

           // Ahora rellenamos los datos que el usuario ha introducido anteriormente.
           gridCampos->Cells[3][c]=GetDatosCampo(hijo);
        }
    }
    // Con Repaint se actualiza el contenido de la tabla.
    gridCampos->Repaint();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::FormCreate(TObject *Sender)
{
   gridCampos->Canvas->Font=gridCampos->Font;
   gridCampos->Align=alClient;

   // El fondo de las imgenes es azul y hay que pintarlo del mismo color que
   // la ventana (se hace al crear la ventana para hacerlo unsa sola vez).
   // Este es el color del fondo de las flechas.  R 78  G 168  B 252
   // Es necesario saberlo para porder usar FloodFill para pintar el borde
   // del mismo color que la ventana.
   // El orden de los caraceres hexadecimales es
   // 0xFF0000 Azul
   // 0x00FF00 Verde
   // 0x0000FF Rojo

    imgEventIn->Canvas->Brush->Color=clBtnFace;
    imgEventIn->Canvas->FloodFill(0,0,(TColor)0xFCA84E,fsSurface);

    SetBounds(Left,Top,WIDTH_VENTANA,MIN_HEIGHT);

    imgEventOut->Canvas->Brush->Color=clBtnFace;
    imgEventOut->Canvas->FloodFill(0,0,(TColor)0xFCA84E,fsSurface);

    imgExposedField->Canvas->Brush->Color=clBtnFace;
    imgExposedField->Canvas->FloodFill(0,0,(TColor)0xFCA84E,fsSurface);

    imgExposedField_->Canvas->Brush->Color=clBtnFace;
    imgExposedField_->Canvas->FloodFill(0,0,(TColor)0xFCA84E,fsSurface);


    imgField->Canvas->Brush->Color=clBtnFace;
    imgField->Canvas->FloodFill(0,0,(TColor)0xFCA84E,fsSurface);

    lbNombreNodo->Caption="";

    // Hay que desactivar el panel de eventos.
    pnlEventos->Visible=false;

    // Ajustamos la posicin de los los botones que apareceran sobre gridCampos.
    pnlEnlaces->Height=gridCampos->DefaultRowHeight+1;
    pnlEnlaces->Width=btnEnlaceVerde->Width + 4;

    CampoHaCambiado=false;

    Carpetas->ActivePageIndex=0;

   // Colocamos las ventanas.
   if( (frmTools != NULL) && (frmEditorNodos != NULL) && (frmEscena != NULL) ){
      frmTools->Posiciona();
      this->Posiciona();
      frmEscena->Posiciona();
      frmEscena->SetFocus();
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::gridCamposDrawCell(TObject *Sender,
      int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
     // Para no dibujar varias veces por fila solo pintamos cuando la
     // columna es la adecuada.
     if( (NodoArbolEditado==NULL) || (!NodoArbolEditado->EsNodo()) )
        return;

     if(ACol == 0){  // Dibujamos el tipo del campo.
        NodoArbol *campo = NodoArbolEditado->GetHijo(ARow,CAMPO);
        if(campo == NULL)
           return;
        Tipo *tipo = campo->AsCampo()->datosCampo->tipo;
        gridCampos->Canvas->Draw(Rect.Left,Rect.Top,tipo->icono->Bitmap);

     }else if(ACol == 1){  // Hay que refrescar el texto guardado.
        gridCampos->Canvas->Font->Color=COLOR_NOMBRES_CAMPO;
        gridCampos->Canvas->Brush->Color=clBtnFace;
        Font->Color=COLOR_NOMBRES_CAMPO;
        gridCampos->Canvas->TextRect(Rect,Rect.Left+1,Rect.Top+4,gridCampos->Cells[ACol][ARow]);

     }else if(ACol == 2){  // Colocamos las flechas del rutado.
        NodoArbol *campo = NodoArbolEditado->GetHijo(ARow,CAMPO);
        if(campo == NULL)
           return;
        switch(  campo->AsCampo()->datosCampo->rutado ){
            case FIELD        :  gridCampos->Canvas->Draw(Rect.Left,Rect.Top+4,imgField->Picture->Bitmap);        break;
            case EVENTOUT     :  gridCampos->Canvas->Draw(Rect.Left,Rect.Top+4,imgEventOut->Picture->Bitmap);     break;
            case EVENTIN      :  gridCampos->Canvas->Draw(Rect.Left,Rect.Top+4,imgEventIn->Picture->Bitmap);      break;
            case EXPOSEDFIELD :  gridCampos->Canvas->Draw(Rect.Left,Rect.Top+4,imgExposedField->Picture->Bitmap); break;
        }
        gridCampos->Canvas->Brush->Color=clBtnFace;

     }else if(ACol == 3){  // Hay que refrescar el texto guardado.

         gridCampos->Canvas->Font->Color=COLOR_DATOS_CAMPOS;

         NodoArbol *campoHijo;
         campoHijo=NodoArbolEditado->GetHijo(ARow,CAMPO);
         if( (campoHijo == NULL) || (!campoHijo->EsCampo()) )
            return;

         gridCampos->Canvas->TextRect(Rect,Rect.Left+1,Rect.Top+4,GetDatosCampo(campoHijo));
     }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::EditaCampo(NodoArbol *campo){

   if((campo == NULL) || (!campo->EsCampo()) )
     return;

   // Si el nodo actual no coincide con el padre de campo cargamos el padre:
   if(NodoArbolEditado != campo->padre)
      CargaNodo(campo->padre);

   if(NodoArbolEditado == NULL)
      return;

   CampoEditado=campo;

   // Segn cual sea el tab activo hacemos una cosa u otra.
   if(Carpetas->ActivePageIndex == 0){

       // Ahora recorremos los hijos de NodoArbolEditado para seleccionar la fila
       // de gridCampos adecuada:
       NodoArbol *punt;
       int fila=0;

       // Vamos a obtener el nmero de campos que hay en el nodo. Es importante
       // no usar NodoArbolEditado->AsNodo()->datosNodo->numCampos porque hay nodos
       // especiales como Script (de VMRL) que tiene un nmero indeterminado de
       // campos (puede tener campos repetidos). Asi que calculamos el nmero de
       // campos as:
       int numCampos = 0;
       for(int c=0; c <= NodoArbolEditado->hijos->MaxIndexUsado(); c++){
          NodoArbol *campo = (NodoArbol *)NodoArbolEditado->hijos->Get(c);
          if( (campo != NULL) && campo->EsCampo() )
             numCampos++;
       }

       for(int c=0; c < numCampos ;c++){
           punt=NodoArbolEditado->GetHijo(c,CAMPO);
           if((punt != NULL) && punt->EsCampo() ){
              if(punt == CampoEditado) {
                  // Hay que hacer que el control de la aplicacin pase a la fila
                  // asociada al campo seleccionado.

                  // Es necesario para que se desplacen las celdas.
                  gridCampos->Col=3;
                  gridCampos->Row=fila;

                  // Finalmente hay que colocar un botn junto a los datos y el control
                  // edDatosCampo, se hace seleccionando la celda adecuada.
                  if( (fila >= 0) && (fila <  gridCampos->RowCount) )
                     DibujaBotonEnlace_y_TEdit(fila);
                  c=NodoArbolEditado->hijos->MaxIndexUsado();  // Para salir del bucle.
              }
              fila++;
           }
       }
   }else if(Carpetas->ActivePageIndex == 1){
      CargaEventos(CampoEditado);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::imgNodoDblClick(TObject *Sender)
{
   if( (NodoArbolEditado==NULL) || (!NodoArbolEditado->EsNodo()) )
      return;
   // Al hacer un doble click sobre la imagen se abrir una ventana con la
   // informacin del nodo que se est editando actualmente. Si el nodo actual
   // no se encuentra en el gestor de nodos (p.e. caso del nodo Raiz), entonces
   // no se abrir ninguna ventana.
   frmDetallesNodo->Inicia(frmEscena->GN,frmEscena->GT, NodoArbolEditado->AsNodo()->nombre);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::gridCamposSelectCell(
      TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
    // Solo se pueden seleccionar las celdas de la columna que recoge los datos.
    CanSelect=(ACol == 3);

    // Al usar DibujaBotonEnlace_y_TEdit() hay un problema, y es que este evento
    // se ejecuta antes de que se seleccione la celda. As, como en
    // DibujaBotonEnlace_y_TEdit se obtienen las coordenadas de la celda
    // seleccionada debemos, primero seleccionar la celda y luego llamar a
    // DibujaBotonEnlace_y_TEdit. Un modo de hacerlo es usar esta llamada recursiva
    // controlada por s.
    // NOTA: Al ejecutar gridCampos->Row=ARow se vuelve a ejecutar el evento.
    // NOTA: De este modo, al seleccionar la celda adecuada se hace visible y
    //      si es necesario se hace el scroll. Por eso no poda hacerse llamando
    //      a DibujaBotonEnlace_y_TEdit pasndole la nueva celda que se va a
    //      seleccionar porque si esta no es visible fallar la funcin.
    static bool s=true;
    static bool inicio=true;

    if( ((gridCampos->Row!=ARow) && s) || (inicio) ){
       if(inicio)
          inicio=false;
       else
          s=false;

       gridCampos->Row=ARow;
       if( (ACol >= 1) && (ACol <= 3) )
          DibujaBotonEnlace_y_TEdit(ARow);
    }else{
       s=true;
    }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::FormShow(TObject *Sender)
{
   // Ajustamos la altura de la lnea vertical.
   BarraCampos->Top=0;
   BarraCampos->Height=pnlCampos->Height-1;
}
//------------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::edDatosCampoKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
   if( (Key == VK_UP) && (gridCampos->Row > 0) ){    // ARRIBA
       // Es necesario para que se desplacen las celdas.
       gridCampos->Row=gridCampos->Row-1;
       gridCampos->Col=3;
       Key='\0';

       // Finalmente hay que colocar un botn junto a los datos y el control
       // edDatosCampo:
       // DibujaBotonEnlace_y_TEdit(gridCampos->Row);
       // No hace falta pq se ejecuta al seleccionar la celda.
   }
   if( (Key == VK_DOWN) && (NodoArbolEditado != NULL) &&
       (gridCampos->RowCount > gridCampos->Row+1) ){    // Abajo
       // Es necesario para que se desplacen las celdas.
       gridCampos->Row=gridCampos->Row+1;
       gridCampos->Col=3;
       Key='\0';

       // Finalmente hay que colocar un botn junto a los datos y el control
       // edDatosCampo:
       // DibujaBotonEnlace_y_TEdit(gridCampos->Row);
       // No hace falta pq se ejecuta al seleccionar la celda.       
   }
   if( (Key == VK_INSERT) && Shift.Contains(ssShift) ){
      // Se va a intentar pegar el contenido del portapapeles. Lo evitaremos
      // cuando tengamos un evento o un campo de varias lneas o un SFNode o
      // un campo MFNode.
      if( (CampoEditado == NULL) || !CampoEditado->EsCampo() ||
          CampoEditado->EsCampoEvento() || (CampoEditado->AsCampo()->tipoCampo != SIMPLE) ||
          (edDatosCampo->Text == (AnsiString) CADENA_CONTROL_MAS_INTRO) )
       Key = '\0';
   }

   // Pulsar CONTROL + INTRO equivale a pulsar el botn asociado al control.
   if( (Key == VK_RETURN) && (Shift.Contains(ssCtrl)) )
       btnEnlaceVerdeClick(NULL);

   if (Key == VK_RETURN){  // Si se pulsa intro no debeocurrir nada (hay que evitar que
     Key='\0';             // se introduca el caracter 13 ('\r') en la cadena.
     return;
   }
   if( !DatosCampoEditables() ){
      Key='\0';
      return;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::edDatosCampoKeyUp(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
   // A la vez que cambia el contenido de la celda que se est editando iremos
   // guardando los datos que se van introduciendo:
   // Hay que asignarlo al dato asociado al campo que se est editando, para
   // ello se usa CampoEditado.
   if( (CampoEditado != NULL) && CampoEditado->EsCampo() && DatosCampoEditables() ){
      // Solo asignaremos el contenido cuando los datos hayan cambiado.
      if(  CampoEditado->AsCampo()->valor != edDatosCampo->Text ){
         CampoHaCambiado=true;
         CampoEditado->AsCampo()->valor = edDatosCampo->Text;
      }
   }

   // Tambin hay que asignar el nuevo dato a gridCampos:
   gridCampos->Cells[gridCampos->Col][gridCampos->Row]=edDatosCampo->Text;

   if( (Key == VK_RETURN) && (CampoHaCambiado) ){
     frmEscena->Actualiza();
     CampoHaCambiado=false;
   }

   // Cuando se deja pulsado un cursor (vertical) se recorren todas las filas
   // con los valores de los campos. Interesa que al seleccionar la ltima
   // casilla se actualice frmEscena (para que se muestre el cdigo X3D de la
   // ultima modificacin. As este evento se produce solo al final del scroll
   // (cuando soltamos la tecla) y por eso podemos usarlo para actualizar frmEscena.
   if( ((Key == VK_DOWN) || (Key == VK_UP)) && CampoHaCambiado ){
       frmEscena->Actualiza();   // Solo se actualiza al final del scroll.
       CampoHaCambiado=false;
   }

}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::btnEnlaceVerdeClick(TObject *Sender)
{
   if( (NodoArbolEditado == NULL) || (CampoEditado == NULL) || (!CampoEditado->EsCampo()) )
      return;

   TipoCampo *campo = CampoEditado->AsCampo();

   // Distinguimos los siguientes casos.
   if( CampoEditado->EsCampoEvento() ){
       // Si el campo que tenemos es un evento siempre mostraremos el panel de
       // eventos.
        Carga(CampoEditado);
   }else if( (campo->tipoCampo == SFNODE) && (CampoEditado->hijos->NumElementosNoNulos() > 0) ){
       // En este caso tenemos un campo de tipo SFNode que contiene algn hijo.
       // Puede tener 1 o ms hijos. Notar que puede tener ms de un hijo porque
       // pueden ser comentarios. Lo que vamos a hacer es intentar buscar entre
       // los hijos un nodo y editarlo:
       for(int c=0; c <= CampoEditado->hijos->MaxIndexUsado(); c++){
          NodoArbol *hijo = (NodoArbol *)CampoEditado->hijos->Get(c);
          if( (hijo != NULL) && hijo->EsNodo() ){
             frmEscena->TreeView->Selected = hijo->nodoAsociado;
             Carga(hijo);
             return;
          }
       }
   }else if( (campo->tipoCampo == MFNODE) || (campo->tipoCampo == SFNODE) ){
       // Cuando el campo es SFNODE o MFNODE y no es un evento mostramos los
       // nodos que se pueden aadir al campo actual.

       // El nodo se aadir al nodo seleccionado en frmEscena->TreeView, as
       // que eleccionamos el nodo asociado a CampoEditado.
       frmEscena->TreeView->Selected = CampoEditado->nodoAsociado;

       bool enTransform=false;
       AnsiString nombreNodo = frmIndiceNodos->IniciaElegirNodo(frmEscena->GN,enTransform,campo->datosCampo->nombre);
       if(nombreNodo == "")
          return;
       Carga(frmEscena->AnadirNodo(nombreNodo));
       frmEscena->Actualiza();
   }else if(CampoEditado->AsCampo()->nombre == "url"){

       Utilidad.MsgInfo("Remember that another method to get a file's path is to use the visual galleries.");
       AnsiString file;
       if(  (NodoArbolEditado->AsNodo()->nombre == "ImageTexture") ||
            (NodoArbolEditado->AsNodo()->nombre == "MovieTexture")   )
           GetRutaImagen(file);
       else
           GetRutaFile(file);

       if(file != ""){
          // En escena H3D hay que duplicar las \ para que localice los ficheros.
          if( (frmEscena->Raiz != NULL) && (frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D ) )
              Utilidad.DuplicaBarras(file);

          CampoEditado->AsCampo()->valor = file;
          frmEscena->EscenaModificada(false);
          frmEscena->Actualiza();
       }

   }else if ( ((AnsiString)(CampoEditado->AsCampo()->datosCampo->tipo->nombre) == "SFBool") ){
       if( edDatosCampo->Text == "TRUE" ){
          CampoEditado->AsCampo()->valor = "FALSE";
          frmEscena->EscenaModificada(false);
          CampoHaCambiado=true;
       }else if( edDatosCampo->Text == "FALSE" ){
          CampoEditado->AsCampo()->valor = "TRUE";
          frmEscena->EscenaModificada(false);
          CampoHaCambiado=true;
       }
       frmEscena->Actualiza();
   }else{
       // En el resto de los casos tenemos FIELDS o EXPOSEDFIELDS, podramos
       // mostrar el panel de eventos, pero el mucho ms frecuentre asignar
       // valores al campo que crear vnculos de rutado. As por ser el caso
       // ms comun mostraremos directamente el editor de datos.
       frmEdicionCampos->Inicia(CampoEditado,frmEscena->GN,frmEscena->GT);
       frmEscena->Actualiza();
   }

   if(Carpetas->ActivePageIndex == 0)
      gridCampos->Repaint();

   // Habr que refrescar los datos.
   edDatosCampo->Text = GetDatosCampo(CampoEditado);
   edDatosCampo->SelStart=0;
   edDatosCampo->SelLength=edDatosCampo->Text.Length();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::CargaEventos(NodoArbol *campoEventoEditado){

    if( (campoEventoEditado == NULL)        || !campoEventoEditado->EsCampo()       ||
        (campoEventoEditado->padre == NULL) || !campoEventoEditado->padre->EsNodo() ||
        (campoEventoEditado->AsCampo()->datosCampo->rutado == FIELD) ){
       pnlEventos->Visible=false;
       return;
    }

    NodoArbolEditado = campoEventoEditado->padre;

    CargaNodo(campoEventoEditado->padre);

    pnlHint->Visible=false;

    // En primer lugar asignamos la variable de la clase CampoEditado
    CampoEditado=campoEventoEditado;

    Campo *campotmp;
    campotmp = CampoEditado->AsCampo()->datosCampo;

    lbEvento->Caption="Events of type: " + (AnsiString) campotmp->tipo->nombre;

    // Usamos el nombre del tipo para obtener su icono.
    Tipo *tipo;
    tipo=campotmp->tipo;

    if(tipo == NULL)
         return;
    imgTipo->Picture= tipo->icono;

    AnsiString nombreDelCampo=campotmp->nombre;
    if(campotmp->rutado == EXPOSEDFIELD){
       nombreDelCampo= (AnsiString)       "(" + Main->Prefijo_ExpField + ")"
                       + nombreDelCampo + "(" + Main->Sufijo_ExpField + ")";
    }

    // Actualizamos el nombre del campo.
    if(  NodoArbolEditado->AsNodo()->nombreDado.Trim() != "")
       pnlNombreCampo->Caption = NodoArbolEditado->AsNodo()->nombreDado + "." + nombreDelCampo;
    else
       pnlNombreCampo->Caption = nombreDelCampo;

    // Segn el tipo de rutado del campo que estamos editando se podrn pulsar
    // botones u otros:
    sbEventOut->Enabled   = (campotmp->rutado == EXPOSEDFIELD) || (campotmp->rutado == EVENTIN);
    sbEventIn->Enabled    = (campotmp->rutado == EXPOSEDFIELD) || (campotmp->rutado == EVENTOUT);

    Carpetas->ActivePageIndex=1;
    pnlEventos->Visible=true;

    // Cargamos la lista de eventos de toda la escena.
    ActualizarListaEventos();
}
//------------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::CarpetasChange(TObject *Sender)
{
   if( (Carpetas->ActivePageIndex == 0) && (pnlCampos->Visible) ){
       EditaCampo(CampoEditado);
   }else if( (Carpetas->ActivePageIndex == 1) && (pnlEventos->Visible) ){
       if(CampoEditado != NULL)
          CargaEventos(CampoEditado);
       else
          pnlEventos->Visible=false;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::Carga(NodoArbol *elemento){

   // Si se pasa elemento a NULL hay que desactivar todos los controles.
   if( (elemento == NULL) || (frmEscena->Raiz == NULL) ||
       (!elemento->EsRaiz() && !elemento->EsCampo() && !elemento->EsNodo() && !elemento->EsRutado() )   ){

       // Ahorramos tiempo en asignaciones que por implicar las propiedades
       // visible pueden (quizs) tardar cierto tiempo.
       if(NodoArbolEditado == NULL)
          return;

       lbNombreNodo->Caption="";
       edNombreNodo->Enabled=false;
       edNombreNodo->Text="";
       pnlEventos->Visible =false;
       pnlCampos->Visible = false;
       BarraDeEstado->SimpleText="";
       NodoArbolEditado=NULL;
       CampoEditado=NULL;
       imgNodo->Visible=false;
       Carpetas->Repaint();
       pnlCampos->Repaint();
       pnlEventos->Repaint();
       return;
   }

   imgNodo->Visible=true;

   // Especificamos el valor de lbNombreNodo: Si elemento es un nodo o un campo
   // se asignar al cargar el nodo, en otro caso:
   if(elemento->EsRaiz())
       lbNombreNodo->Caption="Root Element";
   else
       lbNombreNodo->Caption="";

   // Especificamos el valor de edNombreNodo: Si elemento es un nodo o un campo
   // se asignar al cargar el nodo, en otro caso:
   if(elemento->EsRaiz()){
      // Hay que especificar el nombre del fichero.
       edNombreNodo->Text = ExtractFileName(elemento->AsRaiz()->fichero);
       edNombreNodo->Enabled=true;
   }else{
       edNombreNodo->Enabled=false;
       edNombreNodo->Text="";
   }

   // Actualizamos imgNodo:
   if(elemento->EsRaiz()){
       if( elemento->AsRaiz()->tipoEscena == ESCENA_X3D)
          Utilidad.GetImagen (imgNodo->Picture,"",CONF.ICONO_GENERAL_NODO_X3D);
       else if( elemento->AsRaiz()->tipoEscena == ESCENA_H3D)
          Utilidad.GetImagen (imgNodo->Picture,"",CONF.ICONO_GENERAL_NODO_H3D);
   }


   // Si elemento es un campo hay que activar el tab adecuado de carpetas. En
   // otro caso no hay que hacer nada.
   if(elemento->EsRutado()){
       Carpetas->ActivePageIndex = 1;
   }else if(elemento->EsCampo()){
       if(elemento->padre == NULL)
          Utilidad.FatalError(" Nodo tipo campo hurfano.");

       if(   (elemento->AsCampo()->datosCampo->rutado == FIELD)    ||
             (elemento->AsCampo()->datosCampo->rutado == EXPOSEDFIELD)  ||
             (elemento->padre->AsNodo()->nombreDado.Trim() == "")  )
          Carpetas->ActivePageIndex = 0;
       else  // EventIn y EventOut
          Carpetas->ActivePageIndex = 1;
   }else{
       Carpetas->ActivePageIndex = 0;
   }

   // Especificamos cuando es visible pnlEventos
   if( (elemento->EsCampo()) &&
       (  // ??? ((elemento->AsCampo()->datosCampo->rutado == EXPOSEDFIELD) ||
          (elemento->AsCampo()->datosCampo->rutado == EVENTIN) ||
          (elemento->AsCampo()->datosCampo->rutado == EVENTOUT)  )   )
      pnlEventos->Visible =  true;
   else if (elemento->EsRutado()){
      pnlEventos->Visible =  true;
   }else
      pnlEventos->Visible =  false;

   // Especificamos cuando es visible pnlCampos
   pnlCampos->Visible = elemento->EsNodo() || elemento->EsCampo();

   if( elemento->EsNodo() && (elemento->AsNodo()->datosNodo->numCampos == 0) )
      pnlCampos->Visible = false;

   // A continuacin vamos a asignar las variables: NodoArbolEditado y CampoEditado
   if(elemento->EsNodo()){
      // En el interior de CargaNodo se asignan tanto NodoArbolEditado como
      // CampoEditado (que ser el primer campo del nodo).
      CargaNodo(elemento);
      // Hay que llamar a Edita para que procese el Campo seleccionado (que
      // puede ser un evento u otro tipo de campo).
      EditaCampo(CampoEditado);
   }else if(elemento->EsCampo()){
        // Solo hay que Cargar el nodo padre de elemento y editar el campo elemento.
        if(elemento->padre == NULL)
           Utilidad.FatalError(" Nodo tipo campo hurfano.");
        CargaNodo(elemento->padre);
        EditaCampo(elemento);
   }else if(elemento->EsRutado()){
        CargaRutado(elemento);
   }else if(elemento->EsRaiz()){
        NodoArbolEditado = elemento;  // El NodoArbol editado ser la raiz.
        CampoEditado = NULL;
   }else{
        NodoArbolEditado = NULL;
        CampoEditado = NULL;
        imgNodo->Visible=false;
   }

   // Rellenamos el contenido de la barra de estado.
   RellenarBarraEstado();

   Carpetas->Repaint();
   pnlCampos->Repaint();
   pnlEventos->Repaint();
}
//-----------------------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::imgTipoClick(TObject *Sender)
{
    if(CampoEditado != NULL)
        frmTipos->Inicia(frmEscena->GT);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::gridEventosSelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
    // Vamos a comprobar si el texto que contiene la celda se muestra por
    // completo en la pantalla. Si no es as habr que hacer aparecer el panel
    // que muestre la informacin completa del campo.
    if(gridEventos->DefaultColWidth <= gridEventos->Canvas->TextWidth(gridEventos->Cells[ACol][ARow])){
        pnlHint->Caption=gridEventos->Cells[ACol][ARow];
        pnlHint->Visible=true;
        pnlHint->Top=gridEventos->Top + ARow * (gridEventos->DefaultRowHeight+1);
        pnlHint->Alignment= (ACol==0) ? taLeftJustify : taRightJustify;
    }else{
        pnlHint->Visible=false;
    }
    CanSelect=true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::gridEventosMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
    // Vamos a comprobar si el texto que contiene la celda se muestra por
    // completo en la pantalla. Si no es as habr que hacer aparecer el panel
    // que muestre la informacin completa del campo.
    int ARow,ACol;
    gridEventos->MouseToCell(X,Y,ACol,ARow);

    if( (ACol >= 0) && (ARow >= 0) &&
       (gridEventos->DefaultColWidth <= gridEventos->Canvas->TextWidth(gridEventos->Cells[ACol][ARow])) ){
        pnlHint->Caption=gridEventos->Cells[ACol][ARow];
        pnlHint->Visible=true;
        pnlHint->Top=gridEventos->Top + ARow * (gridEventos->DefaultRowHeight+1);
        pnlHint->Alignment= (ACol==0) ? taLeftJustify : taRightJustify;
    }else{
        pnlHint->Visible=false;
    }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::pnlEventosMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
   pnlHint->Visible=false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::ActualizarListaEventos(){

   if( (Carpetas->ActivePageIndex == 0) ||
       (NodoArbolEditado == NULL) || !NodoArbolEditado->EsNodo() ||
       (CampoEditado == NULL)     || !CampoEditado->EsCampo()   )
      return;


    // A continuacin vamos a recorrer todos los nodos de la escena y vamos a
    // rellenar gridEventos.

    gridEventos->RowCount=1;       // Empezamos con una fila que inicializamos.
    gridEventos->Cells[0][0]="";
    gridEventos->Cells[1][0]="";

    gridEventos->Objects[0][0] = NULL;
    gridEventos->Objects[1][0] = NULL;

    // Necesitaremos varios contadores de campos:
    int contEventIn=0, contEventOut=0;


    // Es el nombre del tipo asociado a CampoEditado.
    AnsiString tipoEditado;
    tipoEditado= CampoEditado->AsCampo()->datosCampo->tipo->nombre;

    NodoArbol *nodoActual;
    frmEscena->IniciaRecorrerArbol(NODO);
    nodoActual=frmEscena->RecorrerArbol();
    while(nodoActual != NULL){
        // Tenemos que aadir todos los EventIn, EventOuts y ExpoxedField del
        // nodo actual a gridEventos. Recorremos todos los campos de nodoActual
        // y aadimos los eventos.
        NodoArbol *campoActual;
        Campo *datosCampo;

        // Vamos a obtener el nmero de campos que hay en el nodo. Es importante
        // no usar NodoArbolEditado->AsNodo()->datosNodo->numCampos porque hay nodos
        // especiales como Script (de VMRL) que tiene un nmero indeterminado de
        // campos (puede tener campos repetidos). Asi que calculamos el nmero de
        // campos as:
        int numCampos = 0;
        for(int c=0; c <= nodoActual->hijos->MaxIndexUsado(); c++){
           NodoArbol *campo = (NodoArbol *)nodoActual->hijos->Get(c);
           if( (campo != NULL) && campo->EsCampo() )
              numCampos++;
        }

        for(int c=0; c < numCampos ; c++){
            AnsiString tipo;
            campoActual= nodoActual->GetHijo(c,CAMPO);
            datosCampo = campoActual->AsCampo()->datosCampo;

            tipo = datosCampo->tipo->nombre;

            // Solo consideraremos los eventos de la escena que sean del
            // mismo tipo que CampoEditado.
            if(  (tipo == tipoEditado) &&
                 ( nodoActual->AsNodo()->nombreDado.Trim() != "") ) {

                switch ( datosCampo->rutado)
                {
                   case EXPOSEDFIELD:  contEventIn++; contEventOut++; break;
                   case EVENTIN     :  contEventIn++;  break;
                   case EVENTOUT    :  contEventOut++; break;
                }

                // Antes de asignar el valor nos aseguramos de que hay casillas
                // disponibles en grid eventos.
                if( (contEventIn  > gridEventos->RowCount) ||
                    (contEventOut > gridEventos->RowCount) ){

                    // Aadimos una fila ms
                    gridEventos->RowCount++;       // Empezamos con una fila que inicializamos.

                    // Inicializamos los valores.
                   gridEventos->Objects[0][gridEventos->RowCount-1] = NULL;
                   gridEventos->Objects[1][gridEventos->RowCount-1] = NULL;
                   gridEventos->Cells[0][gridEventos->RowCount-1]="";
                   gridEventos->Cells[1][gridEventos->RowCount-1]="";
                }

                // Antes de asignar los datos vamos a preparar la cadena:
                AnsiString dato;
                // El dato est compuesto por el nombre del nodo actual
                // seguido de un punto y el nombre del campo.
                dato= nodoActual->AsNodo()->nombreDado + ".";


                // Finalmente vamos asignar los datos y tambin a usar el
                // array bidimensional de punteros a TObject que tiene
                // gridEventos para guardar una referencia a los punteros
                // NodoArbol asociados a cada campo. Esto facilita mucho
                // aadir los campos a las listas de eventos.
                if( (datosCampo->rutado == EXPOSEDFIELD) ||
                    (datosCampo->rutado == EVENTIN) ){
                    if(datosCampo->rutado == EVENTIN)
                       gridEventos->Cells[1][contEventIn-1] = dato + datosCampo->nombre;
                    else // (caso EXPOSEDFIELD)
                       gridEventos->Cells[1][contEventIn-1] = dato + Main->Prefijo_ExpField + datosCampo->nombre;
                    gridEventos->Objects[1][contEventIn-1] = (TObject *) campoActual;
                }

                if( (datosCampo->rutado == EXPOSEDFIELD) ||
                    (datosCampo->rutado == EVENTOUT) ){
                    if(datosCampo->rutado == EVENTOUT)
                       gridEventos->Cells[0][contEventOut-1] = dato + datosCampo->nombre;
                    else // (caso EXPOSEDFIELD)
                       gridEventos->Cells[0][contEventOut-1] = dato + datosCampo->nombre + Main->Sufijo_ExpField;
                    gridEventos->Objects[0][contEventOut-1] =  (TObject *) campoActual;
                }
            }
        }
        nodoActual=frmEscena->RecorrerArbol();
    }

    // Finalmente hay que cargar los datos que afectan al campo actual, es decir
    // los eventos rutados anteriormente al campo actual o desde el campo actual.

    // Lo primero es limpiar las listas:
    listEventIn->Items->Clear();
    listEventOut->Items->Clear();

    // Vamos a buscar todos los vinculos de rutado en los que aparece el campo
    // editado como vinculo out o in para rellenar las listas.
    frmEscena->IniciaRecorrerArbol(RUTADO);

    NodoArbol *p;
    p=frmEscena->RecorrerArbol();
    AnsiString nombreNodo  =  NodoArbolEditado->AsNodo()->nombreDado.Trim();
    AnsiString nombreCampo =  CampoEditado->AsCampo()->nombre.Trim();
    AnsiString nombreCampoIn,nombreCampoOut;
    // Antes de seguir consideramos los prefijos y sufijos del caso EXPOSEDFIELD
    if(  CampoEditado->AsCampo()->datosCampo->rutado == EXPOSEDFIELD ){
       nombreCampoIn = Main->Prefijo_ExpField + nombreCampo;
       nombreCampoOut= nombreCampo + Main->Sufijo_ExpField;
    }else{
       nombreCampoIn = nombreCampo;
       nombreCampoOut= nombreCampo;
    }
    while(p != NULL){
        TipoRutado *r = p->AsRutado();
        if( (r->nodoOut == nombreNodo) && (r->campoOut == nombreCampoOut) )
            listEventIn->Items->Append(  r->nodoIn + "." + r->campoIn );
        if( (r->nodoIn == nombreNodo) && (r->campoIn == nombreCampoIn) )
            listEventOut->Items->Append(  r->nodoOut + "." + r->campoOut );
        p=frmEscena->RecorrerArbol();
    }
    // Con esto se ha rellenado toda la lista de eventos que se relacionan con el
    // campo editado.
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::pnlHintMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   // Queremos hacer que cuando se haga un click sobre el panel se seleccione
   // la celda que est debajo.

   // X,Y son coordenadas relativas al panel pnlHint y hay que convertirlas a
   // coordenadas relaticas al gridEventos:
   // X= X + pnlHint->Left - gridEventos->Left;  No hace falta porque Left vale lo mismo en los dos controles.
   Y= Y + pnlHint->Top - gridEventos->Top;

   // Ahora si podemos hacer la conversin.
   int ACol,ARow;
   gridEventos->MouseToCell(X,Y,ACol,ARow);
   if( (ACol >= 0) && (ARow >= 0) ){
      gridEventos->Row=ARow;
      gridEventos->Col=ACol;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::sbEventOutClick(TObject *Sender)
{
   // Vamos a aadir el campo seleccionado a la lista de eventos de entrada.
   if( (gridEventos->Col!=0)      || (gridEventos->Row < 0) ||
       (NodoArbolEditado == NULL) || !NodoArbolEditado->EsNodo() ||
       (CampoEditado == NULL)     || !CampoEditado->EsCampo()   )
      return;


   if(NodoArbolEditado->AsNodo()->nombreDado.Trim() == ""){
      Utilidad.MsgInfo("To create ROUTE links it is necessary to name the implied nodes.");
      return;
   }

   // Vamos a usar los punteros a TObject de la gridEventos para saber qu campo
   // se ha seleccionado -> Realmente son los punteros a ArbolNodo de la escena.
   NodoArbol *punt;
   punt =(NodoArbol *) gridEventos->Objects[gridEventos->Col][gridEventos->Row];

   // punt ser NULL cuando la casilla est en blanco.
   if(punt == NULL)
      return;

   // Hay que comprobar que no se ha rutado un campo consigo mismo (exposedfield).
   if(punt == CampoEditado){
      Utilidad.MsgInfo("Auto-links are nor allowed.");
      return;
   }

   // Hay que aadir un nuevo vinculo de rutado a la escena.
   // punt es el evento de salida y CampoEditado el de entrada, por eso:
   frmEscena->AnadirVinculoRutado(frmEscena->Raiz,punt,CampoEditado);

   // Aadimos este campo a la lista de eventos de salida.
   if( (punt != NULL) && (punt->padre != NULL) )
       listEventOut->Items->Append( gridEventos->Cells[gridEventos->Col][gridEventos->Row] );

}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::sbEventInClick(TObject *Sender)
{
   // Vamos a aadir el campo seleccionado a la lista de eventos de salida.
   if( (gridEventos->Col!=1)      || (gridEventos->Row < 0) ||
       (NodoArbolEditado == NULL) || !NodoArbolEditado->EsNodo() ||
       (CampoEditado == NULL)     || !CampoEditado->EsCampo()   )
      return;

   if(NodoArbolEditado->AsNodo()->nombreDado.Trim() == ""){
      Utilidad.MsgInfo("To create ROUTE links it is needed to name the implied nodes.");
      return;
   }
   // Vamos a usar los punteros a TObject de la gridEventos para saber qu campo
   // se ha seleccionado -> Realmente son los punteros a ArbolNodo de la escena.
   NodoArbol *punt;
   punt =(NodoArbol *) gridEventos->Objects[gridEventos->Col][gridEventos->Row];

   // punt ser NULL cuando la casilla est en blanco.
   if(punt == NULL)
      return;

   // Hay que comprobar que no se ha rutado un campo consigo mismo.
   if(punt == CampoEditado){
      Utilidad.MsgInfo("Auto-links are nor allowed.");
      return;
   }

   // Hay que aadir un nuevo vinculo de rutado a la escena.
   // punt es el evento de salida y CampoEditado el de entrada, por eso:
   frmEscena->AnadirVinculoRutado(frmEscena->Raiz,CampoEditado,punt);

   // Aadimos este campo a la lista de eventos de salida.
   if( (punt != NULL) && (punt->padre != NULL) )
       listEventIn->Items->Append( gridEventos->Cells[gridEventos->Col][gridEventos->Row] );

}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::gridCamposMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   int ACol,ARow;
   gridCampos->MouseToCell(X,Y,ACol,ARow);
   if( (CampoEditado != NULL) && (ACol == 0) )
        frmTipos->Inicia(frmEscena->GT);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::edNombreNodoExit(TObject *Sender)
{
    if(NodoArbolEditado == NULL)
       return;

    // Ms adelante necesitaremos saber si la cadena est en blanco o no (ojo
    // pq puede tener espacios).
    bool enBlanco= (edNombreNodo->Text.Trim()).Length() == 0;

    // Tambin ser necesario saber si en la escena hay vinculos de rutado con
    // en los que aparezca el nombre del nodo que se est editando:
    int numVinculosRutado=0;
    int numUSEs =0;
    NodoArbol *nodoActual;


    if(NodoArbolEditado->EsNodo()){
        AnsiString nombreNodoEditado  =  NodoArbolEditado->AsNodo()->nombreDado.Trim();

        frmEscena->IniciaRecorrerArbol(TNA_INDEFINIDO,true);
        nodoActual=frmEscena->RecorrerArbol();
        while(nodoActual != NULL){
            // En este caso comprobamos si NodoArbolEditado aparece en algn
            // vinculo de rutado o en alguna sentencia USE.
            if(nodoActual->EsRutado()){
               TipoRutado *p= nodoActual->AsRutado();
               if( (p->nodoIn == nombreNodoEditado) || (p->nodoOut == nombreNodoEditado) )
                   numVinculosRutado++;
            }else if(nodoActual->EsUSE()){
               if( nodoActual->AsUSE()->nombreDado == nombreNodoEditado )
                   numUSEs++;
            }
            nodoActual=frmEscena->RecorrerArbol();
        }
    }

   // En X3D puede haber nombres de nodos repetidos y nodos sin nombre as
   // que no hay que hacer ninguna restriccion a los nombres de los nodos. Si
   // es necesario que si se cambia el nombre del nodo se avise con un mensaje
   // si el cambio de nombre afecta a algn evento.

   //  Adems la raiz debe tener un nombre no nulo. As en esta funcin vamos a
   // avisar que se debe especificar un nombre para la raiz pero no vamos a
   // obligar a dar ese nombre porque ya se har cuando se vaya a escribir el
   // fichero a disco.

   if(NodoArbolEditado->EsRaiz()){         // --------------------  RAIZ ----
       // Hay que cambiar el nombre en la estructura de datos de memoria y
       // tambin el nombre que aparece en el TreeView:

       AnsiString NombreAnterior;
       NombreAnterior = ExtractFileName(NodoArbolEditado->AsRaiz()->fichero);

       bool haCambiado = (edNombreNodo->Text != NombreAnterior );

       if(!haCambiado)
         return;

       // Hay que borrar el fichero de prueba que se haya podido usar para ejecutar
       // la escena.
       frmEscena->BorrarFicheroPrueba( frmEscena->Raiz->AsRaiz()->fichero  );

       AnsiString tmp=edNombreNodo->Text.LowerCase();
       // Vamos a comprobar que tiene la extensin WRL, si no la tiene se la aadimos.
       if(0 == tmp.Pos(EXTENSION_X3D))
          // En este caso no existe la extensin -> La aadimos siempre que
          // la cadena no est vaca.
          if(edNombreNodo->Text.Trim() != "")
              edNombreNodo->Text=edNombreNodo->Text + (AnsiString)EXTENSION_X3D;

       AnsiString ruta = ExtractFileDir(NodoArbolEditado->AsRaiz()->fichero);
       if( (ruta.Length() > 0) && (ruta[ruta.Length()] != '\\')  )
          ruta+= '\\';
       ruta+=edNombreNodo->Text;

       if( NodoArbolEditado->AsRaiz()->fichero != ruta  )
           frmEscena->EscenaModificada(false);

       NodoArbolEditado->AsRaiz()->fichero = ruta;

       NodoArbolEditado->nodoAsociado->Text=frmEscena->GetNombreTreeView(NodoArbolEditado);

   }else if( NodoArbolEditado->EsNodo() ){ // --------------------- NODO ----

       AnsiString NombreAnterior=NodoArbolEditado->AsNodo()->nombreDado;

       bool haCambiado = (edNombreNodo->Text !=  NombreAnterior);

       // solo procesaremos cuando la escena haya cambiado.
       if(!haCambiado)
          return;

       frmEscena->EscenaModificada(true);
       // Actualizamos el contenido de la estructura de datos en memoria:
       NodoArbolEditado->AsNodo()->nombreDado = edNombreNodo->Text;
       bool quiereCambiarVinculos=false;
       if(numVinculosRutado){
            // Habra que borrar los vnculos de rutado pero es mejor usar otro
            // enfoque para no complicar el cdigo -> Vamos a dejar que haya
            // errores en la estructura de modo que el programa funcione
            // correctamente y que sea la funcin que detecta errores la que se
            // encargue de detectarlos y avisar cuando se salve la escena o se
            // ejecute.
            AnsiString msg = "The change made in the node's identifier affects to " + IntToStr(numVinculosRutado) + " ROUTE link";
            if(numVinculosRutado != 1)
               msg+="s";
            msg+= ". Do you wish to update the affected links?";
            quiereCambiarVinculos= (mrYes == frmUtilidad->Pregunta(msg) );
       }
       // Ocurre los mismo con las sentencias USE:
       bool quiereCambiarUSEs=false;
       if(numUSEs){
            AnsiString msg = "The change made in the node's identifier affects to " + IntToStr(numUSEs) + " USES sentence";
            if(numUSEs != 1)
               msg+="s";
            msg+= ". Do you wish to update the affected USE sentences?";
            quiereCambiarUSEs= (mrYes == frmUtilidad->Pregunta(msg) );
       }

       if( !enBlanco && (numVinculosRutado || numUSEs) && (quiereCambiarVinculos || quiereCambiarUSEs) ){
          // En este caso iniciamos una lectura lineal para borrar o cambiar el
          // nombre de los vinculos de rutado y USEs afectados.
          frmEscena->IniciaRecorrerArbol(TNA_INDEFINIDO,true);
          NodoArbol *n = frmEscena->RecorrerArbol();
          bool Cambiado=false;
          while(n != NULL){
             if( n->EsUSE() && quiereCambiarUSEs && (NombreAnterior == n->AsUSE()->nombreDado ) ){

                n->AsUSE()->nombreDado = NodoArbolEditado->AsNodo()->nombreDado;
                Cambiado=true;

             }else if( (n->EsRutado()) && (quiereCambiarVinculos) ){
                 if(NombreAnterior == n->AsRutado()->nodoIn) {

                     n->AsRutado()->nodoIn = NodoArbolEditado->AsNodo()->nombreDado;
                     Cambiado=true;

                 }else if(NombreAnterior == n->AsRutado()->nodoOut){

                     n->AsRutado()->nodoOut = NodoArbolEditado->AsNodo()->nombreDado;
                     Cambiado=true;
                 }
             }
             n = frmEscena->RecorrerArbol();
          }
          if(Cambiado)
             Utilidad.MsgInfo(" The affected items have been updated.");
       }
   }
   // Si lo que se muestra es el texto X3D hay que actualizarlo.
   frmEscena->Actualiza();

   ActualizarListaEventos();
}
//---------------------------------------------------------------------------
AnsiString __fastcall TfrmEditorNodos::GetDatosCampo(NodoArbol *campo){

   if( (campo == NULL) || (!campo->EsCampo()) || (NodoArbolEditado == NULL) )
      return "";

   AnsiString cadena;
   if( (campo->AsCampo()->datosCampo->rutado == EVENTIN) ||
       (campo->AsCampo()->datosCampo->rutado == EVENTOUT ) )
         cadena = "(Event)";
   else{
       // En este caso caso tenemos que distinguir qu tipo de campo tenemos:
       if(  campo->AsCampo()->tipoCampo == SFNODE  ){
            // En este caso distinguimos si el campo SFNODE ha sido asignado o no.
            if(campo->GetHijo(0,NODO) == NULL)
               cadena = "NULL";
            else{
               if( (campo->GetHijo(0,NODO))->dato != NULL  ){
                  void *p;
                  p = (campo->GetHijo(0,NODO))->dato;
                  cadena = (AnsiString) "[" + ((TipoNodo *)p)->nombre + "]";
               }else
                  cadena = "";
            }

       }else if (  campo->AsCampo()->tipoCampo == MFNODE  ){
            // En este caso solo escribiremos (MFNode):
            cadena = "(MFNode)";
       }else if (  campo->AsCampo()->tipoCampo == SIMPLE){
            // En este caso tenemos que ver si hay retornos de carro o no.
            // si los hay escribiremos "(CTRL+Enter)"
            char *cad =  campo->AsCampo()->valor.c_str();
            bool RCs=false;

            if(cad != NULL){
                int c=0;
                while( (cad[c] != '\0') && (!RCs) ){
                   if( (cad[c] == char(13))  ||  (cad[c] == char(10)) )
                      RCs=true;
                   c++;
                }
                if(RCs)
                    cadena = CADENA_CONTROL_MAS_INTRO;
                else
                    cadena = campo->AsCampo()->valor;
            }else
                cadena = "";
       }
   }
   return cadena;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmEditorNodos::DatosCampoEditables(){

   if( (CampoEditado == NULL) || (!CampoEditado->EsCampo()) || (NodoArbolEditado == NULL) )
      return false;

   if( (CampoEditado->AsCampo()->datosCampo->rutado == EVENTIN) ||
       (CampoEditado->AsCampo()->datosCampo->rutado == EVENTOUT ) ){
         return false;
   }else{
       // En este caso caso tenemos que distinguir qu tipo de campo tenemos:
       if(  CampoEditado->AsCampo()->tipoCampo == SFNODE  ){
          return false;

       }else if (  CampoEditado->AsCampo()->tipoCampo == MFNODE  ){
          return false;

       }else if (  CampoEditado->AsCampo()->tipoCampo == SIMPLE){
            // En este caso tenemos que ver si hay retornos de carro o no.
            // si los hay escribiremos "(CTRL+Enter)"
            char *cad =  CampoEditado->AsCampo()->valor.c_str();
            bool RCs=false;

            if(cad != NULL){
                int c=0;
                while( (cad[c] != '\0') && (!RCs) ){
                   if( (cad[c] == char(13))  ||  (cad[c] == char(10)) )
                      RCs=true;
                   c++;
                }
                if(RCs)
                    return false;
                else
                    return true;

            }else{
                return true;
            }
       }
   }
   return false;
}
//------------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::edDatosCampoExit(TObject *Sender)
{
   if(CampoHaCambiado){
      frmEscena->Actualiza();
      CampoHaCambiado=false;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::edDatosCampoKeyPress(TObject *Sender,
      char &Key)
{
   if( (VK_RETURN == Key) || ('\n' == Key) )
      Key=0;  // As evitamos el sonido de windows.

   if( !DatosCampoEditables() ){
      Key='\0';
      return;
   }
   frmEscena->EscenaModificada(false);
   CampoHaCambiado=true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::edNombreNodoKeyUp(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
   // Al pulsar intro se valida la informacin que hay dentro y por eso es
   // equivalente a salir del control.
   if(Key == VK_RETURN)
      edNombreNodoExit(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::FormDeactivate(TObject *Sender)
{
   // El evento OnExit de edNombreNodo se usa para actualizar el valor del
   // texto edNombreNodo pero hay un problema: Este evento no se ejecuta cuando
   // el foco de la aplicacin pasa a otro control de otra ventana. Para
   // solucionarlo usamos este evento -> y as llamamos a la funcion que
   // actualiza los datos cuando el formulario pierde el control.
   edNombreNodoExit(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::RellenarBarraEstado(){

  if(NodoArbolEditado == NULL){
     BarraDeEstado->SimpleText="";
     return;
  }

  if(NodoArbolEditado->EsRaiz()){
       BarraDeEstado->SimpleText= "";
       return;
  }else if(NodoArbolEditado->EsNodo()){

       // Necestitaremos un puntero para leer la informacin de cada campo.
       Campo *campo;
       NodoArbol *hijo;

       // Para la informacin de la barra de estado necesitamos contar los tipos
       // de campo.
       int contField=0,contExposedField=0,contEventOut=0,contEventIn=0;

       // Vamos a obtener el nmero de campos que hay en el nodo. Es importante
       // no usar NodoArbolEditado->AsNodo()->datosNodo->numCampos porque hay nodos
       // especiales como Script (de VMRL) que tiene un nmero indeterminado de
       // campos (puede tener campos repetidos). Asi que calculamos el nmero de
       // campos as:
       int NumeroCampos = 0;
       for(int c=0; c <= NodoArbolEditado->hijos->MaxIndexUsado(); c++){
          NodoArbol *campo = (NodoArbol *)NodoArbolEditado->hijos->Get(c);
          if( (campo != NULL) && campo->EsCampo() )
             NumeroCampos++;
       }

       // Vamos a hacer un bucle para contar los elementos del nodo actual.
       for(int c=0; c < NumeroCampos; c++){
           // Obtenemos el hijo actual.
           hijo=NodoArbolEditado->GetHijo(c,CAMPO);

           if(hijo == NULL)
              return;

           campo=  hijo->AsCampo()->datosCampo;
           if(campo != NULL){
              // Contamos el tipo de campos:
              if(campo->rutado == EVENTOUT)
                  contEventOut++;
              else if(campo->rutado == EVENTIN)
                  contEventIn++;
              else if(campo->rutado == EXPOSEDFIELD)
                  contExposedField++;
              else if(campo->rutado == FIELD)
                  contField++;
           }
       }
       // Actualizamos el contenido de la barra de estado.
       BarraDeEstado->SimpleText=  (AnsiString) "Total Fields:" + IntToStr(NumeroCampos)
                                   + " -> " 
                                   + IntToStr(contField)        + " fields, "
                                   + IntToStr(contExposedField) + " expfld, "
                                   + IntToStr(contEventIn)      + " eventIn, "
                                   + IntToStr(contEventOut)     + " eventOut.";
       return;
  }
  // En el resto de casos dejaremos vaca la barra.
  BarraDeEstado->SimpleText="";
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::CargaRutado(NodoArbol *elemento){

   static int nivelRecursivo=0;

   if( (elemento == NULL) || (!elemento->EsRutado()) )
      return;

   // Vamos a recorrer todos los nodos de la escena hasta encontrar un nodo que
   // aparezca en el vinculo de rutado.
   static bool inout =true;
   inout= !inout;

   // Vamos a usar una variable static para buscar alternativamente el evento
   // de entrada o de salida.
   AnsiString Nodo,Campo;
   if(inout){
      Nodo =  elemento->AsRutado()->nodoIn;
      Campo = elemento->AsRutado()->campoIn;
   }else{
      Nodo =  elemento->AsRutado()->nodoOut;
      Campo = elemento->AsRutado()->campoOut;
   }

   // Vamos a recorrer la escena para buscar uno de los nodos que interviene en
   // el rutado:
   frmEscena->IniciaRecorrerArbol(NODO);
   NodoArbol *nodo= frmEscena->RecorrerArbol();
   while( nodo != NULL){
      if( Nodo == nodo->AsNodo()->nombreDado){
          // En este caso hemos encontrado el nodo. Ahora buscamos el campo:
          NodoArbol *campo;
          // Vamos a obtener el nmero de campos que hay en el nodo. Es importante
          // no usar NodoArbolEditado->AsNodo()->datosNodo->numCampos porque hay nodos
          // especiales como Script (de VMRL) que tiene un nmero indeterminado de
          // campos (puede tener campos repetidos). Asi que calculamos el nmero de
          // campos as:
          int numCampos = 0;
          for(int c=0; c <= nodo->hijos->MaxIndexUsado(); c++){
             NodoArbol *campo = (NodoArbol *)nodo->hijos->Get(c);
             if( (campo != NULL) && campo->EsCampo() )
                numCampos++;
          }

          for(int c=0; c < numCampos ; c++){
             campo= nodo->GetHijo(c,CAMPO);
             // Hay un problema al comparar los campos: Los prefijos y sufijos.
             AnsiString nombreCampo;
             if(campo != NULL){
                nombreCampo=campo->AsCampo()->nombre;
                if( (nombreCampo == Campo) ||
                    ( (nombreCampo+Main->Sufijo_ExpField) == Campo) ||
                    ( (Main->Prefijo_ExpField+nombreCampo) == Campo)   ){
                   // Ya hemos encontrado el campo deseado.
                   CargaEventos(campo);
                   // Reseteamos el contador de niveles recursivos:
                   nivelRecursivo = 0;
                   return;
                }
             }
          }
      }
      nodo = frmEscena->RecorrerArbol();
   }

   // En este caso hemos llegado al final de la bsqueda y no hemos conseguido
   // localizar el campo que buscbamos. Inicialmente hicimos una eleccin segn
   // indicaba inout. Debemos intentar buscar siguiendo la otra alternativa. Por
   // ello vamos ha hacer una llamada recursiva, solo una y si tampoco lo
   // encontramos no podremos cargar el evento:
   nivelRecursivo++;
   if(nivelRecursivo == 1){
      CargaRutado(elemento);
   }else{ // (nivelRecursivo == 2){
      // En este caso no se ha encontrado el campo eventin ni el eventout:
      nivelRecursivo = 0;
      Carga(NULL);
   }
}
//------------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::edNombreNodoKeyPress(TObject *Sender,
      char &Key)
{
    // Cuando el contenido de edNombreNodo cambie con respecto a lo que hay
    // guardado en memoria, marcaremos la escena como modificada.
    if(NodoArbolEditado == NULL)
      return;
    AnsiString c1 = edNombreNodo->Text + (AnsiString) Key;
    if(NodoArbolEditado->EsRaiz()){
       AnsiString c2;
       c2 = ExtractFileName( NodoArbolEditado->AsRaiz()->fichero  );
       if( c1.Trim() != c2.Trim() )
           frmEscena->EscenaModificada(false);

    }else if(NodoArbolEditado->EsNodo()){
       if( NodoArbolEditado->AsNodo()->nombreDado.Trim() != c1.Trim() )
           frmEscena->EscenaModificada(false);
    }
    if(VK_RETURN == Key)
       Key=0;  // As evitamos el sonido de windows.

}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::GetRutaImagen(AnsiString &ruta){

   // Abrimos el cuadro de dilogo.
   Main->dlgAbrirImg->FileName= "";
   Main->dlgAbrirImg->InitialDir=CONF.LAST_CARPETA_USADA;
   bool devuelto=false;

   // Hay que usar try-catch para evitar las excepciones que saltan cuando
   // se selecciona un archivo que no sea una imagen del tipo que se puede
   // mostrar en dlgAbrirImg.
   try{ devuelto = Main->dlgAbrirImg->Execute();  } catch (...){   }

   if(!devuelto)
      return;

   CONF.LAST_CARPETA_USADA= GetCurrentDir();
   CONF.LosDatosHanCambiado();

   ruta= "\"" + Main->dlgAbrirImg->FileName + "\"";

   // Se produce una excepcin de tipo EInvalidGraphic cuando se elige un fichero
   // que no es de los tipos que se pueden ver (p.e. png) Pero en el punto EXE
   // no aparece la ventana.
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::GetRutaFile(AnsiString &ruta){

   // Abrimos el cuadro de dilogo.
   Main->dlgAbrir->FileName= "*.*";
   Main->dlgAbrir->FilterIndex = 2;
   Main->dlgAbrir->InitialDir=CONF.LAST_CARPETA_USADA;
   bool devuelto=false;

   // Hay que usar try-catch para evitar posibles excepciones.
   try{ devuelto = Main->dlgAbrir->Execute();  } catch (...){   }

   if(!devuelto)
      return;

   CONF.LAST_CARPETA_USADA= GetCurrentDir();
   CONF.LosDatosHanCambiado();

   ruta= "\"" + Main->dlgAbrir->FileName + "\"";
}
//------------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::CarpetasDrawTab(
      TCustomTabControl *Control, int TabIndex, const TRect &Rect,
      bool Active)
{
   Carpetas->Brush->Color=clSilver;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::FormCanResize(TObject *Sender,
      int &NewWidth, int &NewHeight, bool &Resize)
{
  Resize = true;
  NewHeight = (NewHeight >= MIN_HEIGHT) ? NewHeight : MIN_HEIGHT;
  NewWidth=WIDTH_VENTANA;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::pnlCamposResize(TObject *Sender)
{
   BarraCampos->Height=pnlCampos->ClientHeight;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::GetFoco(){

   if(NodoArbolEditado == NULL)
      return;

   TWinControl *control=NULL;

   // Vamos a determinar que control debe obtener el foco en funcin del
   // tipo de nodo que estemos editando NodoArbolEditado->tipo.
   // Notar que no es necesario hacer comprobaciones sobre si el control
   // est oculto o activo porque antes de pasar el foco usamos la funcion CanFocus.
   if( (frmEscena->TreeView->Selected != NULL) &&
       (  ((NodoArbol *)frmEscena->TreeView->Selected->Data)->EsNodo()) ){
      control=edNombreNodo;
   }else if(NodoArbolEditado->EsRaiz()){
      control=edNombreNodo;
   }else if( (NodoArbolEditado != NULL) && (CampoEditado == NULL) ){
      control=edNombreNodo;
   }else if( (CampoEditado != NULL) && CampoEditado->EsCampo() ){
      if(Carpetas->ActivePageIndex == 0)
         control=edDatosCampo;
      else if(Carpetas->ActivePageIndex == 1)
         control=gridEventos;
   }
   // Ahora intentamos pasar el foco a control.
   if( (control != NULL) && control->CanFocus() ){
      Main->LiberarFoco();
      this->SetFocus();
      this->FocusControl(control);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::edDatosCampoDblClick(TObject *Sender)
{
   btnEnlaceVerdeClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::Cortar(){

    TEdit *ed=NULL;
    // Solo haremos algo cuando el control seleccionado sea edDatosCampo o
    // edNombreNodo.
    if     (this->ActiveControl == edDatosCampo)
       ed=edDatosCampo;
    else if(this->ActiveControl == edNombreNodo)
       ed=edNombreNodo;
    if(ed == NULL)
       return;
    // Cortamos la seleccion actual al portapapeles.
    ed->CutToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::Copiar(){

    TEdit *ed=NULL;
    // Solo haremos algo cuando el control seleccionado sea edDatosCampo o
    // edNombreNodo.
    if     (this->ActiveControl == edDatosCampo)
       ed=edDatosCampo;
    else if(this->ActiveControl == edNombreNodo)
       ed=edNombreNodo;
    if(ed == NULL)
       return;
    // Copiamos la seleccion actual al portapapeles.
    ed->CopyToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::Pegar(){

    TEdit *ed=NULL;
    // Solo haremos algo cuando el control seleccionado sea edDatosCampo o
    // edNombreNodo.
    if( (this->ActiveControl == edDatosCampo) && (CampoEditado != NULL) &&
        CampoEditado->EsCampo() && !CampoEditado->EsCampoEvento() &&
        (CampoEditado->AsCampo()->tipoCampo == SIMPLE) &&
        (edDatosCampo->Text != (AnsiString) CADENA_CONTROL_MAS_INTRO) )
       // Solo se podr pegar texto en edDatosCampo cuanto el campo editado
       // no sea un evento, ni un campo SFNode, ni MFNode ni sea un campo que
       // ya contenga varias lneas.
       ed=edDatosCampo;
    else if(this->ActiveControl == edNombreNodo)
       ed=edNombreNodo;
    if(ed == NULL)
       return;
    // Pegamos el contenido del portapapeles.
    ed->PasteFromClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::FormShortCut(TWMKey &Msg, bool &Handled)
{
  // Vamos a gestionar las pulsaciones del Tab de un modo especial. Queremos
  // que el control pase de edNombre nodo a edDatosCampo y viceversa:

  // El bit 30 de Msg.KeyData es 1 si la tecla est pulsada antes de que se produzca
  // el evento.
  if(0x40000000 & Msg.KeyData)
     return;

  if( (Msg.CharCode == VK_TAB) && (CampoEditado != NULL) && (NodoArbolEditado != NULL) ){
     // Aqui sabemos que se ha pulsado el tabulador y que el editor de nodos
     // est editando un nodo. Ahora distinguimos que control es el que tiene
     // el foco:
     if( (ActiveControl == edNombreNodo) && pnlCampos->Visible &&
         (Carpetas->ActivePageIndex == 0) ){
         // edNombreNodo tiene el foco y podemos pasarlo a edDatosCampo-> Lo hacemos:
         this->FocusControl(edDatosCampo);
         Handled =true;
     }else if( (ActiveControl == edDatosCampo) ){
         // edDatosCampo tiene el foco y vamos a pasarlo a edNombreNodo:
         this->FocusControl(edNombreNodo);
         Handled =true;
     }
  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEditorNodos::gridCamposMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   if(ActiveControl != edDatosCampo)
      this->FocusControl(edDatosCampo);
}
//---------------------------------------------------------------------------

