//
//     frmEdicionCampos  
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Recoge recoger los datos asociados a un campo.
*/


//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "frmEdicionCampos_.h"
#include "Utilidad_.h"
#include "Configuracion_.h"
#include "frmDetallesNodo_.h"
#include "frmTipos_.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmEdicionCampos *frmEdicionCampos;
//---------------------------------------------------------------------------
__fastcall TfrmEdicionCampos::TfrmEdicionCampos(TComponent* Owner)
        : TForm(Owner)
{
   CampoEditado==NULL;
   GN=NULL;
   GT=NULL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmEdicionCampos::sbVolverClick(TObject *Sender)
{
   Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEdicionCampos::Inicia(NodoArbol *campo,GestorNodos *GN_,GestorTipos *GT_){

   if( (campo == NULL) || (GN_ == NULL) || (GT_ == NULL) || (!campo->EsCampo()) )
      return;

   // Actualizamos las variables de la clase
   CampoEditado=campo;
   GN=GN_;
   GT=GT_;
   memo->Text=CampoEditado->AsCampo()->valor;

   // Actualizamos los indicadores TLabel
   lbCampo->Caption= CampoEditado->AsCampo()->nombre;
   if(campo->padre != NULL)
        lbNodo->Caption= CampoEditado->padre->AsNodo()->nombre;

   // Solo falta cargar las imgenes asociadas al nodo y al tipo del campo.
   Nodo *nodo;
   nodo= CampoEditado->padre->AsNodo()->datosNodo;
   if(nodo != NULL){
       if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D )
          Utilidad.GetImagen(imgNodo->Picture,nodo->icono,CONF.ICONO_GENERAL_NODO_H3D);
       else if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_X3D)
          Utilidad.GetImagen(imgNodo->Picture,nodo->icono,CONF.ICONO_GENERAL_NODO_X3D);
   }

   // Cargamos la imgen asociada al tipo.
   if(CampoEditado->AsCampo()->datosCampo->tipo->icono != NULL)
      imgTipo->Picture= CampoEditado->AsCampo()->datosCampo->tipo->icono;

   // Finalmente se muestra la ventana.
   ShowModal();
}
//-----------------------------------------------------------------------------
void __fastcall TfrmEdicionCampos::sbAceptarClick(TObject *Sender)
{
   if( CampoEditado->AsCampo()->valor != memo->Text );
      frmEscena->EscenaModificada(false);

   if(CampoEditado != NULL)
      CampoEditado->AsCampo()->valor = memo->Text;

   Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEdicionCampos::imgNodoDblClick(TObject *Sender)
{
  if( (CampoEditado != NULL) && (CampoEditado->padre != NULL) &&
                                (GN != NULL) && (GT != NULL) )
     frmDetallesNodo->Inicia(GN,GT,CampoEditado->padre->AsNodo()->nombre);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEdicionCampos::imgTipoDblClick(TObject *Sender)
{
  if(GT != NULL)
     frmTipos->Inicia(GT);
}
//---------------------------------------------------------------------------
void __fastcall TfrmEdicionCampos::memoKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   // Cuando se pulsa control + intro equivale a pulsar aceptar.
   if( (Key == VK_RETURN) && (Shift.Contains(ssCtrl)) )
      sbAceptarClick(NULL);

}
//---------------------------------------------------------------------------

void __fastcall TfrmEdicionCampos::FormKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(VK_ESCAPE == Key)
     Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmEdicionCampos::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmEdicionCampos::sbAyudaClick(TObject *Sender)
{
   Main->Ayuda();
}
//---------------------------------------------------------------------------

