//
//     frmDetallesNodo   
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta ventana muestra informacin general de cada nodo.
*/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "frmDetallesNodo_.h"
#include "Utilidad_.h"
#include "frmTipos_.h"
#include "Configuracion_.h"
#include "frmEscena_.h"

// Las siguientes constantes controlan la posicin en la que se dibujan las
// flechas del rutado en el grid.
#define RUTADO_OFFSET_X 2
#define RUTADO_OFFSET_Y 0

// Es el nmero mnimo de columnas que habr en el grid (para que siempre salgan
// las barras laterales en el grid hay que hacer que el nmero de columnas supere
// cierto valor.
#define MIN_COLUMS_GRID 12

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmDetallesNodo *frmDetallesNodo;

//---------------------------------------------------------------------------
__fastcall TfrmDetallesNodo::TfrmDetallesNodo(TComponent* Owner)
     : TForm(Owner)
{
     NodoActual=NULL;
     GN=NULL;
     GT=NULL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::Inicia(GestorNodos *gn,GestorTipos *gt,int nodo){

     if( (gn == NULL) || (gt==NULL) )
        return;

     GN=gn;
     GT=gt;


     NodoActual=GN->DatosNodo(nodo);
     if(NodoActual!=NULL){
        CargacbNodos();
        Actualiza();
        ShowModal();
     }
}
//------------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::Inicia(GestorNodos *gn,GestorTipos *gt,AnsiString nodo){

     if( (gn == NULL) || (gt==NULL) )
        return;
     GN=gn;
     GT=gt;

     NodoActual=GN->DatosNodo(nodo);

     if(NodoActual!=NULL){
        CargacbNodos();
        Actualiza();
        ShowModal();
     }
}



//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::sbVolverClick(TObject *Sender)
{
     Close();
}

//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::Actualiza(){
     if(NodoActual==NULL)
          return;

     if(GN->tipoEscena == ESCENA_X3D){
         sbIdea->Visible= ( NULL != Main->GNH->DatosNodo((AnsiString) NodoActual->nombre));
     }else{
         sbIdea->Visible= ( NULL != Main->GNX->DatosNodo((AnsiString) NodoActual->nombre));
     }

     int pos = cbNodos->Items->IndexOf(NodoActual->nombre);
     cbNodos->ItemIndex = (-1 == pos) ? 0 : pos;

     // Ocurre que al parecer el nmero mnimo de filas es 1 y cuando se
     // asgna a 0 queda una fila y no se borra su contenido. As que la
     // borramos desde aqui.
     if(NodoActual->numCampos == 0){
          // Borramos el contenido de la primera fila.
          Grid->Cells[0][0]="";
          Grid->Cells[1][0]="";
          Grid->Cells[2][0]="";
          Grid->Cells[3][0]="";
          Grid->Cells[4][0]="";
     }
     Grid->RowCount= NodoActual->numCampos;
     //-------------------------------------------------------- Nombre ---------
     // Volcamos a pantalla el contenido del nodo actual.
     lbNombre->Caption=(AnsiString) NodoActual->nombre;

     //-------------------------------------------------------- Tipo -----------
     // Volcamos a pantalla el contenido del nodo actual.
     lbTipo->Caption=(AnsiString) NodoActual->tipo;

     //-------------------------------------------------------- Imagen ---------
     if(GN->tipoEscena == ESCENA_X3D)
        Imagen->Visible=Utilidad.GetImagen(Imagen->Picture,NodoActual->imagen,CONF.IMAGEN_GENERAL_NODO_X3D);
     else
        Imagen->Visible=Utilidad.GetImagen(Imagen->Picture,NodoActual->imagen,CONF.IMAGEN_GENERAL_NODO_H3D);
     //-------------------------------------------------------- Descripcin ----
     Descripcion->Text = NodoActual->descripcion;

     //-------------------------------------------------------- Indicador ------
     Indicador->Caption="Node " +
                        IntToStr(1+GN->NumeroDeNodo(NodoActual->nombre))
                        + "/" + IntToStr(GN->GetNumNodos());

     //---------------------------------------------------- Relleno de Campos --
     Campo *campo;
     for(int i=0; i < NodoActual->numCampos; i++){
          campo=NodoActual->campos[i];
          if(campo != NULL){
               Grid->Cells[1][i]= (AnsiString) campo->nombre;
               Grid->Cells[3][i]= (AnsiString) campo->tipo->nombre;
               Grid->Cells[4][i]= (AnsiString) campo->valorPorDefecto;
          }
     }
     Grid->Repaint();
}


void __fastcall TfrmDetallesNodo::sbSiguienteClick(TObject *Sender)
{
     if(NodoActual == NULL)
          return;
     int nodo;
     nodo=GN->NumeroDeNodo(NodoActual->nombre);
     if((nodo+1) < GN->GetNumNodos()){
          NodoActual=GN->DatosNodo(nodo+1);
          Actualiza();
     }
}
//---------------------------------------------------------------------------

void __fastcall TfrmDetallesNodo::sbAnteriorClick(TObject *Sender)
{
     if(NodoActual == NULL)
          return;
     int nodo;
     nodo=GN->NumeroDeNodo(NodoActual->nombre);
     if(nodo > 0){
          NodoActual=GN->DatosNodo(nodo-1);
          Actualiza();
     }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::FormCreate(TObject *Sender)
{
     // Vamos a asignar el ttulo del Grid de Ttulos.
     GridTitulos->Cells[0][0]="Name";
     GridTitulos->Cells[1][0]="Type";
     GridTitulos->Cells[2][0]="Default Value";
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::GridDrawCell(TObject *Sender, int ACol,
      int ARow, TRect &Rect, TGridDrawState State)
{
     // Solo pintamos las lneas una vez por cada fila visible.
     if(ACol==0)
          PonFlecha(ARow);
     if(ACol==2){
          Campo *campo;
          Tipo *tipo;

          if ((NodoActual == NULL) || (NodoActual->numCampos == 0))
               return;
          campo=NodoActual->campos[ARow];
          if( (campo==NULL) || (campo->tipo == NULL) || (campo->tipo->icono == NULL))
               return;

          Grid->Canvas->Draw(Rect.left,Rect.top,campo->tipo->icono->Bitmap);
     }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::PonFlecha(int fil){
     if( (NodoActual == NULL) || (NodoActual->campos == NULL) || (NodoActual->numCampos == 0) )
        return;

     TRect posicion;
     Campo *campo;
     int x,y;

     campo=NodoActual->campos[fil];
     if(campo != NULL){
          posicion=Grid->CellRect(0,fil);
          // CellRect nos devuelve un rectngulo vaco si la celda no se
          // est mostrando en la pantalla.
          if(posicion.Width() || posicion.Height()){
               x=posicion.left + RUTADO_OFFSET_X;
               y=posicion.Top + RUTADO_OFFSET_Y;
               switch (campo->rutado){
                    case FIELD        :  Grid->Canvas->Draw(x,y,imgField->Picture->Bitmap); break;
                    case EVENTOUT     :  Grid->Canvas->Draw(x,y,imgRoutedTo->Picture->Bitmap); break;
                    case EVENTIN      :  Grid->Canvas->Draw(x,y,imgRoutedFrom->Picture->Bitmap); break;
                    case EXPOSEDFIELD :  Grid->Canvas->Draw(x,y,imgExposedField->Picture->Bitmap); break;
               }
          }
     }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::GridDblClick(TObject *Sender)
{
     frmTipos->Inicia(GT);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::sbH3DClick(TObject *Sender)
{
     if(GN->tipoEscena == ESCENA_H3D)
        return;

     AnsiString nombreNodo;
     Nodo *tmp;

     // Vamos a intentar que cuando se pase de X3D a H3D o al revs se
     // carge el mismo nodo que haba para ver las diferencias.
     nombreNodo=NodoActual->nombre;

     GN=Main->GNH;
     GT=Main->GTH;

     tmp=GN->DatosNodo(nombreNodo);
     if(tmp!=NULL){
        NodoActual=tmp;
     }else{  // Si no existe cargamos el primer nodo.
        NodoActual=GN->DatosNodo(0);
     }

     CargacbNodos();
     Actualiza();
}
//---------------------------------------------------------------------------

void __fastcall TfrmDetallesNodo::sbX3DClick(TObject *Sender)
{
     if(GN->tipoEscena== ESCENA_X3D)
        return;

     AnsiString nombreNodo;
     Nodo *tmp;

     // Vamos a intentar que cuando se pase de X3D a H3D o al revs se
     // carge el mismo nodo que haba para ver las diferencias.
     nombreNodo=NodoActual->nombre;

     GN=Main->GNX;
     GT=Main->GTX;

     tmp=GN->DatosNodo(nombreNodo);
     if(tmp!=NULL){
        NodoActual=tmp;
     }else{  // Si no existe cargamos el primer nodo.
        NodoActual=GN->DatosNodo(0);
     }

     CargacbNodos();
     Actualiza();
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::sbIdeaClick(TObject *Sender)
{
    if(GN->tipoEscena == ESCENA_X3D)
        sbH3DClick(NULL);
    else
        sbX3DClick(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::FormKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   if(VK_ESCAPE == Key)
     Close();
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::CargacbNodos(){
   if(GN == NULL)
      return;
   cbNodos->Items->Clear();
   Nodo *n;
   int fin = GN->GetNumNodos();
   for(int c=0; c < fin; c++){
      n=GN->DatosNodo(c);
      if(n!=NULL)
         cbNodos->Items->Append(n->nombre);
   }
   if(NodoActual != NULL){
      int pos = cbNodos->Items->IndexOf(NodoActual->nombre);
      cbNodos->ItemIndex = (-1 == pos) ? 0 : pos;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::cbNodosChange(TObject *Sender)
{
   if(GN == NULL)
      return;

   Nodo *n= GN->DatosNodo(cbNodos->Text);
   if(n != NULL){
      NodoActual=n;
      Actualiza();
   }

}
//---------------------------------------------------------------------------

void __fastcall TfrmDetallesNodo::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmDetallesNodo::sbAyudaClick(TObject *Sender)
{
   Main->Ayuda();
}
//---------------------------------------------------------------------------

