//
//     frmConsola   
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta clase permite ejecutar ficheros MS-DOS redireccionando su
                entrada estndar, salida estndar y salida de error estndar a
                un componente TMemo.
*/
//---------------------------------------------------------------------------

#ifndef frmConsola_H
#define frmConsola_H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
//---------------------------------------------------------------------------
class TfrmConsola : public TForm
{
__published:	// IDE-managed Components
        TPanel *pnlTitulo;
        TTimer *Timer;
        TLabel *lbTitulo;
        TPanel *pnlConsola;
        TSpeedButton *sbConsola;
        TPanel *pnlMemo;
        TMemo *Memo;
        TPanel *pnlIrA;
        TSpeedButton *sbIrALinea;
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall TimerTimer(TObject *Sender);
        void __fastcall FormDestroy(TObject *Sender);
        void __fastcall FormCanResize(TObject *Sender, int &NewWidth,
          int &NewHeight, bool &Resize);
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall sbIrALineaClick(TObject *Sender);
        void __fastcall MemoClick(TObject *Sender);
        void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
private:	// User declarations
   // Esta variable guardar la direccin de la funcin original que procesa
   // los mensajes que el sistema operativo enva al componente Memo
   TWndMethod FuncionOriginalMemo;

   // Se usa para saber si se han escrito datos en la salida de error estndar.
   bool HuboError;

   // El usuario puede seleccionar el nmero de lnea que quiere editar. Esta
   // varible guarda la lnea que se elige.
   int LineaSeleccionada;

   // true si cuando acaba el proceso hijo se debe esperar a que el usuario
   // pulse una tecla antes de cerrar la ventana.
   bool EsperarSiError;

   // Indica al evento OnClose si se puede cerrar la ventana. No se podr cerrar
   // la ventana mientras el proceso hijo se est ejecutando.
   bool SePuedeCerrar;

   //  Con esta funcin capturaremos los mensajes que el sistema operativo
   // intercambia con el componente Memo.
   void __fastcall CapturaWndProc(Messages::TMessage &Message);

public:		// User declarations

        //  Recibe la ruta del fichero H3D a ejecutar.
        // (A esta ruta se le aaden comillas dobles "" en la funcin).
        //   A continuacin ejecuta el fichero .exe configurado en CONF para
        // las ejecuciones h3d pasndole como parmetro fichero.
        //   Para el nuevo proceso creado se captura la salida estndar y la
        // salida estndar de error y los datos leidos de ests salidas se
        // vuelcan al componente Memo.
        //   Adems los datos introducidos en el componente TMemo se mandan a la
        // entrada estndar del proceso creado.
        //
        //   Cuando acaba el proceso se cierra la ventana y acaba la funcin a
        // menos que el proceso creado haya escrito algo en la salida de error
        // estndar.
        // En ese caso, si esperarSiError es verdadero se esperar a que se pulse
        // una tecla antes de cerrar la ventana.
        //
        // Devuelve el nmero de lnea seleccionado por el usuario (muy til para
        // editar errores en el cdigo). Si el usuario no selecciona ninguna lnea
        // devuelve -1.
        int __fastcall Inicia(AnsiString fichero,bool esperarSiError);

        // Muestra la ventana con ShowModal y permite ver el contenido de la
        // consola que produjo la ltima ejecucin H3D.
        // Devuelve el nmero de lnea seleccionado por el usuario (muy til para
        // editar errores en el cdigo). Si el usuario no selecciona ninguna lnea
        // devuelve -1.
        int __fastcall MostrarConsola();

        // Constructor de la clase.
        __fastcall TfrmConsola(TComponent* Owner);

};
//---------------------------------------------------------------------------
extern PACKAGE TfrmConsola *frmConsola;
//---------------------------------------------------------------------------
#endif
