//
//     frmConsola 
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta clase permite ejecutar ficheros MS-DOS redireccionando su
                entrada estndar, salida estndar y salida de error estndar a
                un componente TMemo.
*/

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <windows.h>
#include <tchar.h>

#include "frmConsola_.h"
#include "Main_.h"
#include "Utilidad_.h"
#include "Configuracion_.h"
//---------------------------------------------------------------------------
// Tamao del buffer que se usa para leer datos de los pipe's.
#define TAM_BUFFER 100

// Constantes para controlar si se puede cambiar el tamao del control.
#define MIN_WIDTH 476
#define MIN_HEIGHT 247

#pragma package(smart_init)
#pragma resource "*.dfm"

TfrmConsola *frmConsola;


// Ver comentarios en la declaracin de funcin.
bool ProcesarDatosDeEntrada(HANDLE hReadPipe);

/*  Al redireccionar las entradas y salidas estandars hay que crear pipes
 (tuberas) estos son los manejadores de esas tuberas. Cada extremo de la
 tubera tiene asociado un manejador para leer o escribir datos:

  PIPE 1:  ASOCIADA A LA ENTRADA STANDAR DEL PROCESO HIJO

+------------+                       (-----------------)                     +-----------+
| PROC.PADRE | --> ManStdinPadre -->      P I P E       --> ManStdinHijo --> | PROC.HIJO |
+------------+                       (-----------------)                     +-----------+

  PIPE 2:  ASOCIADA A LA SALIDA STANDAR DEL PROCESO HIJO

+------------+                       (-----------------)                     +----------+
| PROC.PADRE | <-- ManStdoutPadre <--      P I P E     <-- ManStdoutHijo <-- | PROC.HIJO |
+------------+                       (-----------------)                     +----------+

  PIPE 3:  ASOCIADA A LA SALIDA DE ERROR STANDAR DEL PROCESO HIJO

+------------+                       (-----------------)                     +-----------+
| PROC.PADRE | <-- ManStdoutErrorPadre <--P I P E <-- ManStdoutErrorHijo <-- | PROC.HIJO |
+------------+                       (-----------------)                     +-----------+

  A continuacin se declaran las variables que aparecen en el grfico anterior
como manejadores de los PIPEs. (Man = Manejador)  */

HANDLE ManStdoutPadre=0;
HANDLE ManStdoutHijo=0;

HANDLE ManStdinPadre=0;
HANDLE ManStdinHijo=0;

HANDLE ManStdoutErrorPadre=0;
HANDLE ManStdoutErrorHijo=0;

// Guarda informacin asociada al proceso creado en la ejecucin del fichero
// ejecutable con CreateProcess (Ver ayuda de las API de Windows)
PROCESS_INFORMATION InfProc;
// Guarda informacin necesaria para crear un proceso (Ver ayuda de las API de Windows).
STARTUPINFO InfCreaProc;

//------------------------------------------------------------------------------
__fastcall TfrmConsola::TfrmConsola(TComponent* Owner)
        : TForm(Owner)
{
   HuboError=false;
   EsperarSiError=false;
   SePuedeCerrar=false;
   LineaSeleccionada=0;
}
//------------------------------------------------------------------------------
void __fastcall TfrmConsola::CapturaWndProc(Messages::TMessage &Message)
{
   // Usaremos esta funcin para escribir en la entrada del pipe 1 (ver grfico)
   if( Message.Msg == WM_CHAR )
   {
       //  Al cambiar de lnea en un componente TMemo solo se lee de teclado
       // (char)13 pero cuando esto se hace desde una consola MS-DOS se lee
       // (char)13 y (char)10 as:
       DWORD  escritos= 0;
       if(Message.WParam == (TCHAR)0x0D)
          WriteFile(ManStdinPadre, "\r\n", 2, &escritos, 0);
       else
          WriteFile(ManStdinPadre, &Message.WParam, 1, &escritos, 0);
       // Notar que escribimos a la entrada del pipe 1 (ver grfico).
    }
    // Llamamos a la funcin original.
    FuncionOriginalMemo(Message);
}
//------------------------------------------------------------------------------
void __fastcall TfrmConsola::FormCreate(TObject *Sender)
{
    // Obtenemos el manejador del proceso actual.
    HANDLE ManProcPadre = GetCurrentProcess();

    // Usamos las propiedades del compomente Memo para capturar los mensajes
    // asociados este control.
    FuncionOriginalMemo=Memo->WindowProc;
    Memo->WindowProc=CapturaWndProc;

    // Usamos la siguiente estructura para crear los pipes.
    SECURITY_ATTRIBUTES pipesInfo;
    // Activamos el flag bInheritHandle SECURITY_ATTRIBUTES para que los
    // manejadores del pipe sean heredables.
    pipesInfo.nLength = sizeof(pipesInfo);
    pipesInfo.bInheritHandle = TRUE;
    pipesInfo.lpSecurityDescriptor = NULL;

    /* A continuacin se van a crear los tres pipes que necesitamos (ver grfico
    anterior). Se usan las dos funciones siguientes:
     BOOL CreatePipe(
         PHANDLE hReadPipe,   -> (out) address of variable for read handle -> SALIDA DE LA TUBERIA (PIPE)
         PHANDLE hWritePipe,  -> (out) address of variable for write handle -> ENTRADA DE LA TUBERIA (PIPE)
         LPSECURITY_ATTRIBUTES lpPipeAttributes, -> (in) pointer to security attributes
         DWORD nSize                             -> (in) number of bytes reserved for pipe
     );

     BOOL DuplicateHandle(
        HANDLE hSourceProcessHandle,  ->  (in) Handle to the process with the handle to duplicate
        HANDLE hSourceHandle,         ->  (in) Handle to duplicate.
        HANDLE hTargetProcessHandle,  ->  (in) Handle to the process that is to receive the duplicated handle
        LPHANDLE lpTargetHandle,      ->  (out) Pointer to a variable that receives the value of the duplicate handle.
        DWORD dwDesiredAccess,        ->  (in) se ignora si dwOptions es DUPLICATE_SAME_ACCESS
        BOOL bInheritHandle,          ->  (in) Indicates whether the handle is inheritable. If TRUE,
                                              the duplicate handle can be inherited by new processes
                                              created by the target process. If FALSE,
                                              the new handle cannot be inherited.
        DWORD dwOptions               ->  (in) Debe ser DUPLICATE_SAME_ACCESS o DUPLICATE_CLOSE_SOURCE
     );  */

    HANDLE tmp; 
    
    //>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> CREACIN DEL PIPE 1 (Ver Grfico) >>>>>
    if(!CreatePipe(&ManStdinHijo, &tmp, &pipesInfo, 0))
        return;
    if(!DuplicateHandle(ManProcPadre, tmp, ManProcPadre,&ManStdinPadre,
                        0, FALSE, DUPLICATE_SAME_ACCESS))
        return;
    CloseHandle(tmp);

    //>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> CREACIN DEL PIPE 2 (Ver Grfico) >>>>>
    if(!CreatePipe(&tmp, &ManStdoutHijo, &pipesInfo, 0))
        return;
    if(!DuplicateHandle( ManProcPadre, tmp, ManProcPadre, &ManStdoutPadre,
                         0, FALSE, DUPLICATE_SAME_ACCESS))
        return;
    CloseHandle(tmp);

    //>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> CREACIN DEL PIPE 3 (Ver Grfico) >>>>>
    if(!CreatePipe(&tmp, &ManStdoutErrorHijo, &pipesInfo, 0))
        return;
    if(!DuplicateHandle( ManProcPadre, tmp, ManProcPadre, &ManStdoutErrorPadre,
                         0, FALSE, DUPLICATE_SAME_ACCESS))
        return;
    CloseHandle(tmp);


    // A continuacin vamos a preparar las estructuras de datos que se pasan
    // a la funcin create process para indicarle cmo queremos ejecutar
    // el fichero.

    // Pone a 0 todos los bytes de la estructura InfCreaProc
    memset(&InfCreaProc, 0, sizeof(InfCreaProc));
    // cb debe contener el n de bytes de la estructura.
    InfCreaProc.cb        = sizeof(STARTUPINFO);
    // El flag STARTF_USESTDHANDLES del campo dwFlags indica que se deben
    // usar como entrada estandar, salida estandar y salida estandar de errores
    // las especificadas en los campo hStdInput, hStdOutput y hStdError.
    // Adems, tenemos que especificar tb el flag STARTF_USESHOWWINDOW para que
    // el campo wShowWindow que vamos a usar a continuacin no se ignore:
    InfCreaProc.dwFlags    =   STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
    // Especifica como se debe mostrar la ventana del proceso hijo. Algunos
    // valores posibles son: SW_SHOW, SW_SHOWNOACTIVATE, SW_MAXIMIZE etc.
    // Para ver el resto de valores consulte la ayuda de la funcin ShellExecute
    InfCreaProc.wShowWindow = SW_SHOW;

    // Aqui es donde se hace la redireccin de la entrada y salida (ver grfico)
    InfCreaProc.hStdInput  = ManStdinHijo;
    InfCreaProc.hStdOutput = ManStdoutHijo;
    InfCreaProc.hStdError  = ManStdoutErrorHijo;
}
//------------------------------------------------------------------------------
void __fastcall TfrmConsola::FormDestroy(TObject *Sender)
{
   // Al destruir la ventana hay que liberar los manejadores de todos los pipes
   // que hemos usado:
   CloseHandle(ManStdoutPadre);
   CloseHandle(ManStdoutHijo);
   CloseHandle(ManStdinPadre);
   CloseHandle(ManStdinHijo);
   CloseHandle(ManStdoutErrorPadre);
   CloseHandle(ManStdoutErrorHijo);
}
//------------------------------------------------------------------------------
// Esta funcin recibe el manejador de un pipe (tubera) y chequea si hay datos
// que leer, si es as los lee y aade a Memo los datos leidos. Si el pipe no
// contena datos que leer devuelve false y true en caso contrario.
// Usaremos esta funcin para leer las salidas de los pipes 2 y 3 (ver grfico).
bool ProcesarDatosDeEntrada(HANDLE pipe)
{
    // Buffer para leer los datos de pipe. static para no perder tiempo en
    // reservas de memoria (esta funcin se puede ejecutar con mucha frecuencia).
    static CHAR buffer[TAM_BUFFER];
    DWORD bytesPorLeer = 0;    // Nmero de bytes que an queda por leer.
    DWORD bytesLeidos  = 0;    // Numero actual de bytes leidos.
    bool haLeido = false;      // para saber si se ha leido algn dato de pipe.

    // Iteraremos mientras haya datos que leer.
    for(;;)
    {
        // La funcin ReadFile() bloquea el programa hasta que se reciban los
        // datos, por eso vamos a usar PeekNamedPipe() que nos permite preguntar
        // si hay datos que leer sin bloquear el programa.
        //   Es necesario sealar que aunque en la ayuda de las API de esta
        // funcin se seala que la funcin sirve para leer los datos del pipe,
        // nosostros, solo vamos a usarla para preguntar cuantos bytes hay en
        // el pipe esperando a ser leidos. Y no la usaremos para leerlos pq
        // PeekNamedPipe lee los datos pero no los elimina del pipe.
        // Si se produce algn error la funcin devuelve 0.
        // Usando el valor devuelto por PeekNamedPipe en bytesPorLeer en la
        // misma condicin del if, saldremos cuando:
        //  a) Se produzca un error en la funcin, o bien cuando
        //  b) el nmero de bytes por leer sea 0.
        if(!PeekNamedPipe(pipe, 0, 0, 0, &bytesPorLeer, 0) || bytesPorLeer == 0)
            return haLeido;

        // En este caso hay que leer los datos de pipe:
        if(bytesPorLeer){
            haLeido=true;

            // Leemos los datos al buffer teniendo en cuenta su tamao.
            DWORD numBytes= (bytesPorLeer < (TAM_BUFFER - 1)) ? bytesPorLeer : (TAM_BUFFER - 1);

            /* De la ayuda de las API:
              BOOL ReadFile(
                  HANDLE hFile,
                  LPVOID lpBuffer,
                  DWORD nNumberOfBytesToRead,
                  LPDWORD lpNumberOfBytesRead,
                  LPOVERLAPPED lpOverlapped
                );   */

            // Con esta funcin intentamos leer dwBytesToRead de hReadPipe
            ReadFile(pipe, buffer, numBytes, &bytesLeidos, 0);

            // Ponemos el caracter teminador en el buffer.
            buffer[bytesLeidos] = 0;

            // Cadena con los datos leidos:
            TCHAR* cad  = buffer;

            // Es necesario para que se reciban todos los mensajes de la consola
            // (si se omite podra perderse parte del texto).
            Sleep(CONF.DELAY_CONSOLA_H3D);

            // Obtenemos el nmero de caracteres que hay en Memo
            int nLen = GetWindowTextLength(frmConsola->Memo->Handle);
            // Vamos a posicionar el cursor en el final del texto de Memo.
            // (WPARAM) especifica el principio de la seleccin y (LPARAM) el final.
            // y como son el mismo nmero simplemente pondremos el cursor a final.
            SendMessage(frmConsola->Memo->Handle, EM_SETSEL, (WPARAM)nLen, (LPARAM)nLen);
            // El mensaje EM_REPLACESEL reemplaza la seleccin actual con el
            // texto especificado en tsz, pero realmente ms que reemplazar la
            // seleccin que no existe, lo que se hace es aadir el contenido
            // de (LPARAM)tsz a Memo.
            SendMessage(frmConsola->Memo->Handle, EM_REPLACESEL, 0, (LPARAM)cad);
        }
    }
}
//------------------------------------------------------------------------------
void __fastcall TfrmConsola::TimerTimer(TObject *Sender)
{
    // Peridicamente comprobaremos si hay datos en los pipes esperando a ser leidos:
    ProcesarDatosDeEntrada(ManStdoutPadre);
    HuboError = HuboError || ProcesarDatosDeEntrada(ManStdoutErrorPadre);

    // Ahora tenemos que comprobar si el proceso hijo sigue ejecutandose,
    // cuando detectemos que el proceso hijo ha acabado detendremos el Timer
    // y cerraremos la ventana. Usaremos la funcin WaitForSingleObject

    /* La funcin WaitForSingleObject acaba cuando, se agota el tiempo que se
     pasa en el segundo parmetro (en ms) o cuando el proceso asociado al
     manejador pasado en el primer parmetro est en estado signal. Un manejador
     est en este estado cuando no es est ejecutando (no tiene ninguna hebra asociada).
     DWORD WaitForSingleObject( HANDLE hHandle,       (in) -> Handle to the object.
                                DWORD dwMilliseconds  (in) -> Specifies the time-out interval, in milliseconds.);
     Puede devolver estos tres valores:
     WAIT_ABANDONED -> The specified object is a mutex object that was not released
                       by the thread that owned the mutex object before the owning
                      thread terminated.
     WAIT_OBJECT_0  -> The state of the specified object is signaled
     WAIT_TIMEOUT   -> The time-out interval elapsed, and the object's state is nonsignaled.*/
     if(WaitForSingleObject(InfProc.hProcess, 0) == WAIT_OBJECT_0)
     {
           // El proceso hijo ha acabado -> Obtenemos el cdigo de salida:
           DWORD exitCode = 0;;
           if(GetExitCodeProcess(InfProc.hProcess,&exitCode))
           {
              HuboError = (exitCode != 0);
           }

           // Liberamos los manejadores abiertos al crear el proceso hijo.
           //   No son dos procesos si no dos manejadores asociados al mismo proceso:
           // hProcess es el manejador del proceso.
           // hThread;  es el manejador a "the primary thread of the process".
           CloseHandle(InfProc.hThread);
           CloseHandle(InfProc.hProcess);

           Timer->Enabled=false;
           // Ya se puede cerrar la ventana.
           SePuedeCerrar=true;
           Memo->ReadOnly = true;

           if(EsperarSiError && HuboError)
           {
              pnlIrA->Visible = true;
              return;  // No hacemos nada.
           }
           ModalResult = mrOk;
     }
}
//------------------------------------------------------------------------------
int __fastcall TfrmConsola::Inicia(AnsiString fichero,bool esperarSiError)
{
   LineaSeleccionada=-1;
   Memo->ReadOnly=false;
   Memo->Clear();
   Caption = Main->Caption;

   // Vamos a hacer que el directorio actual sea el mismo en el que est el fichero:
   AnsiString dirTmp = GetCurrentDir();
   SetCurrentDir(ExtractFileDir(fichero));

   HuboError=false;
   EsperarSiError = esperarSiError;
   // Evitamos que el usuario pueda cerrar la ventana antes de que acabe el
   // proceso hijo.
   SePuedeCerrar=false;

   // Preparamos la lnea de comandos para la ejecucin.
   fichero= CONF.PATH_H3D_LOAD + " \"" + fichero + "\"";

   // Ejecutamos fichero creando un proceso con los parmetros asignados al crear
   // la ventana.
   if(!CreateProcess(NULL, fichero.c_str() , NULL, NULL, TRUE, CREATE_NEW_CONSOLE, NULL, NULL, &InfCreaProc, &InfProc))
         return -1;

   // Ocultamos el panelIrA, solo lo mostraremos si hay errores.
   pnlIrA->Visible = false;

   // Activamos el sondeo de los pipes.
   Timer->Enabled=true;

   ShowModal();

   SetCurrentDir(dirTmp);

   return LineaSeleccionada;
}
//------------------------------------------------------------------------------
int __fastcall TfrmConsola::MostrarConsola(){
   Memo->ReadOnly=true;
   LineaSeleccionada=-1;   
   SePuedeCerrar=true;
   pnlIrA->Visible=true;
   Caption = Main->Caption;
   ShowModal();
   return LineaSeleccionada;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConsola::FormCanResize(TObject *Sender,
      int &NewWidth, int &NewHeight, bool &Resize)
{
  Resize = true;
  NewHeight = (NewHeight >= MIN_HEIGHT) ? NewHeight : MIN_HEIGHT;
  NewWidth  = (NewWidth  >= MIN_WIDTH)  ? NewWidth  : MIN_WIDTH; 
}
//---------------------------------------------------------------------------

void __fastcall TfrmConsola::FormClose(TObject *Sender,
      TCloseAction &Action)
{
   Action = SePuedeCerrar ? caHide : caNone;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConsola::FormShortCut(TWMKey &Msg,
      bool &Handled)
{
   // Cerraremos la ventana cuando se pulse ESC:
   // El bit 30 de Msg.KeyData es 1 si la tecla est pulsada antes de que se produzca
   // el evento.
   if(0x40000000 & Msg.KeyData)
      return;
   if( (Msg.CharCode == VK_ESCAPE) || (Msg.CharCode == VK_F8) )
      ModalResult=mrOk;
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConsola::sbIrALineaClick(TObject *Sender)
{
   Utilidad.MsgInfo("You can make a click on the line's number you want to edit.");
}
//---------------------------------------------------------------------------}
void __fastcall TfrmConsola::MemoClick(TObject *Sender)
{
   // Solo responderemos a eventos cuando no se est ejecutando la escena:
   if(!pnlIrA->Visible)
      return;

   // Hay que intentar ver si hay un nmero alrededor del cursor:
   int index = Memo->SelLength + Memo->SelStart + 1;
   AnsiString numero;
   int fin = Memo->Text.Length();
   if(index > fin)
      return;

   // Nos colocamos al principio del nmero:
   while( (index > 1) && (Memo->Text[index-1] >= '0') && (Memo->Text[index-1] <= '9') )
      index--;

   // Cargamos el nmero:
   while( (index <= fin) && (Memo->Text[index] >= '0') && (Memo->Text[index] <= '9') )
      numero +=Memo->Text[index++];

   if(numero == "")
      return;

   // Vamos a intentar hacer la conversin:
   int n;
   try{ n = StrToInt(numero); }
   catch(...){return;}

   // Cerramos la ventana.
   LineaSeleccionada=n;
   ModalResult=mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConsola::FormCloseQuery(TObject *Sender,bool &CanClose)
{
   CanClose = SePuedeCerrar;
}
//---------------------------------------------------------------------------


