//
//     frmConfiguracion  
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta es la clase implementa un interfaz para configurar todos
                los parmetros del programa.
*/
//---------------------------------------------------------------------------

#ifndef frmConfiguracion_H
#define frmConfiguracion_H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <Grids.hpp>
#include "GestorNodos_.h"
#include "GestorTipos_.h"
#include <Graphics.hpp>



// Esta clase contiene los datos asociados a cada elemento de Autotexto:
class DatosAT{
public:
   AnsiString at;        // Es el autotexto.
   AnsiString titulo;    // Es el indentificador asociado a at:
   AnsiString extension; // extension asociada al autotexto.
};

//---------------------------------------------------------------------------
//  En el cdigo VRML se distinguen varios tipos de elementos, por ejemplo
// comentarios, palabras reservadas, nombres de los nodos, etc. Para cada tipo
// de elemento tenemos asociado un color y si se representa en negrita y/o en
// cursiva. Vamos a crear una clase que guardar esta informacin para cada
// elemento. (Fnt es el prefijo asociado a todos los elementos relacionados con
// el Tab Fuente).
class FntDatosElemento{
public:
   TColor Color;
   bool Negrita;
   bool Cursiva;
   // Asigna los valores Color Negrita y Cursiva a partir de c y nc
   void __fastcall Set(TColor c,DWORD nc){
      Color =c;
      Negrita = nc & CFE_BOLD;
      Cursiva = nc & CFE_ITALIC;
   }
   // Copia los datos de x a Negrita, Cursiva y Color.
   void __fastcall Set(FntDatosElemento x){
      this->Color=x.Color;
      this->Negrita=x.Negrita;
      this->Cursiva=x.Cursiva;
   }

   // Asigna los valores c y nc con los datos guardados en Color, Negrita y Cursiva.
   void __fastcall Get(TColor &c,DWORD &nc){
      c=Color;
      nc=GetNC();
   }
   // Copia Negrita, Cursiva y Color a x.
   void __fastcall Get(FntDatosElemento &x){
      x.Color=this->Color;
      x.Negrita=this->Negrita;
      x.Cursiva=this->Cursiva;
   }

   // Devuelve los valores de Negrita y Cursiva como DWORD
   DWORD __fastcall GetNC(){
      DWORD nc=0;
      if(Negrita)
         nc = nc | CFE_BOLD;   // Aadimos el flag CFE_BOLD
      if(Cursiva)
         nc = nc | CFE_ITALIC; // Aadimos el flag CFE_ITALIC
      return nc;
   }
   // Constructor:
   __fastcall FntDatosElemento(){
      Negrita = false;
      Cursiva = false;
      Color   = clYellow;  // Asignamos un color cualquiera.
   }
};


//---------------------------------------------------------------------------
class TfrmConfiguracion : public TForm
{
__published:	// IDE-managed Components
        TPageControl *Carpetas;
        TTabSheet *tabFnt;
        TTabSheet *tabTipos;
        TGroupBox *FntGbGeneral;
        TLabel *FntlbFondo;
        TPanel *FntPnlColorFondo;
        TLabel *FntLbFuente;
        TComboBox *FntCbFuente;
        TLabel *FntLbTamEditor;
        TComboBox *FntCbTamEditor;
        TGroupBox *FntGbElementos;
        TListBox *FntLbElementos;
        TGroupBox *FntGbPropiedades;
        TCheckBox *FntCbNegritaProps;
        TCheckBox *FntCbCursivaProps;
        TPanel *FntPnlColorProps;
        TLabel *FntLbColorProps;
        TCheckBox *FntCbNegritaGen;
        TCheckBox *FntCbCursivaGen;
        TGroupBox *FntGbMuestra;
        TRichEdit *FntMuestra;
        TGroupBox *FntGbFormato;
        TRadioButton *FntRbEnrriquecido;
        TRadioButton *FntRbSencillo;
        TSpeedButton *sbAyuda;
        TSpeedButton *sbAceptar;
        TSpeedButton *sbCancelar;
        TSpeedButton *sbRestaurar;
        TComboBox *FntCbTamEscena;
        TGroupBox *FntGbColores;
        TPanel *FntPnl01;
        TPanel *FntPnl03;
        TPanel *FntPnl02;
        TPanel *FntPnl04;
        TPanel *FntPnl05;
        TLabel *FntLbTamEscena;
        TPanel *FntPnl06;
        TPanel *FntPnl07;
        TPanel *FntPnl08;
        TPanel *FntPnl09;
        TPanel *FntPnl10;
        TPanel *FntPnl11;
        TPanel *FntPnl12;
        TPanel *FntPnl13;
        TPanel *FntPnl14;
        TPanel *FntPnl15;
        TPanel *FntPnl16;
        TPanel *FntPnl17;
        TPanel *FntPnl18;
        TPanel *FntPnl19;
        TPanel *FntPnl20;
        TGroupBox *FntGbSeleccionado;
        TGroupBox *FntGbOtrosColores;
        TPanel *FntPnlSeleccionado;
        TLabel *FntLbSeleccionado;
        TPanel *FntPnlOtro;
        TLabel *FntLbColorGen;
        TPanel *FntPnlColorGen;
        TSpeedButton *TiposSbX3D;
        TSpeedButton *TiposSbH3D;
        TSpeedButton *TiposSbNuevo;
        TSpeedButton *TiposSbEliminar;
        TGroupBox *TiposGbNuevo;
        TGroupBox *TiposGbLista;
        TSpeedButton *TiposSbIniciar;
        TGroupBox *TiposGbIcono;
        TGroupBox *TiposGbNombre;
        TEdit *TiposEdNombre;
        TEdit *TiposEdIcono;
        TGroupBox *TiposGbEjemplo;
        TEdit *TiposEdEjemplo;
        TSpeedButton *TiposSbAnadirEditar;
        TTabSheet *tabNodos;
        TGroupBox *NodosGb;
        TSpeedButton *NodosSbH3D;
        TSpeedButton *NodosSbX3D;
        TSpeedButton *NodosSbIniciar;
        TSpeedButton *NodosSbEliminar;
        TSpeedButton *NodosSbNuevo;
        TGroupBox *TiposGbHijos;
        TComboBox *TiposCbHijos;
        TGroupBox *NodosGbNombre;
        TComboBox *NodosCbNombre;
        TGroupBox *NodosGbTipo;
        TEdit *NodosEdTipo;
        TGroupBox *NodosGbIcono;
        TGroupBox *NodosGbDescripcion;
        TMemo *NodosMmDescripcion;
        TEdit *NodosEdIcono;
        TGroupBox *NodosGbCampos;
        TPanel *TiposPnlGrid;
        TStringGrid *TiposGrid;
        TSpeedButton *NodosSbEditar;
        TGroupBox *NodosGbIcono2;
        TPanel *Panel1;
        TImage *NodosIcono;
        TPanel *TiposPnlIcono;
        TImage *TiposIcono;
        TImage *NodosimgRoutedFrom;
        TImage *NodosimgRoutedTo;
        TImage *NodosimgField;
        TImage *NodosimgExposedField;
        TGroupBox *NodosGbNumNodo;
        TGroupBox *NodosGbDatosCampo;
        TPanel *NodosPnlCampos;
        TStringGrid *NodosGrid;
        TGroupBox *NodosGbFlechas;
        TSpeedButton *NodosSbAnterior;
        TSpeedButton *NodosSbSiguiente;
        TEdit *NodosEdNombreCampo;
        TComboBox *NodosCbTipoCampo;
        TLabel *NodosLbNombreCampo;
        TLabel *NodosLbTipoCampo;
        TLabel *NodosLbRutadoCampo;
        TComboBox *NodosCbRutadoCampo;
        TLabel *NodosLbValDefCampo;
        TEdit *NodosEdValDefCampo;
        TGroupBox *NodosGbBotonesCampo;
        TSpeedButton *NodosSbNuevoCampo;
        TSpeedButton *NodosSbEliminarCampo;
        TSpeedButton *NodosSbEditarCampo;
        TGroupBox *NodosGbImagen;
        TEdit *NodosEdImagen;
        TPanel *NodosPnlEdicionImagen;
        TSpeedButton *NodosSbBorrarImagen;
        TSpeedButton *NodosSbExplImagen;
        TPanel *NodosPnlEdicionIcono;
        TSpeedButton *NodosSbBorrarIcono;
        TSpeedButton *NodosSbExplIcono;
        TPanel *TiposPnlEditarIcono;
        TSpeedButton *TiposSbBorrarIcono;
        TSpeedButton *TiposSbExplorar;
        TGroupBox *GroupBox2;
        TLabel *NodosLbNumNodo;
        TGroupBox *GroupBox3;
        TLabel *NodosLbNumCampos;
        TButton *btnOtros;
        TTabSheet *tabAT;
        TGroupBox *gbGruposAT;
        TListBox *lbExtensionesAT;
        TGroupBox *gbSeleccionadoAT;
        TGroupBox *gbIndentificadorAT;
        TEdit *edElementoAT;
        TGroupBox *gbAutoTextoAT;
        TMemo *mmAT;
        TGroupBox *gbBotonesAT;
        TSpeedButton *sbNuevoElementoAT;
        TSpeedButton *sbEliminarElementoAT;
        TSpeedButton *sbEditarElementoAT;
        TGroupBox *gbGruposExtAT;
        TEdit *edExtensionAT;
        TGroupBox *GroupBox1;
        TListBox *lbElementosAT;
        TTabSheet *tabGeneral;
        TGroupBox *gbGen00;
        TGroupBox *gbGen02;
        TEdit *edGenPrimeraLineaX3D;
        TGroupBox *gbGen01;
        TEdit *edGenPrimeraLineaH3D;
        TGroupBox *gbGen11;
        TGroupBox *gbGen04;
        TEdit *edGenNodosSinAnidamiento;
        TGroupBox *gbGen03;
        TEdit *edGenPalabrasReservadas;
        TGroupBox *gbGen07;
        TGroupBox *gbGen08;
        TSpeedButton *sbGenVisorX3D;
        TEdit *edGenVisorX3D;
        TGroupBox *gbGen09;
        TSpeedButton *sbGenVisorH3D;
        TEdit *edGenVisorH3D;
        TGroupBox *gbGen10;
        TEdit *edGenUIT;
        TGroupBox *gbGen05;
        TRadioButton *rbGenHerramientasVentana;
        TRadioButton *rbGenHerramientasOcultar;
        TRadioButton *rbGenHerramientasBarra;
        TGroupBox *gbGen06;
        TRadioButton *rbGenEscenaIniH3D;
        TRadioButton *rbGenEscenaIniX3D;
        TGroupBox *gbGen12;
        TCheckBox *cbGenNombrarNodos;
        TCheckBox *cbGenAutoCompletar;
        TGroupBox *gbGen13;
        TGroupBox *gbGen14;
        TComboBox *comboGenJustificado;
        TComboBox *comboGenRetardoAC;
        TCheckBox *cbUsarConsolaH3D;
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall sbCancelarClick(TObject *Sender);
        void __fastcall sbAceptarClick(TObject *Sender);
        void __fastcall FntPnl01Click(TObject *Sender);
        void __fastcall FntPnlColorPropsClick(TObject *Sender);
        void __fastcall FntMuestraKeyPress(TObject *Sender, char &Key);
        void __fastcall FormDestroy(TObject *Sender);
        void __fastcall FntCbNegritaPropsKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall FntCbNegritaPropsMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall FntCbTamEscenaChange(TObject *Sender);
        void __fastcall FntCbNegritaGenKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall FntCbNegritaGenMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
        void __fastcall FntCbTamEditorChange(TObject *Sender);
        void __fastcall FntCbFuenteChange(TObject *Sender);
        void __fastcall sbRestaurarClick(TObject *Sender);
        void __fastcall TiposGridDrawCell(TObject *Sender, int ACol,
          int ARow, TRect &Rect, TGridDrawState State);
        void __fastcall TiposSbAnadirEditarClick(TObject *Sender);
        void __fastcall TiposSbNuevoClick(TObject *Sender);
        void __fastcall TiposGridSelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
        void __fastcall TiposSbEliminarClick(TObject *Sender);
        void __fastcall TiposSbIniciarClick(TObject *Sender);
        void __fastcall TiposSbX3DClick(TObject *Sender);
        void __fastcall CarpetasChanging(TObject *Sender,
          bool &AllowChange);
        void __fastcall TiposSbH3DClick(TObject *Sender);
        void __fastcall TiposEdIconoKeyPress(TObject *Sender, char &Key);
        void __fastcall NodosSbSiguienteClick(TObject *Sender);
        void __fastcall NodosSbAnteriorClick(TObject *Sender);
        void __fastcall NodosGridDrawCell(TObject *Sender, int ACol,
          int ARow, TRect &Rect, TGridDrawState State);
        void __fastcall NodosSbX3DClick(TObject *Sender);
        void __fastcall NodosSbH3DClick(TObject *Sender);
        void __fastcall NodosCbNombreChange(TObject *Sender);
        void __fastcall NodosSbEliminarClick(TObject *Sender);
        void __fastcall NodosSbIniciarClick(TObject *Sender);
        void __fastcall NodosSbEditarClick(TObject *Sender);
        void __fastcall NodosSbNuevoClick(TObject *Sender);
        void __fastcall NodosGridClick(TObject *Sender);
        void __fastcall NodosSbExplIconoClick(TObject *Sender);
        void __fastcall NodosSbExplImagenClick(TObject *Sender);
        void __fastcall NodosSbBorrarImagenClick(TObject *Sender);
        void __fastcall NodosSbBorrarIconoClick(TObject *Sender);
        void __fastcall TiposSbExplorarClick(TObject *Sender);
        void __fastcall TiposSbBorrarIconoClick(TObject *Sender);
        void __fastcall NodosSbEditarCampoClick(TObject *Sender);
        void __fastcall NodosSbNuevoCampoClick(TObject *Sender);
        void __fastcall NodosSbEliminarCampoClick(TObject *Sender);
        void __fastcall btnOtrosClick(TObject *Sender);
        void __fastcall lbExtensionesATClick(TObject *Sender);
        void __fastcall lbElementosATClick(TObject *Sender);
        void __fastcall sbNuevoElementoATClick(TObject *Sender);
        void __fastcall sbEliminarElementoATClick(TObject *Sender);
        void __fastcall sbEditarElementoATClick(TObject *Sender);
        void __fastcall edElementoATKeyPress(TObject *Sender, char &Key);
        void __fastcall sbGenVisorX3DClick(TObject *Sender);
        void __fastcall sbGenVisorH3DClick(TObject *Sender);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall sbAyudaClick(TObject *Sender);
        void __fastcall FntLbElementosClick(TObject *Sender);
private:	// User declarations

        // Para la configuracin de los nodos H3D y X3D es necesario usar:
        GestorNodos *GN;
        GestorTipos *GT;

        // Podemos estar editando un tipo nuevo o uno que ya exista, lo
        // controlamos con esta variable:
        bool TiposEditandoTipoNuevo;
        // Podemos estar editando un nodo nuevo o uno que ya exista, lo
        // controlamos con esta variable:
        bool NodosEditandoNodoNuevo;

        // Para algunas operaciones que se hacen en la clase es til tener
        // un buffer temporal:
        TStringList *LineasAux;

        // Podemos estar editando un campo nuevo o uno que ya exista, lo
        // controlamos con esta variable:
        bool NodosEditandoCampoNuevo;

        // Es el ndice del gestor de nodos asociado al nodo actual:
        int NodosIndex;

        // Estas variables controlan cuando han cambiado los datos de los
        // gestores de tipos y de nodos.
        bool TiposHanCambiado;
        bool NodosHanCambiado;

        // Apunta a los datos del elemento de autotexto actualmente seleccionado.
        // Cuando se est editando un elemento nuevo ser NULL. Se usa para
        // guardar los cambios en elementos AT, ya sean nuevos o editados.
        DatosAT *ElementoSeleccionadoAT;

        // Controla cuando se han cambiado los datos de AutoCompletar.
        bool HaCambiadoAT;

        // Es un array de punteros a DatosAT que contendr todos los elementos
        // AT editados.
        DatosAT **ElementosAT;

        int NumElementosAT;  // El el nmero de elementos no nulos que hay en ElementosAT.
        int TamElementosAT;  // El el nmero total de elementos que hay en AT.

        // Hay dos posibles tamaos de fuente: Para el Editor y para la Escena.
        // As que el Texto de Muestra aparecer con el ltimo tamao que se haya
        // especificado. Con esta variable sabremos qu tamao aplicar.
        bool UltimoEsEditor;

        // Salva los datos contenidos en los controles del Tab Fuente a CONF.
        void __fastcall SalvaTabFuenteA_CONF();

        // Ser un array de objetos FntDatosElemento. Contendr la informacin
        // de formato (Color,negrita,cursiva) asociado a cada tipo de elemento.
        // El tamao del array ser FntLbElementos->Items->Count
        FntDatosElemento *FntDatosElementos;

        // Toma los valores actuales de CONF y actualiza todos los controles
        // de todos los Tabs de frmConfiguracin.
        // Si se produce algn error devuelve false (por ejemplo si no existen
        // los ficheros de configuracin).
        bool __fastcall CargaDatosCONF();
        // Hace el paso inverso. Salva todos los datos contenidos en los controles
        // de frmConfiguracion y los salva en CONF.
        void __fastcall SalvaDatosCONF();

        // Cada vez que se modificican los datos de los controles contenidos en
        // FntGbPropiedades hay que llamar a esta funcin que actualiza el
        // contenido deFntDatosElemn
        void __fastcall FntCambiaPropiedad();

        // Esta funcin formatea el texto contenido en FntMuestra con la
        // informacin contenida en los controles del Tab Fuente:
        void __fastcall FntActualizaMuestra();

        // Actualiza los controles contenidos en FntGbPropiedades con el valor
        // asociado al elemento actual de FntDatosElementos.
        void __fastcall FntAsignaPropActual();

        // Rellena los gestores (de tipos y de nodos) con la informacin
        // guardada en disco:
        // h3d: Si es verdadero se cargan datos h3d (sino datos X3D).
        // valDefecto:  Si es verdadero se cargan los datos por defecto (si no se
        //              cargarn los datos configurados).
        // Si se produce algn error muestra un mensaje de error y devuelve false.
        bool __fastcall CargaGestores(bool h3d,bool valDefecto);

        // Salva los datos del gestor actual a disco.
        // Caso == 0 -> Solo se salva el gestor de tipos
        // Caso == 1 -> Solo se salva el gestor de nodos
        bool __fastcall SalvarGestor(int caso);

        // Elimina la imagen que contenga actualmente imagen.
        void __fastcall LimpiaImagen(TImage *imagen);

        // Intenta cargar en img el icono que estando en la carpeta de
        // imgenes del programa tiene el nombre file.
        // La funcin comprueba que la extensin es BMP, que el fichero exista
        //  y que el tamao sea tamxtam. Si falla alguna de estas condiciones
        // devuelve false. Si msg es true se muestran estos mensajes de error.
        // Si se pasa tam = -1 no se comprueba el tamao.
        // Un valor file = "-" se considera valido y se devolver true.
        bool __fastcall CargaImagen(TImage * img,AnsiString file,bool msg,int tam);

        // Devuelve true si cad contiene una y solo una palabra.
        // La funcin podr mostrar los siguientes mensajes de error:
        // si cad.Trim() == ""         -> inicioMsg + " debe existir."
        // si cad tiene + de 1 palabra -> inicioMsg + " debe tener solo una palabra."
        // cad se devuelve como cad.Trim() 
        bool __fastcall Es1SolaPalabra (AnsiString &cad,AnsiString inicioMsg);
        bool __fastcall Es1SolaPalabra_(AnsiString  cad,AnsiString inicioMsg); // Para evitar warnings.

        // Actualiza los controles de Tab Tipos con la informacin inicial.
        void __fastcall TiposCargarDatos();

        // Esta funcin chequea los datos del tipo nuevo que ha introducido el
        // usuario:
        //  (*) - El icono debe estar dentro de la carpeta de imgenes del programa
        //  (*) - El icono debe ser de tamao 20x20
        //      - El nombre del tipo debe tener solo una palabra
        //      - Se debe introducir al menos el nombre del tipo.
        // Si soloIcono es true se comprobarn solo (*)
        // Si se produce algn error se devuelve false:
        bool __fastcall TiposChequeaDatos(bool soloIcono);

        // Actualiza los datos de los controles asociado al tipo actual.
        // fil indica el nmero de la fila de la que se toman los datos.
        // Si fil es -1 se intentar usar la fila seleccionada.
        // Si fil es -2 se limpiarn todos los datos de los controles.
        void __fastcall TiposActualizaTipo(int fil=-1);

        // Si editar es true se activa la edicin del campo actual. Y si es false
        // se desactiva. Lo que se hace es activar o desactivar la propiedad
        // Enabled de los controles que recogen los datos del tipo y tanbin
        // la propiedad Caption del botn de edicin:
        void __fastcall TiposEditar(bool editar);

        // Si se han hecho cambios en el gestor de tipos actual se pregunta si
        // se desean salvar esos cambios. Si el usuario decide salvarlos se salvan
        // y devuelve true. Solo se devuelve false si el usuario pulsa cancelar.
        // Es decir se devuelve true si se debe continuar con el proceso.
        bool __fastcall TiposPreguntarSalvar();

        // Actualiza los controles de Tab Tipos con la informacin inicial.
        void __fastcall NodosCargarDatos();

        // Actualiza los controles del tab Nodos con el nodo asociado a numNodo
        // del gestor actual de nodos.
        void __fastcall NodosCargarNodo(int numNodo);

        // Si se han hecho cambios en el gestor de nodos actual se pregunta si
        // se desean salvar esos cambios. Si el usuario decide salvarlos se salvan
        // y devuelve true. Solo se devuelve false si el usuario pulsa cancelar.
        // Es decir se devuelve true si se debe continuar con el proceso.
        bool __fastcall NodosPreguntarSalvar();

        // Preparan todos los controles para comenzar la edicin o para terminarla.
        // editar a true para comenzar la edicin de datos (y a false para acabarla
        // y poner a false la propiedad Enabled de los controles). Si nuevo es true
        // se iniciar con "" el texto de los controles.
        void __fastcall NodosEditar(bool editar,bool nuevo);

        // Preparan todos los controles para comenzar la edicin de un campo o
        // para terminarla.
        // editar a true para comenzar la edicin de datos (y a false para acabarla
        // y poner a false la propiedad Enabled de los controles). Si nuevo es true
        // se iniciar con "" el texto de los controles.
        void __fastcall NodosDatosCampoEditar(bool editar,bool nuevo);

        // Comprueba que los valores introducidos por el usuario son vlidos
        // para el nodo que se est creando/editando:
        bool __fastcall NodosChequeaDatos();

        // Comprueba que los valores introducidos por el usuario son vlidos
        // para el campo que se est creando/editando:
        bool __fastcall NodosChequeaDatosCampo();

        // Actualiza el contenido de NodosGrid con los datos de nodo.
        void __fastcall NodosActualizaGrid(Nodo *nodo);

        // Salva a disco los datos contenidos actuales del autotexto.
        void __fastcall SalvarAT();

        // Carga los controles de tabAT con la informacion guardada en el
        // fichero file. Devuelve false si no se puede abrir el fichero.
        bool __fastcall CargarDatosAT(AnsiString file);

        // Libera la memoria ocupada por ElementosAT.
        void __fastcall LiberaMemoriaAT();

        // Actualiza el contenido de todos los controles de AT. Se puede usar
        // cuando se ha hecho algn cambio en los datos. 
        void __fastcall ActualizaAT();

public:		// User declarations
        // Muestra la ventana de configuracin. tab indica el nmero de tab
        // que se desea mostrar. Valores posibles de tab:
        //  0 --> Tipo de Fuente usado en el editor.
        //  1 --> Tipos X3D/H3D.
        //  2 --> Campos X3D/H3D.
        // Devuelve verdadero si el usuario decide salvar los cambios y falso
        // en caso contrario.
        bool __fastcall Inicia(int tab=0);

        // CargaAT todos los elementos de AT guardados en el fichero de
        // configuracin que tengan la extensin extension en lb. Los punteros
        // lb->Objects se asignan a AnsiString que contienen el autotexto.
        // La memoria que se reserva hay que liberarla con DescargaAT();
        // Antes de cargar los datos CargaAT llama a DescargaAT. 
        void __fastcall CargaAT(TListBox *lb,AnsiString extension);
        void __fastcall DescargaAT(TListBox *lb);

        // Devuelve una de las siguientes cadenas para informar sobre cual es
        // el tab actual: "Fuente", "Tipos", "Nodos", "AutoTexto", "General"
        AnsiString __fastcall GetTabActual();

        __fastcall ~TfrmConfiguracion();
        __fastcall TfrmConfiguracion(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmConfiguracion *frmConfiguracion;
//---------------------------------------------------------------------------
#endif
