//
//     frmConfiguracion  
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta es la clase implementa un interfaz para configurar todos
                los parmetros del programa.
*/

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "frmConfiguracion_.h"
#include "frmEditor_.h"
#include "frmEscena_.h"
#include "frmUtilidad_.h"
#include "Utilidad_.h"
#include "RichEditVRML_.h"

#include "Main_.h"

// Contiene la ruta del fichero de configuracin que contiene los datos del
// autotexto, se espera que tenga el siguiente formato:
/*

-> ELEMENTO: < Identificador del Elemento AT >  <extension>
  Aqui va el autotexto del elemento
  pueden ser varias lneas.

Ejemplo de Fichero:

-> ELEMENTO: < Clase1 > <py>
class NombreClase()
  __init__ (parametros)
-> ELEMENTO: < Clase2 > <py>
class NombreClase()
  __init__ (parametros) */
#define FICH_CONF_AT "AutoTexto.cfg"

// Contiene los valores por defecto de FICH_CONF_AT
#define FICH_CONF_AT_VD "AutoTextoVD.cfg"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmConfiguracion *frmConfiguracion;
//---------------------------------------------------------------------------
__fastcall TfrmConfiguracion::TfrmConfiguracion(TComponent* Owner)
        : TForm(Owner)
{
    try{
       GN=new GestorNodos();
       GT=new GestorTipos();
       LineasAux = new TStringList();
    }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

    TiposHanCambiado=false;
    NodosHanCambiado=false;
    HaCambiadoAT=false;
    TiposEditandoTipoNuevo=true;
    NodosEditandoNodoNuevo=true;
    NodosEditandoCampoNuevo=true;
    NodosIndex=0;

    ElementosAT=NULL;
    NumElementosAT=0;
    TamElementosAT=0;
    ElementoSeleccionadoAT=NULL;
}
//---------------------------------------------------------------------------
__fastcall TfrmConfiguracion::~TfrmConfiguracion(){
   delete GT;
   delete GN;
   LiberaMemoriaAT();
   delete LineasAux;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FormCreate(TObject *Sender)
{
   Caption = Main->Caption;

   UltimoEsEditor=true;

   // Rellenamos la ComboBox FntCBFuente con los tipos de fuente del sistema:
   for (int i = 0; i < Screen->Fonts->Count; i++)
      FntCbFuente->Items->Add(Screen->Fonts->Strings[i]);

   // Rellenamos los posibles tamaos de las fuentes.
   for (int i = 8; i <= 40; i++){
      FntCbTamEditor->Items->Append(IntToStr(i));
      FntCbTamEscena->Items->Append(IntToStr(i));
      i++;
   }

   // Vamos a asignar cada uno de los tipos de elementos que se distinguen
   // en el cdigo VRML: (SI SE ALTERA SU ORDEN HABR QUE CAMBIAR TAMBIEN LAS
   // FUNCIONES: CargaDatosCONF y SalvaDatosCONF)
   FntLbElementos->Clear();
   FntLbElementos->Items->Append("Comments");
   FntLbElementos->Items->Append("Strings");
   FntLbElementos->Items->Append("Default Format");
   FntLbElementos->Items->Append("Block markers");
   FntLbElementos->Items->Append("Node Names");
   FntLbElementos->Items->Append("Field Names");
   FntLbElementos->Items->Append("Reserved Words");
   FntLbElementos->Items->Append("Identifiers");

   // Para cada uno de los elementos de la lista: FntLbElementos tenemos que
   // crear un objeto de la clase FntDatosElemento e inicializar sus datos:
   try{ FntDatosElementos = new FntDatosElemento[FntLbElementos->Items->Count]; }
   catch(...){  Utilidad.FatalErrorFaltaMemoria();  }

   // Asignamos los ttulos de las columnas de NodosGrid:
   NodosGrid->Cells[0][0]="";
   NodosGrid->Cells[1][0]="Name";
   NodosGrid->Cells[2][0]="";
   NodosGrid->Cells[3][0]="Type";
   NodosGrid->Cells[4][0]="Default Value";


   // Ahora hay que cargar los datos guardados en CONF a FntDatosElementos.
   CargaDatosCONF();

   // Inicializamos los valores de las Combobox:
   for(int c=0; c <= 30; c++)
      comboGenJustificado->Items->Append(c);

   // Damos valores entre 500 y 10000 en pasos de 500:
   for(int c=1; c <= 20; c++)
      comboGenRetardoAC->Items->Append(c * 500);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FormDestroy(TObject *Sender)
{
   if(FntDatosElementos != NULL)
      delete FntDatosElementos;
}

//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::sbCancelarClick(TObject *Sender)
{
   ModalResult=mrCancel;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::sbAceptarClick(TObject *Sender)
{
   ModalResult=mrOk;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::Inicia(int tab){

   if( (tab < 0) || (tab >= Carpetas->PageCount) )
      return false;

   Carpetas->ActivePageIndex=tab;
   // Ahora inicializamos todos los controles de todos los Tabs. Hay que hacerlo
   // en todos los tabs por si el usuario cambia de tab:
   // Si se produce un error es mejor volver porque podran aparecer datos
   // erroneos.
   if(!CargaDatosCONF())
      return false;

   // Actualizamos la muestra de cdigo VRML:
   FntActualizaMuestra();

   if(mrOk == ShowModal()){
      // Hay que salvar todos los datos que se hayan modificado:
      SalvaDatosCONF();
      CONF.SalvarDatos();
      // Despus de habar salvado los datos podemos liberar la memoria.
      LiberaMemoriaAT();
      return true;
   }
   LiberaMemoriaAT();
   return false;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntPnl01Click(TObject *Sender)
{
   // Con esto hacemos que FntPnlSeleccionado tome el color del panel que se pulsa.
   FntPnlSeleccionado->Color = ((TPanel *)Sender)->Color;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntPnlColorPropsClick(TObject *Sender)
{
    ((TPanel *)Sender)->Color = FntPnlSeleccionado->Color;
    FntActualizaMuestra();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntMuestraKeyPress(TObject *Sender,
      char &Key)
{
   Key='\0';
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntAsignaPropActual(){
   if( FntLbElementos->Items->Count <= 0)
      return;
   // Si no hay ningn elemento seleccionado, seleccionamos el primero:
   if( FntLbElementos->ItemIndex == -1)
     FntLbElementos->ItemIndex = 0;

   FntCbNegritaProps->Checked = FntDatosElementos[FntLbElementos->ItemIndex].Negrita;
   FntCbCursivaProps->Checked = FntDatosElementos[FntLbElementos->ItemIndex].Cursiva;
   FntPnlColorProps->Color    = FntDatosElementos[FntLbElementos->ItemIndex].Color;
}
//---------------------------------------------------------------------------

bool __fastcall TfrmConfiguracion::CargaDatosCONF(){

   //------------------------ ACTUALIZACIN DEL TAB: Fuente ------------------
   FntRbEnrriquecido->Checked =  CONF.FORMATEAR_CODIGO;
   FntRbSencillo->Checked     = !CONF.FORMATEAR_CODIGO;
   FntPnlColorFondo->Color    =  CONF.Formato_COLOR_FONDO;
   int index = FntCbFuente->Items->IndexOf( CONF.Formato_NOMBRE_FUENTE );
   FntCbFuente->ItemIndex     =  (-1 != index) ? index : 0;

   index = FntCbTamEscena->Items->IndexOf( IntToStr(CONF.Formato_TAM_FUENTE_ESCENA) );
   FntCbTamEscena->ItemIndex     =  (-1 != index) ? index : 0;

   index = FntCbTamEditor->Items->IndexOf( IntToStr(CONF.Formato_TAM_FUENTE_EDITOR) );
   FntCbTamEditor->ItemIndex     =  (-1 != index) ? index : 0;

   FntCbNegritaGen->Checked = CONF.Formato_GENERAL_NC & CFE_BOLD;
   FntCbCursivaGen->Checked = CONF.Formato_GENERAL_NC & CFE_ITALIC;

   FntPnlColorGen->Color = CONF.Formato_GENERAL_color;
   FntLbElementos->ItemIndex = 0;
   // Ahora hay que inicializar los valores de los elementos de FntLbElementos:
   if( (FntDatosElementos != NULL) && (FntLbElementos->Items->Count == 8) ){
       // No merece la pena complicar el cdigo con comprobaciones innecesarias,
       // as que asumo que el contenido de la lista es:
       // Comentarios
       // Cadenas
       // Formato Normal
       // Delimitadores de Bloques
       // Nombres de Nodos
       // Nombres de Campos
       // Palabras Reservadas
       // Indentificadores
       FntDatosElementos[0].Set(CONF.Formato_COMENTARIO_color,CONF.Formato_COMENTARIO_NC);
       FntDatosElementos[1].Set(CONF.Formato_CADENA_color,CONF.Formato_CADENA_NC);
       FntDatosElementos[2].Set(CONF.Formato_NORMAL_color,CONF.Formato_NORMAL_NC);
       FntDatosElementos[3].Set(CONF.Formato_LLAVES_Y_CORCHETES_color,CONF.Formato_LLAVES_Y_CORCHETES_NC);
       FntDatosElementos[4].Set(CONF.Formato_NODO_color,CONF.Formato_NODO_NC);
       FntDatosElementos[5].Set(CONF.Formato_CAMPO_color,CONF.Formato_CAMPO_NC);
       FntDatosElementos[6].Set(CONF.Formato_PALABRA_RESERVADA_color,CONF.Formato_PALABRA_RESERVADA_NC);
       FntDatosElementos[7].Set(CONF.Formato_IDENTIFICADOR_color,CONF.Formato_IDENTIFICADOR_NC);
   }
   FntAsignaPropActual();
   //------------------------ ACTUALIZACIN DEL TAB Tipos:  ---------------------
   if(!CargaGestores(false,false))
      return false;
   TiposCargarDatos();
   TiposActualizaTipo();
   TiposHanCambiado=false;
   //------------------------ ACTUALIZACIN DEL TAB Nodos:  ---------------------
   NodosCargarDatos();
   NodosHanCambiado=false;

   //------------------------ ACTUALIZACIN DEL TAB AutoTexto:  ---------------------
   AnsiString file = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION +
                                             "\\" + FICH_CONF_AT;
   if(!CargarDatosAT(file))
      return false;
   HaCambiadoAT=false;

   //------------------------ ACTUALIZACIN DEL TAB General  :  ---------------------

   edGenPrimeraLineaH3D      ->Text = CONF.PRIMERA_LINEA_FICH_H3D;
   edGenPrimeraLineaX3D      ->Text = CONF.PRIMERA_LINEA_FICH_X3D;
   edGenPalabrasReservadas   ->Text = CONF.PALABRAS_RESERVADAS;
   edGenNodosSinAnidamiento  ->Text = CONF.NODOS_SIN_ANIDAMIENTO;

   rbGenHerramientasVentana->Checked= (CONF.VER_HERRAMIENTAS_COMO == "VENTANA");
   rbGenHerramientasBarra  ->Checked= (CONF.VER_HERRAMIENTAS_COMO == "BARRA");
   rbGenHerramientasOcultar->Checked= (CONF.VER_HERRAMIENTAS_COMO == "OCULTA");

   rbGenEscenaIniH3D       ->Checked= (CONF.TIPO_ESCENA_POR_DEFECTO == ESCENA_H3D);
   rbGenEscenaIniX3D       ->Checked= (CONF.TIPO_ESCENA_POR_DEFECTO == ESCENA_X3D);

   edGenVisorX3D             ->Text = CONF.PATH_EXPLORER;
   edGenVisorH3D             ->Text = CONF.PATH_H3D_LOAD;
   cbUsarConsolaH3D          ->Checked= CONF.USAR_CONSOLA_H3D_AL_EJECUTAR_H3D;
   edGenUIT                  ->Text = CONF.URL_USER_INTERFACE_TOOLKIT;
   cbGenAutoCompletar      ->Checked= CONF.USAR_AUTO_COMPLETAR;
   cbGenNombrarNodos       ->Checked= CONF.NOMBRAR_NODOS_AUTOMATICAMENTE;

   AnsiString cad = IntToStr(CONF.FICH_NUM_CARACTERES_JUSTIF);
   if( -1 != comboGenJustificado->Items->IndexOf(cad) )
      comboGenJustificado->ItemIndex = comboGenJustificado->Items->IndexOf(cad);

   cad = IntToStr(CONF.RETARDO_AUTO_COMPLETAR);
   if( -1 != comboGenRetardoAC->Items->IndexOf(cad) )
      comboGenRetardoAC->ItemIndex = comboGenRetardoAC->Items->IndexOf(cad);

   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::SalvaDatosCONF(){

   //----------------------------------- SALVAMOS EL TAB: Fuente -------------
   SalvaTabFuenteA_CONF();
   //----------------------------------- SALVAMOS EL TAB: Tipos  -------------
   if(TiposHanCambiado){
      SalvarGestor(0);
      TiposHanCambiado = false;
   }
   //----------------------------------- SALVAMOS EL TAB: Nodos  -------------
   if(NodosHanCambiado){
      SalvarGestor(1);
      NodosHanCambiado = false;
   }
   //----------------------------------- SALVAMOS EL TAB: AT     -------------
   if(HaCambiadoAT){
      SalvarAT();
      HaCambiadoAT = false;
   }
   //----------------------------------- SALVAMOS EL TAB: General ------------
   CONF.PRIMERA_LINEA_FICH_H3D      = edGenPrimeraLineaH3D->Text;
   CONF.PRIMERA_LINEA_FICH_X3D      = edGenPrimeraLineaX3D->Text;
   CONF.PALABRAS_RESERVADAS         = edGenPalabrasReservadas->Text;
   CONF.NODOS_SIN_ANIDAMIENTO       = edGenNodosSinAnidamiento->Text;

   if(rbGenHerramientasVentana->Checked)
      CONF.VER_HERRAMIENTAS_COMO = "VENTANA";
   else if(rbGenHerramientasBarra->Checked)
      CONF.VER_HERRAMIENTAS_COMO = "BARRA";
   else
      CONF.VER_HERRAMIENTAS_COMO = "OCULTA";

   if(rbGenEscenaIniH3D->Checked)
      CONF.TIPO_ESCENA_POR_DEFECTO = ESCENA_H3D;
   else if(rbGenEscenaIniX3D->Checked)
      CONF.TIPO_ESCENA_POR_DEFECTO = ESCENA_X3D;

   CONF.PATH_EXPLORER = edGenVisorX3D->Text;
   CONF.PATH_H3D_LOAD =edGenVisorH3D->Text;
   CONF.USAR_CONSOLA_H3D_AL_EJECUTAR_H3D = cbUsarConsolaH3D->Checked;
   CONF.URL_USER_INTERFACE_TOOLKIT = edGenUIT->Text;
   CONF.USAR_AUTO_COMPLETAR = cbGenAutoCompletar->Checked;
   CONF.NOMBRAR_NODOS_AUTOMATICAMENTE = cbGenNombrarNodos->Checked;

   try{ CONF.FICH_NUM_CARACTERES_JUSTIF = StrToInt(comboGenJustificado->Text);    }
   catch(...){ /* No hacemos nada.*/ }

   try{ CONF.RETARDO_AUTO_COMPLETAR = StrToInt(comboGenRetardoAC->Text); }
   catch(...){ /* No hacemos nada.*/ }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntCambiaPropiedad(){
   if(FntLbElementos->ItemIndex == -1)
      return;
   FntDatosElementos[FntLbElementos->ItemIndex].Negrita = FntCbNegritaProps->Checked;
   FntDatosElementos[FntLbElementos->ItemIndex].Cursiva = FntCbCursivaProps->Checked;
   FntDatosElementos[FntLbElementos->ItemIndex].Color   = FntPnlColorProps->Color;
}
//---------------------------------------------------------------------------

void __fastcall TfrmConfiguracion::FntCbNegritaPropsKeyUp(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
   FntCambiaPropiedad();
   FntActualizaMuestra();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntCbNegritaPropsMouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
   FntCambiaPropiedad();
   FntActualizaMuestra();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntActualizaMuestra(){

   // El mejor modo de actualizar el cdigo de FntMuestra es salvar en variables
   // temporales los datos actuales de CONF referentes al formato del texto y
   // a continuacin asignar los datos de los controles del tab Fuente a CONF.
   // En este punto solo falta llamar a la funcin que da formato al texto
   // contenido en muestra y finalmente restaurar los valores de CONF.

   // PASO 1: SALVAR LOS VALORES DE CONF EN VARIABLES TEMPORALES:
   bool FormatearCodigo =  CONF.FORMATEAR_CODIGO;
   TColor Formato_COLOR_FONDO = CONF.Formato_COLOR_FONDO;
   AnsiString Formato_NOMBRE_FUENTE = CONF.Formato_NOMBRE_FUENTE;
   int Formato_TAM_FUENTE_ESCENA = CONF.Formato_TAM_FUENTE_ESCENA;
   int Formato_TAM_FUENTE_EDITOR = CONF.Formato_TAM_FUENTE_EDITOR;

   DWORD  Formato_COMENTARIO_NC            = CONF.Formato_COMENTARIO_NC;
   TColor Formato_COMENTARIO_color         = CONF.Formato_COMENTARIO_color;
   DWORD  Formato_NO_VISIBLE_NC            = CONF.Formato_NO_VISIBLE_NC;
   TColor Formato_NO_VISIBLE_color         = CONF.Formato_NO_VISIBLE_color;
   DWORD  Formato_CADENA_NC                = CONF.Formato_CADENA_NC;
   TColor Formato_CADENA_color             = CONF.Formato_CADENA_color;
   DWORD  Formato_LLAVES_Y_CORCHETES_NC    = CONF.Formato_LLAVES_Y_CORCHETES_NC;
   TColor Formato_LLAVES_Y_CORCHETES_color = CONF.Formato_LLAVES_Y_CORCHETES_color;
   DWORD  Formato_CAMPO_NC                 = CONF.Formato_CAMPO_NC;
   TColor Formato_CAMPO_color              = CONF.Formato_CAMPO_color;
   DWORD  Formato_IDENTIFICADOR_NC         = CONF.Formato_IDENTIFICADOR_NC;
   TColor Formato_IDENTIFICADOR_color      = CONF.Formato_IDENTIFICADOR_color;
   DWORD  Formato_NORMAL_NC                = CONF.Formato_NORMAL_NC;
   TColor Formato_NORMAL_color             = CONF.Formato_NORMAL_color;
   DWORD  Formato_NODO_NC                  = CONF.Formato_NODO_NC;
   TColor Formato_NODO_color               = CONF.Formato_NODO_color;
   DWORD  Formato_PALABRA_RESERVADA_NC     = CONF.Formato_PALABRA_RESERVADA_NC;
   TColor Formato_PALABRA_RESERVADA_color  = CONF.Formato_PALABRA_RESERVADA_color;
   TColor Formato_GENERAL_color            = CONF.Formato_GENERAL_color;
   DWORD Formato_GENERAL_NC                = CONF.Formato_GENERAL_NC;

   // PASO 2: ASIGNAR LOS VALORES DE CONF USANDO LA INFORMACION DE LOS CONTROLES.
   SalvaTabFuenteA_CONF();

   // PASO 3: ASIGNAR COLOR DE FONDO, TAMAO y FUENTE DE FntMuesta:

   // Para que los cambios en el texto y en la fuente tengan efecto en el
   // control RichEdit es necesario borrar el texto as que usamos como buffer
   // temporal LineasAux

   // Salvamos la seleccin actual:
   int pos = FntMuestra->SelStart;
   int lon = FntMuestra->SelLength;

   // Para que cambie el tamao de la fuente es necesario poner FntMuestra->ReadOnly
   // a false
   FntMuestra->ReadOnly = false;

   // Desactivamos la actualizacin del control para evitar parpados.
   ReVRML.BloqueaRepaint(FntMuestra);

   LineasAux->Text = FntMuestra->Text;

   FntMuestra->Clear();
   int s;
   try{
      if(UltimoEsEditor)
         s = StrToInt(FntCbTamEditor->Text);
      else
         s = StrToInt(FntCbTamEscena->Text);

   }catch (...){
      s = 10;
   }
   FntMuestra->Font->Size = s;
   FntMuestra->Font->Name = FntCbFuente->Text;
   FntMuestra->Color = FntPnlColorFondo->Color;
   FntMuestra->Font->Color = FntPnlColorGen->Color;
   FntMuestra->Font->Style = TFontStyles();
   if(FntCbNegritaGen->Checked)
      FntMuestra->Font->Style = FntMuestra->Font->Style << fsBold;
   if(FntCbCursivaGen->Checked)
      FntMuestra->Font->Style = FntMuestra->Font->Style << fsItalic;

   FntMuestra->ReadOnly = true;

   // Ya podemos representar el texto.
   FntMuestra->Text = LineasAux->Text;

   // PASO 4: DAR FORMATO AL TEXTO SI ES NECESARIO.
   if(FntRbEnrriquecido->Checked)
      ReVRML.FormateaPantalla(this,FntMuestra);

   // Reponemos la seleccin anterior.
   FntMuestra->SelStart = pos;
   FntMuestra->SelLength= lon;

   // Activamos de nuevo la actualizacin del control RichEdit
   ReVRML.PermiteRepaint(FntMuestra);

   InvalidateRect(FntMuestra->Handle, 0, true);   // Equivale a Repaint();

   // PASO 5: RESTAURAMOS LOS VALORES DE CONF.

   CONF.FORMATEAR_CODIGO = FormatearCodigo;
   CONF.Formato_COLOR_FONDO = Formato_COLOR_FONDO;
   CONF.Formato_NOMBRE_FUENTE = Formato_NOMBRE_FUENTE;
   CONF.Formato_TAM_FUENTE_ESCENA = Formato_TAM_FUENTE_ESCENA;
   CONF.Formato_TAM_FUENTE_EDITOR = Formato_TAM_FUENTE_EDITOR;

   CONF.Formato_COMENTARIO_NC            = Formato_COMENTARIO_NC;
   CONF.Formato_COMENTARIO_color         = Formato_COMENTARIO_color;
   CONF.Formato_NO_VISIBLE_NC            = Formato_NO_VISIBLE_NC;
   CONF.Formato_NO_VISIBLE_color         = Formato_NO_VISIBLE_color;
   CONF.Formato_CADENA_NC                = Formato_CADENA_NC;
   CONF.Formato_CADENA_color             = Formato_CADENA_color;
   CONF.Formato_LLAVES_Y_CORCHETES_NC    = Formato_LLAVES_Y_CORCHETES_NC;
   CONF.Formato_LLAVES_Y_CORCHETES_color = Formato_LLAVES_Y_CORCHETES_color;
   CONF.Formato_CAMPO_NC                 = Formato_CAMPO_NC;
   CONF.Formato_CAMPO_color              = Formato_CAMPO_color;
   CONF.Formato_IDENTIFICADOR_NC         = Formato_IDENTIFICADOR_NC;
   CONF.Formato_IDENTIFICADOR_color      = Formato_IDENTIFICADOR_color;
   CONF.Formato_NORMAL_NC                = Formato_NORMAL_NC;
   CONF.Formato_NORMAL_color             = Formato_NORMAL_color;
   CONF.Formato_NODO_NC                  = Formato_NODO_NC;
   CONF.Formato_NODO_color               = Formato_NODO_color;
   CONF.Formato_PALABRA_RESERVADA_NC     = Formato_PALABRA_RESERVADA_NC;
   CONF.Formato_PALABRA_RESERVADA_color  = Formato_PALABRA_RESERVADA_color;
   CONF.Formato_GENERAL_color            = Formato_GENERAL_color;
   CONF.Formato_GENERAL_NC               = Formato_GENERAL_NC;

}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntCbTamEscenaChange(TObject *Sender)
{
   UltimoEsEditor=false;
   FntActualizaMuestra();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntCbNegritaGenKeyUp(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
   FntActualizaMuestra();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntCbNegritaGenMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
   FntActualizaMuestra();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::SalvaTabFuenteA_CONF(){

  CONF.FORMATEAR_CODIGO = FntRbEnrriquecido->Checked;
  CONF.Formato_COLOR_FONDO = FntPnlColorFondo->Color;
  CONF.Formato_NOMBRE_FUENTE = FntCbFuente->Text;

  try{
     CONF.Formato_TAM_FUENTE_EDITOR = StrToInt(FntCbTamEditor->Text);
  }catch (...){
     CONF.Formato_TAM_FUENTE_EDITOR = 10;
  }

  try{
     CONF.Formato_TAM_FUENTE_ESCENA = StrToInt(FntCbTamEscena->Text);
  }catch (...){
     CONF.Formato_TAM_FUENTE_ESCENA = 10;
  }

  // Activamos los flags asociados a FntCbNegritaGen y FntCbCursivaGen
  CONF.Formato_GENERAL_NC=0;
  if(FntCbNegritaGen->Checked)
    CONF.Formato_GENERAL_NC = CONF.Formato_GENERAL_NC | CFE_BOLD;
  if(FntCbCursivaGen->Checked)
    CONF.Formato_GENERAL_NC = CONF.Formato_GENERAL_NC | CFE_ITALIC;

  CONF.Formato_GENERAL_color = FntPnlColorGen->Color;
  // Ahora hay que salvar los valores de los elementos de FntLbElementos:
  if( (FntDatosElementos != NULL) && (FntLbElementos->Items->Count == 8) ){
      // No merece la pena complicar el cdigo con comprobaciones innecesarias,
      // as que asumo que el contenido de la lista es:
      // Comentarios
      // Cadenas
      // Formato Normal
      // Delimitadores de Bloques
      // Nombres de Nodos
      // Nombres de Campos
      // Palabras Reservadas
      // Indentificadores
      FntDatosElementos[0].Get(CONF.Formato_COMENTARIO_color,CONF.Formato_COMENTARIO_NC);
      FntDatosElementos[1].Get(CONF.Formato_CADENA_color,CONF.Formato_CADENA_NC);
      FntDatosElementos[2].Get(CONF.Formato_NORMAL_color,CONF.Formato_NORMAL_NC);
      FntDatosElementos[3].Get(CONF.Formato_LLAVES_Y_CORCHETES_color,CONF.Formato_LLAVES_Y_CORCHETES_NC);
      FntDatosElementos[4].Get(CONF.Formato_NODO_color,CONF.Formato_NODO_NC);
      FntDatosElementos[5].Get(CONF.Formato_CAMPO_color,CONF.Formato_CAMPO_NC);
      FntDatosElementos[6].Get(CONF.Formato_PALABRA_RESERVADA_color,CONF.Formato_PALABRA_RESERVADA_NC);
      FntDatosElementos[7].Get(CONF.Formato_IDENTIFICADOR_color,CONF.Formato_IDENTIFICADOR_NC);
  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntCbTamEditorChange(TObject *Sender)
{
   UltimoEsEditor=true;
   FntActualizaMuestra();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntCbFuenteChange(TObject *Sender)
{
   FntActualizaMuestra();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::sbRestaurarClick(TObject *Sender)
{
   AnsiString pregunta = "The default <> will be loaded. Dou you wish to continue?";
   int pos = pregunta.Pos("<>");
   if(-1 == pos)
      return;
   pregunta = pregunta.Delete(pos,2);

   if(Carpetas->ActivePageIndex == 0){ // FUENTE 
      pregunta.Insert("font values",pos);

      if(mrYes == frmUtilidad->Pregunta(pregunta) )
      {
         // Restauramos los valores por defecto de CONF.
         CONF.CargaFormatosTexto(DATOS_TEXTO_CON_FORMATO);
         CONF.FORMATEAR_CODIGO = CONF_VD.FORMATEAR_CODIGO;
         CONF.Formato_NOMBRE_FUENTE = CONF_VD.Formato_NOMBRE_FUENTE;

         // Actualizamos la informacin de todos los controles con la informacin de CONF.
         CargaDatosCONF();
         // Tb hay que actualizar la muestra de texto.
         FntActualizaMuestra();
      }
   }else if(Carpetas->ActivePageIndex == 1){ // TIPOS 
      if(GT == NULL){
         sbCancelarClick(NULL);
         return;
      }
      bool h3d = (GT->tipoEscena == ESCENA_H3D);
      if(h3d)
         pregunta.Insert("H3D types",pos);
      else
         pregunta.Insert("X3D types",pos);

      if(mrYes == frmUtilidad->Pregunta(pregunta) ){
         if(!CargaGestores(h3d,true)){
            sbCancelarClick(NULL);
            return;
         }
         TiposCargarDatos();
         TiposActualizaTipo();
         TiposHanCambiado=true;
      }
   }else if(Carpetas->ActivePageIndex == 2){ // NODOS 
      if(GN == NULL){
         sbCancelarClick(NULL);
         return;
      }
      bool h3d = (GN->tipoEscena == ESCENA_H3D);
      if(h3d)
         pregunta.Insert("H3D nodes",pos);
      else
         pregunta.Insert("X3D nodes",pos);

      if(mrYes == frmUtilidad->Pregunta(pregunta) ){
         if(!CargaGestores(h3d,true)){
            sbCancelarClick(NULL);
            return;
         }
         NodosCargarDatos();
         NodosHanCambiado=true;
      }
   }else if(Carpetas->ActivePageIndex == 3){ // AUTOTEXTO 

      pregunta.Insert("autotext values",pos);

      if(mrYes == frmUtilidad->Pregunta(pregunta) ){
         gbSeleccionadoAT->Enabled = false;
         sbEditarElementoAT->Caption = "Edit Element";
         // Solo tenemos que cargar el fichero que contiene los valores por defecto:
         AnsiString file = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION +
                                             "\\" + FICH_CONF_AT_VD;
         CargarDatosAT(file);
         HaCambiadoAT=true;
      }
   }else if(Carpetas->ActivePageIndex == 4){ // GENERAL 

      pregunta.Insert("general variable values",pos);

      if(mrYes == frmUtilidad->Pregunta(pregunta) ){

         edGenPrimeraLineaH3D      ->Text = CONF_VD.PRIMERA_LINEA_FICH_H3D;
         edGenPrimeraLineaX3D      ->Text = CONF_VD.PRIMERA_LINEA_FICH_X3D;
         edGenPalabrasReservadas   ->Text = CONF_VD.PALABRAS_RESERVADAS;
         edGenNodosSinAnidamiento  ->Text = CONF_VD.NODOS_SIN_ANIDAMIENTO;

         rbGenHerramientasVentana->Checked= (CONF_VD.VER_HERRAMIENTAS_COMO == "VENTANA");
         rbGenHerramientasBarra  ->Checked= (CONF_VD.VER_HERRAMIENTAS_COMO == "BARRA");
         rbGenHerramientasOcultar->Checked= (CONF_VD.VER_HERRAMIENTAS_COMO == "OCULTA");

         rbGenEscenaIniX3D       ->Checked= (CONF_VD.TIPO_ESCENA_POR_DEFECTO == ESCENA_X3D);
         rbGenEscenaIniH3D       ->Checked= (CONF_VD.TIPO_ESCENA_POR_DEFECTO == ESCENA_H3D);

         edGenVisorX3D             ->Text = CONF_VD.PATH_EXPLORER;
         edGenVisorH3D             ->Text = CONF_VD.PATH_H3D_LOAD;
         cbUsarConsolaH3D        ->Checked= CONF_VD.USAR_CONSOLA_H3D_AL_EJECUTAR_H3D;
         edGenUIT                  ->Text = CONF_VD.URL_USER_INTERFACE_TOOLKIT;
         cbGenAutoCompletar      ->Checked= CONF_VD.USAR_AUTO_COMPLETAR;
         cbGenNombrarNodos       ->Checked= CONF_VD.NOMBRAR_NODOS_AUTOMATICAMENTE;

         AnsiString cad = IntToStr(CONF_VD.FICH_NUM_CARACTERES_JUSTIF);
         if( -1 != comboGenJustificado->Items->IndexOf(cad) )
            comboGenJustificado->ItemIndex = comboGenJustificado->Items->IndexOf(cad);

         cad = IntToStr(CONF_VD.RETARDO_AUTO_COMPLETAR);
         if( -1 != comboGenRetardoAC->Items->IndexOf(cad) )
            comboGenRetardoAC->ItemIndex = comboGenRetardoAC->Items->IndexOf(cad);
      }
   }
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::CargaGestores(bool h3d,bool valDefecto){

   if( (GN == NULL) || (GT == NULL) )
      return false;

   AnsiString carpeta =  Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\";
   AnsiString fichero;

   if(h3d){
      fichero = CONF.FICHERO_CONFIG_TIPOS_H3D;
      if(valDefecto)
         Utilidad.UsarValorPorDefecto(fichero);
      fichero = carpeta  + fichero;
      if(!Utilidad.Existe(fichero))
         return false;

      GT->CargarFichConf(fichero, ESCENA_H3D);

      fichero = CONF.FICHERO_CONFIG_NODOS_H3D;
      if(valDefecto)
         Utilidad.UsarValorPorDefecto(fichero);
      fichero = carpeta  + fichero;
      if(!Utilidad.Existe(fichero))
         return false;

      GN->CargarFichConf(fichero, ESCENA_H3D,GT);

   }else{  // Caso: VRML

      fichero = CONF.FICHERO_CONFIG_TIPOS_X3D;
      if(valDefecto)
         Utilidad.UsarValorPorDefecto(fichero);
      fichero = carpeta  + fichero;
      if(!Utilidad.Existe(fichero))
         return false;

      GT->CargarFichConf(fichero, ESCENA_X3D);

      fichero = CONF.FICHERO_CONFIG_NODOS_X3D;
      if(valDefecto)
         Utilidad.UsarValorPorDefecto(fichero);
      fichero = carpeta + fichero;
      if(!Utilidad.Existe(fichero))
         return false;

      GN->CargarFichConf(fichero, ESCENA_X3D,GT);
   }
   return true;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::SalvarGestor(int caso){

   if( (GN == NULL) || (GT == NULL) )
      return false;
   AnsiString cad = (caso == 0) ? "types" : "nodes";
   Utilidad.MsgInfo("The changes made in " + cad + " will take effect the next time you run DisReal.");

   AnsiString carpeta =  Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION + "\\";
   AnsiString fichero;

   if(caso == 0){  // Salvamos el gestor de tipos:
      if(0 == GT->GetNumTipos() ){
         Utilidad.MsgInfo("You must declare one type at least.","Advertencia");
         return false;
      }
      if(GT->tipoEscena == ESCENA_H3D)
         fichero = carpeta  + CONF.FICHERO_CONFIG_TIPOS_H3D;
      else
         fichero = carpeta  + CONF.FICHERO_CONFIG_TIPOS_X3D;
      return GT->SalvarFichConf(fichero);
   }else{  // Salvamos el gestor de nodos.
      if(0 == GN->GetNumNodos() ){
         Utilidad.MsgInfo("You must declare one node at least.","Advertencia");
         return false;
      }
      if(GN->tipoEscena == ESCENA_H3D)
         fichero = carpeta  + CONF.FICHERO_CONFIG_NODOS_H3D;
      else
         fichero = carpeta  + CONF.FICHERO_CONFIG_NODOS_X3D;
      return GN->SalvarFichConf(fichero);
   }
}
//------------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposCargarDatos(){
   if(GT == NULL)
      return;
   Tipo *tipo;
   int nTipos;

   TiposEditar(false);

   nTipos=GT->GetNumTipos();

   if(nTipos == 0)
      TiposGrid->RowCount= 2;
   else
      TiposGrid->RowCount= nTipos+1;
   TiposGrid->Cells[0][0]= "";
   TiposGrid->Cells[1][0]= "Icon";
   TiposGrid->Cells[2][0]= "Name";
   TiposGrid->Cells[3][0]= "Example";
   TiposGrid->Cells[4][0]= "Children";

   if(nTipos==0){
      // Siempre dejamos al menos una fila en TiposGrids (sin contar la de ttulos).
      // Por eso tenemos que considerar este caso especial:
      TiposGrid->Cells[0][1]= "";
      TiposGrid->Cells[1][1]= "";
      TiposGrid->Cells[2][1]= "";
      TiposGrid->Cells[3][1]= "";
      TiposGrid->Cells[4][1]= "";
      return;
   }

   for(int i=1; i < nTipos+1; i++){
      tipo=GT->DatosTipo(i-1);
      if(tipo != NULL){
         TiposGrid->Cells[0][i]= "";
         TiposGrid->Cells[1][i]= tipo->nombreIcono;
         TiposGrid->Cells[2][i]= tipo->nombre;
         TiposGrid->Cells[3][i]= tipo->ejemplo;
         switch (tipo->numHijos)         {
            case 0:  TiposGrid->Cells[4][i]= "None"; break;
            case 1:  TiposGrid->Cells[4][i]= "SFNode";  break;
            case 2:  TiposGrid->Cells[4][i]= "MFNode";  break;
         }
      }
   }
   AnsiString titulo = (GT->tipoEscena==ESCENA_X3D)  ? " X3D" : "H3D";
   titulo+= " Type List.";
   TiposGbLista->Caption = titulo;
}
//------------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposGridDrawCell(TObject *Sender,
      int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
   // Para no dibujar varias veces por fila solo pintamos cuando la columna es:
   if(ACol!=0)
      return;

   AnsiString nombretipo;
   Tipo *tipo;

   nombretipo=TiposGrid->Cells[2][ARow];

   // Ya tenemos el nombre del tipo base, ahora lo buscamos en el gestor de
   // nodos.
   tipo=GT->DatosTipo(nombretipo);
   if(tipo == NULL)
       return;
   TiposGrid->Canvas->Draw(Rect.left+1,Rect.top,tipo->icono->Bitmap);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposEditar(bool editar){

  TiposPnlEditarIcono->Enabled= editar;
  TiposGbNombre->Enabled   = editar;
  TiposGbEjemplo->Enabled  = editar;
  TiposGbHijos->Enabled    = editar;
  TiposSbAnadirEditar->Caption = editar ? "Save" : "Edit";
  if(editar)
     FocusControl(TiposEdNombre);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposSbAnadirEditarClick(TObject *Sender)
{
   if(TiposSbAnadirEditar->Caption == "Edit"){
      TiposEditandoTipoNuevo=false;
      TiposEditar(true);
   }else if(TiposSbAnadirEditar->Caption == "Save") {
      // Tenemos que salvar los datos del tipo que se est editando:
      if( (GT == NULL) || !TiposChequeaDatos(false) )
         return;
      int numHijos = (-1 == TiposCbHijos->ItemIndex) ? 0 : TiposCbHijos->ItemIndex;

      if(TiposEditandoTipoNuevo){
         // En este caso tenemos que aadir un nuevo tipo:
         GT->AnadirTipo(TiposEdNombre->Text,TiposEdIcono->Text,TiposEdEjemplo->Text,numHijos);
         TiposHanCambiado = true;
         TiposCargarDatos();
         TiposActualizaTipo();
      }else{
         // En este caso el tipo ya existe -> Lo actualizamos:
         Tipo *tipo = GT->DatosTipo(TiposGrid->Cells[2][TiposGrid->Selection.Top]);
         if(tipo != NULL){
            tipo->nombre      = TiposEdNombre ->Text;
            tipo->nombreIcono = TiposEdIcono  ->Text;
            tipo->ejemplo     = TiposEdEjemplo->Text;
            tipo->numHijos    = numHijos;
            Utilidad.GetImagen(tipo->icono,tipo->nombreIcono,CONF.ICONO_GENERAL_TIPO);
            TiposHanCambiado = true;
            TiposCargarDatos();
            TiposActualizaTipo();
         }
      }
   }else{
      Utilidad.MsgInfo("TiposSbAnadirEditar->Caption debe ser Salvar o Editar.");
      sbCancelarClick(NULL);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposSbNuevoClick(TObject *Sender)
{
   TiposActualizaTipo(-2);
   TiposEditar(true);
   TiposEditandoTipoNuevo=true;
   FocusControl(TiposEdNombre);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposGridSelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
   CanSelect=true;
   TiposActualizaTipo(ARow);
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::TiposChequeaDatos(bool soloIcono){

   // Intentamos cargar el icono a la vez que se validan las 3 condiciones
   // que debe cumplir el icono:
   // Que el fichero sea BMP, que exista en la carpeta de imgenes del programa
   // y que sea de tamao 20x20:
   if(!CargaImagen(TiposIcono,TiposEdIcono->Text.Trim(),true,20))
      return false;

   if(soloIcono)
      return true;

   // El nombre del tipo debe existir y tener solo una palabra
   if(!Es1SolaPalabra_(TiposEdNombre->Text,"the type's name"))
      return false;
   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposActualizaTipo(int fil){

   if(-1 == fil)
      fil = TiposGrid->Selection.Top;

   if( fil >= 1){
      TiposEdIcono  ->Text= TiposGrid->Cells[1][fil];
      TiposEdNombre ->Text= TiposGrid->Cells[2][fil];
      TiposEdEjemplo->Text= TiposGrid->Cells[3][fil];
      TiposCbHijos->ItemIndex = TiposCbHijos->Items->IndexOf(TiposGrid->Cells[4][fil]);
      CargaImagen(TiposIcono,TiposEdIcono->Text.Trim(),false,20);
      // Al cambiar el tipo seleccionado desactivamos la edicin.
      TiposEditar(false);

   }else{
      TiposEdIcono  ->Text="";
      TiposEdNombre ->Text="";
      TiposEdEjemplo->Text="";
      TiposCbHijos->ItemIndex=0;
      // Vamos a Borrar el icono que aparece en TiposIcono:
      LimpiaImagen(TiposIcono);
   }

}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::LimpiaImagen(TImage *imagen){
   int ancho=imagen->Picture->Width;
   int alto =imagen->Picture->Height;
   imagen->Canvas->Brush->Color = clBtnFace;
   imagen->Canvas->FillRect(TRect(0,0,ancho,alto));
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposSbEliminarClick(TObject *Sender){
   if( (GT == NULL) || (TiposGrid->Selection.Top <=0) )
      return;
   TiposEditar(false);      
   Tipo *tipo = GT->DatosTipo(TiposGrid->Cells[2][TiposGrid->Selection.Top]);
   if(tipo != NULL){
      int index= GT->NumeroDeTipo(tipo->nombre);
      if(index != -1){
         GT->EliminarTipo(index);
         TiposCargarDatos();
         TiposActualizaTipo();
         TiposHanCambiado = true;
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposSbIniciarClick(TObject *Sender)
{
   if(GT == NULL)
      return;
   GT->EliminarTodos();
   TiposCargarDatos();
   TiposActualizaTipo();
   TiposHanCambiado = true;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::TiposPreguntarSalvar(){

   if(!TiposHanCambiado)
      return true;  // Devolvemos true para que continue el proceso
   else{
      TModalResult mr = frmUtilidad->Pregunta("The Type settings have been modified. Do you wish to save the changes?");
      if(mr == mrCancel)
         return false;  // No debemos continuar con el proceso.
      else if(mr == mrYes){
         SalvarGestor(0);
         TiposHanCambiado = false;
      }
      return true;
   }
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::NodosPreguntarSalvar(){

   if(!NodosHanCambiado)
      return true;  // Devolvemos true para que continue el proceso
   else{
      TModalResult mr = frmUtilidad->Pregunta("The node settings have been modified. Do you wish to save the changes?");
      if(mr == mrCancel)
         return false;  // No debemos continuar con el proceso.
      else if(mr == mrYes){
         SalvarGestor(1);
         NodosHanCambiado = false;
      }

      return true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::CarpetasChanging(TObject *Sender,
      bool &AllowChange)
{
   if(Carpetas->ActivePageIndex == 1)  // Tipos:
      AllowChange = TiposPreguntarSalvar();
   else if(Carpetas->ActivePageIndex == 2)  // Nodos:
      AllowChange = NodosPreguntarSalvar();
   else
      AllowChange = true;
   if(AllowChange)
      CargaDatosCONF();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposSbX3DClick(TObject *Sender)
{
   if( (GT == NULL) || (GT->tipoEscena == ESCENA_X3D) || !TiposPreguntarSalvar() )
      return;
   // Cargamos los datos del nuevo gestor:
   if(!CargaGestores(false,false))
      sbCancelarClick(NULL);
   TiposHanCambiado = false;
   TiposCargarDatos();
   TiposEditar(false);
   TiposActualizaTipo();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposSbH3DClick(TObject *Sender)
{
   if( (GT == NULL) || (GT->tipoEscena == ESCENA_H3D) || !TiposPreguntarSalvar() )
      return;
   // Cargamos los datos del nuevo gestor:
   if(!CargaGestores(true,false))
      sbCancelarClick(NULL);
   TiposHanCambiado = false;
   TiposCargarDatos();
   TiposEditar(false);
   TiposActualizaTipo();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposEdIconoKeyPress(TObject *Sender,
      char &Key)
{
   // Evitamos el sonido que se produce al pulsar intro.
   if(Key == VK_RETURN)
      Key = '\0';
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosCargarDatos(){
   if(GN == NULL)
      return;
   Nodo *nodo;
   // Inicialmente no estmos editando nodos ni campos:
   NodosEditar(false,false);
   NodosDatosCampoEditar(false,false);
   // Rellenamos la ComboBox con los nombres de los nodos.
   NodosCbNombre->Items->Clear();
   for(int c=0; c < GN->GetNumNodos() ; c++){
      nodo = GN->DatosNodo(c);
      if(nodo != NULL)
         NodosCbNombre->Items->Append(nodo->nombre);
   }

   if(GT != NULL){
      NodosCbTipoCampo->Clear();
      Tipo *t;
      for(int c=0; c < GT->GetNumTipos(); c++){
         t = GT->DatosTipo(c);
         if(t != NULL)
         NodosCbTipoCampo->Items->Append(t->nombre);
      }
      NodosCbTipoCampo->ItemIndex = -1;
   }

   // Cargamos el primer nodo:
   NodosIndex=0;
   NodosCargarNodo(NodosIndex);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosCargarNodo(int numNodo){

   if(GN == NULL)
      return;
   // Hay que desactivar la edicin de nodos y de campos:
   NodosEditar(false,false);
   NodosDatosCampoEditar(false,false);
   Nodo *nodo;
   NodosIndex=numNodo;

   // Rellenamos los valores de los controles:
   nodo = GN->DatosNodo(numNodo);
   if(nodo == NULL){
      NodosCbNombre->ItemIndex = 0;
      NodosEdTipo->Text        = "";
      NodosEdImagen->Text      = "";
      NodosEdIcono->Text       = "";
      NodosMmDescripcion->Text = "";
   }else{
      NodosCbNombre->ItemIndex = numNodo;
      NodosEdTipo->Text        = nodo->tipo;
      NodosEdImagen->Text      = nodo->imagen;
      NodosEdIcono->Text       = nodo->icono;
      NodosMmDescripcion->Text = nodo->descripcion;
   }
   NodosGbDatosCampo->Enabled=false;

   NodosActualizaGrid(nodo);

   AnsiString titulo = (GT->tipoEscena==ESCENA_X3D)  ? "X3D Nodes" : "H3D Nodes";
   NodosGb->Caption = titulo;

   // Tambin hay que actualizar la imagen asociada al nodo.
   if( (GN->tipoEscena == ESCENA_X3D) && (nodo != NULL) )
      // En este caso hay que utilizar la imagen general de los nodos X3D.
      Utilidad.GetImagen (NodosIcono->Picture,nodo->icono,CONF.ICONO_GENERAL_NODO_X3D);
   else if( (GN->tipoEscena == ESCENA_H3D) && (nodo != NULL) )
      Utilidad.GetImagen (NodosIcono->Picture,nodo->icono,CONF.ICONO_GENERAL_NODO_H3D);
   NodosIcono->Visible=true;      

   if(0 != GN->GetNumNodos())
      NodosLbNumNodo->Caption = "Node " + IntToStr(NodosIndex+1) + " of " + IntToStr(GN->GetNumNodos());
   else
      NodosLbNumNodo->Caption="";

   // Adems hay que actualizar el valor de los controles contenidos en: NodosGbDatosCampo
   NodosGridClick(NULL);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbSiguienteClick(TObject *Sender)
{
   if( (GN == NULL) || (NodosIndex+1 >= GN->GetNumNodos()) )
      return;
   NodosCargarNodo(++NodosIndex);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbAnteriorClick(TObject *Sender)
{
   if( (GN == NULL) || (NodosIndex == 0) )
      return;
   NodosCargarNodo(--NodosIndex);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosGridDrawCell(TObject *Sender,
      int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
   if(ARow == 0)
      return;
   Campo *c = (Campo *)NodosGrid->Objects[0][ARow];
   if(c == NULL){
      return;
   }else{
      if(ACol==0){
         TRect posicion;
         int x,y;
         posicion=NodosGrid->CellRect(0,ARow);
         // CellRect nos devuelve un rectngulo vaco si la celda no se
         // est mostrando en la pantalla.
         if(posicion.Width() || posicion.Height()){
            x=posicion.left;
            y=posicion.Top;
            switch (c->rutado){
               case FIELD        :  NodosGrid->Canvas->Draw(x,y,NodosimgField->Picture->Bitmap); break;
               case EVENTOUT     :  NodosGrid->Canvas->Draw(x,y,NodosimgRoutedTo->Picture->Bitmap); break;
               case EVENTIN      :  NodosGrid->Canvas->Draw(x,y,NodosimgRoutedFrom->Picture->Bitmap); break;
               case EXPOSEDFIELD :  NodosGrid->Canvas->Draw(x,y,NodosimgExposedField->Picture->Bitmap); break;
            }
         }
      }else if(ACol==2){
         if(c->tipo != NULL)
           NodosGrid->Canvas->Draw(Rect.left+1,Rect.top,c->tipo->icono->Bitmap);
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbX3DClick(TObject *Sender)
{
   if( (GN == NULL) || (GN->tipoEscena == ESCENA_X3D) || !NodosPreguntarSalvar() )
      return;
   AnsiString actual = NodosCbNombre->Text;
   // Cargamos los datos del nuevo gestor:
   if(!CargaGestores(false,false))
      sbCancelarClick(NULL);
   NodosHanCambiado = false;
   NodosCargarDatos();
   int numNodo = GN->NumeroDeNodo(actual);
   if( -1 != numNodo)
      NodosCargarNodo(numNodo);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbH3DClick(TObject *Sender)
{
   if( (GN == NULL) || (GN->tipoEscena == ESCENA_H3D) || !NodosPreguntarSalvar() )
      return;
   AnsiString actual = NodosCbNombre->Text;
   // Cargamos los datos del nuevo gestor:
   if(!CargaGestores(true,false))
      sbCancelarClick(NULL);
   NodosHanCambiado = false;
   NodosCargarDatos();
   int numNodo = GN->NumeroDeNodo(actual);
   if( -1 != numNodo)
      NodosCargarNodo(numNodo);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosCbNombreChange(TObject *Sender)
{
   if(GN == NULL)
      return;
   int n = GN->NumeroDeNodo(NodosCbNombre->Text);
   if(n != -1)
      NodosCargarNodo(n);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbEliminarClick(TObject *Sender)
{
   // Si estamos editando un campo no se puede eliminar un nodo.
   if(NodosSbEditar->Caption == "Save")
      return;
   GN->EliminarNodo(NodosIndex);
   if(-1 != NodosCbNombre->ItemIndex)
      NodosCbNombre->Items->Delete(NodosCbNombre->ItemIndex);
   NodosHanCambiado=true;
   if(NodosIndex < GN->GetNumNodos())
      NodosCargarNodo(NodosIndex);
   else if(GN->GetNumNodos() >= 1)
      NodosCargarNodo(--NodosIndex);
   else{
      NodosIndex=0;
      NodosCargarNodo(NodosIndex);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbIniciarClick(TObject *Sender)
{
   // Si estamos editando un campo no se pueden eliminar los nodos.
   if(NodosSbEditar->Caption == "Save")
      return;

   GN->EliminarTodos();
   NodosCbNombre->Clear();
   NodosHanCambiado=true;
   NodosIndex=0;
   NodosCargarNodo(NodosIndex);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosEditar(bool editar,bool nuevo){

   if(GN == NULL)
      return;
   if( (0 == GN->GetNumNodos()) && editar && !nuevo)
      // Si se intenta editar una ficha cuando el gestor est vaco volvemos:
      return;

   NodosSbEditar->Caption = editar ? "Save" : "Edit";
   if(editar){
      AnsiString tmp = NodosCbNombre->Text;
      NodosCbNombre->Clear();
      NodosCbNombre->Style = csDropDown;
      NodosCbNombre->Text = tmp;
   }else{
      // Volvemos a cargar los nodos que borramos al editar la escena.
      NodosCbNombre->Style = csDropDownList;
      NodosCbNombre->Clear();
      Nodo *nodo;
      for(int c=0; c < GN->GetNumNodos() ; c++){
         nodo = GN->DatosNodo(c);
         if(nodo != NULL)
            NodosCbNombre->Items->Append(nodo->nombre);
      }
   }
   NodosGbTipo->Enabled=editar;
   NodosPnlEdicionImagen->Enabled =editar;
   NodosPnlEdicionIcono->Enabled =editar;
   NodosGbDescripcion->Enabled=editar;

   if(nuevo){
      // Limpiamos todos los controles.
      NodosCbNombre->Text="";
      NodosEdTipo  ->Text="";
      NodosEdImagen->Text="";
      NodosEdIcono ->Text="";
      NodosMmDescripcion->Text="";
      NodosGrid->RowCount= 2;
      NodosGrid->Cells[0][1]= "";
      NodosGrid->Cells[1][1]= "";
      NodosGrid->Cells[2][1]= "";
      NodosGrid->Cells[3][1]= "";
      NodosGrid->Cells[4][1]= "";
      NodosGrid->Objects[0][1]= NULL;
      NodosLbNumNodo->Caption="";
      NodosLbNumCampos->Caption="";
      NodosIcono->Visible=false;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbEditarClick(TObject *Sender)
{
   // Hay que desactivar la edicin de campos:
   NodosDatosCampoEditar(false,false);

   if(NodosSbEditar->Caption == "Edit"){
      NodosEditar(true,false);
      NodosEditandoNodoNuevo=false;
      FocusControl(NodosCbNombre);
   }else if(NodosSbEditar->Caption == "Save"){
      if( (GN == NULL) || (!NodosChequeaDatos()) )
         return;

      // Hay que salvar el nodo actual -> Debemos saber si estamos editando un nodo o no.
      if(NodosEditandoNodoNuevo){

         // Vamos a crear un nodo nuevo.
         Nodo *nodo = GN->AnadirNodo();
         if(nodo == NULL)
            return;
         nodo->nombre= NodosCbNombre->Text.Trim();
         nodo->tipo  = NodosEdTipo->Text.Trim();
         nodo->icono = NodosEdIcono->Text.Trim();
         nodo->imagen= NodosEdImagen->Text.Trim();
         nodo->descripcion = NodosMmDescripcion->Text.Trim();
         // Creamos el nodo sin campos. Los campos se aadirn posteriormente.
         nodo->numCampos=0;
         nodo->campos=NULL;
         NodosHanCambiado=true;

      }else{
         if(NULL == GN->DatosNodo(NodosIndex))
            return;
         // Estamos editando un nodo:
         // Comprobamos que el nombre del nodo existe y tiene 1 sola palabra:
         if(!Es1SolaPalabra_(NodosCbNombre->Text,"The node's name"))
            return;

         Nodo *nodo = GN->DatosNodo(NodosIndex);
         nodo->nombre= NodosCbNombre->Text.Trim();
         nodo->tipo  = NodosEdTipo->Text.Trim();
         nodo->icono = NodosEdIcono->Text.Trim();
         nodo->imagen= NodosEdImagen->Text.Trim();
         nodo->descripcion = NodosMmDescripcion->Text.Trim();
         NodosHanCambiado=true;
      }
      int i = GN->NumeroDeNodo(NodosCbNombre->Text.Trim());
      if(i != -1)
         NodosCargarNodo(i);

   }else{
      Utilidad.MsgInfo("NodosSbAnadirEditar->Caption debe ser Salvar o Editar.");
      sbCancelarClick(NULL);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbNuevoClick(TObject *Sender)
{
   // Hay que desactivar la edicin de campos:
   NodosDatosCampoEditar(false,false);

   NodosEditandoNodoNuevo=true;
   NodosEditar(true,true);
   FocusControl(NodosCbNombre);
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::CargaImagen(TImage * img,AnsiString file,bool msg,int tam){

   if(img == NULL)
      return false;
   // Limpiamos la imagen por si salimos por algn error.
   LimpiaImagen(img);
   AnsiString carpeta = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_IMAGENES + "\\";
   if((file != "") && (file != "-") ){
      //  - El icono debe estar dentro de la carpeta de imgenes del programa
      AnsiString ext  = ExtractFileExt(file);
      file = ExtractFileName(file);
      file = carpeta + file;
      if(ext.UpperCase() != ".BMP"){
          if(msg)
             Utilidad.MsgInfo("You must select a BMP file.");
          return false;
      }else if(!FileExists(file)){
          if(msg)
             Utilidad.MsgInfo("You must select a image contained in the folder  " + carpeta);
          return false;
      }
      // Adems el icono debe ser de tamao tam x tam
      if(img != NULL){
         try{ img->Picture->LoadFromFile(file); }
         catch(...){return false;}
      }

      if( (tam != -1) && (img != NULL) ){
         if( (img->Picture->Width != tam) || (img->Picture->Height != tam) ){
            LimpiaImagen(img);
            if(msg)
               Utilidad.MsgInfo("The image size must be  " + IntToStr(tam) + "x" + IntToStr(tam) + ".","Advertencia");
            return false;
         }
      }
   }

   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosGridClick(TObject *Sender)
{
   // Vamos a actualizar el valor de los controles contenidos en: NodosGbDatosCampo
   Campo *campo = NULL;
   int i = NodosGrid->Selection.Top;
   if(i >= 1)
      campo = (Campo *) NodosGrid->Objects[0][i];

   if(campo != NULL){
      NodosEdNombreCampo->Text  = campo->nombre;
      if(campo->tipo != NULL)
         NodosCbTipoCampo->ItemIndex = NodosCbTipoCampo->Items->IndexOf(campo->tipo->nombre);
      else
         NodosCbTipoCampo->ItemIndex=-1;

      switch (campo->rutado){
         case FIELD       : NodosCbRutadoCampo->ItemIndex = 0;  break;
         case EVENTIN     : NodosCbRutadoCampo->ItemIndex = 1;  break;
         case EVENTOUT    : NodosCbRutadoCampo->ItemIndex = 2;  break;
         case EXPOSEDFIELD: NodosCbRutadoCampo->ItemIndex = 3;  break;
      }
      NodosEdValDefCampo->Text  = campo->valorPorDefecto;
   }else{
      NodosEdNombreCampo->Text= "";
      NodosCbTipoCampo->ItemIndex=-1;    // Para que aparezca en blanco.
      NodosCbRutadoCampo->ItemIndex=-1;  // Para que aparezca en blanco.
      NodosEdValDefCampo->Text= "";
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbExplIconoClick(TObject *Sender)
{
   AnsiString carpeta = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_IMAGENES;
   Main->dlgAbrirImg->FileName= "";
   Main->dlgAbrirImg->InitialDir= carpeta;
   bool devuelto=false;

   // Cuando se elige un fichero que no tiene la extensin adecuada se producen
   // excepciones -> Las evitamos con try:
   try{ devuelto = Main->dlgAbrirImg->Execute();  } catch (...){   }

   if(devuelto){
      AnsiString tmp = NodosEdIcono->Text;
      NodosEdIcono->Text = ExtractFileName(Main->dlgAbrirImg->FileName);
      // Vamos a chequear los datos y a cargar el icono en NodosIcono
      if(!CargaImagen(NodosIcono,NodosEdIcono->Text.Trim(),true,30))
         NodosEdIcono->Text = tmp;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbExplImagenClick(TObject *Sender)
{
   AnsiString carpeta = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_IMAGENES;
   Main->dlgAbrirImg->FileName= "";
   Main->dlgAbrirImg->InitialDir= carpeta;
   bool devuelto=false;

   // Cuando se elige un fichero que no tiene la extensin adecuada se producen
   // excepciones -> Las evitamos con try:
   try{ devuelto = Main->dlgAbrirImg->Execute();  } catch (...){   }

   if(devuelto){
      AnsiString tmp = NodosEdImagen->Text;
      AnsiString carpeta = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_IMAGENES + "\\";
      AnsiString file = ExtractFileName(Main->dlgAbrirImg->FileName).Trim();

      // La imgen debe estar dentro de la carpeta de imgenes del programa.
      AnsiString ext  = ExtractFileExt(file);
      file = ExtractFileName(file);
      if( (ext.UpperCase() != ".BMP") && (ext.UpperCase() != ".JPG") ){
         Utilidad.MsgInfo("You must select a BMP or JPG file.");
         NodosEdImagen->Text = tmp;
         return;
      }else if(!FileExists(carpeta + file)){
         Utilidad.MsgInfo("You must select a image contained in the folder  " + carpeta);
         NodosEdImagen->Text = tmp;
         return;
      }
      NodosEdImagen->Text = file;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbBorrarImagenClick(TObject *Sender)
{
   NodosEdImagen->Text="";
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbBorrarIconoClick(TObject *Sender)
{
   NodosEdIcono->Text="";
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::NodosChequeaDatos(){

   // Los controles sobre NodosEdImagen se hicieron al cargar la imgen.
   
   // Intentamos cargar el icono a la vez que se validan las 3 condiciones
   // que debe cumplir el icono:
   // Que el fichero sea BMP, que exista en la carpeta de imgenes del programa
   // y que sea de tamao 30x30:
   if(!CargaImagen(NodosIcono,NodosEdIcono->Text.Trim(),true,30))
      return false;

   // Comprobamos que el nombre del nodo existe y tiene 1 sola palabra:
   if(!Es1SolaPalabra_(NodosCbNombre->Text,"The node's name"))
      return false;
   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposSbExplorarClick(TObject *Sender)
{
   AnsiString carpeta = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_IMAGENES;
   Main->dlgAbrirImg->FileName= "";
   Main->dlgAbrirImg->InitialDir= carpeta;
   bool devuelto=false;

   // Cuando se elige un fichero que no tiene la extensin adecuada se producen
   // excepciones -> Las evitamos con try:
   try{ devuelto = Main->dlgAbrirImg->Execute();  } catch (...){   }

   if(devuelto){
      AnsiString tmp = TiposEdIcono->Text;
      TiposEdIcono->Text = ExtractFileName(Main->dlgAbrirImg->FileName);
      // Vamos a chequear los datos y a cargar el icono en TiposIcono
      if(!TiposChequeaDatos(true)){
         TiposEdIcono->Text = tmp;
         CargaImagen(TiposIcono,TiposEdIcono->Text.Trim(),false,20);
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::TiposSbBorrarIconoClick(TObject *Sender)
{
   TiposEdIcono->Text="";
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbEditarCampoClick(TObject *Sender)
{
   if(NodosSbEditar->Caption == "Save"){
      Utilidad.MsgInfo("During the node edition its fields can not be modified.");
      return;
   }
   if(NodosSbEditarCampo->Caption == "Edit"){
      NodosEditandoCampoNuevo=false;
      NodosDatosCampoEditar(true,false);
   }else if(NodosSbEditarCampo->Caption == "Save") {
      if( (GN == NULL) || (GT == NULL) || !NodosChequeaDatosCampo() )
         return;

      // Preparamos las variables para la asignacin:
      Tipo *tipo = GT->DatosTipo(NodosCbTipoCampo->Text);

      AnsiString cad = NodosCbRutadoCampo->Text.UpperCase();
      TipoRutadoCampo rutado;
      if(cad == "INITIALIZEONLY")    rutado = FIELD;
      else if(cad == "INPUTONLY")    rutado = EVENTIN;
      else if(cad == "OUTPUTONLY")   rutado = EVENTOUT;
      else/*(cad=="inputOutput")*/   rutado = EXPOSEDFIELD;
      
      // Tenemos que salvar los datos que ha introducido el usuario:
      if(NodosEditandoCampoNuevo){
         // Tenemos que crear un nuevo campo:
         GN->AnadirCampo(NodosIndex,NodosEdNombreCampo->Text,tipo,rutado,NodosEdValDefCampo->Text);

      }else{
         // Editamos los datos del campo ya existente:
         Campo *campo = NULL;
         int i = NodosGrid->Selection.Top;
         if(i >= 1)
            campo = (Campo *) NodosGrid->Objects[0][i];

         if(campo == NULL)
            return;

         campo->nombre = NodosEdNombreCampo->Text;
         campo->valorPorDefecto = NodosEdValDefCampo->Text;
         campo->tipo = tipo;
         campo->rutado = rutado;
      }
      NodosHanCambiado=true;
      // Acabamos la edicin de los campos:
      NodosDatosCampoEditar(false,false);
   }else{
      Utilidad.MsgInfo("NodosSbEditarCampo->Caption debe ser Salvar o Editar.");
      sbCancelarClick(NULL);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbNuevoCampoClick(TObject *Sender)
{
   if(NodosSbEditar->Caption == "Save"){
      Utilidad.MsgInfo("During the node edition its fields can not be modified.");
      return;
   }
   NodosEditandoCampoNuevo=true;
   NodosDatosCampoEditar(true,true);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosSbEliminarCampoClick(
      TObject *Sender)
{
   if(NodosSbEditar->Caption == "Save"){
      Utilidad.MsgInfo("During the node edition its fields can not be modified.");
      return;
   }
   // Vamos a eliminar el campo que est seleccionado actualmente:
   if(GN == NULL)
      return;
   Nodo *nodo= GN->DatosNodo(NodosIndex);
   if( (nodo == NULL) || (nodo->numCampos==0) )
      return;
   // Vamos a borrar el campo actual de la lista de campos:
   // El ndice del campo a eliminar es: NodosGrid->Selection.Top-1;
   int campo = NodosGrid->Selection.Top-1;
   if( (campo >= 0) && (campo < nodo->numCampos) ){
      GN->EliminarCampo(NodosIndex,campo);
      // Actualizamos la apariencia de NodosGrid.
      NodosCargarNodo(NodosIndex);
      NodosHanCambiado=true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosDatosCampoEditar(bool editar,bool nuevo){

   if( (GN == NULL) || (0 == GN->GetNumNodos()) )
      return;

   NodosSbEditarCampo->Caption = editar ? "Save" : "Edit";
   NodosGbDatosCampo->Enabled=editar;
   if(editar){
      if(nuevo){
         NodosEdNombreCampo->Text= "";
         NodosCbTipoCampo->ItemIndex=-1;    // Para que aparezca en blanco.
         NodosCbRutadoCampo->ItemIndex=-1;  // Para que aparezca en blanco.
         NodosEdValDefCampo->Text= "";
      }
      FocusControl(NodosEdNombreCampo);
   }else{
      // Al acabar la edicin hay que actualizar el valor de NodosGrid.
      NodosActualizaGrid(GN->DatosNodo(NodosIndex));
   }
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::NodosChequeaDatosCampo(){

   // Hay que comprobar los controles contenidos en: NodosGbDatosCampo
   // NodosEdValDefCampo puede valer cualquier cosa.
   // NodosCbRutadoCampo->Text debe existir
   // El resto de controles deben tener una sola palabra y ser != "".

   // Comprobamos que el nombre del nodo existe y tiene 1 sola palabra:
   if( (!Es1SolaPalabra_(NodosEdNombreCampo->Text,"The field's name")) ||
       (!Es1SolaPalabra_(NodosCbTipoCampo->Text  ,"The field's type")) )
       return false;

   if( NodosCbRutadoCampo->Text.Trim() == ""){
      Utilidad.MsgInfo("You must select a ROUTE type for the field.");
      return false;
   }
   return true;
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::Es1SolaPalabra_(AnsiString cad,AnsiString inicioMsg)
{
   return Es1SolaPalabra(cad,inicioMsg);
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::Es1SolaPalabra(AnsiString &cad,AnsiString inicioMsg){

   cad = cad.Trim();
   // cad debe tener solo una palabra:
   if( 1 < Utilidad.NumPalabras(cad.c_str())){
      Utilidad.MsgInfo(inicioMsg + " must have only a word.");
      return false;
   }
   //  cad debe existir:
   if(cad == ""){
      Utilidad.MsgInfo(inicioMsg + " must exist.");
      return false;
   }
   return true;
}

//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::NodosActualizaGrid(Nodo *nodo){

   // Ahora rellenamos la lista de campos:
   if( (nodo == NULL) || (nodo->numCampos == 0) ){
      NodosGrid->RowCount= 2;
      NodosGrid->Cells[0][1]= "";
      NodosGrid->Cells[1][1]= "";
      NodosGrid->Cells[2][1]= "";
      NodosGrid->Cells[3][1]= "";
      NodosGrid->Cells[4][1]= "";
      NodosGrid->Objects[0][1]= NULL;
   }else{
      NodosGrid->RowCount= nodo->numCampos+1;
      Campo *campo;
      for(int c=0; c < nodo->numCampos; c++){
         campo = nodo->campos[c];
         NodosGrid->Cells[0][c+1]= "";
         NodosGrid->Cells[2][c+1]= "";
         if(campo != NULL){
            NodosGrid->Cells[1][c+1] = campo->nombre;
            NodosGrid->Cells[4][c+1] = campo->valorPorDefecto;
            if(campo->tipo != NULL)
               NodosGrid->Cells[3][c+1] = campo->tipo->nombre;
            else
               NodosGrid->Cells[3][c+1] = campo->nombreTipoIndefinido;
         }else{
            NodosGrid->Cells[1][c+1]= "";
            NodosGrid->Cells[3][c+1]= "";
            NodosGrid->Cells[4][c+1]= "";
         }
         // Vinculamos cada fila con un campo para representar posteriormente
         // los iconos.
         NodosGrid->Objects[0][c+1]= (TObject *)campo;
      }
   }
   if(nodo != NULL)
      NodosLbNumCampos->Caption = IntToStr(nodo->numCampos) + " Field" + ((nodo->numCampos == 1) ? "" : "s");
   else
      NodosLbNumCampos->Caption = "";
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::btnOtrosClick(TObject *Sender)
{
   Main->dlgColor->Color = FntPnlOtro->Color;
   if( Main->dlgColor->Execute() ){
      FntPnlOtro->Color = Main->dlgColor->Color;
      FntPnlSeleccionado->Color = Main->dlgColor->Color;
   }
}
//---------------------------------------------------------------------------
bool __fastcall TfrmConfiguracion::CargarDatosAT(AnsiString file){

   // Iniciamos todos los controles:
   lbElementosAT->Clear();
   lbExtensionesAT->Clear();
   edExtensionAT->Text = "";
   edElementoAT->Text = "";
   mmAT->Clear();
   gbSeleccionadoAT->Enabled = false;
   sbEditarElementoAT->Caption = "Edit Element";

   // Ahora intentamos cargar los datos del fichero:
   if(!Utilidad.LoadFromFile(LineasAux,file,true))
      return false;

   LiberaMemoriaAT();
   TamElementosAT = 0;

   TStringList *lista = LineasAux;
   // Tenemos el fichero AT, ahora hay que crear en memoria la estructura de datos:
   // Necesitamos saber cual es el nmero de elementos que hay en el fichero, as
   // que hacemos un primer barrido para determinar el nmero de elementos y luego
   // crear el array:
   for(int c=0; c < lista->Count ; c++){
      if(1 == lista->Strings[c].Pos("-> ELEMENTO: <") )
         TamElementosAT++;
   }

   // Ya sabemos que tamao debe tener el array -> Lo creamos:
   try{ ElementosAT =   new (DatosAT *[TamElementosAT]); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria();}

   // Es recomendable siempre inicializar todos los elementos del array:
   for(int c=0; c < TamElementosAT; c++)
      ElementosAT[c] = NULL;

   // Ahora recorremos todos sus elementos asignandoles un valor:
   NumElementosAT=0;
   int c=0;
   while(c < lista->Count){
      if(1 == lista->Strings[c].Pos("-> ELEMENTO: <") ){
         try{ ElementosAT[NumElementosAT] = new DatosAT(); }
         catch(...){ Utilidad.FatalErrorFaltaMemoria();}

         ElementosAT[NumElementosAT]->titulo    = Utilidad.GetCadenaEntreMarcas(lista->Strings[c],0);
         ElementosAT[NumElementosAT]->extension = Utilidad.GetCadenaEntreMarcas(lista->Strings[c],1);

         c++; // Para pasar a la siguiente lnea:

         while( (c < lista->Count) && (1 != lista->Strings[c].Pos("-> ELEMENTO: <")) ){
            if(ElementosAT[NumElementosAT]->at == "")
               ElementosAT[NumElementosAT]->at = lista->Strings[c];
            else
               ElementosAT[NumElementosAT]->at = ElementosAT[NumElementosAT]->at + "\r\n" + lista->Strings[c];
            c++;
         }
         NumElementosAT++;
      }else
         c++;
   }

   // El siguiente paso es cargar la informacin en los controles, usamos:
   ActualizaAT();

   return true;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::SalvarAT(){

   AnsiString datos;
   for(int c=0; c < TamElementosAT; c++){
      if(ElementosAT[c] != NULL){
         datos += (AnsiString)"-> ELEMENTO: <" + ElementosAT[c]->titulo + "> <" + ElementosAT[c]->extension + ">\r\n";
         datos += ElementosAT[c]->at+ "\r\n";
      }
   }
   
   // Usamos LineasAux:
   LineasAux->Text = datos;

   // Ahora intentamos salvar los datos a disco:
   AnsiString file = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION +
                                              "\\" + FICH_CONF_AT;

   // Finalmente salvamos el fichero (si se produce algn error se avisar al usuario):
   Utilidad.SaveToFile(LineasAux,file,true);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::LiberaMemoriaAT(){

   if(ElementosAT == NULL)
      return;

   gbSeleccionadoAT->Enabled = false;
   sbEditarElementoAT->Caption = "Edit Element";

   for(int c=0; c < NumElementosAT; c++){
      if(ElementosAT[c] != NULL){
         delete ElementosAT[c];
         ElementosAT[c] = NULL;
      }
   }

   delete ElementosAT;
   ElementosAT=NULL;
   NumElementosAT=0;
   TamElementosAT=0;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::lbExtensionesATClick(TObject *Sender)
{
   if(lbExtensionesAT->ItemIndex == -1)
     return;

   gbSeleccionadoAT->Enabled = false;
   sbEditarElementoAT->Caption = "Edit Element";

   AnsiString ext = lbExtensionesAT->Items->Strings[lbExtensionesAT->ItemIndex].UpperCase();

   // Hay que cargar la lista de elementos que tengan la extensin seleccionada:
   lbElementosAT->Clear();

   for(int c=0; c < TamElementosAT; c++){
      if( (ElementosAT[c] != NULL) && (ElementosAT[c]->extension.UpperCase() == ext) ){
         // Aadimos este elemento a la lista:
         lbElementosAT->Items->Append(ElementosAT[c]->titulo);
         lbElementosAT->Items->Objects[lbElementosAT->Items->Count-1] = (TObject *) ElementosAT[c];
      }
   }

   // Ahora intentamos cargar el primer elemento de la lista y despues llamamos
   // a la funcin que cargar los datos del elemento seleccionado:
   if(lbElementosAT->Items->Count > 0){
      lbElementosAT->ItemIndex = 0;
      lbElementosATClick(NULL);
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::lbElementosATClick(TObject *Sender)
{
   // Intentamos cargar los datos del elemento actual:
   if(  (lbElementosAT->ItemIndex == -1) ||
        (lbElementosAT->Items->Objects[lbElementosAT->ItemIndex]== NULL) )
      return;

   gbSeleccionadoAT->Enabled = false;
   sbEditarElementoAT->Caption = "Edit Element";

   DatosAT *p = (DatosAT *) lbElementosAT->Items->Objects[lbElementosAT->ItemIndex];

   edElementoAT->Text = p->titulo;
   edExtensionAT->Text = p->extension.UpperCase();
   mmAT->Text = p->at;
   ElementoSeleccionadoAT = p;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::sbNuevoElementoATClick(TObject *Sender)
{
   gbSeleccionadoAT->Enabled = true;

   edElementoAT->Text = "";
   mmAT->Text = "";
   if(lbExtensionesAT->ItemIndex != -1)
      edExtensionAT->Text = lbExtensionesAT->Items->Strings[lbExtensionesAT->ItemIndex];
   else
      edExtensionAT->Text = "";
   sbEditarElementoAT->Caption = "Save Element";
   ElementoSeleccionadoAT=NULL;

   this->FocusControl(edElementoAT);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::sbEliminarElementoATClick(
      TObject *Sender)
{
   if(lbElementosAT->ItemIndex == -1)
      return;

   gbSeleccionadoAT->Enabled = false;
   sbEditarElementoAT->Caption = "Edit Element";

   // Vamos a recorrer ElementosAT hasta encontrar el puntero sel, y lo borramos:
   DatosAT *sel = (DatosAT *) lbElementosAT->Items->Objects[lbElementosAT->ItemIndex];

   if(sel == NULL)
      return;

   for(int c=0; c < TamElementosAT; c++){
      if(ElementosAT[c] == sel){
         delete ElementosAT[c];
         ElementosAT[c] = NULL;
         NumElementosAT--;
         ElementoSeleccionadoAT=NULL;
         ActualizaAT();
         HaCambiadoAT = true;
         return;
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::sbEditarElementoATClick(TObject *Sender)
{
   if(gbSeleccionadoAT->Enabled){
      // En este caso se est editando algn dato -> Hay que salvarlo.
      // Lo primero es comprobar que los datos introducidos existen:
      if(edExtensionAT->Text.Trim() == ""){
         Utilidad.MsgInfo("It is necessary to specify an extension.");
         return;
      }
      if(edElementoAT->Text.Trim() == ""){
         Utilidad.MsgInfo("It is necessary to specify the element's identifier.");
         return;
      }
      if(mmAT->Text.Trim() == ""){
         Utilidad.MsgInfo("It is necessary to specify the autotext.");
         return;
      }

      // Ya sabemos que los datos son vlidos, ahora tenemos que distinguir
      // estos dos casos:
      if(NULL == ElementoSeleccionadoAT){
         // El elemento seleccionado es nuevo. Tenemos que reservar memoria
         // para el y despus amplicar el array ElementosAT:
         try{ ElementoSeleccionadoAT = new DatosAT(); }
         catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

         ElementoSeleccionadoAT->extension = edExtensionAT->Text.Trim().UpperCase();
         ElementoSeleccionadoAT->titulo    = edElementoAT ->Text.Trim();
         ElementoSeleccionadoAT->at        = mmAT         ->Text;

         // Vamos a ampliar el array. Adems lo compactaremos, es decir si tiene
         // elementos a NULL los quitaremos y aadiremos al final el nuevo puntero.
         DatosAT **tmp = ElementosAT;
         try{ ElementosAT =   new (DatosAT *[NumElementosAT+1]); }
         catch(...){ Utilidad.FatalErrorFaltaMemoria();}

         int index=0;
         for(int c=0; c < TamElementosAT; c++){
            if(tmp[c] != NULL)
               ElementosAT[index++] = tmp[c];
         }

         // An falta aadir el nuevo puntero:
         if(index == NumElementosAT){
            ElementosAT[index] = ElementoSeleccionadoAT;
            NumElementosAT++;
            TamElementosAT = NumElementosAT;
            delete tmp;
         }else{
            // En este caso hay un problema de inconsistencia de datos porque
            // index contiene el nmero de elementos que tiene tmp y debera
            // coincidir con NumElementos -> Avisamos con un Beep() y dejamos
            // todo como antes:
            Beep();
            delete ElementoSeleccionadoAT;
            delete ElementosAT;
            ElementosAT = tmp;
            tmp = NULL;
            ElementoSeleccionadoAT=NULL;
         }
      }else{
         // El elemento seleccionado se est editando:
         ElementoSeleccionadoAT->extension = edExtensionAT->Text.Trim().UpperCase();
         ElementoSeleccionadoAT->titulo    = edElementoAT ->Text.Trim();
         ElementoSeleccionadoAT->at        = mmAT         ->Text;

      }
      HaCambiadoAT=true;
      gbSeleccionadoAT->Enabled = false;
      sbEditarElementoAT->Caption = "Edit Element";
      // Ahora hay que actualizar las listas y seleccionar el elemento que
      // acabamos de crear o editar:
      ActualizaAT();

   }else{
      // En este caso tenemos que editar los datos del elemento seleccionado
      // actualmente:
      if(ElementoSeleccionadoAT == NULL)
         return;
      gbSeleccionadoAT->Enabled = true;
      sbEditarElementoAT->Caption = "Save Element";
      this->FocusControl(edElementoAT);
      // ElementoSeleccionadoAT -> No es necesario asignar lo al elemento actual.
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::ActualizaAT(){

   // Intentaremos mantener la seleccin anterior -> Por eso cargamos guardamos
   // los indices que identifican al elemento seleccionado:
   int indexExt  = (lbExtensionesAT->ItemIndex != -1) ? lbExtensionesAT->ItemIndex : 0;
   int indexElem = (lbElementosAT  ->ItemIndex != -1) ? lbElementosAT  ->ItemIndex : 0;

   lbExtensionesAT->Clear();
   lbElementosAT->Clear();
   mmAT->Text = "";
   edElementoAT->Text = "";
   edExtensionAT->Text = "";

   // Primero cargamos la informacin en lbExtensiones:
   for(int c=0; c<TamElementosAT;c ++){
      if(ElementosAT[c] != NULL){
         if(-1 == lbExtensionesAT->Items->IndexOf(ElementosAT[c]->extension.UpperCase()) )
            lbExtensionesAT->Items->Append(ElementosAT[c]->extension.UpperCase());
      }
   }

   // Ahora intentamos seleccionar indexExt:
   if(lbExtensionesAT->Items->Count > 0){
      while(lbExtensionesAT->Items->Count <= indexExt)
         indexExt--;
      lbExtensionesAT->ItemIndex = indexExt;

      // Hay que cargar la lista de elementos que tengan la extensin seleccionada:

      AnsiString ext = lbExtensionesAT->Items->Strings[lbExtensionesAT->ItemIndex].UpperCase();

      for(int c=0; c < TamElementosAT; c++){
         if( (ElementosAT[c] != NULL) && (ElementosAT[c]->extension.UpperCase() == ext) ){
            // Aadimos este elemento a la lista:
            lbElementosAT->Items->Append(ElementosAT[c]->titulo);
            lbElementosAT->Items->Objects[lbElementosAT->Items->Count-1] = (TObject *) ElementosAT[c];
         }
      }

      if(lbElementosAT->Items->Count > 0){
         // Ahora intentamos seleccionar indexElem
         while(lbElementosAT->Items->Count <= indexElem)
            indexElem--;
         lbElementosAT->ItemIndex = indexElem;

         DatosAT *p = (DatosAT *) lbElementosAT->Items->Objects[lbElementosAT->ItemIndex];

         edElementoAT->Text  = p->titulo;
         edExtensionAT->Text = p->extension.UpperCase();
         mmAT->Text = p->at;
      }
   }

   // Finalmente Actualizamos ElementoSeleccionado:
   if(lbElementosAT->ItemIndex != -1)
      ElementoSeleccionadoAT = (DatosAT *) lbElementosAT->Items->Objects[lbElementosAT->ItemIndex];
   else
      ElementoSeleccionadoAT = NULL;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::edElementoATKeyPress(TObject *Sender,
      char &Key)
{
   if(Key == VK_RETURN){
      Key ='\0';  // Evitamos el sonido.
      sbEditarElementoATClick(NULL);  // Salvamos los cambios
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::DescargaAT(TListBox *lb){
   if(lb == NULL)
      return;

   for(int c=0; c < lb->Items->Count ; c++){
      if(lb->Items->Objects[c] != NULL){
         AnsiString *s = (AnsiString *) lb->Items->Objects[c];
         delete s;
         lb->Items->Objects[c]=NULL;
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::CargaAT(TListBox *lb,AnsiString extension){

   if( (lb == NULL) || (extension == "") )
      return;

   // Lo primero es liberar la memoria reservada anterior mente.
   DescargaAT(lb);
   lb->Clear();

   // Lo ms cmodo es reutilizar las funciones de la clase, as que cargamos
   // los datos en ElementosAT y luego hacemos la asignacin:
   AnsiString file = Main->CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION +
                                             "\\" + FICH_CONF_AT;

   if(!CargarDatosAT(file))
      return;

   extension = extension.UpperCase();

   lb->Sorted = false;

   // Tenemos los datos en ElementosAT:
   for(int c=0; c < TamElementosAT; c++){
      if( (ElementosAT[c] != NULL) && (extension == ElementosAT[c]->extension) ){

         // Aadimos una nueva lnea:
         lb->Items->Append(ElementosAT[c]->titulo);

         // Tenemos que reservar memoria para el at:
         AnsiString *s;
         try{ s = new AnsiString; }
         catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

         (*s) = ElementosAT[c]->at;

         if( lb->Items->Objects[lb->Items->Count-1] == NULL )
            lb->Items->Objects[lb->Items->Count-1] = (TObject *)s;
         else
            delete s;
      }
   }

   LiberaMemoriaAT();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::sbGenVisorX3DClick(TObject *Sender)
{
   Main->dlgAbrir->FileName= "*.exe";
   Main->dlgAbrir->FilterIndex = 2;
   Main->dlgAbrir->InitialDir=CONF.LAST_CARPETA_USADA;
   if(!Main->dlgAbrir->Execute())
      return;

   edGenVisorX3D->Text=Main->dlgAbrir->FileName;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::sbGenVisorH3DClick(TObject *Sender)
{
   Main->dlgAbrir->FileName= "*.exe";
   Main->dlgAbrir->FilterIndex = 2;
   Main->dlgAbrir->InitialDir=CONF.LAST_CARPETA_USADA;
   if(!Main->dlgAbrir->Execute())
      return;

   edGenVisorH3D->Text=Main->dlgAbrir->FileName;
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Main->Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::sbAyudaClick(TObject *Sender)
{
   Main->Ayuda();
}
//---------------------------------------------------------------------------
AnsiString __fastcall TfrmConfiguracion::GetTabActual(){

   if(Carpetas->ActivePageIndex == 0)
      return "Fuente";
   else if(Carpetas->ActivePageIndex == 1)
      return "Tipos";
   else if(Carpetas->ActivePageIndex == 2)
      return "Nodos";
   else if(Carpetas->ActivePageIndex == 3)
      return "AutoTexto";
   else if(Carpetas->ActivePageIndex == 4)
      return "General";
   else
      return "";
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfiguracion::FntLbElementosClick(TObject *Sender)
{
   FntAsignaPropActual();
}
//---------------------------------------------------------------------------





