//
//     UTILIDAD            
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Este espacio de nombres agrupa varias funciones de propsito
                general para ser usadas desde otras clases. Las funciones son
                independientes entre s.
*/
//---------------------------------------------------------------------------
#ifndef Utilidad_H
#define Utilidad_H
//---------------------------------------------------------------------------

#include "Ficheros.h"
#include "Main_.h"

class TUtilidad{
public:

     // Devuelven el nmero de palabras que hay en la cadena que recibe (se
     // considera una palabra el texto separado por uno o ms espacios ' ').
     int NumPalabras(char* cad);

     // Devuelve en palabra la palabra nmero palabraN que contiene cad.
     // Se considera una palabra el texto separado por ' '. Devuelve falso
     // si se produce algn error.
     // Si el nmero de la palabra pedida es mayor que el numero de palabras
     // que hay en la cadena, se devuelve una cadena vaca.
     // (La primera palabra corresponde a palabraN=1)
     bool GetPalabra(char *cad,char *palabra,int palabraN);
     // La funcin est sobrecargada para trabajar con AnsiString.
     AnsiString GetPalabra(AnsiString cad,int palabraN);

     // Esta funcin:
     //  1) Absorve los espacios del principio de cad
     //  2) Lee la primera palabra que aparece en cad
     //  3) Asigna cad al resto de la cadena
     //  4) devuelve la primera palabra obtenida en el paso 2  
     AnsiString CortaPrimeraPalabra(AnsiString &cad);

     // Devuelve el nmero mximo de caracteres que hay en una lnea de un
     // fichero. No se contabilizan los caracteres 10 y 13.
     long int MaxLongLinea(Fichero &f);

     // Esta funcin carga en imagen el fichero (<imagen>) siguiendo los siguientes
     // pasos:
     // Busca el fichero <fich> en la carpeta de imgenes y si existe la carga.
     // Si no existe busca la imagen general (<nombrePorDefecto>) y si sta existe
     // la carga. Si no existe ninguna de las dos imgenes no hace nada.
     // Devuelven falso si no se ha encontrado ningn fichero.
     bool __fastcall  GetImagen (TPicture          *imagen, AnsiString fich, AnsiString nombrePorDefecto);
     bool __fastcall  GetImagen (Graphics::TBitmap *imagen, AnsiString fich, AnsiString nombrePorDefecto);

     // Esta funcin muestra un mensaje de error y a continuacin sale del programa.
     void __fastcall FatalError(AnsiString msg);

     // Esta funcin muestra un mensaje de error indicando que no ha sido posible
     // reservar memoria y sale del programa.
     void __fastcall FatalErrorFaltaMemoria();

     // Es una funcin que devuelve la letra mayscula de la que recibe.
     // no tiene en cuenta la letra .
     char __fastcall CAP(char x);

     // Esta funcin muestra un mensaje con informacin y un botn OK.
     // Por defecto aparece el icono de informacin.
     // Posibles valores de icono: "Informacion", "Advertencia", "Error", "Confirmacion".
     // NOTA: La comparacin de icono se hace pasando a mausculas as que
     //       sern equivalestes: "Error", "error" y "ERROR"
     void __fastcall MsgInfo(AnsiString msg,AnsiString icono="Informacion");

     // Devuelve true si el fichero existe. Si msg es true se muestra un mensaje
     // cuando no existe el fichero.
     bool __fastcall Existe(AnsiString fichero,bool msg=true);

     // Recibe el nombre de un fichero. Corta la extensin y aade
     // SUFIJO_CONF_VAL_DEFECTO y a continuacin pega la extensin.
     void __fastcall UsarValorPorDefecto(AnsiString &file);

     // Cargar y salvar ficheros son operaciones frecuentes que pueden hacer que
     // salten excepciones. Adems, estas acciones pueden tardar cierto tiempo.
     // Las siguientes funciones capturan las posibles excepciones que surjan y
     // adems cambian el puntero del ratn a un reloj de arena:
     // devuelven false si se ha producido alguna excepcin.
     // LoadFromFile comprueba si el fichero existe, si no existe da un mensaje
     // de error y devulve false.
     // Tanto SaveToFile como LoadFromFile dan mensajes de error cuando se
     // producen excepciones.
     // Si usarRelojArena es verdadero, antes de cargar el fichero se usar como
     // puntero del ratn un reloj de arena.
     bool __fastcall LoadFromFile(TStrings *lineas,AnsiString ruta,bool usarRelojArena=true);
     bool __fastcall SaveToFile  (TStrings *lineas,AnsiString ruta,bool usarRelojArena=true);

     // Devuelve la cadena que aparece entre <> dentro de cad en la posicin numCad.
     // numCad empieza en 0.
     // Ejemplo: Si cad es " cadena <de> prueba < para el ejemplo > "
     // GetCadenaEntreMarcas(0) devolver "de"
     // GetCadenaEntreMarcas(1) devolver " para el ejemplo "
     // Si no se encuentra la cadena buscada se devuelve "":
     AnsiString __fastcall GetCadenaEntreMarcas(AnsiString cad,int numCad);

     // Sustituye todas las cadenas cad1 por cad2 que haya en lineas.
     void __fastcall Sustituir(TStrings *lineas,AnsiString cad1,AnsiString cad2);

     // Cambia todas las apariciones de \ por \\.
     void __fastcall DuplicaBarras(AnsiString &cad);

     // Recibe una cadena, cad, que contiene varias lneas separadas por
     // '\n' y/o '\r' y devuelve la lnea numero linea (comienza en 0).
     AnsiString __fastcall GetLinea(AnsiString &cad,int linea);

     // Devuelve el nmero de lneas que hay en cad considerando que cada lnea
     // acaba en "\r\n". As pe.GetNumCadenas("\r\n\r\n") devolver 2.
     // La ltima cadena no tiene porqu acabar con\r\n as:
     // pe.GetNumCadenas("\r\n\r\nXX") devolver 3.
     int __fastcall GetNumCadenas(AnsiString cad);

     // Pasa cad a f el formato que debe tener cad se explica en la ayuda de la
     // funcin StrToFloat. Esta funcin captura las posibles excepciones y
     // avisa con un mensaje de error si avisar es true.
     // Si salta alguna excepcin se devuelve false y f se asigna a 0.
     bool __fastcall PasaStrAFloat(AnsiString cad,float &f,bool avisar=true);
     // Versin sobrecargada que devuelve f:
     float __fastcall PasaStrAFloat(AnsiString cad,bool avisar=true);

     // Devolver true si el cdigo X3D contenido en lines es binario.
     bool __fastcall EsFicheroBinario(TStringList *lines);

     // Devuelve true si el caracter pasado es un separador.
     bool __fastcall Separador(const char c);

     // Devuelve el n de caracteres que tienen en comn las dos cadenas (nmero
     // de caracteres iguales comenzando desde el inicio de la cadena.
     int __fastcall GetNumCaracteresComunes(AnsiString cad1,AnsiString cad2);

     // Obtiene el ltimo mensaje de error de la API de Windows y lo muestra en
     // la pantalla si showMessage es true. En cualquier caso devolver el msenaje.
     AnsiString __fastcall GetWindowLastError(bool showMessage=true);

     TUtilidad(){}
};
#endif


extern TUtilidad Utilidad;
