//
//     UTILIDAD            
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Este espacio de nombres agrupa varias funciones de propsito
                general para ser usadas desde otras clases. Las funciones son
                independientes entre s.
*/

#include <vcl.h>
#pragma hdrstop

#include "Utilidad_.h"
#include "Main_.h"
#include "Ficheros.h"
#include "Configuracion_.h"
#include "GestorVRML_.h"
//---------------------------------------------------------------------------

#pragma package(smart_init)

TUtilidad Utilidad;
//------------------------------------------------------------------------------
int TUtilidad::NumPalabras(char* cad){

     int index=0,numpalabras=0;

     // Absorvemos los espacios.
     while((cad[index]!='\0') && (cad[index]==' ')) index++;

     while(cad[index]!='\0'){
          if(cad[index]!=' '){
               numpalabras++;
               // Seguimos hasta el final de la palabra.
               while((cad[index]!='\0') && (cad[index]!=' ')) index++;
          }
          // Absorvemos los espacios.
          while((cad[index]!='\0') && (cad[index]==' ')) index++;
     }
     return numpalabras;
}
//------------------------------------------------------------------------------
bool TUtilidad::GetPalabra(char *cad,char *palabra,int palabraN){

     int index2=0,index=0,numpalabras=0;

     // Absorvemos los espacios.
     while((cad[index]!='\0') && (cad[index]==' ')) index++;

     while(cad[index]!='\0'){
          if(cad[index]!=' '){
               numpalabras++;
               if(numpalabras==palabraN){
                    // Hemos encontrado la palabra que buscbamos.
                   // Solo falta copiar la cadena.
                   while((cad[index]!='\0') && (cad[index]!=' ')){
                         palabra[index2++]=cad[index++];
                   }
                   // Colocamos el '\0' y salimos.
                   palabra[index2]='\0';
                   return true;
               }
               // Seguimos hasta el final de la palabra.
               while((cad[index]!='\0') && (cad[index]!=' ')) index++;
          }
          // Absorvemos los espacios.
          while((cad[index]!='\0') && (cad[index]==' ')) index++;
     }
     // Si el nmero de la palabra pedida es mayor que el numero de palabras
     // que hay en la cadena, se devuelve una cadena vaca.
     palabra[0]='\0';
     return false;
}
//------------------------------------------------------------------------------
AnsiString TUtilidad::GetPalabra(AnsiString cad,int palabraN){

     int index=1,numpalabras=0;
     int fin=cad.Length();

     // Absorvemos los espacios.
     while((index <= fin) && (cad[index]==' ')) index++;

     while(index <= fin){
          if(cad[index]!=' '){
               numpalabras++;
               if(numpalabras==palabraN){
                   // Hemos encontrado la palabra que buscbamos.
                   // Solo falta copiar la cadena.
                   int ini=index;
                   while((index <= fin) && (cad[index]!=' '))
                       index++;
                   return cad.SubString(ini,index-ini);
               }
               // Seguimos hasta el final de la palabra.
               while((index <= fin) && (cad[index]!=' ')) index++;
          }
          // Absorvemos los espacios.
          while((index <= fin) && (cad[index]==' ')) index++;
     }
     // Si el nmero de la palabra pedida es mayor que el numero de palabras
     // que hay en la cadena, se devuelve una cadena vaca.
     return "";
}
//------------------------------------------------------------------------------
AnsiString TUtilidad::CortaPrimeraPalabra(AnsiString &cad){

     int index=1;
     int fin=cad.Length();

     // 1) Absorvemos los espacios.
     while((index <= fin) && (cad[index]==' ')) index++;
     // 2) Leemos la primera palabra.
     int ini=index;
     while( (index <= fin) && (cad[index]!=' ') )
         index++;
     AnsiString palabra=cad.SubString(ini,index-ini);
     // 3) Asignamos cad al resto de la cadena:
     cad = cad.SubString(index,fin-index+1);
     return palabra;
}
//------------------------------------------------------------------------------
bool __fastcall TUtilidad::GetImagen(Graphics::TBitmap *imagen,AnsiString fich,AnsiString nombrePorDefecto){
     if(imagen == NULL)
        return false;

     AnsiString imagenfich;
     imagenfich= (AnsiString) Main->CARPETA_PROGRAMA + "\\" +
                 (AnsiString) CONF.CARPETA_IMAGENES +
                 (AnsiString) "\\";

     if(FileExists(imagenfich + fich)){
          try{ imagen->LoadFromFile(imagenfich + fich);   }
          catch (...){  }
          return true;
     }else if(FileExists(imagenfich + nombrePorDefecto)){
          try{ imagen->LoadFromFile(imagenfich + nombrePorDefecto);   }
          catch (...){  }
          return true;
     }
     FatalError("The following file doesn't exist: " + imagenfich + nombrePorDefecto );
     return false;
}
//------------------------------------------------------------------------------
bool __fastcall TUtilidad::GetImagen(TPicture *imagen,AnsiString fich,AnsiString nombrePorDefecto){
     if(imagen == NULL)
        return false;

     AnsiString imagenfich;
     imagenfich= (AnsiString) Main->CARPETA_PROGRAMA + "\\" +
                 (AnsiString) CONF.CARPETA_IMAGENES +
                 (AnsiString) "\\";

     if(FileExists(imagenfich + fich)){
          try{ imagen->LoadFromFile(imagenfich + fich);   }
          catch (...){  }
          return true;
     }else if(FileExists(imagenfich + nombrePorDefecto)){
          try{ imagen->LoadFromFile(imagenfich + nombrePorDefecto);   }
          catch (...){  }
          return true;
     }
     if(fich.Trim() != "")
        FatalError("The following file doesn't exist: " + imagenfich + fich );
     else
        FatalError("The following file doesn't exist: " + imagenfich + nombrePorDefecto );

     return false;
}

//------------------------------------------------------------------------------
void __fastcall TUtilidad::FatalError(AnsiString msg){
   MessageDlg(msg, mtError,TMsgDlgButtons() << mbOK,0);
   exit(EXIT_FAILURE);
}

//------------------------------------------------------------------------------
void __fastcall TUtilidad::FatalErrorFaltaMemoria(){
   MessageDlg("It is not possible to allocate memory.", mtError,TMsgDlgButtons() << mbOK,0);
   exit(EXIT_FAILURE);
}
//---------------------------------------------------------------------------
char __fastcall TUtilidad::CAP(char x){
   if ( (x>=97) && (x<=122) )
       return (char) (((int)x)-32);
   return x;
}
//------------------------------------------------------------------------------
void __fastcall TUtilidad::MsgInfo(AnsiString msg,AnsiString icono)
{
   try
   {
      TMsgDlgType MsgDlgType;
      icono = icono.UpperCase();
      if( icono == "ERROR" )
         MsgDlgType = mtError;
      else if( icono == "ADVERTENCIA" )
         MsgDlgType = mtWarning;
      else if( icono == "CONFIRMACION" )
         MsgDlgType = mtConfirmation;
      else
         MsgDlgType = mtInformation;

     MessageDlg(msg, MsgDlgType,TMsgDlgButtons() << mbOK,0);
   }
   catch(...){}
}
//------------------------------------------------------------------------------
bool __fastcall TUtilidad::Existe(AnsiString fichero,bool msg){

   if(FileExists(fichero))
      return true;
   else{
      if(msg)
         MsgInfo("The following file doesn't exist: " + fichero,"Advertencia");
      return false;
   }
}
//------------------------------------------------------------------------------
void __fastcall TUtilidad::UsarValorPorDefecto(AnsiString &file){

  AnsiString ext = ExtractFileExt(file);
  if(ext == "")
     return;
  int pos = file.Pos(ext);
  if(pos != 0){
     file = file.Insert(SUFIJO_CONF_VAL_DEFECTO,pos);
  }
}
//------------------------------------------------------------------------------
long int TUtilidad::MaxLongLinea(Fichero &f){
   f.Seek(0);
   long int tmp,max;
   char anter,letra;
   max=0;
   while (!f.Final()){
      tmp=0;
      letra='.';  // Asignado a cualquier valor distinto de (char)13
      // Comenzamos a leer la nueva lnea.
      do{
         anter=letra;
         letra=f.LeeCaracter();
         tmp++;

      }while( (!f.Final()) && !(  (anter == (char)13) && (letra == (char)10)  )   );
      if(  (anter == (char)13) && (letra == (char)10)  ){
          tmp=tmp-2;
          max= (max<tmp)? tmp : max;
      }
   }
   return max;
}
//------------------------------------------------------------------------------
bool __fastcall TUtilidad::LoadFromFile(TStrings *lineas,AnsiString ruta,bool usarRelojArena){
   if(!Existe(ruta))
      return false;

   TCursor tmp;
   if(usarRelojArena){
      tmp=Screen->Cursor;       // Salvamos el puntero actual del ratn.
      Screen->Cursor=PUNT_RATON_ESPERA; // Puntero del ratn -> Reloj de arena.
   }

   bool error = false;
   try{
      lineas->LoadFromFile(ruta);
   }catch (...){
       MsgInfo("An error occurred while loading the file:" + ruta,"Error");
       error = true;
   }

   if(usarRelojArena)
      Screen->Cursor=tmp;  // Reponemos el puntero original del ratn.

   return !error;
}
//------------------------------------------------------------------------------
bool __fastcall TUtilidad::SaveToFile(TStrings *lineas,AnsiString ruta,bool usarRelojArena){

   TCursor tmp;
   if(usarRelojArena){
      tmp=Screen->Cursor;       // Salvamos el puntero actual del ratn.
      Screen->Cursor=PUNT_RATON_ESPERA; // Puntero del ratn -> Reloj de arena.
   }

   bool error = false;
   try{
       lineas->SaveToFile(ruta);
   }catch (...){
       MsgInfo("An error occurred while saving the file:" + ruta,"Error");
       error = true;
   }

   if(usarRelojArena)
      Screen->Cursor=tmp;  // Reponemos el puntero original del ratn.

   return !error;
}
//------------------------------------------------------------------------------
void __fastcall TUtilidad::Sustituir(TStrings *lineas,AnsiString cad1,AnsiString cad2){

   if(lineas == NULL)
      return;

   // Vamos a asumir que solo habr, a lo sumo, 1 ocurrencia de cad1 por lnea.
   int pos,longit = cad1.Length();
   for(int c=0; c < lineas->Count; c++){
      pos = lineas->Strings[c].Pos(cad1);
      if( 0 != pos ){
         lineas->Strings[c] = lineas->Strings[c].Delete(pos,longit);
         lineas->Strings[c] = lineas->Strings[c].Insert(cad2,pos);
      }
   }
}

//------------------------------------------------------------------------------
void __fastcall TUtilidad::DuplicaBarras(AnsiString &cad){

   int fin = cad.Length();
   int index = 1;
   for(int c=0;c < fin;c++){
      if(cad[index] == '\\'){
         cad = cad.Insert("\\",index);
         // Nos saltamos la barra que hemos aadido.
         index++;
      }
      index++;
   }
}
//------------------------------------------------------------------------------
AnsiString __fastcall TUtilidad::GetLinea(AnsiString &cad,int linea){

  int posIni = 1;
  int index = 1;
  int indexLinea = 0;
  int fin = cad.Length();
  while(index <= fin){
     if( (cad[index] == '\n') || (cad[index] == '\r') ){
        // Hemos llegado al final de una lnea -> Pasamos a la lnea siguiente.
        if(linea == indexLinea){
           // En este caso ya tenemos la lnea que hay que devolver:
           return cad.SubString(posIni,index-posIni);
        }else{
           indexLinea++;
           if( ((index+1) <= fin) && ( (cad[index+1] == '\r') || (cad[index+1] == '\n') ) )
              index++;
           // Aplicamos el +1 aunque hayamos llegado al final porque as luego
           // devolveremos "" en lugar de "\n" o "\r".
           posIni=index+1;
        }
     }
     index++;
  }
  // El final de la cadena no tiene porqu estr acabado con un RC, as que
  // devolvemos el ltimo tramo de la cadena si es que indexLinea+1 == linea
  if(indexLinea == linea){
     if(index == posIni)
        return "";
     else
        return cad.SubString(posIni,index-posIni);
  }
  // No hemos encontrado la lnea que buscbamos.
  return "";
}
//------------------------------------------------------------------------------
int __fastcall TUtilidad::GetNumCadenas(AnsiString cad){

   int fin=cad.Length();
   int cont = 0;
   for(int c=1; c <= fin; c++){
      if( (cad[c] == '\r') && (c+1 <= fin) && (cad[c+1] == '\n') ){
         cont++;
         c++;  // Avanzamos c para absorver "\n";
      }
   }
   // Comprobamos el caso especial de que la ltima cadena no tiene pq acabar
   // en RC:
   if( (fin > 0) && (cad[fin] != '\r') && (cad[fin] != '\n') )
      cont++;
   return cont;
}
//------------------------------------------------------------------------------
AnsiString __fastcall TUtilidad::GetCadenaEntreMarcas(AnsiString cad,int numCad){

   int fin = cad.Length();
   int index = 1;
   int x = 0;

   while(index <= fin){
      if(cad[index] == '<'){
         // Tenemos que distinguir dos casos:
         if(x == numCad){
           // Hemos encontrado la cadena busca -> la obtenemos y la devolvemos:
           // Tenemos que construir una cadena con todo lo que haya en cad hasta
           // llegar al final o a >:
           AnsiString devolver;

           index++; // para absorver el caracter '<'

           while( (index <= fin) && (cad[index] != '>') ){
              devolver+=cad[index];
              index++;
           }
           return devolver;

         }// else tenemos que seguir con la bsqueda (no hay que hacer nada):

         // Aunmentamos el nmero de ocurrencias de <
         x++;
      }
      index++;
   }
   // No se ha encontrado la cadena buscada:
   return "";
}
//---------------------------------------------------------------------------
bool __fastcall TUtilidad::PasaStrAFloat(AnsiString cad,float &f,bool avisar){
   cad=cad.Trim();
   // Consideramos un valor vlida la cadena vaca.
   if(cad == ""){
      f=0;
      return false;
   }
   try{
      f=StrToFloat(cad);
   }catch(...){
      f=0;
      if(avisar)
         MsgInfo("Error real format: " + cad);
      return false;
   }
   return true;
}
//---------------------------------------------------------------------------
float __fastcall TUtilidad::PasaStrAFloat(AnsiString cad,bool avisar){
   float f;
   PasaStrAFloat(cad,f,avisar);
   return f;
}
//---------------------------------------------------------------------------
bool __fastcall TUtilidad::EsFicheroBinario(TStringList *lines){

   if(lines == NULL)
      return false;

   int numLineas = lines->Count;

   if(numLineas == 0)
      return false;

   // Para acelerar la ejecucin en lugar de acceder a lines->Text usaremos
   // cad incluyendo en cad las 15 primeras lneas del fichero:
   AnsiString cad;
   for(int c=0; c < numLineas ; c++){
      cad+= lines->Strings[c];
      if(c == 14)
         break;
   }
   // Para decidir si un fichero es o no binario haremos lo siguiente.
   // Procesaremos a lo sumo 500 caracteres y contaremos el nmero de caracteres
   // vlidos en un fichero X3D: Letras nmeros ", \r \n \t, _ . , * + - { } [ ]
   // Con este valor decidiremos que el fichero es binario si el nmero de
   // caracteres X3D supera el 85% de los caracteres procesados:
   int longit = cad.Length();
   int fin = (longit >= 500) ? 500 : longit;
   char c;
   int cont = 0;

   for(int indexCad=1; indexCad <= fin; indexCad++){
      c = cad[indexCad];

      // Colocamos antes los caracteres ms frecuentes:
      if( (c == ' ') ||
          ((c >= '0') && (c <= '9')) ||
          ((c >= 'a') && (c <= 'z')) ||
          ((c >= 'A') && (c <= 'Z')) ||
          (c == (char)0x9) || (c == (char)0xd) || (c == (char)0xa) ||
          (c == '_') || (c == '"')  || (c == '\'') || (c == '#') || (c == ',') ||
          (c == '.') || (c == '\\') || (c == '/')  || (c == '[') || (c == ']') ||
          (c == '{') || (c == '}')  || (c == '+')  || (c == '-') || (c == '<') || (c == '>') )
          cont++;
   }
   if( fin == 0 )
      return false;
   else
      return   ((cont * 100) / fin) < 85 ;

}


//---------------------------------------------------------------------------
bool __fastcall TUtilidad::Separador(const char c)
{
   // Colocamos los caracteres ms frecuentes al principio para ganar velocidad
   // al usar la evaluacin en cortocircuito.
            // Espacio        Tabulador        Retorno de Carro    Fin de Linea          Coma
   return ( (c == ' ') || (c == (char)0x9) || (c == (char)0xd) || (c == (char)0xa) || (c == (char)0x2c) );
}
//---------------------------------------------------------------------------
int __fastcall TUtilidad::GetNumCaracteresComunes(AnsiString cad1,AnsiString cad2)
{
   int min = (cad1.Length() < cad2.Length()) ? cad1.Length() : cad2.Length();
   for(int c=1; c <= min; c++)
   {
      if(cad1[c] != cad2[c])
         return c-1;
   }
   return min;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TUtilidad::GetWindowLastError(bool showMessage)
{
   char *lpMsgBuf;
   FormatMessage(
       FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
       NULL,
       GetLastError(),
       MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
       (LPTSTR) &lpMsgBuf,
       0,
       NULL);

   AnsiString msg(lpMsgBuf);
   delete lpMsgBuf;

   if(showMessage)
      Utilidad.MsgInfo(msg,"Advertencia");
}



