//
//     CLASE: RichEditVRML    
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
               Esta clase implementa algunas utilidades para el componente
            TRichEdit para formatear el cdigo VRML reconociendo: Nombres de nodos,
            palabras reservadas, nombres de indentificadores dados por el usuario,
            cadenas, valores de los campos y comentarios. A cada uno de estos
            elementos se le puede asignar un formato que es configurable.

            Adems el componente TRichEdit de BCB 5.0 tiene problemas con la
            velocidad de algunas funciones. Por ejemplo,las funciones
            re->Lines->LoadFromStream() y re->Lines->SaveToStream() son lentsimas.
            Se puede mejorar su velocidad considerablemente usando directamente
            los mtodos que proporcionan las API de Windows.
*/
//---------------------------------------------------------------------------
#ifndef RichEditVRML_H
#define RichEditVRML_H

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ImgList.hpp>
#include "ArrayDinamico_.h"
#include "Utilidad_.h"
#include "Main_.h"
#include <Buttons.hpp>
#include <ExtCtrls.hpp>

//---------------------------------------------------------------------------
class RichEditVRML
{
private:
    // Devuelve la siguiente palabra contenida en cad.
    // Y avanza index.
    // tamCad es el tamao de cad (cad.Length()) se pasa para no perder tiempo
    // en calcularla.
    AnsiString __fastcall GetPalabra(int &index,AnsiString &cad,int tamCad);

    // Esta funcin recibe una porcin de texto de un control TRichEdit (re)
    // que viene dada por su posicin inicial y su longitud. Y a este trozo de
    // cdigo le asigna el formato de texto asociado al entero formato.
    // formato debe ser uno de los valores de las constantes declaradas en
    // RichEditVRML_.cpp
    void __fastcall PutFormato(TRichEdit *re,int formato,int posIni,int longit);

    // Devuelve verdadero si palabra es una de las palabras reservadas guardadas
    // en los datos de configuracin (CONF.)
    bool __fastcall EsPalabraReservada(AnsiString &palabra);

public:

    // Usa la informacin de CONF para actualizar el color de fondo, el tipo
    // de letra y el tamao de la fuente. Y finalmente se llama a RepresentaPantalla
    // si es necesario. Hay que pasar un puntero a la ventana que contiene el control re.
    // El parmetro tipo se usa para distinguir dos casos:
    // tipo = 1 -> Se usar la informacin de configuracin del Editor (frmEditor).
    // tipo = 2 -> Se usar la informacin de configuracin de Escena (frmEscena).
    // tipo = 3 -> Se usar el formato simple con tamao para frmEditor.
    // La funcin puede ser lenta (depende del tamao de datos).
    // Si datos es NULL se actualizar la apariencia el contenido de re y en otro
    // caso se asignar datos a re->Text. 
    void __fastcall Inicia(TForm *padre,TRichEdit *re,int tipo,AnsiString *datos=NULL);

    // Pone el cursor en la posicin (fila,columna) del control re.
    // (fila y columna empiezan en 1).
    void __fastcall SetCursorPos(TRichEdit *re, int fila, int col);

    // Formatea las lneas mostradas en re. padre es la ventana que contiene el
    // control re:
    void __fastcall FormateaPantalla(TForm *padre,TRichEdit *re);

    // El componente TRichEdit de BCB 5.0 tiene problemas con la velocidad de
    // algunas funciones. Por ejemplo,las funciones re->Lines->LoadFromStream()
    // y re->Lines->SaveToStream() son lentsimas. Se puede mejorar su velocidad
    // en ms de un 90% al usar directamente los mtodos que proporcionan las API
    // de Windows. As se definen las dos funciones siguientes que sustituyen a
    // las de la clase TRichEdit:
    void __fastcall RichEditLoadFromStream(TRichEdit *re,TMemoryStream *ms);
    void __fastcall RichEditSaveToStream (TRichEdit *re,TMemoryStream *ms);

    // Inexplicablemente el componente re de Borland consume muchsimo tiempo
    // en evaluar re->Lines->Count cuando el fichero tiene muchas lneas.
    // Tanto es as que el programa puede llegar a quedarse colgado.
    // Esta funcin hace lo mismo con las API y es infinitamente ms rpida.
    int __fastcall LinesCount(TRichEdit *re);

    // Evita que se actualice la apariencia del control.
    void __fastcall BloqueaRepaint(TRichEdit *re);
    // Permite que se Actualice la apariencia de re.
    void __fastcall PermiteRepaint(TRichEdit *re);

    // Devuelve el ndice de re->Text asociado al primer caracter de la lnea linea.
    // Los indices que devuelven empiezan en 1 y los indices de linea empiezan en 0.
    // Si se pasa un nmero de lnea no vlido se devuelve 0.
    // Si indexLinea es un nmero mayor o igual que el nmero total de lneas
    // se devolver -1.
    int __fastcall GetIndexLinea(TRichEdit *re,int indexLinea);

    // Devuelve la primera lnea visible de re:
    int __fastcall GetPrimeraLineaVisible(TRichEdit *re);

    // Hace que la primera lnea visible de re sea linea:
    void __fastcall SetPrimeraLineaVisible(TRichEdit *re,int linea);

    // Devuelve el nmero de pixels de alto que tiene asociada una lnea de
    // re con tamao de fuente fontSize. Es necesario es especificar el tamao
    // de la fuente porque en un re es posible tener varios tamaos de fuente y
    // as nos aseguramos de que el tamao devuelto es el deseado.
    // El tamao que se devuelve incluye la altura de la fuente y la separacin
    // entre lneas. Si hay algn problema devuelve -1.
    int __fastcall GetLineHeight(TForm *padre,TRichEdit *re,int fontSize);

    // Devuelve el nmero de lneas que se muestran en el control RichEdit.
    // lineHeight es la altura de una lnea (ver funcin GetLineHeight).
    // reHeight es la altura del control RichEdit:    
    // NOTA: En ocasiones de devuelve una lnea ms de las que realmente se
    //       pueden mostrar.
    int __fastcall GetLinesPerPage(int reHeight,int lineHeight);
};

#endif

// Exportamos un objeto RicEditVRML que contiene funciones tiles para formatear
// y mejorar el comportamiento de un componente TRichEdit.
extern RichEditVRML ReVRML;


