//
//     CLASE: RichEditVRML    
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
               Esta clase implementa algunas utilidades para el componente
            TRichEdit para formatear el cdigo VRML reconociendo: Nombres de nodos,
            palabras reservadas, nombres de indentificadores dados por el usuario,
            cadenas, valores de los campos y comentarios. A cada uno de estos
            elementos se le puede asignar un formato que es configurable.

            Adems el componente TRichEdit de BCB 5.0 tiene problemas con la
            velocidad de algunas funciones. Por ejemplo,las funciones
            re->Lines->LoadFromStream() y re->Lines->SaveToStream() son lentsimas.
            Se puede mejorar su velocidad considerablemente usando directamente
            los mtodos que proporcionan las API de Windows.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "RichEditVRML_.h"
#include "Configuracion_.h"
#include "GestorVRML_.h"
#include "Main_.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)


// Se definen las constantes de formato par hacer el cdigo ms legible:
// FORMATO_NO_VISIBLE Son caracteres como ' ', tab, (char)13 o (char)10
#define FORMATO_NO_VISIBLE           0
#define FORMATO_COMENTARIO           1
#define FORMATO_CADENA               2
#define FORMATO_NORMAL               3
#define FORMATO_LLAVES_Y_CORCHETES   4
#define FORMATO_NODO                 5
#define FORMATO_CAMPO                6
#define FORMATO_PALABRA_RESERVADA    7
#define FORMATO_IDENTIFICADOR        8

// Es un Stream que se usa para las operaciones SaveToStream y LoadFromStream
// que se implementan en esta unidad para los componentes TRichEdit.
TMemoryStream *RichEditStreamBuffer=NULL;

// Las funciones RichEditSaveToStream() (CASO 1) y RichEditLoadFromtream()
// (CASO 2) necesitan una funcin auxiliar cada una. El comportamiento de
// estas funciones se define en la ayuda de las API del mensaje EDITSTREAM.
// NOTA: Hay un error en la ayuda que proporciona BCB, la informacin
// correcta se puede obtener de: http://msdn.microsoft.com/default.aspx
// Parmetros:
// pbBuff : Puntero al buffer de lectura o escritura (segn el caso 1 o 2).
// cb : Numero de bytes que hay que leer o escribir (segn el caso 1 o 2).
// pcb: Puntero a una variable que recibe el nmero de bytes que se han
//      leido o escrito (segn el caso 1 o 2).
//  La funcin debe devolver 0 cuando no hay errores (este es el error
// que hay en la ayuda).
// StreamInCallback corresponde al caso 1 y StreamOutCallback al 2.
//------------------------------------------------------------------------------
DWORD CALLBACK StreamOutCallback(DWORD dwCookie,LPBYTE pbBuff, LONG cb, LONG FAR *pcb){

   // Escribimos cb bytes en la posicin actual de RichEditStreamBuffer
   RichEditStreamBuffer->Write(pbBuff,cb);
   (*pcb) = cb;  // Asignamos el nmero de bytes leidos.
   return 0;
}
//------------------------------------------------------------------------------
DWORD CALLBACK StreamInCallback(DWORD dwCookie,LPBYTE pbBuff, LONG cb, LONG FAR *pcb){

  // Se van a salvar los datos de RichEditStreamBuffer a pbBuff
  // El nmero de Bytes que faltan por escribir en pbBuff es aEscribir:
  int aEscribir = (RichEditStreamBuffer->Size - RichEditStreamBuffer->Position);
  // Distinguimos dos casos para saber si hemos llegado al final de RichEditStreamBuffer.
  if( cb < aEscribir ){
     // Aun no hemos llegado al final de RichEditStreamBuffer.
     RichEditStreamBuffer->Read(pbBuff,cb);
     (*pcb) = cb;          // Asignamos el nmero de bytes escritos en pbBuff
     // Nota: Las API dejarn de llamar a esta funcin cuando devolvamos (*pcb) = 0.
  }else{
     RichEditStreamBuffer->Read((void *)pbBuff,aEscribir);
     (*pcb) = aEscribir;   // Asignamos el nmero de bytes escritos en pbBuff
  }
  return 0;
}

// Creamos un objeto RichEditVRML que contiene funciones tiles para formatear
// y mejorar el comportamiento de un componente TRichEdit.
RichEditVRML ReVRML;

//---------------------------------------------------------------------------
void __fastcall RichEditVRML::FormateaPantalla(TForm *padre,TRichEdit *re)
{
   if( (re == NULL) || !CONF.FORMATEAR_CODIGO || (FORMATO_MAX_NUM_LINS < LinesCount(re)) )
      return;

   // Vamos a obtener los indices inicio y fin de re->Text que marcan los lmites
   // del texto a formatear. Antes de eso hay que obtener el nmero de lneas que
   // caben en el re:
   // Obtenemos la altura de una lnea:
   int lineHeight = GetLineHeight(padre,re,10);
   if(lineHeight == -1)
      // Funcionaos con tolerancia a fallos especificando una valor tpico:
      lineHeight = 10;

   // Obtenemos el nmero de lneas por pantalla:
   int linesPerPage = GetLinesPerPage(re->Height,lineHeight);

   int primLinea = GetPrimeraLineaVisible(re);
   int posInicial= GetIndexLinea(re,primLinea);
   int posFinal  = GetIndexLinea(re,primLinea+linesPerPage+1);

   if((posInicial == 0) || (posFinal == 0) )
      // Primera Linea es mayor que el nmero de lineas del fichero o bien
      // el fichero no tiene ningn carecter.
      return;

   AnsiString cad = re->Text;

   //int tamCad = re->Text.Length(); Esto es mucho ms lento en ficheros grandes.
   int tamCad = SendMessage(re->Handle, WM_GETTEXTLENGTH, 0, 0);

   if(posFinal <= 0)
      posFinal = tamCad;

   int indexIni,index=posInicial;

   AnsiString palabra,palabraAnterior="";

   // Hay que salvar la seleccin actual y reponerla al final del proceso.
   // int selPos = re->SelStart;         // MODO 1
   // int selLen = re->SelLength;
   CHARRANGE seleccionAnter;             // MODO 2
   SendMessage(re->Handle, EM_EXGETSEL, 0, (LPARAM) &seleccionAnter);

   // Hay que solucionar un problema. Y es que cuando se representa el texto
   // se ve el parpadeo debido que se est seleccionando el texto. Para evitarlo
   // quitamos el foco a re (re->HideSelection debe ser true).
   bool teniaElFoco = (padre->ActiveControl == re);
   if(padre->Visible && re->Enabled && teniaElFoco )
      padre->FocusControl(NULL);

   while(index <= posFinal)
   {
      int indexInicial = index;
                                         // SEPARADOR o NUMEROS 
      if(  (GVRML.Separador(cad[index])) || ((cad[index] >= '0') && (cad[index] <= '9')) ||
                                             (cad[index] == '.') || (cad[index] == '-') ){

         indexIni = index;
         index++;
         // Vamos a obtener todos los caracteres asociados al tipo de texto actual.
         while( (index <= posFinal) &&
                    ( (GVRML.Separador(cad[index])) ||
                      ((cad[index] >= '0') && (cad[index] <= '9')) ||
                      (cad[index] == '.') || (cad[index] == '-'))  ){

            index++;
         }
         // Formateamos el trozo anterior:
         PutFormato(re,FORMATO_NORMAL,indexIni,index-indexIni);
      }
      else if( ((cad[index] == '"') || (cad[index] == '\''))) // CADENA 
      {
         // Dada una cadena que ocupa varias lneas " ...\r\n ...  X ... \r\n ..."
         // Es posible que hayamos empezado a dar formato en el punto X y
         // entonces las comillas iniciales que encontramos son en realidad las
         // de cierre as que solo formatearemos el texto entre "" si est en
         // la misma lnea.

         // Vamos a obtener todos los caracteres asociados al tipo de texto actual.
         bool en1Linea = true;
         indexIni = index;
         index++;
         // Hay que ignorar las comillas precedidas de '\':
         while(index <= posFinal)
         {
            bool noEsComillaDoble  =   (cad[index] != '"') ||
                                      ( (index > 1) && (cad[index] == '"' ) && (cad[index-1] == '\\') );
            bool noEsComillaSimple =   (cad[index] != '\'') ||
                                      ( (index > 1) && (cad[index] == '\'' ) && (cad[index-1] == '\\') );

            if(!noEsComillaDoble || !noEsComillaSimple)
               break;

            if( (cad[index] == '\n') || (cad[index] == '\r') ){
               en1Linea = false;
               break;
            }
            index++;
         }
         if(index <= posFinal)
            index++; // para incluir las " de cierre.
         if(en1Linea)
         {
            int formato = FORMATO_CADENA;
            if( (palabraAnterior == "DEF"        ) ||
                (palabraAnterior == "EXTERNPROTO") ||
                (palabraAnterior == "PROTO"      ) ||
                (palabraAnterior == "ROUTE"      ) ||
                (palabraAnterior == "TO"         ) ||
                (palabraAnterior == "fromNode"   ) ||
                (palabraAnterior == "fromField"  ) ||
                (palabraAnterior == "toNode"     ) ||
                (palabraAnterior == "toField"    ) ||
                (palabraAnterior == "USE") )
                   formato = FORMATO_IDENTIFICADOR;

            PutFormato(re,formato,indexIni,index-indexIni);
         }
         else{
            // En este caso tenemos una cadena en varias lneas y la mejor opcin
            // es no darle formato as que volvemos dejando index tras la primera
            // comilla:
            index= indexIni + 1;
         }

      }else if( (cad[index] == '!') &&
                (index > 1) && (cad[index-1] == '<') &&
                ((index + 2) < posFinal) && (cad[index+1] == '-') && (cad[index+2] == '-') )
      {
         // Vamos a obtener todos los caracteres asociados al tipo de texto actual.
         indexIni = index;
         index+=3;
         while( ((index+2) <= posFinal) && (cad[index] != '-') && (cad[index+1] != '-') && (cad[index+2] != '>') )
         {
            index++;
         }
         index+=3;
         PutFormato(re,FORMATO_COMENTARIO,indexIni,index-indexIni       );
      }
      else if( (cad[index] == '{') || (cad[index] == '}') ||
               (cad[index] == '<') || (cad[index] == '>') ||
               (cad[index] == '/') || (cad[index] == '=') ||
               (cad[index] == '[') || (cad[index] == ']') ){ // CORCHETES Y LLAVES: { } [ ]

         PutFormato(re,FORMATO_LLAVES_Y_CORCHETES,index,1);
         index++;
      }else{  // PALABRAS 
         // En este caso tenemos palabras y hay que ver si son:
         //  a) Nodos.
         //  b) Campos.
         //  c) Palabras Reservadas: DEF,USE,ROUTE etc.
         //  d) Identiticadores (Nombres de nodos)
         //  e) El resto son los datos que hay en los campos.

         // Vamos a obtener la palabra que hay a partir de index:
         indexIni = index;
         // palabra=GetPalabra(index , cad, tamCad);

         //vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv Get Palabra vvvvvvvvvvvvvvvv
         // Absorvemos los separadores.
         while( (index <= tamCad) && GVRML.Separador(cad[index]))
            index++;
         // Ahora obtenemos la siguiete palabra.
         palabra="";
         while( (index <= tamCad) && !GVRML.Separador(cad[index])  &&
              (cad[index] != '#') && (cad[index] != '"') && (cad[index] != '{') &&
              (cad[index] != '}') && (cad[index] != '[') && (cad[index] != ']') &&
              (cad[index] != '<') && (cad[index] != '>') && (cad[index] != '=') ){
              palabra+=cad[index];
              index++;
         }
         //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ Get Palabra ^^^^^^^^^^^^^^^^

         int formato;

         if( (palabra == "Scene") || (palabra == "X3D") )
            formato = FORMATO_NODO;

         else if(NULL != frmEscena->GN->DatosNodo(palabra))
            formato = FORMATO_NODO;
         else if( frmEscena->GN->EsCampo(palabra) )
            formato = FORMATO_CAMPO;
         else if( EsPalabraReservada(palabra) )
            formato = FORMATO_PALABRA_RESERVADA;
         else
            formato = FORMATO_NORMAL;

         palabraAnterior=palabra;  // Actualizamos palabraAnterior.

         PutFormato(re,formato,indexIni,palabra.Length());
      }
      // Para asegurar que avanzamos:
      if(index == indexInicial)
         index++;
   }

   // Reponermos la seleccin original.
   // re->SelStart=selPos;   // MODO 1:
   // re->SelLength=selLen;
                          // MODO 2:
   SendMessage(re->Handle, EM_EXSETSEL, 0, (LPARAM) &seleccionAnter);

   // Devolvemos el foco al control si es que lo tena:
   if(padre->Visible && re->Enabled && re->CanFocus() && teniaElFoco )
      padre->FocusControl(re);
}
//------------------------------------------------------------------------------
AnsiString __fastcall RichEditVRML::GetPalabra(int &index,AnsiString &cad,int tamCad){

    // Absorvemos los separadores.
    while( (index <= tamCad) && GVRML.Separador(cad[index]))
       index++;
    // Ahora obtenemos la siguiete palabra.
    int inicio=index;
    while( (index <= tamCad) && !GVRML.Separador(cad[index])  &&
           (cad[index] != '#') && (cad[index] != '"') && (cad[index] != '{') &&
           (cad[index] != '}') && (cad[index] != '[') && (cad[index] != ']') )
       index++;
    return cad.SubString(inicio,index-inicio);
}
//------------------------------------------------------------------------------
bool __fastcall RichEditVRML::EsPalabraReservada(AnsiString &palabra)
{
   return (-1 != CONF.PalabrasReservadas->IndexOf(palabra));
}

//---------------------------------------------------------------------------
void __fastcall RichEditVRML::SetCursorPos(TRichEdit *re, int fila, int col){

   if( (re == NULL) || (fila < 0) || (col < 0) )
      return;

   // El cdigo de esta funcin se ha obtenido de unas FAQs de internet ya que
   // el componente TRichEdit que proporciona Borland no permite mover el cursor
   // a una fila y columna determinadas. Es necesario usar las API de windows.

   // En primer lugar obtenemos el nmero de caracteres en el control.
   int longDatos= SendMessage(re->Handle, WM_GETTEXTLENGTH, 0, 0);

   // A continuacin colocamos el cursor en la fila fila.
   CHARRANGE chrg;
   // EM_LINEINDEX devuelve el ndice (desde el principio de los datos) del
   // primer caracter de la lnea fila-1.
   // Devuelve -1 si la lnea pedida el mayor que el n total de lneas.
   chrg.cpMin = chrg.cpMax = SendMessage(re->Handle, EM_LINEINDEX, (WPARAM) fila-1, 0);
   if (chrg.cpMin == -1)   // En este caso nos colocamos al final del fichero.
     chrg.cpMin = chrg.cpMax =  longDatos;
   // Este mensaje, EM_EXSETSEL, hace que el cursor se coloque en la posicin
   // indicada por chrg (que contiene el nmero de caracteres desde el principio.

   // aadimos la columna.
   chrg.cpMin += col-1;
   chrg.cpMax += col-1;
   SendMessage(re->Handle, EM_EXSETSEL, 0, (LPARAM) &chrg);

   // int primeraLinVisible = GetPrimeraLineaVisible(re);
   // El ltimo paso es hacer que el cursor aparezca en la pantalla. Con la
   // siguiente lnea se hace un scroll, si es necesario, para que el cursor
   // aparezca en la pantalla.
   re->Perform(EM_SCROLLCARET, 0, 0);
   /*
   // Tras hacer el scroll puede haber un problema y es que a veces no se ve la
   // ltima lnea por completo sino solo parte, para evitarlo, en el caso de
   // que haya cambiado la primera lnea desplazaremos una lnea ms.
   int primeraLinVisible2 = GetPrimeraLineaVisible(re);
   if( primeraLinVisible2 != primeraLinVisible)
       SendMessage(re->Handle,EM_SCROLL, SB_LINEDOWN, 0);

        Pero a veces la primera lnea se ve mal.
   */
}
//---------------------------------------------------------------------------
void __fastcall RichEditVRML::Inicia(TForm *padre,TRichEdit *re,int tipo,AnsiString *datos)
{
   if( (padre == NULL) || (re == NULL) )
      return;

   // Hay que salvar la seleccin actual y reponerla al final del proceso.
   // int selPos = re->SelStart;         // MODO 1
   // int selLen = re->SelLength;
   CHARRANGE seleccionAnter;             // MODO 2
   SendMessage(re->Handle, EM_EXGETSEL, 0, (LPARAM) &seleccionAnter);

   Screen->Cursor=PUNT_RATON_ESPERA;

   // Desactivamos la actualizacin del control para evitar parpados.
   ReVRML.BloqueaRepaint(re);

   // Para que se pueda cambiar el tipo de letra y el tamao del texto re->ReadOnly
   // deber ser false:
   bool readOnlyTmp = re->ReadOnly;
   re->ReadOnly=false;

   // Vemos si hay que asignar los datos.
   if(datos != NULL)
      re->Text = (*datos);

   // En cualquier caso formatearemos todo el texto teniendo en cuenta lo siguiente:
   //   Para el tamao de letra se distinguiran los casos: tipo 1,2 o 3 (frmEscena / frmEditor).
   //   El tipo de letra ser el configurado en cualquiera de los tres casos.
   //   Si estamos en el caso 3 o bien no hay que formatear el csigo se usar
   //  el formato general. En otro caso se formatear todo el cdigo con el
   // formato normal. Esto se hace as porque al representar pantalla ahorramos
   // mucho tiempo si el texto ya tiene el formato correcto (y el formato normal
   // es el ms frecuente.
   re->SelectAll();
   re->SelAttributes->Name = CONF.Formato_NOMBRE_FUENTE;   // TIPO DE FUENTE 
   re->Color = CONF.Formato_COLOR_FONDO;                   // COLOR DE FONDO 

   // Solo se dar formato al texto cuando tipo sea != 3 y CONF.FORMATEAR_CODIGO
   // sea true:
   bool elTextoSeFormatea = CONF.FORMATEAR_CODIGO && (tipo != 3) &&
                            (FORMATO_MAX_NUM_LINS >= LinesCount(re));
   if( elTextoSeFormatea )                                 // COLOR DEL TEXTO 
      re->SelAttributes->Color = CONF.Formato_NORMAL_color;
   else
      re->SelAttributes->Color = CONF.Formato_GENERAL_color;

   if( (tipo == 1) || (tipo == 3) )                        // TAM.DE LA FUENTE 
      re->SelAttributes->Size = CONF.Formato_TAM_FUENTE_EDITOR;
   else
      re->SelAttributes->Size = CONF.Formato_TAM_FUENTE_ESCENA;

   re->SelAttributes->Style = TFontStyles();               // ATRIBUTOS NEGR Y CURS 
   if(elTextoSeFormatea){
      if( CONF.Formato_NORMAL_NC & CFE_BOLD )
         re->SelAttributes->Style = re->SelAttributes->Style << fsBold;
      if( CONF.Formato_NORMAL_NC & CFE_ITALIC )
         re->SelAttributes->Style = re->SelAttributes->Style << fsItalic;
   }else{
      if( CONF.Formato_GENERAL_NC & CFE_BOLD )
         re->SelAttributes->Style = re->SelAttributes->Style << fsBold;
      if( CONF.Formato_GENERAL_NC & CFE_ITALIC )
         re->SelAttributes->Style = re->SelAttributes->Style << fsItalic;
   }

   if(elTextoSeFormatea)
      FormateaPantalla(padre,re);

   // Reponermos la seleccin original.
   // re->SelStart=selPos;   // MODO 1:
   // re->SelLength=selLen;
                          // MODO 2:
   SendMessage(re->Handle, EM_EXSETSEL, 0, (LPARAM) &seleccionAnter);

   re->ReadOnly=readOnlyTmp;

   // Activamos de nuevo la actualizacin del control RichEdit
   ReVRML.PermiteRepaint(re);

   InvalidateRect(re->Handle, 0, true);   // Equivale a Repaint();

   Screen->Cursor=PUNT_RATON_NORMAL;
}
//------------------------------------------------------------------------------
void __fastcall RichEditVRML::BloqueaRepaint(TRichEdit *re){
   SendMessage(re->Handle,WM_SETREDRAW, false, 0);
}
//------------------------------------------------------------------------------
void __fastcall RichEditVRML::PermiteRepaint(TRichEdit *re){
   SendMessage(re->Handle,WM_SETREDRAW, true, 0);
}
//------------------------------------------------------------------------------
void __fastcall RichEditVRML::PutFormato(TRichEdit *re,int formato,int posIni,int longit)
{
   // Los indices de AnsiString empiezan en 1 -> lo convertimos al caso habitual:
   posIni--;

   // Esta variable especifica el rango de texto que vamos a formatear.
   CHARRANGE rango;
   rango.cpMin=posIni;
   rango.cpMax=posIni+longit;

   // Con esta llamada seleccionamos el texto especificado por rango.
   SendMessage(re->Handle, EM_EXSETSEL, 0, (LPARAM) &rango);

   static CHARFORMAT cf;  // Especifica qu formato vamos a dar al texto seleccionado.
   memset(&cf, 0, sizeof(cf));  // Inicializamos a 0 la estructura.
   cf.cbSize = sizeof(cf);      // Asignamos el tamao en bytes de la estructura.
   // Con esta mscara indicamos que vamos usar el color y los modos BOLD e ITALIC.
   cf.dwMask = CFM_COLOR | CFM_BOLD | CFM_ITALIC;

   // Asignamos los campos cf.crTextColor y cf.dwEffects segn el caso.
   switch(formato){
      case FORMATO_NORMAL:
         cf.dwEffects   = CONF.Formato_NORMAL_NC;
         cf.crTextColor = CONF.Formato_NORMAL_color;              break;
      case FORMATO_COMENTARIO:
         cf.dwEffects   = CONF.Formato_COMENTARIO_NC;
         cf.crTextColor = CONF.Formato_COMENTARIO_color;          break;
      case FORMATO_CADENA:
         cf.dwEffects   = CONF.Formato_CADENA_NC;
         cf.crTextColor = CONF.Formato_CADENA_color;              break;
      case FORMATO_LLAVES_Y_CORCHETES:
         cf.dwEffects   = CONF.Formato_LLAVES_Y_CORCHETES_NC;
         cf.crTextColor = CONF.Formato_LLAVES_Y_CORCHETES_color;  break;
      case FORMATO_NODO:
         cf.dwEffects   = CONF.Formato_NODO_NC;
         cf.crTextColor = CONF.Formato_NODO_color;                break;
      case FORMATO_CAMPO:
         cf.dwEffects   = CONF.Formato_CAMPO_NC;
         cf.crTextColor = CONF.Formato_CAMPO_color;               break;
      case FORMATO_PALABRA_RESERVADA:
         cf.dwEffects   = CONF.Formato_PALABRA_RESERVADA_NC;
         cf.crTextColor = CONF.Formato_PALABRA_RESERVADA_color;   break;
      case FORMATO_IDENTIFICADOR:
         cf.dwEffects   = CONF.Formato_IDENTIFICADOR_NC;
         cf.crTextColor = CONF.Formato_IDENTIFICADOR_color;       break;
      case FORMATO_NO_VISIBLE:
         // Caso poco frecuente, usamos el formato normal.
         cf.dwEffects   = CONF.Formato_NORMAL_NC;
         cf.crTextColor = CONF.Formato_NORMAL_color;              break;
   }

   // Antes de asignar el formato al texto seleccionado vamos a comprobar que
   // si tiene ya el formato que queremos darle. Con eso ahorraremos mucho tiempo.
   static CHARFORMAT cfActual;
   memset(&cfActual, 0, sizeof(cfActual));  // Inicializamos a 0 la estructura.
   cfActual.cbSize = sizeof(cfActual);      // Asignamos el tamao en bytes de la estructura.

   SendMessage(re->Handle, EM_GETCHARFORMAT, SCF_SELECTION, (LPARAM) &cfActual);
   if( (cfActual.crTextColor != cf.crTextColor) || (cfActual.dwEffects != cf.dwEffects) ){
       SendMessage(re->Handle, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM) &cf);
   }
//    SendMessage(re->Handle, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM) &cf);
}
//------------------------------------------------------------------------------
void __fastcall RichEditVRML::RichEditSaveToStream(TRichEdit *re,TMemoryStream *ms)
{
   if( (re == NULL) || (ms == NULL) )
      return;

   RichEditStreamBuffer=ms;

   EDITSTREAM stream;

   stream.dwCookie = 0; // Es un parmetro que se pasa a la funcin de Callback,
                        // lo inicializamos pero no lo usaremos.
   // Direccin de la funcin que transfiere los datos.
   stream.pfnCallback = StreamOutCallback;
   // Los otros dos parmetros de stream se ignoran (uno es para saber si se ha
   // producido un error de salida y el otro es para pasar informacin a la funcin
   // pfnCallback.

   // Obtenemos el tamao del control re.
   int longDatos= SendMessage(re->Handle, WM_GETTEXTLENGTH, 0, 0);
   // Hacemos que el stream tenga el tamao necesario.
   ms->SetSize(longDatos);
   ms->Position=0; // Nos colocamos al principio del buffer.

   SendMessage(re->Handle,EM_STREAMOUT,SF_TEXT,(LPARAM) &stream);
}
//------------------------------------------------------------------------------
void __fastcall RichEditVRML::RichEditLoadFromStream(TRichEdit *re,TMemoryStream *ms)
{
   if( (re == NULL) || (ms == NULL) )
      return;

   RichEditStreamBuffer=ms;
   // Nos colocamos al principio del buffer.
   RichEditStreamBuffer->Position=0;

   // Creamos la estrucura que tenemos que pasar con el mensaje EM_STREAMIN
   EDITSTREAM stream;
   // Direccin de la funcin que transfiere los datos.
   stream.pfnCallback = StreamInCallback;
   // Los otros dos parmetros de stream se ignoran (uno es para saber si se ha
   // producido un error de salida y el otro es para pasar informacin a la funcin
   // pfnCallback.

   SendMessage(re->Handle,EM_STREAMIN, SF_TEXT,(LPARAM) &stream);
}
//------------------------------------------------------------------------------
int __fastcall RichEditVRML::LinesCount(TRichEdit *re){
   return (re == NULL) ? 0 : SendMessage(re->Handle, EM_GETLINECOUNT, 0, 0);
}
//---------------------------------------------------------------------------
int __fastcall RichEditVRML::GetPrimeraLineaVisible(TRichEdit *re){
   if (re == NULL)
      return 0;
   return re->Perform(EM_GETFIRSTVISIBLELINE,0,0);
}
//---------------------------------------------------------------------------
void __fastcall RichEditVRML::SetPrimeraLineaVisible(TRichEdit *re,int linea){
   if (re == NULL)
      return;

   int prim = GetPrimeraLineaVisible(re);
   // pe si prim= 10 y linea es 20  ->  linea-prim = 10
   re->Perform(EM_LINESCROLL,0,(DWORD)linea-prim );
}
//---------------------------------------------------------------------------
int __fastcall RichEditVRML::GetIndexLinea(TRichEdit *re,int indexLinea){

   if(re == NULL)
      return 0;

   int x = SendMessage(re->Handle, EM_LINEINDEX, (WPARAM)indexLinea, 0);

   if(x == -1)
      return x;

   x++; // Para convertir a los indices de AnsiString.

   // Parece que no hay una correspodencia total entre el control RichEdit
   // de Windows y re->Text.Length() porque en ocasiones GetIndexLinea (que
   // usa las API de windows) devuelve 1 caracter mas de la longitud que tiene
   // re->Text.Length(), as hay que hacer:
   // int final = re->Text.Length(); evito esto pq es demasiado lento en ficheros grandes.
   int final = SendMessage(re->Handle, WM_GETTEXTLENGTH, 0, 0);
   if(x > final)
      x = final;
   return x;
}
//---------------------------------------------------------------------------
int __fastcall RichEditVRML::GetLineHeight(TForm *padre,TRichEdit *re,int fontSize){

   if( (padre == NULL) || (re == NULL) )
      return -1;

   // Asignamos el tamao de la fuente.
   re->Font->Size = fontSize;

   // Obtenemos el tamao de la lnea usando las API:
   // Obtenemos el "device Context" asociado a la ventana.
   HDC dc = GetDC(padre->Handle);

   // Asociamos con dc el tipo de fuente que queremos procesar. Realmente estamos
   // cambiando el elemento seleccionado del "device context" (reemplazando
   // elemAnter por Texto->Font->Handle)
   void *elemAnter = SelectObject(dc, re->Font->Handle);

   // Obtenemos los datos "mtricos" de la fuente seleccionada en dc:
   TEXTMETRIC metX;
   if(!GetTextMetrics(dc, &metX))
      return -1;

   // Reponemos el objeto que tena inicialmente asociado dc:
   SelectObject(dc, elemAnter);

   // El tamao de la lnea se obtiene como:
   return metX.tmHeight + metX.tmExternalLeading;
}
//---------------------------------------------------------------------------
int __fastcall RichEditVRML::GetLinesPerPage(int reHeight,int lineHeight){

   if(lineHeight == 0)
      return 0;
   // Tericamente deberamos usar +1 pero en la prctica se ve que con +1 no
   // siempre se obtiene el correcto -> As que ajustamos con +3. En algunas
   // ocasiones se devolver una o dos lnea ms de las que realmente se muestran.
   return (reHeight / lineHeight) + 3;
}

