//
//     CLASE   MAIN        
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta es la clase de la ventana principal del programa.
*/

#ifndef Main_H
#define Main_H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Menus.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <Buttons.hpp>
#include <Mask.hpp>
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>
#include <OleCtnrs.hpp>
#include "GestorNodos_.h"
#include "GestorTipos_.h"
#include "Configuracion_.h"
#include "frmInicio_.h"
#include "LibXmlComps.hpp"
#include "LibXmlParser.hpp"
#include <Graphics.hpp>


// Referencia a la ETSIT y a la UMA, se usar en varias partes del programa.
#define ETSIT_UMA "Telecommunications Engineering Faculty - University of Mlaga and Sensegraphics"
// Nombre del programa
#define NOMBRE_DEL_PROGRAMA "D I S R E A L"
#define NOMBRE_DEL_PROGRAMA2 "DisReal"

// Nombre del fichero de configuracin que se usa para almacenar los ltimos
// nodos insertados en la escena.
#define FICHERO_NODOS_RECIENTES "nodosrects.cfg"

#define FICHERO_DE_AYUDA "DisReal.hlp"

// Para almacenar los valores por defecto de los fichero de configuracin se
// usa otro fichero de igual nombre y con este sufijo.
#define SUFIJO_CONF_VAL_DEFECTO " VD"

// Tiempo en ms que se retarda la aparicin de la ventana principal para
// mostrar frmInicio.
#define RETARDO_frmInicio 500

// A partir de FORMATO_MAX_NUM_LINS lneas en el editor se usar el formato
// simple para representar el texto. En teora no deberia haber problemas con
// ficheros grandes porque no se da formato a todo el fichero sino solo a lo
// que se ve, pero en la prctica los mtodos de un componente TRichEdit son
// ms lentos cuando se carga ficheros grandes.
#define FORMATO_MAX_NUM_LINS 50000

// links de la Ayuda:
#define URL_ESPECIFICACION_VRML "www.web3d.org/x3d/specifications/vrml/ISO_IEC_14772-All/part1/concepts.html"
#define URL_DISREAL "www.diana.uma.es/investigaIHM/pfc/DisReal/DisReal.htm"
//http://www.diana.uma.es/investigaIHM/pfc/DisReal.htm

// Tiempo en ms que se muestra la ventana frmInicio despus de que se hayan creado
// todas las ventanas.
#define TIEMPO_TRAS_CREACION_frmInicio 400

// La siguiente constante contiene la primera lnea que deben tener todos los
// ficheros VRML.
#define PRIMERA_LINEA_VRML "#X3D V3.0 utf8"

// Al asignar flujos de datos con streams no se puede mostrar barras de progreso.
// en su lugar cambiaresmos el puntero del ratn a PUNT_RATON_ESPERA y despus se
// repondr con PUNT_RATON_NORMAL
#define PUNT_RATON_ESPERA crHourGlass
#define PUNT_RATON_NORMAL crDefault

// Es el nombre del fichero en el que se guarda la escena por defecto.
// ? se usa para saber que an no se ha asignado una carpeta a la escena. As
// cuando se vaya a salvar el fichero se pedir elegir un carpeta.
#define FICHERO_POR_DEFECTO "?:\\New Scene"

// Extensin usada tanto para ficheros X3D como H3D.
#define EXTENSION_X3D ".x3d"

// Extensin de los ficheros VRML binarios que crea H3D.
#define EXTENSION_wrlb ".wrlb"

// Nombre de la carpeta que contiene ejemplos.
#define CARPETA_EJEMPLOS "Examples"

// Nombres de los 4 ficheros por defecto al iniciar el programa la primera vez.
#define FICH_EJEMPLO1 "Example1.x3d"
#define FICH_EJEMPLO2 "Example2.x3d"
#define FICH_EJEMPLO3 "Example3.x3d"
#define FICH_EJEMPLO4 "Example4.x3d"

// Contiene los datos que se usan, por defecto, para dar formato al cgigo VRML.
// El significado de cada elemento se explica en Configuracion_.h
//#define DATOS_TEXTO_CON_FORMATO "10 8 clWhite NO_VISIBLE: -- clYellow CADENA: N- clRed LLAVES_Y_CORCHETES: N- clBlue CAMPO: -- clBlue IDENTIFICADOR: N- clLime COMENTARIO: NC clGray NORMAL: -- clFuchsia NODO: N- clBlue PALABRA_RESERVADA: N- clBlue GENERAL: -- clBlue"

#define DATOS_TEXTO_CON_FORMATO "10 8 clWhite NO_VISIBLE: -- clGray CADENA: -- clFuchsia LLAVES_Y_CORCHETES: N- clGray CAMPO: -- clBlue IDENTIFICADOR: N- 0x006FDD00 COMENTARIO: N- clGray NORMAL: -- clFuchsia NODO: N- clBlue PALABRA_RESERVADA:  N- 0x00B48080 GENERAL: -- clBlue"

// Nombre del fichero que contiene el video avi con la animacin del programa:
#define VIDEO_LOGO_PROGRAMA "AnimPrograma.cfg"

// Nombre del fichero que contiene el video avi con la animacin del cuadro:
#define VIDEO_CUADRO "CuadroAnim.cfg"

// Nombre del fichero que contiene el video avi con la animacin del logo VRML:
#define VIDEO_VRML "VRMLAnim.cfg"

// Nombre del fichero que contiene el video avi con la animacin del logo H3D:
#define VIDEO_H3D "H3DAnim.cfg"

//------------------------------------------------------------------------------
// Ser necesario distinguir los tipos de escena.
enum TipoEscena {ESCENA_X3D = 0, ESCENA_H3D = 1 };
//------------------------------------------------------------------------------
class TMain : public TForm
{
__published:	// IDE-managed Components
     TMainMenu *Menu;
        TMenuItem *mnArchivo;
        TMenuItem *mnAbrirEscenaH3D;
        TMenuItem *mnGuardar;
        TMenuItem *mnGuardarComo;
        TMenuItem *mnEdicion;
        TMenuItem *mnCopiar;
        TMenuItem *mnCortar;
        TMenuItem *mnPegar;
        TMenuItem *mnSalir;
        TMenuItem *mnNuevaEscenaH3D;
        TMenuItem *mnInformacion;
        TMenuItem *mnAyuda;
        TMenuItem *mnAyudaAyuda;
        TToolBar *ToolBar;
        TSpeedButton *sbNuevaEscenaX3D;
        TSpeedButton *sbAbrirEscenaH3D;
    TSpeedButton *sbSalvar;
        TSpeedButton *sbCortar;
        TSpeedButton *sbCopiar;
        TSpeedButton *sbPegar;
        TSpeedButton *sbTipoNodos;
        TSpeedButton *sbDetallesNodos;
        TSpeedButton *sbTipos;
        TSpeedButton *sbAyuda;
        TOpenDialog *dlgAbrir;
        TSaveDialog *dlgSalvar;
        TMenuItem *mnNuevaEscenaX3D;
        TMenuItem *mnAbrirEscenaX3D;
        TMenuItem *mnBorrar;
        TMenuItem *mnNodosX3D;
        TMenuItem *mnNodosH3D;
        TMenuItem *mnTiposX3D;
        TMenuItem *mnTiposH3D;
        TMenuItem *mnPaginaX3D;
        TMenuItem *mnPaginaH3D;
        TMenuItem *mnDTEUMA;
        TMenuItem *mnEscena;
        TMenuItem *mnInsertar;
        TMenuItem *mnInsertarComentario;
        TMenuItem *mnInsertarNodo;
        TMenuItem *mnInsertarUSE;
        TMenuItem *mnInsertarRutado;
        TMenuItem *mnEjecutar;
        TMenuItem *mnEjecucionX3D;
        TMenuItem *mnEjecucionH3D;
        TMenuItem *mnVer;
        TMenuItem *mnVinculosRutado;
        TMenuItem *mnLastFichero1;
        TMenuItem *mnLastFichero2;
        TMenuItem *mnLastFichero3;
        TMenuItem *mnLastFichero4;
        TMenuItem *mnCamposX3D;
        TMenuItem *mnCamposH3D;
    TMenuItem *mnArchivoBarra1;
    TMenuItem *mnArchivoBarra2;
    TMenuItem *mnBuscar;
    TMenuItem *mnInformacionBarra;
    TMenuItem *mnEscenaBarra1;
    TMenuItem *mnEdicionBarra;
    TPanel *BarraEstado;
    TPanel *BarraEstadoEstadistica;
    TPanel *BarraEstadoEscena;
    TMenuItem *mnEdicionBuscarSiguiente;
    TMenuItem *mnUtilidades;
    TMenuItem *mnUtilidadesExpandirNodo;
    TMenuItem *mnUtilidadesOcultarHijos;
    TMenuItem *mnEscenaEditarCodigo;
    TMenuItem *mnEscenaBarra2;
        TMenuItem *mnUtilidadesConfiguracion;
    TPanel *BarraEstadoLineas;
    TPanel *pnlModificada;
        TSpeedButton *sbAbrirEscenaX3D;
        TSpeedButton *sbNuevaEscenaH3D;
        TSpeedButton *sbNuevaEscenaH3D_;
    TSpeedButton *SpeedButton2;
    TOpenPictureDialog *dlgAbrirImg;
        TMenuItem *mnUtilidadesPosiciona;
        TPanel *pnlTools;
        TSpeedButton *sbOcultarHijos;
        TSpeedButton *sbBorrar;
        TSpeedButton *sbExpandirHijos;
        TSpeedButton *sbEjecutar;
        TSpeedButton *sbNodoNuevo;
        TSpeedButton *sbUSE;
        TSpeedButton *sbComentario;
        TSpeedButton *sbEditar;
        TSpeedButton *sbVinculosRutado;
        TSpeedButton *sbRutado;
        TSpeedButton *sbBuscarSiguiente;
        TSpeedButton *sbBuscar;
        TSpeedButton *sbVs;
        TSpeedButton *sbGaleriaVRML;
        TSpeedButton *sbGaleriaSonidos;
        TSpeedButton *sbGaleriaTexturas;
        TMenuItem *mnVerHerramientas;
        TMenuItem *mnVerHerramientasVentana;
        TMenuItem *mnVerHerramientasBarra;
        TMenuItem *mnVerHerramientasOcultar;
        TSpeedButton *sbColocarV;
        TMenuItem *mnAyudaEspecificacionVRML;
        TMenuItem *mnAyudaAcerca;
        TMenuItem *mnUtilidadesEditaDatos;
        TMenuItem *mnAbrirEscena;
        TMenuItem *N1;
        TColorDialog *dlgColor;
        TMenuItem *mnVerConsolaH3D;
        TMenuItem *mnUtilidadesAsignarTransform;
        TMenuItem *N2;
        TMenuItem *mnUtilidadesGalerias;
        TMenuItem *mnUtilidadesGaleriasSonidos;
        TMenuItem *mnUtilidadesGaleriasTexturas;
        TMenuItem *mnUtilidadesGaleriasObjetos;
        TSpeedButton *sbColocarObjetos;
        TSpeedButton *sbConfiguracion;
        TSpeedButton *sbConsolaH3D;
        TMenuItem *mnUtilidadesConversion;
        TMenuItem *N3;
        TMenuItem *mnUtilidadesAsignarRGB;
        TMenuItem *mnUtilidadesAsignarSFVec3f;
        TMenuItem *mnUtilidadesRelieve;
        TMenuItem *mnAyudaVisores;
        TMenuItem *mnDisReal;
        TMenuItem *mnSenseGraphics;
        TMenuItem *mnWeb3D;
        TMenuItem *mnH3DUpdates;
        void __fastcall sbTipoNodosClick(TObject *Sender);
        void __fastcall FormCanResize(TObject *Sender, int &NewWidth,
                                      int &NewHeight, bool &Resize);
        void __fastcall FormResize(TObject *Sender);
        void __fastcall Ejecutar1Click(TObject *Sender);
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
        void __fastcall mnNuevaEscenaX3DClick(TObject *Sender);
        void __fastcall mnNuevaEscenaH3DClick(TObject *Sender);
        void __fastcall mnAbrirEscenaX3DClick(TObject *Sender);
        void __fastcall mnAbrirEscenaH3DClick(TObject *Sender);
        void __fastcall mnGuardarClick(TObject *Sender);
        void __fastcall mnGuardarComoClick(TObject *Sender);
        void __fastcall mnSalirClick(TObject *Sender);
        void __fastcall mnCopiarClick(TObject *Sender);
        void __fastcall mnCortarClick(TObject *Sender);
        void __fastcall mnPegarClick(TObject *Sender);
        void __fastcall mnBorrarClick(TObject *Sender);
        void __fastcall mnEjecutarClick(TObject *Sender);
        void __fastcall mnEjecucionX3DClick(TObject *Sender);
        void __fastcall mnEjecucionH3DClick(TObject *Sender);
        void __fastcall mnInsertarComentarioClick(TObject *Sender);
        void __fastcall mnInsertarUSEClick(TObject *Sender);
        void __fastcall mnInsertarRutadoClick(TObject *Sender);
        void __fastcall mnInsertarNodoClick(TObject *Sender);
        void __fastcall mnNodosX3DClick(TObject *Sender);
        void __fastcall mnNodosH3DClick(TObject *Sender);
        void __fastcall mnTiposX3DClick(TObject *Sender);
        void __fastcall mnTiposH3DClick(TObject *Sender);
        void __fastcall mnPaginaX3DClick(TObject *Sender);
        void __fastcall mnPaginaH3DClick(TObject *Sender);
        void __fastcall mnDTEUMAClick(TObject *Sender);
        void __fastcall mnVinculosRutadoClick(TObject *Sender);
        void __fastcall mnCamposX3DClick(TObject *Sender);
        void __fastcall mnCamposH3DClick(TObject *Sender);
        void __fastcall mnLastFichero1Click(TObject *Sender);
        void __fastcall mnLastFichero2Click(TObject *Sender);
        void __fastcall mnLastFichero3Click(TObject *Sender);
        void __fastcall mnLastFichero4Click(TObject *Sender);
        void __fastcall mnEdicionBuscarSiguienteClick(TObject *Sender);
        void __fastcall mnBuscarClick(TObject *Sender);
        void __fastcall mnUtilidadesExpandirNodoClick(TObject *Sender);
        void __fastcall mnUtilidadesOcultarHijosClick(TObject *Sender);
        void __fastcall mnEscenaEditarCodigoClick(TObject *Sender);
        void __fastcall mnUtilidadesConfiguracionClick(TObject *Sender);
        void __fastcall sbDetallesNodosClick(TObject *Sender);
        void __fastcall sbTiposClick(TObject *Sender);
        void __fastcall mnUtilidadesPosicionaClick(TObject *Sender);
        void __fastcall mnVerHerramientasOcultarClick(TObject *Sender);
        void __fastcall mnUtilidadesEditaDatosClick(TObject *Sender);
        void __fastcall mnAbrirEscenaClick(TObject *Sender);
        void __fastcall mnVerConsolaH3DClick(TObject *Sender);
        void __fastcall mnUtilidadesAsignarTransformClick(TObject *Sender);
        void __fastcall mnUtilidadesGaleriasSonidosClick(TObject *Sender);
        void __fastcall mnUtilidadesGaleriasTexturasClick(TObject *Sender);
        void __fastcall mnUtilidadesGaleriasObjetosClick(
          TObject *Sender);
        void __fastcall mnAyudaAcercaClick(TObject *Sender);
        void __fastcall mnUtilidadesConversionClick(TObject *Sender);
        void __fastcall mnVerHerramientasVentanaClick(TObject *Sender);
        void __fastcall mnVerHerramientasBarraClick(TObject *Sender);
        void __fastcall mnUtilidadesAsignarRGBClick(TObject *Sender);
        void __fastcall mnUtilidadesAsignarSFVec3fClick(TObject *Sender);
        void __fastcall FormShortCut(TWMKey &Msg, bool &Handled);
        void __fastcall mnAyudaAyudaClick(TObject *Sender);
        void __fastcall mnUtilidadesRelieveClick(TObject *Sender);
        void __fastcall mnAyudaEspecificacionVRMLClick(TObject *Sender);
        void __fastcall mnAyudaVisoresClick(TObject *Sender);
        void __fastcall mnDisRealClick(TObject *Sender);
        void __fastcall mnSenseGraphicsClick(TObject *Sender);
        void __fastcall mnWeb3DClick(TObject *Sender);
        void __fastcall mnH3DUpdatesClick(TObject *Sender);
private:	// User declarations

    // Asigna las propiedades Caption de los 4 ltimos fichero abiertos con los
    // valores actuales de las variables CONF.LAST_FILE?
    void __fastcall ActualizarUltimosFicherosAbiertos();


    // Esta funcin comprueba los 4 videos de la ventana frmSobre para que nadie
    // pueda cambiar el fichero AVI del programa por otro de igual duracin
    // y tamao.
    bool __fastcall CompruebaVideos();

    // Esta funcin comprueba el video asociado a file. Suma todos los bytes que nadie
    // contiene el fichero y si coincide con el valor suma devuelve true. En
    // otro caso FALSE. Si el fichero no existe devuelve false.
    bool __fastcall VideoOK(AnsiString file,long unsigned int suma);

public:		// User declarations

     // Contiene la carpeta donde se ejecuta el programa -> Se actualiza cada
     // vez que se ejecuta.
     AnsiString CARPETA_PROGRAMA;

     // Contienen la informacin de todos los nodos que se estn usando:
     // GNH -> Gestor Nodos H3D
     // GNX -> Gestor Nodos X3D
     // Los nodos se cargan en el constructor de la clase.
     GestorNodos *GNH,*GNX;

     // Contiene la informacin de todos los tipos que se estn usando:
     // GTH -> Gestor Tipos H3D
     // GTX -> Gestor Tipos X3D
     // Los tipos se cargan en el constructor de la clase.
     GestorTipos *GTH,*GTX;

     // Para mostrar la ventana de inicio en el constructor de Main es necesario
     // crear dinmicamente una instancia a TfrmInicio, usaremos:
     TfrmInicio *InstanciaAfrmInicio;

     // Para optimizar las operaciones de transferencia de datos hay que usar
     // un buffer de memoria, MS. Se declara en Main y se usa en varias unidades.
     // El uso que se hace de esta variable debe ser local, es decir, que se
     // puede usar en cada funcin como si se hubiese declarado como variable
     // local. As, cuando una funcin utilice MS debe asumir que los datos
     // contenidos en MS no son tiles y se pueden sobrescribir. Y a su vez esto
     // implica que cuando esta funcin acabe no debe dejar datos tiles en MS
     // ya que podrn ser eliminados por otra funcin.
     TMemoryStream *MS_;

     // Es una variable Auxiliar que se usa como buffer temporal. Se usa de
     // modo aislado en cada funcin, del mismo modo que ocurre con MS. 
     TStringList *LineasAux;

     // Contienen el prefijo y el sufijo que hay que aadir a los campos de
     // tipo EXPOSEDFIELD para crear vnculos de rutado.
     AnsiString Sufijo_ExpField;
     AnsiString Prefijo_ExpField;

     // Actualiza la lista de los 4 ultimos ficheros abiertos. Recibe una cadena
     // que tiene como primer caracter una letra V para indicar que la escena
     // es VRML o una R para indicar que la escena es H3D. El resto de
     // caracteres de la cadena son la ruta del fichero VRML/H3D.
     void __fastcall Actualiza_LAST_FILES(AnsiString fichero);

     // Actualiza el contenido de la barra de estado del programa.
     void __fastcall ActualizaBarraEstado();

     // Actualiza la apariencia de las ventanas teniendo en cuenta el contenido
     // de CONF.VER_HERRAMIENTAS_COMO.
     void __fastcall ActualizaPosHerramientas();

     // Es necesario informar a Main cuando se hayan creado en memoria todas
     // las ventanas para ocultar frmInicio y ver si se ha pasado algn parmetro.
     void __fastcall CreacionFormsAcabada();

     // Libera el foco de todas las ventanas hijas y de la ventana principal.
     void __fastcall LiberarFoco();

     // Carga el contenido de la escena actual en el editor. Cuando numLinea es
     // -1, se cargar el cdigo en frmEscena->Texto conservando la posicin del
     // cursor de frmEscena->Codigo. En otro caso, en todos los fichero que
     // contenga el editor se seleccionar la lnea indicada por numLinea. Esto
     // es muy til para abrir una editar los errores de la escena cuando se
     // conoce la lnea en la que est el error. 
     void __fastcall EditaEscenaActual(int numLinea=-1);

     // Esta funcin se ejecutar cuando se produzca una excepcin que no se
     // controla desde el cdigo. En FormOnCreate se asigna Application->OnException
     // a esta funcin:
     void __fastcall CapturaExcepcion(TObject *Sender, Exception *E);

     // Inicia el manual de ayuda. Tiene en cuenta cual es la ventana activa
     // para mostrar la seccin de la ayuda adecuada.
     void __fastcall Ayuda();

     // Asocia con el programa la extensin EXTENSION_X3D en windows.
     void __fastcall AsociarExtensionAlPrograma();

     // En la primera ejecucin del programa hay que comprobar si los visores
     // existen y si no es as avisar que se pueden configurar.
     // Tambin hay que asignar los 4 Ficheros ms recientes a los ejemplos:
     void __fastcall PrimeraEjecucion();

     // Esta funcin busca en la carpeta <carpeta> los archivos y carpetas y
     // los aade a items. Nota items es borrado en esta funcin.
     // Si itemstype es:
     //   0 -> devuelve archivos y carpetas
     //   1 -> solo devuelve carpetas
     //   2 -> solo devuelve archivos.
     void __fastcall GetDiskItems(TStrings *items,AnsiString carpeta,int itemstype,AnsiString extension);
     
     // Aade la informacin del fichero file a config. File ser un fichero
     // de texto que contiene informacin sobre el nodo (que debe ser el nombre
     // del fichero. Ejemplo:
     // NodeName: Arc2D
     //
     // FieldName: startAngle
     // access type: inputOutput
     // field type: SFFloat
     // Default value: 0
     //
     // FieldName: radius
     // access type: inputOutput
     // field type: SFFloat
     // Default value: 1
     void __fastcall AddNodeInf(TStringList *config,AnsiString file);

     // Busca clave en lines incrementando el indice de lnea y devuelve lo que
     // aparece a la derecha de clave.
     AnsiString __fastcall GetValue(TStringList *lines,int &lineIndex,AnsiString clave);
     
     __fastcall TMain(TComponent* Owner);
     __fastcall ~TMain();
};

//---------------------------------------------------------------------------
extern PACKAGE TMain *Main;
//---------------------------------------------------------------------------
#endif
