//
//     CLASE   MAIN        
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta es la clase de la ventana principal del programa.
*/

#include <vcl.h>
#pragma hdrstop

#include <process.h>
#include <FileCtrl.hpp>
#include "Main_.h"
#include "frmIndiceNodos_.h"
#include "frmDetallesNodo_.h"
#include "frmUtilidad_.h"
#include "frmEditor_.h"
#include "frmTipos_.h"
#include "frmRutado_.h"
#include "frmEscena_.h"
#include "frmEditorNodos_.h"
#include "frmTools_.h"
#include "frmConfiguracion_.h"
#include "frmConsola_.h"
#include "Configuracion_.h"
#include "GestorVRML_.h"
#include "RichEditVRML_.h"
#include "frmGaleria_.h"
#include "frmEdicionCampos_.h"
#include "frmSobre_.h"
#include "frmVs_.h"
#include "frmRelieve_.h"
#include <registry.hpp>
#include <vcl\Clipbrd.hpp>
#include "Utilidad_.h"
//-------------------------------------------------------- CONSTANTES --------

// Son el ancho mnimo y la altura mnima que tendr la ventana principal del
// programa.
#define MIN_WIDTH 697
#define MIN_HEIGHT 541

// A continuacin se definen las constantes creadas por el editor de ayuda para
// asociar cada ventana con su correspondiente seccin del manual de ayuda:
#define HELP_CONTEXT_Indice                    9999
#define HELP_CONTEXT_frmSobre                     1
#define HELP_CONTEXT_frmEditorNodos               4
#define HELP_CONTEXT_frmEscena                    5
#define HELP_CONTEXT_frmTools                     6
#define HELP_CONTEXT_frmIndiceNodos              14
#define HELP_CONTEXT_frmUtilidadRutado           16
#define HELP_CONTEXT_frmUtilidadUSE              17
#define HELP_CONTEXT_frmUtilidadComentario       18
#define HELP_CONTEXT_frmUtilidadBusqueda         19
#define HELP_CONTEXT_frmTipos                    25
#define HELP_CONTEXT_frmDetallesNodo             26
#define HELP_CONTEXT_frmRutado                   28
#define HELP_CONTEXT_frmGaleria                  29
#define HELP_CONTEXT_frmGaleriaObjetos           30
#define HELP_CONTEXT_frmGaleriaSonidos           31
#define HELP_CONTEXT_frmGaleriaTexturas          32
#define HELP_CONTEXT_frmEditor                   33
#define HELP_CONTEXT_frmConsola                  45
#define HELP_CONTEXT_frmRelieve                  47
#define HELP_CONTEXT_frmVs                       51
#define HELP_CONTEXT_frmUtilidadErrores          53
#define HELP_CONTEXT_frmUtilidadAperturaGenerica 54
#define HELP_CONTEXT_VisoresVRML                 56
#define HELP_CONTEXT_frmConfiguracionFuente      57
#define HELP_CONTEXT_frmConfiguracionTipos       58
#define HELP_CONTEXT_frmConfiguracionNodos       59
#define HELP_CONTEXT_frmConfiguracionAutoTexto   60
#define HELP_CONTEXT_frmConfiguracionGeneral     61

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "LibXmlComps"
#pragma link "LibXmlParser"
#pragma resource "*.dfm"
TMain *Main;
//---------------------------------------------------------------------------
__fastcall TMain::TMain(TComponent* Owner)
        : TForm(Owner)
{
    CARPETA_PROGRAMA = ExtractFileDir(ParamStr(0));

    // La primera clase que se crea es Main. As el cdigo del programa que se
    // ejecuta en primer lugar es el del constructor de Main. Lo primero que
    // debemos hacer es mostrar la ventana de de inicio. Para hacerlo debemos
    // crear una instancia a la clase.
    InstanciaAfrmInicio = NULL;
    try{
       InstanciaAfrmInicio = new TfrmInicio(Main);
    }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

    InstanciaAfrmInicio->Show();
    InstanciaAfrmInicio->Repaint();

    // Llamamos a la funcin que comprueba los videos:
    if(!CompruebaVideos()){
       Utilidad.MsgInfo("An error was found in setting's files.","Advertencia");
       exit(EXIT_SUCCESS);
    }

    // Una vez que se muestra la pantalla de inicio aadimos un pequeo retardo.
    Sleep(RETARDO_frmInicio);

    try{
       GNH=new GestorNodos();
       GTH=new GestorTipos();

       GNX=new GestorNodos();
       GTX=new GestorTipos();

       LineasAux=new TStringList();
    }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }


    GTH->CargarFichConf( CARPETA_PROGRAMA +
                         "\\" + CONF.CARPETA_CONFIGURACION +
                         "\\" + CONF.FICHERO_CONFIG_TIPOS_H3D, ESCENA_H3D);

    GNH->CargarFichConf( CARPETA_PROGRAMA +
                         "\\" + CONF.CARPETA_CONFIGURACION +
                         "\\" + CONF.FICHERO_CONFIG_NODOS_H3D, ESCENA_H3D,GTH);

    GTX->CargarFichConf( CARPETA_PROGRAMA +
                         "\\" + CONF.CARPETA_CONFIGURACION +
                         "\\" + CONF.FICHERO_CONFIG_TIPOS_X3D,    ESCENA_X3D);

    GNX->CargarFichConf( CARPETA_PROGRAMA +
                         "\\" + CONF.CARPETA_CONFIGURACION +
                         "\\" + CONF.FICHERO_CONFIG_NODOS_X3D,    ESCENA_X3D,GTX);

}
//---------------------------------------------------------------------------
__fastcall TMain::~TMain(){
    delete GNH;
    delete GTH;
    delete GNX;
    delete GTX;
    delete LineasAux;
    if(InstanciaAfrmInicio != NULL)
       delete InstanciaAfrmInicio;
}

//---------------------------------------------------------------------------
void __fastcall TMain::sbTipoNodosClick(TObject *Sender)
{
   if((frmEscena != NULL) && (frmEscena->Raiz != NULL)){
      if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_X3D )
          frmIndiceNodos->IniciaVerNodos(GNX);
      else if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D)
          frmIndiceNodos->IniciaVerNodos(GNH);
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::FormCanResize(TObject *Sender, int &NewWidth,
      int &NewHeight, bool &Resize)
{
  Resize = true;
  NewHeight = (NewHeight >= MIN_HEIGHT) ? NewHeight : MIN_HEIGHT;
  NewWidth  = (NewWidth  >= MIN_WIDTH)  ? NewWidth  : MIN_WIDTH;
}
//---------------------------------------------------------------------------
void __fastcall TMain::FormResize(TObject *Sender)
{
   // Antes de Ejecutar las funciones Posiciona hay que asegurarse de que las
   // ventanas estn en memoria. (Hay que hacerlo as y no con la comparacin
   // del puntero de la ventana con NULL porque haba problemas cuando la clase
   // se destruye).
   if(0 != Application->FindComponent("frmEditorNodos")){
      frmTools->Posiciona();
      frmEditorNodos->Posiciona();
      frmEscena->Posiciona();
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::Ejecutar1Click(TObject *Sender)
{
   frmEscena->Ejecutar();
}
//---------------------------------------------------------------------------
void __fastcall TMain::FormCreate(TObject *Sender)
{
    Caption= (AnsiString) ETSIT_UMA + "     " + NOMBRE_DEL_PROGRAMA;
    ActualizarUltimosFicherosAbiertos();
    BarraEstadoEstadistica->Caption="";
    BarraEstadoLineas->Caption="";
    BarraEstadoEscena->Caption="";
    Sufijo_ExpField=CONF.SUFIJO_EXPOXEDFIELD_AS_EVENTOUT;
    Prefijo_ExpField=CONF.PREFIJO_EXPOXEDFIELD_AS_EVENTIN;

    mnAyudaAcerca->Caption = (AnsiString)"&About " + (AnsiString)NOMBRE_DEL_PROGRAMA;


    // Vamos a comprobar que la resolucin es mayor o igual que 800 x 600. Para
    // resoluciones menores el programa no funcionara bien.
    if( (Screen->Height < 600) || (Screen->Width < 800) ){
       Utilidad.MsgInfo("The video mode must be 800x600 or greater.","Advertencia");
       exit(EXIT_SUCCESS);
    }

    pnlTools->Visible=(CONF.VER_HERRAMIENTAS_COMO == "BARRA");

    // Asignamos ShorCuts para los 4 ficheros ms recientes:
    mnLastFichero1->ShortCut = ShortCut(Word('1'), TShiftState() << ssAlt);
    mnLastFichero2->ShortCut = ShortCut(Word('2'), TShiftState() << ssAlt);
    mnLastFichero3->ShortCut = ShortCut(Word('3'), TShiftState() << ssAlt);
    mnLastFichero4->ShortCut = ShortCut(Word('4'), TShiftState() << ssAlt);

    dlgAbrir->Filter = (AnsiString)"VRML 2.0 utf8|*"+ EXTENSION_X3D +"|All files|*.*";

    // Especificamos el fichero de ayuda.
    Application->HelpFile = CARPETA_PROGRAMA +"\\"+ FICHERO_DE_AYUDA;

    // Evitamos que cuando se produzca una excepcin aparezca el mensaje por defecto:
    Application->OnException = CapturaExcepcion;
}
//---------------------------------------------------------------------------
void __fastcall TMain::FormClose(TObject *Sender, TCloseAction &Action)
{
   if(!frmEscena->PreguntarSalvar())
       // En este caso se ha pulsado cancelar.
       Action=caNone;

   else{
      // En este caso el usuario decide seguir con el proceso de salida (el
      // fichero ha podido o no salvarse).
      if(frmEditor->HayFicherosSinSalvar()){
         Utilidad.MsgInfo("The editor contains files which have not been saved.");
         if(!frmEditor->PreguntarSalvar())
             Action=caNone;
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnNuevaEscenaX3DClick(TObject *Sender)
{
   if( frmEscena->PreguntarSalvar() )
      frmEscena->IniciaEscena(GNX,GTX);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnNuevaEscenaH3DClick(TObject *Sender)
{
    if( frmEscena->PreguntarSalvar() )
       frmEscena->IniciaEscena(GNH,GTH);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnAbrirEscenaClick(TObject *Sender)
{
    frmEscena->AbrirEscena(0);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnAbrirEscenaX3DClick(TObject *Sender)
{
   frmEscena->AbrirEscena(1);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnAbrirEscenaH3DClick(TObject *Sender)
{
   frmEscena->AbrirEscena(2);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnGuardarClick(TObject *Sender)
{
   frmEscena->SalvarEscena();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnGuardarComoClick(TObject *Sender)
{
   frmEscena->SalvarEscenaComo();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnSalirClick(TObject *Sender)
{
   if( frmEscena->PreguntarSalvar() )
      exit(EXIT_SUCCESS);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnCopiarClick(TObject *Sender)
{
   // Vamos a implementar la opcin "Copiar": Notar que es muy genrico y que
   // podemos copiar, texto seleccionado del editor de nodos, o de
   // frmEscena->Codigo o un nodo de frmEscena->TreeView. As:
   if( (this->ActiveMDIChild == frmEscena) || (this->ActiveMDIChild == frmTools) ){
      if( (frmEscena->TreeView->Selected != NULL) &&
          (frmEscena->Carpetas->ActivePageIndex == 0) ){

          frmEscena->Copiar((NodoArbol *)frmEscena->TreeView->Selected->Data);

      }else if(frmEscena->Codigo->SelText != ""){
         Clipboard()->SetTextBuf(frmEscena->Codigo->SelText.c_str());
      }
   }else if(this->ActiveMDIChild == frmEditorNodos){
      frmEditorNodos->Copiar();
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnCortarClick(TObject *Sender)
{
   if( (this->ActiveMDIChild == frmEscena) || (this->ActiveMDIChild == frmTools) ){
      if( (frmEscena->TreeView->Selected != NULL) &&
          (frmEscena->Carpetas->ActivePageIndex == 0) ){

          frmEscena->Cortar((NodoArbol *)frmEscena->TreeView->Selected->Data);

      }else if(frmEscena->Codigo->SelText != ""){
         // Realmente no podemos cortar el texto -> Lo copiamos:
         Clipboard()->SetTextBuf(frmEscena->Codigo->SelText.c_str());
      }

   }else if(this->ActiveMDIChild == frmEditorNodos){
      frmEditorNodos->Cortar();
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnPegarClick(TObject *Sender)
{
   if( (this->ActiveMDIChild == frmEscena) || (this->ActiveMDIChild == frmTools) ){
      frmEscena->Pegar();
   }else if(this->ActiveMDIChild == frmEditorNodos){
      frmEditorNodos->Pegar();
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnBorrarClick(TObject *Sender)
{
   if(frmEscena->TreeView->Selected != NULL)
       frmEscena->BorrarNodo((NodoArbol *)frmEscena->TreeView->Selected->Data);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnEjecutarClick(TObject *Sender)
{
   frmEscena->Ejecutar();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnEjecucionX3DClick(TObject *Sender)
{
   frmEscena->Ejecutar(1);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnEjecucionH3DClick(TObject *Sender)
{
   frmEscena->Ejecutar(2);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnInsertarComentarioClick(TObject *Sender)
{
    if(frmEscena->TreeView->Selected == NULL){
       Utilidad.MsgInfo("To add a comment, you must select a node.");
       return;
    }
    AnsiString texto="";
    // Llamamos a la funcin que leer el comentario.
    if( frmUtilidad->IniciaComentario(texto) ){
        // Aadimos el comentario a la escena actual.
        frmEscena->AnadirComentario( (NodoArbol*)frmEscena->TreeView->Selected->Data,texto);
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnInsertarUSEClick(TObject *Sender)
{
   AnsiString texto,nombreTipoNodo;
   if(frmUtilidad->IniciaUSE(texto,nombreTipoNodo))
   {
       if(frmEscena->TreeView->Selected == NULL)
          frmEscena->AnadirUSE(NULL,texto,nombreTipoNodo);  // Se aadir a la raiz.
       else
          frmEscena->AnadirUSE((NodoArbol *)frmEscena->TreeView->Selected->Data,texto,nombreTipoNodo);  // Se aadir a la raiz.
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnInsertarRutadoClick(TObject *Sender)
{
   // Creamos un nuevo vinculo de rutado.
   AnsiString nodoOut,campoOut,nodoIn,campoIn;

   if( frmUtilidad->IniciaRutado(nodoOut,campoOut,nodoIn,campoIn) ){
       // En este caso se ha devuelto true -> Hay que crear un vnculo de rutado nuevo.
       NodoArbol *padre;
       // Si el elemento actualmente seleccionado es un nodo lo aadimos en
       // ese nodo en otro caso lo aadimos en la raiz:
       if( (frmEscena->TreeView->Selected == NULL) || ( ((NodoArbol *)frmEscena->TreeView->Selected->Data)->EsNodo()) )
           padre = (NodoArbol *)frmEscena->TreeView->Selected->Data;
       else
           padre = frmEscena->Raiz;

       frmEscena->AnadirVinculoRutado(padre,nodoOut,campoOut,nodoIn,campoIn);
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnInsertarNodoClick(TObject *Sender)
{
    // Iniciamos frmIndiceNodos para que nos devuelva un nodo que aadimos a la
    // escena y que cargamos en el editor de nodos.
    bool enTransform=true;
    AnsiString nodo = frmIndiceNodos->IniciaElegirNodo(frmEscena->GN,enTransform);
    if(nodo != ""){
       NodoArbol *nuevoNodo;
       if(!enTransform)
          nuevoNodo = frmEscena->AnadirNodo(nodo);
       else
          nuevoNodo = frmEscena->AnadirNodoEnTransform(nodo);
       frmEditorNodos->Carga(nuevoNodo);
       frmEscena->TreeView->Selected = nuevoNodo->nodoAsociado;
       frmEscena->Actualiza();
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnNodosX3DClick(TObject *Sender)
{
   frmIndiceNodos->IniciaVerNodos(GNX);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnNodosH3DClick(TObject *Sender)
{
   frmIndiceNodos->IniciaVerNodos(GNH);
}
//---------------------------------------------------------------------------

void __fastcall TMain::mnTiposX3DClick(TObject *Sender)
{
   frmTipos->Inicia(GTX);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnTiposH3DClick(TObject *Sender)
{
    frmTipos->Inicia(GTH);        
}
//---------------------------------------------------------------------------

void __fastcall TMain::mnPaginaX3DClick(TObject *Sender)
{
   ShellExecute(this->Handle,"open", "http://www.web3d.org/x3d/specifications/ISO-IEC-19775-X3DAbstractSpecification/",NULL,NULL, SW_SHOWMAXIMIZED);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnPaginaH3DClick(TObject *Sender)
{
   ShellExecute(this->Handle,"open", "http://www.h3d.org/",NULL,NULL, SW_SHOWMAXIMIZED);
}
//---------------------------------------------------------------------------

void __fastcall TMain::mnDTEUMAClick(TObject *Sender)
{
   ShellExecute(this->Handle,"open", CONF.URL_DTE.c_str(),NULL,NULL, SW_SHOWMAXIMIZED);        
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnVinculosRutadoClick(TObject *Sender)
{
   frmRutado->Inicia(frmEscena->GT);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnCamposX3DClick(TObject *Sender)
{
   frmDetallesNodo->Inicia(GNX,GTX,0);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnCamposH3DClick(TObject *Sender)
{
   frmDetallesNodo->Inicia(GNH,GTH,0);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnLastFichero1Click(TObject *Sender)
{
   if(CONF.LAST_FILE1.Length() < 2)
      return;

   // En el evento OnExit de algunos controles como frmEscena->edNombreNodo
   // se pueden dar mensajes -> Y deben darse antes de cargar la nueva escena,
   // por eso pasamos el foco a Main.
   SetFocus();

   if(!frmEscena->PreguntarSalvar())
     return;

   AnsiString fichero = CONF.LAST_FILE1.SubString(2,CONF.LAST_FILE1.Length()-1);

   if(CONF.LAST_FILE1[1] == 'V')
      frmEscena->IniciaEscena(fichero, ESCENA_X3D);
   if(CONF.LAST_FILE1[1] == 'R')
      frmEscena->IniciaEscena(fichero, ESCENA_H3D);
   // Actualiza_LAST_FILES(CONF.LAST_FILE1); -> No es necesario por ser el primero.
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnLastFichero2Click(TObject *Sender)
{
   if(CONF.LAST_FILE2.Length() < 2)
      return;
   // En el evento OnExit de algunos controles como frmEscena->edNombreNodo
   // se pueden dar mensajes -> Y deben darse antes de cargar la nueva escena,
   // por eso pasamos el foco a Main.
   SetFocus();
   if(!frmEscena->PreguntarSalvar())
     return;

   AnsiString fichero = CONF.LAST_FILE2.SubString(2,CONF.LAST_FILE2.Length()-1);

   if(CONF.LAST_FILE2[1] == 'V')
      frmEscena->IniciaEscena(fichero, ESCENA_X3D);
   if(CONF.LAST_FILE2[1] == 'R')
      frmEscena->IniciaEscena(fichero, ESCENA_H3D);
   Actualiza_LAST_FILES(CONF.LAST_FILE2);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnLastFichero3Click(TObject *Sender)
{
   if(CONF.LAST_FILE3.Length() < 2)
      return;
   // En el evento OnExit de algunos controles como frmEscena->edNombreNodo
   // se pueden dar mensajes -> Y deben darse antes de cargar la nueva escena,
   // por eso pasamos el foco a Main.
   SetFocus();
   if(!frmEscena->PreguntarSalvar())
     return;

   AnsiString fichero = CONF.LAST_FILE3.SubString(2,CONF.LAST_FILE3.Length()-1);

   if(CONF.LAST_FILE3[1] == 'V')
      frmEscena->IniciaEscena(fichero, ESCENA_X3D);
   if(CONF.LAST_FILE3[1] == 'R')
      frmEscena->IniciaEscena(fichero, ESCENA_H3D);
   Actualiza_LAST_FILES(CONF.LAST_FILE3);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnLastFichero4Click(TObject *Sender)
{
   if(CONF.LAST_FILE4.Length() < 2)
      return;
   // En el evento OnExit de algunos controles como frmEscena->edNombreNodo
   // se pueden dar mensajes -> Y deben darse antes de cargar la nueva escena,
   // por eso pasamos el foco a Main.
   SetFocus();
   if(!frmEscena->PreguntarSalvar())
     return;

   AnsiString fichero = CONF.LAST_FILE4.SubString(2,CONF.LAST_FILE4.Length()-1);

   if(CONF.LAST_FILE4[1] == 'V')
      frmEscena->IniciaEscena(fichero, ESCENA_X3D);
   if(CONF.LAST_FILE4[1] == 'R')
      frmEscena->IniciaEscena(fichero, ESCENA_H3D);
   Actualiza_LAST_FILES(CONF.LAST_FILE4);
}
//---------------------------------------------------------------------------
void __fastcall TMain::Actualiza_LAST_FILES(AnsiString fichero){

   AnsiString tmp;
   if(fichero == CONF.LAST_FILE1){
       // En este caso no hay que hacer nada.
   }else if(fichero == CONF.LAST_FILE2){
       tmp=CONF.LAST_FILE1;
       CONF.LAST_FILE1 = CONF.LAST_FILE2;
       CONF.LAST_FILE2 = tmp;
   }else if(fichero == CONF.LAST_FILE3){
       tmp=CONF.LAST_FILE1;
       CONF.LAST_FILE1 = CONF.LAST_FILE3;
       CONF.LAST_FILE3= CONF.LAST_FILE2;
       CONF.LAST_FILE2 = tmp;
   }else if(fichero == CONF.LAST_FILE4){
       tmp=CONF.LAST_FILE1;
       CONF.LAST_FILE1 = CONF.LAST_FILE4;
       CONF.LAST_FILE4= CONF.LAST_FILE3;
       CONF.LAST_FILE3= CONF.LAST_FILE2;
       CONF.LAST_FILE2 = tmp;
   }else{
       // En este caso el fichero que se carga no aparece entre los 4 ficheros
       // ms recientes As que desplazamos toda la lista hacia abajo una posicin.
       CONF.LAST_FILE4= CONF.LAST_FILE3;
       CONF.LAST_FILE3= CONF.LAST_FILE2;
       CONF.LAST_FILE2= CONF.LAST_FILE1;
       CONF.LAST_FILE1= fichero;
   }
   CONF.LosDatosHanCambiado();
   // Ahora actualizamos el texto del men:
   ActualizarUltimosFicherosAbiertos();
}
//---------------------------------------------------------------------------
void __fastcall TMain::ActualizarUltimosFicherosAbiertos(){
    //                          Texto del primer TMenuItem
    AnsiString fichero;
    // Quitamos el primer caracter de cada fichero.
    if(CONF.LAST_FILE1.Length() > 2){
       fichero = CONF.LAST_FILE1.SubString(2,CONF.LAST_FILE1.Length()-1);
       fichero = fichero + ((CONF.LAST_FILE1[1] == 'V') ? " (X3D)" : " (H3D)");
       mnLastFichero1->Caption= (AnsiString) "&1 " + ExtractFileName(fichero);
       mnLastFichero1->Visible=true;
    }else{
       mnLastFichero1->Caption="";
       mnLastFichero1->Visible=false;
    }
    //                          Texto del segundo TMenuItem
    if(CONF.LAST_FILE2.Length() > 2){
       fichero = CONF.LAST_FILE2.SubString(2,CONF.LAST_FILE2.Length()-1);
       fichero = fichero + ( (CONF.LAST_FILE2[1] == 'V') ? " (X3D)" : " (H3D)" );
       mnLastFichero2->Caption= (AnsiString) "&2 " + ExtractFileName(fichero);
       mnLastFichero2->Visible=true;
    }else{
       mnLastFichero2->Caption="";
       mnLastFichero2->Visible=false;
    }
    //                          Texto del Tercer TMenuItem
    if(CONF.LAST_FILE3.Length() > 2){
       fichero = CONF.LAST_FILE3.SubString(2,CONF.LAST_FILE3.Length()-1);
       fichero = fichero + ( (CONF.LAST_FILE3[1] == 'V') ? " (X3D)" : " (H3D)" );
       mnLastFichero3->Caption= (AnsiString) "&3 " + ExtractFileName(fichero);
       mnLastFichero3->Visible=true;
    }else{
       mnLastFichero3->Caption="";
       mnLastFichero3->Visible=false;
    }
    //                          Texto del cuarto TMenuItem
    if(CONF.LAST_FILE4.Length() > 2){
       fichero = CONF.LAST_FILE4.SubString(2,CONF.LAST_FILE4.Length()-1);
       fichero = fichero + ( (CONF.LAST_FILE4[1] == 'V') ? " (X3D)" : " (H3D)");
       mnLastFichero4->Caption= (AnsiString) "&4 " + ExtractFileName(fichero);
       mnLastFichero4->Visible=true;
    }else{
       mnLastFichero4->Caption="";
       mnLastFichero4->Visible=false;
    }
    mnArchivoBarra1->Visible = mnLastFichero1->Visible || mnLastFichero2->Visible ||
                               mnLastFichero3->Visible || mnLastFichero4->Visible;
}
//---------------------------------------------------------------------------
void __fastcall TMain::ActualizaBarraEstado(){
   if(frmEscena->Raiz == NULL){
      BarraEstadoEstadistica->Caption="";
      BarraEstadoLineas->Caption="";
      BarraEstadoEscena->Caption="";
      return;
   }
   // Asignamos el tipo de escena.
   if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_X3D )
      BarraEstadoEscena->Caption="X3D Scene";
   else if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D )
      BarraEstadoEscena->Caption="H3D Scene";
   // Asignamos el nmero de lneas.
   int linea= frmEscena->Codigo->CaretPos.y+1;
   int numLineas= ReVRML.LinesCount(frmEscena->Codigo);

   BarraEstadoLineas->Caption= (AnsiString) "Line " + IntToStr(linea) + " of " + IntToStr(numLineas);
      
   // Asignamos el nmero de elementos.
   BarraEstadoEstadistica->Caption=frmEscena->Estadistica;

   pnlModificada->Caption= frmEscena->EscenaModificada() ? "Modified" : "";
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnEdicionBuscarSiguienteClick(TObject *Sender)
{
   if( (frmEscena->BusquedaTipoElemento == 0) && (frmEscena->BusquedaCadena == "") )
      mnBuscarClick(NULL);
   else
      frmEscena->Busca();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnBuscarClick(TObject *Sender)
{
    if(frmUtilidad->IniciaBusquedaArbol(frmEscena->BusquedaCadena,frmEscena->BusquedaTipoElemento,frmEscena->BusquedaDistinguir) ){
        frmEscena->IniciaBusqueda(frmEscena->BusquedaCadena,frmEscena->BusquedaTipoElemento,frmEscena->BusquedaDistinguir);
        frmEscena->Busca();
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesExpandirNodoClick(TObject *Sender)
{
   frmEscena->ExpandirNodoActual();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesOcultarHijosClick(TObject *Sender)
{
   frmEscena->ComprimirNodoActual();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnEscenaEditarCodigoClick(TObject *Sender)
{
   EditaEscenaActual();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesConfiguracionClick(TObject *Sender)
{
    if(frmConfiguracion->Inicia(0)){
       // Actualizamos la apariencia de los elementos afectados por el cambio.
       ActualizaPosHerramientas();
       ReVRML.Inicia(frmEscena,frmEscena->Codigo,2);
       if(frmEscena->Carpetas->ActivePageIndex == 1)
          frmEscena->ActualizaCodigo();
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::sbDetallesNodosClick(TObject *Sender)
{
   if((frmEscena != NULL) && (frmEscena->Raiz != NULL)){
      if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_X3D )
          frmDetallesNodo->Inicia(GNX,GTX,0);
      else if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D)
          frmDetallesNodo->Inicia(GNH,GTH,0);
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::sbTiposClick(TObject *Sender)
{
   if((frmEscena != NULL) && (frmEscena->Raiz != NULL)){
      if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_X3D )
          frmTipos->Inicia(GTX);
      else if( frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D)
          frmTipos->Inicia(GTH);
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesPosicionaClick(TObject *Sender)
{
   frmEditorNodos->Posiciona();
   frmTools->Posiciona();
   frmEscena->Posiciona();
}
//---------------------------------------------------------------------------
void __fastcall TMain::LiberarFoco(){

    for(int i = MDIChildCount-1; i >= 0; i--){
       if(MDIChildren[i]->ActiveControl != NULL)
          MDIChildren[i]->DefocusControl(MDIChildren[i]->ActiveControl,true);
    }
    if(ActiveControl != NULL){
       DefocusControl(ActiveControl,false);
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesEditaDatosClick(TObject *Sender)
{
   frmEscena->EditaDatos();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnVerConsolaH3DClick(TObject *Sender)
{
   int linea = frmConsola->MostrarConsola();

   if(linea != -1){
      if(frmEditor->Editando)
         frmEditor->SeleccionarLinea(linea,true);
      else{
         // En este caso hay que editar la escena actual y editar la lnea linea.
         EditaEscenaActual(linea); 
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesAsignarTransformClick(TObject *Sender)
{
   frmEscena->IniciaAsignarTransform();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesGaleriasSonidosClick(TObject *Sender)
{
   AnsiString cad  = frmGaleria->IniciaSonidos();

   if(cad != ""){
      frmEscena->AnadirSonido(cad);
      frmEscena->Actualiza();
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesGaleriasTexturasClick(TObject *Sender)
{
   AnsiString cad  = frmGaleria->IniciaTexturas();

   if(cad != ""){
      frmEscena->AnadirTextura(cad);
      frmEscena->Actualiza();
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesGaleriasObjetosClick(
      TObject *Sender)
{
   AnsiString cad  = frmGaleria->IniciaObjetos();

   if(cad != ""){
      frmEscena->AnadirObjetoVRML(cad);
      frmEscena->Actualiza();
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::CreacionFormsAcabada(){

   // Lo primero es esperar para cerrar frmInicio, pero antes hay que hacer
   // el Repaint de los formularios que hay bajo frmInicio:
   frmEditorNodos->Repaint();
   frmEscena->Repaint();
   frmTools->Repaint();
   Sleep(TIEMPO_TRAS_CREACION_frmInicio);

   // Cerramos frmInicio

   if(InstanciaAfrmInicio != NULL)
      InstanciaAfrmInicio->Close();

   // Ya no necesitaremos frmInicio -> Liberamos memoria:
   if(InstanciaAfrmInicio != NULL){
      delete InstanciaAfrmInicio;
      InstanciaAfrmInicio = NULL;
   }

   this->Repaint();

    // En la primera ejecucin tras la instalacin del programa tenemos que hacer
    // un procesado especial:
    if(CONF.PRIMERA_EJECUCION)
       PrimeraEjecucion();

   // Comprobamos si se ha pasado algn parmetro:
   if(ParamCount() >= 1){
      frmEscena->AbrirEscena(0,ParamStr(1));
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnAyudaAcercaClick(TObject *Sender)
{
   frmSobre->Inicia();
}
//---------------------------------------------------------------------------
void __fastcall TMain::ActualizaPosHerramientas()
{
   if(CONF.VER_HERRAMIENTAS_COMO == "VENTANA"){
      CONF.VER_HERRAMIENTAS_COMO="VENTANA";
      CONF.LosDatosHanCambiado();
      frmTools->Mostrar();
      mnUtilidadesPosicionaClick(NULL);
      pnlTools->Visible=false;

   }else if(CONF.VER_HERRAMIENTAS_COMO == "BARRA"){
      CONF.VER_HERRAMIENTAS_COMO="BARRA";
      mnUtilidadesPosicionaClick(NULL);
      CONF.LosDatosHanCambiado();
      frmTools->Ocultar();
      pnlTools->Visible=true;

   }else if(CONF.VER_HERRAMIENTAS_COMO == "OCULTA"){
      CONF.VER_HERRAMIENTAS_COMO="OCULTA";
      mnUtilidadesPosicionaClick(NULL);
      CONF.LosDatosHanCambiado();
      frmTools->Ocultar();
      pnlTools->Visible=false;
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnVerHerramientasVentanaClick(TObject *Sender)
{
   CONF.VER_HERRAMIENTAS_COMO = "VENTANA";
   ActualizaPosHerramientas();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnVerHerramientasBarraClick(TObject *Sender)
{
   CONF.VER_HERRAMIENTAS_COMO = "BARRA";
   ActualizaPosHerramientas();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnVerHerramientasOcultarClick(TObject *Sender)
{
   CONF.VER_HERRAMIENTAS_COMO = "OCULTA";
   ActualizaPosHerramientas();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesConversionClick(TObject *Sender)
{
   if(frmEscena->Raiz == NULL)
      return;

   if(frmVs->Inicia()){
      frmEscena->DibujarArbol(frmEscena->Raiz,NULL);
      frmEscena->ActualizaCodigo();
      frmEscena->EscenaModificada(true);
      
      // Tenemos que ver si hay que aadir la primera lnea de los ficheros VRML.
      if(frmEscena->Raiz->AsRaiz()->tipoEscena == ESCENA_H3D){
         // Si el primer hijo de la raiz no es un comentario con la primera
         // lnea de los ficheros VRML habr que aadirla.
         NodoArbol *comentario = frmEscena->Raiz->GetHijo(0);
         bool ok = ((comentario != NULL) &&
                   (comentario->EsComentario()) &&
                   (CONF.PRIMERA_LINEA_FICH_X3D == comentario->AsComentario()->texto));

         if(!ok)
            frmEscena->AnadirComentario(frmEscena->Raiz,CONF.PRIMERA_LINEA_FICH_X3D);
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::EditaEscenaActual(int numLinea){

   if(frmEscena->Raiz == NULL)
      return;

   bool Modificada = frmEscena->EscenaModificada();
   AnsiString fichero = frmEscena->Raiz->AsRaiz()->fichero;
   TPoint posCursor = frmEscena->Codigo->CaretPos;
   posCursor.x++;
   posCursor.y++;

   LineasAux->Clear();
   GVRML.EscribeFichero(frmEscena->Raiz,LineasAux,frmEscena->TreeView->Items->Count);
   // Como las tareas que quedan por hacer dentro de esta funcin pueden tardar
   // cierto tiempo, vamos a actualizar la ventana prinicipal para restaurar la
   // zona que ha ocupado la barra de progreso.
   Main->Repaint();

   if( frmEditor->Inicia(LineasAux,fichero,Modificada,frmEscena->Raiz->AsRaiz()->tipoEscena,posCursor,numLinea) ){
      // En este caso el usuario desea conservar los cambios hechos en el cdigo VRML.
      // As que actualizamos el contenido de la escena.
      // Asignamos los datos:
      AnsiString datos = LineasAux->Text; // -> lo hacemos para evitar el warning: Temporary used form parameter datos in call to ActualizaEscenaDesdeAnsiString.
      frmEscena->ActualizaDesdeAnsiString(datos,fichero,Modificada);
      ReVRML.SetCursorPos(frmEscena->Codigo,posCursor.y+1,posCursor.x+1);
      // El usuario ha podido cambiar la configuracin en el editor.
      ActualizaPosHerramientas();
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesAsignarRGBClick(TObject *Sender)
{
   frmEscena->IniciaAsignarRGB();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesAsignarSFVec3fClick(TObject *Sender)
{
   frmEscena->IniciaAsignarSFVec3f();
}
//---------------------------------------------------------------------------
void __fastcall TMain::CapturaExcepcion(TObject *Sender, Exception *E)
{
  /* Una decisin importante y dficil es qu hacer cuando se produzca una
  excepcin general. Podemos capturarla pero Que hacer con ella? Hay que tener
  en cuenta que lo ms probable es que la excepcin sea un fallo poco grave, por
  ejemplo un acceso a AnsiString con un indice no vlido etc. Prcticamente nunca
  el fallo ser tan grave como para tener que cerrar la aplicacin. El problema
  es que en estas situaciones anmalas no sabemos qu est fallando y no tenemos
  ningn control sobre el proceso. En el peor de los casos se podran perder
  los datos de la escena actual pero creo que esta posibilidad tiene una
  probabilidad tan pequea que no merece la pena cerrar la aplicacin. Esta
  probalidad es pequea por dos motivos, el primero es que la aplicacin se ha
  depurado mucho y tiene pocos fallos (ahora mismo no hay ningn fallo conocido).
  El segundo motivo es que cuando se produzca un fallo la probabilidad de que se
  pierdan datos es mnima (muy muy reducida). Con todo creo que la mejor opcin
  es no cerrar la aplicacin cuando salte una excepcin. Avisaremos de estas
  situaciones con tres Beeps y un cambio en Caption. Adems si se producen tres
  de tres excepciones durante la misma sesin cerraremos la aplicacin: */
  static int c=0;
  c++;

  // En cualquier caso daremos los tres Beeps para que el usuario los asocie
  // con una situacin anmala.
  Caption = NOMBRE_DEL_PROGRAMA;
  for(int s=0;s < 3;s++){
     Beep();
     Sleep(500);
  }
  if(c == 3){
     // Maquillamos un poco el error ;)
     AnsiString msg = (AnsiString) "An error has been detected and the application must be closed." +
                      "It may be caused by errors in the settings files. " +
                      "Some errors are repaired automatically when the program starts. " +
                      "If the problem persists you can install the application again. " +
                      "If this doesn't solve the problem consult your provider.";
     Utilidad.MsgInfo(msg,"Error");

     //Application->ShowException(E);
     // A continuacin, dos formas de acabar el programa. Parece que exit es ms
     // efectiva que Terminate.
     exit(EXIT_FAILURE);
     Application->Terminate();
  }
}
//---------------------------------------------------------------------------
void __fastcall TMain::Ayuda()
{
   if(frmConfiguracion->Active){
      AnsiString tab = frmConfiguracion->GetTabActual();
      if(tab == "Fuente")
         Application->HelpContext(HELP_CONTEXT_frmConfiguracionFuente);
      else if(tab == "Tipos")
         Application->HelpContext(HELP_CONTEXT_frmConfiguracionTipos);
      else if(tab == "Nodos")
         Application->HelpContext(HELP_CONTEXT_frmConfiguracionNodos);
      else if(tab == "AutoTexto")
         Application->HelpContext(HELP_CONTEXT_frmConfiguracionAutoTexto);
      else if(tab == "General")
         Application->HelpContext(HELP_CONTEXT_frmConfiguracionGeneral);
      else
         Application->HelpContext(HELP_CONTEXT_Indice);
   }else if(frmConsola->Active)//--------------------------- frmConsola
      Application->HelpContext(HELP_CONTEXT_frmConsola);
   else if(frmDetallesNodo->Active)//----------------------------- frmDetallesNodo
      Application->HelpContext(HELP_CONTEXT_frmDetallesNodo);
   else if(frmEdicionCampos->Active)//---------------------------- frmEdicionCampos
      Application->HelpContext(HELP_CONTEXT_frmEditorNodos);
   else if(frmRelieve->Active)//---------------------------------- frmRelieve
      Application->HelpContext(HELP_CONTEXT_frmRelieve);
   else if(frmEditor->Active)//----------------------------------- frmEditor
      Application->HelpContext(HELP_CONTEXT_frmEditor);
   else if(frmGaleria->Active){//--------------------------------- frmGaleria
      AnsiString actual = frmGaleria->GetGaleriaActual();
      if(actual == "Objetos")
         Application->HelpContext(HELP_CONTEXT_frmGaleriaObjetos);
      else if(actual == "Sonidos")
         Application->HelpContext(HELP_CONTEXT_frmGaleriaSonidos);
      else if(actual == "Texturas")
         Application->HelpContext(HELP_CONTEXT_frmGaleriaTexturas);
      else
         Application->HelpContext(HELP_CONTEXT_Indice);

   }else if(frmIndiceNodos->Active)//------------------------------ frmIndiceNodos
      Application->HelpContext(HELP_CONTEXT_frmIndiceNodos);
   else if(frmRutado->Active)//------------------------------------ frmRutado
      Application->HelpContext(HELP_CONTEXT_frmRutado);
   else if(frmSobre->Active)//------------------------------------- frmSobre
      Application->HelpContext(HELP_CONTEXT_frmSobre);
   else if(frmTipos->Active)//------------------------------------- frmTipos
      Application->HelpContext(HELP_CONTEXT_frmTipos);
   else if(frmUtilidad->Active){//--------------------------------- frmUtilidad
      if(frmUtilidad->Modo == "Rutado")
         Application->HelpContext(HELP_CONTEXT_frmUtilidadRutado);
      else if(frmUtilidad->Modo == "USE")
         Application->HelpContext(HELP_CONTEXT_frmUtilidadUSE);
      else if(frmUtilidad->Modo == "Comentario")
         Application->HelpContext(HELP_CONTEXT_frmUtilidadComentario);
      else if(frmUtilidad->Modo == "BsquedaArbol")
         Application->HelpContext(HELP_CONTEXT_frmUtilidadBusqueda);
      else if(frmUtilidad->Modo == "Errores")
         Application->HelpContext(HELP_CONTEXT_frmUtilidadErrores);
      else if(frmUtilidad->Modo == "ElegirH3D_X3D")
         Application->HelpContext(HELP_CONTEXT_frmUtilidadAperturaGenerica);
      else
         Application->HelpContext(HELP_CONTEXT_Indice);

   }else if(frmVs->Active)//---------------------------------------- frmVs
      Application->HelpContext(HELP_CONTEXT_frmVs);
   else
      Application->HelpContext(HELP_CONTEXT_Indice);
}
//---------------------------------------------------------------------------
void __fastcall TMain::FormShortCut(TWMKey &Msg, bool &Handled)
{
   if( Msg.CharCode == VK_F1 ){
      Ayuda();
      Handled = true;
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnAyudaAyudaClick(TObject *Sender)
{
   Ayuda();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnUtilidadesRelieveClick(TObject *Sender)
{
   if(frmRelieve->Inicia(LineasAux)){
      if(!frmEscena->Pegar(LineasAux,frmEscena->Raiz))
         Utilidad.MsgInfo("There are errors in the relief VRML code. This can be caused by changes in the nodes and types settings.","Advetencia");
   }
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnAyudaEspecificacionVRMLClick(TObject *Sender)
{
   ShellExecute(this->Handle,"open", URL_ESPECIFICACION_VRML,NULL,NULL, SW_SHOWMAXIMIZED);
}
//---------------------------------------------------------------------------
void __fastcall TMain::PrimeraEjecucion(){

   if(!CONF.PRIMERA_EJECUCION)
      return;

   // En la primera ejecucin del programa tenemos que hacer varias comprobaciones:

   // Lo primero es hacer que no volvamos a entrar aqui:
   CONF.PRIMERA_EJECUCION = false;
   CONF.LosDatosHanCambiado();

   // Asignamos los 4 ejemplos iniciales:
   AnsiString Carpeta = CARPETA_PROGRAMA + "\\" + CARPETA_EJEMPLOS + "\\";

   CONF.LAST_FILE1 = "V" + Carpeta + FICH_EJEMPLO1;
   CONF.LAST_FILE2 = "V" + Carpeta + FICH_EJEMPLO2;
   CONF.LAST_FILE3 = "V" + Carpeta + FICH_EJEMPLO3;
   CONF.LAST_FILE4 = "V" + Carpeta + FICH_EJEMPLO4;

   ActualizarUltimosFicherosAbiertos();

   Utilidad.MsgInfo((AnsiString)"This is the first time you load " + NOMBRE_DEL_PROGRAMA2 +
                     ".\r\n\r\n In the File->Open menu you will find a selection of 3D scenes.");


   // Asociamos la extensin de los ficheros X3D con el programa.
  // AsociarExtensionAlPrograma();

   CONF.LAST_CARPETA_USADA = Carpeta;  

   // Comprobamos si existen los visores configurados por defecto.
   if(!FileExists(CONF.PATH_H3D_LOAD))
      Utilidad.MsgInfo("The H3D viewer has not been found: " + CONF.PATH_H3D_LOAD + " You can use the settings window to specify its path.");
   if(!FileExists(CONF.PATH_EXPLORER))
      Utilidad.MsgInfo("The X3D viewer has not been found: " + CONF.PATH_EXPLORER + " You can use the settings window to specify its path.");
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnAyudaVisoresClick(TObject *Sender)
{
   Application->HelpContext(HELP_CONTEXT_VisoresVRML);
}
//---------------------------------------------------------------------------
void __fastcall TMain::AsociarExtensionAlPrograma(){
   // Creamos una nueva instancia del registro.
   TRegistry* thisReg = new TRegistry();

   // Usamos HKEY_CLASSES_ROOT para asociar la extensin
   thisReg->RootKey = HKEY_CLASSES_ROOT;

   // Creamos una clave para la extensin a registrar.
   thisReg->OpenKey(EXTENSION_X3D, true);

   // Set the default value to the program you want to associate the extension
   // with NB: This can be what ever you want. The name (here FormLoader) is
   // just a link to the next key we are going to create
   thisReg->WriteString("", "FormLoader");

   // Cerramos la clave creada.
   thisReg->CloseKey();

   // Write the default Open command (here we open/create the key with the
   // association name from above)
   thisReg->OpenKey("FormLoader", true);

   // Set the desciption of the file association
   thisReg->WriteString("", NOMBRE_DEL_PROGRAMA2);

   // Create Key "shell" and set "open" as default command (which is actually
   // the FormLoader->shell key ;)
   thisReg->OpenKey("shell", true);
   thisReg->WriteString("", "open");

   // Open the "Open" key (which is actually the FormLoader->shell->open key ;)
   thisReg->OpenKey("open", true);

   // Write the text (which will be shown in the popup menu for the object on the explorer)
   thisReg->WriteString("", "&Open");

   // Create Key "command", which is what is caried out if the user select "Open" --- *
   thisReg->OpenKey("command", true);

   // Write what should be done when "Open" is choosen ParamStr(0) is the name
   // and path to my program %1 is the paramter to my program. This means that
   // my program will be started with the object, on which we have choosen "Open," as parameter.
   thisReg->WriteString("", ParamStr(0)+" \"\%1\"");

   // Close Key
   thisReg->CloseKey();

   // Write Open batch command
   // Here is shown how to create an extra command for your extension.
   // thisReg->OpenKey("FormLoader", true);
   // thisReg->OpenKey("shell", true); thisReg->OpenKey("open batch", true);
   // thisReg->WriteString("", "Open &Batch");
   // thisReg->OpenKey("command", true);
   // thisReg->WriteString("", ParamStr(0)+" -b \"\%1\"");
   // thisReg->CloseKey();

   // Set default icon

   // This is the icon that will be given each object/file that has la extensin
   // que estamos asignando.

   thisReg->OpenKey("FormLoader", true);
   thisReg->OpenKey("DefaultIcon", true);

  // Here is set the icon to the 2 icon resource in my programs exe file.
  // To give the objects/files the same icon as your own program just write
  //thisReg->WriteString("", ParamStr(0)+",0"); instead
  thisReg->WriteString("", ParamStr(0)+",0");

  // Clean up
  delete thisReg;
}

//---------------------------------------------------------------------------
bool __fastcall TMain::CompruebaVideos(){

   // Comprobaremos uno a uno todos los videos que aparecen en frmSobre.

   // No merece la pena usar constantes para las sumas de los bytes que contiene
   // el vdeo porque estos valores solo se usan aqui as que:

   if(!VideoOK(VIDEO_LOGO_PROGRAMA,4249309737))
      return false;

   if(!VideoOK(VIDEO_CUADRO,4286525615))
      return false;

   if(!VideoOK(VIDEO_VRML,14423547))
      return false;

   if(!VideoOK(VIDEO_H3D,4289877368))
      return false;

   return true;
}
//---------------------------------------------------------------------------
bool __fastcall TMain::VideoOK(AnsiString file,long unsigned int suma){

   file = CARPETA_PROGRAMA + "\\" + CONF.CARPETA_CONFIGURACION +
                             "\\" + file;
   if(!FileExists(file))
      return false;
   Fichero f;
   if(!f.Abrir(file.c_str()))
      return false;

   long unsigned int sumaLocal = 0;
   for(int c=0; c < f.tamano; c++){
      sumaLocal+= (int) f.LeeCaracter();
   }
   f.CerrarFichero();

   return suma == sumaLocal;
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnDisRealClick(TObject *Sender)
{
   ShellExecute(this->Handle,"open", URL_DISREAL,NULL,NULL, SW_SHOWMAXIMIZED);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnSenseGraphicsClick(TObject *Sender)
{
   ShellExecute(this->Handle,"open", "http://www.sensegraphics.se/",NULL,NULL, SW_SHOWMAXIMIZED);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnWeb3DClick(TObject *Sender)
{
   ShellExecute(this->Handle,"open", "http://www.web3d.org/",NULL,NULL, SW_SHOWMAXIMIZED);
}
//------------------------------------------------------------------------------
void __fastcall TMain::GetDiskItems(TStrings *items,AnsiString carpeta,int itemstype,AnsiString extension)
{
   if( (items == NULL) || !DirectoryExists(carpeta) )
      return;

   bool anadir,esCarpeta;

   // Recibiremos los datos sobre el fichero encontrado en esta variable:
   TSearchRec f;

   // Limpiamos la lista de ficheros:
   items->Clear();

   // Buscamos todo, archivos y carpetas:
   carpeta = carpeta + "\\" + extension;

   if(0 != FindFirst(carpeta,faAnyFile,f))
      return;

   // Aadimos a items el elemento encontrado.
   esCarpeta = (f.Attr & faDirectory);
   anadir = (itemstype == 0) || ( (itemstype == 1) &&  esCarpeta ) ||
                                ( (itemstype == 2) && !esCarpeta );
   if(anadir)
      items->Append(f.Name);

   // Obtenemos el resto de elementos.
   while(FindNext(f) == 0){

      esCarpeta = (f.Attr & faDirectory);
      anadir = (itemstype == 0) || ( (itemstype == 1) &&  esCarpeta ) ||
                                   ( (itemstype == 2) && !esCarpeta );
      if(anadir)
         items->Append(f.Name);
   }

   FindClose(f);  // Libera los recursos reservados

   // Antes de volver vamos a eliminar de la lista las carpetas: "." y "..":
   int index = items->IndexOf(".");
   if(-1 != index )
      items->Delete(index);

   index = items->IndexOf("..");
   if(-1 != index )
      items->Delete(index);
}
//---------------------------------------------------------------------------
AnsiString __fastcall TMain::GetValue(TStringList *lines,int &lineIndex,AnsiString clave)
{
   if(lines == NULL || lineIndex < 0)
      return "";

   while(lineIndex < lines->Count && lines->Strings[lineIndex].Trim() == ""){ lineIndex++; }      

   AnsiString valor = "";
   if(lineIndex < lines->Count && 0 != lines->Strings[lineIndex].UpperCase().Pos(clave) ) 
   {
      valor = lines->Strings[lineIndex];
      int index = valor.UpperCase().Pos(clave);
      valor = valor.Delete(index,clave.Length()).Trim();
      lineIndex++;
   }
   return valor;
}
//---------------------------------------------------------------------------
void __fastcall TMain::AddNodeInf(TStringList *config,AnsiString file)
{
   try
   {
      if(config == NULL || !FileExists(file) )
         return;

      TStringList *inf = new TStringList();
      inf->LoadFromFile(file);

      AnsiString nodeName;
      int lineIndex=0;

      nodeName = GetValue(inf,lineIndex,"NODENAME:");

      // Aadimos como primer campo el container field -> Intentamos obtenerlo de los
      // datos de configuracin actuales -> Si no lo tenemos aadimos esta cadena por defecto:
      //
      Nodo *nodo = NULL;
      AnsiString containerField = "        -     containerField     SFString           children";
      if(GNH != NULL)
      {
         nodo = GNH->DatosNodo(nodeName);
         if(nodo != NULL && nodo->numCampos > 0 && nodo->campos != NULL)
         {
            Campo *campo = nodo->campos[0];
            if(campo != NULL && campo->nombre == "containerField")
            {
               containerField = (AnsiString)"        -     containerField     SFString           " + campo->valorPorDefecto;
            }
         }
      }

      AnsiString tipoNodo = "Others";
      if(nodo != NULL)
         tipoNodo = nodo->tipo;

      config->Append("----------------------------------------------------------------------------------------");
      config->Append("<<<Nodo>>>");
      config->Append("    Nombre:      " + nodeName);
      config->Append("    Descripcin: -");
      config->Append("    Tipo:        " + tipoNodo);
      config->Append("    Icono:       -");
      config->Append("    Imagen:      -");
      config->Append("    Campos VRML:");
      config->Append("      Rutado   Nombre             Tipo               Val.Defecto");
      config->Append("     -------- --------           ------             -------------");
      config->Append(containerField);

      AnsiString line,tipo,campo,rutado,defVal;

      TStringList *campos = new TStringList();

      bool metadataAdded = false;
      bool contieneField = false;

      while(lineIndex < inf->Count)
      {
         do
         {
            int i = lineIndex;
            campo  = GetValue(inf,lineIndex,"FIELDNAME:"    );
            if(i == lineIndex && campo == "" && lineIndex < inf->Count)
               lineIndex++;
         }
         while(campo == "" && lineIndex < inf->Count);

         // En algunos campos aparece el nombre del nodo + un punto -> Cuando ocurra quitamos el punto y el nombre del nodo.
         {
            int ini = campo.Pos(".");
            if( 0 != ini && ini < campo.Length() )
            {
                campo = campo.SubString(ini+1,campo.Length() - ini );
            }
         }

         rutado = GetValue(inf,lineIndex,"ACCESS TYPE:"  );
         tipo   = GetValue(inf,lineIndex,"FIELD TYPE:"   );
         defVal = GetValue(inf,lineIndex,"DEFAULT VALUE:");

         rutado = rutado.UpperCase();
         if     (rutado == "INPUTOUTPUT" ) rutado = "<->";
         else if(rutado == "OUTPUTONLY"  ) rutado = " ->";
         else if(rutado == "INPUTONLY"   ) rutado = "<- ";
         else                              rutado = " - ";

         line = "       " + rutado + "    " + campo + " ";

         if(line.Length() < 33)
            line = line + line.StringOfChar(' ',33 - line.Length());

         line = line + tipo + " ";

         if(line.Length() < 52)
            line = line + line.StringOfChar(' ',52 - line.Length());

         if(0 != defVal.Pos("Unnamed"))
            defVal = "";            

         if(defVal != "")
            line = line + defVal;


         if(campo != "" && 0 == campo.Pos("Unknown") )
         {
            if(tipo == "Field")
               contieneField = true;
            else
               campos->Append(line);

            if(!metadataAdded && campo == "metadata")
               metadataAdded = true;
         }
      }

      if(nodo != NULL)
      {
         for(int c1=0; c1 < nodo->numCampos; c1++)
         {
            if(nodo->campos == NULL || nodo->campos[c1] == NULL)
               continue;

            AnsiString nombreCampo = (AnsiString)"    " + nodo->campos[c1]->nombre + " ";
            for(int c2=0; c2 < campos->Count; c2++)
            {
               if(0 != campos->Strings[c2].Pos(nombreCampo) )
               {
                  config->Append( campos->Strings[c2] );
                  campos->Delete(c2);
                  break;
               }
            }
         }
      }

      if(!metadataAdded && nodeName == "IndexedFaceSet")
      {
         campos->Append("       <->    metadata           SFNode");
      }

      if(contieneField)
      {
         campos->Append("       <->    fields             MFNode");
      }

      // Agregamos los campos que quedan:
      for(int c=0; c < campos->Count; c++)
      {
         config->Append( campos->Strings[c] );
      }

      campos->Clear();
      delete campos;

      inf->Clear();
      delete inf;   
   }
   catch(...){}
}
//---------------------------------------------------------------------------
void __fastcall TMain::mnH3DUpdatesClick(TObject *Sender)
{
   if(GNH == NULL)
      return;

   try
   {

      Utilidad.MsgInfo("Select the folder which contains the H3D API text files.","Informacion");
      AnsiString carpeta = "C:\\";
      if(!SelectDirectory("","",carpeta))
         return;

      // Creamos una lista con todos los nodos que hay actualmente.
      TStringList *nodos  = new TStringList();
      {
         Nodo *n = NULL;
         int numNodos = GNH->GetNumNodos();
         for(int c=0; c < numNodos ;c++)
         {
            n = GNH->DatosNodo(c);
            if(n != NULL)
               nodos->Append(n->nombre.UpperCase() );
         }
      }
   
      TStringList *files  = new TStringList();
      TStringList *config = new TStringList();
   
      config->Append("");
      config->Append("  FICHERO DE CONFIGURACIN DE NODOS H3D  ");
      config->Append("");
      config->Append("   E.T.S. DE INGENIEROS DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA");
      config->Append("   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E");
      config->Append("                                    INTERFACES 3D CON SENSACIN TCTIL");
      config->Append("   TUTOR:    Antonio Daz Estrella");
      config->Append("   ALUMNO:   Eduardo Njera");
      config->Append("   ALUMNO:   Ernesto Jess de la Rubia Cuestas");
      config->Append("   VERSIN:  2.0");
      config->Append("   FECHA:    04/04/2006");
      config->Append(" ");
      config->Append("  El objetivo de los ficheros de configuracin de nodos es ofrecer el mayor");
      config->Append("grado de generalizacin posible al enfocar el diseo del programa. El usuario");
      config->Append("puede cambiar estos ficheros de configuracin para adaptar el programa a nuevas");
      config->Append("versiones X3D/Sensegraphics sin necesidad de modificar el cdigo.");
      config->Append(" ");
      config->Append("  Este fichero almacena los datos de los nodos H3D");
      config->Append("----------------------------------------------------------------------------------------");
      config->Append("<<<LISTADO DE NODOS>>>");
   
      GetDiskItems(files,carpeta,2,"*.txt");
                                              
      if(files->Count == 0)
      {
         Utilidad.MsgInfo("There are no H3D txt files in the selected folder.","Informacion");
         config->Clear();
         delete config;
         files->Clear();
         delete files;
         return;
      }
   
      for(int c1=0; c1 < nodos->Count; c1++)
      {
         AnsiString nombreNodoActual = nodos->Strings[c1];
         for(int c2=0; c2 < files->Count; c2++)
         {
            if( ((AnsiString)nombreNodoActual + ".TXT").UpperCase() == files->Strings[c2].UpperCase() )
            {
                AddNodeInf(config,carpeta + "\\" + files->Strings[c2]);
                files->Delete(c2);
                break;
            }
         }
      }
   
      for(int c=0; c < files->Count; c++)
      {
         AddNodeInf(config,carpeta + "\\" + files->Strings[c]);
      }
   
   
      config->Append("----------------------------------------------------------------------------------------");
      config->Append("<<<Nodo>>>");
      config->Append("    Nombre:      field");
      config->Append("    Descripcin:");
      config->Append("    Tipo:        Others");
      config->Append("    Icono:");
      config->Append("    Imagen:");
      config->Append("    Campos VRML:");
      config->Append("      Rutado   Nombre             Tipo               Val.Defecto");
      config->Append("     -------- --------           ------             -------------");
      config->Append("        -     name               SFString");
      config->Append("        -     type               SFString");
      config->Append("        -     accessType         SFString");
      config->Append("        -     value              MFFloat");
      config->Append("        -     containerField     SFString           fields");
      config->Append("       <->    children           MFNode");
      config->Append("       <->    texture            MFNode");
      config->Append("----------------------------------------------------------------------------------------");
      config->Append("<<<Nodo>>>");
      config->Append("    Nombre:      Script");
      config->Append("    Descripcin:");
      config->Append("    Tipo:        Others");
      config->Append("    Icono:");
      config->Append("    Imagen:");
      config->Append("    Campos VRML:");
      config->Append("      Rutado   Nombre             Tipo               Val.Defecto");
      config->Append("     -------- --------           ------             -------------");
      config->Append("        -     code               MFString");
      config->Append("----------------------------------------------------------------------------------------");
      config->Append("<<<Nodo>>>");
      config->Append("    Nombre:      IMPORT");
      config->Append("    Descripcin:");
      config->Append("    Tipo:        Others");
      config->Append("    Icono:");
      config->Append("    Imagen:");
      config->Append("    Campos VRML:");
      config->Append("      Rutado   Nombre             Tipo               Val.Defecto");
      config->Append("     -------- --------           ------             -------------");
      config->Append("        -     inlineDEF          SFString");
      config->Append("        -     exportedDEF        SFString");
      config->Append("        -     AS                 SFString");
      config->Append("        -     containerField     SFString           children");

      config->SaveToFile(ExtractFileDir(Application->ExeName) + "\\Config\\Nodos H3D.cfg");

      config ->Clear();     delete config;
      nodos  ->Clear();     delete nodos;
      files  ->Clear();     delete files;

      Utilidad.MsgInfo("DisReal must be restarted in order the change takes effect.","Informacion");
   }
   catch(...){}
}
//---------------------------------------------------------------------------
      
