//
//    GESTOR VRML         
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella
   ALUMNO:    Ernesto Jess de la Rubia Cuestas.
   VERSIN:   1.0
   FECHA:     03/03/2003
   DESCRIPCIN:
                Permite leer y escribir ficheros VRML/Reachin.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <Filectrl.hpp>
#include "GestorVRML_.h"
#include "frmUtilidad_.h"
#include "Configuracion_.h"

// Al leer ficheros que tengan ms de MIN_NUM_LINEAS_PARA_SEGUIMIENTO se mostrar
// una barra de progreso con el porcentaje actual procesado.
#define MIN_NUM_LINEAS_PARA_SEGUIMIENTO 5000
// Anlogamente en la escritura se cuentan al nmero de elementos escritos.
#define MIN_NUM_ELEMENTOS_PARA_SEGUIMIENTO 500
// Es el nmero de lneas que se espera entre llamadas a la funcin que
// actualiza la barra de progreso.
#define NUM_LINEAS_PARA_PROGRESO 500

// Es el nmero mximo de errores que se consideran antes de dejar de leer la escena.
#define MAX_NUM_ERRORES 25

// Para no tener que reservar memoria byte a byte en tipos AnsiString en las
// operaciones de Lectura/Escritura se usa un buffer de tamao:
#define TAM_BUFFER 50000


#pragma package(smart_init)

// Creamos un objeto GestorVRML para que se pueda usar externamente:
GestorVRML GVRML;

//------------------------------------------------------------------------------
__fastcall GestorVRML::GestorVRML(){
    IndexBuffer=0;
    UsandoBuffer=false;
    AnidamientoAnulado=false;    
    LL_NumCadena=0;
    LL_cad=NULL;
    LL_CadenaActual="";
    LL_Index=0;
    LL_Lineas=NULL;
    GN=NULL;
    GT=NULL;
    Errores=NULL;
    LineasEF=NULL;
    LL_Finalizada= false;
    numLineaEF=0;
    ElementosEscritos=0;
    NumErrores = 0;
    UsandoBarraDeProgreso = false;
    try{ Buffer = new char[TAM_BUFFER]; }
    catch(...){ Utilidad::FatalErrorFaltaMemoria(); }
}
//------------------------------------------------------------------------------
__fastcall GestorVRML::~GestorVRML(){
   if(Buffer != NULL)
     delete Buffer;
}
//------------------------------------------------------------------------------
inline void __fastcall GestorVRML::Anida(AnsiString &cad,int nivel){
   if(AnidamientoAnulado)
      cad="";
   else
      cad=cad.StringOfChar(' ',nivel * CONF.FICH_VRML_NUM_CARACTERES_JUSTIF);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::EscribeValorCampo(AnsiString &campo,int nivel){
    AnsiString blanco,dato;
    Anida(blanco,nivel);
    int fin,pos,cont,c;
    c=1;

    // Hay que considerar el caso especial de los [] en este caso la primera
    // lnea y la ltima tendrn un nivel de justificacin menos que las centrales.
    // Vamos a buscar si la cadena contiene el caracter '['
    bool contieneCorchetes = (-1 != campo.Pos(']') );
    fin=campo.Length();

    bool corcheteEncontrado=false;
    bool inicio=true;

    while( c <= fin ){

        cont=0;
        pos=c;
        while( (c <= fin) && ( (campo[c]!=(char)13) || ( (c+1 <= fin) && (campo[c+1]!=(char)10)) ) ){
           if(']' == campo[c])
              corcheteEncontrado=true;
           c++;
           cont++;
        }
        dato = campo.SubString(pos,cont);

        if(corcheteEncontrado){
           // Podemos tener como ltima lnea 123] o bien ] as querramos tener:
           //  campo [ 123                  campo [ 123
           //          123        o bien            123
           //          123]                         123
           //                               ]
           if (dato.Trim().Length() == 1)
              // Caso de la derecha
              Anida(blanco,nivel);
           //else
              // Caso de la izquierda (que no es necesario pq blanco ya tiene
              // esa longitud.
              // Anida(blanco,nivel+1);
        }

        // Hemos encontrado una cadena, la aadimos.
        AnadirLineaEF(blanco+dato);

        c+=2;  // Para absorver el caracter 10.
        if(inicio && contieneCorchetes){
          inicio=false;
          Anida(blanco,nivel+1);
        }
    }
}
//------------------------------------------------------------------------------
bool __fastcall GestorVRML::EscribeFichero(NodoArbol *raiz, TStrings *lineas,int NumElementos){

   if((raiz == NULL) || (lineas == NULL))
      return false;

   ElementosEscritos=0;
   UsandoBarraDeProgreso = (NumElementos >= MIN_NUM_ELEMENTOS_PARA_SEGUIMIENTO);
   if(UsandoBarraDeProgreso)
       frmUtilidad->IniciaProgreso("Building Scene...",NumElementos,"",false);

   AnsiString cad;  // En esta cadena escribiremos cada linea del fichero.

   // Iniciamos la escritura en lineas.
   IniciaAnadirLineaEF(lineas);

   // Lo primero es aadir la lnea que deben tener todos los ficheros VRML/Reachin.
   if(  raiz->AsRaiz()->tipoEscena == ESCENA_VRML )
       AnadirLineaEF(CONF.PRIMERA_LINEA_FICH_VRML);
   else if(  raiz->AsRaiz()->tipoEscena == ESCENA_REACHIN ){
       if(CONF.PRIMERA_LINEA_FICH_REACHIN != "")
          AnadirLineaEF(CONF.PRIMERA_LINEA_FICH_REACHIN);
   }

   // Vamos a escribir uno por uno todos los hijos del nodo raiz. Cada uno
   // de sus hijos ser un elemento que habr que escribir recursivamente.
   // Este elemento puede ser un nodo, un vinculo de rutado etc.
   int c=0;
   NodoArbol *elemento;
   while(c <= raiz->hijos->MaxIndexUsado()){
       elemento= (NodoArbol *) raiz->hijos->Get(c);
       if(elemento != NULL) // Llamamos a la funcin que escribe recursivamente el elemento.
          EscribirElemento(elemento,0,true);
       c++;
   }
   FinalizaAnadirLineaEF();
   if(UsandoBarraDeProgreso)
      frmUtilidad->FinalizaProgreso();
   UsandoBarraDeProgreso = false;
   return true;
}
//------------------------------------------------------------------------------
/*
void __fastcall GestorVRML::EscribirElemento(NodoArbol *elemento,int nivel,bool anidarPrimeraLinea){
   if( elemento == NULL )
      return;

   ElementosEscritos++;
   if(UsandoBarraDeProgreso)
        frmUtilidad->ActualizaProgreso(ElementosEscritos,"");

   AnsiString cad;  // Usaremos esta variable para escribir cada linea en formato VRML.

   // Lo primero es ver si hay que desactivar la justificacin o no:
   if( (elemento->padre != NULL) && (elemento->padre->EsNodo()) ){
      // (Incluimos los espacios para evitar encontrar subcadenas).
      AnidamientoAnulado = ( 0 != CONF.NODOS_SIN_ANIDAMIENTO.Pos( (AnsiString) " " + elemento->padre->AsNodo()->nombre + " " ) );
   }

   // Hay que distinguir qu tipo de elemento tenemos.
   if(elemento->EsNodo()){         //------------------------  NODO  -------
      // Para declarar un nodo hay que usar la siguiente sitaxis segn la
      //especificacin VRML 2.0
      //          nodeStatement ::=
      //                       node |
      //                       DEF nodeNameId node |
      //                       USE nodeNameId ;
      //
      //          node ::=
      //                       nodeTypeId { nodeBody } |
      //                       Script { scriptBody } ;
      //  De momento no vamos a considerar el caso USE.
      //
      // Volvemos a asignar el anidamiento pq en este caso no depende del padre
      // sino del propio nodo. (Incluimos los espacios para evitar encontrar subcadenas).
      AnidamientoAnulado = ( 0 != CONF.NODOS_SIN_ANIDAMIENTO.Pos( (AnsiString)" " + elemento->AsNodo()->nombre + (AnsiString)" " ) );

      if(anidarPrimeraLinea)
         Anida(cad,nivel);   // Ya tenemos la cadena justificada:
      else
         cad = "";

      if( (elemento->AsNodo()->nombreDado == NULL ) ||
          (elemento->AsNodo()->nombreDado.Trim() == "" )  )
          cad = cad + elemento->AsNodo()->nombre  +" {";       // En este caso no hay que usar DEF.
      else   // Hay que usar DEF:
          cad = cad + "DEF " + elemento->AsNodo()->nombreDado +
                         " " + elemento->AsNodo()->nombre + " {";

      // Aadimos la lnea.
      if(anidarPrimeraLinea)
         AnadirLineaEF(cad);
      else
         // En este caso aadimos cad sin crear una lnea nueva:
         AnadirLineaEF(cad,false);

      // Vamos a evitar que la llave de cierre } se escriba en la siguiente
      // lnea cuando no se ha escrito nada dentro del nodo, por ejemplo
      // vamos a evitar este tipo de construcciones:
      //  Box{
      //    }
      // Para ello usamos numLineasTmp;
      int numLineasTmp = numLineaEF;

      // El siguiente paso es escribir todos los miembros del nodo.
      for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++)
         // Hacemos una llamada recursiva para escribir los elementos hijos del nodo.
         EscribirElemento((NodoArbol *)elemento->hijos->Get(c),nivel+1,true);

      // y finalmente se escribe la llave }
      if(!anidarPrimeraLinea && (nivel > 0) )
         Anida(cad,nivel-1);
      else
         Anida(cad,nivel);

      // Aadiremos } en la ltima lnea sin crear una lnea nueva cuando al
      // escribir los hijos del nodo no haya aumentado el nmero de lneas:
      if(numLineaEF == numLineasTmp)
         AnadirLineaEF("}",false);
      else
         AnadirLineaEF( cad + "}" );

   }else if(elemento->EsCampo()){  //------------------------  CAMPO  ------

          // Esta es la sintaxis de los nodos VRML:
          //    nodeBodyElement ::=
          //        fieldId fieldValue |
          //        fieldId IS fieldId |
          //        eventInId IS eventInId |
          //        eventOutId IS eventOutId |
          //        routeStatement |
          //        protoStatement ;

       // Hay que distinguir el tipo de campo de elemento:
       // Consideramos primero un caso especial, el de campo perteneciente a
       // un nodo genrico:
       if(  (  (elemento->padre->AsNodo()->tipoNodoVRML == NODO_INDEFINIDO) ||
               (elemento->padre->AsNodo()->tipoNodoVRML == NODO_DEFINIDO_EN_PROTOS) ) &&
               (elemento->dato != NULL) ){
           Escribe_AnsiStringsToLines( elemento->AsCampo()->valor );

       }else if(elemento->AsCampo()->tipoCampo == MFNODE){
             if( elemento->hijos->NumElementosNoNulos() >0){
                  // En este caso habr que recorrer todos los hijos del campo
                  // escribiendo cada uno de ellos.

                  // Este es un ejemplo de un campo MFNODE (fooNode)
                  //      fooNode [ Transform { translation 1 0 0 }
                  //           DEF CUBE Box { }
                  //           USE CUBE
                  //           USE SOME_OTHER_NODE  ]

                  Anida(cad,nivel);   // Ya tenemos la cadena justificada:
                  AnadirLineaEF(cad + elemento->AsCampo()->datosCampo->nombre + (AnsiString) " [" );

                  for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++)
                     // Hacemos una llamada recursiva para escribir los elementos hijos del nodo.
                     EscribirElemento((NodoArbol *)elemento->hijos->Get(c),nivel+1,true);

                  // Tras Escribir todos los hijos hay que cerrar el corchete.
                  // Puedo reutilizar cad:
                  AnadirLineaEF(cad + (AnsiString) "]" );
             }
       }else if(  elemento->AsCampo()->tipoCampo == SFNODE  ){
            // Podemos tener comentarios como hijos-> hacemos un bucle.
            // Tenemos que tener cuidado con el parmetro anidarPrimeraLinea
            // que pasamos a EscribirElemento porque si escribimos un comentario
            // antes que el nodo podramos tener algo como:
            // comentario, por ejemplo # comentario Appearance {
            // Lo vamos a evitar con yaSeHaEscritoUnComentario:
            bool yaSeHaEscritoUnComentario=false;

            for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++){
                NodoArbol *p=(NodoArbol *)elemento->hijos->Get(c);

                if( (p!=NULL) && p->EsComentario() ){
                     yaSeHaEscritoUnComentario=true;
                     EscribirElemento(p,nivel+1,true);
                }else if( (p!=NULL) && ( p->EsNodo() || p->EsUSE() ) ){
                     // Se hace igual que en el caso MFNODE solo que con un nodo:
                     Anida(cad,nivel);   // Ya tenemos la cadena justificada:
                     AnadirLineaEF(cad + elemento->AsCampo()->datosCampo->nombre + (AnsiString) " " );

                     // Escribimos el elemento hijo.
                     if(yaSeHaEscritoUnComentario)
                        EscribirElemento(p,nivel+1,true);
                     else
                        EscribirElemento(p,nivel+1,false);
                }
            }
       }else if( elemento->AsCampo()->valor.Trim() !=
                 ((AnsiString) elemento->AsCampo()->datosCampo->valorPorDefecto)  ){
             // Escribiremos el campo nicamente si su valor almacenado es distinto del
             // valor por defecto.

             // En este caso hay que escribir el dato.
             // Hay que distinguir segn que tipo de campo tengamos:
             if(  elemento->AsCampo()->tipoCampo == SIMPLE ){
                 // En este caso tenemos un tipo simple. Hay que tener cuidado
                 // con los retornos de carro que pueden aparecer en la cadena
                 // ya que habra que escribir varias lneas teniendo en cuenta
                 // la justificacin.

                 // Vamos a escribir el valor del campo de modo que si hay que usar
                 // varias lneas se haga de modo que la segunda lnea quede anidada
                 // correctamente.
                 if( elemento->AsCampo()->valor.Trim() != "" ){
                     cad=  elemento->AsCampo()->datosCampo->nombre + (AnsiString) " ";
                     cad+= elemento->AsCampo()->valor;
                     EscribeValorCampo(cad,nivel);
                 }
             }
       }
   }else if(elemento->EsRutado()){ //------------------------  RUTADO  -----
       Anida(cad,nivel);

       AnsiString ROUTE;
       if( elemento->AsRutado()->routeAndTouch )
          ROUTE = "ROUTEANDTOUCH";
       else
          ROUTE = "ROUTE";

       // Ya tenemos cad justificada.
       // La siguiente lnea muestra la sintaxis de una sentencia ROUTE en VRML 2.0.
       //      ROUTE nodeNameId.eventOutId TO nodeNameId.eventInId;
       // No hay que comprobar si el vnculo es vlido -> Lo hace ChequeaEscenaVRML()
       cad= cad + ROUTE + " " + elemento->AsRutado()->nodoOut + "."
                          + elemento->AsRutado()->campoOut;
       cad= cad + " TO ";

       cad= cad + elemento->AsRutado()->nodoIn + "."
                  + elemento->AsRutado()->campoIn;
       AnadirLineaEF(cad);

   }else if(elemento->EsComentario()){ //--------------------  COMENTARIO --
       Anida(cad,nivel);
       // Ya tenemos cad justificada.
       if( 1 != elemento->AsComentario()->texto.TrimLeft().Pos("#") )
          cad= cad + "#" + elemento->AsComentario()->texto;
       else
          cad= cad + elemento->AsComentario()->texto;
       AnadirLineaEF(cad);
   }else if(elemento->EsUSE()){ //---------------------------  USE  --------
       if(anidarPrimeraLinea)
          Anida(cad,nivel);
       else
          cad = "";

       cad= cad + "USE ";
       if(elemento->dato != NULL)
           cad+=  elemento->AsUSE()->nombreDado;

       if(anidarPrimeraLinea)
          AnadirLineaEF(cad,true);
       else
          AnadirLineaEF(cad,false);
   }else if(elemento->EsProto()){ //-------------------------  PROTO -----------
       Anida(cad,nivel);
       // Ya tenemos cad justificada.
       AnadirLineaEF(cad + "PROTO " + elemento->AsProto()->nombre + " [");
       Escribe_AnsiStringsToLines(elemento->AsProto()->interfaz);
       AnadirLineaEF(cad + "] {");
       Escribe_AnsiStringsToLines(elemento->AsProto()->cuerpo);
       AnadirLineaEF(cad + "}");

   }else if(elemento->EsExternProto()){ //-------------------  EXTERNPROTO -----
       Anida(cad,nivel);
       // Ya tenemos cad justificada.
       AnadirLineaEF(cad + "EXTERNPROTO " + elemento->AsExternProto()->nombre + " [" );
       Escribe_AnsiStringsToLines(elemento->AsExternProto()->interfaz);
       AnadirLineaEF(cad + "] [");
       Escribe_AnsiStringsToLines(elemento->AsExternProto()->url);
       AnadirLineaEF(cad + "]");
   }
}
*/


//------------------------------------------------------------------------------
bool __fastcall GestorVRML::EscribeFichero(NodoArbol *raiz,int NumElementos){

   // Volvemos si raiz es null o si el nombre del fichero es una cadena de
   // caracteres vaca (se comprueba que no tenga espacios en blanco ni
   // caracteres de control).
   if( (raiz == NULL) || ( raiz->AsRaiz()->fichero.Trim() == "") )
       return false;

   // En primer lugar hay que ver si la carpeta existe. Si no existe se
   // intentar crearla.
   AnsiString carpeta = ExtractFileDir( raiz->AsRaiz()->fichero.Trim() );
   if(!DirectoryExists( carpeta )){
       Utilidad::MsgInfo(" The folder " + carpeta + " doesn't exist. This folder is going to be created.","Advertencia");

       if(! CreateDir(carpeta)  ){
          Utilidad::MsgInfo(" An error occurred while creating the folder: " + carpeta ,"Error" );
          return false;
       }
   }

   // En este punto tenemos asegurado que la carpeta existe. Ahora hay que crear
   // el fichero (si existe se sobrescribir).
   AnsiString fichero = raiz->AsRaiz()->fichero.Trim();
   // Ahora vamos a crear un objeto TStrings y a escribir la escena en ese objeto.
   TStringList *lineas=NULL;
   try{ lineas= new TStringList; }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }

   EscribeFichero(raiz,lineas,NumElementos);

   // Ahora solo hay que escribir en el fichero el contenido de lineas.
   Utilidad::SaveToFile(lineas,fichero);
   
   delete lineas;
   return true;
}
//---------------------------------------------------------------------------
bool __fastcall GestorVRML::Separador(const char c){
   // Colocamos los caracteres ms frecuentes al principio para ganar velocidad
   // al usar la evaluacin en cortocircuito.
            // Espacio        Tabulador        Retorno de Carro    Fin de Linea          Coma
   return ( (c == ' ') || (c == (char)0x9) || (c == (char)0xd) || (c == (char)0xa) || (c == (char)0x2c) );
}
//---------------------------------------------------------------------------
bool __fastcall GestorVRML::CaracterIDValido(const char c){
   // Esta funcin se ejecuta con mucha frecuencia. Para que la velocidad sea lo
   // mayor posible colocamos antes los casos ms frecuentes:
   if( (c >= 'a') && (c <= 'z') )
      return true;
   if( (c >= 'A') && (c <= 'Z') )
      return true;
   if( (c == ' ') || (c == (char)0x9) || (c == (char)0xd) || (c == (char)0xa) )
      return false;
   // Los nmeros no puede aparecer en un identificador como primer caracter,
   // pero en esta funcin no hacemos ese tipo de distinciones as que devolvemos
   // true si tenemos un nmero:
   if( (c >= '0') && (c <= '9') )
      return true;
   // Ahora tratamos los casos menos frecuentes (valores obtenidos de la especificacin VRML97).
   int n=(int)c;
   if( (n == 0x22) || (n == 0x23) || (n == 0x27) || (n == 0x2c) || (n == 0x2e) || (n == 0x5b) ||
       (n == 0x5c) || (n == 0x5d) || (n == 0x7b) || (n == 0x7d) || (n == 0x7f) || (n == 0x28) || (n == 0x29))
      return false;
   if( (n >= 0x0) && (n <= 0x20) )
      return false;
   return true;                   
}
//---------------------------------------------------------------------------
bool __fastcall GestorVRML::IniciaLL(TStrings *Lineas){
    LL_Finalizada = false;
    LL_NumCadena=0;
    LL_cad=NULL;
    LL_CadenaActual="";
    LL_Index=0;
    LL_Lineas=Lineas;
    if((Lineas != NULL) && (Lineas->Count > 0) ){
       LL_CadenaActual = Lineas->Strings[0].c_str();
       LL_cad = LL_CadenaActual.c_str();
    }else
       return false;
    return true;
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::FinalizaLL(){
  LL_NumCadena = LL_Lineas->Count;
  LL_Finalizada=true;
}
//---------------------------------------------------------------------------
char __fastcall GestorVRML::GetCaracterLL(bool devolverRCs){
    static int cuenta = 0;
    if(LL_cad[LL_Index] != '\0'){
        return LL_cad[LL_Index++];
    }else{
        if((LL_Lineas != NULL) && (LL_Lineas->Count > (LL_NumCadena + 1) ) ){
           // En este caso hay que adelantar la cadena.
           LL_CadenaActual=LL_Lineas->Strings[++LL_NumCadena].c_str();
           LL_cad=LL_CadenaActual.c_str();
           LL_Index=0;
           if(UsandoBarraDeProgreso && ((cuenta++ % NUM_LINEAS_PARA_PROGRESO) == 0) )
              frmUtilidad->ActualizaProgreso(LL_NumCadena,"");

           // No hacemos nada ms en la siguientes iteraciones del bucle se
           // devolver el caracter adecuado -> Es posible que tengamos varias
           // lneas vacas seguidas y haya que hacer varias iteraciones.
           // Pero si devolverRCs es verdadero no seguiremos iterando,
           // simplemente devolveremos el RC.
           if(devolverRCs)
               return (char)13;
           else
               return ' '; // al menos hay que devolver un espacio para que
                           // no se unan palabras de distintas lneas.
        }else{
           // En este caso se han leido todos los datos -> no hacemos nada.
           LL_Finalizada=true;
           return '\0';
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::RetrocedeCaracterLL(){
    if(LL_Index == 0){
        // En este caso tenemos que pasar a la lnea anterior.
        if (LL_NumCadena > 0){
           // Cargamos la cadena anterior.
           LL_CadenaActual=LL_Lineas->Strings[--LL_NumCadena].c_str();
           LL_cad=LL_CadenaActual.c_str();
           // Asignamos index al final de la cadena as tendr que (LL_cad[LL_Index] == '\0')
           LL_Index = LL_Lineas->Strings[LL_NumCadena].Length();
        }
    }else{
          LL_Index--;
    }
    LL_Finalizada = false;
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::GetRestoLineaLL(){

    // El resto de la lnea lo podemos obtener como un puntero a char a la
    // posicin actual.
    AnsiString devolver=(AnsiString) &LL_cad[LL_Index];

    // Hacemos LL_cad[LL_Index] sea '\0' porque lo necesitamos en la condicin
    // del bucle y porque si estamos en la ltima lnea no entraremos en el bucle.
    if(LL_NumCadena < LL_Lineas->Count)
       LL_Index = LL_Lineas->Strings[LL_NumCadena].Length();
    else{
       // En este caso se ha llegado al final del fichero. Actualizamos
       // LL_index para que el prximo caracter leido sea '\0' 
       LL_Index= LL_CadenaActual.Length();
       return devolver;
    }

    // Ahora solo hay que cargar la siguiente lnea:
    while( (LL_Lineas != NULL) && (LL_Lineas->Count > (LL_NumCadena + 1) )
         && (LL_cad[LL_Index]=='\0')   ){
         LL_CadenaActual=LL_Lineas->Strings[++LL_NumCadena].c_str();
         LL_cad=LL_CadenaActual.c_str();
         LL_Index=0;
    }
    return devolver;
}
//---------------------------------------------------------------------------
int __fastcall GestorVRML::GetFilaLL(){
   return LL_NumCadena+1;
}
//---------------------------------------------------------------------------
int __fastcall GestorVRML::GetColumnaLL(){
   return LL_Index;
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::GetPalabraID_LL(NodoArbol *padre){
    if(padre == NULL)
       return "";

    // En primer lugar absorvemos WhiteSpace.
    AbsorveWhiteSpaceLL(padre);

    // Ahora construimos una cadena con todos los caracteres que no sean separadores.
    AnsiString cad="";

    char letra=GetCaracterLL();

    // El bucle acaba cuando se han acabado los datos o cuando el ltimo caracter
    // leido es un separador.
    while( (letra!='\0') && !Separador(letra) && CaracterIDValido(letra) ){
       cad+=letra;
       letra=GetCaracterLL();
    }

    // Debemos dejar la posicin de LL justo tras la palabra leida.
    if( (letra!='\0') &&  (Separador(letra) || !CaracterIDValido(letra)) )
       RetrocedeCaracterLL();

    return cad;
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeComentario(NodoArbol *padre){
    if(padre == NULL)
       return;

    // En primer lugar creamos el nuevo nodo en memoria.
    NodoArbol *comentario=CrearElemento(COMENTARIO);

    // Obtenemos el resto de la lnea.
    comentario->AsComentario()->texto=GetRestoLineaLL();

    // Vinculamos padre e hijo.
    comentario->padre=padre;
    padre->hijos->Set((void *)comentario,padre->hijos->MaxIndexUsado()+1);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::AbsorveWhiteSpaceLL(NodoArbol *padre){

   if(padre == NULL)
       return;

   char letra=GetCaracterLL();
   while( Separador(letra) || (letra == '#')  ){

      if(letra == '#'){
          RetrocedeCaracterLL();  // Nos colocamos sobre el caracter '#'
          LeeComentario(padre);
      }
      letra=GetCaracterLL();
   }
   // Es necesario retroceder un caracter porque el ltimo valor de letra ya no
   // pertenece al WhiteSpace. Pero hay una excepcin letra = '\0' -> se ha llegado
   // al final del fichero.
   if(letra != '\0')
      RetrocedeCaracterLL();
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeRutado(NodoArbol *padre,bool routeandtouch){

    if(padre == NULL)
       return;

    // En primer lugar creamos el nuevo nodo en memoria.
    NodoArbol *rutado=CrearElemento(RUTADO);

    rutado->AsRutado()->routeAndTouch = routeandtouch;

    // A continuacin tendremos el nombre del nodo seguido de un punto  de
    // whiteSpace (incluido comentarios) as que no nos vale lee palabra y hay
    // que construir el identificador del nodo caracter a caracter.
    char letra;
    AnsiString NodoInID,NodoOutID,EventInID,EventOutID;

    //. . . . . . . . . . . . . . . . . . . . . . . . . LECTURA NodoOutID . . .
    NodoOutID=GetPalabraID_LL(padre);
    AbsorveWhiteSpaceLL(padre);
    if('.' != GetCaracterLL()){
         delete rutado;
         return;
    }
    // La LL est tras el punto '.' as:
    //. . . . . . . . . . . . . . . . . . . . . . . . . LECTURA EventOutID . . .
    // La siguiente palabra debe ser EventOutID.
    EventOutID=GetPalabraID_LL(padre);

    // La siguiente palabra debe ser TO si no ser un error.
    if( ((AnsiString)"TO") != GetPalabraID_LL(padre) ){
         AnadirError(MsgFilaColumna() + " Error format in ROUTE sentence");
         delete rutado;
         return;
    }

    //. . . . . . . . . . . . . . . . . . . . . . . . . LECTURA NodoInID . . .
    // Hemos absorvido "TO" y solo queda leer NodoInID y EventInID.
    NodoInID=GetPalabraID_LL(padre);
    AbsorveWhiteSpaceLL(padre);
    if('.' != GetCaracterLL()){
         delete rutado;
         return;
    }
    //. . . . . . . . . . . . . . . . . . . . . . . . . LECTURA EventInID . . .
    // La siguiente palabra debe ser EventOutID.
    EventInID=GetPalabraID_LL(padre);

    // Ya tenemos las palabras que aparecen en el fichero VRML/Reachin ahora hay
    // que asignarlas:
    rutado->AsRutado()->nodoOut  = NodoOutID;
    rutado->AsRutado()->campoOut = EventOutID;
    rutado->AsRutado()->nodoIn   = NodoInID;
    rutado->AsRutado()->campoIn  = EventInID;

    // Hay que aadir este nuevo nodo al elemento padre:
    rutado->padre=padre;
    padre->hijos->Set((void *)rutado,padre->hijos->MaxIndexUsado()+1);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeNodo(NodoArbol *padre,AnsiString palabra){

    if( (padre == NULL) || (GN == NULL) )
       return;

    /* Al leer un nodo podemos tener:
        Nombre_NodoVRML { cuerpo }
        DEF NombreDado Nombre_NodoVRML { cuerpo }
        USE NombreDado
      Comprobaremos cada uno de estos casos. En Primer lugar USE porque en ese
    caso bo habr que crear un nodo en memoria.*/
    if(palabra == "USE"){
       // Este es un caso especial que tratamos por separado.
       // Leemos el identificador del nodo que se quiere usar:
       AnsiString nombreDado = GetPalabraID_LL(padre);

       // Tenemos que crear un nodo nuevo de tipo USE y asignarlo.
       // En primer lugar creamos el nuevo nodo en memoria.
       NodoArbol *nodoArbol=CrearElemento(USE);
       // Asignamos sus datos:
       nodoArbol->AsUSE()->nombreDado=nombreDado;

       // Vinculamos padre e hijo.
       nodoArbol->padre=padre;
       padre->hijos->Set((void *)nodoArbol,padre->hijos->MaxIndexUsado()+1);

       return;
    }

    // Vamos a leer el nombre del nodo VRML y el nombre que se ha dado al nodo
    // en el caso de usar DEF.
    AnsiString nombreNodoVRML="";
    AnsiString nombreDado="";

    if(palabra == "DEF"){
        // Obtenemos el nombre dado al nodo:
        nombreDado=GetPalabraID_LL(padre);
        // Leemos el nombre del nodo VRML/Reachin. Hay que tener cuidado porque
        // entre el nombre del nodo y la { podemos tener 0 o ms separadores.
        nombreNodoVRML=GetPalabraID_LL(padre);
        // Ahora absorvemos la llave que puede venir precedida o no de WhiteSpace.
        AbsorveWhiteSpaceLL(padre);
        if( '{' != GetCaracterLL() ){
           AnadirError(MsgFilaColumna() + " Sintax error in node: " + nombreNodoVRML + " '{' expected");
           return;
        }
    }else{
       // En este caso palabra es directamente el nombre del nodo VRML.
       nombreNodoVRML=palabra;
       // Ahora absorvemos la llave que puede venir precedida o no de WhiteSpace.
       AbsorveWhiteSpaceLL(padre);
        if( '{' != GetCaracterLL() ){
           AnadirError(MsgFilaColumna() + " Sintax error in node: " + nombreNodoVRML + " '{' expected");
           return;
        }
    }

    NodoArbol *nuevoNodo; // =NULL; comentado para evitar el warning "is assigned a value thar is never used

    if( NULL != GN->DatosNodo(nombreNodoVRML) ){
       // A continuacin creamos un nuevo nodo VRML en frmEscena.
       nuevoNodo=AnadirNodo(nombreNodoVRML,padre);
    }else{
       // No se ha encontrado el nodo que intentbamos crear -> Creamos un
       // nodo Genrico y lo leemos: (Puede tratarse de un nodo Indefinido o de
       // un nodo definido en una sentencia PROTO o EXTERNPROTO.
       nuevoNodo = AnadirNodoGenerico(nombreNodoVRML,padre);
       if(nuevoNodo == NULL){
          AnadirError(MsgFilaColumna() + " Can not create the node " + nombreNodoVRML);
          return;
       }
       // An tenemos que asignar el nombre dado:
       nuevoNodo->AsNodo()->nombreDado=nombreDado;

       // Solo falta leer el interior del nodo:
       if( (nuevoNodo->hijos != NULL) && (nuevoNodo->hijos->Get(0) != NULL) ){
          NodoArbol *na = nuevoNodo->GetHijo(0);
          if(na != NULL){
             TipoCampo *campo = na->AsCampo();
             if(campo != NULL)
                LeeInteriorLlave1Llave2('{','}',campo->valor);
          }
       }

       // Finalmente comprobamos si el nodo que acabamos de leer es un nodo
       // Indefinido o un nodo definido por una sentencia PROTO o EXTERNPROTO:
       if( 0 == NodoDefsEnPROTOs.Pos( (AnsiString)" " + nombreNodoVRML + " " ) ){

          // En este caso tenemos un nodo Indefinido.
          nuevoNodo->AsNodo()->tipoNodoVRML = NODO_INDEFINIDO;

          // Tenemos que aadirlo a los nodos indefinidos (siempre que no se
          // haya aadido ya):
          if( 0 == NodosIndefinidos.Pos( (AnsiString)" " + nombreNodoVRML + " " ) )
             NodosIndefinidos = NodosIndefinidos + nombreNodoVRML + " ";

       }else{
          // Tenemos un nodo que ha sido definido en una sentencia Proto o ExternProto:
          nuevoNodo->AsNodo()->tipoNodoVRML = NODO_DEFINIDO_EN_PROTOS;
       }

       return;
    }

    if(nombreDado != "")
       nuevoNodo->AsNodo()->nombreDado=nombreDado;

    /* En este punto hay que leer el cuerpo del nodo:
                                          
           L E C T U R A   D E L   C U E R P O  D E L   N O D O      
                                          
     Dentro del cuerpo podemos tener:
       Una sentencia ROUTE -> Para detectar este caso usaremos que debe empezar
                            con la palabra ROUTE.
       Una sentencia PROTO -> Para detectar este caso usaremos que debe empezar
                            con la palabra PROTO o EXTERPROTO.
       Un campo -> En este caso aparecer el nombre del campo seguido de:
           - El valor del campo 
           - una sentencia IS -> Creo que esto solo puede ocurrir en el interior de un PROTO. */

    // La posicin de LL es la siguiente al caracter {. As que haremos un bucle
    // en el que iremos leyendo palabras y distinguiremos varios casos.
    bool fin=false;

    while(!fin){
         // Reutilizamos palabra:
         palabra=GetPalabraID_LL(nuevoNodo);

         if(palabra == "PROTO"){//-----------------------------  PROTO  --------

            LeePROTO(padre);

         }else if(palabra == "EXTERNPROTO"){//-----------  EXTERNPROTO  --------

            LeeEXTERNPROTO(padre);

         }else if(palabra == "ROUTE"){//-------------------------  ROUTE  --------

            LeeRutado(padre,false);

         }else if(palabra == "ROUTEANDTOUCH"){//-----------------  ROUTEANDTOUCH -
            if(GN == Main->GNR)
               LeeRutado(padre,true);
            else
               AnadirError(MsgFilaColumna() + " Error -> ROUTEANDTOUCH sentences are valid in Reachin scenes only");

         }else if(palabra == ""){     //-------------------------  FIN NODO --------
            // Get palabra puede devolver "" por dos motivos: 1 que se hayan acabado
            // los datos -> en este caso GetCaracter deolvera '\0' -> mostraremos
            // un mensaje de error. El 2 motivo es que se haya encontrado un caracter
            // que no forma parte del WhiteSpace ni es un caracter vlido de un ID,
            // por ejemplo } -> As que si el caracter leido es } acabamos las iteraciones.
            char c = GetCaracterLL();
            if( c=='\0'){
                // En este caso se han acabado los datos (fin del fichero).
                AnadirError(MsgFilaColumna() + " Expected '}'");
                fin=true;
            }else if( c=='}'){
                fin=true;
            }else{
                AnadirError(MsgFilaColumna() + " Unexpected character " + (AnsiString)c);
                fin=true;
            }
         }else{   //------------------------------------------------ CAMPO -------

              // ALGO MUY IMPORTANTE: Es que el orden en el que aparecen los campos
              // de un nodo VRML no es indiferente por ello iremos aadiendo los
              // campos en el mismo orden que se vayan leyendo.

              // En palabra tengo el nombre del campo y en nuevoNodo toda
              // la informacin sobre el nodo. Antes de llamar a LeeCampo
              // tengo que crear el campo <palabra> en memoria como hijo de
              // nuevoNodo.
              NodoArbol *nuevoCampo = CreaCampo(nuevoNodo,palabra);
              if(nuevoCampo != NULL){
                 LeeCampo(nuevoNodo,nuevoCampo);
              }else{
                 AnadirError(MsgFilaColumna() + " Can not create the field " + palabra + " of the node " +
                                 nuevoNodo->AsNodo()->nombre + " " +
                                 nuevoNodo->AsNodo()->nombreDado);
              }
         }
     }
     if( !CreaRestoCampos(nuevoNodo))
         AnadirError(MsgFilaColumna() + " Can not create the fields of the node " + palabra );
}
//---------------------------------------------------------------------------
NodoArbol* __fastcall GestorVRML::GetHijo(NodoArbol *padre,AnsiString nombreCampo){

   if( (padre == NULL) || (!padre->EsNodo()) )
      return NULL;

   for(int c=0; c <= padre->hijos->MaxIndexUsado(); c++){
       // Comparamos el nombre de cada campo con campo.
       NodoArbol *campo = (NodoArbol *) padre->hijos->Get(c);
       if( (campo != NULL) && campo->EsCampo()  &&
           (nombreCampo == campo->AsCampo()->nombre) )
             return campo;
   }
   return NULL;
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::MsgFilaColumna(){
  return "Row:" + IntToStr(GetFilaLL()) + " Col:" + IntToStr(GetColumnaLL()) + "-->";
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeSFNode(NodoArbol *campo, AnsiString palabra){
        /* Segun el anxo de grtica de la espeficicacin VRML un campo de
        tipo SFNODE tendr la siguiente estructura:
              sfnodeValue ::=
                     nodeStatement | NULL ;
         As podr valer NULL o ser la declaracin de un nodo.   */

         // palabra es la primera palabra que forma parte del campo SFNODE.
         if(palabra == ""){
             return;
         }else if(palabra == "NULL"){
            // En este caso solo hay que poner a NULL el valor del campo.
             campo->AsCampo()->valor="NULL";
         }else{
            // En este caso tenemos la definicin de un nodo-> hacemos una llamada
            // a la funcin LeeNodo (es una llamada recursiva porque la funcin
            // LeeCampo se llam desde LeeNodo()).
            LeeNodo(campo,palabra);
         }
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeCampo(NodoArbol *padre,NodoArbol *campo){
    if((padre == NULL) || (!padre->EsNodo()) || (campo == NULL) || !campo->EsCampo() )
       return;

   // Aqui tenemos en campo los datos del campo actual.

   // *************  *******************   *******************  ****************
   // *************  ESTRATEGIA PARA LA LECTURA DE CAMPOS VRML  ****************
   // *************  *******************   *******************  ****************
   /* Distinguiremos varios casos -> SFNODE ~ MFNODE ~ RESTO:
     Para SFNODE y MFNODE usaremos llamadas recursivas.
     Para el resto de campos se leeran todos los caracteres hasta encontrar }
     o una palabra que coincida con el nombre de otro campo o con ROUTE PROTO
     o EXTERNPROTO. Hay que tener cuidado con las cadenas que deben leerse de
     forma atmica para evitar interpretar el interior de las cadenas como
     cdigo VRML. Tambin hay que tener cuidado con que dentro de una cadena
     puede aparecer la construccin \" para indicar que esa comilla no es la
     comilla de cierre de la cadena.
        Es necesario decir que para simplificar las funciones de lectura y para
     hacer que esta funcin de lectura no sea demasiado lenta se opta por no hacer
     las comprobaciones del contenido de los campos -> podran usarse las mscaras
     para verificar que el contenido leido para cada campo es el correcto. Por
     ejemplo que un campo numrico no contenga letras -> pero eso no se hace,
     como ya se ha mencionado, para no complicar demasiado esta funcin y para
     no enlentecerla (y tambin porque hay funciones que realizan esa verificacin
     una vez que la escena est cargada en memoria.
   */

        //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  SFNODE  XXXXXXXXXXXXX
   if     ( campo->AsCampo()->tipoCampo == SFNODE ){

          LeeSFNode(campo,GetPalabraID_LL(padre));
        //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  MFNODE  XXXXXXXXXXXXX
   }else if( campo->AsCampo()->tipoCampo == MFNODE ){
        /* Segun el anxo de gramtica de la espeficicacin VRML un campo de
        tipo SFNODE tendr la siguiente estructura:
             mfnodeValue ::=
                     nodeStatement | [ ] | [ nodeStatements ] ;
         As podr valer NULL o ser un nodo o ser [] o ser 1 o ms nodos entre []
         Leemos la primera palabra y distinguimos varios casos.  */
         AnsiString palabra = GetPalabraID_LL(campo);
         if(palabra == ""){
             // En este caso estamos aprovechando el hecho de que GetPalabra no
             // avanzar nada cuando se encuentre un [ as devolver "".

             // Vamos a absorver el caracter [.
             if( GetCaracterLL() != '[' ){
                  AnadirError(MsgFilaColumna() + " Not valid character as field value");
                  return;
             }
             // Ahora hay que leer todos los nodos mientras sea posible.
             bool fin=false;
             do{
                 // Hay que tener en cuenta que podemos tener []:
                 AnsiString palabra = GetPalabraID_LL(campo);
                 if(palabra != ""){
                     LeeSFNode(campo,palabra);
                 }else{
                     // En este caso se ha parado el avance de la funcin
                     // GetPalabraID_LL() -> debemos tener ].
                     if(GetCaracterLL() != ']'){
                         AnadirError(MsgFilaColumna() + " Not valid character as field value");
                         return;
                     }else{
                         fin=true;
                     }
                 }
             }while(!fin);
         }else{
             // En este caso tenemos un SFNode que puede ser NULL o un nodo -> Lo leemos:
             LeeSFNode(campo,palabra);
         }

        //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  SIMPLE  XXXXXXXXXXXXX
   }else if( campo->AsCampo()->tipoCampo == SIMPLE ){
       // En este caso tenemos un valor simple de un campo.
       LeeCampoSIMPLE(campo->padre,campo->AsCampo()->valor);
       // Queremos evitar los separadores al final de los datos -> porque hay
       // RCs que molestan, as:
       int c,pos=0;
       AnsiString valor = campo->AsCampo()->valor;
       for(c=valor.Length(); c > 0 ; c--){
            // Vamos desde el final hasta que se encuentre un caracter que no sea
            // un separador.
            if(!Separador(valor[c])){
               pos=c;
               c=0;  // salimos del bucle.
            }
        }
       // Ya tenemos la cadena sin los separadores
       campo->AsCampo()->valor=valor.SubString(1,pos);
   }
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeCampoSIMPLE(NodoArbol *padre,AnsiString &texto){

  if( (padre == NULL) || (!padre->EsNodo()) )
     return;

  // En primer lugar tenemos que ver si el padre es un nodo con o sin
  // anidamiento. (Incluimos los espacios para evitar encontrar subcadenas).
  AnidamientoAnulado = ( 0 != CONF.NODOS_SIN_ANIDAMIENTO.Pos( (AnsiString)" " + padre->AsNodo()->nombre + " " ) );

  texto="";

  // Lo primero es absorver el WhiteSpace que haya.
  if(!AnidamientoAnulado)
     AbsorveWhiteSpaceLL(padre);
     
  // Ahora hay que ver si el primer caracter es [ o no.
  char letra = GetCaracterLL(true);
  if( letra == '[' ){
       // El Buffer no debe ser compartido por las funciones, avisaremos con un
       // mensaje si se produce esta situacin indeseada.
       if(UsandoBuffer)
          Utilidad::MsgInfo("The Read/Write buffer is being shared","Advertencia");
       UsandoBuffer=true;
       IndexBuffer=0;
       // En este caso tenenos la ventaja de que los datos aparecen entre []:
       while( (letra != '\0') && (letra != '}') && (letra != ']') ){
           // Para no colocar mal el comentario y para acelerar un poco la
           // lectura es preferible no considerar los comentarios que aparecen
           // entre [ ]
           // if(letra == '#'){
           //    RetrocedeCaracterLL();
           //    LeeComentario(padre);
           // }
           if(letra != '"'){
              Buffer[IndexBuffer++]=letra;
              if(IndexBuffer+1 >= TAM_BUFFER){
                 Buffer[IndexBuffer]='\0';
                 texto+=Buffer;
                 IndexBuffer=0;
              }

              if(letra == (char)13){
                 // En este caso aadimos ademas el caracter 10.
                 Buffer[IndexBuffer++]=(char)10;
                 if(IndexBuffer+1 >= TAM_BUFFER){
                    Buffer[IndexBuffer]='\0';
                    texto+=Buffer;
                    IndexBuffer=0;
                 }
                 // Conviene absorver todos los separadores para evitar el efecto de
                 // la justificacin:
                 if(!AnidamientoAnulado){
                    char c=GetCaracterLL(true);
                    while( (c == ' ') ||(c == (char)0x9)  )
                       c=GetCaracterLL(true);
                    RetrocedeCaracterLL();
                 }
              }
           }else{
               RetrocedeCaracterLL();
               // Actualizamos el contenido de texto antes de cargar la cadena.
               Buffer[IndexBuffer]='\0';
               texto+=Buffer;
               IndexBuffer=0;
               texto+=LeeString();
           }
           letra=GetCaracterLL(true);
       }
       // Actualizamos el contenido de texto.
       Buffer[IndexBuffer]='\0';
       texto+=Buffer;
       UsandoBuffer=false;

       if( (letra == '\0') || (letra == '}') ){
           // En este caso se han leido todos los datos y no se ha encontrado ]
           // o bien se ha llegado al final del nodo y no se ha encontrado ]
           AnadirError(MsgFilaColumna() + " It was Expected ] ");
           return;
       }else if(letra == ']'){
           // En este caso todo ha acabado correctamente.
           texto+=']';
           return;
       }
  }else{
     // Tenemos un campo SF o bien un campo MF con solo un valor.
     // Volvemos a colocarnos al principio de los datos.
     // La estrategia para leer los datos del campo ser ir copiando en texto
     // todo lo que vallamos leyendo hasta que se encuentre una palabra que sea
     // el nombre de un campo, el final del nodo o el final de los datos de la LL.

     // Usaremos anter para saber cuando empieza una nueva palabra que pueda ser
     // el nombre de un campo.
     char anter;

     bool fin=false;
     while( (letra != '\0') && (letra != '}') && (!fin) ){
         if(letra == '#'){
             RetrocedeCaracterLL();  // Nos colocamos en #
             LeeComentario(padre);
             letra = ' ';  // Es para que en [*] (abajo) se compruebe el nombre del campo.
         }else if(letra == '"'){
             RetrocedeCaracterLL();
             texto+=LeeString();
             letra = ' ';  // Es para que en [*] (abajo) se compruebe el nombre del campo.
         }else{
            texto+=letra;
            if(letra == (char)13){
               // En este caso aadimos ademas el caracter 10.
               texto+=(char)10;

               // Conviene absorver todos los separadores para evitar el efecto de
               // la justificacin:
               if(!AnidamientoAnulado){
                  char c=GetCaracterLL(true);
                  while( (c == ' ') ||(c == (char)0x9)  )
                     c=GetCaracterLL(true);
                  RetrocedeCaracterLL();
               }
            }
         }

         anter=letra;  // Punto [*] rederenciado arriba.
         letra=GetCaracterLL(true);

         // Cuando el caracter anterior es un caracter Separador y el actual
         // es un CaracterIDValido estamos al principio de una palabra que
         // podra ser el nombre de un nuevo campo.
         if( Separador(anter) && CaracterIDValido(letra) ){
             // En este caso hay que ver si estamos o no al principio del nombre
             // de otro campo y en ese caso asignar fin a true.

             // Haremos un bucle que lea hasta encontrar un separador
             AnsiString sigCampo="";
             int cont = 1; // Contaremos el nmero de letras leidas para luego retroceder.
             while( (letra != '\0') && CaracterIDValido(letra) ){
                 sigCampo+=letra;
                 letra=GetCaracterLL(true);
                 cont++;
             }

             // Si se han acabado los datos (letra == '\0') habr un error porque
             // faltara el caracter } del nodo.
             if(letra == '\0'){
                  AnadirError(MsgFilaColumna() + " It was expected }");
                  return;
             }else{
                 // Hay que retroceder cont veces para estar justo antes de la
                 // palabra que hemos leido.
                 for(int c=0; c < cont ;c++)
                    RetrocedeCaracterLL();

                 // Ya tenemos una palabra que hay que comparar con
                 // los nombres de los campos:
                 Nodo *datosNodo= padre->AsNodo()->datosNodo;
                 bool hijoEncontrado = false;
                 for(int cont=0 ; cont < datosNodo->numCampos; cont++){
                    AnsiString nombreCampo = datosNodo->campos[cont]->nombre;
                    if(nombreCampo == sigCampo){
                        hijoEncontrado=true;
                        cont=datosNodo->numCampos; // Salimos del bucle.
                    }
                 }

                 if( hijoEncontrado ){
                    // En este caso se ha encontrado el siguiente campo.
                    fin = true;
                 }else{
                    // En este caso no se ha encontrado el nodo as que volvemos
                    // a leer la letra que tenemos que procesar.
                    letra=GetCaracterLL(true);
                 }
             }
         }
     }

     if (letra == '\0')
         AnadirError(MsgFilaColumna() + " Unexpected end of file.");
     // Notar que no sera un error que se salga del bucle porque letra sea }
     if(letra == '}')
        // En este caso retrasamos la LL para que desde el exterior se pueda
        // saber que el nodo ha acabado.
        RetrocedeCaracterLL();
  }
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::LeeString(){

   if(GetCaracterLL() != '"'){
      // Dejamos la LL como estaba antes de entrar en LeeString.
      RetrocedeCaracterLL();
      return "";
   }
   // Inicializamos la cadena con el caracter que hemos absorvido.
   AnsiString texto= '"';
   char letra = GetCaracterLL(true);
   while( (letra != '\0') && (letra != '"') ){
      texto+=letra;
      if(letra == (char)13)
          // En este caso aadimos ademas el caracter 10.
          texto+=(char)10;
      else if(letra == '\\'){
          // En este caso comprobamos si el siguiente caracter leido es '"'
          if(GetCaracterLL() == '"')
             texto+='"';
          else
             RetrocedeCaracterLL();
      }
      letra=GetCaracterLL(true);
   }

   if(letra == '\0'){
       // Se ha llegado al final de los datos cuando se esperaba encontrar el
       // final de una cadena.
       AnadirError(MsgFilaColumna() +" It was expected \" ");
       return "";
   }else
       texto+='"';

   return texto;
}
//---------------------------------------------------------------------------
// Ver "CLAVES PARA LA IMPLEMENTACIN DE LA FUNCIN DE LECTURA DE LA ESCENA VRML"
NodoArbol * __fastcall GestorVRML::CargaEscena(TStrings *lineas,TStrings *errores,AnsiString fichero,
                                               TipoEscena tipoEscena,bool mostrarMsgNodosIndefinidos,
                                               int &numNodosIndefinidos,bool ProcesaCabecera){

   if( (lineas == NULL) || (errores == NULL) )
       return NULL;

   Errores=errores;
   NumErrores=0;
   Errores->Clear();

   // Inicializamos la variable que contendr los nodos indefinidos que se
   // encuentren durante la lectura. Todos los nodos estran separados por " ".
   // Al buscar el nombre de un nodo en esta variable hay que evitar encontrar
   // subcadenas, para ello se buscar: " NombreDelNodoIndefinido" y por ello
   // NodosIndefinidos entr el formato: " NodoInd1 NodoInd2 ... NodoIndN "
   NodosIndefinidos = " ";

   UsandoBarraDeProgreso= (lineas->Count >= MIN_NUM_LINEAS_PARA_SEGUIMIENTO);
   if(UsandoBarraDeProgreso)
       frmUtilidad->IniciaProgreso("Processing Data...",lineas->Count,"",false);

   // Asignamos los gestores de datos.
   switch ( tipoEscena ){
      case ESCENA_VRML:
           GN=Main->GNV;
           GT=Main->GTV;
      break;
      case ESCENA_REACHIN: ;
           GN=Main->GNR;
           GT=Main->GTR;
      break;
   }

   // Cuando se encuentra un nodo no registrado se considera como un nodo
   // genrico. Tener un nodo no registrado puede deberse a dos causas:
   //  1 Que sea un nodo definido en sentencias PROTO o EXTERNPROTO.
   //  2 Que sea un nodo Indefinido, por ejemplo un nodo creado con C++ de Reachin.
   // Tras cargar una escena se avisar al usuario si hay nodos no definidos.
   // Pero para distinguir los dos casos anteriores tenemos que usar esta variable
   // en la que se almacenarn durante la carga del fichero todos los nombres
   // de nodos definidos en sentencias PROTO y EXTERNPROTO.
   // Hay que tener en cuenta algo: Cuando queramos localizar el nombre del
   // nodo "Shape" dentro de esta variable, tendremos que buscar " Shape " para
   // evitar encontrar subcadenas.
   NodoDefsEnPROTOs = " ";

   // Raiz ser el nodo padre de todos los elementos del fichero.
   NodoArbol *raiz = CrearElemento(RAIZ);

   // Asignamos sus campos.
   raiz->AsRaiz()->fichero=fichero;
   raiz->AsRaiz()->tipoEscena=tipoEscena;

   // Iniciamos la lectura lineal de los datos de la escena.
   if(!IniciaLL(lineas)){
      GN=NULL;
      GT=NULL;
      Errores=NULL;
      if(UsandoBarraDeProgreso)
         frmUtilidad->FinalizaProgreso();
      UsandoBarraDeProgreso = false;
      return NULL;
   }

   // Comprobamos que la primera cadena del fichero es correcta -> Solo es
   // necesario hacerlo si la escena es de tipo ESCENA_VRML porque en los
   // ficheros Reachin no es obligatoria que aparezca la primera lnea que
   // indica la versin de VRML y el tipo de Codificacin.
   if( ProcesaCabecera && (tipoEscena == ESCENA_VRML) ){

      AnsiString resto = GetRestoLineaLL();

      if( !ChequeaPrimeraLinea(resto) ){
         errores->Append("Row:1 Col:1 --> It is needed to be agree with the VRML 2.0 specification and use UTF-8");
         GN=NULL;
         GT=NULL;
         Errores=NULL;
         if(UsandoBarraDeProgreso)
            frmUtilidad->FinalizaProgreso();
         UsandoBarraDeProgreso = false;
         return raiz;
      }
   }

   // Usaremos un bucle que ir aadiendo los elementos que haya en la raiz del
   // fichero. Con un booleano se indicar cuando dejar de iterar.
   AnsiString palabra;
   while(!LL_Finalizada){
       palabra=GetPalabraID_LL(raiz);
       // Tenemos que distinguir varios casos para los elementos de la raiz:
       if(palabra == "PROTO"){  //-----------------------------  PROTO  --------

          if(tipoEscena == ESCENA_REACHIN)
             AnadirError(MsgFilaColumna() + " PROTO sentences not allowed in Reachin scenes");
          else
             LeePROTO(raiz);

       }else if(palabra == "EXTERNPROTO"){//------------------ EXTERNPROTO  ----

          if(tipoEscena == ESCENA_REACHIN)
             AnadirError(MsgFilaColumna() + " EXTERNPROTO sentences allowed in Reachin scenes");
          else
             LeeEXTERNPROTO(raiz);

       }else if(palabra == "ROUTE"){//-------------------------  ROUTE  --------

           LeeRutado(raiz,false);

       }else if(palabra == "ROUTEANDTOUCH"){//-----------------  ROUTEANDTOUCH -
           if(tipoEscena == ESCENA_REACHIN)
              LeeRutado(raiz,true);
           else
              AnadirError(MsgFilaColumna() + " ROUTEANDTOUCH sentences allowed in Reachin scenes only");


       }else if(palabra != ""){ //----------------------------- NODO --------
           // En este caso debenos tener un nodo.
           LeeNodo(raiz,palabra);
       }else{
          // GetPalabraID_LL ha devuelto "" pero es posible que haya encontrado
          // un caracter que no sea un identificador -> Si es as daremos un
          // mensaje de error y absorveremos el caracter.
          char letra = GetCaracterLL();
          if( (letra != '\0') && !Separador(letra) )
             AnadirError(MsgFilaColumna() + " Unexpected character (ASCII:"+ IntToStr((int)letra) +")" );
       }
   }
   GN=NULL;
   GT=NULL;
   Errores=NULL;
   if(UsandoBarraDeProgreso)
      frmUtilidad->FinalizaProgreso();
   UsandoBarraDeProgreso = false;

   numNodosIndefinidos = Utilidad::NumPalabras(NodosIndefinidos.c_str());

   // Vamos a comprobar si existen nodos indefinidos en la escena y si es as
   // avisaremos al usuario de que puede usar el men de configuracin para
   // registrarlos. Hay que tener en cuenta que si hay errores en la escena
   // no debe aparecer este mensaje porque a veces se encuentran nodos no
   // registrados ficticios debido a errores anteriores.
   if( mostrarMsgNodosIndefinidos && (numNodosIndefinidos > 0) &&
      ( (errores == NULL) || (errores->Count == 0) )   ){
      // Se han encontrado nodos indefinidos -> Mostramos un mensaje:
      if(numNodosIndefinidos <= 10){
         if( numNodosIndefinidos == 1)
            Utilidad::MsgInfo("The following node is not registered: " + NodosIndefinidos,"Advertencia");
         else
            Utilidad::MsgInfo("The following nodes are not registered: " + NodosIndefinidos,"Advertencia");
      }else
         Utilidad::MsgInfo("The file constains unregistered nodes.","Advertencia");

      Utilidad::MsgInfo("To register nodes you can use the setting window.");
   }
   return raiz;
}
//---------------------------------------------------------------------------
//
// CLAVES PARA LA IMPLEMENTACIN DE LA FUNCIN DE LECTURA DE LA ESCENA VRML 
//
/*   CABECERA:
   ------------
  * Todo fichero VRML debe empezar con:
      #VRML V2.0 <encoding type> [optional comment] <line terminator>
  * Debe haber extamente un espacio entre "#VRML" y "V2.0" y tambin debe haber
  exctamente un caracter entre "V2.0" y "<encoding type>" despus puede haber
  haber un comentario hasta el final de la lnea -> Es decir habr que leer
  todos los caraceres hasta que se encuentre un retorno de carro: char(13 y 10).

  * Para nosotros <encoding type> ser siempre "utf8" que indica que el fichero
  usa caractes unicode y en ese caso es legible directamente, en otro caso
  no leeremos el fichero (hay ficheros que usan otro tipo de cdigos).

  * As buscaremos la cadena "#VRML V2.0 utf8" al principio del fichero y leeremos
  el resto de caracteres hasta la siguiente lnea.

    COMENTARIOS
  ---------------
  * Los comentarios empiezan con #. As todos los caracteres que aparezan tras #
  hasta el final de lnea (13 10) sern ignorados. -> EXCEPCION: Cuando el
  caracter # aparece entre " " (interior de una cadena).

     WHITESPACE
  ---------------
  * Todas la palabras en VRML (excepto la cabecera) pueden estar separadas por whitespace.
  * Los caracteres separadores son:
  comas , espacios, tabulaciones, caracteres 10 (linefeeds) y retornos de carro (13).
  * Los caracteres separadores y los comentarios se llaman whitespace.

    TERMINADOR DE LNEA
  -----------------------
   Es un caracter linefeed (0x0a) o un retorno de carro (0x0d).

    NODOS HIJOS DE LA RAIZ
  --------------------------
  *  Una escena VRML est formada por cero o ms sentencias Node, Proto y Route
  en cualquier orden.
  * La sentencia ROUTE no puede aparecer precedida de DEF -> As que para idetentificar
  una sentencia como ROUTE tendremos que buscar la palabra ROUTE.
  * Una sentencia PROTO, puede comenzar con PROTO o EXTERNPROTO. As que buscaremos
  esas palabras en el fichero para identificar una sentencia PROTO. En el resto
  de los casos estaremos ante un NODO.

    SINTAXIS ROUTE
  ----------------------
     ROUTE nodeNameId . eventOutId TO nodeNameId . eventInId ;

    SINTAXIS PROTO
  ----------------------
     Ver Especificacin VRML.

  SINTAXIS NODO
  --------------------------
  Un nodo puede aparecer expresado de estos tres modos:
     Nombre_NodoVRML { cuerpo }
     DEF NombreDado Nombre_NodoVRML { cuerpo }
     USE NombreDado;

  Dentro del cuerpo podemos tener:
     Una sentencia ROUTE -> Para detectar este caso usaremos que debe empezar
                            con la palabra ROUTE.
     Una sentencia PROTO -> Para detectar este caso usaremos que debe empezar
                            con la palabra PROTO o EXTERPROTO.
     Un campo -> En este caso aparecer el nombre del campo seguido de:
           - El valor del campo 
           - una sentencia IS -> Creo que esto solo puede ocurrir en el interior de un PROTO.
*/

//------------------------------------------------------------------------------
NodoArbol * __fastcall GestorVRML::AnadirNodo(AnsiString nombreNodo,NodoArbol *padre){

   if( (nombreNodo == "") || (padre == NULL) )
      return NULL;

   NodoArbol *nuevo,*hijo;

   // Lo primero es obtener los datos del gestor de nodos.
   Nodo *datosNodo;
   datosNodo = GN->DatosNodo(nombreNodo);
   if(datosNodo == NULL){
      AnadirError(MsgFilaColumna() + "The node " + nombreNodo + " is not registered");
      return NULL;
   }

   // Ya tenemos los datos del nodo. Ahora creamos un nuevo nodo del arbol y
   // asignamos sus campos.
   nuevo = frmEscena->CrearNodo(NODO);

   nuevo->nodoAsociado=NULL;
   nuevo->padre=padre;
   padre->hijos->Set((void *) nuevo,padre->hijos->MaxIndexUsado()+1);
   // Por comodidad usamos un puntero a los datos del nuevo nodo.
   TipoNodo *nuevoNodo = nuevo->AsNodo();
   nuevoNodo->nombre=nombreNodo;
   // nuevoNodo->nombreDado   Se asigna despus.
   nuevoNodo->datosNodo=datosNodo;
   nuevoNodo->nombreDado="";

   return nuevo;
}
//------------------------------------------------------------------------------
NodoArbol * __fastcall GestorVRML::AnadirNodoGenerico(AnsiString nombreNodo,NodoArbol *padre){

   if( (nombreNodo == "") || (padre == NULL) )
      return NULL;

   NodoArbol *nuevo,*hijo;

   // Lo primero es obtener los datos del gestor de nodos.
   Nodo *datosNodo = GN->NodoGenerico;
   if(datosNodo == NULL){
      AnadirError(MsgFilaColumna() + "Can not create the node " + nombreNodo);
      return NULL;
   }

   // Ya tenemos los datos del nodo. Ahora creamos un nuevo nodo del arbol y
   // asignamos sus campos.
   nuevo = frmEscena->CrearNodo(NODO);

   if(nuevo == NULL)
      return NULL;

   nuevo->nodoAsociado=NULL;
   // Vinculamos padre e hijo:
   nuevo->padre=padre;
   padre->hijos->Set((void *) nuevo,padre->hijos->MaxIndexUsado()+1);

   // Por comodidad usamos un puntero a los datos del nuevo nodo.
   {
      TipoNodo *pnodo = nuevo->AsNodo();

      pnodo->nombre=nombreNodo;
      // pnodo->nombreDado   Se asigna despus.
      pnodo->nombreDado="";
      pnodo->datosNodo=datosNodo;
   }

   // Solo falta crear el campo del nodo genrico:
   hijo = frmEscena->CrearNodo(CAMPO);

   // Asignamos los valores del nodo del arbol que acabamos de crear.
   hijo->nodoAsociado=NULL;  // Se asignar al crear el TreeNode (abajo).
   // Vinculamos padre e hijo:
   hijo->padre=nuevo;
   nuevo->hijos->Set((void *) hijo,nuevo->hijos->MaxIndexUsado()+1);

   // Ya tenemos el campo hijo->dato apuntando a una nueva estructura DatosCampo
   // Por comodidad usamos:
   {
      TipoCampo *nuevoCampo = hijo->AsCampo();

      if( (nuevoCampo != NULL) && (datosNodo->campos != NULL) && (datosNodo->campos[0] != NULL) ){
         nuevoCampo->nombre     = datosNodo->campos[0]->nombre;
         nuevoCampo->datosCampo = datosNodo->campos[0];
         nuevoCampo->valor      = datosNodo->campos[0]->valorPorDefecto;
         nuevoCampo->tipoCampo  = SIMPLE;
      }
   }
   return nuevo;
}
//------------------------------------------------------------------------------
NodoArbol *__fastcall GestorVRML::CrearElemento(TipoNodoArbol tipo){
   NodoArbol *elemento;
   try{    elemento= new NodoArbol(tipo); }
   catch(...){ Utilidad::FatalErrorFaltaMemoria(); }
   return elemento;
}
//------------------------------------------------------------------------------
bool __fastcall GestorVRML::ChequeaPrimeraLinea(AnsiString cad){
  // Esta es la cadena que debe aparecer en los ficheros VRML 2.0 que vamos a leer.
  return (1 == cad.Pos(PRIMERA_LINEA_VRML ));
}
//-----------------------------------------------------------------------------
NodoArbol * __fastcall GestorVRML::CreaCampo(NodoArbol *nodo,AnsiString nombreCampo){

   if( (nodo == NULL) || (!nodo->EsNodo()) )
      return NULL;

   Nodo *datosNodo= nodo->AsNodo()->datosNodo;
   NodoArbol *hijo;

   for(int i=0; i < datosNodo->numCampos ; i++){

       if(nombreCampo == (AnsiString) datosNodo->campos[i]->nombre ){
           // En este caso hemos encontrado el nodo.

           // creamos un hijo.
           hijo = frmEscena->CrearNodo(CAMPO);

           // Asignamos los valores del nodo del arbol que acabamos de crear.
           hijo->nodoAsociado=NULL;  // Se asignar al crear el TreeNode (abajo).
           hijo->padre=nodo;
           nodo->hijos->Set((void *) hijo,nodo->hijos->MaxIndexUsado()+1);

           // Ya tenemos el campo hijo->dato apuntando a una nueva estructura DatosCampo
           // Por comodidad usamos:
           TipoCampo *nuevoCampo = hijo->AsCampo();

           nuevoCampo->nombre     = datosNodo->campos[i]->nombre;
           nuevoCampo->datosCampo = datosNodo->campos[i];
           nuevoCampo->valor      = datosNodo->campos[i]->valorPorDefecto;

           if(datosNodo->campos[i]->tipo->numHijos == 1)
              nuevoCampo->tipoCampo = SFNODE;
           else if(datosNodo->campos[i]->tipo->numHijos == 2)
              nuevoCampo->tipoCampo = MFNODE;
           else
              nuevoCampo->tipoCampo = SIMPLE;

           // Salimos del bucle.
           return hijo;
       }
   }
   return NULL;
}
//-----------------------------------------------------------------------------
bool __fastcall GestorVRML::CreaRestoCampos(NodoArbol *nodo){

   if( (nodo == NULL) || (!nodo->EsNodo()) )
      return false;

   Nodo *datosNodo= nodo->AsNodo()->datosNodo;

   for(int i=0; i < datosNodo->numCampos ; i++){

       if( NULL == GetHijo(nodo, datosNodo->campos[i]->nombre ) ){
           // En este caso no existe el campo -> lo aadimos:
           if(! CreaCampo(nodo,datosNodo->campos[i]->nombre) )
              return false;
       }
   }
   return true;
}
//-----------------------------------------------------------------------------
void __fastcall GestorVRML::FinalizaAnadirLineaEF(){

   if(numLineaEF == 0)
      return;
   while(numLineaEF < LineasEF->Count)
       // Borramos la ltima cadena.
       LineasEF->Delete(LineasEF->Count-1);
}

//-----------------------------------------------------------------------------
void __fastcall GestorVRML::EscribirElementoVRML(NodoArbol *elemento,TStrings *lineas){
   IniciaAnadirLineaEF(lineas);
   EscribirElemento(elemento,0,true);
   FinalizaAnadirLineaEF();
}
//-----------------------------------------------------------------------------
void __fastcall GestorVRML::IniciaAnadirLineaEF(TStrings *lineas){

    LineasEF=lineas;
    numLineaEF=0;
}
//-----------------------------------------------------------------------------
void __fastcall GestorVRML::AnadirLineaEF(AnsiString &cad,bool enOtraLinea){
   // No compruebo que lineas sea != NULL para ahorrar tiempo -> No habr errores
   // si se usan bien las funciones.
   if( (enOtraLinea) || (numLineaEF==0) ){
       LineasEF->Append(cad);
       numLineaEF++;
    }else
       LineasEF->Strings[numLineaEF-1] = LineasEF->Strings[numLineaEF-1] + " " + cad;
}
//------------------------------------------------------------------------------
void __fastcall GestorVRML::AnadirError(AnsiString error){
   NumErrores++;
   if( NumErrores >= MAX_NUM_ERRORES )
      FinalizaLL();
   if(Errores == NULL)
      return;
   Errores->Append(error);
}
//------------------------------------------------------------------------------
void __fastcall GestorVRML::Escribe_AnsiStringsToLines(AnsiString &cad){

    int fin=cad.Length();
    int c=1;
    int cont,pos;

    while( c <= fin ){

        cont=0;
        pos=c;
        while( (c <= fin) && ( (cad[c]!=(char)13) || ( (c+1 <= fin) && (cad[c+1]!=(char)10)) ) ){
           c++;
           cont++;
        }
        AnadirLineaEF(cad.SubString(pos,cont));
        c+=2;  // Para absorver el caracter 10.
    }
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeePROTO(NodoArbol *padre){
    if(padre == NULL)
       return;

    // En primer lugar creamos el nuevo nodo en memoria.
    NodoArbol *proto=CrearElemento(PROTO);

    // Leemos y asignamos el identificador:
    proto->AsProto()->nombre = GetPalabraID_LL(padre);

    NodoDefsEnPROTOs = NodoDefsEnPROTOs + " " + proto->AsProto()->nombre + " ";    

    // Ahora nos colocamos en el corchete  '['
    AbsorveWhiteSpaceLL(padre);

    if('[' != GetCaracterLL(true) ){
       AnadirError(MsgFilaColumna() + " Format error in PROTO sentence, it was expected [");
       delete proto;
       return;
    }

    // Ahora leemos las declaraciones del interfaz.
    LeeInteriorLlave1Llave2('[',']',proto->AsProto()->interfaz);

    // Ahora nos colocamos sobre la llave '{'
    AbsorveWhiteSpaceLL(padre);

    if('{' != GetCaracterLL(true) ){
       AnadirError(MsgFilaColumna() + " Format error in PROTO sentence, it was expected {");
       delete proto;
       return;
    }

    // Leemos y asignamos el cuerpo del proto:
    LeeInteriorLlave1Llave2('{','}',proto->AsProto()->cuerpo);

    // Vinculamos padre e hijo.
    proto->padre=padre;
    padre->hijos->Set((void *)proto,padre->hijos->MaxIndexUsado()+1);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeEXTERNPROTO(NodoArbol *padre){
    if(padre == NULL)
       return;

    // En primer lugar creamos el nuevo nodo en memoria.
    NodoArbol *externProto=CrearElemento(EXTERNPROTO);

    // Leemos y asignamos el identificador:
    externProto->AsExternProto()->nombre = GetPalabraID_LL(padre);

    NodoDefsEnPROTOs = NodoDefsEnPROTOs + " " + externProto->AsExternProto()->nombre + " ";

    // Ahora nos colocamos en el corchete  '['
    AbsorveWhiteSpaceLL(padre);

    if('[' != GetCaracterLL(true) ){
       AnadirError(MsgFilaColumna() + " Format error in EXTERNPROTO sentence, it was expected [");
       delete externProto;
       return;
    }

    // Ahora leemos las declaraciones del interfaz.
    LeeInteriorLlave1Llave2('[',']',externProto->AsExternProto()->interfaz);

    // Ahora nos colocamos sobre '\"'  "["
    AbsorveWhiteSpaceLL(padre);

    char letra = GetCaracterLL(true);

    if( ('[' != letra) && ('\"' != letra) ){
       AnadirError(MsgFilaColumna() + " Format error in EXTERNPROTO sentence, it was expected \" or [");
       delete externProto;
       return;
    }

    if(letra == '\"'){
       // En este caso solo tenemos una cadena -> La leemos:
       // El primer caracter que lea LeeString() debe ser " as que:
       RetrocedeCaracterLL();
       externProto->AsExternProto()->url = LeeString();
    }else{
       // En este caso tenemos que leer el interior de los corchetes:
       // Leemos y asignamos el valor mfString.
       LeeInteriorLlave1Llave2('[',']',externProto->AsExternProto()->url);
    }

    // Vinculamos padre e hijo.
    externProto->padre=padre;
    padre->hijos->Set((void *)externProto,padre->hijos->MaxIndexUsado()+1);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeInteriorLlave1Llave2(char llave1,char llave2,AnsiString &cad){
   // Asumimos que estamos tras la llave { (llave1). Podemos tener "{ " o bien
   // texto til tras la llave "{ texto til", as:

   // El Buffer no debe ser compartido por las funciones, avisaremos con un
   // mensaje si se produce esta situacin indeseada.
   if(UsandoBuffer)
      Utilidad::MsgInfo("The Read/Write buffer is being shared","Advertencia");
   UsandoBuffer=true;
   IndexBuffer=0;

   char letra = GetCaracterLL(true);
   char letraAnterior = '\0';

   // Guardamos en cad todo lo que encontremos hasta llegar a }, teniendo en
   // cuenta que podran aparecer { } dentro del nodo:
   int nLlaves = 0;

   // Necesitaremos dos variables para controlar cuando estamos dentro de un
   // comentario y dentro de una cadena.
   bool enComentario = false;
   bool enCadena = false;

   while( (letra != '\0') && !( (letra == llave2) && (nLlaves == 0) && !enComentario && !enCadena) ){

      // Lo primero es aadir la letra al buffer:
      Buffer[IndexBuffer++]=letra;
      if(IndexBuffer+1 >= TAM_BUFFER){
         Buffer[IndexBuffer]='\0';
         cad+=Buffer;
         IndexBuffer=0;
      }

      // Ahora hay que controlar el nivel de anidamiento de llaves y el fin de lnea:
      if( (letra == llave1) && !enComentario && !enCadena ){
         nLlaves++;
      }else if( (letra == llave2) && !enComentario && !enCadena ){
         if(nLlaves != 0)
            nLlaves--;
         else
           AnadirError(MsgFilaColumna() + " Unexpected "+ (AnsiString) llave2);
      }else if(letra == '#'){
         // En este caso tenemos que absorver el resto de caracteres hasta el
         // final de la lnea ignorando posibles { }
         enComentario = true;

      }else if(letra == '\"'){
         // En este caso tenemos que leer todo el texto hasta encontrar las
         // comillas de cierre. Tenidendo en cuenta que si aparece \" hay que
         // ignorar esas comillas. Esto se hace para ignorar las { } que pueda
         // haber dentro de una cadena.
         if( (letraAnterior != '\0') && (letraAnterior != '\\') )
            enCadena=!enCadena;

      }else if(letra == (char)13){
         enComentario = false;
         // En este caso aadimos adems el caracter 10.
         Buffer[IndexBuffer++]=(char)10;
         if(IndexBuffer+1 >= TAM_BUFFER){
            Buffer[IndexBuffer]='\0';
            cad+=Buffer;
            IndexBuffer=0;
         }
      }
      letraAnterior = letra;
      letra=GetCaracterLL(true);
   }

   // solo falta aadir el contenido del buffer a cad:
   Buffer[IndexBuffer]='\0';
   cad+=Buffer;
   IndexBuffer=0;

   UsandoBuffer=false;

   // Queremos evitar los separadores al final de los datos -> porque hay
   // RCs que molestan, as:
   int c,pos=0;
   for(c=cad.Length(); c > 0 ; c--){
      // Vamos desde el final hasta que se encuentre un caracter que no sea
      // un separador.
      if(!Separador(cad[c])){
          pos=c;
          break;  // salimos del bucle.
      }
   }
   // Ya tenemos la cadena sin los separadores
   cad=cad.SubString(1,pos);

   // Finalmente tenemos que considerar estos dos casos:
   //   CASO 1:  NodoGenerico{ datos }
   //   CASO 2:  NodoGenerico{
   //                  datos
   //            }
   // El cdigo anterior funcionar bien en el primer caso y en el segundo caso
   // aadir un caracter RC adicional debido al RC que hay tras la llave {
   // As que intentamos eliminar ese RC si es que lo hay:
   c=1;
   int fin = cad.Length();
   while( (c <= fin) && ( (cad[c] == ' ') || (cad[c] == (char)0x9) ) )
      c++;
   // Hemos absorvido todos los espacios y tabuladores Absorvemos ahora el RC
   // si es que existe:
   if( (c <= fin) && (cad[c] == (char)0xd) ){
      c++;
      if( (c <= fin) && (cad[c] == (char)0xa) ){
         c++;
         if(c <= fin)
            cad = cad=cad.SubString(c,fin-c+1);
      }
   }
}



