//
//    GESTOR VRML         
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Permite leer y escribir ficheros X3D/H3D.    */
//---------------------------------------------------------------------------

#ifndef GestorVRML_H
#define GestorVRML_H

#include "frmEscena_.h"
#include "ArbolParserXML_.cpp"

//ParserXML
#include "LibXmlComps.hpp"
#include "LibXmlParser.hpp"


// Prefijo para identificar los nodos no registrados al pasar del traductor XML -> VRML
#define PREF_NODOS_NO_REGISTRADOS "NotRegisteredNode_"

//---------------------------------------------------------------------------
// Esta clase implementa todas las operaciones necesarias para trabajar con
// ficheros VRML. As los datos en memoria se pueden salvar a un fichero VRML y
// viceversa. En lugar de un fichero VRML se puede trabajar con un tipo TStrings
// esto es util para usar componentes TMemo. Esto facilita las operaciones cuando
// se edita el fichero VRML usando un control TMemo.
class GestorVRML{
private:
    //------------------------------------------------ VARIABLES PRIVADAS ------
    // Para cargar los datos de la escena se hace una lectura lineal del contenido
    // de una variable TStrings que contiene las lneas del fichero VRML.
    // Hay varias funciones relacionadas con esta lectura lineal. Estas funciones
    // usarn estas variables:       (LL = Lectura Lineal)
    int LL_NumCadena;      // Identifica qu cadena de LL_Lineas se est leyendo.
    AnsiString LL_CadenaActual; // Cadena que se est leyendo actualmente.
    char *LL_cad;           // puntero a la cadena que se est leyendo actualmente.
    int LL_Index;          // Indice de la cadena que se est leyendo.
    TStrings *LL_Lineas;   // Contiene todas las lneas que forman la escena.
    bool LL_Finalizada;    // Indicar cuando se ha acabado la lectura.

   // Para no tener que reservar memoria byte a byte en tipos AnsiString en las
   // operaciones de Lectura/Escritura se usa un buffer.
   char *Buffer;
   int IndexBuffer;           // Indice actual del buffer.
   bool UsandoBuffer;         // El buffer no puede ser usado por dos funciones a la
                              // vez. Esta variable controla el acceso al buffer.



     //ParserXML
      TXmlScanner *XmlScanner;

    // Para ficheros de muchas lneas se mostrar una ventana de progreso con el
    // porcentaje procesado. Esta variable indica si se est mostrando esta vetana
    // o no.
    bool UsandoBarraDeProgreso;

    // Para escribir las escenas tambin se usa algo similar a la lectura lineal.
    // Se usan las siguientes variables acabadas en EF (Escritura de Ficheros)
    TStrings *LineasEF;      // Es la variable donde se escribir el contenido de la escena.
    int numLineaEF;          // Nmero de lneas escritas en el LineasEF

    // Cuando se lee o se escribe un script python es necesario desactivar el
    // anidamiento, con esta variable controlamos este estado.
    bool AnidamientoAnulado;

    // Cuenta el nmero de elementos escritos.
    int ElementosEscritos;


    // Cuando se encuentra un nodo no registrado se considera como un nodo
    // genrico. Tener un nodo no registrado puede deberse a dos causas:
    //  1 Que sea un nodo definido en sentencias PROTO o EXTERNPROTO.
    //  2 Que sea un nodo Indefinido, por ejemplo un nodo creado con C++ de X3D.
    // Tras cargar una escena se avisar al usuario si hay nodos no definidos.
    // Pero para distinguir los dos casos anteriores tenemos que usar esta variable
    // en la que se almacenarn durante la carga del fichero todos los nombres
    // de nodos definidos en sentencias PROTO y EXTERNPROTO.
    // Hay que tener en cuenta algo: Cuando queramos localizar el nombre del
    // nodo "Shape" dentro de esta variable, tendremos que buscar " Shape " para
    // evitar encontrar subcadenas.
    AnsiString NodoDefsEnPROTOs;

    // Para no sobrecargar demasiado el paso de parmetros en las funciones
    // recursivas de lectura se usan variables globales con los datos de los
    // nodos y tipos que se estn procesando.
    GestorNodos *GN;
    GestorTipos *GT;

    // En la ejecucin de algunas funciones se pueden producir varios errores.
    // Esta variable global apunta a un tipo TStrings donde se irn guardando
    // estos errores.
    TStrings *Errores;

    // Es un contador del nmero de errores que se producen al cargar una escena.
    int NumErrores;

    // Al cargar una escena podemos encontrar nodos no registrados que se cargan
    // como nodos genricos. Esta variable contiene los nombres de los nodos
    // indefinidos que se encuentran al cargar la escena. Solo se usa para informar
    // al usuario de qu nodos no se han reconocido.
    AnsiString NodosIndefinidos;

    //------------ParserXML-----------------------//
    
    // Estructura de arbol donde se almacena la informacin de la escena procedente
    // del parserXML. Es un paso previo a la generacin del cdigo en codific VRML
    // que entiende el parser por defecto de Disreal
    ArbolXML ArbolParseo;
    
    // nivelLectura se utiliza para la correcta tabulacin del cdigo
    int nivelLectura;
    
    // El cdigo completo de un archivo XML se compone del cdigo de la escena en si
    // mismo y el cdigo de la cabecera que puede llegar a ser bastante complejo
    // o al menos voluminoso. Se utilizan dos TStrings para separar ambas partes
    // El TString cabecera se utiliza como variable de paso para almacenarla en el 
    // nodo Raiz de la escena (en un AnsiString cabecera)
    TStrings *SceneLocal,*SceneLines, *Cabecera; //*archivoCompleto,
    
    // El cdigo en codific VRML procedente del arbolParseo se almacena en el TStrings
    // Parseo. Esta informacin se genera en la LecturaRecursiva y para la escritura
    // en este TStrings se utiliza la funcin AddCadena (ninguna otra funcin accede
    // a esta variable)
    TStrings *Parseo;
    
    // En la generacin del cdigo en codific VRML se pierde la info de tipo de nodo
    // para un nodo tipo USE. Esta informacin es completamente necesaria para el XML
    // de salida del programa, pero no es compatible introducirla en el VRML.
    // Para solucionar esto en la escritura del cdigo se registran los pares def 
    // como nombreDado.tipoNodo, y en el momento en que se utiliza un USE se busca
    // el nombreDado para conocer el tipo del Nodo.
    AnsiString registroDefUse;

    //-- Prototipos de Funciones --//
        
    //AnsiString __fastcall GetAttributes(AnsiString TagName, TAttrList *Attributes, int especificarPadre, int vacio);
    
    // Para la generacin del cdigo VRML se utiliza un TStringList Parseo y para 
    // escribir en este nicamente se ha utilizado la funcin AddCadena. 
    // Esta funcin adems tabula las lneas introducidas.
    void __fastcall AddCadena(AnsiString Cadena, int Tipo, int nivel);
    
    // Esta funcin no-recursiva recoge la informacin obtenida con el ParserXML 
    // y rellena una instancia de la clase Arbol llamada arbolParseo.
    // Con cada llamada a la funcin se procesa un nodo y se elige sobre que 
    // nodo del arbol se situa para la siguiente iteraccin.
    NodoXml* __fastcall FormaArbol(NodoXml *nodoActual);
    
    // Se debe obtener la informacin del campo containerField. En muchos casos
    // la informacin se omite por ser el valor por defecto y es aqui donde se
    // debe recurrir al Gestor de Nodos en busca de esta informacin.
    AnsiString __fastcall defaultContainerField(AnsiString nombreNodo);
    //void LecturaRecursiva(Nodo *nodo);
    
    // La generacin del cdigo VRML se realiza con la siguiente funcin recursiva
    // utilizando el Arbol arbolParseo lo recorre y genera un TStringList 
    // almacenando la informacin tabulada en el mediante la funcin AddCadena
    void LecturaRecursiva2(NodoXml *nodo);
    
    // En ocasiones no deseamos interpretar el cdigo dentro de un nodo. Esos
    // casos especiales son los Protos (ProtoDeclare, ProtoInstance, ExternProtoDeclare)
    // y Stripts. Se utiliza la siguiente informacin para leerlo entero y almacenarlo
    // como un slo AnsiString (code)
    void leerProto(NodoXml *nodoProto);

    // En cada lectura de una etiqueta en XML se debe obtener adems los
    // atributos o campos del nodo. El parserXML ofrece facilidades para
    // obtener esta informacin mediante una lista TAttrList. 
    // La funcin GetAttributesNodo procesa esa lista obteniendo los
    // campos DEF, USE y containerField por separado del resto de los
    // atributos. Adems en esta funcin se procesan los ROUTEs ya que
    // la informacin de estos viene en forma de atributos.
    void __fastcall GetAttributesNodo(TAttrList *Attributes, NodoXml *nodo);
    
    // Esta es una particularizacind de la funcin anterior. No se quiere
    // la informacin del resto de los campos sino que nicamente la correspondiente
    // al containerField. Esto ocurre en algunos nodos especiales como son los 
    // ProtoInstance o los Scripts. El resto de la informacin del nodo se lee sin
    // interpretar, pero es necesario saber en que campo del nodo padre cuelga
    // el nodo especial en cuestin.
    void __fastcall GetAttrContainerField(TAttrList *Attributes, NodoXml *nodo);

    // Esta funcin es recursiva y escribe en this->lineas la informacin que hay en nodo.
    void __fastcall PrintTree(TStrings *lineas,NodoXml *nodo, int nivel = 0);

    //------------FIN ParserXML-----------------------//



    //------------------------------------------------ FUNCIONES PRIVADAS ------
    // Cuando se quiere cargar una escena VRML desde una variable TStrings hay
    // que llamar a la funcin IniciaLecturaLineal para indicar que se quiere
    // comenzar la lectura. Una vez que esto se haya hecho se podr llamar a las
    // funciones que irn devolviendo los datos almacenados en Lineas, por
    // ejemplo GetPalabra().
    // Devuelve un booleano indicando si se puede iniciar la lectura. Solo se
    // devuelve false si no hay datos en Lineas.
    bool __fastcall IniciaLL(TStrings *Lineas);
    // Esta funcin acaba la LL. No es necesario llamarla para que la LL acabe.
    // Se usa solo cuando hay que acabar la LL de modo prematuro, por ejemplo,
    // por encontrar muchos errores en el fichero.
    void __fastcall FinalizaLL();

    // Una vez que se ha iniciado la lectura lineal se puede usar esta funcin
    // que absorver todo el WhiteSpace que haya a partir de la posicin actual.
    // Si se encuentra un comentario se aadir como ltimo hijo de padre.
    // Una vez absorvido el WhiteSpace se leen todos los caracteres que sean
    // CaracteresIDValido() y se dejar la posicin de lectura justo despus de
    // la ltima palabra leida.
    // Cuando se acaban los datos devuelve una cadena vaca.
    AnsiString __fastcall GetPalabraID_LL(NodoArbol *padre);

    // Similar a GetPalabra. Devuelve un caracter y avanza en 1 la posicin de
    // lectura. Cuando se acaban los datos devuelve el caracter nulo '\0'.
    // Si devolver RC's es true se devolver un caracter (char)13 cada vez que
    // se cambie de linea.
    char __fastcall GetCaracterLL(bool devolverRCs=false);
    // Retrasa 1 posicin la LL actual. Cada cambio de lnea se considera una
    // posicin.
    void __fastcall RetrocedeCaracterLL();
    // Devuelve una cadena que contiene el texto que hay entre la posicin actual
    // y el final de la lnea (la posicin actual se avanza a la siguiente lnea.
    AnsiString __fastcall GetRestoLineaLL();
    // Esta funcin usa la lectura lneal actual para avanzar la posicin de
    // lectura hasta el primer caracter que encuentre que no se WhiteSpace ni
    // comentarios. Los comentarios que va encontrando los va aadiendo como
    // hijos del parmetro padre.
    void __fastcall AbsorveWhiteSpaceLL(NodoArbol *padre);
    // Las funciones siguientes devuelven la fila y la columna actual en la LL.
    int __fastcall GetFilaLL();
    int __fastcall GetColumnaLL();

   //  En ficheros muy grandes los mensajes de error pueden ser demasiados ya que
   // el parser puede estar leyendo cualquier cosa as que por seguridad, lo
   // ms recomendable es limitar el nmero mximo de errores de la escena.
   // Cuando lleguemos al nmero mximo de errores dejaremos de leer la escena.
   // As esta funcin aade error a la lista de errores y adems detiene la LL
   // si el nmero de errores supera el lmite dado por MAX_NUM_ERRORES
   void __fastcall AnadirError(AnsiString error);


    // Las siguientes funciones se usan al escribir la escena para hacer la
    // escritura ms rpida y evitar tener que reescribir toda la escena completamente.
    // Solo se escribirn las lneas que sea necesario escribir -> As se ahorra
    // tiempo y se evita que el cdigo se desplace en la pantalla cada vez que
    // moficica alguna lnea:
    // La primera funcin prepara las variables para la escritura en lineas.
    void __fastcall IniciaAnadirLineaEF(TStrings *lineas);
    // Esta funcin aade una lnea a lineas (de IniciaAnadirLineas). Solo se
    // aade la lnea cuando es necesario.
    // Si enOtraLinea es true se crear una nueva lnea en la que se aadir cad.
    // si es false se aadir a continuacin de la ltima pabra de la ltima lnea
    // aadiendo " " antes de cad.
    void __fastcall AnadirLineaEF(AnsiString &cad,bool enOtraLinea=true);
    void __fastcall AnadirLineaEF_(AnsiString cad,bool enOtraLinea=true);  // -> Para evitar Warnings al compilar
    // Se encarga de borrar las lneas que sobren del final del fichero.
    void __fastcall FinalizaAnadirLineaEF();


    // Esta funcin devuelve la cadena que recibe con
    //  nivel * CONF.FICH_VRML_NUM_CARACTERES_JUSTIF caracteres ' '.
    inline void __fastcall Anida(AnsiString &cad,int nivel);

    // Devuelve verdadero si cad corresponde a la primer lnea de un fichero VRML
    // versin 2.0 y codificado con utf8
    // #VRML V2.0 utf8
    bool __fastcall ChequeaPrimeraLinea(AnsiString cad);

    // Recibe una cadena que puede tener RC's. Esta funcin escribe cadenas
    // teniendo en cuenta los saltos de lnea y el nivel de jutificado.
    // Tambin tiene en cuenta el anidamiento del cdigo VRML si aparecen los
    // caracteres [ y ]
    // numCaracteresAdicionales es el nmero de caracteres ' ' que se aadirn para anidar.
    void __fastcall EscribeValorCampo(AnsiString &campo, int nivel,int numCaracteresAdicionales = 0);

    // Es una funcin recursiva que escribe elemento y todos sus hijos
    // considerando nivel que es el nivel de profundidad que se usa para
    // justificar el texto.
    // A veces al escribir un elemento por ejemplo un nodo queremos escribirlo
    // a continuacin de la ltima palabra aadida sin cambiar de lnea, por ejemplo
    // cuando escribimos un nodo dentro de un campo SFNode as en este caso
    // pasaremos anidarPrimeraLinea a false.
    void __fastcall EscribirElemento(NodoArbol *elemento,int nivel,bool anidarPrimeraLinea);
    void __fastcall EscribirElementoXML(NodoArbol *elemento,int nivel,bool anidarPrimeraLinea);
//    void __fastcall EscribirElementoVRML(NodoArbol *elemento,int nivel,bool anidarPrimeraLinea);
    // Escribe el contenido de cad en la EF actual. Lo hace convirtiendo los RCs
    // en lineas. No tiene en cuenta el anidamiento del cdigo.
    void __fastcall Escribe_AnsiStringsToLines(AnsiString &cad);

    // Usa la lectura lineal actual y lee el resto de la lnea actual creando un
    // nodo NodoArbol de tipo COMENTARIO que se aade como hijo del parmetro
    // pasado. Para que funcione bien la posicin actual de la lectura lineal
    // antes de llamar a LeeComentario debe ser un caracter '#'.
    void __fastcall LeeComentario(NodoArbol *padre);

    // Esta funcin crea un nodo NodoArbol de tipo RUTADO con la informacin que
    // encuentra a partir de la posicin actual de la lectura lineal. Se asume que
    // la ltima palabra que se ley fue ROUTE.
    // Las escenas H3D pueden contener elementos ROUTEANDTOUCH, para leer
    // estos elementos pasamos a true el segundo parmetro.
    void __fastcall LeeRutado(NodoArbol *padre,bool routeandtouch);

    // Esta funcin crea un nodo NodoArbol de tipo PROTO con la informacin que
    // encuentra a partir de la posicin actual de la lectura lineal. Se asume que
    // la ltima palabra que se ley fue PROTO.
    void __fastcall LeePROTO(NodoArbol *padre);

    // Esta funcin crea un nodo NodoArbol de tipo PROTO con la informacin que
    // encuentra a partir de la posicin actual de la lectura lineal. Se asume que
    // la ltima palabra que se ley fue EXTERNPROTO.
    void __fastcall LeeEXTERNPROTO(NodoArbol *padre);

    // Crea en memoria un nodo nuevo con los datos leidos de la lectura lineal
    // actual y aade este nodo nuevo como hijo de padre.
    // Es una funcin recursiva porque un nodo puede contener otros.
    // La funcin LeeNodo llama a LeeCampo. Y debido que dentro de un campo
    // puede haber declarado un nodo (SFNODE y MFNODE) ocurre que LeeCampo puede
    // volver a llamar a LeeNodo(). De este modo la recursividad se establece
    // entre estas dos funciones.
    // Recibe la primera palabra que pertenece a la definicin del nodo.
    void __fastcall LeeNodo(NodoArbol *padre,AnsiString palabra);

    // Esta funcin asume que ya se ha leido la llave lave1 '{' de un nodo y
    // guarda en cad todo el texto que encuentra hasta la siguiente '}' teniendo en
    // cuenta que pueden aparecer pares '{''}' en el interior. Adems ignora las
    // llaves que aparezcan dentro de comentarios y dentro de cadenas.
    // Deja la Lectura lineal tras '}'
    // Realmente llave1='{' y llave2='}'
    // Pero tb podemos usar esta funcin cambiando llave1 y llave2 por [].
    void __fastcall LeeInteriorLlave1Llave2(char llave1,char llave2,AnsiString &cad);

    // Lee el contenido de un campo SFNode teniendo en cuenta la definicin VRML.
    // Se le pasa la primera palabra que forma parte del valor del campo SFNode -> es
    // necesario pasar palabra porque que la funcin que llama LeeSFNode necesita
    // decidir que hacer en funcin de esa palabra.
    void __fastcall LeeSFNode(NodoArbol *campo,AnsiString palabra);

    // Esta funcin lee y asigna los datos al campo campo.
    // Debido a que dentro de un campo puede haber declarado un nodo (SFNODE y MFNODE)
    // esta funcin puede llamar a LeeNodo. Y a su vez LeeNodo llama a esta funcin.
    // La recursividad se establece de este modo entre estas dos funciones.
    void __fastcall LeeCampo(NodoArbol *padre, NodoArbol *campo);

    // Crea el nodo nombreNodo en memoria sin incluir sus campos y sin crear nodos
    // asociados. Devuelve NULL si nombreNodo no es uno de los nodos registrados.
    NodoArbol * __fastcall AnadirNodo(AnsiString nombreNodo,NodoArbol *padre);

    // Crea un nodo Generico de nombre nombreNodo en memoria incluyendo su campo.
    // No crea nodos asociados.
    NodoArbol * __fastcall AnadirNodoGenerico(AnsiString nombreNodo,NodoArbol *padre);

    // Esta funcin usa la LL actual para leer los datos de un campo que no es SFNODE
    // ni MFNODE, puede ser cualquier otro tipo, por ejemplo MFString etc.
    // Los datos pueden ser o no aparecer entre [].
    // Las cadenas de caracteres se leern de forma atmica para evitar que se
    // confunda su contenido con identificadores VRML. Hay que tener en cuenta
    // que en el interior de una cadena puede aparecer la construccin \" para
    // indicar que esas " forman parte de los datos de la cadena y no para
    // indicar su final.
    // Recibe padre para registrar los comentarios que se encuentren y texto
    // para devolver los datos.
    void __fastcall LeeCampoSIMPLE(NodoArbol *padre,AnsiString &texto);

    // Lee una cadena de texto de la LL actual. Se considera que la cadena de
    // texto aparece entre comillas dobles "..." es posible que en el interior
    // de la cadena aparezca el caracter " precedido de \ para indicar que esas
    // comillas forman parte de la cadena y no sealan su final.
    // Si el primer caracter que se lee de la LL no es " se devuelve "".
    // El texto que se devuelve incluye las comillas de inicio y fin.
    // Si se alcanza el final del fichero antes de encontrar las comillas de
    // cierre avisa con un mensaje de error.
    AnsiString __fastcall LeeString();


    // Busca el campo de nombre <campo> entre los hijos de padre y devuelve un
    // puntero al hijo encontrado. Si no se encuentra se devuelve NULL.
    NodoArbol* __fastcall GetHijo(NodoArbol *padre,AnsiString nombreCampo);

    // Devuelve una cadena con la fila y la columna entre parntesis de la LL
    // actual. Se usa en los mensajes de error.
    AnsiString __fastcall MsgFilaColumna();

    // Reserva memoria para un nodo NodoArbol -> devuelve siempre un puntero
    // vlido pq si no se puede reservar memoria se acaba el programa.
    NodoArbol *__fastcall CrearElemento(TipoNodoArbol tipo);

    // Crea en memoria un elemento de tipo NodoArbol que contiene el campo de
    // nombre NombreCampo del nodo Nodo y se aade en Nodo como ltimo hijo.
    // Si no se encuentra el hijo -> no se crear en memoria y se devuelve NULL.
    NodoArbol * __fastcall CreaCampo(NodoArbol *nodo,AnsiString nombreCampo);

    // Crea en memoria los campos de nodo que no se han creado an. Devuelve false
    // si no se puede crear algn nodo.
    bool __fastcall CreaRestoCampos(NodoArbol *nodo);

    // Devuelve una cadena que permite navegar por el rbol de la escena hasta
    // localizar un nodo concreto. As podra devolverse una cadena del tipo:
    // "\Transform\Shape\Material"
    AnsiString __fastcall GetLocationCode(NodoArbol *nodo);

    // Devuelve un nombre descriptivo asociado al elementos que se pasa segn el
    // tipo de elemento: 
    AnsiString __fastcall GetNombre(NodoArbol *nodo);

public:
    //------------------------------------------------ VARIABLES PBLICAS------
    //------------------------------------------------ FUNCIONES PBLICAS------
    // Devuelve true si el caracter pasado es un separador (segn la especificacin
    // VRML se considerarn separadores los caracteres: Espacio, Tabulador,
    // Retorno de Carro, Fin de Linea y Coma.
    bool __fastcall Separador(const char c);

    // Devuelve verdadero si el caracter pasado puede usarse en un nombre dado
    // a un identificador VRML. Nota: En VRML se distingue entre el primer caracter
    // de un identificador y el resto, esta funcin no hace esa distincin y devuelve
    // true si el caracter puede aparecer en el identificador sin concretar donde
    // podra hacerlo.
    bool __fastcall CaracterIDValido(const char c);

    // Escribe un fichero VRML con la informacin almacenada en el disco.
    // Los campos VRML que tengan como dato un valor igual al valor por defecto
    // no se escribirn.
    // La funcin est sobrecargada. Se puede pasar un puntero a TString y
    // entonces la estructura de datos se guardar en lineas en formato VRML.
    // (se borrarn todas las lneas que hubiese anteriormente).
    //  EscribeFichero no funcionar correctamente si la estructura de datos
    // contiene errores. Es necesario asegurarse de que no hay errores llamando
    // a la funcin  ChequeaEscenaVRML().
    // Si existe el fichero se sobrescribir.
    // Para escenas con muchos elementos es posible mostrar una barra de progreso
    // para ello habr que pasar NumElementos.
    // Si NumElementos > MIN_NUM_ELEMENTOS_PARA_SEGUIMIENTO se mostrar la barra
    // de progreso.
    bool __fastcall EscribeFichero(NodoArbol *raiz,int NumElementos);
    bool __fastcall EscribeFichero(NodoArbol *raiz,TStrings *lineas,int NumElementos);

    // Es una funcin que escribe elemento y todos sus hijos en lineas.
    void __fastcall EscribirElementoVRML(NodoArbol *elemento,TStrings *lineas,TipoRaiz *raiz);

    // Esta funcin lee una escena VRML de lineas y devuelve un puntero NodoArbol
    // al nodo raiz de la escena. Los nodos asociados no se crean (todos a NULL).
    // Los errores detectados durante la ejecucin se almacenan en errores.
    // errores puede ser NULL si no se desea recibir ningn mensaje de error.
    // Es posible que la escena contenga otros errores, por ello es recomendable llamar
    // a la funcin ChequeaEscenaVRML() una vez que la escena se haya cargado.
    // Esto se hace as por dos motivos: En primer lugar la implentacin de esta
    // funcin ser as ms fcil y en segundo lugar ser mucho ms rpida.
    // fichero es el nombre del fichero asociado a la escena. Se pasa este nombre
    // para asignar los datos del nodo raiz pero no se lee ese fichero-> la
    // informacin de la escena se lee de lineas.
    // A veces puede interesarnos leer solo parte de una escena VRML -> entonces
    // pasamos procesa cabecera a false (por defecto true).
    // Tambin se indica el tipo de escena que se quiere cargar H3D o X3D.
    // Al cargar la escena se pueden encontrar nodos no definidos que se cargaran
    // como nodos genricos. Se mostrar un mensaje de advertencia de que si se
    // pasa mostrarMsgNodosIndefinidos a true. Adems numNodosIndefinidos
    // contiene devolver (siempre) el nmero de nodos indefinidos que se hayan
    // encontrado.
    NodoArbol * __fastcall CargaEscena(TStrings *lineas,TStrings *errores,AnsiString fichero,
                                       TipoEscena tipoEscena,bool mostrarMsgNodosIndefinidos,
                                       int &numNodosIndefinidos,bool ProcesaCabecera=true);

    // Costructor y destructor de la clase.
    __fastcall GestorVRML();
   __fastcall ~GestorVRML();    
};
#endif

// Creamos un objeto GestorVRML para que se pueda usar externamente:
extern GestorVRML GVRML;
