//
//    GESTOR VRML         
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Permite leer y escribir ficheros X3D/H3D.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <Filectrl.hpp>
#include "GestorVRML_.h"

//ParserXML
#pragma link "LibXmlComps"
#pragma link "LibXmlParser"


#include "frmUtilidad_.h"
#include "Configuracion_.h"


// Al leer ficheros que tengan ms de MIN_NUM_LINEAS_PARA_SEGUIMIENTO se mostrar
// una barra de progreso con el porcentaje actual procesado.
#define MIN_NUM_LINEAS_PARA_SEGUIMIENTO 5000
// Anlogamente en la escritura se cuentan al nmero de elementos escritos.
#define MIN_NUM_ELEMENTOS_PARA_SEGUIMIENTO 500
// Es el nmero de lneas que se espera entre llamadas a la funcin que
// actualiza la barra de progreso.
#define NUM_LINEAS_PARA_PROGRESO 500

// Es el nmero mximo de errores que se consideran antes de dejar de leer la escena.
#define MAX_NUM_ERRORES 25

// Para no tener que reservar memoria byte a byte en tipos AnsiString en las
// operaciones de Lectura/Escritura se usa un buffer de tamao:
#define TAM_BUFFER 50000


#pragma package(smart_init)

// Creamos un objeto GestorVRML para que se pueda usar externamente:
GestorVRML GVRML;

//------------------------------------------------------------------------------
__fastcall GestorVRML::GestorVRML()
{
    IndexBuffer=0;
    UsandoBuffer=false;
    AnidamientoAnulado=false;    
    LL_NumCadena=0;
    LL_cad=NULL;
    LL_CadenaActual="";
    LL_Index=0;
    LL_Lineas=NULL;
    GN=NULL;
    GT=NULL;
    Errores=NULL;
    LineasEF=NULL;
    LL_Finalizada= false;
    numLineaEF=0;
    ElementosEscritos=0;
    NumErrores = 0;
    UsandoBarraDeProgreso = false;
    try{ Buffer     = new char[TAM_BUFFER];
         XmlScanner = new TXmlScanner(XmlScanner); }
    catch(...){ Utilidad.FatalErrorFaltaMemoria(); }
    Cabecera   = new TStringList();
    SceneLocal = new TStringList();
    SceneLines = NULL;
}
//------------------------------------------------------------------------------
__fastcall GestorVRML::~GestorVRML()
{
   try
   {
      if(Buffer     != NULL)    delete Buffer;
      if(XmlScanner != NULL)    delete XmlScanner;
      if(SceneLocal != NULL) {  SceneLocal ->Clear(); delete SceneLocal; }
      if(Cabecera   != NULL) {  Cabecera   ->Clear(); delete Cabecera  ; }
   }
   catch(...){}
}
//------------------------------------------------------------------------------
inline void __fastcall GestorVRML::Anida(AnsiString &cad,int nivel){
   if(AnidamientoAnulado)
      cad="";
   else
      cad=cad.StringOfChar(' ',nivel * CONF.FICH_NUM_CARACTERES_JUSTIF);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::EscribeValorCampo(AnsiString &campo,int nivel,int numCaracteresAdicionales)
{
    // Obtenemos el nivel de anidamiento base en una cadena:
    AnsiString blanco,dato;
    Anida(blanco,nivel);

    // Aadimos el nmero adicional de ' '
    if(numCaracteresAdicionales > 0)
       blanco += AnsiString::StringOfChar(' ', numCaracteresAdicionales);

    int fin,pos,cont,c;

    fin=campo.Length();
//    int indexCorcheteCierre = campo.Pos(']');
//    if(indexCorcheteCierre != 0)
//       fin = indexCorcheteCierre-1;

    // Vamos a eliminar el corchete [ si es que existe.
    c=1;
/*    
    if(indexCorcheteCierre != 0)
    {
       int indexCorcheteInicial = campo.Pos('[');
       if(indexCorcheteInicial > 0)
          c = indexCorcheteInicial+1;
    } */

    bool corcheteEncontrado=false;

    // En el siguiente bucle vamos obteniendo cada lnea y aadiendola a LineasEF
    while( c <= fin )
    {
        cont=0;
        pos=c;
        while( (c <= fin) && ( (campo[c]!=(char)13) || ( (c+1 <= fin) && (campo[c+1]!=(char)10)) ) ){
           if(']' == campo[c])
              corcheteEncontrado=true;
           c++;
           cont++;
        }
        dato = campo.SubString(pos,cont);

        if(corcheteEncontrado){
           // Podemos tener como ltima lnea 123] o bien ] as querramos tener:
           //  campo [ 123                  campo [ 123
           //          123        o bien            123
           //          123]                         123
           //                               ]
           if (dato.Trim().Length() == 1)
              // Caso de la derecha
              Anida(blanco,nivel);
           //else
              // Caso de la izquierda (que no es necesario pq blanco ya tiene
              // esa longitud.
              // Anida(blanco,nivel+1);
        }

        // Hemos encontrado una cadena, la aadimos.
        AnadirLineaEF_(blanco+dato);

        c+=2;  // Para absorver el caracter 10.
    }
}
//------------------------------------------------------------------------------
bool __fastcall GestorVRML::EscribeFichero(NodoArbol *raiz, TStrings *lineas,int NumElementos)
{
   if((raiz == NULL) || (lineas == NULL))
      return false;

   ElementosEscritos=0;
   UsandoBarraDeProgreso = (NumElementos >= MIN_NUM_ELEMENTOS_PARA_SEGUIMIENTO);
   if(UsandoBarraDeProgreso)
       frmUtilidad->IniciaProgreso("Building Scene...",NumElementos,"",false);

   AnsiString cad;  // En esta cadena escribiremos cada linea del fichero.

   // Iniciamos la escritura en lineas.
   IniciaAnadirLineaEF(lineas);

   // Disreal soporta codificacin VRML y XML. El tratamiento de las cabeceras es
   // distinto para cada tipo de codificacin.

   // Lo primero es aadir la lnea que deben tener todos los ficheros VRML/H3D.
   // An debe ser cambiada la palabra H3D. La lnea de cabera ha cambiado pero
   // el esquema es el mismo.
   switch ( raiz->AsRaiz()->tipoEscena ){
      case ESCENA_X3D:
           GN=Main->GNX;
           GT=Main->GTX;
      break;
      case ESCENA_H3D: ;
           GN=Main->GNH;
           GT=Main->GTH;
      break;
   }

   if (raiz->AsRaiz()->tipoCodificacion=="VRML")
   {
     if(  raiz->AsRaiz()->tipoEscena == ESCENA_X3D )
         AnadirLineaEF(CONF.PRIMERA_LINEA_FICH_X3D);
     else if(  raiz->AsRaiz()->tipoEscena == ESCENA_H3D ){
         if(CONF.PRIMERA_LINEA_FICH_H3D != "")
           AnadirLineaEF(CONF.PRIMERA_LINEA_FICH_H3D);
     }

     // Los archivos H3D son poco extrictos encuanto a la inclusin o no de cabecera
     // es posible encontrarloss sin ella y el usuario querr tener un archivo igual
     // como producto del programa. En cualquier momento es posible incluirla en el editor
     if (raiz->AsRaiz()->cabecera!="NO\r\n")
     {
       AnadirLineaEF(raiz->AsRaiz()->cabecera);  //escribimos la cabecera obtenida del archivo leido
     }
   }else{ // Codificacin XML

     if (raiz->AsRaiz()->cabecera=="")
     {
       // Esta es la cabecera ms tpica que se ha observado de los archivos de XML.
       // Es curioso que en los archivos H3D es posible que no aparezca, aparezca en parte
       // no parezca el encapsulado <Scene> o aparezca el cdigo sin encapsulado pero con cabecera
       AnadirLineaEF_("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
       AnadirLineaEF_("<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 3.0//EN\" \"http://www.web3d.org/specifications/x3d-3.0.dtd\">");
       AnadirLineaEF_("<X3D version='3.0' profile='Immersive'>");
       AnadirLineaEF_("  <Scene>");

     // El tratamiento para los archivos que incluyen cdigo de cabecera en la entrada.
     // El usuario debe tener un archivo igual al que introdujo en la salida si no realiza
     // cambios mediante Disreal.
     }
     else if (raiz->AsRaiz()->cabecera!="NO\r\n")
     {
       AnsiString cabecera = raiz->AsRaiz()->cabecera;
       // Vamos a eliminar los caracteres ' ' \n \r que haya al final:
       int index = cabecera.Length();
       while( (index > 0) && ((cabecera[index] == ' ') || (cabecera[index] == '\n') || (cabecera[index] == '\r')) )
          index--;
       if(index > 0)
       {
          cabecera = cabecera.SubString(1,index);
          AnadirLineaEF(cabecera);  //escribimos la cabecera obtenida del archivo leido
       }
     }
   }

   // Vamos a escribir uno por uno todos los hijos del nodo raiz. Cada uno
   // de sus hijos ser un elemento que habr que escribir recursivamente.
   // Este elemento puede ser un nodo, un vinculo de rutado etc.
   int c=0;
   NodoArbol *elemento;
   while(c <= raiz->hijos->MaxIndexUsado()){
       elemento= (NodoArbol *) raiz->hijos->Get(c);
       if(elemento != NULL) // Llamamos a la funcin que escribe recursivamente el elemento.
       {
          // Dependiendo del tipo de codificacin se llama a una funcin de escritura de elementos u otra.
          // la funcion EscribirElemento no tiene una referencia a VRML en su nombre pq ya existe una funcin
          // del cdigo original con ese nombre y ocasionaba problemas.
          if (raiz->AsRaiz()->tipoCodificacion=="XML")
            EscribirElementoXML(elemento,2,true);
          else {
            EscribirElemento(elemento,2,true);
          }
       }
       c++;
   }

   // En caso de que existiera encapsulado del cdigo debe incluirse el final correspondiente.
   if((raiz->AsRaiz()->tipoCodificacion=="XML")&&(raiz->AsRaiz()->cabecera!="NO\r\n"))
   {
        AnadirLineaEF_("  </Scene>");
        AnadirLineaEF_("</X3D>");
   }

   FinalizaAnadirLineaEF();

   if(UsandoBarraDeProgreso)
      frmUtilidad->FinalizaProgreso();
   UsandoBarraDeProgreso = false;
   return true;
}
//------------------------------------------------------------------------------
void __fastcall GestorVRML::EscribirElementoXML(NodoArbol *elemento,int nivel,bool anidarPrimeraLinea)
{
   if( elemento == NULL )
      return;

   int numHijosEscritos=0;
   ElementosEscritos++;
   if(UsandoBarraDeProgreso)
        frmUtilidad->ActualizaProgreso(ElementosEscritos,"");

   AnsiString cad;  // Usaremos esta variable para escribir cada linea en formato VRML.

   // Lo primero es ver si hay que desactivar la justificacin o no:
   if( (elemento->padre != NULL) && (elemento->padre->EsNodo()) ){
      // (Incluimos los espacios para evitar encontrar subcadenas).
      AnidamientoAnulado = ( 0 != CONF.NODOS_SIN_ANIDAMIENTO.Pos( (AnsiString) " " + elemento->padre->AsNodo()->nombre + " " ) );
   }

   // Hay que distinguir qu tipo de elemento tenemos.
   if(elemento->EsNodo()){         //------------------------  NODO  -------
      // Para declarar un nodo hay que usar la siguiente sitaxis segn la
      //especificacin VRML 2.0
      //          nodeStatement ::=
      //                       node |
      //                       DEF nodeNameId node |
      //                       USE nodeNameId ;
      //
      //          node ::=
      //                       nodeTypeId { nodeBody } |
      //                       Script { scriptBody } ;
      //  De momento no vamos a considerar el caso USE.
      //
      // Volvemos a asignar el anidamiento pq en este caso no depende del padre
      // sino del propio nodo. (Incluimos los espacios para evitar encontrar subcadenas).
      AnidamientoAnulado = ( 0 != CONF.NODOS_SIN_ANIDAMIENTO.Pos( (AnsiString)" " + elemento->AsNodo()->nombre + (AnsiString)" " ) );

      if(anidarPrimeraLinea)
         Anida(cad,nivel);   // Ya tenemos la cadena justificada:
      else
         cad = "";
      NodoArbol *hijo;

    // Existe un tratamiento distinto para los nodos normales del usado para Protos y Scripts. Estos ltimos se
    // leen sin ser interpretados. Son elementos de programacin muy flexibles que ofrecen mucha libertad para crear
    // nodos completamente nuevos. De la misma manera exigen un alto grado de interpretacin del cdigo para poder
    // ser incluidos correctamente, algo que se encuentra fuera de las capacidades de un editor de cdigo.

    Nodo *datosNodoActual = NULL;
    int longitNombreNodo = 0;
    //AnsiString nombreNodoDebug = elemento->AsNodo()->nombre; // para debugear
    if ( (GN!=NULL) && (elemento!=NULL) && (elemento->EsNodo()) && (elemento->AsNodo()->nombre!=NULL) )
    {
       datosNodoActual = GN->DatosNodo(elemento->AsNodo()->nombre);
       longitNombreNodo = elemento->AsNodo()->nombre.Length();
    }
    //if (GN==NULL)
    //AnsiString nombreNodoDebug = elemento->AsNodo()->nombre;

    if ( (elemento->AsNodo()->nombre!= "ProtoDeclare") && (elemento->AsNodo()->nombre!= "ProtoInstance")
           && (elemento->AsNodo()->nombre!= "ExternProtoDeclare") && (elemento->AsNodo()->nombre!="Script")
           && (datosNodoActual!=NULL) )
           //&& ( (GN!=NULL) && (GN->NumeroDeNodo(elemento->AsNodo()->nombre) !=-1) ) )
    {

      // Incluimos la etiqueta de inicio del nodo.
      if( (elemento->AsNodo()->nombreDado == NULL ) ||
          (elemento->AsNodo()->nombreDado.Trim() == "" )  )
          // En este caso no hay que usar DEF.
          cad+= "<" + elemento->AsNodo()->nombre + " ";
      else   // Hay que usar DEF:
      {
          cad+= "<" + elemento->AsNodo()->nombre + "   DEF='" + elemento->AsNodo()->nombreDado + "' ";
          // vemos que no se cierra la etiqueta de inicio puesto que puede contener los atributos.

          // Debemos registrar los DEF utilizados ya que ms tarde habr una referencia en el cdigo a estos
          // y en XML se exige que el tipo de nodo que incluya el USE sea del mismo tipo que el nodo DEF de
          // origen. Esta es una informacin que no era necesaria en VRML y se ha perdido en la conversin.
          registroDefUse+=(AnsiString)" " +elemento->AsNodo()->nombreDado + "." + elemento->AsNodo()->nombre;
      }
      // Aadimos la lnea.
      if(anidarPrimeraLinea)
         AnadirLineaEF(cad);
      else
         // En este caso aadimos cad sin crear una lnea nueva:
         AnadirLineaEF(cad,false);

      AnsiString atributos=" ";

      bool hijos=FALSE;

      // Realizamos dos pasadas sobre la lista de hijos del nodo actual. En la primera pasada identificamos los hijos
      // que son meros campos simples y se aaden en el archivo final generado. Tambin observamos si existen hijos
      // SFNode o MFNode que van a ser contenedores de otros hijos y a los que se deber procesar recursivamente.
      for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++)
      {
         // Hacemos una llamada recursiva para escribir los elementos hijos del nodo.
         hijo = (NodoArbol *)elemento->hijos->Get(c);

         if(hijo == NULL)  
            continue;

         ElementosEscritos++;

         if ( hijo->EsCampo() && (hijo->AsCampo()->tipoCampo == SIMPLE))
         {
           if( hijo->AsCampo()->valor.Trim() !=
                 ((AnsiString) hijo->AsCampo()->datosCampo->valorPorDefecto)  ){
                // Realizamos una lista con los ndices de los hijos tipo campo simple para el tratamiento posterior
                // de los hijos contenedores.
                atributos+=(AnsiString) c + " ";

                if( hijo->AsCampo()->valor.Trim() != "" ){
                  cad="";
                  //Anida(cad,nivel);
                  // Tenemos que tener cuidado con no recargar con dobles comillas. Se supone que no es incorrecto
                  // en XML, pero supone que el cdigo crezca cada paso por esta funcin.
                  //if ( (hijo->AsCampo()->valor[1]=='\"') || (hijo->AsCampo()->valor[1]=='\''))    -> Esto est comentado pq produce fallos cuando hay que escribir este valor de un campo MFString: "EXAMINE" "ANY"
                  //  cad+= hijo->AsCampo()->datosCampo->nombre + " = " + hijo->AsCampo()->valor;
                  //else
                  {
                    cad+= hijo->AsCampo()->datosCampo->nombre + (AnsiString) " = '";
                    cad+= hijo->AsCampo()->valor + "'";
                  }

                  EscribeValorCampo(cad,nivel+2,longitNombreNodo+3);
                }
           }
         }
         else if ( (hijo->EsCampo()) && ( (hijo->AsCampo()->tipoCampo== SFNODE) || (hijo->AsCampo()->tipoCampo== MFNODE) ) )
         {
             // Si existe un campo hijo contenedor informamos. Esto se hace para identificar que tipo de cierre de etiqueta se
             // debe usar: La de "empty tag" '/>' o la de "start tag" '>' y tratamiento recursivo de hijos.
             if (hijo->hijos->NumElementosNoNulos() > 0)
                hijos=TRUE;
         }
         else if( hijo->EsComentario() || hijo->EsRutado() )
            hijos=TRUE;
      }
      numHijosEscritos=0;
      int hijosElem=elemento->hijos->MaxIndexUsado();
      if (hijos)
      {
        // Existen hijos contenedores luego se utiliza cierre de etiqueta de inicio y se atiende a los hijos.
        AnadirLineaEF_(">",false);
        for(int c=0; c<=hijosElem ; c++)
         {
            hijo = (NodoArbol *)elemento->hijos->Get(c);
            if (hijo!=NULL)
            {
               if(  (0==atributos.Pos((AnsiString)c)) &&
                    ( (!hijo->EsCampo()) || ( (hijo->EsCampo()) && (hijo->AsCampo()->tipoCampo != SIMPLE)) )  )
               {
                  numHijosEscritos++;
                  EscribirElementoXML(hijo,nivel+1,true);
               }
            }
         }
      }

      if(!anidarPrimeraLinea && (nivel > 0) )
         Anida(cad,nivel-1);
      else
         Anida(cad,nivel);


      if (numHijosEscritos == 0)
         // No se han escrito hijos, luego se debe cerrar la etiqueta con el cierre de "empty tag"
         AnadirLineaEF_("/>",false);
      else
         // Se ha incluido al menos un hijo y el cierre de etiqueta se debe realizar en una lnea a parte
         // con la etiqueta de final completa
         AnadirLineaEF_( cad + "</" + elemento->AsNodo()->nombre +">" );

     } else {
       // El tratamiento de Scripts, protos y nodos desconocidos. Recordemos que se ha realizado una lectura completa sin interpretacin
       // lo que quiere decir que se deben escribir con cuidado. El cdigo de cada uno se han introducido como el contenido
       // de un atributo "code". Ahora no se debe incluir el encapsulado ya que esto no existe en XML. Se debe incluir directamente
       // el contenido de ese campo "code".
       for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++)
       {
         hijo = (NodoArbol *)elemento->hijos->Get(c);

         if ((hijo->EsCampo()) && (hijo->AsCampo()->tipoCampo == SIMPLE))
         {
           if( hijo->AsCampo()->valor.Trim() !=
                 ((AnsiString) hijo->AsCampo()->datosCampo->valorPorDefecto)  ){

                if( hijo->AsCampo()->datosCampo->nombre == "code" ){
                      // Se ha incluido el cdigo entre comillas dobles. Ahora se debe tener cuidado de no incluir esas
                      // comillas dobles en el cdigo. Se elimina el primer y ltimo caracter de la AnsiString "code"
                      cad= hijo->AsCampo()->valor;
                      cad=cad.Trim();
                      int longitud=cad.Length();

                      if ( (longitud>0) && (cad[1]=='\"') )
                         cad=cad.SubString(2,longitud -2);

                      //if (cad[cad.Length()]=='\"')
                        // cad[cad.Length()]=' ';

                      EscribeValorCampo(cad,nivel);
                }
           }
         }
       }

      } 

   }else if(elemento->EsCampo()){  //------------------------  CAMPO  ------

          // Esta es la sintaxis de los nodos VRML:
          //    nodeBodyElement ::=
          //        fieldId fieldValue |
          //        fieldId IS fieldId |
          //        eventInId IS eventInId |
          //        eventOutId IS eventOutId |
          //        routeStatement |
          //        protoStatement ;

       // Hay que distinguir el tipo de campo de elemento:
       // Consideramos primero un caso especial, el de campo perteneciente a
       // un nodo genrico:
       if(  (  (elemento->padre->AsNodo()->tipoNodoVRML == NODO_INDEFINIDO) ||
               (elemento->padre->AsNodo()->tipoNodoVRML == NODO_DEFINIDO_EN_PROTOS) ) &&
               (elemento->dato != NULL) ){
           Escribe_AnsiStringsToLines( elemento->AsCampo()->valor );

       }else if(elemento->AsCampo()->tipoCampo == MFNODE){
             if( elemento->hijos->NumElementosNoNulos() >0){
                  // En este caso habr que recorrer todos los hijos del campo
                  // escribiendo cada uno de ellos.

                  // Este es un ejemplo de un campo MFNODE (fooNode)
                  //      fooNode [ Transform { translation 1 0 0 }
                  //           DEF CUBE Box { }
                  //           USE CUBE
                  //           USE SOME_OTHER_NODE  ]
                             
                  NodoArbol *hijo, *nieto;
                  int j;
                  for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++)
                  {   // Hacemos una llamada recursiva para escribir los elementos hijos del nodo.
                     hijo = (NodoArbol *)elemento->hijos->Get(c);
                     // Cuando se realizan ediciones del cdigo a travs del treeview se pueden generar
                     // hijos vacos (se mueven a otros hijos). Hay que cuidar que no suceda.
                     if (hijo!=NULL)
                     {
                       // En algunos casos la informacin de containerField no esta rellena. Aqui rellenamos
                       // ese campo de los hijos. Para ello obtenemos el nombre del nodo padre que contiene
                       // ese hijo campo-simple y rellenamos el valor de los hijos de ese campo-simple
                       // ATENCION para leerlo que envuelve 3 niveles del arbol, pero es simple.
                       // En la escritura si ese valor de containerField es el mismo que el default, no se escribe.
                       for (j=0; j<=hijo->hijos->MaxIndexUsado(); j++)
                       {
                         nieto = (NodoArbol *)hijo->hijos->Get(j);
                         if ( (nieto!=NULL) && (nieto->EsCampo()) && (nieto->AsCampo()->tipoCampo == SIMPLE)
                                && (nieto->AsCampo()->datosCampo->nombre=="containerField") )
                             nieto->AsCampo()->valor=elemento->AsCampo()->datosCampo->nombre;
                       }
                       // Finalmente escribimos el resultado.
                       EscribirElementoXML(hijo,nivel+1,true);
                     }
                  }                 
             }
       
       // Para SFNode es un tratamiento similar al MFNode.      
       }else if(  elemento->AsCampo()->tipoCampo == SFNODE  ){
            // Podemos tener comentarios como hijos-> hacemos un bucle.
            // Tenemos que tener cuidado con el parmetro anidarPrimeraLinea
            // que pasamos a EscribirElemento porque si escribimos un comentario
            // antes que el nodo podramos tener algo como:
            // comentario, por ejemplo # comentario Appearance {
            // Lo vamos a evitar con yaSeHaEscritoUnComentario:
            bool yaSeHaEscritoUnComentario=false;

            for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++){
                NodoArbol *p=(NodoArbol *)elemento->hijos->Get(c),*nieto;

                if( (p!=NULL) && p->EsComentario() ){
                     yaSeHaEscritoUnComentario=true;
                     EscribirElementoXML(p,nivel+1,true);
                }else if( (p!=NULL) && ( p->EsNodo() || p->EsUSE() ) ){
                     // Se hace igual que en el caso MFNODE solo que con un nodo:
                     Anida(cad,nivel);   // Ya tenemos la cadena justificada:                  
                     AnadirLineaEF(cad);
                     // Puede haber ms hijos, como comentarios.
                     for (int j=0; j<=p->hijos->MaxIndexUsado(); j++)
                     {
                       nieto = (NodoArbol *)p->hijos->Get(j);
                       if ( (nieto->EsCampo()) && (nieto->AsCampo()->tipoCampo == SIMPLE)
                                && (nieto->AsCampo()->datosCampo->nombre=="containerField") )
                            nieto->AsCampo()->valor=elemento->AsCampo()->datosCampo->nombre;
                     }
                     // Escribimos el elemento hijo.
                     if(yaSeHaEscritoUnComentario)
                        EscribirElementoXML(p,nivel+1,true);
                     else
                        EscribirElementoXML(p,nivel+1,false);
                }
            }
       }

   }else if(elemento->EsRutado()){ //------------------------  RUTADO  -----
       Anida(cad,nivel);

       AnsiString ROUTE;

       // Ya tenemos cad justificada.
       // La siguiente lnea muestra la sintaxis de una sentencia ROUTE en XML 3.0.
       //      ROUTE nodeNameId.eventOutId TO nodeNameId.eventInId;
       // No hay que comprobar si el vnculo es vlido -> Lo hace ChequeaEscenaVRML()

       // El cdigo de un rutado es simple. Se trata de una etiqueta "vaca" (sin hijos)
       // con la siguiente estructura.
       cad = cad + "<ROUTE fromNode='" + elemento->AsRutado()->nodoOut +"'  fromField='"
                       + elemento->AsRutado()->campoOut;
       cad = cad + "'  toNode='" + elemento->AsRutado()->nodoIn +"'  toField='"
                       + elemento->AsRutado()->campoIn + "'  />";

       AnadirLineaEF(cad);

   }else if(elemento->EsComentario()){ //--------------------  COMENTARIO --
       Anida(cad,nivel);
       // Ya tenemos cad justificada.              
       cad= cad + "<!-- " + elemento->AsComentario()->texto + " -->";
       AnadirLineaEF(cad);
   }else if(elemento->EsUSE()){ //---------------------------  USE  --------
       if(anidarPrimeraLinea)
          Anida(cad,nivel);

       AnsiString tipoObjeto="";
       bool punto=FALSE;
       int pos=registroDefUse.AnsiPos(elemento->AsUSE()->nombreDado);
       
       // En XML el use se utiliza dentro de un nodo del mismo tipo que el DEF correspondiente.
       // Esa informacin no se almacena en cualquier lugar sino que se debe obtener al escribir el
       // cdigo. Como la interpretacin es lineal de arriba a abajo, antes del USE se ha tenido
       // que definir el DEF, luego no hay que hacer varias pasadas al cdigo para obtener esa info.
       if(pos != 0)
       {
          for (int i=pos; i <= registroDefUse.Length(); i++)
          {
                // Se almacena separado por espacios " nombreDado.tipoNodo "
                //Si se encuentra un espacio significa que ha terminado el par
                //Despues del punto viene la informacin requerida, el tipo de nodo del DEF.
                if (registroDefUse[i]==' ')
                   break;

                else if (registroDefUse[i]=='.')
                {
                   punto=TRUE;
                }
                else if (punto)
                   tipoObjeto+=(AnsiString)registroDefUse[i];
          }
       }
       else if(elemento->AsUSE()->nombreTipoNodo != "")
       {
          tipoObjeto = elemento->AsUSE()->nombreTipoNodo;
       }

       if(elemento->dato != NULL)
       {
          cad+= "<"+ tipoObjeto + " USE='" +elemento->AsUSE()->nombreDado + "'";
          // Los nodos tipo USE no tienen containerField, pero es sencillo recuperarlo.
          TipoCampo  *campo = elemento->padre->AsCampo();

          if(campo != NULL)
             cad+= " containerField ='" + campo->datosCampo->nombre + "'";
          cad+= " />";
       }
       if(anidarPrimeraLinea)
          AnadirLineaEF(cad,true);
       else
          AnadirLineaEF(cad,false);
   }

}
//========================VERSION ANTINUA=============================************************
//------------------------------------------------------------------------------
void __fastcall GestorVRML::EscribirElemento(NodoArbol *elemento,int nivel,bool anidarPrimeraLinea){
   if( elemento == NULL )
      return;

   ElementosEscritos++;
   if(UsandoBarraDeProgreso)
        frmUtilidad->ActualizaProgreso(ElementosEscritos,"");

   AnsiString cad;  // Usaremos esta variable para escribir cada linea en formato VRML.

   // Lo primero es ver si hay que desactivar la justificacin o no:
   if( (elemento->padre != NULL) && (elemento->padre->EsNodo()) ){
      // (Incluimos los espacios para evitar encontrar subcadenas).
      AnidamientoAnulado = ( 0 != CONF.NODOS_SIN_ANIDAMIENTO.Pos( (AnsiString) " " + elemento->padre->AsNodo()->nombre + " " ) );
   }

   // Hay que distinguir qu tipo de elemento tenemos.
   if(elemento->EsNodo()){         //------------------------  NODO  -------
      /* Para declarar un nodo hay que usar la siguiente sitaxis segn la
      especificacin VRML 2.0
                nodeStatement ::=
                             node |
                             DEF nodeNameId node |
                             USE nodeNameId ;

                node ::=
                             nodeTypeId { nodeBody } |
                             Script { scriptBody } ;
        De momento no vamos a considerar el caso USE.
      */
      // Volvemos a asignar el anidamiento pq en este caso no depende del padre
      // sino del propio nodo. (Incluimos los espacios para evitar encontrar subcadenas).
      AnidamientoAnulado = ( 0 != CONF.NODOS_SIN_ANIDAMIENTO.Pos( (AnsiString)" " + elemento->AsNodo()->nombre + (AnsiString)" " ) );

      if(anidarPrimeraLinea)
         Anida(cad,nivel);   // Ya tenemos la cadena justificada:
      else
         cad = "";

      if( (elemento->AsNodo()->nombreDado == NULL ) ||
          (elemento->AsNodo()->nombreDado.Trim() == "" )  )
          cad = cad + elemento->AsNodo()->nombre  +" {";       // En este caso no hay que usar DEF.
      else   // Hay que usar DEF:
          cad = cad + "DEF " + elemento->AsNodo()->nombreDado +
                         " " + elemento->AsNodo()->nombre + " {";

      // Aadimos la lnea.
      if(anidarPrimeraLinea)
         AnadirLineaEF(cad);
      else
         // En este caso aadimos cad sin crear una lnea nueva:
         AnadirLineaEF(cad,false);

      // Vamos a evitar que la llave de cierre } se escriba en la siguiente
      // lnea cuando no se ha escrito nada dentro del nodo, por ejemplo
      // vamos a evitar este tipo de construcciones:
      //  Box{
      //    }
      // Para ello usamos numLineasTmp;
      int numLineasTmp = numLineaEF;

      // El siguiente paso es escribir todos los miembros del nodo.
      for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++)
         // Hacemos una llamada recursiva para escribir los elementos hijos del nodo.
         EscribirElemento((NodoArbol *)elemento->hijos->Get(c),nivel+1,true);

      // y finalmente se escribe la llave }
      if(!anidarPrimeraLinea && (nivel > 0) )
         Anida(cad,nivel-1);
      else
         Anida(cad,nivel);

      // Aadiremos } en la ltima lnea sin crear una lnea nueva cuando al
      // escribir los hijos del nodo no haya aumentado el nmero de lneas:
      if(numLineaEF == numLineasTmp)
         AnadirLineaEF_("}",false);
      else
         AnadirLineaEF_( cad + "}" );

   }else if(elemento->EsCampo()){  //------------------------  CAMPO  ------

          /* Esta es la sintaxis de los nodos VRML:
              nodeBodyElement ::=
                  fieldId fieldValue |
                  fieldId IS fieldId |
                  eventInId IS eventInId |
                  eventOutId IS eventOutId |
                  routeStatement |
                  protoStatement ;                                       */

       // Hay que distinguir el tipo de campo de elemento:
       // Consideramos primero un caso especial, el de campo perteneciente a
       // un nodo genrico:
       if(  (  (elemento->padre->AsNodo()->tipoNodoVRML == NODO_INDEFINIDO) ||
               (elemento->padre->AsNodo()->tipoNodoVRML == NODO_DEFINIDO_EN_PROTOS) ) &&
               (elemento->dato != NULL) ){
           Escribe_AnsiStringsToLines( elemento->AsCampo()->valor );

       }else if(elemento->AsCampo()->tipoCampo == MFNODE){
             if( elemento->hijos->NumElementosNoNulos() >0){
                  // En este caso habr que recorrer todos los hijos del campo
                  // escribiendo cada uno de ellos.

                  /* Este es un ejemplo de un campo MFNODE (fooNode)
                        fooNode [ Transform { translation 1 0 0 }
                             DEF CUBE Box { }
                             USE CUBE
                             USE SOME_OTHER_NODE  ]     */

                  Anida(cad,nivel);   // Ya tenemos la cadena justificada:
                  AnadirLineaEF_(cad + elemento->AsCampo()->datosCampo->nombre + (AnsiString) " [" );

                  for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++)
                     // Hacemos una llamada recursiva para escribir los elementos hijos del nodo.
                     EscribirElemento((NodoArbol *)elemento->hijos->Get(c),nivel+1,true);

                  // Tras Escribir todos los hijos hay que cerrar el corchete.
                  // Puedo reutilizar cad:
                  AnadirLineaEF_(cad + (AnsiString) "]" );
             }
       }else if(  elemento->AsCampo()->tipoCampo == SFNODE  ){
            // Podemos tener comentarios como hijos-> hacemos un bucle.
            // Tenemos que tener cuidado con el parmetro anidarPrimeraLinea
            // que pasamos a EscribirElemento porque si escribimos un comentario
            // antes que el nodo podramos tener algo como:
            // comentario, por ejemplo # comentario Appearance {
            // Lo vamos a evitar con yaSeHaEscritoUnComentario:
            bool yaSeHaEscritoUnComentario=false;

            for(int c=0; c <= elemento->hijos->MaxIndexUsado() ; c++){
                NodoArbol *p=(NodoArbol *)elemento->hijos->Get(c);

                if( (p!=NULL) && p->EsComentario() ){
                     yaSeHaEscritoUnComentario=true;
                     EscribirElemento(p,nivel+1,true);
                }else if( (p!=NULL) && ( p->EsNodo() || p->EsUSE() ) ){
                     // Se hace igual que en el caso MFNODE solo que con un nodo:
                     Anida(cad,nivel);   // Ya tenemos la cadena justificada:
                     AnadirLineaEF_(cad + elemento->AsCampo()->datosCampo->nombre + (AnsiString) " " );

                     // Escribimos el elemento hijo.
                     if(yaSeHaEscritoUnComentario)
                        EscribirElemento(p,nivel+1,true);
                     else
                        EscribirElemento(p,nivel+1,false);
                }
            }
       }else if( elemento->AsCampo()->valor.Trim() !=
                 ((AnsiString) elemento->AsCampo()->datosCampo->valorPorDefecto)  ){
             // Escribiremos el campo nicamente si su valor almacenado es distinto del
             // valor por defecto.

             // En este caso hay que escribir el dato.
             // Hay que distinguir segn que tipo de campo tengamos:
             if(  elemento->AsCampo()->tipoCampo == SIMPLE ){
                 // En este caso tenemos un tipo simple. Hay que tener cuidado
                 // con los retornos de carro que pueden aparecer en la cadena
                 // ya que habra que escribir varias lneas teniendo en cuenta
                 // la justificacin.

                 // Vamos a escribir el valor del campo de modo que si hay que usar
                 // varias lneas se haga de modo que la segunda lnea quede anidada
                 // correctamente.
                 if( elemento->AsCampo()->valor.Trim() != "" ){
                     cad=  elemento->AsCampo()->datosCampo->nombre + (AnsiString) " ";
                     cad+= elemento->AsCampo()->valor;
                     EscribeValorCampo(cad,nivel);
                 }
             }
       }
   }else if(elemento->EsRutado()){ //------------------------  RUTADO  -----
       Anida(cad,nivel);

       AnsiString ROUTE;
       if( elemento->AsRutado()->routeAndTouch )
          ROUTE = "ROUTEANDTOUCH";
       else
          ROUTE = "ROUTE";

       // Ya tenemos cad justificada.
       // La siguiente lnea muestra la sintaxis de una sentencia ROUTE en VRML 2.0.
       //      ROUTE nodeNameId.eventOutId TO nodeNameId.eventInId;
       // No hay que comprobar si el vnculo es vlido -> Lo hace ChequeaEscenaVRML()
       cad= cad + ROUTE + " " + elemento->AsRutado()->nodoOut + "."
                          + elemento->AsRutado()->campoOut;
       cad= cad + " TO ";

       cad= cad + elemento->AsRutado()->nodoIn + "."
                  + elemento->AsRutado()->campoIn;
       AnadirLineaEF(cad);

   }else if(elemento->EsComentario()){ //--------------------  COMENTARIO --
       Anida(cad,nivel);
       // Ya tenemos cad justificada.
       if( 1 != elemento->AsComentario()->texto.TrimLeft().Pos("#") )
          cad= cad + "#" + elemento->AsComentario()->texto;
       else
          cad= cad + elemento->AsComentario()->texto;
       AnadirLineaEF(cad);
   }else if(elemento->EsUSE()){ //---------------------------  USE  --------
       if(anidarPrimeraLinea)
          Anida(cad,nivel);
       else
          cad = "";

       cad= cad + "USE ";
       if(elemento->dato != NULL)
           cad+=  elemento->AsUSE()->nombreDado;

       if(anidarPrimeraLinea)
          AnadirLineaEF(cad,true);
       else
          AnadirLineaEF(cad,false);
   }else if(elemento->EsProto()){ //-------------------------  PROTO -----------
       Anida(cad,nivel);
       // Ya tenemos cad justificada.
       AnadirLineaEF_(cad + "PROTO " + elemento->AsProto()->nombre + " [");
       Escribe_AnsiStringsToLines(elemento->AsProto()->interfaz);
       AnadirLineaEF_(cad + "] {");
       Escribe_AnsiStringsToLines(elemento->AsProto()->cuerpo);
       AnadirLineaEF_(cad + "}");

   }else if(elemento->EsExternProto()){ //-------------------  EXTERNPROTO -----
       Anida(cad,nivel);
       // Ya tenemos cad justificada.
       AnadirLineaEF_(cad + "EXTERNPROTO " + elemento->AsExternProto()->nombre + " [" );
       Escribe_AnsiStringsToLines(elemento->AsExternProto()->interfaz);
       AnadirLineaEF_(cad + "] [");
       Escribe_AnsiStringsToLines(elemento->AsExternProto()->url);
       AnadirLineaEF_(cad + "]");
   }
}

//------------------------------------------------------------------------------
bool __fastcall GestorVRML::EscribeFichero(NodoArbol *raiz,int NumElementos){

   // Volvemos si raiz es null o si el nombre del fichero es una cadena de
   // caracteres vaca (se comprueba que no tenga espacios en blanco ni
   // caracteres de control).
   if( (raiz == NULL) || ( raiz->AsRaiz()->fichero.Trim() == "") )
       return false;

   // En primer lugar hay que ver si la carpeta existe. Si no existe se
   // intentar crearla.
   AnsiString carpeta = ExtractFileDir( raiz->AsRaiz()->fichero.Trim() );
   if(!DirectoryExists( carpeta )){
       Utilidad.MsgInfo(" The folder " + carpeta + " doesn't exist. This folder is going to be created.","Advertencia");

       if(! CreateDir(carpeta)  ){
          Utilidad.MsgInfo(" An error occurred while creating the folder: " + carpeta ,"Error" );
          return false;
       }
   }

   // En este punto tenemos asegurado que la carpeta existe. Ahora hay que crear
   // el fichero (si existe se sobrescribir).
   AnsiString fichero = raiz->AsRaiz()->fichero.Trim();
   // Ahora vamos a crear un objeto TStrings y a escribir la escena en ese objeto.
   TStringList *lineas=NULL;
   try{ lineas= new TStringList; }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   EscribeFichero(raiz,lineas,NumElementos);

   // Ahora solo hay que escribir en el fichero el contenido de lineas.
   Utilidad.SaveToFile(lineas,fichero);

   lineas->Clear();
   delete lineas;
   return true;
}
//---------------------------------------------------------------------------
bool __fastcall GestorVRML::Separador(const char c){
   // Colocamos los caracteres ms frecuentes al principio para ganar velocidad
   // al usar la evaluacin en cortocircuito.
            // Espacio        Tabulador        Retorno de Carro    Fin de Linea          Coma
   return ( (c == ' ') || (c == (char)0x9) || (c == (char)0xd) || (c == (char)0xa) || (c == (char)0x2c) );
}
//---------------------------------------------------------------------------
bool __fastcall GestorVRML::CaracterIDValido(const char c){
   // Esta funcin se ejecuta con mucha frecuencia. Para que la velocidad sea lo
   // mayor posible colocamos antes los casos ms frecuentes:
   if( (c >= 'a') && (c <= 'z') )
      return true;
   if( (c >= 'A') && (c <= 'Z') )
      return true;
   if( (c == ' ') || (c == (char)0x9) || (c == (char)0xd) || (c == (char)0xa) )
      return false;
   // Los nmeros no puede aparecer en un identificador como primer caracter,
   // pero en esta funcin no hacemos ese tipo de distinciones as que devolvemos
   // true si tenemos un nmero:
   if( (c >= '0') && (c <= '9') )
      return true;
   // Ahora tratamos los casos menos frecuentes (valores obtenidos de la especificacin VRML97).
   int n=(int)c;
   if( (n == 0x22) || (n == 0x23) || (n == 0x27) || (n == 0x2c) || (n == 0x2e) || (n == 0x5b) ||
       (n == 0x5c) || (n == 0x5d) || (n == 0x7b) || (n == 0x7d) || (n == 0x7f) || (n == 0x28) || (n == 0x29))
      return false;
   if( (n >= 0x0) && (n <= 0x20) )
      return false;
   return true;                   
}
//---------------------------------------------------------------------------
bool __fastcall GestorVRML::IniciaLL(TStrings *Lineas){
    LL_Finalizada = false;
    LL_NumCadena=0;
    LL_cad=NULL;
    LL_CadenaActual="";
    LL_Index=0;
    LL_Lineas=Lineas;
    if((Lineas != NULL) && (Lineas->Count > 0) ){
       LL_CadenaActual = Lineas->Strings[0].c_str();
       LL_cad = LL_CadenaActual.c_str();
    }else
       return false;
    return true;
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::FinalizaLL(){
  LL_NumCadena = LL_Lineas->Count;
  LL_Finalizada=true;
}
//---------------------------------------------------------------------------
char __fastcall GestorVRML::GetCaracterLL(bool devolverRCs){
    static int cuenta = 0;
    if(LL_cad[LL_Index] != '\0'){
        return LL_cad[LL_Index++];
    }else{
        if((LL_Lineas != NULL) && (LL_Lineas->Count > (LL_NumCadena + 1) ) ){
           // En este caso hay que adelantar la cadena.
           LL_CadenaActual=LL_Lineas->Strings[++LL_NumCadena].c_str();
           LL_cad=LL_CadenaActual.c_str();
           LL_Index=0;
           if(UsandoBarraDeProgreso && ((cuenta++ % NUM_LINEAS_PARA_PROGRESO) == 0) )
              frmUtilidad->ActualizaProgreso(LL_NumCadena,"");

           // No hacemos nada ms en la siguientes iteraciones del bucle se
           // devolver el caracter adecuado -> Es posible que tengamos varias
           // lneas vacas seguidas y haya que hacer varias iteraciones.
           // Pero si devolverRCs es verdadero no seguiremos iterando,
           // simplemente devolveremos el RC.
           if(devolverRCs)
               return (char)13;
           else
               return ' '; // al menos hay que devolver un espacio para que
                           // no se unan palabras de distintas lneas.
        }else{
           // En este caso se han leido todos los datos -> no hacemos nada.
           LL_Finalizada=true;
           return '\0';
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::RetrocedeCaracterLL(){
    if(LL_Index == 0){
        // En este caso tenemos que pasar a la lnea anterior.
        if (LL_NumCadena > 0){
           // Cargamos la cadena anterior.
           LL_CadenaActual=LL_Lineas->Strings[--LL_NumCadena].c_str();
           LL_cad=LL_CadenaActual.c_str();
           // Asignamos index al final de la cadena as tendr que (LL_cad[LL_Index] == '\0')
           LL_Index = LL_Lineas->Strings[LL_NumCadena].Length();
        }
    }else{
          LL_Index--;
    }
    LL_Finalizada = false;
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::GetRestoLineaLL(){

    // El resto de la lnea lo podemos obtener como un puntero a char a la
    // posicin actual.
    AnsiString devolver=(AnsiString) &LL_cad[LL_Index];

    // Hacemos LL_cad[LL_Index] sea '\0' porque lo necesitamos en la condicin
    // del bucle y porque si estamos en la ltima lnea no entraremos en el bucle.
    if(LL_NumCadena < LL_Lineas->Count)
       LL_Index = LL_Lineas->Strings[LL_NumCadena].Length();
    else{
       // En este caso se ha llegado al final del fichero. Actualizamos
       // LL_index para que el prximo caracter leido sea '\0' 
       LL_Index= LL_CadenaActual.Length();
       return devolver;
    }

    // Ahora solo hay que cargar la siguiente lnea:
    while( (LL_Lineas != NULL) && (LL_Lineas->Count > (LL_NumCadena + 1) )
         && (LL_cad[LL_Index]=='\0')   ){
         LL_CadenaActual=LL_Lineas->Strings[++LL_NumCadena].c_str();
         LL_cad=LL_CadenaActual.c_str();
         LL_Index=0;
    }
    return devolver;
}
//---------------------------------------------------------------------------
int __fastcall GestorVRML::GetFilaLL(){
   return LL_NumCadena+1;
}
//---------------------------------------------------------------------------
int __fastcall GestorVRML::GetColumnaLL(){
   return LL_Index;
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::GetPalabraID_LL(NodoArbol *padre){
    if(padre == NULL)
       return "";

    // En primer lugar absorvemos WhiteSpace.
    AbsorveWhiteSpaceLL(padre);

    // Ahora construimos una cadena con todos los caracteres que no sean separadores.
    AnsiString cad="";

    char letra=GetCaracterLL();

    // El bucle acaba cuando se han acabado los datos o cuando el ltimo caracter
    // leido es un separador.
    while( (letra!='\0') && !Separador(letra) && CaracterIDValido(letra) ){
       cad+=letra;
       letra=GetCaracterLL();
    }

    // Debemos dejar la posicin de LL justo tras la palabra leida.
    if( (letra!='\0') &&  (Separador(letra) || !CaracterIDValido(letra)) )
       RetrocedeCaracterLL();

    return cad;
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeComentario(NodoArbol *padre){
    if(padre == NULL)
       return;

    // En primer lugar creamos el nuevo nodo en memoria.
    NodoArbol *comentario=CrearElemento(COMENTARIO);

    // Obtenemos el resto de la lnea.
    AnsiString tmp = GetRestoLineaLL();
    if( (tmp.Length() > 0) && (tmp[1] == '#') )
    {
       comentario->AsComentario()->texto = tmp.SubString(2,tmp.Length()-1);
    }
    else
       comentario->AsComentario()->texto = tmp;

    // Vinculamos padre e hijo.
    comentario->padre=padre;
    padre->hijos->Set((void *)comentario,padre->hijos->MaxIndexUsado()+1);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::AbsorveWhiteSpaceLL(NodoArbol *padre){

   if(padre == NULL)
       return;

   char letra=GetCaracterLL();
   while( Separador(letra) || (letra == '#')  ){

      if(letra == '#'){
          RetrocedeCaracterLL();  // Nos colocamos sobre el caracter '#'
          LeeComentario(padre);
      }
      letra=GetCaracterLL();
   }
   // Es necesario retroceder un caracter porque el ltimo valor de letra ya no
   // pertenece al WhiteSpace. Pero hay una excepcin letra = '\0' -> se ha llegado
   // al final del fichero.
   if(letra != '\0')
      RetrocedeCaracterLL();
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::GetLocationCode(NodoArbol *nodo)
{
   if(nodo == NULL)
      return "\\ ";

   AnsiString nombres = "";
   while(nodo->padre != NULL)
   {
      if(nodo->padre->hijos == NULL)
         return "\\ ";  // pq es una anomala -> no debera ocurrir nunca.

      if(nodo->EsNodo())
         nombres = (AnsiString)"\\" + GetNombre(nodo) + nombres;

      nodo = nodo->padre;
   }

   // Es peferible que no sea una cadena vaca para que el procesado de estas cadenas sea ms sencillo.
   if(nombres.Trim() == "")
      nombres = "\\";

   return nombres + " ";
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::GetNombre(NodoArbol *nodo)
{
   if(nodo == NULL)
      return "";

   switch(nodo->tipo)
   {
      case RAIZ        : return "Scene";  // break;
      case NODO        : if(nodo->AsNodo()  != NULL) return nodo->AsNodo()->nombre + ((nodo->AsNodo()->nombreDado != "") ? ((AnsiString)":" + nodo->AsNodo()->nombreDado) : (AnsiString)"");  break;
      case CAMPO       : if(nodo->AsCampo() != NULL) return nodo->AsCampo()->nombre; break;
      case RUTADO      : return "ROUTE";  // break;
      case PROTO       : return "PROTO";  // break;
      case EXTERNPROTO : return "EXTERNPROTO";  // break;
      case COMENTARIO  : return "COMMENT";  // break;
      case USE         : return "USE";  // break;
   }
   return "";
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeRutado(NodoArbol *padre,bool routeandtouch){

    if(padre == NULL)
       return;

    // En primer lugar creamos el nuevo nodo en memoria.
    NodoArbol *rutado=CrearElemento(RUTADO);

    rutado->AsRutado()->routeAndTouch = routeandtouch;

    // A continuacin tendremos el nombre del nodo seguido de un punto  de
    // whiteSpace (incluido comentarios) as que no nos vale lee palabra y hay
    // que construir el identificador del nodo caracter a caracter.
    char letra;
    AnsiString NodoInID,NodoOutID,EventInID,EventOutID;

    //. . . . . . . . . . . . . . . . . . . . . . . . . LECTURA NodoOutID . . .
    NodoOutID=GetPalabraID_LL(padre);
    AbsorveWhiteSpaceLL(padre);
    if('.' != GetCaracterLL()){
         delete rutado;
         return;
    }
    // La LL est tras el punto '.' as:
    //. . . . . . . . . . . . . . . . . . . . . . . . . LECTURA EventOutID . . .
    // La siguiente palabra debe ser EventOutID.
    EventOutID=GetPalabraID_LL(padre);

    // La siguiente palabra debe ser TO si no ser un error.
    if( ((AnsiString)"TO") != GetPalabraID_LL(padre) ){
         AnadirError(GetLocationCode(padre) + "Error in ROUTE sentence");
         delete rutado;
         return;
    }

    //. . . . . . . . . . . . . . . . . . . . . . . . . LECTURA NodoInID . . .
    // Hemos absorvido "TO" y solo queda leer NodoInID y EventInID.
    NodoInID=GetPalabraID_LL(padre);
    AbsorveWhiteSpaceLL(padre);
    if('.' != GetCaracterLL()){
         delete rutado;
         return;
    }
    //. . . . . . . . . . . . . . . . . . . . . . . . . LECTURA EventInID . . .
    // La siguiente palabra debe ser EventOutID.
    EventInID=GetPalabraID_LL(padre);

    // Ya tenemos las palabras que aparecen en el fichero X3D/H3D ahora hay
    // que asignarlas:
    rutado->AsRutado()->nodoOut  = NodoOutID;
    rutado->AsRutado()->campoOut = EventOutID;
    rutado->AsRutado()->nodoIn   = NodoInID;
    rutado->AsRutado()->campoIn  = EventInID;

    // Hay que aadir este nuevo nodo al elemento padre:
    rutado->padre=padre;
    padre->hijos->Set((void *)rutado,padre->hijos->MaxIndexUsado()+1);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeNodo(NodoArbol *padre,AnsiString palabra){

    if( (padre == NULL) || (GN == NULL) )
       return;

    /* Al leer un nodo podemos tener:
        Nombre_NodoVRML { cuerpo }
        DEF NombreDado Nombre_NodoVRML { cuerpo }
        USE NombreDado
      Comprobaremos cada uno de estos casos. En Primer lugar USE porque en ese
    caso bo habr que crear un nodo en memoria.*/
    if(palabra == "USE"){
       // Este es un caso especial que tratamos por separado.
       // Leemos el identificador del nodo que se quiere usar:
       AnsiString nombreDado = GetPalabraID_LL(padre);

       // Tenemos que crear un nodo nuevo de tipo USE y asignarlo.
       // En primer lugar creamos el nuevo nodo en memoria.
       NodoArbol *nodoArbol=CrearElemento(USE);
       // Asignamos sus datos:
       nodoArbol->AsUSE()->nombreDado=nombreDado;

       // Vinculamos padre e hijo.
       nodoArbol->padre=padre;
       padre->hijos->Set((void *)nodoArbol,padre->hijos->MaxIndexUsado()+1);

       return;
    }

    // Vamos a leer el nombre del nodo VRML y el nombre que se ha dado al nodo
    // en el caso de usar DEF.
    AnsiString nombreNodoVRML="";
    AnsiString nombreDado="";

    if(palabra == "DEF"){
        // Obtenemos el nombre dado al nodo:
        nombreDado=GetPalabraID_LL(padre);
        // Leemos el nombre del nodo X3D/H3D. Hay que tener cuidado porque
        // entre el nombre del nodo y la { podemos tener 0 o ms separadores.
        nombreNodoVRML=GetPalabraID_LL(padre);
        // Ahora absorvemos la llave que puede venir precedida o no de WhiteSpace.
        AbsorveWhiteSpaceLL(padre);
        if( '{' != GetCaracterLL() ){
           AnadirError(GetLocationCode(padre) + "Error in node: " + nombreNodoVRML);
           return;
        }
    }else{
       // En este caso palabra es directamente el nombre del nodo VRML.
       nombreNodoVRML=palabra;
       // Ahora absorvemos la llave que puede venir precedida o no de WhiteSpace.
       AbsorveWhiteSpaceLL(padre);
        if( '{' != GetCaracterLL() ){
           AnadirError(GetLocationCode(padre) + "Error in node: " + nombreNodoVRML);
           return;
        }
    }

    NodoArbol *nuevoNodo; // =NULL; comentado para evitar el warning "is assigned a value thar is never used

    if( NULL != GN->DatosNodo(nombreNodoVRML) ){
       // A continuacin creamos un nuevo nodo VRML en frmEscena.
       nuevoNodo=AnadirNodo(nombreNodoVRML,padre);
    }else{
       // No se ha encontrado el nodo que intentbamos crear -> Creamos un
       // nodo Genrico y lo leemos: (Puede tratarse de un nodo Indefinido o de
       // un nodo definido en una sentencia PROTO o EXTERNPROTO.
       nuevoNodo = AnadirNodoGenerico(nombreNodoVRML,padre);
       if(nuevoNodo == NULL){
          AnadirError(GetLocationCode(padre) + "Can not create the node " + nombreNodoVRML);
          return;
       }
       // An tenemos que asignar el nombre dado:
       nuevoNodo->AsNodo()->nombreDado=nombreDado;

       // Solo falta leer el interior del nodo:
       if( (nuevoNodo->hijos != NULL) && (nuevoNodo->hijos->Get(0) != NULL) ){
          NodoArbol *na = nuevoNodo->GetHijo(0);
          if(na != NULL){
             TipoCampo *campo = na->AsCampo();
             if(campo != NULL)
                LeeInteriorLlave1Llave2('{','}',campo->valor);
                
          }
       }

       // Finalmente comprobamos si el nodo que acabamos de leer es un nodo
       // Indefinido o un nodo definido por una sentencia PROTO o EXTERNPROTO:
       if( 0 == NodoDefsEnPROTOs.Pos( (AnsiString)" " + nombreNodoVRML + " " ) ){

          // En este caso tenemos un nodo Indefinido.
          nuevoNodo->AsNodo()->tipoNodoVRML = NODO_INDEFINIDO;

          // Tenemos que aadirlo a los nodos indefinidos (siempre que no se
          // haya aadido ya):
          if( 0 == NodosIndefinidos.Pos( (AnsiString)" " + nombreNodoVRML + " " ) )
             NodosIndefinidos = NodosIndefinidos + nombreNodoVRML + " ";

       }else{
          // Tenemos un nodo que ha sido definido en una sentencia Proto o ExternProto:
          nuevoNodo->AsNodo()->tipoNodoVRML = NODO_DEFINIDO_EN_PROTOS;
       }

       return;
    }

    if(nombreDado != "")
       nuevoNodo->AsNodo()->nombreDado=nombreDado;

    /* En este punto hay que leer el cuerpo del nodo:
                                          
           L E C T U R A   D E L   C U E R P O  D E L   N O D O      
                                          
     Dentro del cuerpo podemos tener:
       Una sentencia ROUTE -> Para detectar este caso usaremos que debe empezar
                            con la palabra ROUTE.
       Una sentencia PROTO -> Para detectar este caso usaremos que debe empezar
                            con la palabra PROTO o EXTERPROTO.
       Un campo -> En este caso aparecer el nombre del campo seguido de:
           - El valor del campo 
           - una sentencia IS -> Creo que esto solo puede ocurrir en el interior de un PROTO. */

    // La posicin de LL es la siguiente al caracter {. As que haremos un bucle
    // en el que iremos leyendo palabras y distinguiremos varios casos.
    bool fin=false;

    while(!fin){
         // Reutilizamos palabra:
         palabra=GetPalabraID_LL(nuevoNodo);

         if(palabra == "PROTO"){//-----------------------------  PROTO  --------

            LeePROTO(padre);

         }else if(palabra == "EXTERNPROTO"){//-----------  EXTERNPROTO  --------

            LeeEXTERNPROTO(padre);

         }else if(palabra == "ROUTE"){//-------------------------  ROUTE  --------

            LeeRutado(padre,false);

         }else if(palabra == "ROUTEANDTOUCH"){//-----------------  ROUTEANDTOUCH -
            if(GN == Main->GNH)
               LeeRutado(padre,true);
            else
               AnadirError(GetLocationCode(padre) + "Error -> ROUTEANDTOUCH sentences are not valid");

         }else if(palabra == ""){     //-------------------------  FIN NODO --------
            // Get palabra puede devolver "" por dos motivos: 1 que se hayan acabado
            // los datos -> en este caso GetCaracter deolvera '\0' -> mostraremos
            // un mensaje de error. El 2 motivo es que se haya encontrado un caracter
            // que no forma parte del WhiteSpace ni es un caracter vlido de un ID,
            // por ejemplo } -> As que si el caracter leido es } acabamos las iteraciones.
            char c = GetCaracterLL();
            if( c=='\0'){
                // En este caso se han acabado los datos (fin del fichero).
                AnadirError(GetLocationCode(padre) + "Error (end of node expected).");
                fin=true;
            }else if( c=='}'){
                fin=true;
            }else{
                AnadirError(GetLocationCode(padre) + "Unexpected character " + (AnsiString)c);
                fin=true;
            }
         }else{   //------------------------------------------------ CAMPO -------

              // ALGO MUY IMPORTANTE: Es que el orden en el que aparecen los campos
              // de un nodo VRML no es indiferente por ello iremos aadiendo los
              // campos en el mismo orden que se vayan leyendo.

              // En palabra tengo el nombre del campo y en nuevoNodo toda
              // la informacin sobre el nodo. Antes de llamar a LeeCampo
              // tengo que crear el campo <palabra> en memoria como hijo de
              // nuevoNodo.
              NodoArbol *nuevoCampo = CreaCampo(nuevoNodo,palabra);
              if(nuevoCampo != NULL){
                 LeeCampo(nuevoNodo,nuevoCampo);
              }else{
                 // Es posible que tengamos un nodo genrico -> El problema es que
                 // en X3D no aparece el campo explicitamente -> hay que consultar
                 // el container field del nodo -> Cuando no hay container field
                 // en un nodo genrico no podemos saber a qu campo del nodo padre
                 // pertenece y en esos casos es posible que lleguemos aqui, as que
                 // lo tenemos en cuenta:
                 if(0 != palabra.Pos(PREF_NODOS_NO_REGISTRADOS) )
                 {
                    AnsiString tmp = palabra.Delete( palabra.Pos(PREF_NODOS_NO_REGISTRADOS) , ((AnsiString)PREF_NODOS_NO_REGISTRADOS).Length());
                    AnadirError(GetLocationCode(padre) + "Can not create the node " + palabra + " (container field needed).");
                 }
                 else
                    AnadirError(GetLocationCode(nuevoNodo) + "Can not create the field " + palabra);
              }
         }
     }
     if( !CreaRestoCampos(nuevoNodo))
         AnadirError(GetLocationCode(padre) + "Can not create the fields of the node " + palabra );
}
//---------------------------------------------------------------------------
NodoArbol* __fastcall GestorVRML::GetHijo(NodoArbol *padre,AnsiString nombreCampo){

   if( (padre == NULL) || (!padre->EsNodo()) )
      return NULL;

   for(int c=0; c <= padre->hijos->MaxIndexUsado(); c++){
       // Comparamos el nombre de cada campo con campo.
       NodoArbol *campo = (NodoArbol *) padre->hijos->Get(c);
       if( (campo != NULL) && campo->EsCampo()  &&
           (nombreCampo == campo->AsCampo()->nombre) )
             return campo;
   }
   return NULL;
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::MsgFilaColumna(){
  return "Row:" + IntToStr(GetFilaLL()) + " Col:" + IntToStr(GetColumnaLL()) + "-->";
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeSFNode(NodoArbol *campo, AnsiString palabra){
        /* Segun el anxo de grtica de la espeficicacin VRML un campo de
        tipo SFNODE tendr la siguiente estructura:
              sfnodeValue ::=
                     nodeStatement | NULL ;
         As podr valer NULL o ser la declaracin de un nodo.   */

         // palabra es la primera palabra que forma parte del campo SFNODE.
         if(palabra == ""){
             return;
         }else if(palabra == "NULL"){
            // En este caso solo hay que poner a NULL el valor del campo.
             campo->AsCampo()->valor="NULL";
         }else{
            // En este caso tenemos la definicin de un nodo-> hacemos una llamada
            // a la funcin LeeNodo (es una llamada recursiva porque la funcin
            // LeeCampo se llam desde LeeNodo()).
            LeeNodo(campo,palabra);
         }
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeCampo(NodoArbol *padre,NodoArbol *campo){
    if((padre == NULL) || (!padre->EsNodo()) || (campo == NULL) || !campo->EsCampo() )
       return;

   // Aqui tenemos en campo los datos del campo actual.

   // *************  *******************   *******************  ****************
   // *************  ESTRATEGIA PARA LA LECTURA DE CAMPOS VRML  ****************
   // *************  *******************   *******************  ****************
   /* Distinguiremos varios casos -> SFNODE ~ MFNODE ~ RESTO:
     Para SFNODE y MFNODE usaremos llamadas recursivas.
     Para el resto de campos se leeran todos los caracteres hasta encontrar }
     o una palabra que coincida con el nombre de otro campo o con ROUTE PROTO
     o EXTERNPROTO. Hay que tener cuidado con las cadenas que deben leerse de
     forma atmica para evitar interpretar el interior de las cadenas como
     cdigo VRML. Tambin hay que tener cuidado con que dentro de una cadena
     puede aparecer la construccin \" para indicar que esa comilla no es la
     comilla de cierre de la cadena.
        Es necesario decir que para simplificar las funciones de lectura y para
     hacer que esta funcin de lectura no sea demasiado lenta se opta por no hacer
     las comprobaciones del contenido de los campos -> podran usarse las mscaras
     para verificar que el contenido leido para cada campo es el correcto. Por
     ejemplo que un campo numrico no contenga letras -> pero eso no se hace,
     como ya se ha mencionado, para no complicar demasiado esta funcin y para
     no enlentecerla (y tambin porque hay funciones que realizan esa verificacin
     una vez que la escena est cargada en memoria.
   */

        //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  SFNODE  XXXXXXXXXXXXX
   if     ( campo->AsCampo()->tipoCampo == SFNODE ){

          LeeSFNode(campo,GetPalabraID_LL(padre));
        //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  MFNODE  XXXXXXXXXXXXX
   }else if( campo->AsCampo()->tipoCampo == MFNODE ){
        /* Segun el anxo de gramtica de la espeficicacin VRML un campo de
        tipo SFNODE tendr la siguiente estructura:
             mfnodeValue ::=
                     nodeStatement | [ ] | [ nodeStatements ] ;
         As podr valer NULL o ser un nodo o ser [] o ser 1 o ms nodos entre []
         Leemos la primera palabra y distinguimos varios casos.  */
         AnsiString palabra = GetPalabraID_LL(campo);
         if(palabra == ""){
             // En este caso estamos aprovechando el hecho de que GetPalabra no
             // avanzar nada cuando se encuentre un [ as devolver "".

             // Vamos a absorver el caracter [.
             if( GetCaracterLL() != '[' ){
                  AnadirError(GetLocationCode(campo) + "Not valid character as field value");
                  return;
             }
             // Ahora hay que leer todos los nodos mientras sea posible.
             bool fin=false;
             do{
                 // Hay que tener en cuenta que podemos tener []:
                 AnsiString palabra = GetPalabraID_LL(campo);
                 if(palabra != ""){
                     LeeSFNode(campo,palabra);
                 }else{
                     // En este caso se ha parado el avance de la funcin
                     // GetPalabraID_LL() -> debemos tener ].
                     if(GetCaracterLL() != ']'){
                         AnadirError(GetLocationCode(campo) + "Not valid character as field value");
                         return;
                     }else{
                         fin=true;
                     }
                 }
             }while(!fin);
         }else{
             // En este caso tenemos un SFNode que puede ser NULL o un nodo -> Lo leemos:
             LeeSFNode(campo,palabra);
         }

        //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  SIMPLE  XXXXXXXXXXXXX
   }else if( campo->AsCampo()->tipoCampo == SIMPLE ){
       // En este caso tenemos un valor simple de un campo.
       LeeCampoSIMPLE(campo->padre,campo->AsCampo()->valor);
       // Queremos evitar los separadores al final de los datos -> porque hay
       // RCs que molestan, as:
       int c,pos=0;
       AnsiString valor = campo->AsCampo()->valor;
       for(c=valor.Length(); c > 0 ; c--){
            // Vamos desde el final hasta que se encuentre un caracter que no sea
            // un separador.
            if(!Separador(valor[c])){
               pos=c;
               c=0;  // salimos del bucle.
            }
        }
       // Ya tenemos la cadena sin los separadores
       campo->AsCampo()->valor=valor.SubString(1,pos);
   }
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeCampoSIMPLE(NodoArbol *padre,AnsiString &texto){

  if( (padre == NULL) || (!padre->EsNodo()) )
     return;

  // En primer lugar tenemos que ver si el padre es un nodo con o sin
  // anidamiento. (Incluimos los espacios para evitar encontrar subcadenas).
  AnidamientoAnulado = ( 0 != CONF.NODOS_SIN_ANIDAMIENTO.Pos( (AnsiString)" " + padre->AsNodo()->nombre + " " ) );

  texto="";

  // Lo primero es absorver el WhiteSpace que haya.
  if(!AnidamientoAnulado)
     AbsorveWhiteSpaceLL(padre);

  // Ahora hay que ver si el primer caracter es [ o no.
  char letra = GetCaracterLL(true);
  if( letra == '[' ){
       // El Buffer no debe ser compartido por las funciones, avisaremos con un
       // mensaje si se produce esta situacin indeseada.
       if(UsandoBuffer)
          Utilidad.MsgInfo("The Read/Write buffer is being shared","Advertencia");
       UsandoBuffer=true;
       IndexBuffer=0;
       // En este caso tenenos la ventaja de que los datos aparecen entre []:
       while( (letra != '\0') && (letra != '}') && (letra != ']') ){
           // Para no colocar mal el comentario y para acelerar un poco la
           // lectura es preferible no considerar los comentarios que aparecen
           // entre [ ]
           // if(letra == '#'){
           //    RetrocedeCaracterLL();
           //    LeeComentario(padre);
           // }
           if(letra != '"'){
              Buffer[IndexBuffer++]=letra;
              if(IndexBuffer+1 >= TAM_BUFFER){
                 Buffer[IndexBuffer]='\0';
                 texto+=Buffer;
                 IndexBuffer=0;
              }

              if(letra == (char)13){
                 // En este caso aadimos ademas el caracter 10.
                 Buffer[IndexBuffer++]=(char)10;
                 if(IndexBuffer+1 >= TAM_BUFFER){
                    Buffer[IndexBuffer]='\0';
                    texto+=Buffer;
                    IndexBuffer=0;
                 }
                 // Conviene absorver todos los separadores para evitar el efecto de
                 // la justificacin:
                 if(!AnidamientoAnulado){
                    char c=GetCaracterLL(true);
                    while( (c == ' ') ||(c == (char)0x9)  )
                       c=GetCaracterLL(true);
                    RetrocedeCaracterLL();
                 }
              }
           }else{
               RetrocedeCaracterLL();
               // Actualizamos el contenido de texto antes de cargar la cadena.
               Buffer[IndexBuffer]='\0';
               texto+=Buffer;
               IndexBuffer=0;
               texto+=LeeString();
           }
           letra=GetCaracterLL(true);
       }
       // Actualizamos el contenido de texto.
       Buffer[IndexBuffer]='\0';
       texto+=Buffer;
       UsandoBuffer=false;

       if( (letra == '\0') || (letra == '}') ){
           // En este caso se han leido todos los datos y no se ha encontrado ]
           // o bien se ha llegado al final del nodo y no se ha encontrado ]
           AnadirError(GetLocationCode(padre) + "Error. End of MFNode expected.");
           return;
       }else if(letra == ']'){
           // En este caso todo ha acabado correctamente.
           texto+=']';
           return;
       }
  }else{
     // Tenemos un campo SF o bien un campo MF con solo un valor.
     // Volvemos a colocarnos al principio de los datos.
     // La estrategia para leer los datos del campo ser ir copiando en texto
     // todo lo que vallamos leyendo hasta que se encuentre una palabra que sea
     // el nombre de un campo, el final del nodo o el final de los datos de la LL.

     // Usaremos anter para saber cuando empieza una nueva palabra que pueda ser
     // el nombre de un campo.
     char anter;

     bool fin=false;
     while( (letra != '\0') && (letra != '}') && (!fin) ){
         if(letra == '#'){
             RetrocedeCaracterLL();  // Nos colocamos en #
             LeeComentario(padre);
             letra = ' ';  // Es para que en [*] (abajo) se compruebe el nombre del campo.
         }else if(letra == '"'){
             RetrocedeCaracterLL();
             texto+=LeeString();
             letra = ' ';  // Es para que en [*] (abajo) se compruebe el nombre del campo.
         }else{
            texto+=letra;
            if(letra == (char)13){
               // En este caso aadimos ademas el caracter 10.
               texto+=(char)10;

               // Conviene absorver todos los separadores para evitar el efecto de
               // la justificacin:
               if(!AnidamientoAnulado){
                  char c=GetCaracterLL(true);
                  while( (c == ' ') ||(c == (char)0x9)  )
                     c=GetCaracterLL(true);
                  RetrocedeCaracterLL();
               }
            }
         }

         anter=letra;  // Punto [*] rederenciado arriba.
         letra=GetCaracterLL(true);

         // Cuando el caracter anterior es un caracter Separador y el actual
         // es un CaracterIDValido estamos al principio de una palabra que
         // podra ser el nombre de un nuevo campo.
         if( Separador(anter) && CaracterIDValido(letra) ){
             // En este caso hay que ver si estamos o no al principio del nombre
             // de otro campo y en ese caso asignar fin a true.

             // Haremos un bucle que lea hasta encontrar un separador
             AnsiString sigCampo="";
             int cont = 1; // Contaremos el nmero de letras leidas para luego retroceder.
             while( (letra != '\0') && CaracterIDValido(letra) ){
                 sigCampo+=letra;
                 letra=GetCaracterLL(true);
                 cont++;
             }

             // Si se han acabado los datos (letra == '\0') habr un error porque
             // faltara el caracter } del nodo.
             if(letra == '\0'){
                  AnadirError(GetLocationCode(padre) + "Error. End of node expected.");
                  return;
             }else{
                 // Hay que retroceder cont veces para estar justo antes de la
                 // palabra que hemos leido.
                 for(int c=0; c < cont ;c++)
                    RetrocedeCaracterLL();

                 if(sigCampo == "ROUTE")
                 {
                    fin = true;
                 }
                 else
                 {
                    // Ya tenemos una palabra que hay que comparar con
                    // los nombres de los campos:
                    Nodo *datosNodo= padre->AsNodo()->datosNodo;
                    bool hijoEncontrado = false;
                    for(int cont=0 ; cont < datosNodo->numCampos; cont++){
                       AnsiString nombreCampo = datosNodo->campos[cont]->nombre;
                       if(nombreCampo == sigCampo){
                           hijoEncontrado=true;
                           cont=datosNodo->numCampos; // Salimos del bucle.
                       }
                    }

                    if( hijoEncontrado ){
                       // En este caso se ha encontrado el siguiente campo.
                       fin = true;
                    }else{
                       // En este caso no se ha encontrado el nodo as que volvemos
                       // a leer la letra que tenemos que procesar.
                       letra=GetCaracterLL(true);
                    }
                 }
             }
         }
     }

     if (letra == '\0')
         AnadirError(GetLocationCode(padre) + "Unexpected end of file.");
     // Notar que no sera un error que se salga del bucle porque letra sea }
     if(letra == '}')
        // En este caso retrasamos la LL para que desde el exterior se pueda
        // saber que el nodo ha acabado.
        RetrocedeCaracterLL();
  }
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::LeeString(){

   if(GetCaracterLL() != '"'){
      // Dejamos la LL como estaba antes de entrar en LeeString.
      RetrocedeCaracterLL();
      return "";
   }
   // Inicializamos la cadena con el caracter que hemos absorvido.
   AnsiString texto= '"';
   char letra = GetCaracterLL(true);
   char anter = '\0';
   while( (letra != '\0') && (letra != '"') ){
      texto+=letra;
      if( (anter == (char)13) && (letra != (char)10) )
          // En este caso aadimos ademas el caracter 10.
          texto+=(char)10;
      else if(letra == '\\'){
          // En este caso comprobamos si el siguiente caracter leido es '"'
          if(GetCaracterLL() == '"')
             texto+='"';
          else
             RetrocedeCaracterLL();
      }
      anter = letra;
      letra=GetCaracterLL(true);
   }

   if(letra == '\0'){
       // Se ha llegado al final de los datos cuando se esperaba encontrar el
       // final de una cadena.
       AnadirError(GetLocationCode(NULL) + "Error. End of string expected.");
       return "";
   }else
       texto+='"';

   return texto;
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::PrintTree(TStrings *lineas,NodoXml *nodo, int nivel)
{
   if( (nodo == NULL) || (lineas == NULL) || (lineas == NULL) )
      return;

   AnsiString base = AnsiString::StringOfChar(' ',nivel*5);

   lineas->Append(base + "" );
   lineas->Append(base + nodo->nombreNodo );
   lineas->Append(base + nodo->containerField );
   lineas->Append(base + nodo->atributos );
   lineas->Append(base + nodo->atributos );
   lineas->Append(base + nodo->def );
   lineas->Append(base + nodo->use );
   lineas->Append(base + "leido " + (nodo->leido ? "true" : "false" ));
   lineas->Append(base + "comentario " + (nodo->comentario ? "true" : "false" ));
   lineas->Append(base + "padre " + ((nodo->padre == NULL) ? "es NULL" : "no es NULL" ));
   lineas->Append(base + "hijosNoLeidos: " + nodo->hijosNoLeidos );

   if(nodo->hijos != NULL)
   {
      lineas->Append(base + "NumHijos: " + nodo->hijos->Count);

      for(int c=0; c < nodo->hijos->Count; c++)
      {
         NodoXml *h = (NodoXml *)nodo->hijos->Items[c];
         if(h == NULL)
         {
            lineas->Append(base + "   Hijo a NULL");
         }
         else
         {
            PrintTree(lineas,h,nivel+1);
         }
      }
   }
}
//---------------------------------------------------------------------------
// Ver "CLAVES PARA LA IMPLEMENTACIN DE LA FUNCIN DE LECTURA DE LA ESCENA VRML"
NodoArbol * __fastcall GestorVRML::CargaEscena(TStrings *lineas,TStrings *errores,AnsiString fichero,
                                               TipoEscena tipoEscena,bool mostrarMsgNodosIndefinidos,
                                               int &numNodosIndefinidos,bool ProcesaCabecera)
{
   if( (lineas == NULL) || (errores == NULL) )
       return NULL;

   // Necesitaremos restaurar el cdigo original ms adelante.
   AnsiString ficheroOriginal = lineas->Text;

   Errores=errores;
   NumErrores=0;
   Errores->Clear();

   // Inicializamos la variable que contendr los nodos indefinidos que se
   // encuentren durante la lectura. Todos los nodos estran separados por " ".
   // Al buscar el nombre de un nodo en esta variable hay que evitar encontrar
   // subcadenas, para ello se buscar: " NombreDelNodoIndefinido" y por ello
   // NodosIndefinidos entr el formato: " NodoInd1 NodoInd2 ... NodoIndN "
   NodosIndefinidos = " ";

   UsandoBarraDeProgreso= (lineas->Count >= MIN_NUM_LINEAS_PARA_SEGUIMIENTO);
   if(UsandoBarraDeProgreso)
       frmUtilidad->IniciaProgreso("Processing Data...",1,"",false); // 1 elementos pq an no sabemos el nmero de elementos a procesar:

   // Asignamos los gestores de datos.
   switch ( tipoEscena ){
      case ESCENA_X3D:
           GN=Main->GNX;
           GT=Main->GTX;
      break;
      case ESCENA_H3D: ;
           GN=Main->GNH;
           GT=Main->GTH;
      break;
   }

   // Cuando se encuentra un nodo no registrado se considera como un nodo
   // genrico. Tener un nodo no registrado puede deberse a dos causas:
   //  1 Que sea un nodo definido en sentencias PROTO o EXTERNPROTO.
   //  2 Que sea un nodo Indefinido, por ejemplo un nodo creado con C++ de H3D.
   // Tras cargar una escena se avisar al usuario si hay nodos no definidos.
   // Pero para distinguir los dos casos anteriores tenemos que usar esta variable
   // en la que se almacenarn durante la carga del fichero todos los nombres
   // de nodos definidos en sentencias PROTO y EXTERNPROTO.
   // Hay que tener en cuenta algo: Cuando queramos localizar el nombre del
   // nodo "Shape" dentro de esta variable, tendremos que buscar " Shape " para
   // evitar encontrar subcadenas.
   NodoDefsEnPROTOs = " ";

   // Raiz ser el nodo padre de todos los elementos del fichero.
   NodoArbol *raiz = CrearElemento(RAIZ);

   // Asignamos sus campos.
   raiz->AsRaiz()->fichero=fichero;
   raiz->AsRaiz()->tipoEscena=tipoEscena;

   //------------ParserXML-----------------------//
   //Aqui realizamos la conversin XML->VRML

   int inicioScene=0, finScene,i;

   AnsiString archivoString;

   // Se inicia una Lectura Lineal muy simple para obtener la primera lnea no vaca.
   // Con eso se pretende identificar la codificacin del cdigo.
   if(IniciaLL(lineas)){
     char letra=GetCaracterLL();
     while( Separador(letra) || (letra == '<')  )
     {
       if(letra == '<'){
          RetrocedeCaracterLL();  // Nos colocamos sobre el caracter '<'
          break;
       }
       letra=GetCaracterLL();
     }
     archivoString=GetRestoLineaLL();
   }

   Cabecera->Clear();
   archivoString=archivoString.Trim();

   // Si el archivo comienza por un caracter '<' es codificacin XML
   if( (archivoString.Length() > 0) /*&&  (archivoString[1]=='<') */ )
   {
      // "archivoCompleto" contiene todo el archivo mientras que "scene" contiene slo la escena VRML

      raiz->AsRaiz()->tipoCodificacion="XML";

      // En XML el cdigo se encapsula en <Scene>, separndolo de la cabecera. En H3D es ms flexible
      // puede aparecer la cabecera o no, completa o parcial, encapsular el cdigo o no (independientemente
      // de que se haya definido cabecera.
      inicioScene=finScene=-1;
      for(i=0; i<lineas->Count; i++)
      {
           if (lineas->Strings[i].AnsiPos("<Scene>") )
                   inicioScene=i+1;
           if (lineas->Strings[i].AnsiPos("</Scene>") )
                   finScene=i+1;
      }

      // Separamos el cdigo en dos TStringList. En uno se contiene la cabecera y en el otro el cdigo.
      if( (inicioScene!=-1 ) && (finScene!=-1)  )
      {
         SceneLocal->Clear();
         SceneLines = SceneLocal;
         for (i=0; i< inicioScene; i++)
         {
            Cabecera->Add(lineas->Strings[i]);
         }

         for (i=inicioScene; i<finScene; i++)
         {
            //relleno scene nicamente con lo que hay entre las etiquetas de <Scene>
            SceneLines->Add(lineas->Strings[i] );
         }
      }else{
       	  // No hay encapsulamiento, todo es cdigo y no hay cabecera.
           SceneLocal->Clear();
           SceneLines=lineas;
           Cabecera->Add("NO");
      }

      // Necesitaremos saber si la escena est vaca o no.
      bool escenaVacia = true;
      if( (lineas->Count > 0) || ((lineas->Count == 1) && (lineas->Strings[0].Trim() != "")) )
      {
         escenaVacia = false;
      }

      archivoString = SceneLines->Text; //es una variable de paso
      XmlScanner->LoadFromBuffer(archivoString.c_str());   //se le dice al xmlparser que lo lea de buffer y no de archivo
      //SceneLines->Clear();

      archivoString = Cabecera->Text;

      //Almaceno la cabecera extraida como un AnsiString en el nodo raiz.
      raiz->AsRaiz()->cabecera=archivoString;

      Parseo = lineas;

      // Inicio el escaneo XML con el parser.
      XmlScanner->XmlParser->StartScan();

      // La funcin FormaArbol es la que crea el arbol de la escena para el parseo.
      // cada ejecucin de ArbolParseo da un nico paso en el XMLparser y debe
      // estar referido a que nodo se esta posicionado. Decide esto para el siguiente paso.

      if (ArbolParseo.Escena.hijos->Count > 0)
      {
      	// No es la primera vez que se parsea y hay una estructura almacenada en ArbolParseo.Escena que se debe borrar
      	// y preparar para un nuevo escaneo.
         ArbolParseo.Reinicio();
      }
      // Se realiza una primera llamada a la funcin (no recursiva) para obtener el nodo por el que empezar.
      NodoXml *nodoParseo = FormaArbol(&ArbolParseo.Escena);

      // Cada iteracin se procesa un nodo y se decide sobre que nodo se posiciona para la siguiente lectura.
      // Cuando encuentra </Scene> devuelve el puntero a Escena->padre que es NULL. Y sale del bucle.
      while (nodoParseo != NULL)
      {
        nodoParseo = FormaArbol(nodoParseo);
      }

      //  Procesamos un caso especial. Si el parser X3D no es capaz de reconocer nada
      // no habremos leido ningn nodo -> y en ese caso tenemos que avisar con un
      // error para que no se cargue la escena en blanco sin dar ningn error.
      if( !escenaVacia && (ArbolParseo.Escena.hijos != NULL) && (ArbolParseo.Escena.hijos->Count == 0) )
      {
         //   La escena que se ha leido est vaca cuando el cdigo realmente no
         // est vaco -> Esto puede deberse a dos cosas, a que el cdigo no es XML
         // y el parser no ha podido leer nada o bien a que el cdigo tiene solo
         // la cabecera -> Vamos a ver si el primer caracter es <:
         int tam = (ficheroOriginal.Length() < 2000) ? ficheroOriginal.Length() : 2000;
         bool ok = false;
         for(int c=1; c <= tam; c++)
         {
            if(ficheroOriginal[c] == '<')
            {
               ok = true;
               break;
            }
            else if( (ficheroOriginal[c] != ' ') && (ficheroOriginal[c] != '\t') &&
                     (ficheroOriginal[c] != '\r') && (ficheroOriginal[c] != '\n') )
            {
               ok = false;
               break;
            }
         }
         if(!ok)
            AnadirError(GetLocationCode(NULL) + "XML error.");
      }

      NodoXml *lectura;
      nivelLectura=-1;

      lectura = &ArbolParseo.Escena;
      lineas->Clear();

      //PrintTree(lineas,&ArbolParseo.Escena);

      //  LecturaRecursiva es la funcin que escribe el cdigo en VRML. Como su nombre indica
      // esta funcin s es recursiva.
      LecturaRecursiva2(lectura);

      // Para depurar:
      // lineas->SaveToFile("C:\\test.txt");
   }
   else
   {
      // Si el primer caracter vlido no es '<', entonces es codificacin VRML.
      raiz->AsRaiz()->tipoCodificacion="VRML";
      int finLineas=lineas->Count;
      bool hayCabecera=false;

      // El parser VRML original no recoge la aparicin de la cabecera X3D. Se extrae y elimina del parseo, el contenido
      // se almacena en el AnsiString cabecera del nodo raiz de la escena.
      for (i=0; i<finLineas; i++)
      {
         if ( (0!=lineas->Strings[i].AnsiPos("PROFILE")) || (0!=lineas->Strings[i].AnsiPos("META")) || (0!=lineas->Strings[i].AnsiPos("COMPONENT")))
         {
            // cuando se encuentra un PROFILE, META o COMPONENT, se almacena en cabecera, se elimina y reconfigura el bucle
            Cabecera->Add(lineas->Strings[i]);
            lineas->Delete(i);
            finLineas--;
            i--;
            hayCabecera=true;
         }
      }
      if (hayCabecera)
      {
        archivoString = Cabecera->Text;
        // Aqui es donde se almacena en el nodo raiz.
        raiz->AsRaiz()->cabecera=archivoString;
      }
      else
      {
        // ATENCION: eso puede ser un error, cuidado.
        Cabecera->Add("NO");
      }
   }

   //------------FIN ParserXML-----------------------//


   if(UsandoBarraDeProgreso)
       frmUtilidad->IniciaProgreso("Processing Data...",lineas->Count,"",false); // 1 elementos pq an no sabemos el nmero de elementos a procesar:

   // Iniciamos la lectura lineal de los datos de la escena.
    if(!IniciaLL(lineas)){
      GN=NULL;
      GT=NULL;
      Errores=NULL;
      if(UsandoBarraDeProgreso)
         frmUtilidad->FinalizaProgreso();
      UsandoBarraDeProgreso = false;
      lineas->Clear();
      lineas->Text = ficheroOriginal;
      return NULL;
   }

   // Comprobamos que la primera cadena del fichero es correcta -> Solo es
   // necesario hacerlo si la escena es de tipo ESCENA_X3D porque en los
   // ficheros H3D no es obligatoria que aparezca la primera lnea que
   // indica la versin de VRML y el tipo de Codificacin.

   //Linea provisional para evitar la comprobacin de cabecera
   //ProcesaCabecera = false;


   if( ProcesaCabecera && (tipoEscena == ESCENA_X3D) ){

      AnsiString resto = GetRestoLineaLL();

      //if( !ChequeaPrimeraLinea(resto) ){
      //   errores->Append("Row:1 Col:1 --> It is needed to be agree with the VRML 2.0 specification and use UTF-8");
      //   GN=NULL;
      //   GT=NULL;
      //   Errores=NULL;
      //   if(UsandoBarraDeProgreso)
      //      frmUtilidad->FinalizaProgreso();
      //   UsandoBarraDeProgreso = false;
      //   return raiz;
      //}
   }

   // Usaremos un bucle que ir aadiendo los elementos que haya en la raiz del
   // fichero. Con un booleano se indicar cuando dejar de iterar.
   AnsiString palabra;
   while(!LL_Finalizada){
       palabra=GetPalabraID_LL(raiz);
       // Tenemos que distinguir varios casos para los elementos de la raiz:
       if(palabra == "PROTO"){  //-----------------------------  PROTO  --------

          if(tipoEscena == ESCENA_H3D)
             AnadirError(GetLocationCode(raiz) + "PROTO sentences not allowed in H3D scenes");
          else
             LeePROTO(raiz);

       }else if(palabra == "EXTERNPROTO"){//------------------ EXTERNPROTO  ----

          if(tipoEscena == ESCENA_H3D)
             AnadirError(GetLocationCode(raiz) + "EXTERNPROTO sentences not allowed in H3D scenes.");
          else
             LeeEXTERNPROTO(raiz);

       }else if(palabra == "ROUTE"){//-------------------------  ROUTE  --------

           LeeRutado(raiz,false);

       }else if(palabra == "ROUTEANDTOUCH"){//-----------------  ROUTEANDTOUCH -
           if(tipoEscena == ESCENA_H3D)
              LeeRutado(raiz,true);
           else
              AnadirError(GetLocationCode(raiz) + "ROUTEANDTOUCH sentences are not supported");


       }else if(palabra != ""){ //----------------------------- NODO --------
           // En este caso debenos tener un nodo.
           LeeNodo(raiz,palabra);
       }else{
          // GetPalabraID_LL ha devuelto "" pero es posible que haya encontrado
          // un caracter que no sea un identificador -> Si es as daremos un
          // mensaje de error y absorveremos el caracter.
          char letra = GetCaracterLL();
          if( (letra != '\0') && !Separador(letra) )
             AnadirError(GetLocationCode(raiz) + "Unexpected character (ASCII:"+ IntToStr((int)letra) +")" );
       }
   }
   GN=NULL;
   GT=NULL;
   Errores=NULL;
   if(UsandoBarraDeProgreso)
      frmUtilidad->FinalizaProgreso();
   UsandoBarraDeProgreso = false;

   numNodosIndefinidos = Utilidad.NumPalabras(NodosIndefinidos.c_str());

   // Vamos a comprobar si existen nodos indefinidos en la escena y si es as
   // avisaremos al usuario de que puede usar el men de configuracin para
   // registrarlos. Hay que tener en cuenta que si hay errores en la escena
   // no debe aparecer este mensaje porque a veces se encuentran nodos no
   // registrados ficticios debido a errores anteriores.
   if( mostrarMsgNodosIndefinidos && (numNodosIndefinidos > 0) &&
      ( (errores == NULL) || (errores->Count == 0) )   ){
      // Se han encontrado nodos indefinidos -> Mostramos un mensaje:
      if(numNodosIndefinidos <= 10)
      {
         // Vamos a obtener todos los nodos indefinidos quitando el prefijo de los nodos no registrados.
         AnsiString nodosIndefinidosSinPrefijo = NodosIndefinidos;
         int longPrefijo = ((AnsiString)PREF_NODOS_NO_REGISTRADOS).Length();
         int posPrefijo = nodosIndefinidosSinPrefijo.Pos( PREF_NODOS_NO_REGISTRADOS );
         while(0 != posPrefijo)
         {
            nodosIndefinidosSinPrefijo = nodosIndefinidosSinPrefijo.Delete(posPrefijo,longPrefijo);
            posPrefijo = nodosIndefinidosSinPrefijo.Pos( PREF_NODOS_NO_REGISTRADOS );
         }

         if( numNodosIndefinidos == 1)
            Utilidad.MsgInfo("The following node is not registered: " + nodosIndefinidosSinPrefijo,"Advertencia");
         else
            Utilidad.MsgInfo("The following nodes are not registered: " + nodosIndefinidosSinPrefijo,"Advertencia");
      }else
         Utilidad.MsgInfo("The file constains unregistered nodes.","Advertencia");

      Utilidad.MsgInfo("To register nodes you can use the setting window.");
   }

   // Para liberar la memoria que ocupa el rbol del parseo.
   ArbolParseo.Reinicio();

   // Restauramos los datos originales del cdigo X3D/H3D.
   lineas->Clear();
   lineas->Text = ficheroOriginal;

   return raiz;
}
//---------------------------------------------------------------------------
//
// CLAVES PARA LA IMPLEMENTACIN DE LA FUNCIN DE LECTURA DE LA ESCENA VRML 
//
/*   CABECERA:
   ------------
  * Todo fichero VRML debe empezar con:
      #VRML V2.0 <encoding type> [optional comment] <line terminator>
  * Debe haber extamente un espacio entre "#VRML" y "V2.0" y tambin debe haber
  exctamente un caracter entre "V2.0" y "<encoding type>" despus puede haber
  haber un comentario hasta el final de la lnea -> Es decir habr que leer
  todos los caraceres hasta que se encuentre un retorno de carro: char(13 y 10).

  * Para nosotros <encoding type> ser siempre "utf8" que indica que el fichero
  usa caractes unicode y en ese caso es legible directamente, en otro caso
  no leeremos el fichero (hay ficheros que usan otro tipo de cdigos).

  * As buscaremos la cadena "#VRML V2.0 utf8" al principio del fichero y leeremos
  el resto de caracteres hasta la siguiente lnea.

    COMENTARIOS
  ---------------
  * Los comentarios empiezan con #. As todos los caracteres que aparezan tras #
  hasta el final de lnea (13 10) sern ignorados. -> EXCEPCION: Cuando el
  caracter # aparece entre " " (interior de una cadena).

     WHITESPACE
  ---------------
  * Todas la palabras en VRML (excepto la cabecera) pueden estar separadas por whitespace.
  * Los caracteres separadores son:
  comas , espacios, tabulaciones, caracteres 10 (linefeeds) y retornos de carro (13).
  * Los caracteres separadores y los comentarios se llaman whitespace.

    TERMINADOR DE LNEA
  -----------------------
   Es un caracter linefeed (0x0a) o un retorno de carro (0x0d).

    NODOS HIJOS DE LA RAIZ
  --------------------------
  *  Una escena VRML est formada por cero o ms sentencias Node, Proto y Route
  en cualquier orden.
  * La sentencia ROUTE no puede aparecer precedida de DEF -> As que para idetentificar
  una sentencia como ROUTE tendremos que buscar la palabra ROUTE.
  * Una sentencia PROTO, puede comenzar con PROTO o EXTERNPROTO. As que buscaremos
  esas palabras en el fichero para identificar una sentencia PROTO. En el resto
  de los casos estaremos ante un NODO.

    SINTAXIS ROUTE
  ----------------------
     ROUTE nodeNameId . eventOutId TO nodeNameId . eventInId ;

    SINTAXIS PROTO
  ----------------------
     Ver Especificacin VRML.

  SINTAXIS NODO
  --------------------------
  Un nodo puede aparecer expresado de estos tres modos:
     Nombre_NodoVRML { cuerpo }
     DEF NombreDado Nombre_NodoVRML { cuerpo }
     USE NombreDado;

  Dentro del cuerpo podemos tener:
     Una sentencia ROUTE -> Para detectar este caso usaremos que debe empezar
                            con la palabra ROUTE.
     Una sentencia PROTO -> Para detectar este caso usaremos que debe empezar
                            con la palabra PROTO o EXTERPROTO.
     Un campo -> En este caso aparecer el nombre del campo seguido de:
           - El valor del campo 
           - una sentencia IS -> Creo que esto solo puede ocurrir en el interior de un PROTO.
*/

//------------------------------------------------------------------------------
NodoArbol * __fastcall GestorVRML::AnadirNodo(AnsiString nombreNodo,NodoArbol *padre){

   if( (nombreNodo == "") || (padre == NULL) )
      return NULL;

   NodoArbol *nuevo,*hijo;

   // Lo primero es obtener los datos del gestor de nodos.
   Nodo *datosNodo;
   datosNodo = GN->DatosNodo(nombreNodo);
   if(datosNodo == NULL){
      AnadirError(GetLocationCode(padre) + "The node " + nombreNodo + " is not registered");
      return NULL;
   }

   // Ya tenemos los datos del nodo. Ahora creamos un nuevo nodo del arbol y
   // asignamos sus campos.
   nuevo = frmEscena->CrearNodo(NODO);

   nuevo->nodoAsociado=NULL;
   nuevo->padre=padre;
   padre->hijos->Set((void *) nuevo,padre->hijos->MaxIndexUsado()+1);
   // Por comodidad usamos un puntero a los datos del nuevo nodo.
   TipoNodo *nuevoNodo = nuevo->AsNodo();
   nuevoNodo->nombre=nombreNodo;
   // nuevoNodo->nombreDado   Se asigna despus.
   nuevoNodo->datosNodo=datosNodo;
   nuevoNodo->nombreDado="";

   return nuevo;
}
//------------------------------------------------------------------------------
NodoArbol * __fastcall GestorVRML::AnadirNodoGenerico(AnsiString nombreNodo,NodoArbol *padre){

   if( (nombreNodo == "") || (padre == NULL) )
      return NULL;

   NodoArbol *nuevo,*hijo;

   // Lo primero es obtener los datos del gestor de nodos.
   Nodo *datosNodo = GN->NodoGenerico;
   if(datosNodo == NULL){
      AnadirError(GetLocationCode(padre) + "Can not create the node " + nombreNodo);
      return NULL;
   }

   // Ya tenemos los datos del nodo. Ahora creamos un nuevo nodo del arbol y
   // asignamos sus campos.
   nuevo = frmEscena->CrearNodo(NODO);

   if(nuevo == NULL)
      return NULL;

   nuevo->nodoAsociado=NULL;
   // Vinculamos padre e hijo:
   nuevo->padre=padre;
   padre->hijos->Set((void *) nuevo,padre->hijos->MaxIndexUsado()+1);

   bool provieneDelTraductorXML2VRML = (1 == nombreNodo.Pos(PREF_NODOS_NO_REGISTRADOS));

   // Por comodidad usamos un puntero a los datos del nuevo nodo.
   {
      TipoNodo *pnodo = nuevo->AsNodo();

      //   Hay dos posibilidades -> Que nombre nodo tenga el prefijo PREF_NODOS_NO_REGISTRADOS
      // o que no lo tenga. Lo tendr si proviene del tradurctor XML -> VRML:
      if(provieneDelTraductorXML2VRML)
      {
         nombreNodo = nombreNodo.Delete(1, strlen(PREF_NODOS_NO_REGISTRADOS));
      }
      pnodo->nombre=nombreNodo;

      // pnodo->nombreDado   Se asigna despus.
      pnodo->nombreDado="";
      pnodo->datosNodo=datosNodo;
   }

   // Solo falta crear el campo del nodo genrico:
   hijo = frmEscena->CrearNodo(CAMPO);

   // Asignamos los valores del nodo del arbol que acabamos de crear.
   hijo->nodoAsociado=NULL;  // Se asignar al crear el TreeNode (abajo).
   // Vinculamos padre e hijo:
   hijo->padre=nuevo;
   nuevo->hijos->Set((void *) hijo,nuevo->hijos->MaxIndexUsado()+1);

   // Ya tenemos el campo hijo->dato apuntando a una nueva estructura DatosCampo
   // Por comodidad usamos:
   {
      TipoCampo *nuevoCampo = hijo->AsCampo();

      if( (nuevoCampo != NULL) && (datosNodo->campos != NULL) && (datosNodo->campos[0] != NULL) ){
         nuevoCampo->nombre     = datosNodo->campos[0]->nombre;
         nuevoCampo->datosCampo = datosNodo->campos[0];
         nuevoCampo->valor      = datosNodo->campos[0]->valorPorDefecto;
         nuevoCampo->tipoCampo  = SIMPLE;
      }
   }
   return nuevo;
}
//------------------------------------------------------------------------------
NodoArbol *__fastcall GestorVRML::CrearElemento(TipoNodoArbol tipo){
   NodoArbol *elemento;
   try{    elemento= new NodoArbol(tipo); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }
   return elemento;
}
//------------------------------------------------------------------------------
bool __fastcall GestorVRML::ChequeaPrimeraLinea(AnsiString cad){
  // Esta es la cadena que debe aparecer en los ficheros VRML 2.0 que vamos a leer.
  return (1 == cad.Pos(PRIMERA_LINEA_VRML ));
}
//-----------------------------------------------------------------------------
NodoArbol * __fastcall GestorVRML::CreaCampo(NodoArbol *nodo,AnsiString nombreCampo){

   if( (nodo == NULL) || (!nodo->EsNodo()) )
      return NULL;

   Nodo *datosNodo= nodo->AsNodo()->datosNodo;
   NodoArbol *hijo;

   for(int i=0; i < datosNodo->numCampos ; i++){

       if(nombreCampo == (AnsiString) datosNodo->campos[i]->nombre ){
           // En este caso hemos encontrado el nodo.

           // creamos un hijo.
           hijo = frmEscena->CrearNodo(CAMPO);

           // Asignamos los valores del nodo del arbol que acabamos de crear.
           hijo->nodoAsociado=NULL;  // Se asignar al crear el TreeNode (abajo).
           hijo->padre=nodo;
           nodo->hijos->Set((void *) hijo,nodo->hijos->MaxIndexUsado()+1);

           // Ya tenemos el campo hijo->dato apuntando a una nueva estructura DatosCampo
           // Por comodidad usamos:
           TipoCampo *nuevoCampo = hijo->AsCampo();

           nuevoCampo->nombre     = datosNodo->campos[i]->nombre;
           nuevoCampo->datosCampo = datosNodo->campos[i];
           nuevoCampo->valor      = datosNodo->campos[i]->valorPorDefecto;

           if(datosNodo->campos[i]->tipo->numHijos == 1)
              nuevoCampo->tipoCampo = SFNODE;
           else if(datosNodo->campos[i]->tipo->numHijos == 2)
              nuevoCampo->tipoCampo = MFNODE;
           else
              nuevoCampo->tipoCampo = SIMPLE;

           // Salimos del bucle.
           return hijo;
       }
   }
   return NULL;
}
//-----------------------------------------------------------------------------
bool __fastcall GestorVRML::CreaRestoCampos(NodoArbol *nodo){

   if( (nodo == NULL) || (!nodo->EsNodo()) )
      return false;

   Nodo *datosNodo= nodo->AsNodo()->datosNodo;

   for(int i=0; i < datosNodo->numCampos ; i++){

       if( NULL == GetHijo(nodo, datosNodo->campos[i]->nombre ) ){
           // En este caso no existe el campo -> lo aadimos:
           if(! CreaCampo(nodo,datosNodo->campos[i]->nombre) )
              return false;
       }
   }
   return true;
}
//-----------------------------------------------------------------------------
void __fastcall GestorVRML::FinalizaAnadirLineaEF(){

   if(numLineaEF == 0)
      return;
   while(numLineaEF < LineasEF->Count)
       // Borramos la ltima cadena.
       LineasEF->Delete(LineasEF->Count-1);
}

//-----------------------------------------------------------------------------
void __fastcall GestorVRML::EscribirElementoVRML(NodoArbol *elemento,TStrings *lineas,TipoRaiz *raiz)
{
   if(raiz == NULL)
      return;

   switch ( raiz->tipoEscena ){
      case ESCENA_X3D:
           GN=Main->GNX;
           GT=Main->GTX;
      break;
      case ESCENA_H3D: ;
           GN=Main->GNH;
           GT=Main->GTH;
      break;
   }

   IniciaAnadirLineaEF(lineas);
   if (raiz->tipoCodificacion=="XML")
     EscribirElementoXML(elemento,0,true);
   else
     EscribirElemento(elemento,0,true);
   FinalizaAnadirLineaEF();
}
//-----------------------------------------------------------------------------
void __fastcall GestorVRML::IniciaAnadirLineaEF(TStrings *lineas){

    LineasEF=lineas;
    numLineaEF=0;
}
//-----------------------------------------------------------------------------
void __fastcall GestorVRML::AnadirLineaEF(AnsiString &cad,bool enOtraLinea){
   // No compruebo que lineas sea != NULL para ahorrar tiempo -> No habr errores
   // si se usan bien las funciones.
   if( (enOtraLinea) || (numLineaEF==0) ){
       LineasEF->Append(cad);
       numLineaEF++;
    }else
       LineasEF->Strings[numLineaEF-1] = LineasEF->Strings[numLineaEF-1] + " " + cad;
}
//-----------------------------------------------------------------------------
void __fastcall GestorVRML::AnadirLineaEF_(AnsiString cad,bool enOtraLinea)
{
   // No compruebo que lineas sea != NULL para ahorrar tiempo -> No habr errores
   // si se usan bien las funciones.
   if( (enOtraLinea) || (numLineaEF==0) ){
       LineasEF->Append(cad);
       numLineaEF++;
    }else
       LineasEF->Strings[numLineaEF-1] = LineasEF->Strings[numLineaEF-1] + " " + cad;
}
//------------------------------------------------------------------------------
void __fastcall GestorVRML::AnadirError(AnsiString error){
   NumErrores++;
   if( NumErrores >= MAX_NUM_ERRORES )
      FinalizaLL();
   if(Errores == NULL)
      return;
   Errores->Append(error);
}
//------------------------------------------------------------------------------
void __fastcall GestorVRML::Escribe_AnsiStringsToLines(AnsiString &cad){

    int fin=cad.Length();
    int c=1;
    int cont,pos;

    while( c <= fin ){

        cont=0;
        pos=c;
        while( (c <= fin) && ( (cad[c]!=(char)13) || ( (c+1 <= fin) && (cad[c+1]!=(char)10)) ) ){
           c++;
           cont++;
        }
        AnadirLineaEF_(cad.SubString(pos,cont));
        c+=2;  // Para absorver el caracter 10.
    }
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeePROTO(NodoArbol *padre){
    if(padre == NULL)
       return;

    // En primer lugar creamos el nuevo nodo en memoria.
    NodoArbol *proto=CrearElemento(PROTO);

    // Leemos y asignamos el identificador:
    proto->AsProto()->nombre = GetPalabraID_LL(padre);

    NodoDefsEnPROTOs = NodoDefsEnPROTOs + " " + proto->AsProto()->nombre + " ";    

    // Ahora nos colocamos en el corchete  '['
    AbsorveWhiteSpaceLL(padre);

    if('[' != GetCaracterLL(true) ){
       AnadirError(GetLocationCode(padre) + "Error in PROTO sentence.");
       delete proto;
       return;
    }

    // Ahora leemos las declaraciones del interfaz.
    LeeInteriorLlave1Llave2('[',']',proto->AsProto()->interfaz);

    // Ahora nos colocamos sobre la llave '{'
    AbsorveWhiteSpaceLL(padre);

    if('{' != GetCaracterLL(true) ){
       AnadirError(GetLocationCode(padre) + "Error in PROTO sentence.");
       delete proto;
       return;
    }

    // Leemos y asignamos el cuerpo del proto:
    LeeInteriorLlave1Llave2('{','}',proto->AsProto()->cuerpo);

    // Vinculamos padre e hijo.
    proto->padre=padre;
    padre->hijos->Set((void *)proto,padre->hijos->MaxIndexUsado()+1);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeEXTERNPROTO(NodoArbol *padre){
    if(padre == NULL)
       return;

    // En primer lugar creamos el nuevo nodo en memoria.
    NodoArbol *externProto=CrearElemento(EXTERNPROTO);

    // Leemos y asignamos el identificador:
    externProto->AsExternProto()->nombre = GetPalabraID_LL(padre);

    NodoDefsEnPROTOs = NodoDefsEnPROTOs + " " + externProto->AsExternProto()->nombre + " ";

    // Ahora nos colocamos en el corchete  '['
    AbsorveWhiteSpaceLL(padre);

    if('[' != GetCaracterLL(true) ){
       AnadirError(GetLocationCode(padre) + "Error in EXTERNPROTO sentence.");
       delete externProto;
       return;
    }

    // Ahora leemos las declaraciones del interfaz.
    LeeInteriorLlave1Llave2('[',']',externProto->AsExternProto()->interfaz);

    // Ahora nos colocamos sobre '\"'  "["
    AbsorveWhiteSpaceLL(padre);

    char letra = GetCaracterLL(true);

    if( ('[' != letra) && ('\"' != letra) ){
       AnadirError(GetLocationCode(padre) + "Error in EXTERNPROTO sentence.");
       delete externProto;
       return;
    }

    if(letra == '\"'){
       // En este caso solo tenemos una cadena -> La leemos:
       // El primer caracter que lea LeeString() debe ser " as que:
       RetrocedeCaracterLL();
       externProto->AsExternProto()->url = LeeString();
    }else{
       // En este caso tenemos que leer el interior de los corchetes:
       // Leemos y asignamos el valor mfString.
       LeeInteriorLlave1Llave2('[',']',externProto->AsExternProto()->url);
    }

    // Vinculamos padre e hijo.
    externProto->padre=padre;
    padre->hijos->Set((void *)externProto,padre->hijos->MaxIndexUsado()+1);
}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::LeeInteriorLlave1Llave2(char llave1,char llave2,AnsiString &cad){
   // Asumimos que estamos tras la llave { (llave1). Podemos tener "{ " o bien
   // texto til tras la llave "{ texto til", as:

   // El Buffer no debe ser compartido por las funciones, avisaremos con un
   // mensaje si se produce esta situacin indeseada.
   if(UsandoBuffer)
      Utilidad.MsgInfo("The Read/Write buffer is being shared","Advertencia");
   UsandoBuffer=true;
   IndexBuffer=0;

   char letra = GetCaracterLL(true);
   char letraAnterior = '\0';

   // Guardamos en cad todo lo que encontremos hasta llegar a }, teniendo en
   // cuenta que podran aparecer { } dentro del nodo:
   int nLlaves = 0;

   // Necesitaremos dos variables para controlar cuando estamos dentro de un
   // comentario y dentro de una cadena.
   bool enComentario = false;
   bool enCadena = false;

   while( (letra != '\0') && !( (letra == llave2) && (nLlaves == 0) && !enComentario && !enCadena) ){

      // Lo primero es aadir la letra al buffer:
      Buffer[IndexBuffer++]=letra;
      if(IndexBuffer+1 >= TAM_BUFFER){
         Buffer[IndexBuffer]='\0';
         cad+=Buffer;
         IndexBuffer=0;
      }

      // Ahora hay que controlar el nivel de anidamiento de llaves y el fin de lnea:
      if( (letra == llave1) && !enComentario && !enCadena ){
         nLlaves++;
      }else if( (letra == llave2) && !enComentario && !enCadena ){
         if(nLlaves != 0)
            nLlaves--;
         else
           AnadirError(GetLocationCode(NULL) + "Unexpected end of node.");
      }else if(letra == '#'){
         // En este caso tenemos que absorver el resto de caracteres hasta el
         // final de la lnea ignorando posibles { }
         enComentario = true;

      }else if(letra == '\"'){
         // En este caso tenemos que leer todo el texto hasta encontrar las
         // comillas de cierre. Tenidendo en cuenta que si aparece \" hay que
         // ignorar esas comillas. Esto se hace para ignorar las { } que pueda
         // haber dentro de una cadena.
         if( (letraAnterior != '\0') && (letraAnterior != '\\') )
            enCadena=!enCadena;

      }else if(letra == (char)13){
         enComentario = false;
      }
      letraAnterior = letra;
      letra=GetCaracterLL(true);

      //  En algunos casos puede aparecer char13 sin el char 10 detrs -> eso da
      // problemas -> lo evitamos:
      if( (letraAnterior == (char)13) && (letra != (char)10) )
      {
         // En este caso aadimos adems el caracter 10.
         Buffer[IndexBuffer++]=(char)10;
         if(IndexBuffer+1 >= TAM_BUFFER){
            Buffer[IndexBuffer]='\0';
            cad+=Buffer;
            IndexBuffer=0;
         }
      }
   }

   // solo falta aadir el contenido del buffer a cad:
   Buffer[IndexBuffer]='\0';
   cad+=Buffer;
   IndexBuffer=0;

   UsandoBuffer=false;

   // Queremos evitar los separadores al final de los datos -> porque hay
   // RCs que molestan, as:
   int c,pos=0;
   for(c=cad.Length(); c > 0 ; c--){
      // Vamos desde el final hasta que se encuentre un caracter que no sea
      // un separador.
      if(!Separador(cad[c])){
          pos=c;
          break;  // salimos del bucle.
      }
   }
   // Ya tenemos la cadena sin los separadores
   cad=cad.SubString(1,pos);

   // Finalmente tenemos que considerar estos dos casos:
   //   CASO 1:  NodoGenerico{ datos }
   //   CASO 2:  NodoGenerico{
   //                  datos
   //            }
   // El cdigo anterior funcionar bien en el primer caso y en el segundo caso
   // aadir un caracter RC adicional debido al RC que hay tras la llave {
   // As que intentamos eliminar ese RC si es que lo hay:
   c=1;
   int fin = cad.Length();
   while( (c <= fin) && ( (cad[c] == ' ') || (cad[c] == (char)0x9) ) )
      c++;
   // Hemos absorvido todos los espacios y tabuladores Absorvemos ahora el RC
   // si es que existe:
   if( (c <= fin) && (cad[c] == (char)0xd) ){
      c++;
      if( (c <= fin) && (cad[c] == (char)0xa) ){
         c++;
         if(c <= fin)
            cad = cad=cad.SubString(c,fin-c+1);
      }
   }
}

//-----------------------------------------------------------------------------
//                             Funciones XMLParser
//-----------------------------------------------------------------------------

// Esta funcin lee protos, externprotos y protoinstances sin interpretarlos
// De esta manera se evita que se desglose en el arbol toda su estructura y tener que
// interpretar el contenido, que en ocasiones puede ser muy complicado.
// Posteriormente esta funcin se ha utilizado para leer Scripts de la misma
// manera, sin interpretar.
void GestorVRML::leerProto(NodoXml *nodoProto)
{
   AnsiString buffer;
   nodoProto->atributos +=(char)13;
   nodoProto->atributos +=(char)10;
   while ( XmlScanner->XmlParser->Scan() )
   {
         // Esta funcin la ofrece el XMLparser para leer desde el inicio de la etiqueta al final
         // Pero cuidado que lee etiqueta a etiqueta, por cada llamada a la funcin se devuelve
         // el contenido entre '<' y '>' de la etiqueta actual.
         SetStringSF(buffer, XmlScanner->XmlParser->CurStart, XmlScanner->XmlParser->CurFinal);

         buffer=buffer.Trim();
        
         nodoProto->atributos += buffer;

         nodoProto->atributos +=(char)13;
         nodoProto->atributos +=(char)10;
         // Lo almacenamos todo en atributos. El contenido de atributos se volcar posteriormente en
         // un campo AnsiString en el nodo llamado "code".
         if ( (XmlScanner->XmlParser->CurPartType == ptEndTag) && (XmlScanner->XmlParser->CurName == nodoProto->nombreNodo) )
         {
           if (GN->NumeroDeNodo(nodoProto->nombreNodo)!=-1)
              nodoProto->atributos+="\"";
           return;
         }

   }
}

//---------------------------------------------------------------------------
// -Esta funcin NO es recursiva.

// -Su funcin es crear el arbol que interpreta el XML y que se utilizar para luego
// generar el archivo VRML.

// -Se le pasa el nodo actual del arbol sobre el que se est posicionado, la funcin
// da un paso en escaneo xml y dependiendo de si encuentra un nodo lleno, vacio o fin
// de nodo decide el nodo sobre el que se posicionar la siguiente llamada a esta funcin.

// -Cuando no tenga ms nodos que escanear devolver NULL

// -La informacin del nodoActual es el nodo donde se "cuelga" el siguiente nodo leido.
// al final se decide el "nodoActual" para la siguiente iteraccin y se apunta mediante
// el puntero llamado "siguiente".
NodoXml* __fastcall GestorVRML::FormaArbol(NodoXml *nodoActual)
{
   NodoXml *nuevoNodo;
   NodoXml *siguiente;
   AnsiString comentario;
   // Cada llamada se genera un nodo, se interpreta y rellena con la informacin del
   // parseo y finalmente se "cuelga" del nodo padre. 
   nuevoNodo = new NodoXml;
   nuevoNodo->hijos = new  TList;

  //Comentario referencia de la estructura Nodo
  //struct NodoXml {
  //      AnsiString nombreNodo;
  //      AnsiString containerField;
  //      AnsiString atributos;
  //      AnsiString def;
  //      AnsiString use;
  //      bool leido;
  //      bool comentario;
  //      int hijosNoLeidos;
  //      NodoXml *padre;
  //      TList *hijos;
  //} ;
  //

   if (XmlScanner->XmlParser->Scan()){
         switch(XmlScanner->XmlParser->CurPartType)
           {
              case ptXmlProlog    :
                siguiente=nodoActual;
                break;
              case  ptStartTag   :
		// Se crea el arbol "primero en profundidad": esto quiere decir que si se encuentra
		// un hijo se interna en el hijo y se rellena y posteriormente ya se volver al
		// padre si aparecen ms hijos.
		// Existe una excepcin y es que se encuentre un hijo proto o script. Estos aparecen
		// como nodos con hijos, pero no vamos a interpretarlos, as que los leemos con leeProto
		// pero el puntero de siguiente nodo para el parseo seguir apuntado al nodo padre.

                // Rellenado de valores del nuevo nodo, con info procedente del XMLparser
                nuevoNodo->nombreNodo=XmlScanner->XmlParser->CurName;
                nuevoNodo->padre=nodoActual;
                nuevoNodo->leido=FALSE;
                nuevoNodo->comentario=FALSE;

                // En caso de tratarse de proto's no queremos que se interprete la estructara en arbol interna
                // del proto para luego no tener que generarla. La introducimos como un nodo con toda la definicin
                // en el campo de los atributos. Esto lo hace la funcin leerProto().
                if ( (nuevoNodo->nombreNodo== "ProtoDeclare") || (nuevoNodo->nombreNodo== "ProtoInstance") || (nuevoNodo->nombreNodo== "ExternProtoDeclare")
                              || (nuevoNodo->nombreNodo=="Script") || ( (GN->NumeroDeNodo(nuevoNodo->nombreNodo)==-1) && (nuevoNodo->nombreNodo!="ROUTE") ) )
                {
                   // Se aade adems en nodo.atributos la linea inicial que el XMLparser ya ha interpretado
                   AnsiString code;

                   // Despues de que realicemos el SetStringSF no podemos acceder a los atributos, pero si accedemos antes
                   // no se interfiere en el resultado de esa funcin. Necesitamos conocer el containerField para los nodos
                   // protoInstance y Script, esa informacin la obtenemos con GetAttrContainerField.
                   GetAttrContainerField(XmlScanner->XmlParser->CurAttr, nuevoNodo);

                   SetStringSF(code, XmlScanner->XmlParser->CurStart, XmlScanner->XmlParser->CurFinal);

                   if (GN->NumeroDeNodo(nuevoNodo->nombreNodo)==-1)
                   {
                        nuevoNodo->atributos = code;
                   }
                   else
                   {
                        nuevoNodo->atributos = (AnsiString)"code \"" + code;
                   }
                   leerProto(nuevoNodo);


                   // Aunque se trata de un nodo lleno, no vamos a entrar a interpretarlo, el siguiente
                   // nodo a leer estar vinculado al nodo actual sobre el que estabamos realizando el parseo
                   siguiente=nodoActual;
                }
                else
                {
                   // Si se trata de un nodo normal se deben incluir los atributos correspondientes
                   // y apuntar en el parseo a ese nuevo nodo para continuar.
                   GetAttributesNodo( XmlScanner->XmlParser->CurAttr, nuevoNodo );
                   siguiente=nuevoNodo;
                }
                //funcin del arbol para incluir hijo
                ArbolParseo.AddHijo(nodoActual,nuevoNodo);
                break;

              case  ptEmptyTag   :


                // El tratamiento es muy similar al caso anterior, pero en todos los casos el hijo encontrado es un nodo
                // vaco (sin hijos) luego el parseo debe continuar por el nodo padre actual ("nodoActual").
                nuevoNodo->nombreNodo=XmlScanner->XmlParser->CurName;
                nuevoNodo->padre=nodoActual;
                nuevoNodo->leido=FALSE;
                nuevoNodo->comentario=FALSE;


                if ( (nuevoNodo->nombreNodo== "ProtoDeclare") || (nuevoNodo->nombreNodo== "ProtoInstance") || (nuevoNodo->nombreNodo== "ExternProtoDeclare")
                      || (nuevoNodo->nombreNodo == "Script") || ( (GN->NumeroDeNodo(nuevoNodo->nombreNodo)==-1) && (nuevoNodo->nombreNodo!="ROUTE") ) )
                {
                   AnsiString code;

                   // Despues de que realicemos el SetStringSF no podemos acceder a los atributos, pero si accedemos antes
                   // no se interfiere en el resultado de esa funcin. Necesitamos conocer el containerField para los nodos
                   // protoInstance y Script, esa informacin la obtenemos con GetAttrContainerField.
                   GetAttrContainerField(XmlScanner->XmlParser->CurAttr, nuevoNodo);

                   SetStringSF(code, XmlScanner->XmlParser->CurStart, XmlScanner->XmlParser->CurFinal);
                    if (GN->NumeroDeNodo(nuevoNodo->nombreNodo)==-1)
                   {
                        nuevoNodo->atributos = code;
                   }
                   else
                   {
                        nuevoNodo->atributos=(AnsiString)"code \"" + code + "\"";
                   }


		   // Se ha llegado aqui a travs del ptEmptyTag, esto quiere decir que es un nodo proto o script sin hijos
		   // la etiqueta ser del tipo <contenido/> y se obtendr toda con la llamada a SetStringSF. Por eso aqu
		   // no se realiza una llamada a leeProto.

                }
                else
                {
                   GetAttributesNodo( XmlScanner->XmlParser->CurAttr, nuevoNodo );
                }

                ArbolParseo.AddHijo(nodoActual,nuevoNodo);
                // Tanto si es un proto como sino, se continua la lectura sobre el nodo actual, no sobre el nuevo.
                // esta es la gran diferencia con respecto al "case ptStartTag"
                siguiente=nodoActual;
                break;

              case  ptEndTag     :
                // Ya se ha leido todo del nodo actual y se debe salir de l. En el arbol hay una referencia al padre
                // de cada nodo que se utiliza para apuntar al padre como siguiente nodo sobre el que se realiza el parseo.
                // NOTA: en el caso de que estemos en el final del archivo y nodoActual sea Escena, el padre de escena tiene
                // el valor NULL, que har terminar el bucle que llama a esta funcin. (se llama desde un "While (nodo!=NULL)" )
                siguiente=nodoActual->padre;
                break;

              case  ptComment    :

                // Aado el nodo como hijo y contino
                nuevoNodo->nombreNodo="Comentario";
                nuevoNodo->padre=nodoActual;
                nuevoNodo->leido=FALSE;
                // El XMLparser no lee comentarios, pero puedo leer el texto sin la etiqueta y los delimitadores
                SetStringSF(comentario, XmlScanner->XmlParser->CurStart + 4, XmlScanner->XmlParser->CurFinal - 3);
                nuevoNodo->atributos=comentario;
                // Se utiliza un containerField virtual que su nica utilidad es identificarlo como lo que es, un comentario.
                nuevoNodo->containerField="comentarios";
                nuevoNodo->comentario=TRUE;
                ArbolParseo.AddHijo(nodoActual,nuevoNodo);
                siguiente = nodoActual;

                break;

              default:
                // Si no se identifica la etiqueta se para el parseo.
                siguiente=NULL;
                break;
           }
           //Tratamiento de nodos desconocidos:
           //-comprobar si esta en el gestor de nodos
           //  *Si esta nada
           //  *Si no esta: Buscar children o un slo contenedor vaco.
           //        -Si no se encuentra Error.
           /*if ( (siguiente!=NULL ) && (nuevoNodo!=NULL) && (nuevoNodo->nombreNodo!=NULL) )
           {
             AnsiString nombreNodoDebug = nuevoNodo->nombreNodo;  // para debugear
             if ( (GN->NumeroDeNodo(nuevoNodo->nombreNodo)==-1) && (nuevoNodo->nombreNodo!="Comentario") )
             {
                Nodo *datosPadre = GN->DatosNodo(nuevoNodo->padre->nombreNodo);
                if (datosPadre!=NULL)
                {
                  int nodoSFMF=0, indiceNodoContenedor=-1;
                  for(int c=0; c < datosPadre->numCampos; c++)
                  {
                      if (datosPadre->campos[c]->nombre== "children")
                          indiceNodoContenedor=c;
                      if (datosPadre->campos[c]->tipo->numHijos>0)
                      {
                          nodoSFMF++;
                          if ( (nodoSFMF==1) && (indiceNodoContenedor!=-1) )
                             indiceNodoContenedor==c;
                      }
                  }

                  if ( (nodoSFMF==1) && (indiceNodoContenedor!=-1) )
                     nuevoNodo->containerField == datosPadre->campos[indiceNodoContenedor]->nombre;
                  //else
                     //Error
                }
             }
           } */
           // De todos modos el cdigo que lee esta en VRML al leerlo en cortocircuito (solucin protos?)
   }
   else
   {
        delete nuevoNodo; 
        siguiente=NULL;
   }
   return siguiente;
}
//---------------------------------------------------------------------------
AnsiString __fastcall GestorVRML::defaultContainerField(AnsiString nombreNodo)
{
        // Esta funcin debe consultar al gestor de nodos y devolver el container Field por defecto
        return GN->GetContainerField(nombreNodo);
}
//---------------------------------------------------------------------------
// Esta funcin recursiva recorre el arbol procedente del parseo XML para generar
// un cdigo en VRML que entienda el parser completo de disreal.
void GestorVRML::LecturaRecursiva2(NodoXml *nodo)
{   
   //nivelLectura++;
   int i,j;
   int esMFNode=0;      //esta variable la utilizo para identificar SFNodes
   AnsiString containerActual="";
   NodoXml *nodoAux,*nodoAux2;

   // Si se trata del nodo escena no quiero que aparezca explicitamente en el texto.
   // en realidad las etiquetas de Scene se utilizan en XML para encapsular el cdigo
   // de la escena. En VRML no aparece esa identificacin de cdigo y cabecera por eso
   // no debe aparecer en el cdigo final generado aqui.
   if (nodo->nombreNodo!="Escena" )
   {
           // Existe un trato especial para los casos de USE, DEF o comentario
           if (nodo->use!="")
           {
                //if ( (nodo->containerField!="") && (nodo->padre->nombreNodo!="Escena") )
                //  AddCadena(nodo->containerField + " USE " + nodo->use, 0, nivelLectura );
                //else
                // En VRML es tan simple como eso. Se puede observar que se pieder la informacin
                // de containerField necesaria para volver a generar el cdigo en XML de la escena
                // esto se arregla en la escritura
                AddCadena("USE " + nodo->use, 0, nivelLectura );
           }
           else if (nodo->def!="")
           {
                if (GN->NumeroDeNodo(nodo->nombreNodo)==-1)
                {
                    AddCadena("DEF " + nodo->def + " " + PREF_NODOS_NO_REGISTRADOS + nodo->nombreNodo + " {", 0, nivelLectura );
                }else{
                    AddCadena("DEF " + nodo->def + " " + nodo->nombreNodo + " {", 0, nivelLectura );
                }

           }
           else if (nodo->comentario)
           {
                // Los comentarios en VRML pueden aparecer en cualquier lugar y simplemente son '#' + comentario
                // debemos tener cuidado en no generar '#' de ms.
                AnsiString atrib=nodo->atributos;
                atrib=atrib.Trim();
                if (atrib[1]!='#')
                  atrib="# "+atrib;
                AddCadena(atrib, 0, nivelLectura);
           }
           else if (nodo->nombreNodo=="ROUTE")
           {
               // En la captura de los atributos se ha tenido en cuenta de que se trataba de un ROUTE.
               // Se ha preparado de manera que ahora la generacin del cdigo es tan simple como esto:
               AddCadena("ROUTE " + nodo->atributos, 0, nivelLectura);
           }

           else    // Un nodo normal
           {
                if (GN->NumeroDeNodo(nodo->nombreNodo)==-1)
                {
                    AddCadena(PREF_NODOS_NO_REGISTRADOS + nodo->nombreNodo + " {", 0, nivelLectura );
                }else{
                    AddCadena(nodo->nombreNodo + " {", 0, nivelLectura );
                }
           }
   }


   // Si es USE, comentario o ROUTE, todo se ha escrito arriba y no necesita un tratamiento mayor.
   if ( (nodo->use=="") && (!nodo->comentario) && (nodo->nombreNodo != "ROUTE") )
   {
       AddCadena(nodo->atributos, 0 ,nivelLectura + 1); // Incluyo atributos almacenados juntos en nodo.atributos
       nodo->hijosNoLeidos=nodo->hijos->Count; // Nmero de hijos que an quedan por leer, en principio todos.


       while (nodo->hijosNoLeidos)
       {
          containerActual="";
          for(i=0; i<nodo->hijos->Count; i++)
          {
              nodoAux=(NodoXml *)nodo->hijos->Items[i];
              if(nodoAux == NULL)
                 continue;
              // Lo que se lee aqui son nodos, que van explicitamente incluidos dentro de containers dentro de sus
              // nodos padres. Para una lista de hijos se ha de agrupar todos los correspondientes a un tipo de
              // container juntos, aunque esten definidos por separado y mezclados.
              // Se toma el container del primer hijo NO LEIDO que se encuentra y se busca el resto de los hijos que tengan
              // el mismo container. (cuidado pq los comentarios tambin se juntan solos)
              if ( (!nodoAux->leido)&& (containerActual=="") )
              {
                  containerActual=nodoAux->containerField;
                  esMFNode=0;
                  // En el siguiente bucle se mira si es SFNode o MFNode. Esta informacin se usa para la inclusin
                  // o no de los corchetes []
                  for (int j=i+1; j<nodo->hijos->Count; j++)
                  {
                  	// Se busca a partir de la posicin actual ms nodos con el mismo containerField. Si existen
                  	// se deben poner los corchetes [] y si slo esta l, no.
                        nodoAux2=(NodoXml *)nodo->hijos->Items[j];
                        if (nodoAux2->containerField==containerActual)
                                esMFNode++;
                  }

                  // Slo debe aparecer el contenedor (con o sin []) si no se cumplen las siguientes condiciones.
                  if ( (containerActual != "comentarios") && (nodo->nombreNodo != "Escena") && (containerActual != "ProtoInstance" ) && (containerActual != "routes") )
                  {
                     nivelLectura++;
                     if (esMFNode)
                     {
                        nivelLectura++;
                        AddCadena(containerActual + " [ ", 0, nivelLectura);
                     }
                     else
                        AddCadena(containerActual, 0, nivelLectura);
                  }
              }

              // Si el nodo no ha sido ledo con anterioridad y pertenece al containerField que se esta tratando
              // en este momento, se procesa y marca como ledo.
              //if ( !nodoAux->leido && (nodoAux->containerField==containerActual) )  //-> Implementacin original de Edu.
              if ( !nodoAux->leido && ( (nodoAux->containerField==containerActual) ||
                                        ((nodoAux->use != "") && (containerActual == "")) ||
                                        (nodoAux->comentario) )
                  )  // Aadido a la implemtacin original de Edu a 09-07-2006
              {
                 if( (containerActual == "routes") || (containerActual == "comentarios") )
                    containerActual = "";
                 nodo->hijosNoLeidos--;
                 nodoAux->leido = TRUE;
                 nivelLectura++;
                 LecturaRecursiva2(nodoAux);
              }
          }

          // No deben aparecer los corchetes de cierre en agrupaciones de nodos de tipo comentario, escena, protoinstance o routes
          if ( (containerActual != "comentarios") && (nodo->nombreNodo != "Escena") && (containerActual != "ProtoInstance" ) && (containerActual != "routes") )
          {
             if (esMFNode)
                AddCadena("]",0,nivelLectura);
             nivelLectura--;
          }
       }

       // La llave de salida de un nodo. No debe aparecer en el fin del programa generado por la finalizacin
       // de la llamada a LecturaRecursiva desde el nodo Escena (la primera).
       if (nodo->nombreNodo !="Escena")
               AddCadena("}", 0, nivelLectura);
   }
   nivelLectura--;
}
//---------------------------------------------------------------------------
// Para el nodo actual en el parseo XML se obtiene los atributos. La lista TAttrList la genera el XMLparser
// hay que dejar los atributos preparados para pegarlos de manera automtica en la generacin del cdigo VRML
// Adems existen ciertos nodos como el ROUTE que se pueden tratar aqui ya. Finalmente se debe extraer el
// containerField correcto o buscar el de "por defecto".
void __fastcall GestorVRML::GetAttributesNodo(TAttrList *Attributes, NodoXml *nodo)
{
  
  if(Attributes == NULL)
     return;
  AnsiString frNode,frField,toNode,toField;
  
  if (nodo->nombreNodo!="ROUTE")
  {
    for (int i=0; i<=(Attributes->Count-1); i++){

      TAttr* node = (TAttr *)(Attributes->Items[i]);

      AnsiString attrName = node->Name;
      AnsiString attrVal = node->Value;
      
      // Hay algunos atributos especiales que se deben obtener y colocar en su
      // correspondiente lugar en la estructura del arbol.
      if (attrName== "containerField" ){
              nodo->containerField=attrVal;
      }else if(attrName== "DEF"){
          nodo->def=attrVal;
      }else if(attrName== "USE"){
          nodo->use=attrVal;
          //if (nodo->containerField=="")
          //    nodo->containerField=defaultContainerField(nodo->nombreNodo);
      }else{
          nodo->atributos += "   " + attrName + " " + attrVal.Trim() + " " ;
          nodo->atributos += (char)13;
          nodo->atributos += (char)10;
      }
    }
  }else{
    // Se trata de un nodo ROUTE, se deja preparado para luego cuando peguemos los atributos
    for (int i=0; i<=(Attributes->Count-1); i++){
      TAttr* node = (TAttr *)(Attributes->Items[i]);

      AnsiString attrName = node->Name;
      AnsiString attrVal = node->Value;
      if (attrName == ""){
      }else if (attrName == "fromNode"){
        frNode = attrVal;
      }else if (attrName == "fromField"){
        frField = attrVal;
      }else if (attrName == "toNode"){
        toNode = attrVal;
      }else if (attrName == "toField"){
        toField = attrVal;
      }
    }
    // Con esto es muy simple generar el cdigo VRML del ROUTE 
    nodo->atributos = (AnsiString)"  " + frNode + "." + frField + "  TO  " + toNode + "." + toField ;
    nodo->containerField="routes";
  }
   
  // Tras pasar por esta funcin el containerField debe esta correctamente rellenado. Si no estaba 
  // explcitamente en el cdigo XML, se debe buscar en el gestor de nodos cual es el valor
  // por defecto para el tipo de nodo Actual.
  if ( (nodo->containerField=="") || (nodo->containerField==NULL) )
        nodo->containerField=defaultContainerField(nodo->nombreNodo);

}
//---------------------------------------------------------------------------
void __fastcall GestorVRML::GetAttrContainerField(TAttrList *Attributes, NodoXml *nodo)
{
  // Esta funcin es una versin reducida de la anterior. Su misin es obtener el containerField
  // para nodos Script o Proto. El resto de los atributos se ignora ya que se lee sin interpretar
  if(Attributes == NULL)
     return;


  for (int i=0; i<=(Attributes->Count-1); i++){

      TAttr* node = (TAttr *)(Attributes->Items[i]);

      AnsiString attrName = node->Name;
      AnsiString attrVal = node->Value;

      if (attrName== "containerField" ){
              nodo->containerField=attrVal;
      }
  }

  if ( (nodo->containerField=="") || (nodo->containerField==NULL) )
  {
     if ( (GN->NumeroDeNodo(nodo->nombreNodo)==-1) && (nodo->nombreNodo!="Comentario") )
     {
       Nodo *datosPadre = GN->DatosNodo(nodo->padre->nombreNodo);
       if (datosPadre!=NULL)
       {
          int nodoSFMF=0, indiceNodoContenedor=-1;
          for(int c=0; c < datosPadre->numCampos; c++)
          {
              if (datosPadre->campos[c]->nombre== "children")
              {
                  indiceNodoContenedor=c;
                  nodo->containerField = "children";
              }
              if (datosPadre->campos[c]->tipo->numHijos>0)
              {
                nodoSFMF++;
                if ( (nodoSFMF==1) && (indiceNodoContenedor!=-1) )
                    indiceNodoContenedor==c;
              }
          }

          if ( (nodoSFMF==1) && (indiceNodoContenedor!=-1) )
              nodo->containerField = datosPadre->campos[indiceNodoContenedor]->nombre;
          //else
             //Error
        }
     }else{ 
        nodo->containerField=defaultContainerField(nodo->nombreNodo);
     }
   }

}
//---------------------------------------------------------------------------
// Es la funcin utilizada para ir aadiendo el cdigo justificado en
// el TStringList Parseo. Es el cdigo procedente de la interpretacin del
// arbol XML y es un cdigo con codificacin VRML
void __fastcall GestorVRML::AddCadena(AnsiString Cadena, int Tipo, int nivel )
{
  AnsiString tabu="", tabstd="    ";
  int i;

  for (i=0; i<nivel; i++) {
        tabu+=tabstd;
  }

  switch(Tipo){
    case 0:
     {
        Parseo->Append( tabu + Cadena);
        //lineas->Append (tabu + Cadena);
     }
        break;
    //case 1:  Parseo->Append( tabu + "default [ " + Cadena + " ]"); break;
    //case 2:
    //    Parseo->Append( tabu + "default [ ");
    //    Parseo->Append( tabu + tabstd + Cadena );
    //    break;
    default:
     break;
  }
}


