//
//     GESTOR DE TIPOS  
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                En un fichero de configuracin se guardan los tipos de las API
                de H3D asociados a cada campo. Esta clase permite acceder a
                estos datos.
*/

//---------------------------------------------------------------------------

#ifndef GestorTipos_H
#define GestorTipos_H

// Contiene los datos asociados a un tipo de dato.
struct Tipo{
     AnsiString nombre;     // Nombre del tipo de dato.
     TPicture  *icono;      // Contiene el icono asociado al tipo.
     AnsiString nombreIcono;// Contiene el nombre del icono asociado al tipo.
     AnsiString ejemplo;    // Contiene un ejemplo de un dato vlido.
     int  numHijos;         // Puede ser 0,1 o 2:
                            // 0 si el campo no puede tener hijos      -> CAMPO SIMPLE
                            // 1 si el campo puede tener un solo hijo  -> SFNODE
                            // 2 si el campo puede tener 0 o ms hijos -> MFNODE.
                            // NOTA: Esto no es necesario para el caso X3D pero
                            //     si para H3D porque no usa una misma palabra
                            //     para indicar si el campo puede o no tener hijos
                            //    (esto se hace en X3D con SFNODE y MFNODE).
};

class GestorTipos{
private:
//--------------------------------------------- VARIABLES PRIVADAS -----------
     // Nmero de Tipos Almacenados actualmente.
     int NumTipos;

     // Array de punteros a estructuras Tipo que contiene todos los datos.
     Tipo **Tipos;

     // Se usa como buffer para cargar y salvar el fichero en memoria.
     TStringList *Lineas;

//--------------------------------------------- FUNCIONES PRIVADAS -----------

     // Devuelve Lneas con la informacin asociada a los ficheros de
     // configuracin de tipos teniendo en cuenta el tipo de escena.
     void CargaInfoEnLineas();

     // Libera toda la memoria reservada.
     void LiberaMemoria();

     // Carga en memoria todos los datos del fichero de configuracin indicado.
     //  Si se produce un error se mostrar un mensaje informativo
     // y se cerrar el programa.
     bool CargarFichConfInterna(AnsiString configfile,int tipoEscena_);


public:
//--------------------------------------------- VARIABLES PBLICAS -----------
     // Es el tipo de escena al que pertenecen los datos guardados.
     // Ver la declaracin de tipoEscena en Main_.h
     int tipoEscena;

//--------------------------------------------- FUNCIONES PBLICAS -----------
     // Carga en memoria todos los datos del fichero de configuracin indicado.
     //  Si se produce un error se mostrar un mensaje informativo y se intentarn
     // cargar los datos por defecto. Si vuelven a producirse errores se cerrar
     // el programa.
     void CargarFichConf(AnsiString configfile, int tipoEscena_);

     // Guarda todos los datos en configfile.
     // Si se produce algn error al salvar en ficheros se devuelve false.
     bool SalvarFichConf(AnsiString configfile);

     // Devuelve el nmero de tipos almacenados actualmente.
     int GetNumTipos();

     // Aade al gestor un tipo nuevo con los datos que se pasan como parmetro
     // (ver declaracin de Tipo).
     void AnadirTipo(AnsiString nombre,AnsiString nombreIcono,AnsiString ejemplo,int numHijos);

     // Elimina el tipo asociado a index del gestor. Para borrar un tipo a partir
     // de su nombre puede usarse NumeroDeTipo.
     void EliminarTipo(int index);

     // Elimina todos los tipos del gestor.
     void EliminarTodos();

     // Devuelve los datos del tipo i. Rango de valores i = (0..NumTipos()-1)
     // Est sobrecargado pudiendo recibir tambin el nombre del tipo.
     Tipo *DatosTipo(const int i);
     Tipo *DatosTipo(const AnsiString nombretipo);

     // Devuelve el nmero del tipo de nombre <nombretipo>.
     // Si no existe devuelve -1.
     int NumeroDeTipo(const AnsiString nombretipo);

     // Constructor de la clase.
     GestorTipos();
     GestorTipos(const AnsiString configfile,int tipoEscena_);

     // Destructor de la clase.
     ~GestorTipos();
};

#endif

