//
//     GESTOR DE TIPOS  
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                En un fichero de configuracin se guardan los tipos de las API
                de H3D y X3D asociados a cada campo. Esta clase permite
                acceder a estos datos.
*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "GestorTipos_.h"
#include "Main_.h"
#include "Utilidad_.h"
#include "Configuracion_.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

/*
  TIPO               ICONO                   HIJOS          EJEMPLOS
--------           ----------              ---------     -----------
SFBool              SFBool.bmp              Ninguno      <FALSE o TRUE>
SFInt32             SFInt32.bmp             Ninguno      <17  -0xE20  -510>
SFChild             SFChild.bmp             MFNode       <->
MFNode              MFNode.bmp              MFNode       <->
SFNode              SFNode.bmp              SFNode       <->
*/

//--------------------  COSTANTES ----------------------------------------------
// Esta cadena es la que marca el inicio de la informacin de los nodos.
#define MARCA_DE_INICIO "<<<LISTADO DE TIPOS>>>"

// Estas constantes se usan para alnear los datos escritos en el fichero en
// columnas. Estas constantes son el nmero de caracteres asociado a cada columna.
#define COLUMNA_2 19
#define COLUMNA_3 43
#define COLUMNA_4 58

//------------------------------------------------------------------------------
#pragma package(smart_init)

//------------------------------------------------------------------------------
GestorTipos::GestorTipos(){
   NumTipos=0;
   Tipos=NULL;
   tipoEscena = -1;

   try{ Lineas=new TStringList(); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }
}
//------------------------------------------------------------------------------
GestorTipos::GestorTipos(AnsiString configfile,int tipoEscena_){
   NumTipos=0;
   Tipos=NULL;
   try{ Lineas=new TStringList(); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }
   CargarFichConf(configfile,tipoEscena_);
}
//------------------------------------------------------------------------------
GestorTipos::~GestorTipos(){
   LiberaMemoria();
   delete Lineas;
}
//------------------------------------------------------------------------------
void GestorTipos::CargarFichConf(AnsiString configfile,int tipoEscena_){

   // Intentamos cargar los datos del fichero de configuracin:
   if(!CargarFichConfInterna(configfile,tipoEscena_)){

      AnsiString tmp = configfile;
      // Se ha produido un error -> Intentamos cargar los datos por defecto:
      Utilidad.MsgInfo("The default values are going to be loaded.");
      Utilidad.UsarValorPorDefecto(configfile);
      if(CargarFichConfInterna(configfile,tipoEscena_)){
         Utilidad.MsgInfo("The default values has been loaded.");
         // Salvamos los datos para la prxima vez que se inice el programa:
         SalvarFichConf(tmp);
      }else
         Utilidad.MsgInfo("The configuration file with the default values has not been found. The application must be closed.");
   }
}

//------------------------------------------------------------------------------
bool GestorTipos::CargarFichConfInterna(AnsiString configfile,int tipoEscena_){

   LiberaMemoria();
   Lineas->Clear();

   // Empezamos abriendo el fichero de configuracin.
   if(!Utilidad.LoadFromFile(Lineas,configfile,false)){
      Utilidad.FatalError("Configuration file not found.");
      return false;
   }

   // Lo primero que hacemos es buscar la cadena de texto que indica dnde
   // empieza la informacin de los nodos:
   bool encontrada=false;
   int lineIndex=0;
   while( (!encontrada) && (lineIndex < Lineas->Count) )
      encontrada = (0 != Lineas->Strings[lineIndex++].Pos(MARCA_DE_INICIO));

   if(!encontrada)
      Utilidad.FatalError("Format error in the configuration file: " + configfile);

   // lineIndex contiene el ndice de la siguiente lnea a MARCA_DE_INICIO
   // Hay que sumarle 3 para absorver las tres lneas siguientes.
   lineIndex+=3;
   int cont=0;

   // Ahora comenzamos con la lectura de los tipos.
   // En primer lugar vamos a contar el nmero de tipos que hay en el fichero.
   // Por cada lnea tenemos un tipo. Hay que tener en cuenta que puede haber
   // lneas en blanco:
   for(int c=lineIndex; c < Lineas->Count; c++)
      cont += (Lineas->Strings[c].Trim() == "") ? 0 : 1;

   if(cont==0){
      Utilidad.MsgInfo("The configuration file " + configfile + " hasn't any type.","Error");
      return false;
   }

   // Creamos el array de punteros a estructuras Tipo.
   try{ Tipos= new (Tipo *[cont]); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }
   // Inicializamos los valores del array:
   for(int c=0; c < cont; c++)
       Tipos[c]=NULL;

   NumTipos=0;
   tipoEscena=tipoEscena_;

   Tipo *TipoLeido;
   AnsiString tmp,cad;

   // Con cada iteracin del siguiente bucle procesamos una lnea del fichero y
   // creamos un nuevo tipo:
   while( lineIndex < Lineas->Count ){
      // Cargamos en cad la cadena que vamos a procesar comprobando que no sea
      // una cadena en blanco.
      do{
         cad = Lineas->Strings[lineIndex++].Trim();
      }while( (cad == "") && (lineIndex < Lineas->Count) );

      if(cad == "")
         break; // -> Salimos del bucle pq se ha llegado al final de Lineas.

      // Se ha encontrado un nuevo Tipo -> Creamos un nuevo tipo en memoria.

      try{ TipoLeido= new Tipo; }
      catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

      // Vinculamos el nuevo nodo al array:
      Tipos[NumTipos++]=TipoLeido;

      // Ponemos todos los campos a NULL por si salimos de la funcin por algn error.
      //TipoLeido->nombre;  (no es necesario)
      TipoLeido->icono=NULL;
      //TipoLeido->nombreIcono; (no es necesario)
      //TipoLeido->ejemplo; (no es necesario)
      TipoLeido->numHijos=0;

      // A continuacin rellenamos la estructura Tipo con los datos de cad.
      // NOMBRE 
      TipoLeido->nombre = Utilidad.CortaPrimeraPalabra(cad);
      // ICONO  
      TipoLeido->nombreIcono = Utilidad.CortaPrimeraPalabra(cad);
      // Ahora tenemos en TipoLeido->nombreIcono el nombre del fichero que contiene
      // el icono. Vamos a ver si existe y a intertar cargarlo en el TPicture.
      try{ TipoLeido->icono=new TPicture; }
      catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

      // Cargamos la imagen en memoria.
      Utilidad.GetImagen(TipoLeido->icono,TipoLeido->nombreIcono,CONF.ICONO_GENERAL_TIPO);

      // NUMERO DE HIJOS 
      tmp = Utilidad.CortaPrimeraPalabra(cad);
      // Ahora tenemos en tmp el nmero de hijos que puede tener el
      // campo que sea del tipo actual -> Asignamos numHijos:
      if( tmp.UpperCase() == "MFNODE")
         TipoLeido->numHijos = 2;
      else if( tmp.UpperCase() == "SFNODE")
         TipoLeido->numHijos = 1;
      else
         TipoLeido->numHijos = 0;  // corresponde a un campo simple.

      // EJEMPLO
      // Lo que queda en cad es el ejemplo.
      TipoLeido->ejemplo = cad.TrimLeft();
   }
   // No necesitamos el contenido de Lineas -> Liberamos memoria:
   Lineas->Clear();
   return true;
}
//------------------------------------------------------------------------------
int GestorTipos::GetNumTipos(){
   return NumTipos;
}
//------------------------------------------------------------------------------
Tipo *GestorTipos::DatosTipo(int i){
  return ( (i >= 0) && (i < NumTipos) && (Tipos!=NULL) ) ? Tipos[i] : NULL;
}
//------------------------------------------------------------------------------
Tipo *GestorTipos::DatosTipo(AnsiString nombretipo){
   if( (NumTipos == 0) || (Tipos==NULL) )
      return NULL;

   for(int c=0;c < NumTipos;c++){
      if( (Tipos[c] != NULL) && (nombretipo == Tipos[c]->nombre) )
         return Tipos[c];
   }
   return NULL;
}
//------------------------------------------------------------------------------
int GestorTipos::NumeroDeTipo(AnsiString nombretipo){
   if( (NumTipos == 0) || (Tipos==NULL) )
      return -1;

   for(int c=0;c < NumTipos;c++){
     if( (Tipos[c] != NULL) && (nombretipo == Tipos[c]->nombre) )
        return c;
   }
   return -1;
} 
//-----------------------------------------------------------------------------
void GestorTipos::LiberaMemoria(){
   if(Tipos==NULL)
      return;
   for(int c=0; c < NumTipos ; c++){
      if(Tipos[c] != NULL){
         if(Tipos[c]->icono != NULL)
            delete Tipos[c]->icono;

         delete Tipos[c];
      }
   }
   delete Tipos;
   Tipos=NULL;
   NumTipos=0;
}
//-----------------------------------------------------------------------------
void GestorTipos::CargaInfoEnLineas(){

   AnsiString tipo = (tipoEscena == ESCENA_H3D) ? "H3D" : "X3D";

   Lineas->Clear();
   Lineas->Append("");
   if(tipoEscena == ESCENA_H3D)
      Lineas->Append("  FICHERO DE CONFIGURACIN DE TIPOS H3D ");
   else
      Lineas->Append("  FICHERO DE CONFIGURACIN DE TIPOS X3D ");
   Lineas->Append("");
   Lineas->Append("   E.T.S. DE INGENIEROS DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA");
   Lineas->Append("   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E");
   Lineas->Append("                                    INTERFACES 3D CON SENSACIN TCTIL");
   Lineas->Append("   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es");
   Lineas->Append("   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com");
   Lineas->Append("   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es");
   Lineas->Append("   VERSIN:   2.0");
   Lineas->Append("   FECHA:     03/05/2006");
   Lineas->Append("");
   Lineas->Append(" Este fichero almacena los datos de los tipos asociados a los campos de");
   Lineas->Append("los nodos " + tipo + ".");
   Lineas->Append("");
   Lineas->Append("  El objetivo de este fichero de configuracin es ofrecer el mayor grado de");
   Lineas->Append("generalizacin posible al enfocar el diseo del programa. El usuario puede");
   Lineas->Append("cambiar este fichero de configuracin para adaptar el programa a nuevas");
   Lineas->Append("versiones de las libreras " + tipo +" sin necesidad de modificar el cdigo.");
   Lineas->Append("");
   Lineas->Append("  Para cada tipo de dato se guarda la siguiente informacin:");
   Lineas->Append("");
   Lineas->Append("   1 Columna: Nombre del tipo");
   Lineas->Append("   2 Columna: Imagen (asociada al tipo)");
   Lineas->Append("   3 Columna: Nmero de hijos que puede tener el campo (Ninguno,SFNode,MFNode).");
   Lineas->Append("   4 Columna: Ejemplo del formato.");
   Lineas->Append("");
   Lineas->Append("----------------------------------------------------------------------------------------");
   Lineas->Append(MARCA_DE_INICIO);
   Lineas->Append("----------------------------------------------------------------------------------------");
   Lineas->Append("  TIPO               ICONO                   HIJOS          EJEMPLOS");
   Lineas->Append("--------           ----------              ---------      ------------");
}
//-----------------------------------------------------------------------------
bool GestorTipos::SalvarFichConf(AnsiString configfile){

   // Aadimos las lneas de informacin.
   CargaInfoEnLineas();

   if( (Tipos == NULL) || (NumTipos == 0) )
      return Utilidad.SaveToFile(Lineas,configfile,false);


   AnsiString cad;

   // Ahora aadimos la informacin de cada tipo a Lineas:
   for(int c=0; c < NumTipos ; c++){

      if( Tipos[c] != NULL ){

          cad = Tipos[c]->nombre;
          // Al menos aadieremos un espacio:
          do{ cad+= " "; }
          while(cad.Length() < COLUMNA_2);

          cad += Tipos[c]->nombreIcono;

          do{ cad+= " "; }
          while(cad.Length() < COLUMNA_3);

          switch(Tipos[c]->numHijos){
             case 1:  cad+= "SFNode";  break;
             case 2:  cad+= "MFNode";  break;
             default: cad+= "Ninguno";
          }

          do{ cad+= " "; }
          while(cad.Length() < COLUMNA_4);

          cad+=Tipos[c]->ejemplo;

          Lineas->Append(cad);
      }
   }
   return Utilidad.SaveToFile(Lineas,configfile,false);
}
//-----------------------------------------------------------------------------
void GestorTipos::AnadirTipo(AnsiString nombre,AnsiString nombreIcono,
                             AnsiString ejemplo,int numHijos){
   if(nombre.Trim() == "")
      return;

   // No podemos dejar en blanco nombreIcono porque si no no se cargarn bien
   // los datos del fichero.
   if(nombreIcono.Trim() == "")
      nombreIcono = "-";

   // Tipos podra ser NULL y todo funcionara bien:
   // if(Tipos == NULL) return;

   // Lo primero que hay que hacer es ampliar el array:
   Tipo **tiposTmp;
   try{ tiposTmp = new (Tipo *[NumTipos + 1]); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   // Ahora copiamos el array antiguo en el nuevo:
   for(int c=0; c < NumTipos; c++)
      tiposTmp[c] = Tipos[c];

   // Ya podemos borrar Tipos:
   if(Tipos != NULL)
      delete Tipos;
   Tipos = tiposTmp;

   // Ahora creamos un nuevo tipo:
   Tipo *tipo;

   try{ tipo= new Tipo; }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   tipo->nombre      = nombre;
   tipo->nombreIcono = nombreIcono;
   tipo->ejemplo     = ejemplo;
   tipo->numHijos    = numHijos;

   try{ tipo->icono=new TPicture; }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   // Cargamos la imagen en memoria.
   Utilidad.GetImagen(tipo->icono,tipo->nombreIcono,CONF.ICONO_GENERAL_TIPO);

   // Aadimos tipo a la ltima posicion de Tipos:
   Tipos[NumTipos++] = tipo;
}
//-----------------------------------------------------------------------------
void GestorTipos::EliminarTipo(int index){
   if( (Tipos == NULL) || (index >= NumTipos) )
      return;

   // Borramos el Tipo asociado a index:
   if(Tipos[index] != NULL){
      if(Tipos[index]->icono != NULL)
          delete Tipos[index]->icono;
      delete Tipos[index];
      Tipos[index]=NULL;
   }

   // Ahora tenemos que considerar este caso especial:
   if( NumTipos == 1){
      NumTipos = 0;
      delete Tipos;
      Tipos= NULL;
      return;
   }

   // Ahora hay que crear un array nuevo:
   Tipo **tiposTmp;
   try{ tiposTmp = new (Tipo *[NumTipos - 1]); }
   catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

   int indexNuevo=0;
   // Ahora copiamos el array antiguo en el nuevo:
   for(int c=0; c < NumTipos; c++){
      if( c != index)
         tiposTmp[indexNuevo++] = Tipos[c];
   }

   NumTipos--;

   // Ya podemos borrar Tipos:
   delete Tipos;
   Tipos = tiposTmp;
}
//-----------------------------------------------------------------------------
void GestorTipos::EliminarTodos(){
   LiberaMemoria();
}

