//
//     GESTOR DE NODOS     
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Se usan dos ficheros de configuracin para guardar los datos de
                los nodos. Un fichero para nodos X3D y otro para nodos H3D.
                Esta clase permite acceder a los datos guardado en estos ficheros.
*/
#ifndef GestorNodos_H
#define GestorNodos_H
#include "Ficheros.h"
#include "GestorTipos_.h"

//---------------------------------------------------------------------------
// En los ficheros X3D los campos se clasifican en estos cuatro tipos:
// Field: Campos que no pueden ser rutados (ni como origen ni como destino).
// EventOut: Campos que pueden ser rutados hacia otro campo (enviamos un dato).
// EventIn: Campos que pueden ser rutados desde otro campo (recibimos un dato).
// ExposedField: Campos que pueden ser rutados en ambos sentidos.
enum TipoRutadoCampo{FIELD =0, EVENTOUT =1, EVENTIN =2, EXPOSEDFIELD =3};

// Contiene los datos asociados a un campo X3D.
// No necesitamos guardar valores del campo en esta estructura, para eso
// usaremos los tipos de datos definidos en las API. Esta estructura solo la
// usamos para cargar en memoria los datos del fichero de configuracin.
struct Campo{
     AnsiString nombre;          // Nombre del campo.
     Tipo *tipo;                 // Tipo del campo.
     AnsiString valorPorDefecto; // Valor por defecto del campo.
     TipoRutadoCampo rutado;     // Tipo de Rutado del campo.
     AnsiString nombreTipoIndefinido; // A algunos campos se les asocia un
};                               // nombre que no pertenece a ninguno de los
                                 // tipos conocidos esta variable guarda ese
                                 // nombre en estos casos. 

struct Nodo{
     AnsiString nombre;          // Nombre del nodo.
     AnsiString descripcion;     // Descripcin de la funcionalidad del nodo.
     AnsiString tipo;            // Tipo de Nodo (Ver nota(1)).
     AnsiString icono;           // Ruta para un icono asociada al nodo.
     AnsiString imagen;          // Ruta para una imagen asociada al nodo.
     int  numCampos;             // Nmero de campos X3D del nodo.
     Campo **campos;             // Campos del nodo.
     // Informacin Adicional:
     // Campos no X3D
     // Eventos
};
// NOTA 1: Todos los nodos de las API se agrupan en ciertos tipos:
// Geometra, Textura, Materiales, Grouping Nodes, etc. Se agruparn los nodos
// que tengan el mismo nombre en el fichero de configuracin.

class GestorNodos {
private:
//--------------------------------------------- VARIABLES PRIVADAS -----------
     // Nmero de nodos Almacenados actualmente.
     int NumNodos;

     // Array de punteros a estructuras nodo que contiene todos los datos.
     Nodo **Nodos;

     // Algunos tipos que aparecen en la definicin de los nodos no estn
     // definidos y por eso el puntero (Tipo *) de algunos campos estara a NULL.
     // Pero esto conviene evitarlo para prevenir posibles errores. Para
     // evitarlo creamos en el constructor una estructura de tipo Tipo que
     // ser la que usemos en estos casos.
     Tipo *TipoDesconocido;

     // Usaremos esta variable para leer y salvar datos de/a disco. 
     TStringList *Lineas;

//--------------------------------------------- FUNCIONES PRIVADAS -----------
     // Libera toda la memoria reservada.
     void LiberaMemoria();

     // Libera la memoria ocupada por el nodo asociado a la posicin index:
     void LiberaMemoriaNodo(int index);

     // Reserva memoria e inicializa la variable DatosTipoDesconocido
     void AsignarTipoDesconocido();

     // Esta funcin busca la cadena marca en Lineas a partir de index. Va
     // avanzando index hasta que se encuentra marca y despus devuelve en cad
     // el resto de la lnea que hay tras marca (haciendo TrimLeft())
     // Si no se encuentra marca o se produce algn error se devuelve false.
     // devuelve index en la posicin siguiente a la lnea en la que se encontr
     // marca.
     // NOTA: marca debe ser la primera palabra que aparezca en la lnea.
     bool Busca(int &index,AnsiString marca,AnsiString &cad);

     // Escribe en las primeras lneas de Lineas la cabecera de los ficheros
     // de configuracin.
     void CargaInfoEnLineas();

     // Reserva memoria e inicializa la variable NodoGenerico:
     void CreaNodoGenerico();

public:
//--------------------------------------------- VARIABLES PBLICAS -----------
     // Guarda todos los tipos de nodos que hay cargados en memoria.
     TStringList *TiposNodo;
     // Guarda todos los nombres de los campos.
     TStringList *NombresCampos;

     // Es posible leer un fichero X3D en el que aparezca un nodo desconocido.
     // L mejor solucin es considerar stos nodos como "Nodos Genricos" que
     // contienen un solo campo que almacena toda la informacin de los campos
     // del nodo. El gestor de nodos crea un nodo de este tipo al que apunta
     // esta variable:
     Nodo *NodoGenerico;

     // Es el tipo de escena al que pertenecen los datos guardados.
     // Ver declaracion de las constantes: ESCENA_H3D y ESCENA_X3D
     int tipoEscena;

//--------------------------------------------- FUNCIONES PBLICAS -----------
     // Carga en memoria todos los datos del fichero de configuracin indicado.
     // Si se produce un error se mostrar un mensaje informativo y se cerrar
     // el programa.
     // tipoEscena es el tipo de escena al que pertenecen los datos guardados en
     // el fichero de configuracin.
     // Se pasa un puntero al gestor de tipos para obtener un puntero en cada campo
     // que apunte a su tipo de datos asociado (cuidado con los tipos de escena que
     // deben ser correctos).
     void CargarFichConf(AnsiString configfile,int tipoEscena_, GestorTipos *GT);

     // Salva en configfile el contenido actual del gestor.
     // Si se produce un error devuelve false.
     bool SalvarFichConf(AnsiString configfile);

     // Devuelve el nmero de nodos almacenados.
     int GetNumNodos();

     // Devuelve los datos del nodo i. Rango de valores i = (0..NumNodos()-1)
     // Est sobrecargado pudiendo recibir tambin el nombre del nodo.
     Nodo *DatosNodo(int i);
     Nodo *DatosNodo(AnsiString nombrenodo);

     // Devuelve el nombre del container field asociado al nodo que se pasa como parmetro.
     AnsiString GetContainerField(AnsiString nombrenodo);

     // Elimina el nodo asociado a index del gestor.
     void EliminarNodo(int index);

     // Elimina todos los nodos del gestor.
     void EliminarTodos();

     // Aade un nuevo nodo al gestor con todos los atributos sin inicializar y
     // devuelve un puntero a ese nuevo nodo. Desde el exterior se deben
     // inicializar los datos. Devuelve NULL si se produce algn error.
     Nodo *AnadirNodo();

     // Aade un nuevo campo al nodo asociado a indexNodo.
     void AnadirCampo(int indexNodo,AnsiString nombre,Tipo *tipo,
                      TipoRutadoCampo rutado,AnsiString valorPorDef);


     // Elimina el campo indexCampo del nodo asociado a indexNodo.
     // (los dos indices empiezan en 0).
     void EliminarCampo(int indexNodo,int indexCampo);


     // Devuelve true si campo es uno de los campos cargados.
     bool EsCampo(AnsiString campo);

     // Devuelve el nmero del nodo de nombre <nombrenodo>.
     // La numeracin de los nodos comienza en 0.
     // Si no existe devuelve -1.
     int NumeroDeNodo(AnsiString nombrenodo);

     // Devuelve los datos del campo campo del nodo nodo.
     // Rango de valores nodo =  (0..NumNodos()-1)
     //                  campo = (0..[nodo].numCampos-1)
     Campo *DatosCampo(int nodo,int campo);

     // Constructor de la clase.
     GestorNodos();
     GestorNodos(AnsiString configfile,int tipoEscena_,GestorTipos *GT);

     // Destructor de la clase.
     ~GestorNodos();
};

#endif

