//
//     CLASE   FICHEROS    
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta es la clase implementa las funciones ms comunes
                relacionadas con la gestin de ficheros: Lectura, escritura,
                bsqueda de cadenas, insercin, supresin etc.
*/

//---------------------------------------------------------------------------

#ifndef FicherosH
#define FicherosH

#include <fcntl.h>
#include <sys\stat.h>
#include <io.h>
#include <dos.h>
#include <string.h>
#include <errno.h>
#include <iostream.h>
#include <io.h>
#include <conio.h>

// Es el tamao por defecto del buffer.
#define TamBufferPorDefecto 80000

// Esta estructura guarda los datos de una parte del fichero. Funciona como
// un buffer de memoria RAM para evitar hacer muchos accesos a disco.
struct Cursor{
   //Buffer donde guardaremos temporalmente parte del fichero.
   char *buffer;
   //Es el punto del fichero donde empieza el buffer.
   long int inicio;

   // Es el ndice del array.
   long int index;

   // Booleano dice si el buffer ha cambiado. Es decir si se ha escrito.
   // Ser til al rellenar el buffer para ver si hay o no que salvar.
   int modificado;
};

/*****************************************************************************
*****************     C L A S E    F i c h e r o       ***********************
******************************************************************************
  Esta clase gestiona la lectura y la escritura de ficheros.
Permite leer y escribir cadenas o caracteres sueltos (uno a uno) a una
velocidad mayor, ya que usando buffers no se hace un acceso a disco para cada
lectura o cada escritura de un carcter. Funciona como la memoria cache.
La velocidad de lectura y escritura ser en la mayor parte del tiempo, la
misma que si leysemos  escribisemos en un array, esto es gracias al uso
de funciones inline que evitan perder tiempo en las llamadas a funciones
cuando se trata de funciones crticas en velocidad.

ADVERTENCIA: No se debe abrir un mismo fichero con dos objetos distintos.
*/
class Fichero{
private:
//--------------------------------------------- VARIABLES PRIVADAS -----------

   // Es el nmero de bytes que tiene el buffer de memoria que se usa para
   // trabajar con el cursor.
   long int LongBufferCursor;

   // Es el hueco que se deja detrs del cursor cada vez que se carga el
   // buffer para no perder tiempo en volver a cargar datos si hay que
   // retroceder. Tiene un tamao del 5% de LongBufferCursor.
   long int Hueco;

   // Contiene el cursor de lectura/escritura (buffer de memoria).
   Cursor cursor;

   // Es el manejador del fichero que se usa el sistema operativo.
   int file;

   // Se usa en varias funciones (evito declararla varias veces static).
   char letra;

//--------------------------------------------- FUNCIONES PRIVADAS -----------
	   /* Escribe en el fichero el contenido del cursor (si es que se ha
       escrito en el buffer) y pone la variable modificada (del cursor) a falso.
       Despus rellena el cursor dejando un espacio detrs de la posicin actual
       por si hay que volver atrs en la bsqueda de una cadena o algo as. La
       posicin donde se carga el buffer es posicion (dejando el hueco detrs).
	   Devuelve falso si se ha producido un error, consultar Error. Asigna
	   las variables de la estructura cursor: Buffer,inicio,index,modificado*/
	   // ERRORES QUE PUEDE DEVOLVER: 3,5
	   int RellenaBuffer(const long int posicion);

	  // Esta funcin es como _rtl_write pero permite escribir un nmero
        // long int de bytes (mayor que 65534), lo hace sobre el fichero del
        // objeto y adems actualiza la variable de error del objeto.
        // Devuelve -1 si se ha producido un error. El error ser el indicado
        // por errno.
	   int Escribe(const void *puntero,long int bytes);

	  // Esta funcin es como _rtl_read pero permite leer un nmero long int
        // de bytes (mayor que 65534), lo hace sobre del fichero del objeto y
        // adems actualiza la variable de error del objeto. Devuelve -1 si se
        // ha producido un error. El error ser el indicado por errno.
	   int Lee(void *puntero,long int bytes);


	    // Esta funcin inicializa todas las variables. Sin liberar la memoria.
	   void Inicializa();

        // Prepara el objeto para ser usado con otro fichero. Libera la memoria e
        // inicializa las variables, dejando el objeto vaco. No salva los datos.
        // Antes de llamarla es necesario que el objeto ya haya sido inicializado
        // alguna vez.
       void LiberaMemoria();

        // Asigna el valor a la variable Error, segn el valor de errno.
	   void AsignaError();

        // Contina con una parte del proceso de apertura que es comn a todas
        // las funciones de apertura.
        // Devuelve falso si se ha producido un error, consultar Error.
        // ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
        int AperturaComun(int f,char *archivo);

	// Es una funcin que devuelve la letra mayscula de la que recibe.
	inline char CAP(const char x);

public:
//--------------------------------------------- VARIABLES PUBLICAS -----------
	// Booleano que indica el estado del objeto, si hay un fichero o no donde
	// leer/escribir.
	int abierto;

	// Ruta del fichero actual.
	char *nombre;

	// Es el tamao del fichero actual.
	long int tamano;

	// En algunas tareas expresa la relacin posicin actual/tamano as se
	// tiene una idea de cuanto falta por procesar.
	long int Porcentaje;

	// Informa sobre los posibles errores al intentar abrir de cualquier modo
	// el fichero. Valores posibles:
	//  Error a:
	//             0  . . . . . Sin Errores, Fichero abierto sin problemas.
	//             1  . . . . . Ruta no encontrada.
	//             2  . . . . . Demasiados Ficheros Abiertos.
	//             3  . . . . . Permiso Denegado. Ver NOTA *
	//             4  . . . . . Cdigo de Acceso Invlido.
	//             5  . . . . . Manejador de fichero no vlido (Error del programa que use el objeto)
	//             6  . . . . . Objeto Fichero No inicializado.
      //             7  . . . . . Reservado.
	//             8  . . . . . Posicin no vlida.
	//             9  . . . . . No hay Memoria Suficiente.
	//            10  . . . . . Los parmetros no son del mismo dispositivo.
	//
	// NOTA * Al hacer alguna operacin Abrir un fichero, leer de disco
	// escribir a disco etc. Si se produce al escribir a disco puede estar
	// lleno.
	int Error;

//--------------------------------------------- FUNCIONES PUBLICAS -----------
    // Devuelve un booleano, verdadero si el puntero est fuera del fichero.
    // Si estamos escribiendo al final del fichero de modo que con cada
    // carcter escrito aumenta en 1 el tamao del fichero siempre devolvera
    // verdadero (porque estamos fuera del fichero).
	// ERRORES QUE PUEDE DEVOLVER: ninguno.
	int Final();

	// Devuelve la posicin actual donde estel cursor.
	// ERRORES QUE PUEDE DEVOLVER: ninguno.
	long int GetPos();

	// Pone el cursor apuntando a la posicin indicada.
	// Devuelve falso si se ha producido un error, consultar Error.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	int Seek(long int pos);

	// Es un Seek a la posicin actual menos n. Puede ser cmoda en algunos
	// casos, bsqueda de cadenas etc.
	// Devuelve falso si se ha producido un error, consultar Error.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	inline int Retrocede(const long int n);

	// Devuelve un booleano indicando si el fichero ha sido modificado.
	// ERRORES QUE PUEDE DEVOLVER: Ninguno.
	int Modificado();

	// Lee el carcter del punto del fichero donde est el cursor y lo
	// adelanta una posicin. error es un valor booleano que pasa por
	// referencia para poder devolver si se ha producido un error.
	// ERRORES QUE PUEDE DEVOLVER: 3,5,
	inline char LeeCaracter(int &error);
	// Funcin sobrecargada por si no interesa el error.
	char LeeCaracter();

	// Escribe el carcter en el punto del fichero donde est el cursor y
	// lo adelanta una posicin.
	// Devuelve falso si se ha producido un error, consultar Error.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	int EscribeCaracter (const char caracter);

	// Lee los tam caracteres del fichero a partir de la posicin del cursor
	// cargandolos en la cadena.
	// NOTA: Se aadir el carcter terminador de cadenas por si se trata de
	// una cadena de texto. Pero vale tambin para ficheros binarios.
	// El tamao de la cadena debe ser tam+1 (para el '\0').
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	int LeeCadena(char *cadena,const long int tam);

	// Como el anterior pero se lee una lnea del fichero por cada llamada.
	// Los caracteres terminadores de lnea del fichero, 13 y 10, pasan a ser
	// el terminador de cadenas.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	int LeeCadenaTexto(char *cadena);

	// Escribe los tam caracteres de la cadena en el fichero a partir de la
	// posicin del cursor.
	// NOTA: No se tienen en cuenta los caracteres terminadores, solo se
	// escriben los tam bytes sean los que sean (Versatilidad para ficheros
        // binarios o de texto).
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	int EscribeCadena(const char *cadena,const long int tam);

	// Como la anterior pero la cadena ahora es de texto y el tamao ser
	// el de la cadena de texto. Tambin se escriben en el fichero los
	// caracteres terminadores 13 y 10. Si la cadena es NULL se escribe un
	// salto de lnea en el fichero.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
 	int EscribeCadenaTexto(const char *cadena);

	// Como la anterior pero la cadena ahora no se escriben en el fichero los
	// caracteres terminadores 13 y 10. Si la cadena es NULL no se escribe nada.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
 	int EscribeCadenaTexto2(const char *cadena);

	// Devuelve un booleano indicando si existe o no el archivo.
	int Existe(const char *archivo);

	// Abre el Fichero.
	// Devuelve falso si se ha producido un error, consultar Error.
	// ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
	int Abrir(char *archivo);

	// Si archivo no existe lo crea y si ya exista lo borra y lo abre con
	// tamao cero.
	// Devuelve falso si se ha producido un error, consultar Error.
	// ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
	int Crear(char *archivo);

	// Si el fichero existe lo abre (sin borrarlo) y si no existe lo crea.
	// Devuelve falso si se ha producido un error, consultar Error.
	// ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
	int AbrirOCrear(char *archivo);

	// Abre el Fichero y pone el puntero 0 al final. Ver Variable Error. Si no
	// existe lo crea.
	// Devuelve falso si se ha producido un error, consultar Error.
	// ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
	int AbrirAlFinal(char *archivo);

	// Borra el fichero si archivo es != NULL o borra el fichero actualmente
	// abierto.
	// ERRORES QUE PUEDE DEVOLVER: 1,3
	int Borrar(char *archivo=NULL);

	// Renombra el archivo, puede usarse para mover un archivo. Si el archivo
	// nuevo existe se sobreescribe con el antiguo.
	// Devuelve falso si se produce algn error.
	// ERRORES QUE PUEDE DEVOLVER: 1,3,10
	int Renombrar(char *antigua,char *nueva);

	// Cierra el Fichero. No Es necesario hacerlo lo hace el destructor.
	// Devuelve falso si se ha producido un error, consultar Error.
	// ERRORES QUE PUEDE DEVOLVER: 3,5,6
	int CerrarFichero();

	// Lee linealmente el fichero desde la posicin en que se encuentre el
	// cursor hasta encontrar la cadena Cadena y entonces devuelve
	// verdadero (!=0) y deja el cursor en el siguiente carcter a la cadena
	// encontrada. Se pueden distinguir maysculas de minsculas o no,
	// dependiendo del valor del booleano distinguir. La bsqueda ser ms
	// rpida si se distingen. Error es un boolenano que indica si se ha
	// producido un error.
	// Usa la variable Porcentaje que puede ser consultada por otra tarea.
	// Dar en tanto % la relacin Posicin_actual/tamano.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
	int BuscaCadena(char *Cadena,int distinguir, int &error);
	int BuscaCadena(char *Cadena,int distinguir);     

	// Lee linealmente el fichero desde la posicin del cursor, hasta
	// encontrar la Cadena y entonces devuelve verdadero (!=0) y deja el
	// cursor en el siguiente carcter a la cadena encontrada. La cadena es
	// una cadena binaria y no una cadena de texto, por tanto no hay carcter
	// terminador, as longit dice el nmero de bytes de la cadena a
	// localizar. Error es un boolenano que indica si se ha producido un error.
	// Usa la variable Porcentaje que puede ser consultada por otra tarea.
	// Dar en tanto % la relacin Posicin_actual/tamano.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
	int BuscaCadenaBinaria(char *Cadena,int longit,int &error);

	// Hace un hueco de Hueco__ caracteres en la posicin del cursor cursor.
	// Devuelve un booleano indicando si se ha producido un error.
	// Long2Buffers es el nmero de bytes que tendr cada uno de dos buffers
	// temporales que se usan, a mayor tamao ms rapidez en ficheros grandes
	// y mayores dificultades para reservar la memoria.
      // Long2Buffers debe ser mayor o igual que Hueco__.
	// El puntero del fichero queda en la misma posicin que estaba antes
	// de llamar a la funcin, esto es: Getpos devuelve lo mismo antes que
	// despus de llamar a la funcin.
	// Usa la variable Porcentaje que puede ser consultada por otra tarea.
	// Dar en tanto % la relacin Posicin_actual/tamano.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
	int Insertar(long int Hueco__,long int Long2Buffers);

	// Suprime el nmero de caracteres indicado por n de la posicin actual
	// del cursor como si se tratase de un procesador de texto. Devuelve un
	// booleano indicando si se ha producido un error. LongBuffer es el
	// nmero de bytes que tendr un buffer temporal que se usa, a mayor
	// tamao ms rapidez en ficheros grandes y mayores dificultades para
	// reservar la memoria.
	// Usa la variable Porcentaje que puede ser consultada por otra tarea.
	// Dar en tanto % la relacin Posicin_actual/tamano.
	//  ERRORES QUE PUEDE DEVOLVER: 3,5
	// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
	int Suprimir(long int n,long int LongBuffer);

	// Esta funcin busca la cadena buscada y la sustituye por la cadena
	// sustituta, las longitudes de ambas cadenas no tiemen por qu coincidir.
	// todas es un booleano si es verdadero se sustituirn todas las cadenas
	// encontradas si es falso solo la primera.
	// distinguir es un booleano que indica si al buscar la cadena se
	// distinguirn o no maysculas de minsculas.
	// longbuffers ser el tamao de dos buffers que se crearn temporalmente
	// en la funcin, a mayor valor ms rapidez en ficheros grandes.
	// Se busca a partir de la posicin actual de cursor. Devuelve el nmero
	// de cadenas encontradas y sustituidas. Si devuelve cero puede haber
	// algn Error (consultar Error) o que no se haya encontrado la cadena.
	// ERRORES QUE PUEDE DEVOLVER: 3,5
	// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
	long int Sustituir(char *buscada,char *sustituta,int todas,int distinguir,
                       long int longbuffers);

	// FUNCION QUE NO ES DE LA CLASE:
	// Copia el fichero origen en el fichero destino, ambos desde la posicin
	// donde se encuentren y hasta el final de Origen. Devuelve un booleano
	// indicando si ha habido un error. Si es verdadero el Error puede estar
	// en el fichero origen o en el de destino.
	// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
	// int CopiaFicheros(Fichero &Origen,Fichero &Destino);
	//									   ,int CursorDestino=0)

//--------------------------------------------Constructores-y-Desturctores----
//----------------------------------------------------------------------------
	Fichero();  // Es el constructor por defecto.
	// TamanoBufferCursor es el nmero de bytes que se usarn como buffer para
	// el cursor.
	Fichero(long int TamanoBufferCursor); // Crea la estructura en memoria sin archivo asociado.

	// Permite crear el objeto con un archivo asociado.
	// archivo es la ruta del archivo y modo dice que funcin se usar para
	// abrirlo:
	// Modo 1 . . . . . . void Abrir(char *archivo);
	// Modo 2 . . . . . . void Crear(char *archivo);
	// Modo 3 . . . . . . void AbrirOCrear(char *archivo);
	// Modo 4 . . . . . . void AbrirAlFinal(char *archivo);
	// No Olvidar Consultar Error para ver los posibles fallos.
	// TamanoBufferCursor es el nmero de bytes que se usarn como buffer para
	// el cursor (si no se especifica se usar el tamao por defecto).
	Fichero(char *archivo,int modo,long int TamanoBufferCursor=0);


	~Fichero(); // Destructor de la clase. Cierra el fichero salvndolo.
};
/*****************************************************************************
*****************   F I N   D E   L A   C L A S E   **************************
*****************************************************************************/


#endif
