//
//     CLASE   FICHEROS    
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta es la clase implementa las funciones ms comunes
                relacionadas con la gestin de ficheros: Lectura, escritura,
                bsqueda de cadenas, insercin, supresin etc. 
*/

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Ficheros.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

/*****************************************************************************
****************  Objeto Fichero  ********************************************
*****************************************************************************
     Versin 1.0
     Fecha 01/11/2002
*/


//---------------------- CONSTRUCTORES DE LA CLASE FICHERO -------------------
Fichero::Fichero()
{
   LongBufferCursor=TamBufferPorDefecto;
   Hueco=(LongBufferCursor*5)/100;  // Es el 5%
   Inicializa();
   // El buffer solo puede crearse en el constructor.
   try{cursor.buffer=new char[LongBufferCursor]; }
   catch(...){       Error=9; /* No hay memoria Suficiente.*/ }
}

Fichero::Fichero(long int TamanoBufferCursor)
{
   LongBufferCursor=TamanoBufferCursor;
   Hueco=(LongBufferCursor*5)/100;  // Es el 5%
   Inicializa();
   // El buffer solo puede crearse en el constructor.
   try{cursor.buffer=new char[LongBufferCursor]; }
   catch(...){       Error=9; /* No hay memoria Suficiente.*/ }
}

/* Permite crear el objeto con un archivo asociado. archivo es la ruta del
archivo y modo dice que funcin se usar para abrirlo:
	   Modo 1 . . . . . . void Abrir(char *archivo);
	   Modo 2 . . . . . . void Crear(char *archivo);
	   Modo 3 . . . . . . void AbrirOCrear(char *archivo);
	   Modo 4 . . . . . . void AbrirAlFinal(char *archivo); */
// No Olvidar Consultar Error para ver los posibles fallos.
Fichero::Fichero(char *archivo,int modo,long int TamanoBufferCursor)
{
    LongBufferCursor= (TamanoBufferCursor>0) ? TamanoBufferCursor : TamBufferPorDefecto;
    Hueco=(LongBufferCursor*5)/100;  // Es el 5%
    Inicializa();
    // El buffer solo puede crearse en el constructor.
    try{cursor.buffer=new char[LongBufferCursor]; }
    catch(...){       Error=9; /* No hay memoria Suficiente.*/ }
    switch (modo)
    {
	     case 1: Abrir(archivo);          break;
	     case 2: Crear(archivo);          break;
	     case 3: AbrirOCrear(archivo);    break;
	     case 4: AbrirAlFinal(archivo);
    }
}

Fichero::~Fichero()
{
	CerrarFichero();
	LiberaMemoria();
	if (cursor.buffer != NULL)
           delete cursor.buffer;
}

//------------------------------- FUNCION PRIVADA: RellenaBuffer() -----------
/* Escribe en el fichero el contenido del cursor (si es que se ha
escrito en el buffer) y pone la variable modificada (del cursor) a falso.
Despus rellena el cursor dejando un espacio detrs de la posicin actual
por si hay que volver atrs en la bsqueda de una cadena o algo as. La
posicin donde se carga el buffer es posicion (dejando el hueco detrs).
Devuelve falso si se ha producido un error, consultar Error. Asigna
las variables de la estructura cursor: Buffer,inicio,index,modificado*/
// ERRORES QUE PUEDE DEVOLVER: 3,5
int Fichero::RellenaBuffer(const long int posicion)
{
/*----------------------------------------------------------------------------
 Tenemos que leer del disco a memoria, pero antes hay que escribir a disco
el contenido del buffer si se ha modificado.
   1) Escribimos a disco el buffer (si se ha modificado).
   2) Actualizamos la variable del cursor a no modificada.
   3) Leemos de disco a memoria, dejando un hueco al principio por si hay que
   retroceder. Si estamos al final, solo cargamos el hueco que tenemos que
   dejar detrs.
----------------------------------------------------------------------------*/

   // 1) Escribimos a disco el buffer si se ha modificado.
   if (cursor.modificado)
   {  // Escribimos el buffer modificado a disco.
	   lseek(file,cursor.inicio,0);  // Supongo que no da error porque los argumentos son vlidos.
   	   // Vamos a distinguir el caso de buffer con todos los
         // caracteres tiles de cuando el final del buffer no vale.
	if ( (LongBufferCursor + cursor.inicio) <= tamano)
	{
	     if ((-1) == Escribe((void *)(cursor.buffer),LongBufferCursor))
	     {
	     		AsignaError();
	     		return 0;
		}
	}
	else
	{
		if ((-1) == Escribe((void *)(cursor.buffer),tamano - (cursor.inicio)))
		{
			AsignaError();
			return 0;
		}
	}
   }

//   2) Actualizamos la variable del cursor a no modificada.
   cursor.modificado = 0;


//   3) Leemos de disco a memoria, dejando un hueco al principio por si hay
//   que retroceder. Si estamos al final, solo cargamos el hueco que tenemos
//   que dejar detrs.

	// Posicionamos el puntero del fichero teniendo en cuenta el hueco de atrs.
	if ((posicion - Hueco) >= 0)
	{
		lseek(file,posicion-Hueco,0);
		cursor.inicio=posicion-Hueco;
	}
	else
	{
		lseek(file,0,0);
		cursor.inicio=0;
	}
	cursor.index=posicion - (cursor.inicio);
	// Ahora solo falta rellenar el buffer leyendo de disco pero tenemos que
	// tener en cuenta que podra acabarse el fichero.
	if ((tamano - (cursor.inicio))  >= LongBufferCursor)
	{
		if ( (-1) == Lee((void *)(cursor.buffer) ,LongBufferCursor))
		{   // Se ha producido un Error.
			AsignaError();
			return 0;
		}
	}
	else
	{
		if ( (-1) == (Lee((void *)(cursor.buffer) ,(tamano - (cursor.inicio)))))
		{
			AsignaError();
			return 0;
		}
	}
	return 1;  // Sin Errores.
}

//------------------------------- FUNCION PRIVADA: Escribe() -----------------
// Esta funcin es como _rtl_write pero permite escribir un nmero
// long int de bytes (mayor que 65534), lo hace sobre el fichero del
// objeto y adems actualiza la variable de error del objeto.
// Devuelve -1 si se ha producido un error. El error ser el indicado por errno.
int Fichero::Escribe(const void *puntero,long int bytes)
{
	while (bytes)
	{
		if (bytes >= 65500)
		{
			if ((-1) ==_rtl_write(file,puntero,(unsigned int)65500))
				return -1;
			bytes-=65500;
			puntero=(void *)(   ((long int)puntero) + 65500   );
		}
		else
		{
			if ((-1) == _rtl_write(file,puntero,(unsigned int)bytes))
				return -1;
			bytes=0;
		}
	}
	return 0;
}
//------------------------------- FUNCION PRIVADA: Lee() ---------------------
// Esta funcin es como _rtl_read pero permite leer un nmero long int
// de bytes (mayor que 65534), lo hace sobre del fichero del objeto y
// adems actualiza la variable de error del objeto. Devuelve -1 si se
// ha producido un error. El error ser el indicado por errno.
int Fichero::Lee(void *puntero,long int bytes)
{
	while (bytes)
	{
		if (bytes >= 65500)
		{
			if ((-1) == _rtl_read(file,puntero,(unsigned int)65500))
				return -1;
			bytes-=65500;
			puntero=(void *)(   ((long int)puntero) + 65500   );
		}
		else
		{
			if ((-1) == _rtl_read(file,puntero,(unsigned int)bytes))
				return -1;
			bytes=0;
		}
	}
	return 0;
}

//------------------------------- FUNCION PRIVADA: Inicializa() --------------
// Esta funcin inicializa todas las variables. Sin liberar la memoria.
void Fichero::Inicializa()
{
   file=0;
   abierto=0;  // abierto a falso.
   nombre=NULL;
   Porcentaje=0;
   tamano=0;
   Error=6;
}

//------------------------------- FUNCION PRIVADA: LiberaMemoria() -----------
// Prepara el objeto para ser usado con otro fichero. Libera la memoria e
// inicializa las variables, dejando el objeto vaco. No salva los datos.
// Antes de llamarla es necesario que el objeto ya haya sido inicializado
// alguna vez.

void Fichero::LiberaMemoria()
{
   // El contenido del buffer que hay en cursor no se libera (poque solo se
   // puede especificar desde el exterior desde el constructor.
   // Y as cursor.buffer se crea en los constructores y se libera en el
   // destructor.
   if (nombre)
	  delete nombre;
   Inicializa();  // Inicializa pone a NULL Cursores y nombre.
}
//------------------------------- FUNCION PRIVADA: AsignaError() -------------
// Da el valor a la variable Error, tras abrirse un fichero cuando ha habido
// un error. Para ello usa la variable errno del compilador
void Fichero::AsignaError()
{
		switch (errno)
		{
			case ENOENT:
				Error=1;   // No se Encuentra la Ruta.
				break;

			case EMFILE:
				Error=2;   // Demasiados Ficheros Abiertos.
				break;

			case EACCES:   // Permiso Denegado al hacer alguna Operacin.
				Error=3;   // Por Ejemplo abrir un fichero o leer a disco.
				break;     // (Si se produce al escribir disco lleno).

			case EINVACC:
				Error=4;   // Cdigo de Acceso Invlido.
				break;

			case EBADF:
				Error=5;   // Nmero de Manejador no Vlido (Error del programa).
						   // Error nunca valdr5 salvo error del programa
						   // que use el objeto.
			case ENOTSAM:
				Error=10;   // Al renombrar un archivo. (no son el mismo dispositivo).

			// Error = 6; Reservado para Objeto no inicializado.
			// Error = 7; Reservado
			// Error = 8; Reservado para posicin no vlida.
			// Error = 9; Reservado para insuficiente memoria.
		}
}

//------------------------------- FUNCION PRIVADA: AperturaComun() -----------
// Continua con una parte del proceso de apertura que es comn a todas las
// funciones de apertura.
// ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
int Fichero::AperturaComun(int f,char *archivo)
{
 if (f == (-1)) // Ha habido un error en la apertura.
 {
	AsignaError();
	return 0;
 }
 else  // Fichero Abierto Correctamente.
 {
   file=f;
   abierto=1;
   if (nombre)
	 delete nombre;
   try{ nombre=new char[1+strlen(archivo)]; }
   catch(...){ nombre=NULL; }

   if (nombre != NULL)
   {
	  unsigned int cont=0;
	  do   // Copiamos el nombre del archivo a la variable de la clase.
	  {
		  nombre[cont]=archivo[cont];
	  }while(archivo[cont++] != '\0');
   }
   tamano=filelength(file);
   Error=0;
   //Hacemos apuntar todos al cursor al principio del fichero.
   // No vale hacerlo con Seek porque Seek no siempre lee de disco.

   cursor.inicio=0;
   cursor.index=0;
   cursor.modificado=0;
   for(long int c=0;c < LongBufferCursor;c++)
   {
   	(cursor.buffer)[c]='\0';
   }
   if (abierto)
   {
   	RellenaBuffer(0);
   }

   if (tamano == (-1))
   {
	   AsignaError();    // Error: Nmero de manejador no vlido.
	   CerrarFichero();  // Esto significara que el programa tiene un error
                           // o el sistema.
	   return 0;
   }
 }
 return 1;
}

//------------------------------- FUNCION PRIVADA: CAP() ---------------------
// Es una funcin que devuelve la letra mayscula de la que recibe.
inline char Fichero::CAP(const char x)
{
	 if ( (x>=97) && (x<=122) ) return (char) (((int)x)-32);
	 if  (x=='')              return 'A';
	 if  (x=='')              return 'E';
	 if  (x=='')              return 'I';
	 if  (x=='')              return 'O';
	 if  (x=='')              return 'U';
	 if  (x=='')              return '';
	 if  (x=='')              return 'A';
	 if  (x=='')              return 'E';
	 if  (x=='')              return 'I';
	 if  (x=='')              return 'O';
	 if  (x=='')              return 'U';
	 return x;
}


//------------------------------- FUNCION PUBLICA: Final() -------------------
// Devuelve un booleano, verdadero si el puntero est fuera del fichero.
// Si estamos escribiendo al final del fichero de modo que con cada
// carcter escrito aumenta en 1 el tamao del fichero siempre devolvera
// verdadero (porque estamos fuera del fichero).
// ERRORES QUE PUEDE DEVOLVER: ninguno.
int Fichero::Final()  // Por defecto cursor a cero.
{
	return (tamano <= ((cursor.inicio) + (cursor.index))) ? 1 : 0;
}

//------------------------------- FUNCION PUBLICA: GetPos() ------------------
// Devuelve la posicin actual donde estel cursor.
// ERRORES QUE PUEDE DEVOLVER: ninguno.
long int Fichero::GetPos() // Por defecto cursor a cero.
{
	return cursor.inicio + cursor.index;
}

//------------------------------- FUNCION PUBLICA: Seek() --------------------
// Pone el cursor apuntando a la posicin indicada.
// Devuelve falso si se ha producido un error, consultar Error.
// ERRORES QUE PUEDE DEVOLVER: 3,5
int Fichero::Seek(long int pos)
{
   // 1 Vemos si la posicin pedida est dentro del buffer.
   if ( (pos >= (cursor.inicio)) && (pos < ((cursor.inicio))+LongBufferCursor) )
   { // La posicin pedida est dentro del buffer, solo hay que deplazar el puntero.
	   cursor.index= pos - (cursor.inicio);
	   return 1;
   }
   else  // Hay que rellenar el buffer.
   {
	   return RellenaBuffer(pos);
   }
}

//------------------------------- FUNCION PUBLICA: Retrocede() ---------------
// Es un Seek a la posicin actual menos n. Puede ser cmoda en algunos
// casos, bsqueda de cadenas etc.
// Devuelve falso si se ha producido un error, consultar Error.
// ERRORES QUE PUEDE DEVOLVER: 3,5
inline int Fichero::Retrocede(const long int n)
{
	return Seek(GetPos()-n);
}

//------------------------------- FUNCION PUBLICA: Modificado() --------------
// Devuelve un booleano indicando si el fichero ha sido modificado.
// ERRORES QUE PUEDE DEVOLVER: Ninguno.
int Fichero::Modificado()
{
	return cursor.modificado;
}

//------------------------------- FUNCION PUBLICA: LeeCaracter() -------------
// Lee el carcter del punto del fichero donde est el cursor y lo
// adelanta una posicin. error es un valor booleano que pasa por
// referencia para poder devolver si se ha producido un error.
// ERRORES QUE PUEDE DEVOLVER: 3,5,
inline char Fichero::LeeCaracter(int &error) //Por defecto cursor a 0.
{ /*
	1) Si no est el carcter en el buffer hay que rellenarlo pero antes.
	2) Comprobaramos si el buffer se ha mofidicado y lo escribiramos a disco.
      3) Actualizamos nuestro buffer leyendo desde el disco. Dejando un
	   hueco detrs por si hubiese que retroceder.(si estamos al final del
  	   fichero cargamos la parte de atrs solo y actualizamos variables del
	   manejador).
	4) Tenemos el carcter en el buffer y lo leemos.
	  Parte de estos puntos los harla funcin Privada RellenaBuffer.  */

	  //Se supone que index est en una posicin vlida del buffer. El
	  // programa est hecho para que siempre index valga un valor correcto
	  // que pertenezca al array.

	  letra=cursor.buffer[cursor.index++];
	  if ( (cursor.index) >= LongBufferCursor)
	  {
		   RellenaBuffer(cursor.inicio + cursor.index);
	  }
	  error= Error ? 1 : 0;
	  return letra;
}
// Funcin sobrecargada por si no interesa el error.
char Fichero::LeeCaracter() //Por defecto cursor a 0.
{
	  letra=cursor.buffer[cursor.index++];
	  if ( (cursor.index) >= LongBufferCursor)
	  {
		   RellenaBuffer(cursor.inicio + cursor.index);
	  }
	  return letra;
}

//------------------------------- FUNCION PUBLICA: EscribeCaracter() ---------
// Escribe el carcter en el punto del fichero donde est el cursor y
// lo adelanta una posicin.
// Devuelve falso si se ha producido un error, consultar Error.
// Es una funcin inline un poco larga, es mejor no usarla mucho o
// usar la funcin EscribeCaracter_ que no es inline.
// ERRORES QUE PUEDE DEVOLVER: 3,5
int Fichero::EscribeCaracter(const char caracter)
{ /*
 1) Si el buffer del cursor est lleno y modificado lo escribimos a disco.
 2) Cargamos el buffer dejando un hueco atrs por si hay que retroceder
 (an estando al final del fichero). Actualizamos el cursor.
 3) Escribimos el caracter en el buffer del cursor.
 Parte de estos puntos los har la funcin Privada RellenaBuffer.*/

	  static long int pos;

	  pos= (cursor.inicio) + (cursor.index);
	  // Se incrementa siempre y al principio an pudiendo haber un error de
	  // escritura (p.e.disco lleno) por que Rellena buffer requiere el
	  // valor correcto de tamao.
	  if (Final())
		 tamano++;

	  //Se supone que index esten una posicin vlida del buffer. El
	  // programa est hecho para que siempre index valga un valor correcto
	  // que pertenezca al array.

         if ( (pos >= (cursor.inicio)) && (pos < ((cursor.inicio))+LongBufferCursor) )
	  {
		  cursor.modificado=1;
		  cursor.buffer[pos-(cursor.inicio)]=caracter;
	  }

	  (cursor.index)++;
	  if ( (cursor.index) >= LongBufferCursor)
	  {
		  if (!RellenaBuffer(cursor.inicio+cursor.index))
		  {  // Se ha producido un error y no se ha escrito a disco.
			 if (Final())
				tamano--; // Antes lo habamos incrementado.
			 return 0;
		  }
	  }
	  return 1;
}

//------------------------------- FUNCION PUBLICA: LeeCadena() ---------------
// Lee los tam caracteres del fichero a partir de la posicin del cursor
// cargandolos en la cadena.
// NOTA: Se aadir el carcter terminador de cadenas por si se trata de
// una cadena de texto. Pero vale tambin para ficheros binarios.
// El tamao de la cadena debe ser tam+1 (para el '\0').
// ERRORES QUE PUEDE DEVOLVER: 3,5
int Fichero::LeeCadena(char *cadena,const long int tam) //Por defecto cursor a 0.
{
	if (Final())
	{
		cadena[0]='\0';
		return 1;
	}
	int error=0;
	long int cont=0;
	while ((!Final()) && (cont < tam) && (!error))
	{
		cadena[cont++]=LeeCaracter(error);
	}
	cadena[cont]='\0';
	if (error)
		return 0;
	return 1;
}

//------------------------------- FUNCION PUBLICA: LeeCadenaTexto() ----------
// Como el anterior pero se lee una lnea del fichero por cada llamada.
// Los caracteres terminadores de lnea del fichero, 13 y 10, pasan a ser
// el terminador de cadenas.
// ERRORES QUE PUEDE DEVOLVER: 3,5
int Fichero::LeeCadenaTexto(char *cadena) //Por defecto cursor a 0.
{
	if (Final())
	{
		cadena[0]='\0';
		return 1;
	}
	int error;
	long int cont=0;
	cadena[cont]=LeeCaracter(error);
	while ((!Final()) && (cadena[cont] != char(13)) && (!error))
	{
		cadena[++cont]=LeeCaracter(error);
	}
	if (error)
	{
		cadena[cont]='\0';
		return 0;
	}
	if (!(Final()) && (cadena[cont] == char(13)))
		LeeCaracter(error);  // absovemos el caracter 10.
	if (error)
		return 0;
	cadena[cont]='\0';
	return 1;
}

//------------------------------- FUNCION PUBLICA: EscribeCadena() ----------
// Escribe los tam caracteres de la cadena en el fichero a partir de la
// posicin del cursor.
// NOTA: No se tienen en cuenta los caracteres terminadores, solo se
// escriben los tam bytes sean los que sean (Versatilidad para ficheros
// binarios o de texto).
int Fichero::EscribeCadena(const char *cadena,const long int tam)
{
	for (long int cont=0;cont < tam;)
	{
		if (!EscribeCaracter(cadena[cont++]))
			return 0;
	}
	return 1;
}

//------------------------------- FUNCION PUBLICA: EscribeCadenaTexto() -----
// Como la anterior pero la cadena ahora es de texto y el tamao ser
// el de la cadena de texto. Tambin se escriben en el fichero los
// caracteres terminadores 13 y 10. Si la cadena es NULL se escribe un
// salto de lnea en el fichero.
// ERRORES QUE PUEDE DEVOLVER: 3,5
int Fichero::EscribeCadenaTexto(const char *cadena) //Por defecto cursor a 0.
{
	long int cont=0;
	while(cadena[cont] != '\0')
	{
		if (!EscribeCaracter(cadena[cont++]))
			return 0;
	}
	if (!EscribeCaracter((char)13))
		return 0;
	if (!EscribeCaracter((char)10))
		return 0;
	return 1;
}

// Como la anterior pero la cadena ahora no se escriben en el fichero los
// caracteres terminadores 13 y 10. Si la cadena es NULL no se escribe nada.
// ERRORES QUE PUEDE DEVOLVER: 3,5
int Fichero::EscribeCadenaTexto2(const char *cadena){
	long int cont=0;
	while(cadena[cont] != '\0')
	{
		if (!EscribeCaracter(cadena[cont++]))
			return 0;
	}
	return 1;
}


//------------------------------- FUNCION PUBLICA: Existe() ------------------
// Devuelve un booleano indicando si existe o no el fichero archivo.
int Fichero::Existe(const char *archivo)
{
	int f=open(archivo,O_BINARY | O_RDWR);
	if (f != -1) // fichero Abierto correctamente.
	{
		close(f);
		return 1;
	}
	// En este punto sabemos que ha habido un error al abrir el archivo.
	if (errno == ENOENT)
		return 0;
//	if (errno == EMFILE)  //Supongo que se intenta abrir porque si que existe.
//		return 1;
	// En los otros dos casos no se que pasa supongo que el fichero existe
	return 1;
/*  Posibles Errores:
ENOENT   (No such file or directory)
EMFILE   (Too many open files)
EACCES   (Permission denied)
EINVACC  (Invalid access code) */
}

//------------------------------- FUNCION PUBLICA: Abrir() -------------------
// Abre el Fichero.
// Devuelve falso si se ha producido un error, consultar Error.
// ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
int Fichero::Abrir(char *archivo)
{
 if (abierto)         // Si el fichero estaba abierto lo cerramos.
	CerrarFichero();

 // Lo abrimos en binario y para lectura y escritura.
 return AperturaComun(open(archivo,O_BINARY | O_RDWR),archivo);
 // (open Devuelve el manejador de fichero);
}

//------------------------------- FUNCION PUBLICA: Crear() -------------------
// Si archivo no existe lo crea y si ya exista lo borra y lo abre con
// tamao cero.
// Devuelve falso si se ha producido un error, consultar Error.
// ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
int Fichero::Crear(char *archivo)
{
 if (abierto)         // Si el fichero estaba abierto lo cerramos.
	CerrarFichero();

 // Lo abrimos 1) en binario 2) para lectura y escritura 3) Si no existe
 // se crea si existe no tiene efecto. 4) truncado -> si existe su tamao
 // se pone a cero.
 return AperturaComun(open(archivo,O_BINARY | O_RDWR | O_CREAT | O_TRUNC,S_IREAD|S_IWRITE),archivo);
 // (open Devuelve el manejador de fichero);
}

//------------------------------- FUNCION PUBLICA: AbrirOCrear() -------------
// Si el fichero existe lo abre (sin borrarlo) y si no existe lo crea.
// Devuelve falso si se ha producido un error, consultar Error.
// ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
int Fichero::AbrirOCrear(char *archivo)
{
 if (abierto)         // Si el fichero estaba abierto lo cerramos.
	CerrarFichero();

 // Lo abrimos 1) en binario 2) para lectura y escritura 3) Si no existe
 // se crea si existe no tiene efecto.
 return AperturaComun(open(archivo,O_BINARY | O_RDWR | O_CREAT,S_IREAD|S_IWRITE),archivo);
 // (open Devuelve el manejador de fichero);
}

//------------------------------- FUNCION PUBLICA: AbrirAlFinal() ------------
// Abre el Fichero y pone el puntero 0 al final. Ver Variable Error. Si no
// existe lo crea.
// Devuelve falso si se ha producido un error, consultar Error.
// ERRORES QUE PUEDE DEVOLVER: 1,2,3,4,5,9
int Fichero::AbrirAlFinal(char *archivo)
{
 if (abierto)         // Si el fichero estaba abierto lo cerramos.
	CerrarFichero();

 // Lo abrimos 1) en binario 2) para lectura y escritura 3) Si no existe
 // se crea si existe no tiene efecto.
 if (!AperturaComun(open(archivo,O_BINARY | O_RDWR | O_CREAT,S_IREAD|S_IWRITE),archivo))
 {   // (open Devuelve el manejador de fichero);
	return 0;
 }
 Seek(tamano);
 return 1;

}

//------------------------------- FUNCION PUBLICA: Borrar() ------------------
// Borra el fichero si archivo es != NULL o borra el fichero actualmente
// abierto.
// ERRORES QUE PUEDE DEVOLVER: 1,3
int Fichero::Borrar(char *archivo)
{
	if(archivo!=NULL)
	{
	   if(!remove(archivo))
	   {
		  Error=0;
		  return 1;
	   }
	}
	else
	{
	   if(abierto)
		   CerrarFichero();
	   if(!remove(nombre))
	   {
		  Error=0;
		  return 1;
	   }
	}
	// Ha ocurrido un Error.
	AsignaError();
	return 0;
}

//------------------------------- FUNCION PUBLICA: Renombrar() ---------------
int Fichero::Renombrar(char *antigua,char *nueva)
{
	if(Existe(nueva))
	{
		if(!Borrar(nueva))
			return 0;
	}
	if(-1==rename(antigua,nueva))
		{AsignaError(); return 0;}
	return 1;
}

//------------------------------- FUNCION PUBLICA: CerrarFichero() -----------
// Cierra el Fichero. No Es necesario hacerlo lo hace el destructor.
// Devuelve falso si se ha producido un error, consultar Error.
// ERRORES QUE PUEDE DEVOLVER: 3,5,6
int Fichero::CerrarFichero()
{ /*  Debe escribir el Buffer a disco. (salvar el fichero).
	necesito que se ejecute abierto=0;
	tambin sera conveniente que se inicializaran el resto de las variables.
	Esto deber ocurrrir incluso cuando el fichero est cerrado. (por las
	funciones abrir cuando dan un error con el filelength
	No Debe Liberar la memoria que ocupen los cursores. -> OJO con ejecutar
	Inicializa.	*/
	if (!abierto)
	{
		Error=5;  // Manejador de Fichero no vlido.
		return 0;
	}

      //  Escribimos a disco todos los buffers modificados.

	if (cursor.modificado)
	{  // Escribimos el buffer modificado a disco.
		lseek(file,cursor.inicio,0);  // Supongo que no da error porque los argumentos son vlidos.
		// Vamos a distinguir el caso de buffer con todos los
		// caracteres tiles de cuando el final del buffer no vale.
		if ( (LongBufferCursor + cursor.inicio) <= tamano)
		{
			if ((-1) == Escribe((void *)(cursor.buffer),LongBufferCursor))
			{
				AsignaError();
				return 0;
			}
		}
		else
		{
			if ((-1) == Escribe((void *)(cursor.buffer),tamano - (cursor.inicio)))
			{
				AsignaError();
				return 0;
		      }
            }
	}
	// Actualizamos las variables del cursor
	cursor.modificado = 0;
	cursor.inicio = 0;
	cursor.index = 0;
	for(long int c=0;c < LongBufferCursor;c++)
	{
	    (cursor.buffer)[c]='\0';
	}

	if ((-1) == close(file))
	{
		AsignaError();
		return 0;
	}

	abierto=0;
	file=0;
	if (nombre)
	{
	   delete nombre;
	   nombre=NULL;
	}
	tamano=0;
	Error=6;

	return 1;
}
//------------------------------- FUNCION PUBLICA: BuscaCadena() -------------
// Lee linealmente el fichero desde la posicin en que se encuentre el
// cursor hasta encontrar la cadena Cadena y entonces devuelve
// verdadero (!=0) y deja el cursor en el siguiente carcter a la cadena
// encontrada. Se pueden distinguir maysculas de minsculas o no,
// dependiendo del valor del booleano distinguir. La bsqueda ser ms
// rpida si se distingen. Error es un boolenano que indica si se ha
// producido un error.
// Usa la variable Porcentaje que puede ser consultada por otra tarea.
// Dar en tanto % la relacin Posicin_actual/tamano.
// ERRORES QUE PUEDE DEVOLVER: 3,5
// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
int Fichero::BuscaCadena(char *Cadena,int distinguir, int &error)
{
	unsigned int index;
	long int pos;

	if (tamano==0) return 0;
	error=0;
	Porcentaje=(100*GetPos())/tamano;
	if (Cadena[0] == '\0')
		return 1;
	if (distinguir)
	{
	   while (!Final())
	   {
		  index=0;
		  pos=GetPos();
		  Porcentaje=(100*pos)/tamano;
		  while( Cadena[index] == LeeCaracter(error))
		  {
			if (Cadena[index++] == '\0')
			{
			   Seek(GetPos()-1);
			   return 1;
			 }
			if (error)
				return 0;
		  }
		  if (Cadena[index] == '\0')
		  {
			Seek(GetPos()-1);
			return 1;
		  }
		  if (index)    // Reponemos la posicin.
			Seek(pos+1);
	   }
	   return 0;
	}
	else
	{
	   while (!Final())
	   {
		  index=0;
		  pos=GetPos();
		  Porcentaje=(100*pos)/tamano;
		  while( CAP(Cadena[index]) == CAP(LeeCaracter(error)))
		  {
			if (Cadena[index++] == '\0')
			{
			   Seek(GetPos()-1);
			   return 1;
			}
			if (error)
				return 0;
		  }
		  if (Cadena[index] == '\0')
		  {
			Seek(GetPos()-1);
			return 1;
		  }

		  if (index)    // Reponemos la posicin.
			Seek(pos+1);
	   }
	   return 0;
	}

}

int Fichero::BuscaCadena(char *Cadena,int distinguir){
     int tmp;
     return BuscaCadena(Cadena,distinguir,tmp);
}
//------------------------------- FUNCION PUBLICA: BuscaCadenaBinaria() ------
// Lee linealmente el fichero desde la posicin del cursor, hasta
// encontrar la Cadena y entonces devuelve verdadero (!=0) y deja el
// cursor en el siguiente carcter a la cadena encontrada. La cadena es
// una cadena binaria y no una cadena de texto, por tanto no hay carcter
// terminador, as longit dice el nmero de bytes de la cadena a
// localizar. Error es un boolenano que indica si se ha producido un error.
// Usa la variable Porcentaje que puede ser consultada por otra tarea.
// Dar en tanto % la relacin Posicin_actual/tamano.
// ERRORES QUE PUEDE DEVOLVER: 3,5
// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
int Fichero::BuscaCadenaBinaria(char *Cadena,int longit,int &error)
{   // Cursor por defecto a cero.
   long int pos,index;

   if (tamano==0) return 0;
   Porcentaje=(100*GetPos())/tamano;
   error=0;
   while (!Final())
   {
	  index=0;
	  pos=GetPos();
	  Porcentaje=(100*pos)/tamano;
	  while(Cadena[index] == LeeCaracter(error))
	  {
		if (++index == longit)
			return 1;
		if (error || Final())
			return 0;
	  }
	  if (index == longit)
		  return 1;
	  if (index)
		Seek(pos+1);
   }
   return 0;
}
//------------------------------- FUNCION PUBLICA: HacerHueco() --------------
// Hace un hueco de Hueco__ caracteres en la posicin del cursor cursor.
// Devuelve un booleano indicando si se ha producido un error.
// Long2Buffers es el nmero de bytes que tendr cada uno de dos buffers
// temporales que se usan, a mayor tamao ms rapidez en ficheros grandes
// y mayores dificultades para reservar la memoria.
// Long2Buffers debe ser mayor o igual que Hueco__.
// El puntero del fichero queda en la misma posicin que estaba antes
// de llamar a la funcin, esto es: Getpos devuelve lo mismo antes que
// despus de llamar a la funcin.
// Usa la variable Porcentaje que puede ser consultada por otra tarea.
// Dar en tanto % la relacin Posicin_actual/tamano.
// ERRORES QUE PUEDE DEVOLVER: 3,5
// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
int Fichero::Insertar(long int Hueco__,long int Long2Buffers)
{	// Por razones derivadas de la implementacin del Objeto fichero es
	// necesario minimizar el nmero de veces que se alternan las operaciones
	// de escritura y lectura alternativamente.

   char *temp,*salvada,*tempini,*salvadaini,*intercambio;
   long int PosLect,PosEscr,c,posinicial;
   long int TamanoInicial=tamano;

   posinicial=GetPos();
   if (tamano==0) return 0;
   Porcentaje=(100*GetPos())/tamano;
   if (Final())
   {
	   for(c=0;c < Hueco__;c++)
	   {
		   if(!EscribeCaracter('\0'))
			  return 0;
	   }
	   return 1;
   }

	if ((tamano-GetPos()) < Long2Buffers)
		Long2Buffers=(tamano-GetPos());

        try{ temp=new char[Long2Buffers]; }
        catch(...){ return 0; /*Falta Memoria*/ }
        
        try{ salvada=new char[Long2Buffers]; }
        catch(...){ salvada=NULL; /*Falta Memoria*/ }

	if (salvada == NULL)
	{
		delete temp;
		return 0;  // Falta memoria.
	}
	salvadaini=salvada; // Al parecer tenemos que borrar con delete el
	tempini=temp;     // mismo array que hemos reservado y no otro aunque sea
	// igual. Es porque ms adelante se intercambia el valor de los punteros.

	////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////
	PosEscr=GetPos();
	if (!LeeCadena(salvada,Long2Buffers))
			   { delete salvada; delete temp; return 0; }
	PosLect=GetPos();

	Seek(PosEscr);
	for(c=0;c < Hueco__;c++)
	{
		if(!EscribeCaracter('\0'))
			   { delete salvada; delete temp; return 0; }
	}
	PosEscr=GetPos();

	while((TamanoInicial-PosLect) >= Long2Buffers)
	{
		Seek(PosLect);
		if (!LeeCadena(temp,Long2Buffers))
			   { delete salvadaini; delete tempini; return 0; }
		PosLect=GetPos();
		Porcentaje=(100*PosLect)/tamano;

		Seek(PosEscr);
		if (!EscribeCadena(salvada,Long2Buffers))
			   { delete salvadaini; delete tempini; return 0; }
		PosEscr=GetPos();

		// Ahora copiamos temp a salvada. Y mejor que copiar cadenas ser
		// intercambiar los punteros.
		intercambio=salvada;
		salvada=temp;
		temp=intercambio;
	}
	long int resto = TamanoInicial-PosLect; // Si estamos al final resto ser cero.

	Seek(PosLect);  // Leemos los caracteres que quedan.
	if (!LeeCadena(temp,resto))
		   { delete salvadaini; delete tempini; return 0; }
	Seek(PosEscr);
	if (!EscribeCadena(salvada,Long2Buffers))
		   { delete salvadaini; delete tempini; return 0; }
	if (!EscribeCadena(temp,resto))
		   { delete salvadaini; delete tempini; return 0; }

	Seek(posinicial);
	Porcentaje=(100*GetPos())/tamano;
	delete salvadaini;
	delete tempini;
	return 1;
}
//------------------------------- FUNCION PUBLICA: Suprimir() ----------------
// Suprime el nmero de caracteres indicado por n de la posicin actual
// del cursor como si se tratase de un procesador de texto. Devuelve un
// booleano indicando si se ha producido un error. LongBuffer es el
// nmero de bytes que tendr un buffer temporal que se usa, a mayor
// tamao ms rapidez en ficheros grandes y mayores dificultades para
// reservar la memoria.
// Usa la variable Porcentaje que puede ser consultada por otra tarea.
// Dar en tanto % la relacin Posicin_actual/tamano.
//  ERRORES QUE PUEDE DEVOLVER: 3,5
// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
int Fichero::Suprimir(long int n,long int LongBuffer)
{     // cursor por defecto a cero.
	// Por razones derivadas de la implementacin del Objeto fichero es
	// necesario minimizar el nmero de veces que se alternan las operaciones
	// de escritura y lectura alternativamente.

   if (tamano==0) return 0;

   char *salvada;
   long int PosLect,PosEscr,c,bytes;

   Porcentaje=(100*GetPos())/tamano;
   if (n==0)
	   return 1;
   if (Final())
	   return 0; // No se que devolver, No se puede suprimir por eso devuelvo falso.

   PosEscr=GetPos();
   PosLect=n+PosEscr;
   if (PosLect>tamano)
		PosLect=tamano;

   if ((tamano-PosLect) < LongBuffer)
		LongBuffer=tamano-PosLect;


        try{ salvada=new char[LongBuffer+1];  // +1 por usar LeeCadena }
        }catch(...){ return 0; }

	////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////
	do
	{
	   Seek(PosLect);
	   bytes= ((tamano-PosLect) >= LongBuffer) ? LongBuffer:(tamano-PosLect);
	   if (!LeeCadena(salvada,bytes))
			  { delete salvada; return 0; }
	   PosLect=GetPos();
	   Porcentaje=(100*PosLect)/tamano;

	   Seek(PosEscr);
	   if (!EscribeCadena(salvada,bytes))
			  { delete salvada; return 0; }
	   PosEscr=GetPos();
	}while((bytes == LongBuffer) && bytes);

	// Escribimos n caracteres al final con '\0'
	for(c=0;c<n;c++)
	{
	   if (Final())
	   {
		  delete salvada;
		  return 1;
	   }
	   if (!EscribeCaracter('\0'))
			  { delete salvada; return 0; }
	}
	Porcentaje=(100*GetPos())/tamano;
	delete salvada;
	return 1;
}
//------------------------------- FUNCION PUBLICA: Sustituir() ---------------
// Esta funcin busca la cadena buscada y la sustituye por la cadena
// sustituta, las longitudes de ambas cadenas no tiemen por qu coincidir.
// todas es un booleano si es verdadero se sustituirn todas las cadenas
// encontradas si es falso solo la primera.
// distinguir es un booleano que indica si al buscar la cadena se
// distinguirn o no maysculas de minsculas.
// longbuffers ser el tamao de dos buffers que se crearn temporalmente
// en la funcin, a mayor valor ms rapidez en ficheros grandes.
// Se busca a partir de la posicin actual de cursor. Devuelve el nmero
// de cadenas encontradas y sustituidas. Si devuelve cero puede haber
// algn Error (consultar Error) o que no se haya encontrado la cadena.
// ERRORES QUE PUEDE DEVOLVER: 3,5
// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
long int Fichero::Sustituir(char *buscada,char *sustituta,int todas,int distinguir,
				   long int longbuffers)
{   // cursor por defecto a cero.
   // En primer lugar calculamos las longitudes de ambas cadenas:
   long int longbusc=0,longsust=0,cont=0,pos;
   Error=0;

   while( (buscada[longbusc]) !='\0' ){longbusc++;}
   while( (sustituta[longsust]) !='\0' ){longsust++;}

   // Ahora distinguimos tres casos:
   if(longbusc==longsust)
   {
	  while (BuscaCadena(buscada,distinguir,Error))
	  {
		 cont++;
		 if (Error)
			return 0;
		 Seek(GetPos()-longbusc);
		 if (!EscribeCadena(sustituta,longsust))
			return 0;
		 if (!todas)
			return 1;
	  }
	  return cont;
   }
   else if(longbusc > longsust)
   {
	  while (BuscaCadena(buscada,distinguir,Error))
	  {
		 cont++;
		 if (Error)
			return 0;
		 Seek(GetPos()-longbusc);
		 if (!EscribeCadena(sustituta,longsust))
			return 0;
		 pos=GetPos();
		 if (!Suprimir(longbusc-longsust,longbuffers))
			return 0;
		 if (!todas)
			return 1;
		 Seek(pos);
	  }
	  return cont;
   }
   else  // Caso: -> (longbusc < longsust)
   {
	  while (BuscaCadena(buscada,distinguir,Error))
	  {
		 cont++;
		 if (Error)
			return 0;
		 Seek(GetPos()-longbusc);

		 pos=GetPos();

		 if (!Insertar(longsust-longbusc,longbuffers))
			return 0;

		 Seek(pos);

		 if (!EscribeCadena(sustituta,longsust))
			return 0;

		 if (!todas)
			return 1;
	  }
	  return cont;
   }
}



// FUNCION QUE NO ES DE LA CLASE:
// Copia el fichero origen en el fichero destino, ambos desde la posicin
// donde se encuentren y hasta el final de Origen. Devuelve un booleano
// indicando si ha habido un error. Si es verdadero el Error puede estar
// en el fichero origen o en el de destino.
// LA FUNCION PODRIA TARDAR VARIOS MINUTOS.
int CopiaFicheros(Fichero &Origen,Fichero &Destino)
{
	long int t;
	int error;

	for(t=Origen.GetPos();t < Origen.tamano;t++)
	{
		if ((!(Destino.EscribeCaracter(Origen.LeeCaracter(error)))) || error)
			return 0;
	}
	return 1;
}
