//
//     CONFIGURACION       
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es   
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                 Esta clase contiene todas las variables de configuracin del
                programa. Facilita el acceso a las mismas. Tambin salva y
                carga los valores de las variables al fichero de configuracin.

*/
//---------------------------------------------------------------------------

#ifndef Configuracion_H
#define Configuracion_H

#include "ficheros.h"

//---------------------------------------------------------------------------
/*
   Esta clase contiene todas las variables de configuracin del programa. Todas
las variables se escriben en mayusculas porque aunque son variables actan como
constantes en el programa. Realmente solo se modificarn para cambiar la
configuracin del programa.

   El constructor carga los datos desde el fichero de configuracin.

   Las variables podrn ser modificadas desde el exterior. Y cada vez que se
modifiquen habr que llamar a la funcin que escriba en el fichero los nuevos
valores.
*/

class Configuracion{
private:
     // Es el objeto fichero usado para las opraciones de disco.
     Fichero f;

     // Nombre del fichero de configuracin.
     AnsiString FicheroConfig;

     // Nombre de un fichero auxiliar que se usa para salvar el fichero de
     // configuracin (manteniendo los comentarios del usuario.
     AnsiString FicheroAuxiliar;

     // Con esta variable sabremos si el destructor de la clase debe o no guardar
     // los datos al ejecutarse.
     bool datosHanCambiado;

     // Crea un fichero de configuracin con valores por defecto.
     bool __fastcall CrearFichConfValDefecto();

     // Lee el fichero f a partir de su posicin actual hasta encontrar una cadena
     // que comience por -> Entonces devuelve en dato la lnea del fichero
     // eliminando el RC, la flecha -> y los espacios y tabuladores del principio
     // y del final del fichero.
     // (el puntero dato es modificado y hay que pasarlo por referencia).
     // Devuelve falso si se llega al final del fichero sin encontrar la cadena
     // con ->
     bool __fastcall GetCadena(char *cad,char *&dato);


     // Devuelve el nmero entero contenido en cad. Si se produce un error
     // (por ejemplo cad contiene letras) se avisa con un mensaje de error,
     // se restaura el fichero de configuracin general con los valores iniciales
     // y se cierra la aplicacin.
     int __fastcall GetEntero(AnsiString cad);

     // Dentro de la funcin cargar datos es necesario ejecutar muchas veces un
     // grupo de intrucciones que se agrupan en esta funcin para ahorrar lneas
     // cdigo.
     void __fastcall AsignarDatos(char *cad,char *&dato,AnsiString &CTE);

public:
   //---------------------------------------- LISTADO DE VARIABLES -------------

     // Las palabras reservadas se guardan en:
     TStringList *PalabrasReservadas;

     // Directorio para los ficheros de configuracin.
     AnsiString CARPETA_CONFIGURACION;

     // Directorio para las imgenes que se usarn en el programa.
     AnsiString CARPETA_IMAGENES;

     // Para el ajuste de las ventanas (herramientas, arcbol, editor de nodos, etc)
     // se deja este margen entre el rea de trabajo y las ventanas.
     int MARGEN_POSICIONADO_DE_VENTANAS;

     // Es el nombre del fichero que contiene la imagen que se asociar al nodo
     // cuando en la carpeta CARPETA_IMAGENES no se encuentre la imagen del nodo
     // (que se indica en el fichero de configuracin).
     AnsiString IMAGEN_GENERAL_NODO_H3D;
     AnsiString IMAGEN_GENERAL_NODO_X3D;

     // Es el nombre del fichero que contiene el icono que se asociar al nodo
     // cuando en la carpeta CARPETA_IMAGENES no se encuentre el icono del nodo
     // (que se indica en el fichero de configuracin).
     AnsiString ICONO_GENERAL_NODO_H3D;
     AnsiString ICONO_GENERAL_NODO_X3D;

     // Es el nombre del fichero que contiene la imagen que se asociar al tipo
     // cuando en la carpeta CARPETA_IMAGENES no se encuentre la imagen del tipo.
     AnsiString ICONO_GENERAL_TIPO;

     // Es el nombre del fichero que se usa para identificar a los nodos (diferenciandolos
     // de los campos).
     AnsiString ICONO_NODO_ARBOL;

     // Es el nombre del fichero que se usa para identificar a los nodos que no
     // se han registrado -> Nodos Genericos
     AnsiString ICONO_NODO_GENERICO_ARBOL;

     // Es el nombre de una imagen en blanco 20x20 (Se usa para los tipos indefinidos).
     AnsiString ICONO_BLANCO_20x20;

     // Es el nombre de una imagen 20x20 con el logo X3D.
     AnsiString ICONO_X3D_20x20;

     // Es el nombre de una imagen 20x20 con el logo H3D.
     AnsiString ICONO_H3D_20x20;

     // Es el nombre de una imagen 20x20 con el icono asociado al los nodos de
     // rutado del arbol que se representa.
     AnsiString ICONO_RUTADO_20x20;

     // Es el nombre de una imagen 20x20 con el icono asociado al los nodos de
     // comentarios del arbol que se representa.
     AnsiString ICONO_COMENTARIO_20x20;

     // Es el nombre de una imagen 20x20 con el icono asociado al los nodos USE
     // del arbol que se representa.
     AnsiString ICONO_USE_20x20;

     // Estos son los ficheros que contienen informacin sobre los nodos que se
     // usarn en el programa (H3D y X3D).
     AnsiString FICHERO_CONFIG_NODOS_H3D;
     AnsiString FICHERO_CONFIG_NODOS_X3D;
     // Este fichero contiene informacin sobre los tipos asociados a los campos
     // de los nodos (H3D y X3D).
     AnsiString FICHERO_CONFIG_TIPOS_H3D;
     AnsiString FICHERO_CONFIG_TIPOS_X3D;

     // Indica si aparece o no el nombre del nodo X3D/H3D en la vista
     // TTreeView (a parte del nombre dado por el usuario que aparece siempre).
     // p.e. para el nodo Box tendremos <Box:Box0001> si esta variable es true
     // y <Box0001> en caso contrario.
     bool VER_NOMBRE_NODO_EN_EL_ARBOL;

     // Es la primera lnea que se escribir en un fichero VRML.
     AnsiString PRIMERA_LINEA_FICH_X3D;

     // Es la primera lnea que se escribir en un fichero H3D.
     AnsiString PRIMERA_LINEA_FICH_H3D;

     // Nmero de caracteres que se usan para anidar los datos del cdigo.
     int FICH_NUM_CARACTERES_JUSTIF;

     // Contiene el tipo de escena con la que se iniciar el programa.
     int TIPO_ESCENA_POR_DEFECTO;

     // Indica si al crear un nodo se le asignar o no un nombre por defecto.
     bool NOMBRAR_NODOS_AUTOMATICAMENTE;

     // Es el sufijo que se aade al nombre del fichero para ejecutarlo
     // (As es posible ejecutar un fichero que no se ha salvado an).
     AnsiString SUF_FICHERO_PRUEBA;

     // Es la ruta del fichero .exe que ejecutar las escenas X3D
     AnsiString PATH_EXPLORER;

     // Es la ruta del fichero .exe que ejecutar las escenas H3D.
     AnsiString PATH_H3D_LOAD;

     // Es la carpeta que se us por ultima vez para abrir o guardar un fichero.
     AnsiString LAST_CARPETA_USADA;

     // Las siguientes variables guardan direcciones WEB de interes: X3D, H3D y DTE.
     AnsiString URL_H3D;
     AnsiString URL_X3D;
     AnsiString URL_DTE;

     // En el Men archivo del programa aparecen los 4 ltimos ficheros abiertos
     // Las siguientes variables guardan su ruta:
     AnsiString LAST_FILE1;
     AnsiString LAST_FILE2;
     AnsiString LAST_FILE3;
     AnsiString LAST_FILE4;

     // Indica como se muestran las herramientas. 3 posibles valores "VENTANA","BARRA","OCUTA"
     AnsiString VER_HERRAMIENTAS_COMO;

     // Contiene la url de las User Interface Toolkit
     AnsiString URL_USER_INTERFACE_TOOLKIT;

     // Indica si se desean usar el prefijo y el sufijo para los rutados de
     // de campos de tipos ExposedField en H3D.
     bool USAR_PREF_Y_SUF_EN_RUTADOS_H3D;

     // Contienen el prefijo y el sufijo que se aaden a los campos de tipo;
     // ExposedField al crear vnculos de Rutado.
     AnsiString PREFIJO_EXPOXEDFIELD_AS_EVENTIN;
     AnsiString SUFIJO_EXPOXEDFIELD_AS_EVENTOUT;

     // Contiene las palabras que se consideran como palabras reservadas (solo
     // a efectos de representacin en el editor.
     AnsiString PALABRAS_RESERVADAS;

     // En algunos nodos especiales como en los scripts python hay que desactivar
     // el anidamiento automtico que hace el programa. Esta variable guarda
     // los nombres de los nodos (separados por espacios) en los que hay que
     // desactivar el anidamiento. Para saber si un nombre pertenece o no a la lista
     // hay que buscar " nombre_nodo " para evitar encontrar subcadenas.
     AnsiString NODOS_SIN_ANIDAMIENTO;

     // Indica si se desean usar varios colores en el cdigo VRML.
     bool FORMATEAR_CODIGO;

     // Las siguientes variables guardan el color y tipo (negrita ~ cursiva) de
     // cada formato:  (NC -> Negrita Cursiva)
     DWORD  Formato_COMENTARIO_NC;
     TColor Formato_COMENTARIO_color;

     DWORD  Formato_NO_VISIBLE_NC;
     TColor Formato_NO_VISIBLE_color;

     DWORD  Formato_CADENA_NC;
     TColor Formato_CADENA_color;

     DWORD  Formato_LLAVES_Y_CORCHETES_NC;
     TColor Formato_LLAVES_Y_CORCHETES_color;

     DWORD  Formato_CAMPO_NC;
     TColor Formato_CAMPO_color;

     DWORD  Formato_IDENTIFICADOR_NC;
     TColor Formato_IDENTIFICADOR_color;

     DWORD  Formato_NORMAL_NC;
     TColor Formato_NORMAL_color;

     DWORD  Formato_NODO_NC;
     TColor Formato_NODO_color;

     DWORD  Formato_PALABRA_RESERVADA_NC;
     TColor Formato_PALABRA_RESERVADA_color;

     DWORD  Formato_GENERAL_NC;
     TColor Formato_GENERAL_color;

     // Adems hay otras variables que completan la especificacin del formato
     // de texto:
     int        Formato_TAM_FUENTE_EDITOR;
     int        Formato_TAM_FUENTE_ESCENA;
     TColor     Formato_COLOR_FONDO;
     AnsiString Formato_NOMBRE_FUENTE;

     // Indica si se desea usar la opcin AutoCompletar en ficheros VRML:
     bool USAR_AUTO_COMPLETAR;

     // Nmero de ms que se espera tras soltar una tecla en ficheros VRML
     // para mostrar el cuadro AutoCompletar.
     int RETARDO_AUTO_COMPLETAR;

     //  Solo cuando el visor H3D sea un programa de MS-DOS ser til la
     // consola, en otro caso lo mejor ser ejecutarlo directamente. Es necesario
     // configurar esta opcin, se usar la variable:
     bool USAR_CONSOLA_H3D_AL_EJECUTAR_H3D;

     // Para controlar si es la primera vez que se ejecuta el programa.
     bool PRIMERA_EJECUCION;

     // Con este valor se hace un sleep en la consola H3D para que se reciban todos los
     // mensajes. 
     int DELAY_CONSOLA_H3D;

     //--------------------------------------------------- FUNCIONES -----------
     // Carga todas las variables con los datos del fichero de configuracin.
     // Se usa como fichero de configuracin la constante FICH_CONF
     void __fastcall CargarDatos();

     // Salva en el fichero las variables de configuracin.
     // Cada vez que se modifiquen externamente las variables de configuracin
     // tendr que llamarse desde el exterior a esta funcin si se quieren
     // conservar los cambios.
     // Los comentarios que haya en el fichero se mantendrn, nicamente
     // cambiarn las lneas que contengan los valores de las variables de
     // configuracin. Estas lneas son las que comienzan con ->
     // Se usa como fichero de configuracin la constante FICH_CONF
     void __fastcall SalvarDatos();

     // Crea un fichero de configuracin con los valores por defecto y actualiza
     // todas las variables de la clase.
     void __fastcall Restaurar();

     // Con esta funcin se indica que cuando se ejecute el destructor habr
     // que salvar el fichero de configuracin a disco.
     void __fastcall LosDatosHanCambiado();

     // Esta funcin carga los tipos de formato desde f para poder ser
     // usados en componentes TRichEdit de modo ms eficiente. Los tipos de
     // formato son:
     // FORMATO_NO_VISIBLE            FORMATO_COMENTARIO
     // FORMATO_CADENA                FORMATO_NORMAL
     // FORMATO_LLAVES_Y_CORCHETES    FORMATO_NODO
     // FORMATO_CAMPO                 FORMATO_PALABRA_RESERVADA
     // FORMATO_IDENTIFICADOR         FORMATO_GENERAL
     //  El formato de la cadena debe ser:
     // 12 14 colorFondo NO_VISIBLE: ?? color CADENA: ?? color LLAVES_Y_CORCHETES: ?? color CAMPO: ?? color IDENTIFICADOR: ?? color COMENTARIO: ?? color NORMAL: ?? color NODO: ?? color PALABRA_RESERVADA: ?? color GENERAL: ?? color
     // Donde:
     //    - Aparecen dos valores enteros que corresponden al tamao de las fuentes
     //    del editor (el primero) y del cdigo VRML de escena (el segundo).
     //    -colorFondo es el color que se usa para el fondo del texto.
     //    -color es el color asociado al formato anterior, se debe poder leer
     //    con StringToColor().
     //    - ?? Son dos caracteres si el primero es N se usar negrita para el
     //    formato anterior, en otro caso no se usar negrita. El segundo caracter
     //    se usa para ver si el formato va en cursiva. Cuando sea C se usar
     //    cursiva y en otro caso no.
     void __fastcall CargaFormatosTexto(AnsiString f);
     // El paso inverso se hace con la funcin siguiente, que devuelve el
     // contenido de las variables FORMATO_ (no todas).
     AnsiString __fastcall SalvaFormatosTexto();

     // Es una funcin auxiliar que se llama desde CargaFormatos para hacer el
     // cdigo ms campacto. pal1 y pal2 corresponden a:
     // pal1: son los dos caracteres ?? del formato descrito en la funcion CargaFormatos()
     // pal2: es el nombre del color.
     // color se asigna segn el valor de pal2.
     // NC indica si el formato dado ir en negrita y/o cursiva (4 posibles valores).
     // Si se produce algn error se devuelve false.
     bool __fastcall LeeValoresFormato(AnsiString pal1,AnsiString pal2,DWORD &NC, TColor &color);

     // Recibe los valores nc y color y devuelve una cadena con el formato
     // descrito en la funcin CargaFormatosTexto:
     // nc indica si el texto es negrita y/o cursiva segn el formato de las API.
     // Ejemplos de posibles valores devueltos son:
     // "NC clBlue", "-C clRed", "-- clLime"
     AnsiString __fastcall EscribeValoresFormato(DWORD nc,TColor color);


    //----------------------------------------- Constructor y Destructor -------
     // Debido a que al cargar los datos puede ser necesario dar mensajes de
     // error, el constructor de la clase no carga los datos y es necesario
     // llamar antes de usar las variables de la clase a CargarDatos();
     // El constructor recibe el nombre del fichero de configuracin.
      __fastcall Configuracion(AnsiString fichero);
      __fastcall ~Configuracion();
};


//---------------------------------------------------------------------------
#endif

// Exportamos un objeto Configuracin que contiene toda la informacin de configuracin
// del programa.
extern Configuracion CONF;
// Tambin se usar otro objeto con los valores por defecto (VD) del programa.
extern Configuracion CONF_VD;

