//
//     CONFIGURACION       
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN:
                Esta clase contiene todas las variables de configuracin del
                programa. Facilita el acceso a las mismas. Tambin salva y
                carga los valores de las variables al fichero de configuracin.

*/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Utilidad_.h"
#include "Main_.h"

// Ruta del fichero de configuracin general.
#define FICH_CONF "Config\\General.cfg"
// Ruta del fichero de configuracin con los valores por defecto.
#define FICH_CONF_VD "Config\\GeneralVD.cfg"
// Para salvar los datos de configuracin es necesario usar un fichero temporal.
#define FICH_AUX "Config\\FichAux.tmp"

//---------------------------------------------------------------------------

#pragma package(smart_init)

// Creamos un objeto Configuracin que contiene toda la informacin de configuracin
// del programa.
Configuracion CONF(FICH_CONF);
// Tambin se usar otro objeto con los valores por defecto (VD) del programa.
Configuracion CONF_VD(FICH_CONF_VD);

//--------------------------------------------------------- Constructor --------
__fastcall Configuracion::Configuracion(AnsiString fichero)
{
    AnsiString DirPrograma = ExtractFileDir(ParamStr(0));
    FicheroConfig   = DirPrograma + "\\" + fichero;
    FicheroAuxiliar = DirPrograma + "\\" + FICH_AUX;
    datosHanCambiado=false;

    try{PalabrasReservadas = new TStringList();}
    catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

    CargarDatos();
}
//--------------------------------------------------------- Destructor ---------
__fastcall Configuracion::~Configuracion(){
     if(datosHanCambiado)
        SalvarDatos();

     if(PalabrasReservadas != NULL)
        delete PalabrasReservadas;
}
//---------------------------------------------------------------------------
void __fastcall Configuracion::CargarDatos()
{
    if(!f.Existe(FicheroConfig.c_str()))
    {
        ShowMessage((AnsiString)" The configuration file " + FicheroConfig + (AnsiString)" doesn't exist. Now DisReal is going to create another one with the default values.");
        CrearFichConfValDefecto();
    }
    f.Abrir(FicheroConfig.c_str());
    // Ya tenemos el fichero de configuracion abierto. Hacemos un bucle en el
    // que en cada iteracin se lea una lnea del fichero.
    long int maxLongLin;

    maxLongLin=Utilidad.MaxLongLinea(f);

    AnsiString tmp;
    char *cad,*dato;

    try{cad=new char[maxLongLin+1];  // +1 para que quepa el caracter terminador '\0'
    }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

    // Con esto tenemos garantizado que la lnea de mxima longitud del fichero
    // de configuracin cabr en cad.
    f.Seek(0);

    AsignarDatos(cad,dato,CARPETA_CONFIGURACION);
    AsignarDatos(cad,dato,CARPETA_IMAGENES);

    AsignarDatos(cad,dato,tmp);
    MARGEN_POSICIONADO_DE_VENTANAS=GetEntero(tmp);

    AsignarDatos(cad,dato,IMAGEN_GENERAL_NODO_H3D);
    AsignarDatos(cad,dato,IMAGEN_GENERAL_NODO_X3D);
    AsignarDatos(cad,dato,ICONO_GENERAL_NODO_H3D);
    AsignarDatos(cad,dato,ICONO_GENERAL_NODO_X3D);
    AsignarDatos(cad,dato,ICONO_GENERAL_TIPO);
    AsignarDatos(cad,dato,ICONO_NODO_ARBOL);
    AsignarDatos(cad,dato,ICONO_NODO_GENERICO_ARBOL);    
    AsignarDatos(cad,dato,ICONO_BLANCO_20x20);
    AsignarDatos(cad,dato,ICONO_X3D_20x20);
    AsignarDatos(cad,dato,ICONO_H3D_20x20);
    AsignarDatos(cad,dato,ICONO_RUTADO_20x20);
    AsignarDatos(cad,dato,ICONO_COMENTARIO_20x20);
    AsignarDatos(cad,dato,ICONO_USE_20x20);
    AsignarDatos(cad,dato,FICHERO_CONFIG_NODOS_H3D);
    AsignarDatos(cad,dato,FICHERO_CONFIG_NODOS_X3D);
    AsignarDatos(cad,dato,FICHERO_CONFIG_TIPOS_H3D);
    AsignarDatos(cad,dato,FICHERO_CONFIG_TIPOS_X3D);
    AsignarDatos(cad,dato,tmp);
    VER_NOMBRE_NODO_EN_EL_ARBOL =  (tmp.UpperCase() == "YES");
    AsignarDatos(cad,dato,PRIMERA_LINEA_FICH_X3D);
    AsignarDatos(cad,dato,PRIMERA_LINEA_FICH_H3D);

    AsignarDatos(cad,dato,tmp);
    FICH_NUM_CARACTERES_JUSTIF=GetEntero(tmp);

    AsignarDatos(cad,dato,tmp);
    TIPO_ESCENA_POR_DEFECTO =  (tmp.UpperCase() == "X3D") ? ESCENA_X3D : ESCENA_H3D;

    AsignarDatos(cad,dato,tmp);
    NOMBRAR_NODOS_AUTOMATICAMENTE =  (tmp.UpperCase() == "YES");

    AsignarDatos(cad,dato,SUF_FICHERO_PRUEBA);
    AsignarDatos(cad,dato,PATH_EXPLORER);
    AsignarDatos(cad,dato,PATH_H3D_LOAD);
    AsignarDatos(cad,dato,LAST_CARPETA_USADA);
    AsignarDatos(cad,dato,URL_X3D);
    AsignarDatos(cad,dato,URL_H3D);
    AsignarDatos(cad,dato,URL_DTE);
    AsignarDatos(cad,dato,LAST_FILE1);
    AsignarDatos(cad,dato,LAST_FILE2);
    AsignarDatos(cad,dato,LAST_FILE3);
    AsignarDatos(cad,dato,LAST_FILE4);
    AsignarDatos(cad,dato,VER_HERRAMIENTAS_COMO);
    AsignarDatos(cad,dato,URL_USER_INTERFACE_TOOLKIT);
    AsignarDatos(cad,dato,tmp);
    USAR_PREF_Y_SUF_EN_RUTADOS_H3D =  (tmp.UpperCase() == "YES");
    AsignarDatos(cad,dato,PREFIJO_EXPOXEDFIELD_AS_EVENTIN);
    AsignarDatos(cad,dato,SUFIJO_EXPOXEDFIELD_AS_EVENTOUT);
    AsignarDatos(cad,dato,PALABRAS_RESERVADAS);
    AsignarDatos(cad,dato,NODOS_SIN_ANIDAMIENTO);
    // Dentro de NODOS_SIN_ANIDAMIENTO se buscarn palabras y para evitar
    // encontrar subcadenas, se buscar " palabra " as que tenemos que aadir
    // dos espacios al principio y al final:
    NODOS_SIN_ANIDAMIENTO = " " + NODOS_SIN_ANIDAMIENTO +" ";
    AsignarDatos(cad,dato,tmp);
    FORMATEAR_CODIGO =  (tmp.UpperCase() == "YES");
    AsignarDatos(cad,dato,Formato_NOMBRE_FUENTE);

    // Hay que asignar muchas variables con la informacin de tmp -> Usamos:
    AsignarDatos(cad,dato,tmp);
    CargaFormatosTexto(tmp);

    AsignarDatos(cad,dato,tmp);
    USAR_AUTO_COMPLETAR =  (tmp.UpperCase() == "YES");

    AsignarDatos(cad,dato,tmp);
    RETARDO_AUTO_COMPLETAR=GetEntero(tmp);

    AsignarDatos(cad,dato,tmp);
    USAR_CONSOLA_H3D_AL_EJECUTAR_H3D =  (tmp.UpperCase() == "YES");

    AsignarDatos(cad,dato,tmp);
    PRIMERA_EJECUCION =  (tmp.UpperCase() == "YES");

    AsignarDatos(cad,dato,tmp);
    DELAY_CONSOLA_H3D =  StrToInt(tmp);

    // Finalmente borramos la cadena.
    delete cad;

    // Ahora cargamos las palabras reservadas.
    PalabrasReservadas->Clear();

    int fin=Utilidad.NumPalabras(CONF.PALABRAS_RESERVADAS.c_str());
    for(int c=0;c < fin ; c++ )
        PalabrasReservadas->Append(Utilidad.GetPalabra(CONF.PALABRAS_RESERVADAS,c+1));
}
//---------------------------------------------------------------------------
void __fastcall Configuracion::AsignarDatos(char *cad,char *&dato,AnsiString &CTE){
    if(!GetCadena(cad,dato)){
       ShowMessage("The configuration file hasn't got enough data.");
       ShowMessage("Now the application will be closed to repair this file.");
       // Si f est abierto se cerrar en CrearFichConfValDefecto;
       // Creamos el fichero de configuracin con los valores por defecto.
       CrearFichConfValDefecto();
       // Salimos del programa.
       exit(EXIT_FAILURE);
    }
    CTE=dato;
}

//---------------------------------------------------------------------------
void __fastcall Configuracion::SalvarDatos(){

    if(!f.Existe(FicheroConfig.c_str())){
        ShowMessage((AnsiString)" The configuration file doesn't exist. The settings changes can not be saved.");
        return;
    }
    f.Abrir(FicheroConfig.c_str());

    // Vamos a leer el fichero lnea a lnea, necesitamos un array en el que
    // quepa la lnea ms larga del fichero:
    long int maxLongLin;

    maxLongLin=Utilidad.MaxLongLinea(f);

    char *cad,*dato;

    try{cad=new char[maxLongLin+1];  // +1 para que quepa el caracter terminador '\0'
    }catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

    // Con esto tenemos garantizado que la lnea de mxima longitud del fichero
    // de configuracin cabr en cad.

    // La estrategia que vamos a seguir para escribir el fichero es crear un
    // nuevo fichero de texto en el que se copiarn las lneas de comentarios y
    // se reescribirn las variables de configuracin en el orden adecuado.
    // Es necesario hacerlo as porque puede que haya que insertar caracteres en
    // el fichero (si quiero escribir una cadena de mayor longitud que la que
    // haba).
    Fichero aux;
    f.Seek(0);
    int orden=0;

    if(!aux.Crear(FicheroAuxiliar.c_str())){
       ShowMessage("An error occurred while creating the file.");
       f.CerrarFichero();
       return;
    }

    // Ya tenemos el fichero de configuracin y el auxiliar abiertos. Vamos
    // copiando el primero en el segundo reescribiendo los valores de las
    // variables.

    while(!f.Final()){
        f.LeeCadenaTexto(cad);
        // Distinguimos las lneas de datos de los comentarios.
        if((cad[0]=='-') && (cad[1]=='>')){
           orden++;
           aux.EscribeCadenaTexto2("-> ");
           // Ahora escribimos el valor de la variable que hay que salvar segn
           // el orden.
           AnsiString tmp;
           switch (orden)
           {
             case  1: aux.EscribeCadenaTexto(CARPETA_CONFIGURACION.c_str());                  break;
             case  2: aux.EscribeCadenaTexto(CARPETA_IMAGENES.c_str());                       break;
             case  3: tmp=IntToStr(MARGEN_POSICIONADO_DE_VENTANAS);
                      aux.EscribeCadenaTexto( tmp.c_str() );                                  break;
             case  4: aux.EscribeCadenaTexto(IMAGEN_GENERAL_NODO_H3D.c_str());                break;
             case  5: aux.EscribeCadenaTexto(IMAGEN_GENERAL_NODO_X3D.c_str());                break;
             case  6: aux.EscribeCadenaTexto(ICONO_GENERAL_NODO_H3D.c_str());                 break;
             case  7: aux.EscribeCadenaTexto(ICONO_GENERAL_NODO_X3D.c_str());                 break;
             case  8: aux.EscribeCadenaTexto(ICONO_GENERAL_TIPO.c_str());                     break;
             case  9: aux.EscribeCadenaTexto(ICONO_NODO_ARBOL.c_str());                       break;
             case 10: aux.EscribeCadenaTexto(ICONO_NODO_GENERICO_ARBOL.c_str());              break;
             case 11: aux.EscribeCadenaTexto(ICONO_BLANCO_20x20.c_str());                     break;
             case 12: aux.EscribeCadenaTexto(ICONO_X3D_20x20.c_str());                       break;
             case 13: aux.EscribeCadenaTexto(ICONO_H3D_20x20.c_str());                        break;
             case 14: aux.EscribeCadenaTexto(ICONO_RUTADO_20x20.c_str());                     break;
             case 15: aux.EscribeCadenaTexto(ICONO_COMENTARIO_20x20.c_str());                 break;
             case 16: aux.EscribeCadenaTexto(ICONO_USE_20x20.c_str());                        break;
             case 17: aux.EscribeCadenaTexto(FICHERO_CONFIG_NODOS_H3D.c_str());               break;
             case 18: aux.EscribeCadenaTexto(FICHERO_CONFIG_NODOS_X3D.c_str());               break;
             case 19: aux.EscribeCadenaTexto(FICHERO_CONFIG_TIPOS_H3D.c_str());               break;
             case 20: aux.EscribeCadenaTexto(FICHERO_CONFIG_TIPOS_X3D.c_str());               break;
             case 21: aux.EscribeCadenaTexto( VER_NOMBRE_NODO_EN_EL_ARBOL ?"YES":"NO");   break;
             case 22: aux.EscribeCadenaTexto( PRIMERA_LINEA_FICH_X3D.c_str());               break;
             case 23: aux.EscribeCadenaTexto( PRIMERA_LINEA_FICH_H3D.c_str());                break;
             case 24: tmp=IntToStr(FICH_NUM_CARACTERES_JUSTIF);
                      aux.EscribeCadenaTexto( tmp.c_str() );                                  break;
             case 25: aux.EscribeCadenaTexto( (TIPO_ESCENA_POR_DEFECTO == ESCENA_X3D) ? "X3D":"H3D");   break;
             case 26: aux.EscribeCadenaTexto( NOMBRAR_NODOS_AUTOMATICAMENTE?"YES":"NO");       break;
             case 27: aux.EscribeCadenaTexto(SUF_FICHERO_PRUEBA.c_str());                     break;
             case 28: aux.EscribeCadenaTexto(PATH_EXPLORER.c_str());                          break;
             case 29:
             aux.EscribeCadenaTexto(PATH_H3D_LOAD.c_str());
             break;
             case 30: aux.EscribeCadenaTexto(LAST_CARPETA_USADA.c_str());                     break;
             case 31: aux.EscribeCadenaTexto(URL_X3D.c_str());                                break;
             case 32: aux.EscribeCadenaTexto(URL_H3D.c_str());                                break;
             case 33: aux.EscribeCadenaTexto(URL_DTE.c_str());                                break;
             case 34: aux.EscribeCadenaTexto(LAST_FILE1.c_str());                             break;
             case 35: aux.EscribeCadenaTexto(LAST_FILE2.c_str());                             break;
             case 36: aux.EscribeCadenaTexto(LAST_FILE3.c_str());                             break;
             case 37: aux.EscribeCadenaTexto(LAST_FILE4.c_str());                             break;
             case 38: aux.EscribeCadenaTexto(VER_HERRAMIENTAS_COMO.c_str());                  break;
             case 39: aux.EscribeCadenaTexto(URL_USER_INTERFACE_TOOLKIT.c_str());             break;
             case 40: aux.EscribeCadenaTexto( USAR_PREF_Y_SUF_EN_RUTADOS_H3D?"YES":"NO");      break;
             case 41: aux.EscribeCadenaTexto(PREFIJO_EXPOXEDFIELD_AS_EVENTIN.c_str());        break;
             case 42: aux.EscribeCadenaTexto(SUFIJO_EXPOXEDFIELD_AS_EVENTOUT.c_str());        break;
             case 43: aux.EscribeCadenaTexto( PALABRAS_RESERVADAS.c_str());                   break;
             case 44: aux.EscribeCadenaTexto( NODOS_SIN_ANIDAMIENTO.c_str());                 break;
             case 45: aux.EscribeCadenaTexto( FORMATEAR_CODIGO?"YES":"NO");               break;
             case 46: aux.EscribeCadenaTexto( Formato_NOMBRE_FUENTE.c_str());                 break;
             case 47: aux.EscribeCadenaTexto( SalvaFormatosTexto().c_str() );                 break;
             case 48: aux.EscribeCadenaTexto( USAR_AUTO_COMPLETAR?"YES":"NO" );                break;
             case 49: tmp=IntToStr(RETARDO_AUTO_COMPLETAR);
                      aux.EscribeCadenaTexto( tmp.c_str() );                                  break;
             case 50: aux.EscribeCadenaTexto( USAR_CONSOLA_H3D_AL_EJECUTAR_H3D?"YES":"NO" );  break;
             case 51: aux.EscribeCadenaTexto( PRIMERA_EJECUCION?"YES":"NO" );                 break;
             case 52: aux.EscribeCadenaTexto( IntToStr(DELAY_CONSOLA_H3D).c_str() );          break;
           }
        }else{
            // En este caso tenemos una lnea de comentario, solo hay que copiarla.
            aux.EscribeCadenaTexto(cad);
        }
    }
    f.CerrarFichero();
    aux.CerrarFichero();
    f.Borrar(FicheroConfig.c_str());
    f.Renombrar(FicheroAuxiliar.c_str(),FicheroConfig.c_str());

    // Tambin hay que actualizar la lista de palabras reservadas:
    if(PalabrasReservadas != NULL){
       PalabrasReservadas->Clear();

       int fin=Utilidad.NumPalabras(CONF.PALABRAS_RESERVADAS.c_str());
       for(int c=0;c < fin ; c++ )
           PalabrasReservadas->Append(Utilidad.GetPalabra(CONF.PALABRAS_RESERVADAS,c+1));
    }
    // Tb tenemos que asegurarnos de:
    NODOS_SIN_ANIDAMIENTO = " " + NODOS_SIN_ANIDAMIENTO +" ";
}
//-----------------------------------------------------
bool __fastcall Configuracion::CrearFichConfValDefecto(){

   // Si el fichero est abierto lo cerramos.
   if(f.abierto)
       f.CerrarFichero();


   if(!f.Crear(FicheroConfig.c_str())){
       Utilidad.FatalError((AnsiString)" An error occurred while creating the configuration file " + FicheroConfig );
       return false;
   }
   f.Seek(0);
   f.EscribeCadenaTexto("------------------------------------------------------------------------");
   f.EscribeCadenaTexto("This file only will take into account the lines marked with ->");
   f.EscribeCadenaTexto("The order of the marked lines is important and must be the right one.");
   f.EscribeCadenaTexto("------------------------------------------------------------------------");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Contains the folder's name where the config files will be saved.");
   f.EscribeCadenaTexto("-> Config");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Contains the folder's name where the image files will be stored.");
   f.EscribeCadenaTexto("-> Images");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Windows's layout margin.");
   f.EscribeCadenaTexto("-> 0");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Images with the H3D and H3D/X3D Logo.");
   f.EscribeCadenaTexto("-> ImgGenH3D.bmp");
   f.EscribeCadenaTexto("-> ImgGenX3D.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Default image for H3D nodes.");
   f.EscribeCadenaTexto("-> Nodo H3D.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Default image for X3D nodes.");
   f.EscribeCadenaTexto("-> Nodo X3D.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Default image for data types.");
   f.EscribeCadenaTexto("-> tipo.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Tree node's icon");
   f.EscribeCadenaTexto("-> NodoArbol.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Generic tree node's icon");
   f.EscribeCadenaTexto("-> NodoGenericoArbol.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Blank image for undefined types.");
   f.EscribeCadenaTexto("-> Blanco20.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("A 20x20 image which contains the X3D logo.");
   f.EscribeCadenaTexto("-> X3D_20.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("A 20x20 image which contains the H3D logo.");
   f.EscribeCadenaTexto("-> H3D_20.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("A 20x20 image which contains the routing links (used in the tree view).");
   f.EscribeCadenaTexto("-> Rutado20.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("A 20x20 image which contains the comment's icon");
   f.EscribeCadenaTexto("-> Comentario20.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("A 20x20 image which contains the USE sentence's icon");
   f.EscribeCadenaTexto("-> USE20.bmp");
   f.EscribeCadenaTexto("");
   f.EscribeCadenaTexto("Config files for H3D and X3D nodes.");
   f.EscribeCadenaTexto("-> Nodos H3D.cfg");
   f.EscribeCadenaTexto("-> Nodos X3D.cfg");
   f.EscribeCadenaTexto("Config files for H3D and X3D types.");
   f.EscribeCadenaTexto("-> Tipos H3D.cfg");
   f.EscribeCadenaTexto("-> Tipos X3D.cfg");
   f.EscribeCadenaTexto("Indicates if the name the user gives to each node, appears in the tree view.");
   f.EscribeCadenaTexto("-> YES");
   f.EscribeCadenaTexto("First line in VRML files");
   f.EscribeCadenaTexto("-> #VRML V2.0 utf8");
   f.EscribeCadenaTexto("First line in H3D files");
   f.EscribeCadenaTexto("->");
   f.EscribeCadenaTexto(" Nesting number of blank characters.");
   f.EscribeCadenaTexto("-> 3");
   f.EscribeCadenaTexto(" Default kind of scene H3D / X3D");
   f.EscribeCadenaTexto("-> X3D");
   f.EscribeCadenaTexto(" When creating a node a default name can be used. (type YES to achieve this");
   f.EscribeCadenaTexto("-> YES");
   f.EscribeCadenaTexto(" Sufix which will be used to run H3D/X3D scenes.");
   f.EscribeCadenaTexto("-> _(testing)");
   f.EscribeCadenaTexto(" Path of the X3D viewer");
   f.EscribeCadenaTexto("-> C:\\Archivos de programa\\Internet Explorer\\IEXPLORE.EXE");
   f.EscribeCadenaTexto(" Path of the H3D viewer");
   f.EscribeCadenaTexto("-> C:\\h3d\\H3DAPI\\build\\win32\\vc7\\Release\\H3DLoad.exe");
   f.EscribeCadenaTexto(" Last used folder to open or save a file.");
   f.EscribeCadenaTexto("-> C:\\");
   f.EscribeCadenaTexto(" X3D URL");
   f.EscribeCadenaTexto("-> http://www.web3d.org/");
   f.EscribeCadenaTexto(" H3D URL");
   f.EscribeCadenaTexto("-> http://www.h3d.org");
   f.EscribeCadenaTexto(" DTE department URL (University of Malaga).");
   f.EscribeCadenaTexto("-> http://www.dte.uma.es");
   f.EscribeCadenaTexto("Last used files:");
   f.EscribeCadenaTexto("-> ");
   f.EscribeCadenaTexto("-> ");
   f.EscribeCadenaTexto("-> ");
   f.EscribeCadenaTexto("-> ");
   f.EscribeCadenaTexto(" Tools layout: Possible values: \"VENTANA\",\"BARRA\",\"OCUTA\" ");
   f.EscribeCadenaTexto("-> VENTANA");
   f.EscribeCadenaTexto(" User Interface Toolkit URL ");
   f.EscribeCadenaTexto("-> http://www.h3d.org");
   f.EscribeCadenaTexto(" Indicates if prefix and sufix must be used with routing fields (ExposedField).");
   f.EscribeCadenaTexto("-> NO");
   f.EscribeCadenaTexto(" Prefix and sufix for the ExposedField fields used when creating routing links.");
   f.EscribeCadenaTexto("-> set_");
   f.EscribeCadenaTexto("-> _changed");
   f.EscribeCadenaTexto(" Contains the words which will be represented as reserved words in the editor");
   f.EscribeCadenaTexto("-> DEF EXTERNPROTO FALSE IS NULL PROTO ROUTE TO TRUE USE fromNode fromField toNode toField ");
   f.EscribeCadenaTexto(" Non nested nodes. DisReal will not change the nesting state of this nodes.");
   f.EscribeCadenaTexto("-> < PythonScript >");
   f.EscribeCadenaTexto(" Type yes to use richtext while editing VRML code.");
   f.EscribeCadenaTexto("-> YES");
   f.EscribeCadenaTexto(" Font used to edit de code.");
   f.EscribeCadenaTexto("-> Arial");
   f.EscribeCadenaTexto(" Informacin para representar el texto en modo <Formato Enrriquecido>.");
   AnsiString tmp = (AnsiString)"-> " + (AnsiString) DATOS_TEXTO_CON_FORMATO ;
   f.EscribeCadenaTexto( tmp.c_str() );
   f.EscribeCadenaTexto(" Type YES to use the autocomplete feature in the code editor.");
   f.EscribeCadenaTexto("-> SI");
   f.EscribeCadenaTexto(" Delay (ms) to wait before the autocomplete feature appears.");
   f.EscribeCadenaTexto("-> 2000");
   f.EscribeCadenaTexto(" Type YES to use the H3D console when running H3D scenes.");
   f.EscribeCadenaTexto("-> YES");
   f.EscribeCadenaTexto(" To know if which is the first execution of DisReal after the setup.");
   f.EscribeCadenaTexto("-> NO");
   f.EscribeCadenaTexto(" Time to wait in order the H3D console can receive all the messages.");
   f.EscribeCadenaTexto("-> 150");

   f.CerrarFichero();
   return true;
}
//------------------------------------------------------------------------------
bool __fastcall Configuracion::GetCadena(char *cad,char *&dato){

    while(!f.Final()){
        f.LeeCadenaTexto(cad);
        // Solo interesa la cadena si comienza por ->
        if((cad[0]=='-') && (cad[1]=='>')){
           int index=2;
           while( (cad[index]==' ') || (cad[index]==(char) 8) )
              index++;
           // Hemos eliminado todos los espacios y tabuladores del principio
           // de cadena.
           dato = & cad[index];  // cad[index] contiene la primera letra vlida de la cadena.
           // Ahora solo falta eliminar los espacios y tabuladores del final de la cadena dato.
           index=0;
           while(dato[index++] !='\0');
           // Estamos al final de la cadena retrocedemos mientras haya espacios o tabuladores.
           if(index > 0)
              index--;
           if(index > 0)
              index--;
           while( (index > 0) && ((dato[index]==' ') || (dato[index]==(char) 8)) )
              index--;
           dato[index+1]='\0';
           return true;
        }
    }
    return false;
}
//------------------------------------------------------------------------------
void __fastcall Configuracion::LosDatosHanCambiado(){
   datosHanCambiado=true;

   if(PalabrasReservadas != NULL){
      // Tambin hay que actualizar la lista de palabras reservadas:
      PalabrasReservadas->Clear();

      int fin=Utilidad.NumPalabras(CONF.PALABRAS_RESERVADAS.c_str());
      for(int c=0;c < fin ; c++ )
          PalabrasReservadas->Append(Utilidad.GetPalabra(CONF.PALABRAS_RESERVADAS,c+1));
   }
   NODOS_SIN_ANIDAMIENTO = " " + NODOS_SIN_ANIDAMIENTO +" ";
}
//------------------------------------------------------------------------------
int __fastcall Configuracion::GetEntero(AnsiString cad){

    cad=cad.Trim();
    int devuelto;

    try{  devuelto = StrToInt(cad); }
    catch(...){
       ShowMessage("An error has been detected in the format of the general configuration file .");
       ShowMessage("Now the application will be closed to repair this file.");
       // Si f est abierto se cerrar en CrearFichConfValDefecto;
       // Creamos el fichero de configuracin con los valores por defecto.
       CrearFichConfValDefecto();
       // Salimos del programa.
       exit(EXIT_FAILURE);
    }
    return devuelto;
}

//---------------------------------------------------------------------------
void __fastcall Configuracion::CargaFormatosTexto(AnsiString f){
   // Ver comentarios en la declaracin de la funcin:
   // Este es el formato genrico de la cadena f:
   // 12 14 colorFondo NO_VISIBLE: ?? color CADENA: ?? color LLAVES_Y_CORCHETES: ?? color CAMPO: ?? color IDENTIFICADOR: ?? color COMENTARIO: ?? color NORMAL: ?? color NODO: ?? color PALABRA_RESERVADA: ?? color GENERAL: ?? color
   bool error=false;
   AnsiString pal1,pal2;
   int palabra=1;

   try{
      Formato_TAM_FUENTE_EDITOR = StrToInt(Utilidad.GetPalabra(f,palabra++));
      Formato_TAM_FUENTE_ESCENA = StrToInt(Utilidad.GetPalabra(f,palabra++));
   }catch(...){
      Formato_TAM_FUENTE_EDITOR = 10;
      Formato_TAM_FUENTE_ESCENA = 8;
   }
   pal1 = Utilidad.GetPalabra(f,palabra++);

   try{
      Formato_COLOR_FONDO = StringToColor( pal1 );
   }catch (...){
       error = true;
   }
   //----------------------------------------------- FORMATO: NO_VISIBLE -------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "NO_VISIBLE:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_NO_VISIBLE_NC,Formato_NO_VISIBLE_color);
      }else
         error=true;
   }
   //----------------------------------------------- FORMATO: CADENA -------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "CADENA:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_CADENA_NC,Formato_CADENA_color);
      }else
         error=true;
   }
   //----------------------------------------------- FORMATO: LLAVES_Y_CORCHETES-------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "LLAVES_Y_CORCHETES:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_LLAVES_Y_CORCHETES_NC,Formato_LLAVES_Y_CORCHETES_color);
      }else
         error=true;
   }
   //----------------------------------------------- FORMATO: CAMPO ------------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "CAMPO:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_CAMPO_NC,Formato_CAMPO_color);
      }else
         error=true;
   }
   //----------------------------------------------- FORMATO: IDENTIFICADOR ------------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "IDENTIFICADOR:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_IDENTIFICADOR_NC,Formato_IDENTIFICADOR_color);
      }else
         error=true;
   }
   //----------------------------------------------- FORMATO: COMENTARIO -------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "COMENTARIO:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_COMENTARIO_NC,Formato_COMENTARIO_color);
      }else
         error=true;
   }
   //----------------------------------------------- FORMATO: NORMAL -----------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "NORMAL:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_NORMAL_NC,Formato_NORMAL_color);
      }else
         error=true;
   }
   //----------------------------------------------- FORMATO: NODO -------------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "NODO:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_NODO_NC,Formato_NODO_color);
      }else
         error=true;
   }
   //----------------------------------------------- FORMATO: PALABRA_RESERVADA -------------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "PALABRA_RESERVADA:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_PALABRA_RESERVADA_NC,Formato_PALABRA_RESERVADA_color);
      }else
         error=true;
   }
   //----------------------------------------------- FORMATO: GENERAL -----------------------
   if(!error){
      pal1 = Utilidad.GetPalabra(f,palabra++);
      if(pal1 == "GENERAL:"){
         pal1 = Utilidad.GetPalabra(f,palabra++);
         pal2 = Utilidad.GetPalabra(f,palabra++);
         error=!LeeValoresFormato(pal1,pal2,Formato_GENERAL_NC,Formato_GENERAL_color);
      }else
         error=true;
   }

   if(error){
      ShowMessage("An error has been detected in the format of the general configuration file .");
      ShowMessage("The default value will be used.");
      // Hacemos una llamada recursiva con los datos por defecto y adems
      // indicamos en el fichero de configuracin general que los datos han
      // cambiado.
      CargaFormatosTexto(DATOS_TEXTO_CON_FORMATO);
      LosDatosHanCambiado();
   }
}
//---------------------------------------------------------------------------
bool __fastcall Configuracion::LeeValoresFormato(AnsiString pal1,AnsiString pal2,DWORD &NC, TColor &color){

   if(2 == pal1.Length() ){
       bool negrita = (pal1[1] == 'N');
       bool cursiva = (pal1[2] == 'C');
       if(negrita && cursiva)
          NC = CFE_ITALIC | CFE_BOLD;
       else if(negrita && !cursiva)
          NC = CFE_BOLD;
       else if(!negrita && cursiva)
          NC = CFE_ITALIC;
       else
          NC = 0;
       // Se pueden producir excepciones al convertir pal2 a un color-> Las capturamos.
       try{
          color = StringToColor( pal2 );
        }catch (...){
          return false;
        }
       return true;
   }else
      return false;
}
//---------------------------------------------------------------------------
AnsiString __fastcall Configuracion::SalvaFormatosTexto(){

   AnsiString cad;

   // Ver comentarios en la declaracin de la funcin:
   // Este es el formato genrico de la cadena f:
   // 12 14 colorFondo NO_VISIBLE: ?? color CADENA: ?? color LLAVES_Y_CORCHETES: ?? color CAMPO: ?? color IDENTIFICADOR: ?? color COMENTARIO: ?? color NORMAL: ?? color NODO: ?? color PALABRA_RESERVADA: ?? color GENERAL: ?? color

   // 12 14 colorFondo NO_VISIBLE: ?? color CADENA: ?? color LLAVES_Y_CORCHETES: ?? color CAMPO: ?? color IDENTIFICADOR: ?? color COMENTARIO: ?? color NORMAL: ?? color NODO: ?? color PALABRA_RESERVADA: ?? color GENERAL: ?? color

   cad =             StrToInt(Formato_TAM_FUENTE_EDITOR);
   cad = cad + " " + StrToInt(Formato_TAM_FUENTE_ESCENA) + " ";

   cad = cad + ColorToString(Formato_COLOR_FONDO);

   cad = cad + " NO_VISIBLE: "         + EscribeValoresFormato(Formato_NO_VISIBLE_NC,         Formato_NO_VISIBLE_color);
   cad = cad + " CADENA: "             + EscribeValoresFormato(Formato_CADENA_NC,             Formato_CADENA_color);
   cad = cad + " LLAVES_Y_CORCHETES: " + EscribeValoresFormato(Formato_LLAVES_Y_CORCHETES_NC, Formato_LLAVES_Y_CORCHETES_color);
   cad = cad + " CAMPO: "              + EscribeValoresFormato(Formato_CAMPO_NC,              Formato_CAMPO_color);
   cad = cad + " IDENTIFICADOR: "      + EscribeValoresFormato(Formato_IDENTIFICADOR_NC,      Formato_IDENTIFICADOR_color);
   cad = cad + " COMENTARIO: "         + EscribeValoresFormato(Formato_COMENTARIO_NC,         Formato_COMENTARIO_color);
   cad = cad + " NORMAL: "             + EscribeValoresFormato(Formato_NORMAL_NC,             Formato_NORMAL_color);
   cad = cad + " NODO: "               + EscribeValoresFormato(Formato_NODO_NC,               Formato_NODO_color);   
   cad = cad + " PALABRA_RESERVADA: "  + EscribeValoresFormato(Formato_PALABRA_RESERVADA_NC,  Formato_PALABRA_RESERVADA_color);
   cad = cad + " GENERAL: "            + EscribeValoresFormato(Formato_GENERAL_NC,            Formato_GENERAL_color);

   return cad;
}
//---------------------------------------------------------------------------
AnsiString __fastcall Configuracion::EscribeValoresFormato(DWORD nc,TColor color){

   char l1 = (nc & CFE_BOLD)   ? 'N' : '-';
   char l2 = (nc & CFE_ITALIC) ? 'C' : '-';
   return ((AnsiString)l1 + (AnsiString) l2 + " "  + ColorToString(color));
}
//---------------------------------------------------------------------------
void __fastcall Configuracion::Restaurar(){
   CrearFichConfValDefecto();
   CargarDatos();
}


