//
//     CLASE   ArrayDinamico 
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Esta es la clase implementa un array dinmico de un tipo que se
       pasa como parmetro usando una plantilla.
*/
//---------------------------------------------------------------------------

#ifndef ArrayDinamico_H
#define ArrayDinamico_H

//---------------------------------------------------------------------------
/* Esta clase implementa un array dinmico de tamao indefinido. As es posible
escribir en cualquier indice sin necesidad de preocuparse de si existe o no.

  El array es un array de elementos de tipo T y no un array de punteros a tipo T.
 Este matiz es importante porque lo ms recomendable es que T sea un tipo simple
 (p.e. char, int, float, bool, o cualquier tipo de puntero). Esto es debido a
 que cada vez que hay que ampliar el array hay que copiar todos los elementos
 del array antiguo al nuevo y se el tipo T es una clase sera ms conveniente
 usar un array de punteros a T que un array de elemtos de tipo T. Pero en el
 caso de tipos simples no hay diferencia significativa entre usar un array de
 punteros a T o de variables T. */

typedef void * AD_Tipo;

class ArrayDinamico{
private:
    // Es el nmero de elementos que actualmente hay en el array.
    int maxIndexUsado;
    // Es el nmero de elementos del array (reservados en memoria).
    int numElementosReservados;
    // Es el array de elementos que crece dinmicamente.
    AD_Tipo *elementos;
    // Es el paso de
    int pasoIncremento;


public:
    // Devuelve el elemento i del array. El ndice puede ser cualquiera no hay que
    // preocuparse del tamao de array.
    // (Si no se ha escrito ningn valor en la casilla que se pide se devolver
    // la variable de tipo T del primer elemento).
    AD_Tipo __fastcall Get(int i);

    // Asigna al elemento guardado en la casilla i el elemento t.
    // Es necesario que sobre el tipo t se puedan hacer asignaciones =.
    // No hay que tener en cuenta el tamao del array, si es necesario se
    // ampliar. Se devolver falso si hay problemas con la reserva de memoria.
    bool __fastcall Set(AD_Tipo t,int i);

    // A veces es necesario aumentar el tamao del array. Esta funcin indica
    // cual es el paso del icremento. El valor por defecto de este paso es una
    // constante (PASO_INCREMENTO) definida en ArrayDinamico_.cpp.
    void __fastcall SetPasoIncremento(int paso);

    // Devuelve el mayor ndice que se ha usado desde la creacin de la clase. Es
    // Es el equivalente al tamao del array (aunque no se puede hablar de tamao
    // como tal). Si no se ha usado ningn elemento del array se devuelve -1.
    int __fastcall MaxIndexUsado();

    // Devuelve el ndice de la primera casilla libre (a NULL) y si todas las
    // casillas estn ocupadas se devuelve (MaxIndexUsado+1). Asi el valor
    // devuelto puede usarse directamente para aadir nuevos valores.
    int __fastcall PrimerIndexLibre();

    // Devuelve el ndice asociado al tipo t.
    // Si no se encuentra t se devuelve -1.
    int __fastcall IndexOf(AD_Tipo t);

    // Borra los datos actuales y hace que el objeto se encuentre como si se acabase
    // de crear.
    void __fastcall CrearNuevoArray();


    // Devuelve el nmero de elementos no nulos que hay entre las casillas 0 y
    // MaxIndexUsado().
    int __fastcall NumElementosNoNulos();

    // --------------------------------- Constructor ---------------------------
    __fastcall ArrayDinamico();

    // --------------------------------- Destructor  ---------------------------
    __fastcall ~ArrayDinamico();
};

#endif
