//
//     CLASE   ArrayDinamico 
//
/* E.T.S. DE INGENIERA DE TELECOMUNICACIN  ~ UNIVERSIDAD DE MLAGA
   PROYECTO FIN DE CARRERA:  ENTORNO DE DESARROLLO PARA EL DISEO DE APLICACIONES E
                                    INTERFACES 3D CON SENSACIN TCTIL
   TUTOR:     Antonio Daz Estrella               ade@dte.uma.es
   ALUMNO:    Eduardo Njera Fernndez            eduardo@najeraf.com
   ALUMNO:    Ernesto Jess de la Rubia Cuestas   ejdlrc@coit.es
   VERSIN:   2.0
   FECHA:     03/05/2006
   DESCRIPCIN: Esta es la clase implementa un array dinmico de un tipo que se
       pasa como parmetro usando una plantilla.
*/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ArrayDinamico_.h"
#include "Utilidad_.h"

// Es el nmero de casillas en que se amplia el array cada vez que sea necesario.
#define PASO_INCREMENTO 10

//---------------------------------------------------------------------------

#pragma package(smart_init)

// --------------------------------- Constructor ---------------------------
__fastcall ArrayDinamico::ArrayDinamico(){
       // Inicialmente debe ser -1 para que la funcin MaxIndexUsado() pueda
       // cumplir las especificaciones.
       maxIndexUsado=-1;
       numElementosReservados=0;
       elementos=NULL;
       pasoIncremento=PASO_INCREMENTO;
}
// --------------------------------- Destructor  ---------------------------
__fastcall ArrayDinamico::~ArrayDinamico(){
       if(elementos != NULL)
           delete elementos;
}

// ------------------------------------------------- Funcin: Get() ---------
// Devuelve el nodo i del array. El ndice puede ser cualquiera no hay que
// preocuparse del tamao de array.
// (Si no se ha escrito ningn valor en la casilla que se pide se devolver
// la variable de tipo T del primer elemento).
AD_Tipo __fastcall ArrayDinamico::Get(const int i)
{
    if(i < numElementosReservados){
       return elementos[i];
    }else
       return NULL;
}

// ------------------------------------------------- Funcin: Set() ---------
// Asigna al elemento guardado en la casilla i el elemento t.
// Es necesario que sobre el tipo t se puedan hacer asignaciones =.
// No hay que tener en cuenta el tamao del array, si es necesario se
// ampliar. Se devolver falso si hay problemas con la reserva de memoria.
bool __fastcall ArrayDinamico::Set(AD_Tipo t, int i){
   if(i < 0)
      return true;
   if(i < numElementosReservados){
       // maxIndexUsado ser el mximo index que se ha usado al asignar un elemento.
       maxIndexUsado= (maxIndexUsado < i) ? i :maxIndexUsado;

       elementos[i]=t;
       return true;
   }else{
      // En este caso es necesario ampliar el array.
      AD_Tipo *tmp;

      try{ tmp= new AD_Tipo[pasoIncremento+numElementosReservados]; }
      catch(...){ Utilidad.FatalErrorFaltaMemoria(); }

      numElementosReservados= pasoIncremento + numElementosReservados;

      // Hacemos la copia de elementos.
      for(int i=0;i <= maxIndexUsado; i++){
         tmp[i]=elementos[i];
      }

      // maxIndexUsado ser el mximo index usado al asignar un elemento.
      maxIndexUsado= (maxIndexUsado < i) ? i : maxIndexUsado;

      AD_Tipo *tmp2;
      tmp2=elementos;
      elementos=tmp;
      if(tmp2 != NULL)
          delete tmp2; // Borramos el array antiguo.
      elementos[i]=t;

      return true;
   }
}

//------------------------------------- Funcin: SetPasoIncremento() -----------
// A veces es necesario aumentar el tamao del array. Esta funcin indica
// cual es el paso del icremento. El valor por defecto de este paso es una
// constante (PASO_INCREMENTO) definida en ArrayDinamico_.cpp.
void __fastcall ArrayDinamico::SetPasoIncremento(int paso){
   if(paso)
      pasoIncremento=paso;
}

//------------------------------------------- Funcin: MaxIndexUsado() ---------
// Devuelve el mayor ndice que se ha usado desde la creacin de la clase. Es
// Es el equivalente al tamao del array (aunque no se puede hablar de tamao
// como tal).
int __fastcall ArrayDinamico::MaxIndexUsado(){
   return maxIndexUsado;
}
//------------------------------------------- Funcin: PrimerIndexLibre() ---------
// Devuelve el ndice de la primera casilla libre (a NULL) y si todas las
// casillas estn ocupadas se devuelve (MaxIndexUsado+1). Asi el valor
// devuelto puede usarse directamente para aadir nuevos valores.
int __fastcall ArrayDinamico::PrimerIndexLibre(){
   int c=0;
   while( (c <= maxIndexUsado) && (elementos[c] != NULL) )
       c++;
   return c;
}

//------------------------------------------- Funcin: PrimerIndexLibre() ---------
// Devuelve el nmero de elementos no nulos que hay entre las casillas 0 y
// MaxIndexUsado().
int __fastcall ArrayDinamico::NumElementosNoNulos(){
   int c=0;
   int cont=0;
   while( c <= maxIndexUsado ){
      if(elementos[c] != NULL)
        cont++;
      c++;
   }
   return cont;
}

// ------------------------------------------------- Funcin: CrearNuevoArray() ---------
// Borra los datos actuales y hace que el objeto se encuentre como si se acabase
// de crear.
void __fastcall ArrayDinamico::CrearNuevoArray(){
       if(elementos!=NULL)
          delete elementos;
       maxIndexUsado=-1;
       numElementosReservados=0;
       elementos=NULL;
}
//------------------------------------------- Funcin: IndexOf() ---------------
// Devuelve el ndice asociado al tipo t.
// Si no se encuentra t se devuelve -1.
int __fastcall ArrayDinamico::IndexOf(AD_Tipo t)
{
   int c=0;
   while(c <= maxIndexUsado)
   {
      if(elementos[c] == t)
         return c;
      c++;
   }
   return -1;
}
